/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.w3c.dom.Document;
import play.libs.F;
import play.libs.Json;
import play.libs.XML;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class WS {
    private static AsyncHttpClient client() {
        return play.api.libs.ws.WS.client();
    }

    public static WSRequestHolder url(String string) {
        return new WSRequestHolder(string);
    }

    public static interface SignatureCalculator {
        public void sign(WSRequest var1);
    }

    public static class Response {
        private com.ning.http.client.Response ahcResponse;

        public Response(com.ning.http.client.Response response) {
            this.ahcResponse = response;
        }

        public int getStatus() {
            return this.ahcResponse.getStatusCode();
        }

        public String getStatusText() {
            return this.ahcResponse.getStatusText();
        }

        public String getHeader(String string) {
            return this.ahcResponse.getHeader(string);
        }

        public String getBody() {
            try {
                String string;
                String string2 = this.ahcResponse.getContentType();
                if (string2 == null) {
                    string2 = "application/octet-stream";
                }
                if ((string = AsyncHttpProviderUtils.parseCharset((String)string2)) != null) {
                    return this.ahcResponse.getResponseBody(string);
                }
                if (string2.startsWith("text/")) {
                    return this.ahcResponse.getResponseBody("ISO-8859-1");
                }
                return this.ahcResponse.getResponseBody("utf-8");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public Document asXml() {
            try {
                return XML.fromInputStream((InputStream)this.ahcResponse.getResponseBodyAsStream(), (String)"utf-8");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public JsonNode asJson() {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (JsonNode)objectMapper.readValue(this.ahcResponse.getResponseBodyAsStream(), JsonNode.class);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public InputStream getBodyAsStream() {
            try {
                return this.ahcResponse.getResponseBodyAsStream();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public byte[] asByteArray() {
            try {
                return this.ahcResponse.getResponseBodyAsBytes();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public URI getUri() {
            try {
                return this.ahcResponse.getUri();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
    }

    public static class WSRequestHolder {
        private final String url;
        private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        private Map<String, Collection<String>> queryParameters = new HashMap<String, Collection<String>>();
        private String username = null;
        private String password = null;
        private Realm.AuthScheme scheme = null;
        private SignatureCalculator calculator = null;
        private int timeout = 0;
        private Boolean followRedirects = null;

        public WSRequestHolder(String string) {
            this.url = string;
        }

        public WSRequestHolder setHeader(String string, String string2) {
            if (this.headers.containsKey(string)) {
                Collection<String> collection = this.headers.get(string);
                collection.add(string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                this.headers.put(string, arrayList);
            }
            return this;
        }

        public WSRequestHolder setQueryParameter(String string, String string2) {
            if (this.queryParameters.containsKey(string)) {
                Collection<String> collection = this.queryParameters.get(string);
                collection.add(string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                this.queryParameters.put(string, arrayList);
            }
            return this;
        }

        public WSRequestHolder setAuth(String string, String string2) {
            this.username = string;
            this.password = string2;
            this.scheme = Realm.AuthScheme.BASIC;
            return this;
        }

        public WSRequestHolder setAuth(String string, String string2, Realm.AuthScheme authScheme) {
            this.username = string;
            this.password = string2;
            this.scheme = authScheme;
            return this;
        }

        public WSRequestHolder sign(SignatureCalculator signatureCalculator) {
            this.calculator = signatureCalculator;
            return this;
        }

        public WSRequestHolder setFollowRedirects(Boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        public WSRequestHolder setTimeout(int n) {
            this.timeout = n;
            return this;
        }

        public WSRequestHolder setContentType(String string) {
            return this.setHeader("Content-Type", string);
        }

        public F.Promise<Response> get() {
            return this.execute("GET");
        }

        public F.Promise<Response> post(String string) {
            return this.executeString("POST", string);
        }

        public F.Promise<Response> put(String string) {
            return this.executeString("PUT", string);
        }

        public F.Promise<Response> post(JsonNode jsonNode) {
            return this.executeJson("POST", jsonNode);
        }

        public F.Promise<Response> put(JsonNode jsonNode) {
            return this.executeJson("PUT", jsonNode);
        }

        public F.Promise<Response> post(InputStream inputStream) {
            return this.executeIS("POST", inputStream);
        }

        public F.Promise<Response> put(InputStream inputStream) {
            return this.executeIS("PUT", inputStream);
        }

        public F.Promise<Response> post(File file) {
            return this.executeFile("POST", file);
        }

        public F.Promise<Response> put(File file) {
            return this.executeFile("PUT", file);
        }

        public F.Promise<Response> delete() {
            return this.execute("DELETE");
        }

        public F.Promise<Response> head() {
            return this.execute("HEAD");
        }

        public F.Promise<Response> options() {
            return this.execute("OPTIONS");
        }

        public F.Promise<Response> execute(String string) {
            WSRequest wSRequest = (WSRequest)new WSRequest(string).setUrl(this.url).setHeaders((Map)this.headers).setQueryParameters(new FluentStringsMap(this.queryParameters));
            return this.execute(wSRequest);
        }

        private F.Promise<Response> executeString(String string, String string2) {
            String string3;
            FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap(this.headers);
            String string4 = fluentCaseInsensitiveStringsMap.getFirstValue("Content-Type");
            if (string4 == null) {
                string4 = "text/plain";
            }
            if ((string3 = AsyncHttpProviderUtils.parseCharset((String)string4)) == null) {
                string3 = "utf-8";
                fluentCaseInsensitiveStringsMap.replace("Content-Type", new String[]{string4 + "; charset=utf-8"});
            }
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)new WSRequest(string).setBody(string2)).setUrl(this.url).setHeaders(fluentCaseInsensitiveStringsMap).setQueryParameters(new FluentStringsMap(this.queryParameters))).setBodyEncoding(string3);
            return this.execute(wSRequest);
        }

        private F.Promise<Response> executeJson(String string, JsonNode jsonNode) {
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)new WSRequest(string).setBody(Json.stringify((JsonNode)jsonNode))).setUrl(this.url).setHeaders((Map)this.headers).setHeader("Content-Type", "application/json; charset=utf-8").setQueryParameters(new FluentStringsMap(this.queryParameters))).setBodyEncoding("utf-8");
            return this.execute(wSRequest);
        }

        private F.Promise<Response> executeIS(String string, InputStream inputStream) {
            WSRequest wSRequest = (WSRequest)((WSRequest)new WSRequest(string).setBody(inputStream)).setUrl(this.url).setHeaders((Map)this.headers).setQueryParameters(new FluentStringsMap(this.queryParameters));
            return this.execute(wSRequest);
        }

        private F.Promise<Response> executeFile(String string, File file) {
            WSRequest wSRequest = (WSRequest)((WSRequest)new WSRequest(string).setBody(file)).setUrl(this.url).setHeaders((Map)this.headers).setQueryParameters(new FluentStringsMap(this.queryParameters));
            return this.execute(wSRequest);
        }

        private F.Promise<Response> execute(WSRequest wSRequest) {
            if (this.timeout > 0) {
                PerRequestConfig perRequestConfig = new PerRequestConfig();
                perRequestConfig.setRequestTimeoutInMs(this.timeout);
                wSRequest.setPerRequestConfig(perRequestConfig);
            }
            if (this.followRedirects != null) {
                wSRequest.setFollowRedirects(this.followRedirects);
            }
            if (this.username != null && this.password != null && this.scheme != null) {
                wSRequest.auth(this.username, this.password, this.scheme);
            }
            if (this.calculator != null) {
                this.calculator.sign(wSRequest);
            }
            return wSRequest.execute();
        }
    }

    public static class WSRequest
    extends RequestBuilderBase<WSRequest> {
        private FluentCaseInsensitiveStringsMap headers = new FluentCaseInsensitiveStringsMap();
        private String method;
        private String url;

        public WSRequest(String string) {
            super(WSRequest.class, string, false);
            this.method = string;
        }

        private WSRequest auth(String string, String string2, Realm.AuthScheme authScheme) {
            this.setRealm(new Realm.RealmBuilder().setScheme(authScheme).setPrincipal(string).setPassword(string2).setUsePreemptiveAuth(true).build());
            return this;
        }

        public WSRequest setHeader(String string, String string2) {
            this.headers.replace(string, new String[]{string2});
            return (WSRequest)super.setHeader(string, string2);
        }

        public WSRequest addHeader(String string, String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.headers.add(string, new String[]{string2});
            return (WSRequest)super.addHeader(string, string2);
        }

        public WSRequest setHeaders(FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap) {
            this.headers = this.headers == null ? new FluentCaseInsensitiveStringsMap() : this.headers;
            return (WSRequest)super.setHeaders(fluentCaseInsensitiveStringsMap);
        }

        public WSRequest setHeaders(Map<String, Collection<String>> map) {
            this.headers = this.headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(this.headers);
            return (WSRequest)super.setHeaders(map);
        }

        public Map<String, List<String>> getAllHeaders() {
            return this.headers;
        }

        public List<String> getHeader(String string) {
            List list = this.headers.get((Object)string);
            if (list == null) {
                return new ArrayList<String>();
            }
            return list;
        }

        public String getMethod() {
            return this.method;
        }

        public WSRequest setUrl(String string) {
            this.url = string;
            return (WSRequest)super.setUrl(string);
        }

        public String getUrl() {
            return this.url;
        }

        public F.Promise<Response> execute() {
            final Promise promise = Promise$.MODULE$.apply();
            try {
                WS.client().executeRequest((Request)this.request, (AsyncHandler)new AsyncCompletionHandler<com.ning.http.client.Response>(){

                    public com.ning.http.client.Response onCompleted(com.ning.http.client.Response response) {
                        com.ning.http.client.Response response2 = response;
                        promise.success((Object)new Response(response2));
                        return response;
                    }

                    public void onThrowable(Throwable throwable) {
                        promise.failure(throwable);
                    }
                });
            }
            catch (IOException iOException) {
                promise.failure((Throwable)iOException);
            }
            return new F.Promise(promise.future());
        }
    }
}

