/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.xid;

import javax.transaction.xa.Xid;
import tyrex.services.UUID;
import tyrex.tm.xid.BaseXid;
import tyrex.tm.xid.GlobalXid;

public final class BranchXid
extends BaseXid {
    private final byte[] _global;
    private final byte[] _branch;

    BranchXid(byte[] byArray, byte[] byArray2) {
        StringBuffer stringBuffer = new StringBuffer(14 + (byArray.length + byArray2.length) * 2);
        stringBuffer.append(GlobalXid.XID_PREFIX_ARRAY);
        int n = byArray.length;
        while (n-- > 0) {
            stringBuffer.append(BaseXid.HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(BaseXid.HEX_DIGITS[byArray[n] & 0xF]);
        }
        stringBuffer.append('-');
        int n2 = byArray2.length;
        while (n2-- > 0) {
            stringBuffer.append(BaseXid.HEX_DIGITS[(byArray2[n2] & 0xF0) >> 4]);
            stringBuffer.append(BaseXid.HEX_DIGITS[byArray2[n2] & 0xF]);
        }
        this._global = byArray;
        this._branch = byArray2;
        this._string = stringBuffer.toString();
    }

    BranchXid(String string, byte[] byArray, byte[] byArray2) {
        this._string = string;
        this._global = byArray;
        this._branch = byArray2;
    }

    public int getFormatId() {
        return 14745550;
    }

    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    public byte[] getBranchQualifier() {
        return this._branch;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BaseXid) {
            return this._string.equals(((BaseXid)object)._string);
        }
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            if (xid.getFormatId() != 14745550) {
                return false;
            }
            byte[] byArray = xid.getGlobalTransactionId();
            if (byArray == null || byArray.length != this._global.length) {
                return false;
            }
            int n = byArray.length;
            while (n-- > 0) {
                if (byArray[n] == this._global[n]) continue;
                return false;
            }
            byArray = xid.getBranchQualifier();
            if (byArray == null || byArray.length != this._branch.length) {
                return false;
            }
            int n2 = byArray.length;
            while (n2-- > 0) {
                if (byArray[n2] == this._branch[n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Xid newBranch() {
        return new BranchXid(this._global, UUID.createBinary());
    }
}

