/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import tyrex.tm.impl.XAResourceHelper;

public final class OracleXAResourceHelper
extends XAResourceHelper {
    public static final String XID_CLASS_NAME = "oracle.jdbc.xa.OracleXid";
    private Constructor _xidConstructor;
    private boolean _failedXidConstructor;
    private Method _errorCodeMethod;
    private boolean _failedErrorCodeMethod;

    public Xid getXid(XAResource xAResource, Xid xid) throws XAException {
        if (!this.loadOracleXidClass(xAResource)) {
            if (null == xid.getBranchQualifier() || 0 == xid.getBranchQualifier().length) {
                return new OracleXidWrapper(xid);
            }
            return xid;
        }
        try {
            Object[] objectArray = new Object[]{new Integer(xid.getFormatId()), xid.getGlobalTransactionId(), null == xid.getBranchQualifier() || 0 == xid.getBranchQualifier().length ? (Object)xid.getGlobalTransactionId() : (Object)xid.getBranchQualifier()};
            return (Xid)this._xidConstructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof XAException) {
                throw (XAException)throwable;
            }
            return xid;
        }
    }

    public boolean useDifferentBranchesForSharedResources() {
        return true;
    }

    public boolean treatDifferentBranchesForSharedResourcesAsShared() {
        return false;
    }

    public String getXAErrorString(XAException xAException) {
        Class<?> clazz = xAException.getClass();
        if (clazz.getName().equals("oracle.jdbc.xa.OracleXAException")) {
            try {
                if (this.loadOracleXAExceptionErrorMethod(clazz)) {
                    return " oracle error code: " + this._errorCodeMethod.invoke((Object)xAException, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    private synchronized boolean loadOracleXAExceptionErrorMethod(Class clazz) {
        Object var2_2 = null;
        if (null == this._errorCodeMethod && !this._failedErrorCodeMethod) {
            try {
                this._errorCodeMethod = clazz.getDeclaredMethod("getOracleError", null);
                return true;
            }
            catch (Throwable throwable) {
                this._failedErrorCodeMethod = true;
                return false;
            }
        }
        return null != this._errorCodeMethod;
    }

    private synchronized boolean loadOracleXidClass(XAResource xAResource) {
        Object var2_2 = null;
        if (null == this._xidConstructor && !this._failedXidConstructor) {
            try {
                Class<?> clazz = xAResource.getClass().getClassLoader().loadClass(XID_CLASS_NAME);
                Class<?> clazz2 = Class.forName("[B");
                this._xidConstructor = clazz.getDeclaredConstructor(Integer.TYPE, clazz2, clazz2);
                return true;
            }
            catch (Throwable throwable) {
                this._failedXidConstructor = true;
                return false;
            }
        }
        return null != this._xidConstructor;
    }

    private static class OracleXidWrapper
    implements Xid {
        private final Xid _xid;

        private OracleXidWrapper(Xid xid) {
            this._xid = xid;
        }

        public byte[] getBranchQualifier() {
            return this.getGlobalTransactionId();
        }

        public int getFormatId() {
            return this._xid.getFormatId();
        }

        public byte[] getGlobalTransactionId() {
            return this._xid.getGlobalTransactionId();
        }
    }
}

