/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scalax.io.CloseAction$;
import scalax.io.CloseAction$Noop$;
import scalax.io.Codec;
import scalax.io.Codec$;
import scalax.io.Input;
import scalax.io.InputResource;
import scalax.io.LongTraversable;
import scalax.io.OpenOption;
import scalax.io.OpenedResource;
import scalax.io.Output;
import scalax.io.OutputConverter;
import scalax.io.OutputConverter$;
import scalax.io.OutputConverter$ByteArrayConverter$;
import scalax.io.OutputConverter$TraversableByteConverter$;
import scalax.io.OutputConverter$TraversableIntAsByteConverter$;
import scalax.io.OutputResource;
import scalax.io.Overwrite;
import scalax.io.OverwriteAll$;
import scalax.io.OverwriteSome;
import scalax.io.Resource$;
import scalax.io.Seekable;
import scalax.io.Seekable$;
import scalax.io.SeekableByteChannel;
import scalax.io.TraversableOnceOps$;
import scalax.io.managed.ByteChannelResource;
import scalax.io.managed.SeekableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource$;
import scalax.io.processing.SeekableProcessor;

public abstract class Seekable$class {
    public static Object readWriteChannel(Seekable $this, Function1 f) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        try {
            return f.apply((Object)resource.get());
        }
        finally {
            resource.close();
        }
    }

    public static Object appendChannel(Seekable $this, Function1 f) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(true);
        try {
            return f.apply((Object)resource.get());
        }
        finally {
            resource.close();
        }
    }

    public static SeekableProcessor seekableProcessor(Seekable $this) {
        return new SeekableProcessor((Function0<OpenedResource<SeekableByteChannel>>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;

            public final OpenedResource<SeekableByteChannel> apply() {
                return this.$outer.underlyingChannel(false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.context());
    }

    public static void patch(Seekable $this, long position2, String string2, Overwrite overwrite, Codec codec) {
        Overwrite overwrite2;
        block9: {
            block6: {
                long l;
                block8: {
                    long r;
                    OverwriteSome x2;
                    block7: {
                        block5: {
                            Predef$.MODULE$.require(position2 >= 0L, (Function0)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "The patch starting position must be greater than or equal 0";
                                }
                            });
                            if (!$this.size().forall((Function1)new Serializable($this, position2){
                                public static final long serialVersionUID = 0L;
                                private final long position$4;

                                public final boolean apply(long x$1) {
                                    return this.apply$mcZJ$sp(x$1);
                                }

                                public boolean apply$mcZJ$sp(long v1) {
                                    return this.position$4 >= v1;
                                }
                                {
                                    this.position$4 = position$4;
                                }
                            }) && !codec.hasConstantSize()) break block5;
                            $this.patch(position2, Predef$.MODULE$.wrapString(string2), overwrite, OutputConverter$.MODULE$.charsToOutputFunction(codec));
                            break block6;
                        }
                        overwrite2 = overwrite;
                        OverwriteAll$ overwriteAll$ = OverwriteAll$.MODULE$;
                        Overwrite overwrite3 = overwrite2;
                        if (overwriteAll$ != null ? !overwriteAll$.equals(overwrite3) : overwrite3 != null) break block7;
                        Overwrite x3 = overwrite2;
                        l = Long.MIN_VALUE;
                        break block8;
                    }
                    if (!(overwrite2 instanceof OverwriteSome) || (x2 = (OverwriteSome)overwrite2) == null) break block9;
                    l = r = x2.replacementLength();
                }
                long replaced = l;
                byte[] bytes2 = string2.getBytes(codec.name());
                long posInBytes = Seekable$class.charCountToByteCount($this, 0L, position2, codec);
                if (overwrite.exists((Function1<Object, Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$2) {
                        return this.apply$mcZJ$sp(x$2);
                    }

                    public boolean apply$mcZJ$sp(long v1) {
                        return v1 < 0L;
                    }
                })) {
                    $this.insert(posInBytes, bytes2, OutputConverter$ByteArrayConverter$.MODULE$);
                } else {
                    Overwrite overwrite4 = overwrite;
                    OverwriteAll$ overwriteAll$ = OverwriteAll$.MODULE$;
                    long replacedInBytes = Seekable$class.charCountToByteCount($this, position2, position2 + (!(overwrite4 != null ? !overwrite4.equals(overwriteAll$) : overwriteAll$ != null) ? (long)new StringOps(Predef$.MODULE$.augmentString(string2)).size() : replaced), codec);
                    $this.patch(posInBytes, bytes2, (Overwrite)new OverwriteSome(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(replaced)).max((Object)BoxesRunTime.boxToLong((long)replacedInBytes)))), OutputConverter$ByteArrayConverter$.MODULE$);
                }
            }
            return;
        }
        throw new MatchError((Object)overwrite2);
    }

    public static void patch(Seekable $this, long position2, Object data, Overwrite overwrite, OutputConverter converter) {
        boolean insertData;
        Predef$.MODULE$.require(position2 >= 0L, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The patch starting position must be greater than or equal 0";
            }
        });
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        long actualPosition = (long)converter.sizeInBytes() * position2;
        Predef$.MODULE$.require(actualPosition >= 0L, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The patch starting position must be greater than or equal 0";
            }
        });
        long replaced = overwrite.getOrElse((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Long.MIN_VALUE;
            }
        });
        boolean appendData = $this.size().forall((Function1)new Serializable($this, actualPosition){
            public static final long serialVersionUID = 0L;
            private final long actualPosition$1;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return this.actualPosition$1 >= v1;
            }
            {
                this.actualPosition$1 = actualPosition$1;
            }
        });
        boolean bl = insertData = replaced <= 0L && replaced != Long.MIN_VALUE;
        if (appendData) {
            $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else if (insertData) {
            $this.insert(actualPosition, bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else {
            Seekable$class.overwriteFileData($this, actualPosition, bytes2, replaced);
        }
    }

    public static Codec patch$default$4(Seekable $this, long position2, String string2, Overwrite overwrite) {
        return Codec$.MODULE$.default();
    }

    public static void patchIntsAsBytes(Seekable $this, long position2, Overwrite overwrite, Seq data) {
        $this.patch(position2, data, overwrite, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void insert(Seekable $this, long position2, String string2, Codec codec) {
        $this.insert(position2, codec.encode(string2), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    public static Object insert(Seekable $this, long position2, Object data, OutputConverter converter) {
        Object object;
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        if (position2 > -1L && $this.size().forall((Function1)new Serializable($this, position2){
            public static final long serialVersionUID = 0L;
            private final long position$5;

            public final boolean apply(long x$4) {
                return this.apply$mcZJ$sp(x$4);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return v1 <= this.position$5;
            }
            {
                this.position$5 = position$5;
            }
        })) {
            $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
            object = BoxedUnit.UNIT;
        } else {
            object = bytes2.hasDefiniteSize() && bytes2.size() <= 0xA00000 ? BoxesRunTime.boxToInteger((int)Seekable$class.insertDataInMemory($this, BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(position2)).max((Object)BoxesRunTime.boxToLong((long)0L))), bytes2)) : Seekable$class.insertDataTmpFile($this, BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(position2)).max((Object)BoxesRunTime.boxToLong((long)0L))), bytes2);
        }
        return object;
    }

    public static Codec insert$default$3(Seekable $this, long position2, String string2) {
        return Codec$.MODULE$.default();
    }

    public static Object insertIntsAsBytes(Seekable $this, long position2, Seq data) {
        return $this.insert(position2, data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, Object data, OutputConverter converter) {
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        $this.appendChannel(new Serializable($this, bytes2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final TraversableOnce bytes$4;

            public final Tuple2<Object, Object> apply(SeekableByteChannel x$5) {
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, x$5, this.bytes$4, -1L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bytes$4 = bytes$4;
            }
        });
    }

    public static void appendIntsAsBytes(Seekable $this, Seq data) {
        $this.append(data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, String string2, Codec codec) {
        $this.append(codec.encode(string2), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    public static Codec append$default$2(Seekable $this, String string2) {
        return Codec$.MODULE$.default();
    }

    public static void appendStrings(Seekable $this, Traversable strings, String separator, Codec codec) {
        byte[] sepBytes = codec.encode(separator);
        $this.appendChannel(new Serializable($this, sepBytes, strings, codec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            public final byte[] sepBytes$1;
            private final Traversable strings$1;
            public final Codec codec$2;

            public final boolean apply(SeekableByteChannel channel) {
                return BoxesRunTime.unboxToBoolean((Object)this.strings$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Seekable$.anonfun.appendStrings.1 $outer;
                    private final SeekableByteChannel channel$2;

                    public final boolean apply(boolean addSep, String string2) {
                        Object object = addSep ? Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.scalax$io$Seekable$$anonfun$$$outer(), this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.sepBytes$1), Long.MAX_VALUE) : BoxedUnit.UNIT;
                        Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.scalax$io$Seekable$$anonfun$$$outer(), this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.codec$2.encode(string2)), Long.MAX_VALUE);
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.channel$2 = channel$2;
                    }
                }));
            }

            public /* synthetic */ Seekable scalax$io$Seekable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sepBytes$1 = sepBytes$1;
                this.strings$1 = strings$1;
                this.codec$2 = codec$2;
            }
        });
    }

    public static String appendStrings$default$2(Seekable $this) {
        return "";
    }

    public static Codec appendStrings$default$3(Seekable $this, Traversable strings, String separator) {
        return Codec$.MODULE$.default();
    }

    public static void truncate(Seekable $this, long position2) {
        $this.readWriteChannel(new Serializable($this, position2){
            public static final long serialVersionUID = 0L;
            private final long position$6;

            public final SeekableByteChannel apply(SeekableByteChannel x$6) {
                return x$6.truncate(this.position$6);
            }
            {
                this.position$6 = position$6;
            }
        });
    }

    public static void truncateString(Seekable $this, long position2, Codec codec) {
        long posInBytes = Seekable$class.charCountToByteCount($this, 0L, position2, codec);
        $this.appendChannel(new Serializable($this, posInBytes){
            public static final long serialVersionUID = 0L;
            private final long posInBytes$1;

            public final SeekableByteChannel apply(SeekableByteChannel x$7) {
                return x$7.truncate(this.posInBytes$1);
            }
            {
                this.posInBytes$1 = posInBytes$1;
            }
        });
    }

    public static Codec truncateString$default$2(Seekable $this, long position2) {
        return Codec$.MODULE$.default();
    }

    private static int insertDataInMemory(Seekable $this, long position2, TraversableOnce bytes2) {
        return BoxesRunTime.unboxToInt($this.readWriteChannel(new Serializable($this, position2, bytes2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$1;
            private final TraversableOnce bytes$1;

            public final int apply(SeekableByteChannel channel) {
                channel.position(this.position$1);
                int dataToMove = (int)BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(channel.size() - this.position$1)).min((Object)BoxesRunTime.boxToLong((long)0xA00000L)));
                Tuple2 buffers = new Tuple2((Object)ByteBuffer.allocateDirect(dataToMove), (Object)ByteBuffer.allocateDirect(dataToMove));
                channel.read((ByteBuffer)buffers._1());
                ((Buffer)buffers._1()).flip();
                buffers = buffers.swap();
                channel.position(this.position$1);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$1, this.bytes$1.size());
                while (channel.position() < channel.size() - (long)((Buffer)buffers._2()).remaining()) {
                    channel.read((ByteBuffer)buffers._1());
                    ((Buffer)buffers._1()).flip();
                    channel.write((ByteBuffer)buffers._2(), channel.position() - (long)this.bytes$1.size());
                    buffers = buffers.swap();
                }
                return channel.write((ByteBuffer)buffers._2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$1 = position$1;
                this.bytes$1 = bytes$1;
            }
        }));
    }

    public static Input tempFile(Seekable $this) {
        File file = File.createTempFile("SeekableCache", "tmp");
        return Resource$.MODULE$.fromFile(file);
    }

    private static Tuple2 insertDataTmpFile(Seekable $this, long position2, TraversableOnce insertBytes) {
        Input tmp = $this.tempFile();
        ((Output)((Object)tmp)).write($this.bytes().ldrop(position2), OutputConverter$TraversableByteConverter$.MODULE$);
        return (Tuple2)$this.readWriteChannel(new Serializable($this, position2, insertBytes, tmp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$2;
            private final TraversableOnce insertBytes$1;
            private final Input tmp$1;

            public final Tuple2<Object, Object> apply(SeekableByteChannel channel) {
                channel.position(this.position$2);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.insertBytes$1, -1L);
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.tmp$1.bytes(), BoxesRunTime.unboxToLong((Object)this.tmp$1.size().get()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$2 = position$2;
                this.insertBytes$1 = insertBytes$1;
                this.tmp$1 = tmp$1;
            }
        });
    }

    private static Object overwriteFileData(Seekable $this, long position2, TraversableOnce bytes2, long replaced) {
        return $this.readWriteChannel(new Serializable($this, position2, bytes2, replaced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$3;
            private final TraversableOnce bytes$3;
            private final long replaced$1;

            public final Object apply(SeekableByteChannel channel) {
                channel.position(this.position$3);
                Tuple2 tuple2 = Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$3, this.replaced$1);
                if (tuple2 != null) {
                    Object object;
                    Tuple2.mcJZ.sp sp2;
                    long wrote = tuple2._1$mcJ$sp();
                    boolean earlyTermination = tuple2._2$mcZ$sp();
                    Tuple2.mcJZ.sp sp3 = sp2 = new Tuple2.mcJZ.sp(wrote, earlyTermination);
                    long wrote2 = sp3._1$mcJ$sp();
                    boolean earlyTermination2 = sp3._2$mcZ$sp();
                    if (this.replaced$1 > channel.size() || this.position$3 + this.replaced$1 > channel.size()) {
                        object = channel.truncate(channel.position());
                    } else if (this.replaced$1 > wrote2) {
                        long length = channel.size() - this.position$3 - this.replaced$1;
                        long srcIndex = this.position$3 + this.replaced$1;
                        long destIndex = this.position$3 + wrote2;
                        Seekable$class.scalax$io$Seekable$$copySlice(this.$outer, channel, srcIndex, destIndex, (int)length);
                        object = channel.truncate(destIndex + length);
                    } else if (earlyTermination2) {
                        Object object2;
                        long adjustedPosition = this.position$3 + this.replaced$1;
                        TraversableOnce traversableOnce = this.bytes$3;
                        if (traversableOnce instanceof LongTraversable) {
                            LongTraversable x2 = (LongTraversable)traversableOnce;
                            object2 = this.$outer.insert(adjustedPosition, x2.ldrop(wrote2), OutputConverter$TraversableByteConverter$.MODULE$);
                        } else if (traversableOnce instanceof Traversable) {
                            Traversable x3 = (Traversable)traversableOnce;
                            object2 = this.$outer.insert(adjustedPosition, x3.drop((int)wrote2), OutputConverter$TraversableByteConverter$.MODULE$);
                        } else if (traversableOnce instanceof Iterator) {
                            Iterator x4 = (Iterator)traversableOnce;
                            object2 = this.$outer.insert(adjustedPosition, this.bytes$3, OutputConverter$TraversableByteConverter$.MODULE$);
                        } else {
                            object2 = this.$outer.insert(adjustedPosition, TraversableOnceOps$.MODULE$.drop(this.bytes$3, (int)wrote2), OutputConverter$TraversableByteConverter$.MODULE$);
                        }
                        object = object2;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$3 = position$3;
                this.bytes$3 = bytes$3;
                this.replaced$1 = replaced$1;
            }
        });
    }

    public static void scalax$io$Seekable$$copySlice(Seekable $this, SeekableByteChannel channel, long srcIndex, long destIndex, int length) {
        ByteBuffer buf = $this.context().createNioBuffer((Option<Object>)None$.MODULE$, (Option<Channel>)new Some((Object)channel), false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), length).by(buf.capacity()).foreach$mVc$sp((Function1)new Serializable($this, channel, srcIndex, destIndex, length, buf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final SeekableByteChannel channel$1;
            private final long srcIndex$1;
            private final long destIndex$1;
            private final int length$2;
            private final ByteBuffer buf$1;

            public final void apply(int done) {
                this.apply$mcVI$sp(done);
            }

            public void apply$mcVI$sp(int v1) {
                Seekable$class.write$1(this.$outer, v1, this.channel$1, this.srcIndex$1, this.destIndex$1, this.length$2, this.buf$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.channel$1 = channel$1;
                this.srcIndex$1 = srcIndex$1;
                this.destIndex$1 = destIndex$1;
                this.length$2 = length$2;
                this.buf$1 = buf$1;
            }
        });
    }

    public static Tuple2 scalax$io$Seekable$$writeTo(Seekable $this, WritableByteChannel c, TraversableOnce bytes2, long length) {
        Tuple2 tuple2;
        TraversableOnce traversableOnce = bytes2;
        if (traversableOnce instanceof WrappedArray) {
            WrappedArray x2 = (WrappedArray)traversableOnce;
            tuple2 = Seekable$class.writeArray$1($this, (byte[])x2.array(), c, bytes2, length);
        } else if (traversableOnce instanceof ArrayOps) {
            ArrayOps x3 = (ArrayOps)traversableOnce;
            tuple2 = Seekable$class.writeArray$1($this, (byte[])x3.toArray(ClassTag$.MODULE$.Byte()), c, bytes2, length);
        } else {
            ByteBuffer buf = $this.context().createNioBuffer((Option<Object>)(length < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)length))), (Option<Channel>)new Some((Object)c), false);
            BooleanRef earlyTermination = new BooleanRef(false);
            tuple2 = new Tuple2.mcJZ.sp(Seekable$class.write$2($this, 0L, bytes2, 0L, c, length, buf, earlyTermination), earlyTermination.elem);
        }
        return tuple2;
    }

    public static OutputResource underlyingOutput(Seekable $this) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        return new WritableByteChannelResource<Object>((Function0<Object>)new Serializable($this, resource){
            public static final long serialVersionUID = 0L;
            private final OpenedResource resource$2;

            public final SeekableByteChannel apply() {
                return (SeekableByteChannel)this.resource$2.get();
            }
            {
                this.resource$2 = resource$2;
            }
        }, resource.context(), WritableByteChannelResource$.MODULE$.$lessinit$greater$default$3());
    }

    public static InputResource toByteChannelResource(Seekable $this) {
        return new ByteChannelResource<Object>((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;

            public final ByteChannel apply() {
                return Seekable$class.opened$1(this.$outer);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.context(), CloseAction$Noop$.MODULE$, (Function0<Option<Object>>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
    }

    public static LongTraversable chars(Seekable $this, Codec codec) {
        return $this.toByteChannelResource().chars(codec);
    }

    public static LongTraversable bytesAsInts(Seekable $this) {
        return $this.toByteChannelResource().bytesAsInts();
    }

    public static LongTraversable bytes(Seekable $this) {
        return $this.toByteChannelResource().bytes();
    }

    public static LongTraversable blocks(Seekable $this, Option blockSize) {
        return $this.toByteChannelResource().blocks(blockSize);
    }

    public static Option blocks$default$1(Seekable $this) {
        return None$.MODULE$;
    }

    private static long charCountToByteCount(Seekable $this, long start, long end2, Codec codec) {
        CharsetEncoder encoder2 = codec.encoder();
        CharBuffer charBuffer = CharBuffer.allocate(1);
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        try {
            LongTraversable<Object> chars2 = new SeekableByteChannelResource(new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final SeekableByteChannel apply(Seq<OpenOption> x$10) {
                    return (SeekableByteChannel)this.resource$1.get();
                }
                {
                    this.resource$1 = resource$1;
                }
            }, resource.context(), CloseAction$.MODULE$.apply((Function1)new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final void apply(Object x$11) {
                    this.resource$1.close();
                }
                {
                    this.resource$1 = resource$1;
                }
            }), (Function0<Option<Object>>)new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final Some<Object> apply() {
                    return new Some((Object)BoxesRunTime.boxToLong((long)((SeekableByteChannel)this.resource$1.get()).size()));
                }
                {
                    this.resource$1 = resource$1;
                }
            }, (Option<Seq<OpenOption>>)None$.MODULE$).chars(codec);
            LongTraversable segment = (LongTraversable)chars2.lslice(start, end2);
            long l = 0L;
            return BoxesRunTime.unboxToLong((Object)segment.$div$colon(BoxesRunTime.boxToLong((long)l), (Function2)new Serializable($this, codec, encoder2, charBuffer){
                public static final long serialVersionUID = 0L;
                private final Codec codec$1;
                private final CharsetEncoder encoder$1;
                private final CharBuffer charBuffer$1;

                public final long apply(long replacedInBytes, char nextChar) {
                    ((Buffer)this.charBuffer$1).clear();
                    this.charBuffer$1.put(nextChar);
                    ((Buffer)this.charBuffer$1).flip();
                    ByteBuffer encoded = this.encoder$1.encode(this.charBuffer$1);
                    int size2 = Predef$.MODULE$.byteArrayOps(((Object)BoxesRunTime.boxToCharacter((char)nextChar)).toString().getBytes(this.codec$1.name())).size();
                    return replacedInBytes + (long)encoded.limit();
                }
                {
                    this.codec$1 = codec$1;
                    this.encoder$1 = encoder$1;
                    this.charBuffer$1 = charBuffer$1;
                }
            }));
        }
        finally {
            resource.close();
        }
    }

    public static final void write$1(Seekable $this, int done, SeekableByteChannel channel$1, long srcIndex$1, long destIndex$1, int length$2, ByteBuffer buf$1) {
        Object object = length$2 < done + buf$1.capacity() ? ((Buffer)buf$1).limit(length$2 - done) : BoxedUnit.UNIT;
        ((Buffer)buf$1).clear();
        int read2 = channel$1.read(buf$1, srcIndex$1 + (long)done);
        ((Buffer)buf$1).flip();
        int written = channel$1.write(buf$1, destIndex$1 + (long)done);
    }

    private static final Tuple2 writeArray$1(Seekable $this, byte[] array, WritableByteChannel c$1, TraversableOnce bytes$2, long length$1) {
        long count2 = length$1 < 0L ? (long)bytes$2.size() : BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(length$1)).min((Object)BoxesRunTime.boxToLong((long)bytes$2.size())));
        int wrote = c$1.write(ByteBuffer.wrap(array, 0, (int)count2));
        boolean isWriteAll = length$1 > 0L;
        return new Tuple2.mcJZ.sp((long)wrote, isWriteAll && length$1 < (long)bytes$2.size());
    }

    private static final long write$2(Seekable $this, long written, TraversableOnce data, long acc, WritableByteChannel c$1, long length$1, ByteBuffer buf$2, BooleanRef earlyTermination$1) {
        Tuple2 tuple2;
        while (true) {
            Tuple2 tuple22;
            boolean bl;
            long l;
            if (-1L == (l = length$1)) {
                long x2 = l;
                bl = true;
            } else if (Long.MIN_VALUE == l) {
                long x3 = l;
                bl = true;
            } else {
                bl = false;
            }
            int n = bl ? buf$2.capacity() : (int)BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(length$1 - written)).min((Object)BoxesRunTime.boxToLong((long)buf$2.capacity())));
            int numBytes = n;
            tuple2 = TraversableOnceOps$.MODULE$.splitAt(data, numBytes);
            if (tuple2 == null) break;
            TraversableOnce toWrite = (TraversableOnce)tuple2._1();
            TraversableOnce remaining = (TraversableOnce)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)toWrite, (Object)remaining);
            TraversableOnce toWrite2 = (TraversableOnce)tuple23._1();
            TraversableOnce remaining2 = (TraversableOnce)tuple23._2();
            if (numBytes <= 0 && !remaining2.nonEmpty()) {
                Predef$.MODULE$.assert(numBytes > 0 || remaining2.nonEmpty());
            }
            ((Buffer)buf$2).clear();
            toWrite2.foreach((Function1)new Serializable($this, buf$2){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buf$2;

                public final ByteBuffer apply(byte x$1) {
                    return this.buf$2.put(x$1);
                }
                {
                    this.buf$2 = buf$2;
                }
            });
            ((Buffer)buf$2).flip();
            long currentWrite = c$1.write(buf$2);
            boolean bl2 = earlyTermination$1.elem = length$1 <= written + (long)numBytes && remaining2.nonEmpty();
            if (earlyTermination$1.elem || remaining2.isEmpty()) {
                return currentWrite + acc;
            }
            acc = currentWrite + acc;
            data = remaining2;
            written += (long)numBytes;
        }
        throw new MatchError(tuple2);
    }

    public static final ByteChannel opened$1(Seekable $this) {
        OpenedResource<SeekableByteChannel> r = $this.underlyingChannel(false);
        r.get().position(0L);
        return new ByteChannel($this, r){
            private final SeekableByteChannel wrapped;
            private final OpenedResource r$1;

            public boolean isOpen() {
                return this.wrapped.isOpen();
            }

            public void close() {
                this.r$1.close();
            }

            public int write(ByteBuffer src) {
                return this.wrapped.write(src);
            }

            public int read(ByteBuffer dst) {
                return this.wrapped.read(dst);
            }
            {
                this.r$1 = r$1;
                this.wrapped = (SeekableByteChannel)r$1.get();
            }
        };
    }

    public static void $init$(Seekable $this) {
    }
}

