/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import views.html.defaultpages.unauthorized;

public class Security {

    public static class Authenticator
    extends Results {
        public String getUsername(Http.Context context) {
            return (String)context.session().get("username");
        }

        public Result onUnauthorized(Http.Context context) {
            return Authenticator.unauthorized(unauthorized.render());
        }
    }

    public static class AuthenticatedAction
    extends Action<Authenticated> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result call(Http.Context context) {
            Authenticator authenticator = ((Authenticated)this.configuration).value().newInstance();
            String string = authenticator.getUsername(context);
            if (string == null) {
                return authenticator.onUnauthorized(context);
            }
            try {
                context.request().setUsername(string);
                Result result = this.delegate.call(context);
                context.request().setUsername(null);
                return result;
            }
            catch (Throwable throwable) {
                try {
                    context.request().setUsername(null);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw new RuntimeException(throwable2);
                }
            }
        }
    }

    @With(value={AuthenticatedAction.class})
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Authenticated {
        public Class<? extends Authenticator> value() default Authenticator.class;
    }
}

