/*
 * Decompiled with CFR 0.152.
 */
package play;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import play.api.Play;
import play.libs.Scala;
import scala.Option;
import scala.collection.JavaConverters;

public class Configuration {
    private final play.api.Configuration conf;

    public static Configuration root() {
        return new Configuration(Play.unsafeApplication().configuration());
    }

    public Configuration(Config config) {
        this(new play.api.Configuration(config));
    }

    public Configuration(play.api.Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConfig(String string) {
        Option<play.api.Configuration> option = this.conf.getConfig(string);
        if (option.isDefined()) {
            return new Configuration((play.api.Configuration)option.get());
        }
        return null;
    }

    public String getString(String string) {
        return Scala.orNull(this.conf.getString(string, (Option<scala.collection.immutable.Set<String>>)Option.empty()));
    }

    public String getString(String string, String string2) {
        return Scala.orElse(this.conf.getString(string, (Option<scala.collection.immutable.Set<String>>)Option.empty()), string2);
    }

    public Long getMilliseconds(String string) {
        return (Long)Scala.orNull(this.conf.getMilliseconds(string));
    }

    public Long getMilliseconds(String string, Long l) {
        return Scala.orElse(this.conf.getMilliseconds(string), l);
    }

    public Long getNanoseconds(String string) {
        return (Long)Scala.orNull(this.conf.getNanoseconds(string));
    }

    public Long getNanoseconds(String string, Long l) {
        return Scala.orElse(this.conf.getNanoseconds(string), l);
    }

    public Long getBytes(String string) {
        return (Long)Scala.orNull(this.conf.getBytes(string));
    }

    public Long getBytes(String string, Long l) {
        return Scala.orElse(this.conf.getBytes(string), l);
    }

    public Double getDouble(String string) {
        return (Double)Scala.orNull(this.conf.getDouble(string));
    }

    public Double getDouble(String string, Double d) {
        return Scala.orElse(this.conf.getDouble(string), d);
    }

    public Integer getInt(String string) {
        return (Integer)Scala.orNull(this.conf.getInt(string));
    }

    public Integer getInt(String string, Integer n) {
        return Scala.orElse(this.conf.getInt(string), n);
    }

    public Long getLong(String string) {
        return (Long)Scala.orNull(this.conf.getLong(string));
    }

    public Long getLong(String string, Long l) {
        return Scala.orElse(this.conf.getLong(string), l);
    }

    public Number getNumber(String string) {
        return Scala.orNull(this.conf.getNumber(string));
    }

    public Number getNumber(String string, Number number) {
        return Scala.orElse(this.conf.getNumber(string), number);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)Scala.orNull(this.conf.getBoolean(string));
    }

    public Boolean getBoolean(String string, Boolean bl) {
        return Scala.orElse(this.conf.getBoolean(string), bl);
    }

    public Set<String> keys() {
        return (Set)JavaConverters.setAsJavaSetConverter(this.conf.keys()).asJava();
    }

    public Set<String> subKeys() {
        return (Set)JavaConverters.setAsJavaSetConverter(this.conf.subKeys()).asJava();
    }

    public Map<String, Object> asMap() {
        return this.conf.underlying().root().unwrapped();
    }

    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        return this.conf.underlying().entrySet();
    }

    public RuntimeException reportError(String string, String string2, Throwable throwable) {
        return this.conf.reportError(string, string2, (Option<Throwable>)Option.apply((Object)throwable));
    }

    public List<Boolean> getBooleanList(String string) {
        return Scala.orNull(this.conf.getBooleanList(string));
    }

    public List<Boolean> getBooleanList(String string, List<Boolean> list) {
        return Scala.orElse(this.conf.getBooleanList(string), list);
    }

    public List<Long> getBytesList(String string) {
        return Scala.orNull(this.conf.getBytesList(string));
    }

    public List<Long> getBytesList(String string, List<Long> list) {
        return Scala.orElse(this.conf.getBytesList(string), list);
    }

    public List<Configuration> getConfigList(String string) {
        if (this.conf.getConfigList(string).isDefined()) {
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
            for (play.api.Configuration configuration : (List)this.conf.getConfigList(string).get()) {
                arrayList.add(new Configuration(configuration));
            }
            return arrayList;
        }
        return null;
    }

    public List<Configuration> getConfigList(String string, List<Configuration> list) {
        List<Configuration> list2 = this.getConfigList(string);
        if (list2 == null) {
            list2 = list;
        }
        return list2;
    }

    public List<Double> getDoubleList(String string) {
        return Scala.orNull(this.conf.getDoubleList(string));
    }

    public List<Double> getDoubleList(String string, List<Double> list) {
        return Scala.orElse(this.conf.getDoubleList(string), list);
    }

    public List<Integer> getIntList(String string) {
        return Scala.orNull(this.conf.getIntList(string));
    }

    public List<Integer> getIntList(String string, List<Integer> list) {
        return Scala.orElse(this.conf.getIntList(string), list);
    }

    public List<Object> getList(String string) {
        if (this.conf.getList(string).isDefined()) {
            return ((ConfigList)this.conf.getList(string).get()).unwrapped();
        }
        return null;
    }

    public List<Object> getList(String string, List<Object> list) {
        List<Object> list2 = this.getList(string);
        if (list2 == null) {
            list2 = list;
        }
        return list2;
    }

    public List<Long> getLongList(String string) {
        return Scala.orNull(this.conf.getLongList(string));
    }

    public List<Long> getLongList(String string, List<Long> list) {
        return Scala.orElse(this.conf.getLongList(string), list);
    }

    public List<Long> getMillisecondsList(String string) {
        return Scala.orNull(this.conf.getMillisecondsList(string));
    }

    public List<Long> getMillisecondsList(String string, List<Long> list) {
        return Scala.orElse(this.conf.getMillisecondsList(string), list);
    }

    public List<Long> getNanosecondsList(String string) {
        return Scala.orNull(this.conf.getNanosecondsList(string));
    }

    public List<Long> getNanosecondsList(String string, List<Long> list) {
        return Scala.orElse(this.conf.getNanosecondsList(string), list);
    }

    public List<Number> getNumberList(String string) {
        return Scala.orNull(this.conf.getNumberList(string));
    }

    public List<Number> getNumberList(String string, List<Number> list) {
        return Scala.orElse(this.conf.getNumberList(string), list);
    }

    public List<Map<String, Object>> getObjectList(String string) {
        if (this.conf.getObjectList(string).isDefined()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (ConfigObject configObject : (List)this.conf.getObjectList(string).get()) {
                arrayList.add(configObject.unwrapped());
            }
            return arrayList;
        }
        return null;
    }

    public List<Map<String, Object>> getObjectList(String string, List<Map<String, Object>> list) {
        List<Map<String, Object>> list2 = this.getObjectList(string);
        if (list2 == null) {
            list2 = list;
        }
        return list2;
    }

    public List<String> getStringList(String string) {
        return Scala.orNull(this.conf.getStringList(string));
    }

    public List<String> getStringList(String string, List<String> list) {
        return Scala.orElse(this.conf.getStringList(string), list);
    }

    public Object getObject(String string) {
        if (this.conf.getObject(string).isDefined()) {
            return ((ConfigObject)this.conf.getObject(string).get()).unwrapped();
        }
        return null;
    }

    public Object getObject(String string, Object object) {
        Object object2 = this.getObject(string);
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public play.api.Configuration getWrappedConfiguration() {
        return this.conf;
    }
}

