package models.services
import beans._
import models._
import controllers.services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
case class PartRelationManager() {
  def insert(data:PartsListBean):String = {
    if(Check().loopCheck(data)) {
      val pr = PartManager().getByName(data.parent).parts.associate(PartManager().getByName(data.child))
      // insertの後、attributeの更新
      updatePr(pr, data)
      return null
    } else {
      return "form.error1"
    }
  }
  
  def update(data:PartsListBean, childName:String):String = {
    if(data.child == childName) {
      if(Check().loopCheck(data)) {
        //PartRelation データ更新処理
        val pr = PartManager().getByName(data.parent).parts.assign(PartManager().getByName(data.child))
        updatePr(pr, data)
        return null
      } else {
       return "form.error1"
       }
    } else {
      //PartRelation キー情報（ChildId）の更新なので削除／登録処理
      delete(data, childName)
      insert(data)
     }
  }
  
  def updatePr(pr: PartRelation, data: PartsListBean) = {
    pr.quantity = data.quantity
    PartsListDb.partRelations.update(pr)
  }
  
  def delete(data: PartsListBean, childName: String) = {
       PartManager().getByName(data.parent).parts.dissociate(PartManager().getByName(childName))
  }
  
}