/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import play.api.UsefulException;

public class PlayException
extends UsefulException {
    private final AtomicLong generator = new AtomicLong(System.currentTimeMillis());

    private String nextId() {
        return Long.toString(this.generator.incrementAndGet(), 26);
    }

    public PlayException(String string, String string2, Throwable throwable) {
        super(string + "[" + string2 + "]", throwable);
        this.title = string;
        this.description = string2;
        this.id = this.nextId();
        this.cause = throwable;
    }

    public PlayException(String string, String string2) {
        super(string + "[" + string2 + "]");
        this.title = string;
        this.description = string2;
        this.id = this.nextId();
        this.cause = null;
    }

    public static class InterestingLines {
        public final int firstLine;
        public final int errorLine;
        public final String[] focus;

        public InterestingLines(int n, String[] stringArray, int n2) {
            this.firstLine = n;
            this.errorLine = n2;
            this.focus = stringArray;
        }
    }

    public static abstract class RichDescription
    extends ExceptionAttachment {
        public RichDescription(String string, String string2, Throwable throwable) {
            super(string, string2, throwable);
        }

        public RichDescription(String string, String string2) {
            super(string, string2);
        }

        public abstract String htmlDescription();
    }

    public static abstract class ExceptionAttachment
    extends PlayException {
        public ExceptionAttachment(String string, String string2, Throwable throwable) {
            super(string, string2, throwable);
        }

        public ExceptionAttachment(String string, String string2) {
            super(string, string2);
        }

        public abstract String subTitle();

        public abstract String content();
    }

    public static abstract class ExceptionSource
    extends PlayException {
        public ExceptionSource(String string, String string2, Throwable throwable) {
            super(string, string2, throwable);
        }

        public ExceptionSource(String string, String string2) {
            super(string, string2);
        }

        public abstract Integer line();

        public abstract Integer position();

        public abstract String input();

        public abstract String sourceName();

        public InterestingLines interestingLines(int n) {
            try {
                if (this.input() == null || this.line() == null) {
                    return null;
                }
                String[] stringArray = this.input().split("\n");
                int n2 = Math.max(0, this.line() - n);
                int n3 = Math.min(stringArray.length - 1, this.line() + n);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = n2; i <= n3; ++i) {
                    arrayList.add(stringArray[i]);
                }
                return new InterestingLines(n2 + 1, arrayList.toArray(new String[arrayList.size()]), this.line() - n2 - 1);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public String toString() {
            return super.toString() + " in " + this.sourceName() + ":" + this.line();
        }
    }
}

