/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.transaction.xa.XAException;

final class Util {
    private static final SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    Util() {
    }

    static String getStatus(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                stringBuffer.append("STATUS_ACTIVE: ");
                stringBuffer.append("A transaction is associated with the target object and it is in the active state.");
                break;
            }
            case 3: {
                stringBuffer.append("STATUS_COMMITTED: ");
                stringBuffer.append("A transaction is associated with the target object and it has been committed.");
                break;
            }
            case 8: {
                stringBuffer.append("STATUS_COMMITTING: ");
                stringBuffer.append("A transaction is associated with the target object and it is in the process of committing.");
                break;
            }
            case 1: {
                stringBuffer.append("STATUS_MARKED_ROLLBACK: ");
                stringBuffer.append("A transaction is associated with the target object and it has been marked for rollback, perhaps as a result of a setRollbackOnly operation.");
                break;
            }
            case 6: {
                stringBuffer.append("STATUS_NO_TRANSACTION: ");
                stringBuffer.append("No transaction is currently associated with the target object.");
                break;
            }
            case 2: {
                stringBuffer.append("STATUS_PREPARED: ");
                stringBuffer.append("A transaction is associated with the target object and it has been prepared, i.e.");
                break;
            }
            case 7: {
                stringBuffer.append("STATUS_PREPARING: ");
                stringBuffer.append("A transaction is associated with the target object and it is in the process of preparing.");
                break;
            }
            case 4: {
                stringBuffer.append("STATUS_ROLLEDBACK: ");
                stringBuffer.append("A transaction is associated with the target object and the outcome has been determined as rollback.");
                break;
            }
            case 9: {
                stringBuffer.append("STATUS_ROLLING_BACK: ");
                stringBuffer.append("A transaction is associated with the target object and it is in the process of rolling back.");
                break;
            }
            default: {
                stringBuffer.append("Unknown status " + n);
            }
        }
        return stringBuffer.toString();
    }

    static String getHeuristic(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 2: {
                stringBuffer.append("rollback");
                break;
            }
            case 1: {
                stringBuffer.append("commit");
                break;
            }
            case 4: {
                stringBuffer.append("mixed");
                break;
            }
            case 8: {
                stringBuffer.append("hazard");
                break;
            }
            case 32: {
                stringBuffer.append("other");
                break;
            }
            case 0: {
                stringBuffer.append("read only");
                break;
            }
            default: {
                if ((n & 2) != 0) {
                    stringBuffer.append("rollback");
                }
                if ((n & 1) != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("commit");
                }
                if ((n & 4) != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("mixed");
                }
                if ((n & 8) != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("hazard");
                }
                if ((n & 0x20) != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("other");
                }
                if ((n & 0) == 0) break;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("read only");
            }
        }
        return stringBuffer.toString();
    }

    static String getXAException(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XA Exception occurred: ");
        switch (xAException.errorCode) {
            case 7: {
                stringBuffer.append("XA_HEURCOM: ");
                stringBuffer.append("The transaction branch has been heuristically committed.");
                break;
            }
            case 8: {
                stringBuffer.append("XA_HEURHAZ: ");
                stringBuffer.append("The transaction branch may have been heuristically completed.");
                break;
            }
            case 5: {
                stringBuffer.append("XA_HEURMIX: ");
                stringBuffer.append("The transaction branch has been heuristically committed and rolled back.");
                break;
            }
            case 6: {
                stringBuffer.append("XA_HEURRB: ");
                stringBuffer.append("The transaction branch has been heuristically rolled back.");
                break;
            }
            case 9: {
                stringBuffer.append("XA_NOMIGRATE: ");
                stringBuffer.append("Resumption must occur where suspension occured.");
                break;
            }
            case 101: {
                stringBuffer.append("XA_RBCOMMFAIL: ");
                stringBuffer.append("Communication error occured.");
                break;
            }
            case 102: {
                stringBuffer.append("XA_RBDEADLOCK: ");
                stringBuffer.append("A deadlock was detected.");
                break;
            }
            case 103: {
                stringBuffer.append("XA_RBINTEGRITY: ");
                stringBuffer.append("A condition that violates the integrity of the resource was detected.");
                break;
            }
            case 104: {
                stringBuffer.append("XA_RBOTHER: ");
                stringBuffer.append("The resource manager rolled back the transaction branch for a reason not on this list.");
                break;
            }
            case 105: {
                stringBuffer.append("XA_RBPROTO: ");
                stringBuffer.append("A protocol error occured in the resource manager.");
                break;
            }
            case 100: {
                stringBuffer.append("XA_RBROLLBACK: ");
                stringBuffer.append("Rollback was caused by unspecified reason.");
                break;
            }
            case 106: {
                stringBuffer.append("XA_RBTIMEOUT: ");
                stringBuffer.append("A transaction branch took too long.");
                break;
            }
            case 107: {
                stringBuffer.append("XA_RBTRANSIENT: ");
                stringBuffer.append("May retry the transaction branch.");
                break;
            }
            case 3: {
                stringBuffer.append("XA_RDONLY: ");
                stringBuffer.append("The transaction branch has been read-only and has been committed.");
                break;
            }
            case 4: {
                stringBuffer.append("XA_RETRY: ");
                stringBuffer.append("Routine returned with no effect and may be reissued.");
                break;
            }
            case -2: {
                stringBuffer.append("XAER_ASYNC: ");
                stringBuffer.append("Asynchronous operation already outstanding.");
                break;
            }
            case -8: {
                stringBuffer.append("XAER_DUPID: ");
                stringBuffer.append("The XID already exists.");
                break;
            }
            case -5: {
                stringBuffer.append("XAER_INVAL: ");
                stringBuffer.append("Invalid arguments were given.");
                break;
            }
            case -4: {
                stringBuffer.append("XAER_NOTA: ");
                stringBuffer.append("The XID is not valid.");
                break;
            }
            case -9: {
                stringBuffer.append("XAER_OUTSIDE: ");
                stringBuffer.append("The resource manager is doing work outside global transaction.");
                break;
            }
            case -6: {
                stringBuffer.append("XAER_PROTO: ");
                stringBuffer.append("Routine was invoked in an inproper context.");
                break;
            }
            case -3: {
                stringBuffer.append("XAER_RMERR: ");
                stringBuffer.append("A resource manager error has occured in the transaction branch.");
                break;
            }
            case -7: {
                stringBuffer.append("XAER_RMFAIL: ");
                stringBuffer.append("Resource manager is unavailable.");
                break;
            }
            default: {
                stringBuffer.append("Unknown error code: " + xAException.errorCode);
            }
        }
        if (xAException.getMessage() != null) {
            stringBuffer.append(": ").append(xAException.getMessage());
        }
        return stringBuffer.toString();
    }

    public static String fromClock(long l) {
        return _dateFormat.format(new Date(l));
    }
}

