/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource;

public final class ReuseOptions {
    public static final int REUSE_ON = 0;
    public static final int REUSE_OFF = 1;
    public static final int REUSE_TRANSACTION = 2;
    public static final int REUSE_TRANSACTION_OFF = 3;
    public static final int REUSE_NO_TRANSACTION_OFF = 4;
    public static final String REUSE_ON_NAME = "on";
    public static final String REUSE_OFF_NAME = "off";
    public static final String REUSE_TRANSACTION_NAME = "transaction";
    public static final String REUSE_TRANSACTION_OFF_NAME = "transaction_off";
    public static final String REUSE_NO_TRANSACTION_OFF_NAME = "no_transaction_off";

    private ReuseOptions() {
    }

    public static int fromString(String string) {
        if (null == string) {
            throw new IllegalArgumentException("The argument 'string' is null.");
        }
        if (string.equals(REUSE_ON_NAME)) {
            return 0;
        }
        if (string.equals(REUSE_OFF_NAME)) {
            return 1;
        }
        if (string.equals(REUSE_TRANSACTION_NAME)) {
            return 2;
        }
        if (string.equals(REUSE_TRANSACTION_OFF_NAME)) {
            return 3;
        }
        if (string.equals(REUSE_NO_TRANSACTION_OFF_NAME)) {
            return 4;
        }
        throw new IllegalArgumentException("Unknown reuse option: " + string);
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return REUSE_ON_NAME;
            }
            case 1: {
                return REUSE_OFF_NAME;
            }
            case 2: {
                return REUSE_TRANSACTION_NAME;
            }
            case 4: {
                return REUSE_NO_TRANSACTION_OFF_NAME;
            }
        }
        throw new IllegalArgumentException("Unknown reuse option: " + n);
    }

    public static void validate(int n) {
        if (!ReuseOptions.isValid(n)) {
            throw new IllegalArgumentException("Unknown reuse option: " + n);
        }
    }

    public static boolean isValid(int n) {
        return 0 == n || 1 == n || 2 == n || 4 == n;
    }
}

