// WildCardSearch.h
// (c) 2003 exeal

#ifndef _WILD_CARD_SEARCH_H_
#define _WILD_CARD_SEARCH_H_
#include <string>
#include <list>


enum TokenType {
	WTT_QUESTION,		// ?
	WTT_STAR,			// *
	WTT_HASH,			// #
	WTT_LEFTBRACKET,	// [
	WTT_RIGHTBRACKET,	// ]
	WTT_EXCLAMATION,	// !
	WTT_CHARACTER,		// other
};

struct TToken {
	TokenType		type;
	unsigned long	character;
	TToken*			pNext;

	TToken(TokenType type_) : type(type_), pNext(0) {
	}
	~TToken() {
		delete pNext;
	}
};

class CWildCardSearch {
};

template<typename T>
class CWildcardLexer {
	typedef std::basic_string<T>	StringType;
public:
	CWildcardLexer(const T* strPattern, size_t cchPattern) : m_pHeadToken(0) {
		assert(strPattern != 0 && cchPattern != 0);

		size_t	i;
		bool	bEscapeNext = false;
		TToken*	pNewToken = 0;
		while(i < cchPattern) {
			if(bEscapeNext) {
				bEscapeNext = false;
				goto default;
			}
			switch(strPattern[i]) {
			case '?':
				pNewToken = new TToken(WTT_QUESTION);
				break;
			case '*':
				pNewToken = new TToken(WTT_STAR);
				break;
			case '#':
				pNewToken = new TToken(WTT_HASH);
				break;
			case '[':
				pNewToken = new TToken(WTT_LEFTBRACKET);
				break;
			case ']':
				pNewToken = new TToken(WTT_RIGHTBRACKET);
				break;
			case '!':
				pNewToken = new TToken(WTT_EXCLAMATION);
				break;
			case '\\':
				bEscapeNext = true;
				break;
			default:
				pNewToken = new TToken(WTT_CHARACTER);
				break;
			}
		}
	}
	virtual ~CWildcardLexer() {
		delete m_pHeadToken;
	}

private:
	TToken*	m_pHeadToken;
};

#endif /* _WILD_CARD_SEARCH_H_ */

/* [EOF] */