// UnknownImpl.h
// (c) 2002-2004 exeal

#ifndef _UNKNOWN_IMPL_H_
#define _UNKNOWN_IMPL_H_

#include "ComGeneric.h"


namespace Armaiti {

// IUnknownImpl ̂߂3̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/// QƃJEggpȂ
class CUnheapMemoryManageModel {
public:
	CUnheapMemoryManageModel() {}
	ULONG AddRef() {return 2;}
	ULONG Release() {return 1;}
private:
	CUnheapMemoryManageModel(const CUnheapMemoryManageModel&);
	operator =(CUnheapMemoryManageModel&);
};

/// PȎQƃJEggp
class CSingleThreadMemoryManageModel {
public:
	CSingleThreadMemoryManageModel() : m_cRef(0) {}
	ULONG AddRef() {return ++m_cRef;}
	ULONG Release() {return --m_cRef;}
private:
	LONG	m_cRef;
	CSingleThreadMemoryManageModel(const CSingleThreadMemoryManageModel&);
	operator =(const CSingleThreadMemoryManageModel&);
};

/// QƃJEg̑XbhZ[t
class CMultiThreadMemoryManageModel {
public:
	CMultiThreadMemoryManageModel() : m_cRef(0) {}
	ULONG AddRef() {return ::InterlockedIncrement(&m_cRef);}
	ULONG Release() {return ::InterlockedDecrement(&m_cRef);}
private:
	LONG	m_cRef;
	CMultiThreadMemoryManageModel(const CSingleThreadMemoryManageModel&);
	operator =(const CMultiThreadMemoryManageModel&);
};


// IUnknownImpl class definitions and implementations
/////////////////////////////////////////////////////////////////////////////

/// IUnknown ̎
template<class MemoryManageModel>
class IUnknownImpl {
	// RXgN^
public:
	///	RXgN^
	IUnknownImpl() {/* do nothing */}
	///	fXgN^
	virtual ~IUnknownImpl() {/* do nothing */}
private:
	IUnknownImpl(const IUnknownImpl&);

	// Zq
private:
	operator =(const IUnknownImpl&);

	// f[^o
protected:
	MemoryManageModel	mmm;	// Ǘf
};

#define IMPLEMENT_UNKNOWN()				\
	STDMETHODIMP_(ULONG)	AddRef() {	\
		return mmm.AddRef();			\
	}									\
	STDMETHODIMP_(ULONG)	Release() {	\
		LONG	cRef = mmm.Release();	\
		if(cRef == 0)					\
			delete this;				\
		return cRef;					\
	}

#define BEGIN_INTERFACE_TABLE()										\
	STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {	\
		if(ppvObject == 0)											\
			return E_POINTER;

#define END_INTERFACE_TABLE()								\
		else												\
			return (*ppvObject = 0), E_NOINTERFACE;			\
		reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();	\
		return S_OK;										\
	}

#define IMPLEMENTS_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName)				\
			*ppvObject = static_cast<InterfaceName*>(this);

#define IMPLEMENTS_LEFTMOST_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName || riid == IID_IUnknown)	\
			*ppvObject = static_cast<InterfaceName*>(this);


// ISupportErrorInfoImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// ISupportErrorInfo ̕WIȎ
template<const IID* piid>
class ISupportErrorInfoImpl : public ISupportErrorInfo {
	STDMETHODIMP	InterfaceSupportsErrorInfo(REFIID riid) {
		return (riid == *piid) ? S_OK : S_FALSE;
	}
};

} // namespace Armaiti

#endif /* _UNKNOWN_IMPL_H_ */

/* [EOF] */