// DispatchImpl.h
// (c) 2002-2004 exeal

#ifndef _DISPATCH_IMPL_H_
#define _DISPATCH_IMPL_H_

#include "ComGeneric.h"


namespace Armaiti {
namespace OLE {

// IProvideClassInfo2Impl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IProvideClassInfo2 ̊{IȎ
 *	@param pclsid	CLSID
 *	@param piid		IID
 *	@param plibid	LIBID
 *	@param wMajor	W[o[W
 *	@param wMinor	}Ci[o[W
 */
template<const CLSID* pclsid, const IID* piid, const GUID* plibid, WORD wMajor = 1, WORD wMinor = 0>
class IProvideClassInfo2Impl : public IProvideClassInfo2 {
	// RXgN^
public:
	/// RXgN^
	IProvideClassInfo2Impl() : m_pTypeInfo(0) {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		hr = ::LoadRegTypeLib(*plibid, wMajor, wMinor, 0, &pTypeLib);
		assert(SUCCEEDED(hr));
		pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~IProvideClassInfo2Impl() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}

	// \bh
public:
	///	@see	IProvideClassInfo::GetClassInfo
	STDMETHOD(GetClassInfo)(ITypeInfo** ppTypeInfo) {
		if(ppTypeInfo == 0)
			return E_POINTER;
		*ppTypeInfo = m_pTypeInfo;
		(*ppTypeInfo)->AddRef();
		return S_OK;
	}

	///	@see	IProvideClassInfo2::GetGUID
	STDMETHOD(GetGUID)(DWORD dwGuidKind, GUID* pGUID) {
		if(pGUID == 0)
			return E_POINTER;
		if(dwGuidKind == GUIDKIND_DEFAULT_SOURCE_DISP_IID && pclsid != 0) {
			*pGUID = iid;
			return S_OK;
		}
		*pGUID = 0;
		return E_INVALIDARG;
	}

	// f[^o
private:
	ITypeInfo*	m_pTypeInfo;
};


// IDispatchImpl NX̂߂2̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/**
 *	LIBID ^CvCu[h
 *	@param plibid	^CvCu LIBID
 *	@param piid		IID
 *	@param wMajor	W[o[W
 *	@param wMinor	}Ci[o[W
 */
template<const GUID* plibid, const IID* piid, WORD wMajor = 1, WORD wMinor = 0>
class CRegTypeLibTypeInfoHolder {
public:
	/// RXgN^
	CRegTypeLibTypeInfoHolder() {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		assert(plibid != 0 && piid != 0);
		hr = ::LoadRegTypeLib(*plibid, wMajor, wMinor, 0, &pTypeLib);
		assert(SUCCEEDED(hr));
		hr = pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~CRegTypeLibTypeInfoHolder() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo*	GetTypeInfo() const {
		return m_pTypeInfo;
	}
private:
	ITypeInfo*	m_pTypeInfo;
};

/**
 *	ڃpXw肵ă^CvCu[h
 *	@param TypeLibPath	^CvCũpX񋟂NX
 *	@param piid			IID
 */
template<class TypeLibPath, const IID* piid>
class CPathTypeLibTypeInfoHolder {
public:
	/// RXgN^
	CPathTypeLibTypeInfoHolder() {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		hr = ::LoadTypeLib(TypeLibPath::GetPath(), &pTypeLib);
		assert(SUCCEEDED(hr));
		hr = pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~CPathTypeLibTypeInfoHolder() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo*	GetTypeInfo() const {
		return m_pTypeInfo;
	}
private:
	ITypeInfo*	m_pTypeInfo;
};


// IDispatchImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IDispatch ̕WIȎ
 *	@param DI				IDispatch ƂC^[tFCX
 *	@param TypeInfoHolder	ITypeInfo 񋟂NX
 */
template<class DI, class TypeInfoHolder>
class IDispatchImpl : public DI {
	// RXgN^
public:
	/// RXgN^
	IDispatchImpl() : m_pTypeInfoHolder(0) {
		m_pTypeInfoHolder = new TypeInfoHolder;
	}
	/// fXgN^
	virtual ~IDispatchImpl() {
		delete m_pTypeInfoHolder;
	}

	// \bh
public:
	/// @see	IDispatch::GetIDsOfNames
	STDMETHOD(GetIDsOfNames)(REFIID riid,
			OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
		assert(m_pTypeInfoHolder != 0);
		assert(riid == IID_NULL);
		return ::DispGetIDsOfNames(m_pTypeInfoHolder->GetTypeInfo(), rgszNames, cNames, rgDispId);
	}

	/// @see	IDispatch::GetTypeInfo
	STDMETHOD(GetTypeInfo)(unsigned int iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
		VERIFY_POINTER(ppTypeInfo);
		if(iTypeInfo != 0)
			return DISP_E_BADINDEX;
		else if(m_pTypeInfoHolder == 0)
			return (*ppTypeInfo = 0), TYPE_E_ELEMENTNOTFOUND;
		(*ppTypeInfo = m_pTypeInfoHolder->GetTypeInfo())->AddRef();
		return S_OK;
	}

	/// @see	IDispatch::GetTypeInfoCount
	STDMETHOD(GetTypeInfoCount)(unsigned int* pctInfo) {
		VERIFY_POINTER(pctInfo);
		*pctInfo = (m_pTypeInfoHolder != 0) ? 1 : 0;
		return S_OK;
	}

	/// @see	IDispatch::Invoke
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
			DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
		assert(m_pTypeInfoHolder != 0);
		assert(riid == IID_NULL);
		return ::DispInvoke(static_cast<DI*>(this),
				m_pTypeInfoHolder->GetTypeInfo(), dispidMember, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
	}

	// f[^o
private:
	TypeInfoHolder*	m_pTypeInfoHolder;
};

} // namespace OLE
} // namespace Armaiti

#endif /* DISPATCH_IMPL_H_ */

/* [EOF] */