// ScriptLanguageManager.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "ScriptLanguageManager.h"
#include <activdbg.h>
#include <algorithm>
using Alpha::CScriptLanguageManager;


// CScriptLanguageManager class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	1ǉ
 *	@param strLanguageName	ǉ錾ꖼ
 *	@param setExtensions	gq̏W
 */
void CScriptLanguageManager::Add(const wstring& strLanguageName, const set<wstring>& setExtensions) {
	set<wstring>	setExtensions_;
	wchar_t*		pwszExtensionName = 0;

	// ɕϊȂW
	for(set<wstring>::const_iterator it = setExtensions.begin(); it != setExtensions.end(); ++it) {
		pwszExtensionName = new wchar_t[it->length() + 1];
		wcscpy(pwszExtensionName, it->c_str());
		::CharLowerW(pwszExtensionName);
		setExtensions_.insert(wstring(pwszExtensionName));
		delete[] pwszExtensionName;
	}
	m_mapLanguages[strLanguageName] = setExtensions_;
}

/**
 *	ꖼɑΉXNvgGW CLSID Ԃ
 *	@param strLanguageName	ꖼ
 */
CLSID CScriptLanguageManager::GetCLSID(const wstring& strLanguageName) {
	CLSID	clsid;
	::CLSIDFromProgID(strLanguageName.c_str(), &clsid);
	return clsid;
}

/**
 *	ɑΉgq̏WԂ
 *	@param strLanguageName	ꖼ
 */
set<wstring> CScriptLanguageManager::GetExtensionNames(const wstring& strLanguageName) const {
	set<wstring>								setExtensions;
	map<wstring, set<wstring> >::const_iterator	it;

	it = m_mapLanguages.find(strLanguageName);
	if(it != m_mapLanguages.end())
		setExtensions = it->second;
	return setExtensions;
}

/**
 *	̏W擾
 */
set<wstring> CScriptLanguageManager::GetLanguages() const {
	set<wstring>	setLanguages;

	for(map<wstring, set<wstring> >::const_iterator it = m_mapLanguages.begin();
			it != m_mapLanguages.end(); ++it)
		setLanguages.insert(it->first);

	return setLanguages;
}

/**
 *	gq猾ꖼ擾Bgqo^ĂȂ΋󕶎Ԃ
 *	@param strExtensionName	gq
 */
wstring CScriptLanguageManager::LanguageNameFromExtension(const wstring& strExtensionName) const {
	wchar_t*	pwszExtensionName = new wchar_t[strExtensionName.length() + 1];
	wcscpy(pwszExtensionName, strExtensionName.c_str());
	::CharLowerW(pwszExtensionName);
	for(map<wstring, set<wstring> >::const_iterator it = m_mapLanguages.begin();
			it != m_mapLanguages.end(); ++it) {
		if(it->second.find(wstring(pwszExtensionName)) != it->second.end()) {
			delete[] pwszExtensionName;
			return it->first;
		}
	}
	delete[] pwszExtensionName;
	return L"";
}

/**
 *	XNvgGWfobOT|[g邩ǂԂ
 */
bool CScriptLanguageManager::QueryDebuggable(const wstring& strLanguageName) {
	CLSID				clsid = GetCLSID(strLanguageName);
	IActiveScriptDebug*	pDebugger = 0;

	if(clsid != CLSID_NULL
		&& SUCCEEDED(::CoCreateInstance(clsid,
			0, CLSCTX_ALL, IID_IActiveScriptDebug, reinterpret_cast<void**>(&pDebugger)))) {
		pDebugger->Release();
		return true;
	}
	return false;
}

/**
 *	1폜
 *	@param strLanguageName	폜錾ꖼ
 */
void CScriptLanguageManager::Remove(const wstring& strLanguageName) {
	m_mapLanguages.erase(strLanguageName);
}

/**
 *	ׂč폜
 */
void CScriptLanguageManager::RemoveAll() {
	m_mapLanguages.clear();
}


/* [EOF] */