// FindDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "FindDlg.h"
#include <algorithm>	// std::find
using Alpha::CFindDlg;


// CFindDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CFindDlg::CFindDlg() : m_bUseRegExp(false), m_bWholeWord(false),
		m_bIgnoreCase(false), m_bIgnoreKanaType(false),
		m_bAutoClose(false), m_bHasSelection(false), m_bReplaceBackward(false) {
}

/**
 *	ɕǉ
 *	@param strText		ǉ镶
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::AddToHistory(const wstring& strText, bool bIsReplace) {
	AssertValid();

	list<wstring>&			listTarget = bIsReplace ? m_listReplaceWith : m_listFindWhat;
	list<wstring>::iterator	it;

	it = std::find(listTarget.begin(), listTarget.end(), strText);
	if(it != listTarget.end())
		listTarget.erase(it);
	listTarget.push_front(strText);

	if(IsWindow()) {
		UpdateHistory(bIsReplace);
		SendDlgItemMessage(bIsReplace ? IDC_COMBO_REPLACEWITH : IDC_COMBO_FINDWHAT, CB_SETCURSEL, 0, 0L);
	}
}

/**
 *	폜
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::ClearHistory(bool bIsReplace) {
	AssertValid();
	(bIsReplace ? m_listReplaceWith : m_listFindWhat).clear();
	if(IsWindow())
		UpdateHistory(bIsReplace);
}

///	擾
void CFindDlg::GetHistory(list<wstring>& listFindWhat, list<wstring>& listReplaceWith) const {
	AssertValid();

	listFindWhat = m_listFindWhat;
	listReplaceWith = m_listReplaceWith;
}

///	ݒ
void CFindDlg::SetHistory(const list<wstring>& listFindWhat, const list<wstring>& listReplaceWith) {
	AssertValid();

	// d`FbNȂRs[
	m_listFindWhat.clear();
	for(list<wstring>::const_iterator it = listFindWhat.begin(); it != listFindWhat.end(); ++it) {
		if(m_listFindWhat.end() == std::find(m_listFindWhat.begin(), m_listFindWhat.end(), *it))
			m_listFindWhat.push_back(*it);
	}
	m_listReplaceWith.clear();
	for(list<wstring>::const_iterator it = listReplaceWith.begin(); it != listReplaceWith.end(); ++it) {
		if(m_listReplaceWith.end() == std::find(m_listReplaceWith.begin(), m_listReplaceWith.end(), *it))
			m_listReplaceWith.push_back(*it);
	}

	if(IsWindow()) {
		UpdateHistory(false);
		UpdateHistory(true);
	}
}

/**	
 *	XgR{{bNXɔf
 *	@param	bIsReplace	ûƂ^
 */
void CFindDlg::UpdateHistory(bool bIsReplace) {
	AssertValidAsWindow();

	list<wstring>::const_iterator	it;
	HWND							hwndReplaceWithCombobox = GetDlgItem(IDC_COMBO_REPLACEWITH);

	if(!bIsReplace) {	// []
		SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_RESETCONTENT, 0, 0L);
		for(it = m_listFindWhat.begin(); it != m_listFindWhat.end(); ++it)
			SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	} else{	// [u]
		if(::IsWindow(hwndReplaceWithCombobox)) {
			::SendMessage(hwndReplaceWithCombobox, CB_RESETCONTENT, 0, 0L);
			for(it = m_listReplaceWith.begin(); it != m_listReplaceWith.end(); ++it)
				::SendMessage(hwndReplaceWithCombobox, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
		}
	}
}

///	@see	CDialog::OnCancel
void CFindDlg::OnCancel() {
	OnClose();
}

///	@see	CDialog::OnClose
void CFindDlg::OnClose() {
	GetParent()->SendMessage(WM_COMMAND,
		m_bType ? IDCM_FIND_FIND : IDCM_FIND_REPLACE, reinterpret_cast<LPARAM>(this));
//	CDialog::OnClose();
}

///	@see	CDialog::OnCommand
bool CFindDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	bool		bEnable;
	wchar_t*	pwsz = 0;
	size_t		cch;

	switch(wID) {
	case IDCM_FIND_FINDNEXT:
	case IDCM_FIND_FINDPREV:
	case IDCM_FIND_BOOKMARKALL:
	case IDCM_FIND_REPLACEALL:
	case IDCM_FIND_REPLACEANDNEXT:
		cch = ::GetWindowTextLength(GetDlgItem(IDC_COMBO_FINDWHAT));
		pwsz = new wchar_t[cch + 1];
		GetDlgItemText(IDC_COMBO_FINDWHAT, pwsz, cch + 1);
		m_strFindWhat = pwsz;
		delete[] pwsz;
		if(!m_bType) {
			if(wID == IDCM_FIND_FINDNEXT && m_bReplaceBackward)
				wID = IDCM_FIND_FINDPREV;
			cch = ::GetWindowTextLength(GetDlgItem(IDC_COMBO_REPLACEWITH));
			pwsz = new wchar_t[cch + 1];
			GetDlgItemText(IDC_COMBO_REPLACEWITH, pwsz, cch + 1);
			m_strReplaceWith = pwsz;
			delete[] pwsz;
		}
		GetParent()->SendMessage(WM_COMMAND, MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
		return true;
	case IDC_COMBO_FINDWHAT:
		if(wNotifyCode == CBN_EDITCHANGE || wNotifyCode == CBN_SELCHANGE) {
			bEnable = (wNotifyCode == CBN_EDITCHANGE) ?
				::GetWindowTextLength(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0 : true;
			::EnableWindow(GetDlgItem(IDCM_FIND_FINDNEXT), bEnable);
			::EnableWindow(GetDlgItem(IDCM_FIND_FINDPREV), bEnable);
			::EnableWindow(GetDlgItem(IDCM_FIND_BOOKMARKALL), bEnable);
			if(!m_bType) {	// [u]_CAO
				::EnableWindow(GetDlgItem(IDCM_FIND_REPLACEANDNEXT), bEnable);
				::EnableWindow(GetDlgItem(IDCM_FIND_REPLACEALL), bEnable);
			}
		}
		break;
	case IDC_CHK_USEREGEXP:
		m_bUseRegExp = IsDlgButtonChecked(IDC_CHK_USEREGEXP) == BST_CHECKED;
		break;
	case IDC_CHK_WHOLEWORD:
		m_bWholeWord = IsDlgButtonChecked(IDC_CHK_WHOLEWORD) == BST_CHECKED;
		break;
	case IDC_CHK_IGNORECASE:
		m_bIgnoreCase = IsDlgButtonChecked(IDC_CHK_IGNORECASE) == BST_CHECKED;
		break;
	case IDC_CHK_IGNOREKANATYPE:
		m_bIgnoreKanaType = IsDlgButtonChecked(IDC_CHK_IGNOREKANATYPE) == BST_CHECKED;
		break;
	case IDC_CHK_AUTOCLOSE:
		m_bAutoClose = IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED;
		break;
	case IDC_CHK_SHIFT:
		m_bReplaceBackward = IsDlgButtonChecked(IDC_CHK_SHIFT) == BST_CHECKED;
		break;
	case IDC_RADIO_SELECTION:
	case IDC_RADIO_WHOLEFILE:
		m_bFindSelection = IsDlgButtonChecked(IDC_RADIO_SELECTION) == BST_CHECKED;
		break;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFindDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_LIMITTEXT, 255, 0L);
	CheckDlg2StateButton(IDC_CHK_WHOLEWORD, m_bWholeWord);
	CheckDlg2StateButton(IDC_CHK_IGNORECASE, m_bIgnoreCase);
	CheckDlg2StateButton(IDC_CHK_IGNOREKANATYPE, m_bIgnoreKanaType);
	CheckDlg2StateButton(IDC_CHK_AUTOCLOSE, m_bAutoClose);
	if(!m_bType) {	// [u]_CAO
		::SendMessage(GetDlgItem(IDC_COMBO_REPLACEWITH), CB_LIMITTEXT, 255, 0L);
		SetDlgItemText(IDC_COMBO_REPLACEWITH, m_strReplaceWith.c_str());
		if(!m_bHasSelection) {
			::EnableWindow(GetDlgItem(IDC_RADIO_SELECTION), false);
			CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);
			m_bFindSelection = false;
		} else
			CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE,
				m_bFindSelection ? IDC_RADIO_SELECTION : IDC_RADIO_WHOLEFILE);
	}
	SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_RESETCONTENT, 0, 0L);

	UpdateHistory(false);
	UpdateHistory(true);
	SetDlgItemText(IDC_COMBO_FINDWHAT, m_strFindWhat.c_str());
	OnCommand(IDC_COMBO_FINDWHAT, CBN_EDITCHANGE, GetDlgItem(IDC_COMBO_FINDWHAT));

	return true;
}

/* [EOF] */