// CommonOptionDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CommonOptionDlg.h"
#include "Alpha.h"
#include "CodePageManager.h"
#include "..\Manah\WaitCursor.h"
#include "..\Manah\DC.h"
#include "..\Manah\GdiObject.h"
#include <list>
using Alpha::CCommonOptionSheet;
using Alpha::CCodePageOptionDlg;
using Alpha::CEditOptionDlg;
using Alpha::CFileOptionDlg;
using Alpha::CFindOptionDlg;
using Alpha::CKeyBindsOptionDlg;
using Alpha::CKeywordOptionDlg;
using Alpha::CViewOptionDlg;
using Alpha::CScriptOptionDlg;
using Alpha::CStyleOptionDlg;
using namespace Manah::Windows;
using namespace Manah::Windows::GDI;


// CCommonOptionSheet class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CCommonOptionSheet::CCommonOptionSheet(const wchar_t* pwszCaption, HWND hwndParent,
		UINT iSelectPage /* = 0 */) : CPropertySheet(pwszCaption, hwndParent, iSelectPage) {
	SetCallbackProc(CCommonOptionSheet::InitProc);
}

///	@see	CPropertySheet::OnInitSheet
int CCommonOptionSheet::InitProc(HWND hWnd, UINT message, LPARAM lParam) {
	if(message == PSCB_INITIALIZED) {
//		HWND	hwndTab = PropSheet_GetTabControl(hWnd);
//		TabCtrl_SetPadding(hwndTab, 5, 3);
	}
	return 0;
}


// CCodePageOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnInitDialog
bool CCodePageOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	LVCOLUMNW		column;
	LVITEMW			item;
	HWND			hwndCodePagesListView = GetDlgItem(IDC_LIST_CODEPAGES);
	list<UINT>		listCodePages;
	wchar_t			wszCodePage[10];
	const wchar_t*	pwszCPName = 0;

	column.mask = LVCF_WIDTH | LVCF_TEXT;
	column.pszText = L"R[hy[W";
	column.cx = 80;
	ListView_InsertColumn(hwndCodePagesListView, 0, &column);
	column.pszText = L"R[hy[W";
	column.cx = 290;
	ListView_InsertColumn(hwndCodePagesListView, 1, &column);

	ListView_SetExtendedListViewStyle(
		hwndCodePagesListView, LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	Alpha::CCodePageManager::EnumAvailableCodePages(listCodePages);

	item.mask = LVIF_TEXT;
	item.iItem = 0;

	for(list<UINT>::const_iterator it = listCodePages.begin(); it != listCodePages.end(); ++it, ++item.iItem) {
		pwszCPName = Alpha::CCodePageManager::GetCodePageName(*it);
		if(wcslen(pwszCPName) == 0)
			continue;
		swprintf(wszCodePage, L"%lu", *it);
		item.pszText = wszCodePage;
		item.iSubItem = 0;
		item.iItem = ListView_InsertItem(hwndCodePagesListView, &item);
		item.pszText = const_cast<wchar_t*>(pwszCPName);
		item.iSubItem = 1;
		ListView_SetItem(hwndCodePagesListView, &item);
		ListView_SetCheckState(hwndCodePagesListView,
			item.iItem, m_setExceptedCPs.find(*it) == m_setExceptedCPs.end());
	}

	return true;
}


// CEditOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CEditOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_RADIO_UNDOUNLIMITED || wID == IDC_RADIO_UNDOLIMITEDSPECIFIED) {
		bool	bLimitUndoCount = IsDlgButtonChecked(IDC_RADIO_UNDOLIMITEDSPECIFIED) == BST_CHECKED;

		::EnableWindow(GetDlgItem(IDC_STATIC_1), bLimitUndoCount);
		::EnableWindow(GetDlgItem(IDC_STATIC_2), bLimitUndoCount);
		::EnableWindow(GetDlgItem(IDC_EDIT_UNDOLIMIT), bLimitUndoCount);
		::EnableWindow(GetDlgItem(IDC_SPIN_UNDOLIMIT), bLimitUndoCount);
	}

	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnDestroy
void CEditOptionDlg::OnDestroy() {
	m_bCancelAfterCopy = IsDlgButtonChecked(IDC_CHK_CANCELAFTERCOPY) == BST_CHECKED;
	m_bUseCurrentBreak = IsDlgButtonChecked(IDC_CHK_USECURRENTBREAKASCOPY) == BST_CHECKED;

	CPropertyPage::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CEditOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	CheckDlg2StateButton(IDC_CHK_CANCELAFTERCOPY, m_bCancelAfterCopy);
	CheckDlg2StateButton(IDC_CHK_USECURRENTBREAKASCOPY, m_bUseCurrentBreak);
	CheckRadioButton(IDC_RADIO_UNDOUNLIMITED, IDC_RADIO_UNDOLIMITEDSPECIFIED,
		m_bLimitUndoHistory ? IDC_RADIO_UNDOLIMITEDSPECIFIED : IDC_RADIO_UNDOUNLIMITED);
	SendDlgItemMessage(IDC_SPIN_UNDOLIMIT, UDM_SETRANGE, 0, MAKELONG(60000, 60));
	SendDlgItemMessage(IDC_SPIN_UNDOLIMIT, UDM_SETPOS, 0, m_nUndoLimit);
	OnCommand(m_bLimitUndoHistory ? IDC_RADIO_UNDOLIMITEDSPECIFIED : IDC_RADIO_UNDOUNLIMITED, 0, 0);

	return true;
}


// CFileOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	Rg[̏ԂXV
void CFileOptionDlg::UpdateControls() {
	AssertValidAsWindow();

	bool	bUseAutoSave = IsDlgButtonChecked(IDC_CHK_AUTOSAVE) == BST_CHECKED;

	::EnableWindow(GetDlgItem(IDC_STATIC_INTERVAL1), bUseAutoSave);
	::EnableWindow(GetDlgItem(IDC_STATIC_INTERVAL2), bUseAutoSave);
	::EnableWindow(GetDlgItem(IDC_SPIN_INTERVAL), bUseAutoSave);
	::EnableWindow(GetDlgItem(IDC_EDIT_INTERVAL), bUseAutoSave);
	::EnableWindow(GetDlgItem(IDC_COMBO_CHARCODE), IsDlgButtonChecked(IDC_RADIO_CUSTOMCP) == BST_CHECKED);
}

///	@see	CDialog::OnCommand
bool CFileOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_BTN_RESET) {
		m_bClearedMRU = true;
		::EnableWindow(GetDlgItem(IDC_BTN_RESET), false);
	}
	UpdateControls();

	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnDestroy
void CFileOptionDlg::OnDestroy() {
	m_nShareMode = GetCheckedRadioButton(IDC_RADIO_SHARE, IDC_RADIO_DENYREADWRITE) - IDC_RADIO_SHARE;
	m_bAutoSave = IsDlgButtonChecked(IDC_CHK_AUTOSAVE) == BST_CHECKED;
	m_nInterval = SendDlgItemMessage(IDC_SPIN_INTERVAL, UDM_GETPOS, 0, 0L);
	m_bWriteBOMAsUTF8 = IsDlgButtonChecked(IDC_CHK_WRITEBOMASUTF8) == BST_CHECKED;
	m_bWriteBOMAsUTF16LE = IsDlgButtonChecked(IDC_CHK_WRITEBOMASUTF16LE) == BST_CHECKED;
	m_bWriteBOMAsUTF16BE = IsDlgButtonChecked(IDC_CHK_WRITEBOMASUTF16BE) == BST_CHECKED;
	m_bWriteBOMAsUTF32LE = IsDlgButtonChecked(IDC_CHK_WRITEBOMASUTF32LE) == BST_CHECKED;
	m_bWriteBOMAsUTF32BE = IsDlgButtonChecked(IDC_CHK_WRITEBOMASUTF32BE) == BST_CHECKED;
	m_bWriteBOMAsISO2022CN = IsDlgButtonChecked(IDC_CHK_WRITEBOMASISO2022CN) == BST_CHECKED;
	m_bWriteBOMAsISO2022KR = IsDlgButtonChecked(IDC_CHK_WRITEBOMASISO2022KR) == BST_CHECKED;
	m_nMRULimit = static_cast<BYTE>(SendDlgItemMessage(IDC_SPIN_MRULIMIT, UDM_GETPOS, 0, 0L));
	m_bSendAsAttachment = IsDlgButtonChecked(IDC_CHK_SENDASATTACHMENT) == BST_CHECKED;

	CPropertyPage::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CFileOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	list<UINT>	listCodePages;
	int			iInserted;

	// Rg[̐ݒ
	SendDlgItemMessage(IDC_SPIN_INTERVAL, UDM_SETRANGE, 0, MAKELONG(3600, 60));
	SendDlgItemMessage(IDC_SPIN_MRULIMIT, UDM_SETRANGE, 0, MAKELONG(16, 4));
	CCodePageManager::EnumAvailableCodePages(listCodePages);
	for(list<UINT>::const_iterator it = listCodePages.begin(); it != listCodePages.end(); ++it) {
		const wchar_t*	pwszCPName = CCodePageManager::GetCodePageName(*it);
		if(wcslen(pwszCPName) == 0)
			continue;
		iInserted = SendDlgItemMessage(IDC_COMBO_CHARCODE,
			CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszCPName));
		SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_SETITEMDATA, iInserted, *it);
	}
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CR+LF (Windows)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_CRLF);
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"LF (Unix)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_LF);
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CR (Macintosh)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_CR);
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"NEL (U+0085)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_NEL);
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"LS (U+2028)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_LS);
	iInserted = SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"PS (U+2029)"));
	SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_SETITEMDATA, iInserted, BT_PS);

	CheckRadioButton(IDC_RADIO_SHARE, IDC_RADIO_DENYREADWRITE, IDC_RADIO_SHARE + m_nShareMode);
	CheckDlg2StateButton(IDC_CHK_AUTOSAVE, m_bAutoSave);
	SendDlgItemMessage(IDC_SPIN_INTERVAL, UDM_SETPOS, 0, m_nInterval);
	SendDlgItemMessage(IDC_SPIN_MRULIMIT, UDM_SETPOS, 0, m_nMRULimit);
	CheckDlg2StateButton(IDC_CHK_SENDASATTACHMENT, m_bSendAsAttachment);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASUTF8, m_bWriteBOMAsUTF8);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASUTF16LE, m_bWriteBOMAsUTF16LE);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASUTF16BE, m_bWriteBOMAsUTF16BE);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASUTF32LE, m_bWriteBOMAsUTF32LE);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASUTF32BE, m_bWriteBOMAsUTF32BE);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASISO2022CN, m_bWriteBOMAsISO2022CN);
	CheckDlg2StateButton(IDC_CHK_WRITEBOMASISO2022KR, m_bWriteBOMAsISO2022KR);
	CheckRadioButton(IDC_RADIO_SYSTEMACP, IDC_RADIO_CUSTOMCP,
		m_bUseSystemACP ? IDC_RADIO_SYSTEMACP : IDC_RADIO_CUSTOMCP);
	SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_SELECTSTRING,
		-1, reinterpret_cast<LPARAM>(CCodePageManager::GetCodePageName(m_nCustomCP)));

	UpdateControls();
	return true;
}


// CFindOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnDestroy
void CFindOptionDlg::OnDestroy() {
	m_bShowMessageBox = IsDlgButtonChecked(IDC_CHK_SHOWMESSAGEBOX) == BST_CHECKED;
	m_bInitializeFromEditor = IsDlgButtonChecked(IDC_CHK_INITIALIZEFROMEDITOR) == BST_CHECKED;
}

///	@see	CDialog::OnInitDialog
bool CFindOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	CheckDlg2StateButton(IDC_CHK_SHOWMESSAGEBOX, m_bShowMessageBox);
	CheckDlg2StateButton(IDC_CHK_INITIALIZEFROMEDITOR, m_bInitializeFromEditor);

	return true;
}


// CKeywordOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CKeywordOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CKeywordOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	return true;
}


// CViewOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CViewOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

void CViewOptionDlg::OnDestroy() {
	m_bVisibleToolbar = IsDlgButtonChecked(IDC_CHK_TOOLBAR) == BST_CHECKED;
	m_bVisibleStatusBar = IsDlgButtonChecked(IDC_CHK_STATUSBAR) == BST_CHECKED;
	m_nLeftMargin = SendDlgItemMessage(IDC_SPIN_LEFTMARGIN, UDM_GETPOS, 0, 0L);
	m_nTopMargin = SendDlgItemMessage(IDC_SPIN_TOPMARGIN, UDM_GETPOS, 0, 0L);

	CPropertyPage::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CViewOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	// Rg[̐ݒ
	SendDlgItemMessage(IDC_SPIN_LEFTMARGIN, UDM_SETRANGE, 0, MAKELONG(99, 0));
	SendDlgItemMessage(IDC_SPIN_TOPMARGIN, UDM_SETRANGE, 0, MAKELONG(99, 0));

	CheckDlg2StateButton(IDC_CHK_TOOLBAR, m_bVisibleToolbar);
	CheckDlg2StateButton(IDC_CHK_STATUSBAR, m_bVisibleStatusBar);
	SendDlgItemMessage(IDC_SPIN_LEFTMARGIN, UDM_SETPOS, 0, m_nLeftMargin);
	SendDlgItemMessage(IDC_SPIN_TOPMARGIN, UDM_SETPOS, 0, m_nTopMargin);

	CheckRadioButton(IDC_RADIO_USEDEFAULT, IDC_RADIO_USESPECIFIED, IDC_RADIO_USEDEFAULT + m_nStartupWindowPos);
	SendDlgItemMessage(IDC_SPIN_WINDOWLEFT, UDM_SETPOS, 0, m_rectSpecifiedWindow.left);
	SendDlgItemMessage(IDC_SPIN_WINDOWTOP, UDM_SETPOS, 0, m_rectSpecifiedWindow.top);
	SendDlgItemMessage(IDC_SPIN_WINDOWWIDTH, UDM_SETPOS, 0, m_rectSpecifiedWindow.right - m_rectSpecifiedWindow.left);
	SendDlgItemMessage(IDC_SPIN_WINDOWHEIGHT, UDM_SETPOS, 0, m_rectSpecifiedWindow.bottom - m_rectSpecifiedWindow.top);

	return true;
}


// CStyleOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CPropertyPage::OnCommand
bool CStyleOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if((wID == IDC_LIST_COLORS && wNotifyCode == LBN_SELCHANGE)
			|| (wID == IDC_COMBO_STYLENAMES && wNotifyCode == CBN_SELCHANGE)) {
		::InvalidateRect(GetDlgItem(IDC_STATIC_1), 0, true);
		int	iCurrentStyle = SendDlgItemMessage(IDC_COMBO_STYLENAMES, CB_GETCURSEL, 0, 0L);
		int	iTextType = SendDlgItemMessage(IDC_LIST_COLORS, LB_GETCURSEL, 0, 0L);
		SendDlgItemMessage(IDC_COMBO_UNDERLINE, CB_SETCURSEL,
			m_vecDocStyles[iCurrentStyle].arrTfs[iTextType].underline, 0L);
		return true;
	}
	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CPropertyPage::OnDrawItem
void CStyleOptionDlg::OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem) {
	if(idCtrl == IDC_STATIC_1) {	// [Tv] ̃I[i[`
		int			iCurrentStyle = SendDlgItemMessage(IDC_COMBO_STYLENAMES, CB_GETCURSEL, 0, 0L);
		int			iTextType = SendDlgItemMessage(IDC_LIST_COLORS, LB_GETCURSEL, 0, 0L);
		CMinimalDC	oDC;
		HPEN		hOldPen;
		HBRUSH		hOldBrush;
		HFONT		hOldFont;

		if(iTextType == LB_ERR)
			return;

		oDC.Attach(lpDrawItem->hDC);

		COLORREF	clrFore = m_vecDocStyles[iCurrentStyle].arrTfs[iTextType].fgColor;
		COLORREF	clrBack = m_vecDocStyles[iCurrentStyle].arrTfs[iTextType].bgColor;
		if(clrFore == -1) {
			switch(iTextType) {
			case TT_NORMAL:
				clrFore = ::GetSysColor(COLOR_WINDOWTEXT);
				break;
			case TT_SELECTION:
				clrFore = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
				break;
			case TT_INACTIVESELECTION:
				clrFore = ::GetSysColor(COLOR_INACTIVECAPTIONTEXT);
				break;
			default:
				clrFore = (m_vecDocStyles[iCurrentStyle].arrTfs[TT_NORMAL].fgColor != -1) ?
					m_vecDocStyles[iCurrentStyle].arrTfs[TT_NORMAL].fgColor : ::GetSysColor(COLOR_WINDOWTEXT);
			}
		}
		if(clrBack == -1) {
			switch(iTextType) {
			case TT_NORMAL:
				clrBack = ::GetSysColor(COLOR_WINDOW);
				break;
			case TT_SELECTION:
				clrBack = ::GetSysColor(COLOR_HIGHLIGHT);
				break;
			case TT_INACTIVESELECTION:
				clrBack = ::GetSysColor(COLOR_INACTIVECAPTION);
				break;
			default:
				clrBack = (m_vecDocStyles[iCurrentStyle].arrTfs[TT_NORMAL].bgColor != -1) ?
					m_vecDocStyles[iCurrentStyle].arrTfs[TT_NORMAL].bgColor : ::GetSysColor(COLOR_WINDOW);
			}
		}

		CPen	oBorderPen(PS_SOLID, 1, ::GetSysColor(COLOR_3DDKSHADOW));
		CBrush	oBgBrush(clrBack);
		CFont	oFont;
		LOGFONT	lf;

		::GetObject(GetFont(), sizeof(LOGFONT), &lf);
		lf.lfWeight = m_vecDocStyles[iCurrentStyle].arrTfs[iTextType].bold ? FW_BOLD : FW_NORMAL;
		lf.lfItalic = m_vecDocStyles[iCurrentStyle].arrTfs[iTextType].italic;
		lf.lfUnderline = false;
		oFont.CreateFontIndirect(lf);
		hOldPen = oDC.SelectObject(oBorderPen);
		hOldBrush = oDC.SelectObject(oBgBrush);
		hOldFont = oDC.SelectObject(oFont);
		oDC.Rectangle(&lpDrawItem->rcItem);

		oDC.SetTextColor(clrFore);
		oDC.SetBkMode(TRANSPARENT);
		oDC.TextOut(75, 12, L"AaBbCcXxYyZz", 12);

		oDC.SelectObject(hOldPen);
		oDC.SelectObject(hOldBrush);
		oDC.SelectObject(hOldPen);
		oDC.Detach();
	}
}

///	@see	CPropertyPage::OnInitDialog
bool CStyleOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	HWND		hwndColorsListBox = GetDlgItem(IDC_LIST_COLORS);
	HWND		hUnderlineCombo = GetDlgItem(IDC_COMBO_UNDERLINE);

	// [X^C]
	for(unsigned int iStyle = 0; iStyle < m_vecDocStyles.size(); ++iStyle)
		SendDlgItemMessage(IDC_COMBO_STYLENAMES,
			CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(m_vecDocStyles[iStyle].strName.c_str()));
	SendDlgItemMessage(IDC_COMBO_STYLENAMES, CB_SETCURSEL, 0, 0L);

	// [\]
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"eLXg"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"IꂽeLXg"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"IꂽANeBułȂeLXg"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CWP[^ }[W"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"sԍ"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ԍ (ps)"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"sԍ"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"󔒕"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"s}[N"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"pl"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"dp"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"dp"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"L[[h1"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"L[[h2"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"Rg"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ʎq"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"Zq"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ʂ̈v"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"݂̃R[hy[Wɖ"));
	::SendMessage(hwndColorsListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"EOF }[N"));
	::SendMessage(hwndColorsListBox, LB_SETCURSEL, 0, 0L);

	// []
	::SendMessage(hUnderlineCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L""));
	::SendMessage(hUnderlineCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L""));
	::SendMessage(hUnderlineCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"j"));
	::SendMessage(hUnderlineCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"_"));
	::SendMessage(hUnderlineCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"g"));

	OnCommand(IDC_COMBO_STYLENAMES, CBN_SELCHANGE, GetDlgItem(IDC_COMBO_STYLENAMES));

	return true;
}


// CKeyBindsOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CKeyBindsOptionDlg::CKeyBindsOptionDlg(Alpha::CAlphaApp* pApp, Alpha::CKeyboardMap* pKeyboardMap)
		: m_pApp(pApp), m_pKeyboardMap(pKeyboardMap) {
	assert(m_pApp != 0 && m_pKeyboardMap != 0);
}

///	@see	CDialog::OnCommand
bool CKeyBindsOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_KEYS && wNotifyCode == LBN_SELCHANGE
			|| wID == IDC_CHK_SHIFT
			|| wID == IDC_CHK_CTRL
			|| wID == IDC_CHK_ALT) {
		HWND	hwndKeyListBox = GetDlgItem(IDC_LIST_KEYS);
		int		iKey = ::SendMessage(hwndKeyListBox, LB_GETCURSEL, 0, 0L);
		short	sVKey = static_cast<short>(::SendMessage(hwndKeyListBox, LB_GETITEMDATA, iKey, 0L));
		unsigned int			nCommand;
		Alpha::KeyModifier	km = static_cast<Alpha::KeyModifier>(0);

		if(IsDlgButtonChecked(IDC_CHK_SHIFT) == BST_CHECKED)
			km = static_cast<Alpha::KeyModifier>(km | KM_SHIFT);
		if(IsDlgButtonChecked(IDC_CHK_CTRL) == BST_CHECKED)
			km = static_cast<Alpha::KeyModifier>(km | KM_CTRL);
		if(IsDlgButtonChecked(IDC_CHK_ALT) == BST_CHECKED)
			km = static_cast<Alpha::KeyModifier>(km | KM_ALT);
		nCommand = m_pKeyboardMap->GetCommandID(sVKey, km);
		if(nCommand != 0) {
			wchar_t	wszCommandName[100];
			if(0 != m_pApp->LoadString(nCommand, wszCommandName, 100)) {
				wchar_t*	pwszNameEnd = wcschr(wszCommandName, L'(');
				if(pwszNameEnd != 0)
					*pwszNameEnd = 0;
				SetDlgItemText(IDC_EDIT_BOUNDCOMMAND, wszCommandName);
			} else
				SetDlgItemText(IDC_EDIT_BOUNDCOMMAND, L"(R}h ID sł)");
		} else
			SetDlgItemText(IDC_EDIT_BOUNDCOMMAND, L"(蓖ĂĂ܂)");
	} else if(wID == IDOK) {	// [蓖]
		return true;
	} else if(wID == IDCANCEL) {	// []
		return true;
	}

	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnDestroy
void CKeyBindsOptionDlg::OnDestroy() {
	CPropertyPage::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CKeyBindsOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	HWND			hwndCommandTree = GetDlgItem(IDC_TREE_COMMANDS);
	HWND			hwndKeyListBox = GetDlgItem(IDC_LIST_KEYS);
	TVINSERTSTRUCTW	tvis;
	wchar_t			wszCommandName[100];
	wchar_t*		pwszNameEnd;
	int				iCommand = IDCM_FILE_NEW;
	const wchar_t*	pwszKeyName = 0;
	int				iInserted;
	wchar_t*		arrCategoryName[7] = {
		L"t@C", L"ҏW", L"", L"\", L"fobO", L"c[", L"wv"
	};

	// [R}h] c[̏
	ZeroMemory(&tvis, sizeof(TVINSERTSTRUCTW));
	tvis.hInsertAfter = TVI_LAST;
	tvis.item.mask = TVIF_PARAM | TVIF_TEXT;
	tvis.item.pszText = wszCommandName;

	for(short iCategory = 0; iCategory < 7; ++iCategory) {
		tvis.hParent = TVI_ROOT;
		tvis.item.lParam = -1;
		wcscpy(wszCommandName, arrCategoryName[iCategory]);
		tvis.hParent = TreeView_InsertItem(hwndCommandTree, &tvis);
		for(; iCommand < IDCM_FILE_NEW + 32 * (iCategory + 1); ++iCommand) {
			if(0 == m_pApp->LoadString(iCommand, wszCommandName, 100))
				continue;
			pwszNameEnd = wcschr(wszCommandName, L'(');
			if(pwszNameEnd != 0)
				*pwszNameEnd = 0;
			tvis.item.lParam = iCommand;
			TreeView_InsertItem(hwndCommandTree, &tvis);
		}
	}

	// [蓖ĉ\ȃL[] Xg{bNX̏
	for(short iVKey = 0x00; iVKey <= 0xFF; ++iVKey) {
		pwszKeyName = Alpha::CKeyboardMap::GetKeyName(iVKey);
		if(pwszKeyName != 0) {
			iInserted = ::SendMessage(hwndKeyListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszKeyName));
			::SendMessage(hwndKeyListBox, LB_SETITEMDATA, iInserted, iVKey);
		}
	}
	::SendMessage(hwndKeyListBox, LB_SETCURSEL, 0, 0L);

	return true;
}

///	@see	CDialog::OnNotify
bool CKeyBindsOptionDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_TREE_COMMANDS && lpNMHDR->code == TVN_SELCHANGED) {
		LPNMTREEVIEW	lpNMTS = reinterpret_cast<LPNMTREEVIEW>(lpNMHDR);

		// ݒ\
		if(lpNMTS->itemNew.lParam == 0 || lpNMTS->itemNew.lParam == -1)	// 蓖ĕs\Ȃ̂蓖Ă̖
			SetDlgItemText(IDC_EDIT_BOUNDKEY, L"(蓖ĂĂ܂)");
		else {
			short				sVKey;
			Alpha::KeyModifier	km;
			HWND				hwndKeysListBox;
			int					cKeys;

			SetDlgItemText(IDC_EDIT_BOUNDKEY, m_pKeyboardMap->GetKeyString(lpNMTS->itemNew.lParam).c_str());
			if(m_pKeyboardMap->GetKeyBind(lpNMTS->itemNew.lParam, sVKey, km)) {
				CheckDlg2StateButton(IDC_CHK_SHIFT, toBoolean(km & KM_SHIFT));
				CheckDlg2StateButton(IDC_CHK_CTRL, toBoolean(km & KM_CTRL));
				CheckDlg2StateButton(IDC_CHK_ALT, toBoolean(km & KM_ALT));
				hwndKeysListBox = GetDlgItem(IDC_LIST_KEYS);
				cKeys = ::SendMessage(hwndKeysListBox, LB_GETCOUNT, 0, 0L);
				for(int iKey = 0; iKey < cKeys; ++iKey) {
					if(sVKey == ::SendMessage(hwndKeysListBox, LB_GETITEMDATA, iKey, 0L)) {
						::SendMessage(hwndKeysListBox, LB_SETCURSEL, iKey, 0L);
						break;
					}
				}
			}
		}

		::EnableWindow(GetDlgItem(IDC_LIST_KEYS), lpNMTS->itemNew.lParam != -1);
		::EnableWindow(GetDlgItem(IDC_CHK_SHIFT), lpNMTS->itemNew.lParam != -1);
		::EnableWindow(GetDlgItem(IDC_CHK_CTRL), lpNMTS->itemNew.lParam != -1);
		::EnableWindow(GetDlgItem(IDC_CHK_ALT), lpNMTS->itemNew.lParam != -1);
		::EnableWindow(GetDlgItem(IDOK), lpNMTS->itemNew.lParam != -1);
		::EnableWindow(GetDlgItem(IDCANCEL), lpNMTS->itemNew.lParam != -1);

		OnCommand(IDC_LIST_KEYS, LBN_SELCHANGE, 0);
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}


// CScriptOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CScriptOptionDlg::CScriptOptionDlg(Alpha::CScriptLanguageManager* pScriptLanguageManager)
		: m_pScriptLanguageManager(pScriptLanguageManager) {
	assert(m_pScriptLanguageManager != 0);
}

///	@see	CPropertyPage::OnInitDialog
bool CScriptOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	CWaitCursor	wc;

	HWND		hScriptEnginesList = GetDlgItem(IDC_LIST_SCRIPTENGINES);
	LVCOLUMNW	column;
	LVITEMW		item;
	
	ListView_SetExtendedListViewStyle(hScriptEnginesList, LVS_EX_FULLROWSELECT);
	column.mask = LVCF_TEXT | LVCF_WIDTH;
	column.pszText = L"";
	column.cx = 100;
	ListView_InsertColumn(hScriptEnginesList, 0, &column);
	column.pszText = L"gq";
	column.cx = 54;
	ListView_InsertColumn(hScriptEnginesList, 1, &column);
	column.pszText = L"CLSID";
	column.cx = 260;
	ListView_InsertColumn(hScriptEnginesList, 2, &column);

	ZeroMemory(&item, sizeof(LVITEM));
	item.mask = LVIF_TEXT;
	set<wstring>	setLanguages = m_pScriptLanguageManager->GetLanguages();
	set<wstring>	setExtensions;
	wstring			strExtensions;
	wstring			strNotation;	// [ڍ] ɕ\e

	for(set<wstring>::const_iterator it = setLanguages.begin(); it != setLanguages.end(); ++it, ++item.iItem) {
		item.pszText = const_cast<wchar_t*>(it->c_str());
		ListView_InsertItem(hScriptEnginesList, &item);
		setExtensions = m_pScriptLanguageManager->GetExtensionNames(*it);
		strExtensions.erase();
		for(set<wstring>::const_iterator itExts = setExtensions.begin(); itExts != setExtensions.end(); ++itExts)
			strExtensions += *itExts + L",";
		if(!strExtensions.empty())
			strExtensions.erase(strExtensions.length() - 1);
		item.pszText = const_cast<wchar_t*>(strExtensions.c_str());
		++item.iSubItem;
		ListView_SetItem(hScriptEnginesList, &item);
		if(m_pScriptLanguageManager->GetCLSID(*it) != CLSID_NULL) {
			::StringFromCLSID(m_pScriptLanguageManager->GetCLSID(*it), &item.pszText);
			++item.iSubItem;
			ListView_SetItem(hScriptEnginesList, &item);
			strNotation.erase();
			strNotation = L"ProgID ɊÂꖼ: " + *it
				+ L"\r\nAlpha ŔFgq: " + strExtensions
				+ L"\r\nGW CLSID: " + item.pszText
				+ L"\r\nXNvg̎sƉ: T|[gĂ܂\r\nXNvg̃fobO: ";
			strNotation	+= CScriptLanguageManager::QueryDebuggable(*it) ? L"T|[gĂ܂" : L"T|[gĂ܂";
			::CoTaskMemFree(item.pszText);
		} else {
			strNotation = item.pszText = L"(ꖼȂCXg[Ă܂)";
			++item.iSubItem;
			ListView_SetItem(hScriptEnginesList, &item);
		}
		m_vecNotations.push_back(strNotation);
		item.iSubItem = 0;
	}

	return true;
}

///	@see	CPropertyPage::OnNotify
bool CScriptOptionDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_SCRIPTENGINES
			&& lpNMHDR->code == LVN_ITEMCHANGED
			&& toBoolean(reinterpret_cast<LPNMLISTVIEW>(lpNMHDR)->uNewState & LVIS_SELECTED)) {
		SetDlgItemText(IDC_EDIT_OUTPUT,
			m_vecNotations[reinterpret_cast<LPNMLISTVIEW>(lpNMHDR)->iItem].c_str());
	}
	return CPropertyPage::OnNotify(idCtrl, lpNMHDR);
}


/* [EOF] */