// EditViewCommands.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "..\..\Manah\win_utils.h"
#include "..\..\Manah\WaitCursor.h"
using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Text;


///	CMDID_EDIT_BACKSPACE
void CEditView::CmdEditBackspace() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	GetDocument()->EndEditCollection();
	if(HasSelection())
		m_pActivePoint->Delete(*m_pAnchorPoint);
	else	// IȂꍇ1ÕR[h|Cg폜
		m_pActivePoint->Delete(-1);
	m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
	m_pAnchorPoint->EnsureVisible();
	OnMoveCaret();
	m_eoLast.set(EOT_DELETE, *m_pActivePoint);

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->UpdateListCursel();
}

///	CMDID_EDIT_BREAK
void CEditView::CmdEditBreak() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	if(HasSelection()) {
		GetDocument()->BeginEditCollection();
		m_pActivePoint->Delete(*m_pAnchorPoint);
		m_pActivePoint->NewLine();
		GetDocument()->EndEditCollection();
		m_eoLast.set(EOT_REPLACE, *m_pActivePoint);
	} else {
		GetDocument()->EndEditCollection();
		m_pActivePoint->NewLine();
		m_eoLast.set(EOT_TYPING, *m_pActivePoint);
	}
	m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
	m_pAnchorPoint->EnsureVisible();
	OnMoveCaret();
}

/**
 *	CMDID_EDIT_CHAR
 *	@param nCodePoint	͂镶̃R[h|Cg
 */
void CEditView::CmdEditChar(unsigned long nCodePoint) {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	wchar_t	wsz[3];
	bool	bDoneSmartIndent = false;

	// ASCII 䕶͖ ( TAB ȊO)
	if(nCodePoint <= 0xFF && nCodePoint != 0x09
			&& toBoolean(iscntrl(static_cast<int>(nCodePoint)))) {
//		::MessageBeep(MB_OK);
		return;
	}

	if(nCodePoint == 0x0009) {	// [Tab]
		if(HasSelection())
			CmdEditTabIndent(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000));
		else {
			InsertText(L"\t");
			m_eoLast.set(EOT_TYPING, *m_pActivePoint);
		}
	} else if(nCodePoint == 0x0020) {	// [Space]
		if(HasSelection())
			CmdEditSpaceIndent(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000));
		else {
			InsertText(L" ");
			m_eoLast.set(EOT_TYPING, *m_pActivePoint);
		}
	} else {
		if(nCodePoint < 0x010000) {
			wsz[0] = CEditView::ConvertCharacter(
				static_cast<wchar_t>(nCodePoint), m_nccNextCharConvert);
			wsz[1] = 0;
		} else if(EncodeCodePointToUTF16SurrogatePair(nCodePoint, wsz))
			wsz[2] = 0;
		else
			wsz[1] = 0;
		if(HasSelection()) {
//			if(!m_ModeState.bSmartIndent || !SmartIndent(nCodePoint))
				ReplaceSel(wsz);
			m_eoLast.set(EOT_REPLACE, *m_pActivePoint);
		} else {
			if(m_eoLast.type != EOT_TYPING
					|| m_eoLast.pos != *m_pActivePoint
					|| !CEditView::IsIdentifierContinueChar(nCodePoint))
				GetDocument()->BeginEditCollection();
			if(m_ModeState.bOvertype) {
				m_pActivePoint->DestructiveInsert(wsz);
				m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
				ValidateCaretPos();
			} else
				InsertText(wsz);
//			GetDocument()->EndEditCollection();
			m_eoLast.set(EOT_TYPING, *m_pActivePoint);
		}
	}

	m_pAnchorPoint->EnsureVisible();
	if(m_pwndAutoComplete->IsWindowVisible()) {
		++m_AutoComplete.iStartChar;
		m_pwndAutoComplete->UpdateListCursel();
	}
}

///	CMDID_EDIT_CONVERTSEL
void CEditView::CmdEditConvertSel(SelConvertType sct) {
	AssertValidAsWindow();

	wstring		strSelection = GetSelection();
	size_t		cchSelection = strSelection.length();
	wchar_t*	pwszSelection = new wchar_t[cchSelection + 1];

	strSelection.copy(pwszSelection, cchSelection);
	pwszSelection[cchSelection] = 0;

	if(sct == SCT_CAPITALIZE) {
		size_t	i = 0;
		while(i < cchSelection) {
			size_t	cchWord = IsIdentifier(pwszSelection + i, cchSelection - i);
			size_t	cchHead = ((cchWord > 1)
						&& IsUTF16HighSurrogate(pwszSelection[i])
						&& IsUTF16LowSurrogate(pwszSelection[i + 1])) ? 2 : 1;
			::CharUpperBuffW(pwszSelection + i, cchHead);
			if(cchWord > 1)
				::CharLowerBuffW(pwszSelection + i + cchHead, cchWord - cchHead);
			i += std::max<size_t>(cchWord, 1);
		}
	} else if(sct == SCT_LOWERCASE) 
		::CharLowerBuffW(pwszSelection, cchSelection);
	else if(sct == SCT_UPPERCASE)
		::CharUpperBuffW(pwszSelection, cchSelection);
	ReplaceSel(pwszSelection, m_ModeState.bBoxSelecting);
}

///	CMDID_EDIT_COPY
void CEditView::CmdEditCopy() {
	AssertValidAsWindow();
	CWaitCursor	wc;

	if(!HasSelection())
		return;

	wstring	strSelection = GetSelection();

	if(!m_ModeState.bBoxSelecting)
		CClipboard::SetClipboardText(m_hWnd, strSelection.c_str());
	else {	// `I
		wchar_t*		pwszSelection;
		char*			pszData;
		unsigned int	nClipFormat;

		// Nbv{[hɓ]
		HGLOBAL	hGlobal = 0;
		if(!::OpenClipboard(m_hWnd))
			return;

		hGlobal = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, (strSelection.length() + 1) * sizeof(wchar_t));
		pszData = reinterpret_cast<char*>(::GlobalLock(hGlobal));
		::WideCharToMultiByte(CP_ACP, 0, strSelection.c_str(), -1, pszData, strSelection.length() * 2, 0, 0);
		::GlobalUnlock(hGlobal);
		::SetClipboardData(CF_TEXT, hGlobal);
		pwszSelection = reinterpret_cast<wchar_t*>(::GlobalLock(hGlobal));
		wcscpy(pwszSelection, strSelection.c_str());
		::GlobalUnlock(hGlobal);
		::SetClipboardData(CF_UNICODETEXT, hGlobal);
		nClipFormat = ::RegisterClipboardFormat(L"MSDEVColumnSelect");
		if(nClipFormat != 0) {
			hGlobal = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, 1);
			pszData = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			pszData[0] = 0;
			::GlobalUnlock(hGlobal);
			::SetClipboardData(nClipFormat, hGlobal);
		}
		::CloseClipboard();
	}

	// Nbv{[hOɂ]
	m_oClipboardRing.Add(strSelection, m_ModeState.bBoxSelecting);
}

///	CMDID_EDIT_CUT
void CEditView::CmdEditCut() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	if(HasSelection()) {
		CmdEditCopy();
		DeleteSel();
		m_eoLast.set(EOT_DELETE, *m_pActivePoint);
	}
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	uI͈͂1̕폜v̎sP
void CEditView::CmdEditDelete() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	if(HasSelection())
		DeleteSel();
	else {	// IȂꍇ1̕폜
		m_pActivePoint->Delete(1);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		OnMoveCaret();
	}
	m_eoLast.set(EOT_DELETE, *m_pActivePoint);

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->UpdateListCursel();
}

///	CMDID_EDIT_DELETELINE
void CEditView::CmdEditDeleteLine() {
	AssertValidAsWindow();

	CEditDoc*	pDoc = GetDocument();

	if(pDoc->IsReadOnly())
		return;
	if(HasSelection()) {
		CmdEditDelete();
		return;
	}

	if(m_pActivePoint->m_iLine != pDoc->GetLineCount() - 1) {
		unsigned long	iChar;
		unsigned long	cx = PosFromChar(*m_pActivePoint).x
							+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth()
							- m_layoutInfo.nLeftTabWidth;

		iChar = CharFromPixel(m_pActivePoint->m_iLine + 1, cx, true);
		pDoc->DeleteText(this,
			CCharPos(m_pActivePoint->m_iLine, 0), CCharPos(m_pActivePoint->m_iLine + 1, 0));
		SetSelWithoutSelection(m_pActivePoint->m_iLine, iChar);
	} else	// ŏIs̏ꍇ
		pDoc->DeleteText(this,
			CCharPos(m_pActivePoint->m_iLine, 0), CCharPos(m_pActivePoint->m_iLine, -1));
}

///	CMDID_EDIT_DELETETONEXTWORD
void CEditView::CmdEditDeleteToNextWord() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(m_ModeState.bBoxSelecting) {
		CmdEditDelete();
		return;
	}

	CCharPos	pos = m_pBoundarySearcher->SearchWordBoundary(*m_pActivePoint, true, false);

	if(pos != *m_pActivePoint) {
		m_pActivePoint->MoveToPoint(pos);
		DeleteSel();
	}
}

///	CMDID_EDIT_DELETETOPREVWORD
void CEditView::CmdEditDeleteToPrevWord() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(m_ModeState.bBoxSelecting) {
		CmdEditDelete();
		return;
	}

	CCharPos	pos = m_pBoundarySearcher->SearchWordBoundary(*m_pActivePoint, false, false);

	if(pos != *m_pActivePoint) {
		m_pActivePoint->MoveToPoint(pos);
		DeleteSel();
	}
}

///	CMDID_EDIT_INSERTPREVLINE
void CEditView::CmdEditInsertPrevLine() {
	const CCharPos&	posTop = GetSelTopPoint();

	if(posTop.m_iLine != 0)
		SetSelWithoutSelection(posTop.m_iLine - 1, -1);
	else
		SetSelWithoutSelection(0, 0);
	CmdEditBreak();
}

///	CMDID_EDIT_OPENCANDIDATEWINDOW
void CEditView::CmdEditOpenCandidateWindow() {
	POINT	ptClient, ptScreen;		// Jbgʒu
	CRect	rect;					// NCAg̈

	if(HasSelection()) {	// Iꍇ͉邾
		SetSelWithoutSelection(*m_pActivePoint);
		return;
	}
	if(GetDocument()->IsReadOnly())
		return;

	// O
	if(m_pwndAutoComplete->GetWordCount() == 0) {
		::MessageBeep(MB_OK);
		return;
	}
	
	// l̐ݒ
	m_AutoComplete.iCurrentLine = m_pActivePoint->m_iLine;
	m_AutoComplete.iStartChar = m_pActivePoint->m_iChar;
	m_AutoComplete.iStartWordStart = m_AutoComplete.iStartChar - GetPrecedingWord(50).length();
	m_pwndAutoComplete->UpdateListCursel();

	// ʒu (܂sS)
	::GetCaretPos(&ptClient);
	ptScreen = ptClient;
	ClientToScreen(&ptScreen);
	GetClientRect(&rect);
	m_pwndAutoComplete->MoveWindow((rect.right - ptClient.x > 170) ? ptScreen.x : ptScreen.x - 170,
		(rect.bottom - ptClient.y > (rect.Height()) / 3) ?
			ptScreen.y + m_layoutInfo.nLineHeight : ptScreen.y - (rect.Height()) / 3,
		170, (rect.bottom - rect.top) / 3, false);
//	m_pwndAutoComplete->AnimateWindow(200, AW_SLIDE | AW_VER_POSITIVE);
	m_pwndAutoComplete->ShowWindow(SW_SHOW);
}

///	CMDID_EDIT_PASTE
void CEditView::CmdEditPaste() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	GetDocument()->BeginEditCollection();
	m_pActivePoint->Paste(*m_pAnchorPoint);
	GetDocument()->EndEditCollection();
	m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
	OnMoveCaret();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_EDIT_RECOMPOSE
void CEditView::CmdEditRecomposeSelection() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(!HasSelection() || m_ModeState.bBoxSelecting)
		return;

//	if(*m_pAnchorPoint < *m_pActivePoint)
//		std::swap(*m_pAnchorPoint, *m_pActivePoint);

	HIMC			hImc = ::ImmGetContext(m_hWnd);
	const wstring	strSelection = GetSelection();

	::ImmSetCompositionStringW(hImc, SCS_SETSTR,
		const_cast<wchar_t*>(strSelection.c_str()), strSelection.length() * 2, 0, 0);
	::ImmNotifyIME(hImc, NI_COMPOSITIONSTR, CPS_CONVERT, 0);
	::ImmNotifyIME(hImc, NI_OPENCANDIDATE, CPS_CONVERT, 0);
	::ImmReleaseContext(m_hWnd, hImc);

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_EDIT_REDO
void CEditView::CmdEditRedo() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	CWaitCursor();
	InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
	GetDocument()->Redo();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_EDIT_SETNEXTINPUTCONVERT
void CEditView::CmdEditSetNextInputConvert(NextCharConvert n) {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	m_nccNextCharConvert = n;
}

/**
 *	CMDID_EDIT_SPACEINDENT
 *	@param bReverse	tXy[XCfĝƂ true
 *	@param nLevel	Cfgx
 */
void CEditView::CmdEditSpaceIndent(bool bReverse /* = false */, unsigned short nLevel /* = 1 */) {
	AssertValidAsWindow();

	CEditDoc*	pDocument = GetDocument();
	CCharPos	posAnchorResult;

	if(pDocument->IsReadOnly())
		return;

	m_nccNextCharConvert = NCC_NONE;	// ɖ߂
	pDocument->BeginEditCollection();
	posAnchorResult = m_pActivePoint->SpaceIndent(*m_pAnchorPoint, nLevel * (bReverse ? -1 : 1));
	pDocument->EndEditCollection();
	m_pAnchorPoint->MoveToPoint(posAnchorResult);
	OnMoveCaret();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_EDIT_TABINDENT
 *	@param bReverse	t^uCfĝƂ true
 *	@param nLevel	Cfgx
 */
void CEditView::CmdEditTabIndent(bool bReverse /* = false */, unsigned short nLevel /* = 1 */) {
	AssertValidAsWindow();

	CEditDoc*	pDocument = GetDocument();
	CCharPos	posAnchorResult;

	if(pDocument->IsReadOnly())
		return;

	m_nccNextCharConvert = NCC_NONE;	// ɖ߂
	pDocument->BeginEditCollection();
	Freeze();
	posAnchorResult = m_pActivePoint->TabIndent(*m_pAnchorPoint, nLevel * (bReverse ? -1 : 1));
	pDocument->EndEditCollection();
	Unfreeze();
	m_pAnchorPoint->MoveToPoint(posAnchorResult);
	OnMoveCaret();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_EDIT_TABIFY
void CEditView::CmdEditTabify(bool bRevoke /* = false */) {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	m_pActivePoint->Convert(*m_pAnchorPoint, bRevoke ? RCT_UNTABIFY : RCT_TABIFY);
}

///	CMDID_EDIT_TEXT
void CEditView::CmdEditText(const wchar_t* pwszText) {
	assert(pwszText != 0);
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);

	if(m_ModeState.bOvertype && !HasSelection())	// ㏑[h̏ꍇ (K)
		SetSel(*m_pAnchorPoint,
			CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar + wcslen(pwszText)),
			false, false);

	if(HasSelection()) {
		ReplaceSel(pwszText);
		m_eoLast.set(EOT_REPLACE, *m_pActivePoint);
	} else {
		InsertText(pwszText);
		m_eoLast.set(EOT_TYPING, *m_pActivePoint);
	}
}

///	CMDID_EDIT_TOGGLECHARCODEPOINT
void CEditView::CmdEditToggleCharCodePoint() {
	AssertValidAsWindow();

	CCharPos	posBottom = std::max(*m_pAnchorPoint, *m_pActivePoint);
	
	if(posBottom.m_iChar != 0) {	// ݈ʒusłȂ
		const wchar_t*	pwszLine = GetDocument()->GetLine(posBottom.m_iLine).c_str();

		if(!toBoolean(iswxdigit(pwszLine[posBottom.m_iChar - 1]))) {	//  -> R[h|Cg
			unsigned long	nCodePoint;
			wchar_t			wszCodePoint[7];
			if(posBottom.m_iChar > 1
					&& IsUTF16HighSurrogate(pwszLine[posBottom.m_iChar - 2])
					&& IsUTF16LowSurrogate(pwszLine[posBottom.m_iChar - 1]))
				nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pwszLine + posBottom.m_iChar - 2, 2);
			else
				nCodePoint = pwszLine[posBottom.m_iChar - 1];
			swprintf(wszCodePoint, L"%lX", nCodePoint);
			SetSel(CCharPos(posBottom.m_iLine,
				posBottom.m_iChar - ((nCodePoint > 0xFFFF) ? 2 : 1)), posBottom, false, false);
			ReplaceSel(wszCodePoint, false);
			return;
		} else {	// R[h|Cg -> 
			unsigned long	i = posBottom.m_iChar - 1;
			unsigned long	nCodePoint;
			wchar_t			wszChar[3] = {0, 0, 0};
			wchar_t			chOrg = pwszLine[posBottom.m_iChar];

			while(i != 0 && posBottom.m_iChar - i < 6) {
				if(!toBoolean(iswxdigit(pwszLine[i - 1])))
					break;
				--i;
			}
			const_cast<wchar_t*>(pwszLine)[posBottom.m_iChar] = 0;
			nCodePoint = wcstoul(pwszLine + i, 0, 16);
			const_cast<wchar_t*>(pwszLine)[posBottom.m_iChar] = chOrg;
			if(nCodePoint < 0x110000) {
				SetSel(CCharPos(posBottom.m_iLine, i), posBottom, false, false);
				if(nCodePoint < 0x010000)
					wszChar[0] = static_cast<wchar_t>(nCodePoint);
				else
					EncodeCodePointToUTF16SurrogatePair(nCodePoint, wszChar);
				ReplaceSel(wszChar, false);
				return;
			}
		}
	}

	// ϊłȂ
	::MessageBeep(MB_OK);
}

///	CMDID_EDIT_TOGGLEIMESTATUS
void CEditView::CmdEditToggleIMEStatus() {
	AssertValidAsWindow();
	HIMC	hImc = ::ImmGetContext(m_hWnd);
	::ImmSetOpenStatus(hImc, !::ImmGetOpenStatus(hImc));
	::ImmReleaseContext(m_hWnd, hImc);
}

///	CMDID_EDIT_TOGGLEOVERTYPEMODE
void CEditView::CmdEditToggleOvertypeMode() {
	AssertValid();
	SetOvertypeMode(!m_ModeState.bOvertype);
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_EDIT_UNDO
void CEditView::CmdEditUndo() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;

	CWaitCursor();
	InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
	GetDocument()->Undo();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	uL[}NL^̒~v̎sP
void CEditView::CmdKeymacroCancel() {
	AssertValid();

	KeyMacroState	kms = m_pKeyMacroPlayer->GetState();

	if(kms == KMS_RECORDING || kms == KMS_PAUSING)
		m_pKeyMacroPlayer->CancelRecording();
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

///	uL[}N̓ǂݍ݁v̎sP
void CEditView::CmdKeymacroLoad(const wstring& strPathName) {
	AssertValid();

	if(m_pKeyMacroPlayer->GetState() != KMS_NONE)
		return;
	m_pKeyMacroPlayer->Load(strPathName);
}

///	uL[}N̋L^ꎞ~/ĊJv̎sP
void CEditView::CmdKeymacroPause() {
	AssertValid();

	KeyMacroState	kms = m_pKeyMacroPlayer->GetState();

	if(kms == KMS_NONE || kms == KMS_PLAYING)
		return;
	m_pKeyMacroPlayer->Pause();
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

///	uL[}N̎sv̎sP
void CEditView::CmdKeymacroPlay() {
	AssertValidAsWindow();

	if(m_pKeyMacroPlayer->GetState() != KMS_NONE)
		return;
	LockWindowUpdate();
	m_pKeyMacroPlayer->Play(*this);
	UnlockWindowUpdate();
	if(0 != m_pEventListener)	// ܂Ƃ߂Ēʒm
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

///	uL[}N̋L^v̎sP
void CEditView::CmdKeymacroRecord() {
	AssertValid();

	if(m_pKeyMacroPlayer->GetState() == KMS_NONE) {
		m_pKeyMacroPlayer->StartRecording(*this);
		if(m_pEventListener != 0)
			m_pEventListener->OnMoveCaret(*m_pActivePoint);
	}
}

///	uL[}N̕ۑv̎sP
void CEditView::CmdKeymacroSave(const wstring& strPathName) {
	AssertValid();

	if(m_pKeyMacroPlayer->GetState() == KMS_NONE)
		m_pKeyMacroPlayer->Save(strPathName);
}

///	uL[}N̋L^~v̎sP
void CEditView::CmdKeymacroStop() {
	AssertValid();

	KeyMacroState	kms = m_pKeyMacroPlayer->GetState();

	if(kms != KMS_RECORDING && kms != KMS_PAUSING)
		return;
	m_pKeyMacroPlayer->StopRecording();
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

///	CMDID_MOVE_CANCELSELECTION
void CEditView::CmdMoveCancelSelection() {
	AssertValidAsWindow();

	if(HasSelection()) {
		unsigned long	iAnchorLineOrg = m_pAnchorPoint->m_iLine;
		unsigned long	iActiveLineOrg = m_pActivePoint->m_iLine;

		m_ModeState.bBoxSelecting = false;
		m_pActivePoint->Normalize();
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		InvalidateLines(iAnchorLineOrg, iActiveLineOrg);
	}
}

/**
 *	CMDID_MOVE_CHARNEXT, CMDID_MOVE_CHARNEXTEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cch		ړ
 */
void CEditView::CmdMoveCharNext(bool bExtend /* = false */, unsigned long cch /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const_cast<CVisibleEditPoint&>(GetSelTopPoint()).MoveToPoint(GetSelBottomPoint());
		m_ModeState.bBoxSelecting = false;
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iTopLineOrg, m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		m_pActivePoint->CharNext(cch);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iTopLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->CharNext(cch);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}

	if(m_AutoComplete.iStartChar < m_pActivePoint->m_iChar
			|| m_AutoComplete.iCurrentLine != m_pActivePoint->m_iLine)
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_MOVE_CHARPREV, CMDID_MOVE_CHARPREVEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cch		ړ
 */
void CEditView::CmdMoveCharPrev(bool bExtend /* = false */, unsigned long cch /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		const_cast<CVisibleEditPoint&>(GetSelBottomPoint()).MoveToPoint(GetSelTopPoint());
		m_ModeState.bBoxSelecting = false;
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iBottomLineOrg, m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->CharPrev(cch);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iBottomLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->CharPrev(cch);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
	m_pActivePoint->EnsureVisible();

	if(m_AutoComplete.iStartWordStart > m_pActivePoint->m_iChar
			|| m_AutoComplete.iCurrentLine != m_pActivePoint->m_iLine)
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_MOVE_END, CMDID_MOVE_ENDEXTEND
 *	@param bExtend	I͈͂gƂ true
 */
void CEditView::CmdMoveEnd(bool bExtend /* = false */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToEndOfDocument();
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToEndOfDocument();
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iBottomLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->MoveToEndOfDocument();
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

/**
 *	CMDID_MOVE_HOME, CMDID_MOVE_HOMEEXTEND
 *	@param bExtend	I͈͂gƂ true
 */
void CEditView::CmdMoveHome(bool bExtend /* = false */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToStartOfDocument();
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToStartOfDocument();
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iBottomLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->MoveToStartOfDocument();
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

/**
 *	CMDID_MOVE_LINEDOWN, CMDID_MOVE_LINEDOWNEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cLines	ړs (\s)
 */
void CEditView::CmdMoveLineDown(bool bExtend /* = false */, unsigned long cLines /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->LineDown(iBottomLineOrg - m_pActivePoint->m_iLine + cLines);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(iBottomLineOrg != m_pActivePoint->m_iLine)
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->LineDown(cLines);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(posActiveOrg.m_iLine, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->LineDown(cLines);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_MOVE_LINEEND, CMDID_MOVE_LINEENDEXTEND
 *	@param bExtend	I͈͂gƂ true
 */
void CEditView::CmdMoveLineEnd(bool bExtend /* = false */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToEndOfLine();
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
	} else {
		const CCharPos	posActiveOrg = *m_pActivePoint;
		const bool		bHadSelection = HasSelection();
		m_pActivePoint->MoveToEndOfLine();
		if(*m_pActivePoint != posActiveOrg) {
			if(!bExtend)
				m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(bExtend || bHadSelection)
				InvalidateLine(m_pActivePoint->m_iLine);
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

/**
 *	CMDID_MOVE_LINEHOME, CMDID_MOVE_LINEHOMEXTNED
 *	@param bExtend	I͈͂gƂ true
 */
void CEditView::CmdMoveLineHome(bool bExtend /* = false */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->MoveToStartOfLine(true);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
	} else {
		const CCharPos	posActiveOrg = *m_pActivePoint;
		const bool		bHadSelection = HasSelection();
		m_pActivePoint->MoveToStartOfLine(true);
		if(*m_pActivePoint != posActiveOrg) {
			if(!bExtend)
				m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(bExtend || bHadSelection)
				InvalidateLine(m_pActivePoint->m_iLine);
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

/**
 *	CMDID_MOVE_LINEUP, CMDID_MOVE_LINEUPEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cLines	ړs
 */
void CEditView::CmdMoveLineUp(bool bExtend /* = false */, unsigned long cLines /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->LineUp(m_pActivePoint->m_iLine - iTopLineOrg + cLines);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		m_ModeState.bBoxSelecting = false;
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(iTopLineOrg != m_pActivePoint->m_iLine)
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->LineUp(cLines);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(posActiveOrg.m_iLine, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->LineUp(cLines);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_MOVE_MATCHBRACKET, CMDID_MOVE_MATCHBRACKETEXTEND
 *	@param bExtend	I͈͂gƂ true
 */
void CEditView::CmdMoveMatchBracket(bool bExtend /* = false */) {
	AssertValidAsWindow();

	CCharPos	posFound;

	if(FindBracket(*m_pActivePoint, posFound)) {
		if(!bExtend)
			SetSelWithoutSelection(posFound);
		else if(posFound > *m_pActivePoint)
			SetSel(*m_pActivePoint, CCharPos(posFound.m_iLine, posFound.m_iChar + 1));
		else
			SetSel(CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar + 1), posFound);
	} else if(m_pActivePoint->m_iChar != 0
			&& FindBracket(CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1), posFound)) {
		if(!bExtend)
			SetSelWithoutSelection(posFound);
		else if(posFound > CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1))
			SetSel(CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1),
				CCharPos(posFound.m_iLine, posFound.m_iChar + 1));
		else
			SetSel(*m_pActivePoint, posFound);
	} else
		::MessageBeep(MB_OK);	// Ȃ
}

///	CMDID_MOVE_NEXTBOOKMARK
void CEditView::CmdMoveNextBookmark() {
	AssertValidAsWindow();

	unsigned long	iLine;
	unsigned long	cLines = GetDocument()->GetLineCount();

	m_ModeState.bBoxSelecting = false;

	// T
	for(iLine = m_pActivePoint->m_iLine + 1; iLine < cLines; ++iLine) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			SetSelWithoutSelection(iLine, 0);
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = 0; iLine < m_pActivePoint->m_iLine; ++iLine) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			SetSelWithoutSelection(iLine, 0);
			return;
		}
	}
}

/**
 *	CMDID_MOVE_PAGEDOWN, CMDID_MOVE_PAGEDOWNEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cPages	ړy[W
 */
void CEditView::CmdMovePageDown(bool bExtend /* = false */, unsigned long cPages /* = 1 */) {
	AssertValidAsWindow();

	if(cPages == 0)
		return;
	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->PageDown(cPages);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_ModeState.bBoxSelecting = false;
		while(cPages-- != 0)
			OnVScroll(SB_PAGEDOWN, 0, 0);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(iBottomLineOrg != m_pActivePoint->m_iLine)
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->PageDown(cPages);
		while(cPages-- != 0)
			OnVScroll(SB_PAGEDOWN, 0, 0);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(posActiveOrg.m_iLine, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->PageDown(cPages);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			while(cPages-- != 0)
				OnVScroll(SB_PAGEDOWN, 0, 0);
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(posActiveOrg.m_iLine != m_pActivePoint->m_iLine) {
			InvalidateLine(posActiveOrg.m_iLine);
			InvalidateLine(m_pActivePoint->m_iLine);
		}
	}
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	CMDID_MOVE_PAGEUP, CMDID_MOVE_PAGEUPEXTEND
 *	@param bExtend	IgێƂ true
 *	@param cPages	ړy[W
 */
void CEditView::CmdMovePageUp(bool bExtend /* = false */, unsigned long cPages /* = 1 */) {
	AssertValidAsWindow();

	if(cPages == 0)
		return;
	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->PageUp(cPages);
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_ModeState.bBoxSelecting = false;
		while(cPages-- != 0)
			OnVScroll(SB_PAGEUP, 0, 0);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(iTopLineOrg != m_pActivePoint->m_iLine)
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->PageUp(cPages);
		while(cPages-- != 0)
			OnVScroll(SB_PAGEUP, 0, 0);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(posActiveOrg.m_iLine, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->PageUp(cPages);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			while(cPages-- != 0)
				OnVScroll(SB_PAGEUP, 0, 0);
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(posActiveOrg.m_iLine != m_pActivePoint->m_iLine) {
			InvalidateLine(posActiveOrg.m_iLine);
			InvalidateLine(m_pActivePoint->m_iLine);
		}
	}
	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	CMDID_MOVE_PREVBOOKMARK
void CEditView::CmdMovePrevBookmark() {
	AssertValidAsWindow();

	unsigned long	iLine = m_pActivePoint->m_iLine - 1;

	m_ModeState.bBoxSelecting = false;

	// T
	while(true) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			SetSelWithoutSelection(iLine, 0);
			return;
		}
		if(--iLine == 0)
			break;
	}

	// Ȃΐ܂Ԃ
	CEditDoc*	pDoc = GetDocument();
	for(iLine = pDoc->GetLineCount() - 1; iLine > m_pActivePoint->m_iLine; --iLine) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			SetSelWithoutSelection(iLine, 0);
			return;
		}
	}
}

///	CMDID_MOVE_SELECTALL
void CEditView::CmdMoveSelectAll() {
	AssertValidAsWindow();
	m_ModeState.bBoxSelecting = false;
	SetSel(CCharPos(0, 0), CCharPos(-1, -1), true);
}

///	CMDID_MOVE_SELECTCURRENTWORD
void CEditView::CmdMoveSelectCurrentWord() {
	AssertValidAsWindow();

	m_ModeState.bBoxSelecting = false;
	if(m_pActivePoint->IsEndOfLine()) {
		if(m_pActivePoint->IsStartOfLine())
			SetSelWithoutSelection(*m_pActivePoint);
		else
			SetSel(m_pBoundarySearcher->SearchWordBoundary(
				*m_pActivePoint, false, false), *m_pActivePoint);
	} else
		SetSel(m_pBoundarySearcher->SearchWordBoundary(
			CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar + 1), false, false),
			m_pBoundarySearcher->SearchWordBoundary(*m_pActivePoint, true, true));
}

/**
 *	CMDID_MOVE_WORDENDNEXT, CMDID_MOVE_WORDENDNEXTEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cWords	ړꐔ
 */
void CEditView::CmdMoveWordEndNext(bool bExtend /* = false */, unsigned long cWords /* = 1 */) {
	AssertValidAsWindow();

	// TODO: u̒P̏I[Ɉړv
}

/**
 *	CMDID_MOVE_WORDENDPREV, CMDID_MOVE_WORDENDPREVEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cWords	ړꐔ
 */
void CEditView::CmdMoveWordEndPrev(bool bExtend /* = false */, unsigned long cWords /* = 1 */) {
	AssertValidAsWindow();

	// TODO: uO̒P̏I[Ɉړv
}

/**
 *	CMDID_MOVE_WORDNEXT, CMDID_MOVE_WORDNEXTEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cWords	ړꐔ
 */
void CEditView::CmdMoveWordNext(bool bExtend /* = false */, unsigned long cWords /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->WordNext(cWords);
		m_ModeState.bBoxSelecting = false;
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(m_FoundationInfo.bDrawCurrentUnderline
				&& (m_pActivePoint->m_iLine < iTopLineOrg
				|| m_pActivePoint->m_iLine > iBottomLineOrg))
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		m_pActivePoint->WordNext(cWords);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iTopLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->WordNext(cWords);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

/**
 *	CMDID_MOVE_WORDPREV, CMDID_MOVE_WORDPREVEXTEND
 *	@param bExtend	I͈͂gƂ true
 *	@param cch		ړ
 */
void CEditView::CmdMoveWordPrev(bool bExtend /* = false */, unsigned long cWords /* = 1 */) {
	AssertValidAsWindow();

	if(HasSelection() && !bExtend) {	// I
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		const unsigned long	iBottomLineOrg = GetSelBottomPoint().m_iLine;
		m_pActivePoint->WordPrev(cWords);
		m_ModeState.bBoxSelecting = false;
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		InvalidateLines(iTopLineOrg, iBottomLineOrg);
		if(m_FoundationInfo.bDrawCurrentUnderline
				&& (m_pActivePoint->m_iLine < iTopLineOrg
				|| m_pActivePoint->m_iLine > iBottomLineOrg))
			InvalidateLine(m_pActivePoint->m_iLine);
	} else if(bExtend) {	// Ig/쐬
		const CCharPos		posActiveOrg = *m_pActivePoint;
		const unsigned long	iTopLineOrg = GetSelTopPoint().m_iLine;
		m_pActivePoint->WordPrev(cWords);
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
		if(*m_pActivePoint != posActiveOrg)
			InvalidateLines(iTopLineOrg, m_pActivePoint->m_iLine);
	} else {	// ړ
		const CCharPos	posActiveOrg = *m_pActivePoint;
		m_pActivePoint->WordPrev(cWords);
		if(*m_pActivePoint != posActiveOrg) {
			m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& m_pActivePoint->m_iLine != posActiveOrg.m_iLine) {
				InvalidateLine(m_pActivePoint->m_iLine);
				InvalidateLine(posActiveOrg.m_iLine);
			}
		}
		m_pActivePoint->EnsureVisible();
		OnMoveCaret();
	}
}

///	CMDID_SCROLL_COLUMNNEXT
void CEditView::CmdScrollColumnNext() {
	AssertValidAsWindow();
	OnHScroll(SB_LINERIGHT, 0, 0);
}

///	CMDID_SCROLL_COLUMNPREV
void CEditView::CmdScrollColumnPrev() {
	AssertValidAsWindow();
	OnHScroll(SB_LINELEFT, 0, 0);
}

///	CMDID_SCROLL_END
void CEditView::CmdScrollEnd() {
	AssertValidAsWindow();
	OnVScroll(SB_BOTTOM, 0, 0);
}

///	CMDID_SCROLL_ENSURECARETCENTERED
void CEditView::CmdScrollEnsureCaretCentered() {
	AssertValidAsWindow();
	m_pActivePoint->EnsureCentered();
}

///	CMDID_SCROLL_ENSURECARETVISIBLE
void CEditView::CmdScrollEnsureCaretVisible() {
	AssertValidAsWindow();
	m_pActivePoint->EnsureVisible();
}

///	CMDID_SCROLL_HOME
void CEditView::CmdScrollHome() {
	AssertValidAsWindow();
	OnVScroll(SB_TOP, 0, 0);
}

///	CMDID_SCROLL_LINEDOWN
void CEditView::CmdScrollLineDown() {
	AssertValidAsWindow();
	OnVScroll(SB_LINEDOWN, 0, 0);
}

///	CMDID_SCROLL_LINEUP
void CEditView::CmdScrollLineUp() {
	AssertValidAsWindow();
	OnVScroll(SB_LINEUP, 0, 0);
}

///	CMDID_SCROLL_PAGEDOWN
void CEditView::CmdScrollPageDown() {
	AssertValidAsWindow();
	OnVScroll(SB_PAGEDOWN, 0, 0);
}

///	CMDID_SCROLL_PAGEUP
void CEditView::CmdScrollPageUp() {
	AssertValidAsWindow();
	OnVScroll(SB_PAGEUP, 0, 0);
}

/* [EOF] */