// EditView.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "KeywordManager.h"
#include "EditController.h"
#include <limits>	// numeric_limit
#include <algorithm>
#include <zmouse.h>
#include "..\..\Manah\win_utils.h"
#include "..\..\Manah\WaitCursor.h"

#define WC_ASCENSIONVIEW	L"AscensionView"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Text;
using namespace Armaiti;
using namespace std;
using Armaiti::OLE::CDraggingTextDataObject;

#ifdef _DEBUG
CDumpContext	gdc;
#include "..\..\Manah\Timer.h"
#endif


// GlobalElements definition
/////////////////////////////////////////////////////////////////////////////

///	̒r2֐BSetOperators Ŏgp
bool _CompareStringByLength(const wstring& str1, const wstring& str2) {
	return str1.length() > str2.length();
}


// TEditViewFoundationInfo struct implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CEditView::TEditViewFoundationInfo::TEditViewFoundationInfo() : bDrawCurrentUnderline(true),
		bDrawBreakArrow(true), bDrawEOF(true), bDrawSpaces(false),
		bIgnoreCaseOnHilite(false), bPaintBreakContinuingSelection(true),
		bDrawBoldCharsClosely(false),
		strEndOfFile(L"[EOF]"), chTab(L'^'), chIdeographicSpace(L'\x25A1'), chSpace(L'_'),
		pKeywords1(new CKeywordManager), pKeywords2(new CKeywordManager),
		bLockedParsing(false) {
}

///	Rs[RXgN^
CEditView::TEditViewFoundationInfo::TEditViewFoundationInfo(
		const CEditView::TEditViewFoundationInfo& rhs) {
	bDrawCurrentUnderline = rhs.bDrawCurrentUnderline;
	bDrawBreakArrow = rhs.bDrawBreakArrow;
	bDrawEOF = rhs.bDrawEOF;
	bDrawSpaces = rhs.bDrawSpaces;
	bIgnoreCaseOnHilite = rhs.bIgnoreCaseOnHilite;
	bPaintBreakContinuingSelection = rhs.bPaintBreakContinuingSelection;
	chTab = rhs.chTab;
	chSpace = rhs.chSpace;
	chIdeographicSpace = rhs.chIdeographicSpace;
	strEndOfFile = rhs.strEndOfFile;
	strCommentStart1 = rhs.strCommentStart1;
	strCommentEnd1 = rhs.strCommentEnd1;
	strCommentStart2 = rhs.strCommentStart2;
	strCommentEnd2 = rhs.strCommentEnd2;
	strCommentLineHeader1 = rhs.strCommentLineHeader1;
	strCommentLineHeader2 = rhs.strCommentLineHeader2;
	pKeywords1 = new CKeywordManager(*rhs.pKeywords1);
	pKeywords2 = new CKeywordManager(*rhs.pKeywords2);
	mapOperators = rhs.mapOperators;
	listCharsTreatedAsAlpha = rhs.listCharsTreatedAsAlpha;
	bLockedParsing = false;
}

///	fXgN^
CEditView::TEditViewFoundationInfo::~TEditViewFoundationInfo() {
	delete pKeywords1;
	delete pKeywords2;
}


// CClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CClipboardRing::CClipboardRing() : m_nLimit(16), m_nMaxByte(100 * 1024), m_pEventListener(0) {
}

/**
 *	VeLXgǉB𒴂ꍇ͌Â̂폜
 *	@param strText	VeLXgB1ȏ
 *	@param bBox		`f[^
 */
void CClipboardRing::Add(const wstring& strText, bool bBox) {
	AssertValid();
	assert(strText.length() > 0);

	if(strText.length() * sizeof(wchar_t) > m_nMaxByte) {
		if(m_pEventListener != 0)
			m_pEventListener->OnClipboardRingDeniedAdding();
		return;
	}

	TClipText	ct;
	ct.strText = strText;
	ct.bBox = bBox;
	m_listDatas.push_back(ct);
	if(m_listDatas.size() > m_nLimit)
		m_listDatas.pop_front();
	if(m_pEventListener != 0)
		m_pEventListener->OnClipboardRingChanged();
}

/**
 *	w肵eLXg폜
 *	@param iText		폜eLXg̈ʒu
 *	@throw out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::Delete(unsigned char iText) throw(out_of_range) {
	AssertValid();
	if(iText >= m_listDatas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::iterator	it = m_listDatas.begin();
	for(unsigned char i = 0; i < iText; ++i, ++it);
	m_listDatas.erase(it);
	if(m_pEventListener != 0)
		m_pEventListener->OnClipboardRingChanged();
}

///	SẴeLXg폜
void CClipboardRing::DeleteAll() {
	AssertValid();
	m_listDatas.clear();
	if(m_pEventListener != 0)
		m_pEventListener->OnClipboardRingChanged();
}

///	eLXg̑Ԃ
unsigned char CClipboardRing::GetCount() const {
	AssertValid();
	return m_listDatas.size();
}

/**
 *	w肵ʒũeLXgԂ
 *	@param iText		擾eLXg̈ʒu
 *	@param strText		eLXg
 *	@param bBox			`f[^
 *	@throw out_of_range
 */
void CClipboardRing::GetText(unsigned char iText, wstring& strText, bool& bBox) const throw(out_of_range) {
	AssertValid();
	if(iText >= m_listDatas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::const_iterator	it = m_listDatas.begin();
	for(unsigned char i = 0; i < iText; ++i, ++it);

	strText = it->strText;
	bBox = it->bBox;
}

/**
 *	eLXg̏ݒ肷Bꂽ͍폜
 *	@param nLimit	VlB0ȊO
 */
void CClipboardRing::LimitCount(unsigned char nLimit) {
	AssertValid();
	assert(nLimit > 0);

	m_nLimit = nLimit;
	if(m_listDatas.size() > m_nLimit) {
		m_listDatas.resize(m_nLimit);
		if(m_pEventListener != 0)
			m_pEventListener->OnClipboardRingChanged();
	}
}

/**
 *	eLXg̃Xgt@Cǂݍ
 *	@param strPathName	t@CpX
 *	@return				
 */
bool CClipboardRing::Load(const wstring& strPathName) {
	return false;
}

/**
 *	eLXg̃Xgt@Cɏ
 *	@param strPathName	t@CpX
 *	@return				
 */
bool CClipboardRing::Save(const wstring& strPathName) const {
	return false;
}

/**
 *	CxgXi̐ݒ
 *	@param pEventListener	VCxgXi (null ł悢)
 */
void CClipboardRing::SetEventListener(IClipboardRingEventListener* pEventListener) {
	AssertValid();
	m_pEventListener = pEventListener;
}


// CEditView class implementation
/////////////////////////////////////////////////////////////////////////////

bool			CEditView::m_bRegistered = false;
CClipboardRing	CEditView::m_oClipboardRing;
CTextSearcher	CEditView::m_oTextSearcher;
CPopupMenu		CEditView::m_oContextMenu;


/// RXgN^
CEditView::CEditView() : m_pEventListener(0),
		m_bActiveIMEComposition(false),
		m_ldmLeftDown(LDM_NONE), m_nccNextCharConvert(NCC_NONE),
		m_bFreezed(false), m_iFirstVisibleLine(0) {
	m_pBoundarySearcher = new CBoundarySearcher(*this);
	m_pOriginalView = this;	// C4345 (VC7)
	m_pAnchorPoint = new CVisibleEditPoint(this);
	m_pActivePoint = new CVisibleEditPoint(this);
	m_pDragging = new Armaiti::OLE::CDraggingTextDataObject(this);
	m_pDragging->AddRef();
	m_pLineLayoutManager = new CLineLayoutManager(this);
	m_pKeyMacroPlayer = CKeyMacroPlayer::Create();
	m_pwndAutoComplete = new CAutoCompleteWnd(this);

	m_ptScroll.x = 0;
	m_ptScroll.y = 0;
	m_eoLast.type = EOT_NONE;
}

///	Rs[RXgN^B
///	قƂǂ̐ݒ͕Rs[邪A
///	tHg̓EBhE쐬ɐݒ肷KvB
CEditView::CEditView(const CEditView& rhs) : CView(rhs),
		IUnknownImpl<CUnheapMemoryManageModel>(), m_FoundationInfo(rhs.m_FoundationInfo) {
	m_pBoundarySearcher = new CBoundarySearcher(*this);
	m_pDragging = new CDraggingTextDataObject(this);
	m_pDragging->AddRef();
	m_pKeyMacroPlayer = rhs.m_pKeyMacroPlayer;
	m_pwndAutoComplete = new CAutoCompleteWnd(this);
	m_pEventListener = rhs.m_pEventListener;

	m_pOriginalView = &const_cast<CEditView&>(rhs);
	m_pOriginalView->m_setClones.insert(this);

	m_layoutInfo = rhs.m_layoutInfo;
	m_pLineLayoutManager = new CLineLayoutManager(this);
	m_ModeState = rhs.m_ModeState;
	m_AutoComplete = rhs.m_AutoComplete;

	m_bActiveIMEComposition = false;
	m_ldmLeftDown = LDM_NONE;
	m_nccNextCharConvert = NCC_NONE;
	m_bFreezed = false;

	m_pAnchorPoint = new CVisibleEditPoint(*rhs.m_pAnchorPoint);
	m_pActivePoint = new CVisibleEditPoint(*rhs.m_pActivePoint);
	m_pAnchorPoint->m_pView = this;
	m_pActivePoint->m_pView = this;
	m_ptScroll = rhs.m_ptScroll;
	m_iFirstVisibleLine = rhs.m_iFirstVisibleLine;
}

/// fXgN^
CEditView::~CEditView() {
	// 񋤗Lf[^
	delete m_pBoundarySearcher;
	delete m_pLineLayoutManager;
	m_pDragging->Release();
	m_pwndAutoComplete->DestroyWindow();
	delete m_pwndAutoComplete;
	delete m_pAnchorPoint;
	delete m_pActivePoint;

	// L
	if(m_pOriginalView == this) {
		if(m_setClones.empty()) {	// Ō
			//
			// ŋLf[^j
			//
		} else {	// ̕܂cĂ
			CEditView*	pAlphaClone = *m_setClones.begin();
			pAlphaClone->m_pOriginalView = pAlphaClone;
			pAlphaClone->m_setClones = m_setClones;
			for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
				(*it)->m_pOriginalView = pAlphaClone;
		}
	} else	// IWiɎSʒm
		m_pOriginalView->m_setClones.erase(
			m_pOriginalView->m_setClones.find(this));
}

///	`IJn
void CEditView::BeginBoxSelect() {
	AssertValidAsWindow();

	m_ModeState.bBoxSelecting = true;
	m_layoutInfo.iBoxSelectionAnchorLine = DisplayLineFromLogicalLine(m_pAnchorPoint->m_iLine);
	m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
	m_layoutInfo.xBoxSelectionAnchor = PosFromChar(*m_pAnchorPoint).x - m_layoutInfo.nLeftTabWidth;
	m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x - m_layoutInfo.nLeftTabWidth;
	InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
}

/**
 *	Ń}b`SĂ̍sɃubN}[Nݒ肷
 *	@param strText	
 *	@param sfFlags	tO
 *	@return			ubN}[Nݒ肵s
 */
unsigned long CEditView::BookmarkAll(const wstring& strText, SearchFlag sfFlags) {
	AssertValid();

	CEditDoc*		pDocument = GetDocument();
	unsigned long	cLines = GetDocument()->GetLineCount();
	unsigned long	cBookmarked = 0;
	size_t			iFound, cchFound;	// ǂݎ̂

	CEditView::m_oTextSearcher.SetFlag(sfFlags);
	CEditView::m_oTextSearcher.SetText(strText);
	try {
		for(unsigned long iLine = 0; iLine < cLines; ++iLine) {
			CEditView::m_oTextSearcher.SetTargetText(pDocument->GetLine(iLine));
			if(CEditView::m_oTextSearcher.Search(0, iFound, cchFound)) {
				m_pLineLayoutManager->GetLine(iLine)->SetBookmark(true);
				if(m_pOriginalView == this) {
					for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
						(*it)->m_pLineLayoutManager->GetLine(iLine)->SetBookmark(true);
				}
				++cBookmarked;
			}
		}
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		throw;
	} catch(ERegExpPatternIsInvalid& /* e */) {
		throw;
	}

	if(IsWindowVisible())
		InvalidateRect(0, false);
	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->InvalidateRect(0, false);
	}

	return cBookmarked;
}

/**
 *	w肵z|CgɒB̂ɍs̖ɒǉKv̂󔒕ԂB
 *	󔒂͐^uƔp󔒂gpB
 *	s̏I[łɉz|Cg𒴂Ăꍇ͋󕶎ԂB
 *	`\tt[J[\̎Ɏgp
 *	@param iLine	sԍ (\s)
 *	@param xVirtual	r[ x W (r[W̒`̓NX`̑Oɂ)
 *	@return			Kvȋ󔒕
 */
wstring CEditView::CalculateSpacesReachingVirtualPoint(unsigned long iLine, unsigned long xVirtual) const {
	AssertValidAsWindow();

	unsigned long	x = PosFromChar(CCharPos(iLine, GetDocument()->GetLineLength(iLine))).x;

	if(x >= xVirtual)	// łɒĂ -> I
		return L"";

	wostringstream	ssSpaces;
	HFONT			hOldFont = const_cast<CEditView*>(this)->m_GDIObjects.oMemDC.SelectObject(m_GDIObjects.hNormalFont);
	unsigned long	nTabPixel = GetAvgCharWidth() * m_layoutInfo.nTabWidth;
	long			nSpacePixel = m_GDIObjects.oMemDC.GetTextExtent(L" ", 1).cx;

	const_cast<CEditView*>(this)->m_GDIObjects.oMemDC.SelectObject(hOldFont);

	while(x + nTabPixel - x % nTabPixel < xVirtual) {	// xVirtual 𒴂܂Ő^utĂ
		ssSpaces << L'\t';
		x += nTabPixel - x % nTabPixel;
	}
	while(x + nSpacePixel < xVirtual) {	// xVirtual 𒴂܂ŔpXy[XtĂ
		ssSpaces << L' ';
		x += nSpacePixel;
	}

	return ssSpaces.str();
}

/**
 *	wsɂr[ x Wɂ镶擾
 *	@param iLine		s
 *	@param x			r[ x W
 *	@param bIgnoreMark	Lbg󂯎Ȃ𖳎
 *	@param pbTruncated	x ̈ʒuɕꍇ true
 *	@return				
 */
unsigned long CEditView::CharFromPixel(unsigned long iLine,
		unsigned long x, bool bIgnoreMark, bool* pbTruncated /* = 0 */) const {
	assert(iLine < GetDocument()->GetLineCount());

	const vector<int>&	vecCaretPos = m_pLineLayoutManager->GetLine(iLine)->GetCaretPositions();
	const wstring&		strLine = GetDocument()->GetLine(iLine);
	const wchar_t*		pwszLine = strLine.c_str();
	unsigned long		cchLine = strLine.length();

	if(pbTruncated != 0)
		*pbTruncated = false;

	// ł߂_T (x@)
	unsigned long	iNearest = 0;										// ܂łōł߂ʒu
	int				nNearestDistance = std::numeric_limits<int>::max();	// ̋
	for(unsigned long iChar = 0; iChar <= cchLine; ++iChar) {
		if(iChar != 0 && iChar != cchLine) {
			// ʃTQ[g͖
			if(IsUTF16LowSurrogate(strLine[iChar])
					&& IsUTF16HighSurrogate(strLine[iChar - 1]))
				continue;

			// Lbg󂯎Ȃ𖳎ꍇ
			if(bIgnoreMark) {
				unsigned long	nCodePoint = (iChar >= cchLine - 1) ? pwszLine[iChar]
					: DecodeUTF16SurrogatePairToCodePoint(pwszLine + iChar, cchLine - iChar);
				if(!m_pBoundarySearcher->IsFirstCharacterOfCluster(nCodePoint))
					continue;
			}
		}

		if(vecCaretPos[iChar] + m_layoutInfo.nLeftMargin == x)	// SɈv̂ΏI
			return iChar;
		if(dif(static_cast<int>(x), static_cast<int>(vecCaretPos[iChar] + m_layoutInfo.nLeftMargin)) < nNearestDistance) {
			iNearest = iChar;
			nNearestDistance = dif(static_cast<int>(x), static_cast<int>(vecCaretPos[iChar] + m_layoutInfo.nLeftMargin));
		}
	}
	return iNearest;
}

/**
 *	NCAgWł߂sƕʒu (_l) 擾
 *	@param pt			NCAgW
 *	@param pIgnoreMark	Lbg󂯎Ȃ𖳎B
 *						TQ[g͏ɍl
 *	@param pbTruncated	<var>pt</var> LȈʒuɐ؂l߂ꂽꍇ
 *						true (null w肷Ɩ)
 *	@return				ł߂ʒu
 */
CCharPos CEditView::CharFromPos(const POINT& pt,
		bool bIgnoreMark, bool* pbTruncated /* = 0 */) const {
	AssertValidAsWindow();

	CCharPos		pos;
	const wchar_t*	pszLine = 0;

	if(pbTruncated != 0)
		*pbTruncated = false;

	// s̊m
	if(pt.y > static_cast<long>(m_layoutInfo.nTopMargin))
		pos.m_iLine = (pt.y - m_layoutInfo.nTopMargin) / m_layoutInfo.nLineHeight + m_ptScroll.y * m_layoutInfo.nVScrollRatio;
	else {
		pos.m_iLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}
	if(pos.m_iLine < m_ptScroll.y * m_layoutInfo.nVScrollRatio) {
		pos.m_iLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio;
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else if(pos.m_iLine >= m_ptScroll.y * m_layoutInfo.nVScrollRatio + GetVisibleLineCount()) {
		pos.m_iLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio + GetVisibleLineCount() - 1;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}
	if(pos.m_iLine >= GetDocument()->GetLineCount()) {
		pos.m_iLine = GetDocument()->GetLineCount() - 1;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}

	// ̊m
	if(pt.x > static_cast<long>(m_layoutInfo.nLeftMargin + m_layoutInfo.nLeftTabWidth)) {	// сA]E
			pos.m_iChar = CharFromPixel(pos.m_iLine,
							m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() + pt.x - m_layoutInfo.nLeftTabWidth,
							bIgnoreMark, (pbTruncated != 0 && *pbTruncated) ? 0 : pbTruncated);
	} else {
		pos.m_iChar = CharFromPixel(pos.m_iLine, m_ptScroll.x * m_layoutInfo.nHScrollRatio, bIgnoreMark, 0);
		if(pbTruncated != 0)
			*pbTruncated = true;
	}

	return LogicalCharFromDisplayChar(pos);
}

///	ANeBu|Cg̕ʂł΋\B
///	̃\bh͑Ίʂ̌Aĕ`AO܂ŋ\ĂΊʂ̖ȂǑSčs
void CEditView::CheckMatchBrackets() {
	AssertValidAsWindow();
	
	if(GetTextFoundation(TT_BRACKETSMATCH).enabled
			&& !HasSelection()
			&& !CharIsInCommentOrQuotation(*m_pActivePoint)) {
		if(m_layoutInfo.posHilightedBrackets[0] != CCharPos(-1, -1)) {	// Ô̂
			InvalidateLine(m_layoutInfo.posHilightedBrackets[0].m_iLine);
			InvalidateLine(m_layoutInfo.posHilightedBrackets[1].m_iLine);
		}
		CCharPos	posBracket;
		bool		bFound;
		if(bFound = FindBracket(*m_pActivePoint, posBracket)) {
			m_layoutInfo.posHilightedBrackets[0] = *m_pActivePoint;
			m_layoutInfo.posHilightedBrackets[1] = posBracket;
		} else if(m_pActivePoint->m_iChar != 0	// 1Oׂ
				&& (bFound = FindBracket(CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1), posBracket))) {
			m_layoutInfo.posHilightedBrackets[0] = CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1);
			m_layoutInfo.posHilightedBrackets[1] = posBracket;
		}
		if(bFound) {	// ꍇ
			// ʂׂ荇Ăꍇ͌ȂƂɂ
			if(m_layoutInfo.posHilightedBrackets[0].m_iLine == m_layoutInfo.posHilightedBrackets[1].m_iLine
					&& dif(m_layoutInfo.posHilightedBrackets[0].m_iChar, m_layoutInfo.posHilightedBrackets[1].m_iChar) == 1) {
				m_layoutInfo.posHilightedBrackets[0] =
				m_layoutInfo.posHilightedBrackets[1] = CCharPos(-1, -1);
			} else {
				InvalidateLine(m_layoutInfo.posHilightedBrackets[0].m_iLine);
				InvalidateLine(m_layoutInfo.posHilightedBrackets[1].m_iLine);
			}
		} else {
			m_layoutInfo.posHilightedBrackets[0]
				= m_layoutInfo.posHilightedBrackets[1]
				= CCharPos(-1, -1);
		}
	} else if(m_layoutInfo.posHilightedBrackets[0] != CCharPos(-1, -1)) {
		InvalidateLine(m_layoutInfo.posHilightedBrackets[0].m_iLine);
		InvalidateLine(m_layoutInfo.posHilightedBrackets[1].m_iLine);
		m_layoutInfo.posHilightedBrackets[0]
			= m_layoutInfo.posHilightedBrackets[1]
			= CCharPos(-1, -1);
	}
}

///	uubN}[NNAv̎sP
void CEditView::ClearBookmarks() {
	AssertValid();

	unsigned long	cLines = GetDocument()->GetLineCount();
	for(unsigned long iLine = 0; iLine < cLines; ++iLine)
		m_pLineLayoutManager->GetLine(iLine)->SetBookmark(false);
	if(IsWindowVisible())
		InvalidateRect(0, false);
}

/**
 *	ʒu瑊ԍ擾
 *	@param pos	ʒu
 *	@return		ԍ
 */
unsigned long CEditView::ColumnFromChar(const CCharPos& pos) const {
	AssertValid();

	const unsigned long		cLines = GetDocument()->GetLineCount();
	const unsigned long		iLine = std::min(pos.m_iLine, cLines - 1);
	const vector<int>&		vecCaretPos = m_pLineLayoutManager->GetLine(iLine)->GetCaretPositions();
	const unsigned long		iChar = std::min<unsigned long>(pos.m_iChar, vecCaretPos.size() - 1);

	return vecCaretPos[iChar] / GetAvgCharWidth();
}

/**
 *	\Rg̔rɎgpB
 *	r[̐ݒɂ茟͕ς
 *	@param psz1, psz2	r
 *	@param cch			r
 *	@return				rʁB<var>psz1</var> &gt; <var>psz2</var> ł+1A
 *						<var>psz1</var> = <var>psz2</var> ł0A
 *						ȊȌꍇ-1
 */
int CEditView::CompareString(
		const wchar_t* psz1, const wchar_t* psz2, unsigned long cch) const {
	AssertValid();

	int	n = m_FoundationInfo.bIgnoreCaseOnHilite ?
				::StrCmpNIW(psz1, psz2, cch) : wcsncmp(psz1, psz2, cch);
	if(n > 0)		return 1;
	else if(n == 0)	return 0;
	else			return -1;
}

/**
 *	ϊBANZgt͂ƂȂǂɎg
 *	@param wch	ϊ镶
 *	@param ncc	ϊ̎
 */
wchar_t CEditView::ConvertCharacter(wchar_t wch, NextCharConvert ncc) {
	if(ncc == NCC_NONE)
		return wch;
	else if(ncc == NCC_GRAVE) {
		switch(wch) {
		case 0x0041: return 0x00C0;	case 0x0061: return 0x00E0;	// A
		case 0x0045: return 0x00C8;	case 0x0065: return 0x00E8;	// E
		case 0x0049: return 0x00CC;	case 0x0069: return 0x00EC;	// I
		case 0x004F: return 0x00D2;	case 0x006F: return 0x00F2;	// O
		case 0x0055: return 0x00D9;	case 0x0075: return 0x00F9;	// U
		case 0x00DC: return 0x01DB;	case 0x00FC: return 0x01DC;	// U With Diaeresis
		case 0x004E: return 0x01F8;	case 0x006E: return 0x01F9;	// N
		case 0x0415: return 0x0400;	case 0x0435: return 0x0450;	// Cyrillic Ie
		case 0x0418: return 0x040D;	case 0x0438: return 0x045D;	// Cyrillic I
		case 0x0112: return 0x1E14;	case 0x0113: return 0x1E15;	// E With Macron
		case 0x014C: return 0x1E50;	case 0x014D: return 0x1E51;	// O With Macron
		case 0x0057: return 0x1E80;	case 0x0077: return 0x1E81;	// W
		case 0x00C2: return 0x1EA6;	case 0x00E2: return 0x1EA7;	// A With Circumflex
		case 0x0102: return 0x1EB0;	case 0x0103: return 0x1EB1;	// A With Breve
		case 0x00CA: return 0x1EC0;	case 0x00EA: return 0x1EC1;	// E With Circumflex
		case 0x00D4: return 0x1ED2;	case 0x00F4: return 0x1ED3;	// O With Circumflex
		case 0x01A0: return 0x1EDC;	case 0x01A1: return 0x1EDD;	// O With Horn
		case 0x01AF: return 0x1EEA;	case 0x01B0: return 0x1EEB;	// U With Horn
		case 0x0059: return 0x1EF2;	case 0x0079: return 0x1EF3;	// Y
		}
	} else if(ncc == NCC_ACUTE) {
		switch(wch) {
		case 0x0041: return 0x00C1;	case 0x0061: return 0x00E1;	// A
		case 0x0045: return 0x00C9;	case 0x0065: return 0x00E9;	// E
		case 0x0049: return 0x00CD;	case 0x0069: return 0x00ED;	// I
		case 0x004F: return 0x00D3;	case 0x006F: return 0x00F3;	// O
		case 0x0055: return 0x00DA;	case 0x0075: return 0x00FA;	// U
		case 0x0059: return 0x00DD;	case 0x0079: return 0x00FD;	// Y
		case 0x0043: return 0x0106;	case 0x0063: return 0x0107;	// C
		case 0x004C: return 0x0139;	case 0x006C: return 0x013A;	// L
		case 0x004E: return 0x0143;	case 0x006E: return 0x0144;	// N
		case 0x0052: return 0x0154;	case 0x0072: return 0x0155;	// R
		case 0x0053: return 0x015A;	case 0x0073: return 0x015B;	// S
		case 0x005A: return 0x0179;	case 0x007A: return 0x017A;	// Z
		case 0x00DC: return 0x01D7;	case 0x00FC: return 0x01D8;	// U With Diaeresis
		case 0x0047: return 0x01F4;	case 0x0067: return 0x01F5;	// G
		case 0x00C5: return 0x01FA;	case 0x00E5: return 0x01FB;	// A With Ring Above
		case 0x00C6: return 0x01FC;	case 0x00E6: return 0x01FD;	// Ae
		case 0x00D8: return 0x01FE;	case 0x00F8: return 0x01FF;	// O With Stroke
		case 0x03D2: return 0x03D3;	// Greek Upsilon With Hook Symbol
		case 0x00C7: return 0x1E08;	case 0x00E7: return 0x1E09;	// C With Cedilla
		case 0x0112: return 0x1E16;	case 0x0113: return 0x1E17;	// E With Macron
		case 0x00CF: return 0x1E2E;	case 0x00EF: return 0x1E2F;	// I With Diaeresis
		case 0x004B: return 0x1E30;	case 0x006B: return 0x1E31;	// K
		case 0x004D: return 0x1E3E;	case 0x006D: return 0x1E3F;	// M
		case 0x00D5: return 0x1E4C;	case 0x00F5: return 0x1E4D;	// O With Tilde
		case 0x014C: return 0x1E52;	case 0x014D: return 0x1E53;	// O With Macron
		case 0x0050: return 0x1E54;	case 0x0070: return 0x1E55;	// P
		case 0x1E60: return 0x1E64;	case 0x1E61: return 0x1E65;	// S With Dot Above
		case 0x0168: return 0x1E78;	case 0x0169: return 0x1E79;	// U With Tilde
		case 0x0057: return 0x1E82;	case 0x0077: return 0x1E83;	// W
		case 0x00C2: return 0x1EA4;	case 0x00E2: return 0x1EA5;	// A With Circumflex
		case 0x0102: return 0x1EAE;	case 0x0103: return 0x1EAF;	// A With Breve
		case 0x00CA: return 0x1EBE;	case 0x00EA: return 0x1EBF;	// E With Circumflex
		case 0x00D4: return 0x1ED0;	case 0x00F4: return 0x1ED1;	// O With Circumflex
		case 0x01A0: return 0x1EDA;	case 0x01A1: return 0x1EDB;	// O With Horn
		case 0x01AF: return 0x1EE8;	case 0x01B0: return 0x1EE9;	// U With Horn
		}
	} else if(ncc == NCC_CIRCUMFLEX) {
		switch(wch) {
		case 0x0041: return 0x00C2;	case 0x0061: return 0x00E2;	// A
		case 0x0045: return 0x00CA;	case 0x0065: return 0x00EA;	// E
		case 0x0049: return 0x00CE;	case 0x0069: return 0x00EE;	// I
		case 0x004F: return 0x00D4;	case 0x006F: return 0x00F4;	// O
		case 0x0055: return 0x00DB; case 0x0075: return 0x00FB;	// U
		case 0x0043: return 0x0108;	case 0x0063: return 0x0109;	// C
		case 0x0047: return 0x011C;	case 0x0067: return 0x011D;	// G
		case 0x0048: return 0x0124;	case 0x0068: return 0x0125;	// H
		case 0x004A: return 0x0134;	case 0x006A: return 0x0135;	// J
		case 0x0053: return 0x015C;	case 0x0073: return 0x015D;	// S
		case 0x0057: return 0x0174;	case 0x0077: return 0x0175;	// W
		case 0x0059: return 0x0176;	case 0x0079: return 0x0177;	// Y
		case 0x005A: return 0x1E90;	case 0x007A: return 0x1E91;	// Z
		case 0x00C1: return 0x1EA4;	case 0x00E1: return 0x1EA5;	// A With Acute
		case 0x00C0: return 0x1EA6;	case 0x00E0: return 0x1EA7;	// A With Grave
		case 0x1EA2: return 0x1EA8;	case 0x1EA3: return 0x1EA9;	// A With Hook Above
		case 0x00C3: return 0x1EAA;	case 0x00E3: return 0x1EAB;	// A With Tilde
		case 0x1EA0: return 0x1EAC;	case 0x1EA1: return 0x1EAD;	// A With Dot Below
		case 0x00C9: return 0x1EBE;	case 0x00E9: return 0x1EBF;	// E With Acute
		case 0x00C8: return 0x1EC0;	case 0x00E8: return 0x1EC1;	// E With Grave
		case 0x1EBA: return 0x1EC2;	case 0x1EBB: return 0x1EC3;	// E With Hook Above
		case 0x1EBC: return 0x1EC4;	case 0x1EBD: return 0x1EC5;	// E With Tilde
		case 0x1EB8: return 0x1EC6;	case 0x1EB9: return 0x1EC7;	// E With Dot Below
		case 0x00D3: return 0x1ED0;	case 0x00F3: return 0x1ED1;	// O With Acute
		case 0x00D2: return 0x1ED2;	case 0x00F2: return 0x1ED3;	// O With Grave
		case 0x1ECE: return 0x1ED4;	case 0x1ECF: return 0x1ED5;	// O With Hook Above
		case 0x00D5: return 0x1ED6;	case 0x00F5: return 0x1ED7;	// O With Tilde
		case 0x1ECC: return 0x1ED8;	case 0x1ECD: return 0x1ED9;	// O With Dot Below
		}
	} else if(ncc == NCC_TILDE) {
		switch(wch) {
		case 0x0041: return 0x00C3;	case 0x0061: return 0x00E3;	// A
		case 0x004E: return 0x00D1;	case 0x006E: return 0x00F1;	// N
		case 0x004F: return 0x00D5;	case 0x006F: return 0x00F5;	// O
		case 0x0049: return 0x0128;	case 0x0069: return 0x0129;	// I
		case 0x0055: return 0x0168;	case 0x0075: return 0x0169;	// U
		case 0x014C: return 0x022C;	case 0x014D: return 0x022D;	// O With Macron
		case 0x00D3: return 0x1E4C;	case 0x00F3: return 0x1E4D;	// O With Acute
		case 0x00D6: return 0x1E4E;	case 0x00F6: return 0x1E4F;	// O With Diaeresis
		case 0x00DA: return 0x1E78;	case 0x00FA: return 0x1E79;	// U With Acute
		case 0x0056: return 0x1E7C;	case 0x0076: return 0x1E7D;	// V
		case 0x00C2: return 0x1EAA;	case 0x00E2: return 0x1EAB;	// A With Circumflex
		case 0x0102: return 0x1EB4;	case 0x0103: return 0x1EB5;	// A With Breve
		case 0x0045: return 0x1EBC;	case 0x0065: return 0x1EBD;	// E
		case 0x00CA: return 0x1EC4;	case 0x00EA: return 0x1EC5;	// E With Circumflex
		case 0x00D4: return 0x1ED6;	case 0x00F4: return 0x1ED7;	// O With Circumflex
		case 0x01A0: return 0x1EE0;	case 0x01A1: return 0x1EE1;	// O With Horn
		case 0x01AF: return 0x1EEE;	case 0x01B0: return 0x1EEF;	// U With Horn
		case 0x0059: return 0x1EF8;	case 0x0079: return 0x1EF9;	// Y
		}
	} else if(ncc == NCC_DIAERESIS) {
		switch(wch) {
		case 0x0041: return 0x00C4;	case 0x0061: return 0x00E4;	// A
		case 0x0045: return 0x00CB;	case 0x0065: return 0x00EB;	// E
		case 0x0049: return 0x00CF;	case 0x0069: return 0x00EF;	// I
		case 0x004F: return 0x00D6;	case 0x006F: return 0x00F6;	// O
		case 0x0055: return 0x00DC;	case 0x0075: return 0x00FC;	// U
		case 0x0059: return 0x0178;	case 0x0079: return 0x00FF;	// Y
//		case 0x016A: return 0x01D5;	case 0x016B: return 0x01D6;	// U With Macron
		case 0x00DA: return 0x01D7;	case 0x00FA: return 0x01D8;	// U With Acute
		case 0x01D3: return 0x01D9;	case 0x01D4: return 0x01DA;	// U With Caron
		case 0x00D9: return 0x01DB;	case 0x00F9: return 0x01DC;	// U With Grave
		case 0x0100: return 0x01DE;	case 0x0101: return 0x01DF;	// A With Macron
		case 0x014C: return 0x022A;	case 0x014D: return 0x022B;	// O With Macron
		case 0x03D2: return 0x03D4;	// Greek Upsilon With Hook Symbol
		case 0x0410: return 0x04D2;	case 0x0430: return 0x04D3;	// Cyrillic A
		case 0x04D8: return 0x04DA;	case 0x04D9: return 0x04DB;	// Cyrillic Schwa
		case 0x0416: return 0x04DC;	case 0x0436: return 0x04DD;	// Cyrillic Zhe
		case 0x0417: return 0x04DE;	case 0x0437: return 0x04DF;	// Cyrillic Ze
		case 0x0418: return 0x04E4;	case 0x0438: return 0x04E5;	// Cyrillic I
		case 0x041E: return 0x04E6;	case 0x043E: return 0x04E7;	// Cyrillic O
		case 0x04E8: return 0x04EA;	case 0x04E9: return 0x04EB;	// Cyrillic Barred O
		case 0x042D: return 0x04EC;	case 0x044D: return 0x04ED;	// Cyrillic E
		case 0x0423: return 0x04F0;	case 0x0443: return 0x04F1;	// Cyrillic U
		case 0x0427: return 0x04F4;	case 0x0447: return 0x04F5;	// Cyrillic Che
		case 0x042B: return 0x04F8;	case 0x044B: return 0x04F9;	// Cyrillic Yeru
		case 0x0048: return 0x1E26;	case 0x0068: return 0x1E27;	// H
		case 0x00CD: return 0x1E2E;	case 0x00ED: return 0x1E2F;	// I With Acute
		case 0x00D5: return 0x1E4E; case 0x00F5: return 0x1E4F;	// O With Tilde
		case 0x016A: return 0x1E7A;	case 0x016B: return 0x1E7B;	// U With Macron
		case 0x0057: return 0x1E84;	case 0x0077: return 0x1E85;	// W
		case 0x0058: return 0x1E8C;	case 0x0078: return 0x1E8D;	// X
		case 0x0074: return 0x1E97;	// Small T
		}
	} else if(ncc == NCC_CEDILLA) {
		switch(wch) {
		case 0x0043: return 0x00C7;	case 0x0063: return 0x00E7;	// C
		case 0x0047: return 0x0122;	case 0x0067: return 0x0123;	// G
		case 0x004B: return 0x0136;	case 0x006B: return 0x0137;	// K
		case 0x004C: return 0x013B;	case 0x006C: return 0x013C;	// L
		case 0x004E: return 0x0145;	case 0x006E: return 0x0146;	// N
		case 0x0052: return 0x0156;	case 0x0072: return 0x0157;	// R
		case 0x0053: return 0x015E;	case 0x0073: return 0x015F;	// S
		case 0x0054: return 0x0162;	case 0x0074: return 0x0163;	// T
		case 0x0045: return 0x0228;	case 0x0065: return 0x0229;	// E
		case 0x00C7: return 0x1E08;	case 0x00E7: return 0x1E09;	// C With Acute
		case 0x0044: return 0x1E10;	case 0x0064: return 0x1E11;	// D
		case 0x0114: return 0x1E1C;	case 0x0115: return 0x1E1D;	// E With Breve
		case 0x0048: return 0x1E28;	case 0x0068: return 0x1E29;	// H
		}
	} else if(ncc == NCC_SUPERSCRIPT) {
		switch(wch) {
		case 0x0030: return 0x2070;	// Zero
		case 0x0069: return 0x2071;	// Latin Small Letter I
		case 0x0034: return 0x2074;	case 0x0035: return 0x2075;	// Four, Five
		case 0x0036: return 0x2076;	case 0x0037: return 0x2077;	// Six, Seven
		case 0x0038: return 0x2078;	case 0x0039: return 0x2079;	// Eight, Nine
		case 0x002B: return 0x207A;	case 0x2212: return 0x207B;	// Plus Sign, Minus
		case 0x003D: return 0x207C;	// Equals Sign
		case 0x0028: return 0x207D;	// Left Parenthesis
		case 0x0029: return 0x207E;	// Right Parenthesis
		case 0x006E: return 0x207F;	// Latin Small Letter N
		}
	} else if(ncc == NCC_SUBSCRIPT) {
		switch(wch) {
		case 0x0030: return 0x2080;	case 0x0031: return 0x2081;	// Zero, One
		case 0x0032: return 0x2082;	case 0x0033: return 0x2083;	// Two, Three
		case 0x0034: return 0x2084;	case 0x0035: return 0x2085;	// Four, Five
		case 0x0036: return 0x2086;	case 0x0037: return 0x2087;	// Six, Seven
		case 0x0038: return 0x2088;	case 0x0039: return 0x2089;	// Eight, Nine
		case 0x002B: return 0x208A;	case 0x2212: return 0x208B;	// Plus Sign, Minus
		case 0x003D: return 0x208C;	// Equals Sign
		case 0x0028: return 0x208D;	// Left Parenthesis
		case 0x0029: return 0x208E;	// Right Parenthesis
		}
	} else
		assert(false);
	return wch;
}

/**
 *	EBhE̍쐬
 *	@param hwndParent	eEBhE
 *	@param pRect		쐬EBhE̋`
 *	@param dwStyle		EBhEX^C
 *	@param dwExStyle	gEBhEX^C
 *	@return				EBhE쐬 true
 */
bool CEditView::Create(HWND hwndParent, const RECT* pRect, DWORD dwStyle, DWORD dwExStyle) throw(runtime_error) {
	AssertValid();

	if(!CEditView::RegisterWindowClass())
		throw runtime_error("Failed to register window class!");
	if(IsWindow())
		return false;

	bool	bVisible = toBoolean(dwStyle & WS_VISIBLE);
	dwStyle &= ~WS_VISIBLE;
	m_hWnd = ::CreateWindowExW(dwExStyle,
		WC_ASCENSIONVIEW, L"", dwStyle,
		0, 0, 0, 0, hwndParent, 0, ::GetModuleHandle(0), reinterpret_cast<void*>(this));
	if(m_hWnd == 0)
		return false;
	InitializeWindow();

	// ʒu߂ƕ\
	MoveWindow(pRect, false);
	if(bVisible)
		ShowWindow(SW_SHOW);

	return true;
}

/**
 *	ҏW|Cg쐬
 *	@return	ҏW|CgBĂяoō폜
 */
CEditPoint* CEditView::CreateEditPoint() {
	AssertValid();

	CEditPoint*	ppt = new CEditPoint(this);
	ppt->m_bOwnedByView = true;
	m_setEditPoints.insert(ppt);
	return ppt;
}

/**
 *	@brief	I͈͂폜
 *
 *	̃\bh̓AhDO[v쐬ȂB
 *	݁A`I̓eȒPɍ폜ł̂͂̃\bh
 *
 *	@see	InsertText, ReplaceSel
 */
void CEditView::DeleteSel() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(!HasSelection())	// IȂΉȂ
		return;

	CEditDoc*	pDoc = GetDocument();

	if(!m_ModeState.bBoxSelecting) {
		m_pActivePoint->MoveToPoint(pDoc->DeleteText(this, *m_pAnchorPoint, *m_pActivePoint));
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
	} else {
		unsigned long	iTopLine = GetSelTopPoint().m_iLine;
		unsigned long	iBottomLine = GetSelBottomPoint().m_iLine;

		m_ModeState.bBoxSelecting = false;
		for(unsigned long iLine = iTopLine; iLine <= iBottomLine; ++iLine)
			pDoc->DeleteText(this,
				CCharPos(iLine, CharFromPixel(iLine, min(m_layoutInfo.xBoxSelectionAnchor,
					m_layoutInfo.xBoxSelectionActive), !m_ModeState.bCaretMarkByMouse)),
				CCharPos(iLine, CharFromPixel(iLine, max(m_layoutInfo.xBoxSelectionAnchor,
					m_layoutInfo.xBoxSelectionActive), !m_ModeState.bCaretMarkByMouse)));
	}
	m_nccNextCharConvert = NCC_NONE;	// ɖ߂

	if(m_pEventListener != 0 && m_pKeyMacroPlayer->GetState() != KMS_PLAYING)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

/// @see CWindow::DispatchEvent
LRESULT CEditView::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	POINT			pt;
	static wstring	strText;

	switch(message) {
	case WM_CHAR:
		OnChar(wParam, lParam);
		return 0L;
	case WM_CLEAR:
		ExecCommand(CMDID_EDIT_DELETE, 0L);
		return 0L;
	case WM_COPY:
		ExecCommand(CMDID_EDIT_COPY, 0L);
		return 0L;
	case WM_CUT:
		ExecCommand(CMDID_EDIT_CUT, 0L);
		return 0L;
	case WM_ERASEBKGND:
		InvalidateRect(0, false);
		return true;
	case WM_GETFONT:
		return reinterpret_cast<LRESULT>(m_GDIObjects.hNormalFont);
	case WM_GETTEXT:
		GetDocument()->GetAllLines(strText);
		return reinterpret_cast<LRESULT>(strText.c_str());
	case WM_GETTEXTLENGTH:
		GetDocument()->GetAllLines(strText);
		return strText.length();
	case WM_HSCROLL:
		OnHScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	case WM_IME_COMPOSITION:
		if(OnImeComposition(wParam, lParam))
			return false;
		break;
	case WM_IME_ENDCOMPOSITION:
		OnImeEndComposition();
		break;
	case WM_IME_REQUEST:
		if(wParam == IMR_RECONVERTSTRING) {	// L[{[hɂĕϊ
			ExecCommand(CMDID_EDIT_RECOMPOSESELECTION, 0L);
			return 0;
		}
		break;
	case WM_IME_STARTCOMPOSITION:
		OnImeStartComposition();
		break;
	case WM_KEYDOWN:
		OnKeyDown(wParam, lParam);
//		GetParent()->SendMessage(WM_KEYDOWN, wParam, lParam);
		return 0L;
	case WM_MOUSEWHEEL:
		pt.x = LOWORD(lParam);
		pt.y = LOWORD(lParam);
		OnMouseWheel(LOWORD(wParam), HIWORD(wParam), pt);
		return 0L;
	case WM_PASTE:
		ExecCommand(CMDID_EDIT_PASTE, 0L);
		return 0L;
	case WM_SETTEXT:
		ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		ReplaceSel(reinterpret_cast<const wchar_t*>(lParam));
		return 0L;
	case WM_SYSCOLORCHANGE:
#ifdef WM_THEMECHANGED
	case WM_THEMECHANGED:
#endif
		OnSysColorChange();
		return 0L;
	case WM_UNDO:
		ExecCommand(CMDID_EDIT_UNDO, 0L);
		return 0L;
	case WM_VSCROLL:
		OnVScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	}

	return CView::DispatchEvent(message, wParam, lParam);
}

/**
 *	_ʒu\ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posLogical	ϊ_ʒu
 *	@return				ϊꂽ\ʒu (łȂo-1)
 */
CCharPos CEditView::DisplayCharFromLogicalChar(const CCharPos& posLogical) const {
	AssertValid();

//	if(m_ModeState.wpmWrapMode == WPM_NONE)
		return posLogical;
/*
	CCharPos			posDisplay(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(unsigned long iTotalLogicalLine = 0;
			iTotalLogicalLine < posLogical.iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return CCharPos(-1, -1);
		posDisplay.iLine += pInfo->GetWrappedPoints().size() + 1;
	}

	// ̊m
	vector<unsigned long>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();

	// ̍sɂ͐܂Ԃ͖ or 擪s
	if(cOffsets == 0 || posLogical.iChar < pInfo->m_vecWrappedOffsets[0]) {
		posDisplay.iChar = posLogical.iChar;
		return posDisplay;
	}
	
	for(vector<unsigned long>::size_type iOffset = cOffsets - 1; iOffset < cOffsets; ++iOffset) {
		if(pInfo->m_vecWrappedOffsets[iOffset] <= posLogical.iChar) {
			posDisplay.iChar = posLogical.iChar - pInfo->m_vecWrappedOffsets[iOffset];
			posDisplay.iLine += iOffset;
			return posDisplay;
		}
	}

	return CCharPos(-1, -1);*/
}

/**
 *	_s\sɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param iLine	ϊ_s
 *	@return			ϊꂽ\s (ϊɎsꍇ-1)
 */
unsigned long CEditView::DisplayLineFromLogicalLine(unsigned long iLine) const {
	AssertValid();

	assert(iLine < GetDocument()->GetLineCount());
//	if(m_ModeState.wpmWrapMode == WPM_NONE)
		return iLine;
/*
	unsigned long		iDisplay = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(unsigned long iTotalLogicalLine = 0;
			iTotalLogicalLine < iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return -1;
		iDisplay += pInfo->m_vecWrappedOffsets.size() + 1;
	}
	return iDisplay;*/
}

/// @see IDropTarget::DragEnter
STDMETHODIMP CEditView::DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	FORMATETC	fe = {
		CF_TEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL
	};

	if(m_ldmLeftDown == LDM_NONE)
		m_ldmLeftDown = LDM_DRAGANDDROP;
	SetFocus();

	// hbOĂf[^Lǂׂ
	if(!GetDocument()->IsReadOnly()
			&& (m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| pDataObj->QueryGetData(&fe) == S_OK
			|| (fe.cfFormat = CF_UNICODETEXT, pDataObj->QueryGetData(&fe) == S_OK))) {
		SetTimer(ID_TIMER_DRAGSCROLL, 50, 0);
		return DragOver(grfKeyState, pt, pdwEffect);
	}
	m_ldmLeftDown = LDM_NONE;
	*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/// @see IDropTarget::DragLeave
STDMETHODIMP CEditView::DragLeave() {
	::SetFocus(0);
	KillTimer(ID_TIMER_DRAGSCROLL);
	if(m_ldmLeftDown != LDM_DRAGANDDROPSELF
			&& m_ldmLeftDown != LDM_DRAGANDDROPBOXSELF)
		m_ldmLeftDown = LDM_NONE;
	return S_OK;
}

/// @see IDropTarget::DragOver
STDMETHODIMP CEditView::DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	VERIFY_POINTER(pdwEffect);

	if(m_ldmLeftDown == LDM_DRAGANDDROP
			|| m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// hbv\ȏꍇȊO͉Ȃ
		POINT	ptCaret = {pt.x, pt.y};
		ScreenToClient(&ptCaret);
		SetCaretPos(PosFromChar(CharFromPos(ptCaret, !m_ModeState.bCaretMarkByMouse)));
		if(m_ldmLeftDown != LDM_DRAGANDDROP)
			*pdwEffect = (::GetKeyState(VK_CONTROL) & 0x8000) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
		else
			*pdwEffect = DROPEFFECT_COPY;
	} else
		*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/**
 *	s}[N̕`
 *	@param x, y		`ʒu
 *	@param bt		`悷s
 *	@param clrBack	wiF
 *	@return			`敝
 */
inline int CEditView::DrawBreakMark(int x, int y, BreakType bt, COLORREF clrBack) {
	CMinimalDC&	oDC = m_GDIObjects.oMemDC;

	if(bt == BT_LF || bt == BT_CR || bt == BT_CRLF) {
		HPEN	hOldPen = oDC.SelectObject(m_GDIObjects.hLineBreakPen);
		int		cx = GetAvgCharWidth();
		int		cy = m_layoutInfo.nLineHeight;
		int		hx, hy;

		// ŏl̐ݒ
		cx = std::max(cx, 7);

		// wiFh
		oDC.FillSolidRect(x, y, cx, cy, clrBack);

		// ɑƕ`Ղ?
		cx -= (cx % 2 == 0) ? 1 : 0;
		cy -= (cy % 2 == 0) ? 1 : 0;

		// ̈ʒu
		hx = x + cx / 2;
		hy = y + cy / 2;

		if(bt == BT_LF) {	// E
			oDC.MoveTo(x + 1, hy);
			oDC.LineTo(x + cx, hy);
			oDC.MoveTo(hx + 1, hy - cx / 2 + 1);
			oDC.LineTo(x + cx, hy + 1);
			oDC.MoveTo(hx + 1, hy + cx / 2 - 1);
			oDC.LineTo(x + cx, hy - 1);
		} else if(bt == BT_CR) {	// 
			oDC.MoveTo(x + cx - 1, hy);
			oDC.LineTo(x, hy);
			oDC.MoveTo(hx - 0, hy - cx / 2 + 1);
			oDC.LineTo(x + 0, hy + 1);
			oDC.MoveTo(hx - 0, hy + cx / 2 - 1);
			oDC.LineTo(x + 0, hy - 1);
		} else {	// 
			oDC.MoveTo(hx, hy - cx / 2);
			oDC.LineTo(hx, hy + cx / 2 + 1);
			oDC.MoveTo(x + 1, hy + 1);
			oDC.LineTo(hx, hy + cx / 2);
			oDC.MoveTo(x + cx - 2, hy + 1);
			oDC.LineTo(hx, hy + cx / 2);
		}
		oDC.SelectObject(hOldPen);
		return GetAvgCharWidth();
	} else if(bt == BT_NEL || bt == BT_LS || bt == BT_PS) {
		HFONT	hOldFont = oDC.SelectObject((bt != BT_PS) ?
							m_GDIObjects.hNormalFont : m_GDIObjects.hBoldFont);
		wchar_t	chBreakArrow = (bt == BT_NEL) ? L'\x21A9' : L'\x21B2';
		RECT	rect;
		int		nWidth;

		oDC.GetCharWidth(chBreakArrow, chBreakArrow, &nWidth);
		::SetRect(&rect, x, y, x + nWidth, y + m_layoutInfo.nLineHeight);
		oDC.SetTextColor(m_layoutInfo.tfTextFoundation[TT_BREAK].fgColor);
		oDC.SetBkColor(clrBack);
		oDC.SetBkMode(OPAQUE);
		oDC.ExtTextOut(x, y, ETO_OPAQUE, &rect, &chBreakArrow, 1, 0);
		oDC.SelectObject(hOldFont);

		return nWidth;
	} else
		assert(false);
	return 0;
}

/**
 *	т`
 *	@param iStart	Jns (\s)
 *	@param iEnd		Is (\s)
 */
void CEditView::DrawLeftTab(unsigned long iStart, unsigned long iEnd) {
	AssertValidAsWindow();

	HPEN		hOldPen;
	RECT		rectClient;
	CMinimalDC&	oDC = m_GDIObjects.oMemDC;
	int			yStart = m_layoutInfo.nTopMargin + (iStart - m_ptScroll.y) * m_layoutInfo.nLineHeight;

	if(iStart > iEnd)
		std::swap(iStart, iEnd);

	if(m_ModeState.lttTabType != LTT_NONE) {
		GetClientRect(&rectClient);

		// \bh
		if(toBoolean(m_ModeState.lttTabType & LTT_INDICATOR)) {
			if(m_ModeState.wpmWrapMode == WPM_NONE) {
				RECT				rectSolid = {rectClient.left, yStart,
										rectClient.left + INDICATORMARGIN_WIDTH, yStart + m_layoutInfo.nLineHeight};
				CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(iStart);

				// n (?) `
				hOldPen = oDC.SelectObject(m_GDIObjects.hLeftIndicatorPen);
				oDC.FillSolidRect(rectClient.left, rectClient.top, INDICATORMARGIN_WIDTH,
					rectClient.bottom - rectClient.top, GetTextFoundation(TT_INDICATORMARGIN).bgColor);
				oDC.MoveTo(INDICATORMARGIN_WIDTH - 1, rectClient.top);
				oDC.LineTo(INDICATORMARGIN_WIDTH - 1, rectClient.bottom);

				if(m_pEventListener != 0) {
					for(unsigned long iLine = iStart; iLine <= iEnd; ++iLine) {
						pInfo = m_pLineLayoutManager->GetLine(iLine);
						m_pEventListener->OnDrawIndicatorMargin(iLine, oDC,
							rectSolid, pInfo->IsBookmarked(), pInfo->GetUserDefinedValue(), pInfo == m_layoutInfo.pAppDefinedSingleLine);
						::OffsetRect(&rectSolid, 0, m_layoutInfo.nLineHeight);
					}
				}
				oDC.SelectObject(hOldPen);
			}
			rectClient.left += INDICATORMARGIN_WIDTH;
		}

		// sԍ
		if(toBoolean(m_ModeState.lttTabType & LTT_LINENUMBER)) {
			wchar_t			szLineNumber[32];
			RECT			rectLineNumber, rectLineNumberDraw;
			LineIterator	it = 0;
			HFONT			hOldFont = 0;
			TextType		ttLine;	// `悷sʂ̍ss
			unsigned long	iLogicalStart, iDummy;

			oDC.SetTextCharacterExtra(0);	// sԍ\͕Ԋu̐ݒ𖳎
			GetDisplayLineOffsetIndex(iStart, iLogicalStart, iDummy);
			it = GetDocument()->GetLineIterator(iLogicalStart);
			rectLineNumber = rectClient;
			rectLineNumber.right = m_layoutInfo.nLeftTabWidth;
			rectLineNumberDraw.left = rectLineNumber.left;
			rectLineNumberDraw.right = rectLineNumber.right - 4;
			hOldPen = oDC.SelectObject(m_GDIObjects.hLineNumberPen);
			oDC.SetBkMode(OPAQUE);
			oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
				rectLineNumber.right - rectLineNumber.left,
				rectClient.bottom - rectClient.top,
				GetTextFoundation(TT_LINENUMBER).bgColor);

			if(m_ModeState.wpmWrapMode == WPM_NONE) {
				TTextFoundation	tf;
				// 1s`
				for(unsigned long iLine = iStart; iLine <= iEnd; ++iLine, ++it) {
					swprintf(szLineNumber, L"%lu", iLine + 1);
					rectLineNumber.top = rectLineNumberDraw.top
						= (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight + m_layoutInfo.nTopMargin;
					rectLineNumber.bottom = rectLineNumberDraw.bottom
						= rectLineNumber.top + m_layoutInfo.nLineHeight;
					ttLine = it->IsModified() ? TT_EMPHASIZEDLINENUMBER : TT_LINENUMBER;
					tf = GetTextFoundation(ttLine);

					// tHgȂǂ̑I
					oDC.SetTextColor(tf.fgColor);
					oDC.SetBkColor(tf.bgColor);
					hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttLine));
					oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
						rectLineNumber.right - rectLineNumber.left,
						m_layoutInfo.nLineHeight, tf.bgColor);
					oDC.DrawText(szLineNumber, -1, &rectLineNumberDraw, DT_TOP | DT_RIGHT | DT_SINGLELINE);
					oDC.SelectObject(hOldFont);
				}
			} else {	// ܂Ԃlꍇ
				unsigned long		iLine = iStart;
				unsigned long		iLogicalLine;
				unsigned long		iOffset;
				CLineLayoutInfo*	pInfo = 0;
				TTextFoundation		tf;

				GetDisplayLineOffsetIndex(iStart * m_layoutInfo.nVScrollRatio, iLogicalLine, iOffset);
				pInfo = m_pLineLayoutManager->GetLine(iLogicalLine);
				while(iLine <= iEnd && pInfo != 0) {
					ttLine = it->IsModified() ? TT_EMPHASIZEDLINENUMBER : TT_LINENUMBER;
					if(iOffset >= pInfo->GetWrappedPoints().size() + 1) {	// ̘_s֐i
						++iLogicalLine;
						++it;
						ttLine = it->IsModified() ? TT_EMPHASIZEDLINENUMBER : TT_LINENUMBER;
						tf = GetTextFoundation(ttLine);
						iOffset = 0;
						pInfo = m_pLineLayoutManager->GetLine(iLogicalLine);
						continue;
					}
					if(iOffset == 0) {
						swprintf(szLineNumber, L"%lu", iLogicalLine + 1);
						rectLineNumber.top = rectLineNumberDraw.top
							= (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight + m_layoutInfo.nTopMargin;
						rectLineNumber.bottom = rectLineNumberDraw.bottom
							= rectLineNumber.top + m_layoutInfo.nLineHeight;

						// tHgȂǂ̑I
						oDC.SetTextColor(tf.fgColor);
						oDC.SetBkColor(tf.bgColor);
						hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttLine));
						oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
							rectLineNumber.right - rectLineNumber.left,
							m_layoutInfo.nLineHeight, tf.bgColor);
						oDC.DrawText(szLineNumber, -1, &rectLineNumberDraw, DT_TOP | DT_RIGHT | DT_SINGLELINE);
						oDC.SelectObject(hOldFont);
					}
					++iLine;
					++iOffset;
				}
			}

			oDC.MoveTo(m_layoutInfo.nLeftTabWidth - 1, rectClient.top);
			oDC.LineTo(m_layoutInfo.nLeftTabWidth - 1, rectClient.bottom);
			oDC.SelectObject(hOldPen);
		}
	}
}

/**
 *	_s1s`B` m_hMemDC ɑIĂrbg}bvɍs
 *	@param iLine		`悷_s
 *	@param y			y W (r[W)
 *	@param strLine		`e
 *	@param bt			̍s̉sR[h
 *	@param pLineInfo	`悷_s̃CAEg
 *	@return				`悵\s
 */
unsigned long CEditView::DrawLine(unsigned long iLine,
		int y, const wstring& strLine, BreakType bt, const CLineLayoutInfo* pLineInfo) {
	AssertValidAsWindow();
	
//	CTimer	tm(L"DrawLine");

	const TokenList&	listTokens = pLineInfo->GetTokenList();
	const vector<int>&	vecCaretPos = pLineInfo->GetCaretPositions();

	const wchar_t*	pwszLine = strLine.c_str();
	unsigned long	iSelBegin, iSelEnd;	// ̍sɂI͈
	register long	nXOffset;			// `ʒu
	RECT			rect;
	unsigned long	cDrawnLines = 0;	// ߂l
	CMinimalDC&		oDC = m_GDIObjects.oMemDC;
	const int		nScrollOffset = m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
	COLORREF		clrForeFixed = -1;	// OnQueryLineColor 瓾OiF
	COLORREF		clrBackFixed = -1;	// OnQueryLineColor 瓾wiF
	const COLORREF	clrSelectionFG =
		GetTextFoundation((::GetFocus() == m_hWnd) ? TT_SELECTION : TT_INACTIVESELECTION).fgColor;
	const COLORREF	clrSelectionBG =
		GetTextFoundation((::GetFocus() == m_hWnd) ? TT_SELECTION : TT_INACTIVESELECTION).bgColor;

	// I͈͂̌vZ
	if(!HasSelection())	// 
		iSelBegin = iSelEnd = -1;
	else if(!m_ModeState.bBoxSelecting) {	// `
		if(iLine == m_pAnchorPoint->m_iLine)
			iSelBegin = m_pAnchorPoint->m_iChar;
		else
			iSelBegin = (iLine < m_pAnchorPoint->m_iLine) ? -1 : 0;
		if(iLine == m_pActivePoint->m_iLine)
			iSelEnd = m_pActivePoint->m_iChar;
		else
			iSelEnd = (iLine < m_pActivePoint->m_iLine) ? -1 : 0;
	} else {	// `
		unsigned long	iTopLine = GetSelTopPoint().m_iLine;
		unsigned long	iBottomLine = GetSelBottomPoint().m_iLine;

		if(iLine >= iTopLine && iLine <= iBottomLine) {
			iSelBegin = CharFromPixel(iLine, m_layoutInfo.xBoxSelectionAnchor, !m_ModeState.bCaretMarkByMouse);
			iSelEnd = CharFromPixel(iLine, m_layoutInfo.xBoxSelectionActive, !m_ModeState.bCaretMarkByMouse);
		} else
			iSelBegin = iSelEnd = 0;
	}
	if(iSelBegin > iSelEnd)
		swap(iSelBegin, iSelEnd);

	// O
	oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan);
	GetClientRect(&rect);
	nXOffset = m_layoutInfo.nLeftMargin - nScrollOffset;
	if(m_pEventListener != 0)
		m_pEventListener->OnQueryLineColor(iLine, pLineInfo->IsBookmarked(),
			pLineInfo->GetUserDefinedValue(), pLineInfo == m_layoutInfo.pAppDefinedSingleLine, clrForeFixed, clrBackFixed);

	unsigned long	iChar = 0;	// ʒu
	unsigned long	cchToken;	// ̒
	TextType		ttCurrent;	// `悷镶̎
	TokenList::const_iterator	itTokens = listTokens.begin();
	while(nXOffset <= m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth) && itTokens != listTokens.end()) {
		nXOffset = itTokens->GetLeftEdge() + m_layoutInfo.nLeftMargin - nScrollOffset;

		// `KvȔ͈͂܂œǂݔ΂
		if(nXOffset + static_cast<long>(itTokens->GetTextWidth())
				< m_layoutInfo.rectUpdate.left - static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
			nXOffset += itTokens->GetTextWidth();
			++itTokens;
			continue;
		}

		iChar = itTokens->GetIndex();
		cchToken = itTokens->GetStringLength();
		ttCurrent = itTokens->GetType();

		if(cchToken == 1) {
			// \銇
			if(GetTextFoundation(TT_BRACKETSMATCH).enabled
					&& ((iLine == m_layoutInfo.posHilightedBrackets[0].m_iLine
					&& iChar == m_layoutInfo.posHilightedBrackets[0].m_iChar)
					|| (iLine == m_layoutInfo.posHilightedBrackets[1].m_iLine
					&& iChar == m_layoutInfo.posHilightedBrackets[1].m_iChar)))
				ttCurrent = TT_BRACKETSMATCH;
		}

		// `
		TTextFoundation&	tf = GetTextFoundation(ttCurrent);
		HFONT				hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttCurrent));
		bool				bOverflow = false;			// ܂ԂNꍇ true
//		unsigned long		cchDisplay = cchToken;		// 1x̕`ŏo͂镶
//		const unsigned long	iCharTokenStart = iChar;	// ܂Ԃ擪s̈ʒu
//		unsigned long		cxToken;					// DrawText ADrawSpace ̖߂l

		if(tf.enabled && tf.bold && m_FoundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan - 1);
//		do {	// ̕`悪I܂ŕ\si߂
			// ܂Ԃl
//			if(m_ModeState.wpmWrapMode != WPM_NONE) {
//				if(cDrawnLines < pLineInfo->m_vecWrappedOffsets.size()
//						&& iCharTokenStart + cchToken >= pLineInfo->m_vecWrappedOffsets[cDrawnLines]) {
//					bOverflow = true;
//					cchDisplay = pLineInfo->m_vecWrappedOffsets[cDrawnLines] - iChar;
//				} else if(bOverflow) {
//					bOverflow = false;
//					cchDisplay = cchToken - (iChar - iCharTokenStart);
//				}
//			}

			// g[N̕`
			RECT	rect;

			rect.top = y;
			rect.bottom = y + m_layoutInfo.nLineHeight;
			while(iChar < itTokens->GetIndex() + cchToken) {
				bool	bRtlReading = itTokens->GetCharDirection(iChar - itTokens->GetIndex());
				bool	bInSelection = iChar >= iSelBegin && iChar < iSelEnd;

				if(pwszLine[iChar] == L'\t') {	// ^u1
					oDC.SetTextColor(bInSelection ? clrSelectionFG :
						((clrForeFixed == -1) ? GetTextFoundation(TT_SPACE).fgColor : clrForeFixed));
					oDC.SetBkColor(bInSelection ? clrSelectionBG :
						((clrBackFixed == -1) ? GetTextFoundation(TT_SPACE).bgColor : clrBackFixed));
					rect.left = vecCaretPos[iChar] + m_layoutInfo.nLeftMargin - nScrollOffset;
					rect.right = GetNextTabStop(rect.left - m_layoutInfo.nLeftMargin
									+ nScrollOffset, false) + m_layoutInfo.nLeftMargin - nScrollOffset;
					oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, &m_FoundationInfo.chTab, bInSelection ? 0 : 1, 0);
					++iChar;
				} else if(CEditView::IsWhiteSpace(pwszLine + iChar, 1) > 0) {	// 󔒗ޕ1
					oDC.SetBkColor(bInSelection ? clrSelectionBG :
						((clrBackFixed == -1) ? GetTextFoundation(TT_SPACE).bgColor : clrBackFixed));
					rect.left = vecCaretPos[iChar]
						- (bRtlReading ? oDC.GetTextExtent(pwszLine + iChar, 1).cx : 0)
						+ m_layoutInfo.nLeftMargin - nScrollOffset;
					rect.right = bRtlReading ?
						vecCaretPos[iChar] - nScrollOffset + m_layoutInfo.nLeftMargin
							: rect.left + oDC.GetTextExtent(pwszLine + iChar, 1).cx;

					wchar_t	chAlternative;	// փOt
					if(pwszLine[iChar] == L'\x3000') {	// Ideographic Space
						chAlternative = m_FoundationInfo.chIdeographicSpace;
						oDC.SetTextColor(GetTextFoundation(TT_SPACE).fgColor);
					} else if(pwszLine[iChar] == L'\x1680') {	// Ogham Space Mark
						chAlternative = L'\x1680';
						oDC.SetTextColor(bInSelection ? clrSelectionFG :
							((clrForeFixed == -1) ? GetTextFoundation(TT_SPACE).fgColor : clrForeFixed));
					} else {
						chAlternative = m_FoundationInfo.chSpace;
						oDC.SetTextColor(GetTextFoundation(TT_SPACE).fgColor);
					}
					oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, &chAlternative, 1, 0);
					++iChar;
//				} else if(CEditView::IsNeutralNoAlpha(pszLine[iChar])) {	// ԕP\1
//					oDC.SetTextColor(bInSelection ? clrSelectionFG :
//						((clrForeFixed == -1) ? GetTextFoundation(ttCurrent).fgColor : clrForeFixed));
//					oDC.SetBkColor(bInSelection ? clrSelectionBG :
//						((clrBackFixed == -1) ? GetTextFoundation(ttCurrent).bgColor : clrBackFixed));
//					rect.left = vecCaretPos[iChar]
//						- (bRtlReading ? oDC.GetTextExtent(pszLine + iChar, 1).cx : 0)
//						+ m_layoutInfo.nLeftMargin - nScrollOffset;
//					rect.right = bRtlReading ?
//						vecCaretPos[iChar] - nScrollOffset + m_layoutInfo.nLeftMargin
//							: rect.left + oDC.GetTextExtent(pszLine + iChar, 1).cx;
//					oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, pszLine + iChar, 1, 0);
//					++iChar;
				} else {	// ̑͑̕I̒[A̕ύX܂ł܂Ƃ߂ĕ`
					unsigned long	cchDraw = 1;
					while(iChar - itTokens->GetIndex() + cchDraw < cchToken) {
						if(toBoolean(CEditView::IsWhiteSpace(pwszLine + iChar + cchDraw, 1) != 0))	// 󔒗ޕ͈ꏏɕ`悵Ȃ
							break;
						if(iSelBegin == iChar + cchDraw || iSelEnd == iChar + cchDraw)	// I̒[ŃXgbv
							break;
	//					if(CEditView::IsNeutralNoAlpha(pszLine[iChar + cchDraw]))	// ԕ̔P\͈ꏏɕ`悵Ȃ
	//						break;
						if(bRtlReading != itTokens->GetCharDirection(iChar + cchDraw - itTokens->GetIndex()))	// ςXgbv
							break;
						++cchDraw;
					}
					oDC.SetTextColor(bInSelection ?
						clrSelectionFG : ((clrForeFixed == -1) ? tf.fgColor : clrForeFixed));
					oDC.SetBkColor(bInSelection ?
						clrSelectionBG : ((clrBackFixed == -1) ? tf.bgColor : clrBackFixed));

					// ``̍vZ -> E -> `
					if(bRtlReading) {	// E獶
						rect.left = vecCaretPos[iChar] + m_layoutInfo.nLeftMargin
							- nScrollOffset - oDC.GetTextExtent(pwszLine + iChar, cchDraw).cx;
						rect.right = vecCaretPos[iChar] + m_layoutInfo.nLeftMargin - nScrollOffset + 1;
						oDC.ExtTextOut(rect.left, y, ETO_OPAQUE | ETO_RTLREADING, &rect, pwszLine + iChar, cchDraw, 0);
					} else {
						rect.left = vecCaretPos[iChar] + m_layoutInfo.nLeftMargin - nScrollOffset;
						rect.right = rect.left + oDC.GetTextExtent(pwszLine + iChar, cchDraw).cx;
						oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, pwszLine + iChar, cchDraw, 0);
					}
					iChar += cchDraw;
				}
			}

			// 
			nXOffset += itTokens->GetTextWidth();
			oDC.SetTextColor(tf.fgColor);
			DrawUnderline(itTokens->GetLeftEdge() + m_layoutInfo.nLeftMargin,
				nXOffset + m_layoutInfo.nLeftMargin, y, tf.underline);

//			iChar += cchDisplay;

//			if(bOverflow) {	// ̕\sɐi
				// TODO: ]hԂR[h...
//				++cDrawnLines;
//				nXOffset = m_layoutInfo.nLeftMargin
//							- GetAvgCharWidth() * m_ptScroll.x * m_layoutInfo.nHScrollRatio;
//			}
//		} while(bOverflow);

		if(tf.enabled && tf.bold && m_FoundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan);
		++itTokens;
		oDC.SelectObject(hOldFont);
	}

	// I}[N̕`
	if(nXOffset <= m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
		if(iLine == GetDocument()->GetLineCount() - 1) {	// 
			if(m_FoundationInfo.bDrawEOF) {	// [EOF] }[N
				RECT				rect;
				HFONT				hOldFont;
				TTextFoundation&	tf = GetTextFoundation(TT_ENDOFFILE);

				hOldFont = oDC.SelectObject(GetFontForRenderingToken(TT_ENDOFFILE));
				rect.left = nXOffset;
				rect.top = y;
				rect.right = rect.left + oDC.GetTextExtent(
					m_FoundationInfo.strEndOfFile.c_str(), m_FoundationInfo.strEndOfFile.length()).cx;
				rect.bottom = rect.top + m_layoutInfo.nLineHeight;
				oDC.SetTextColor(tf.fgColor);
				oDC.SetBkColor(tf.bgColor);
				oDC.ExtTextOut(nXOffset, y, ETO_OPAQUE, &rect,
					m_FoundationInfo.strEndOfFile.c_str(), m_FoundationInfo.strEndOfFile.length(), 0);
				oDC.SelectObject(hOldFont);
				nXOffset += rect.right - rect.left;
			}
		} else if(m_FoundationInfo.bDrawBreakArrow) {	// s}[N
			COLORREF	clrBreakBg;

			if(iSelBegin != -1 && iSelEnd == -1 && m_FoundationInfo.bPaintBreakContinuingSelection)
				clrBreakBg = GetTextFoundation(
					(::GetFocus() == m_hWnd) ? TT_SELECTION : TT_INACTIVESELECTION).bgColor;
			else if(clrBackFixed != -1)
				clrBreakBg = clrBackFixed;
			else
				clrBreakBg = GetTextFoundation(TT_NORMAL).bgColor;
			nXOffset += DrawBreakMark(nXOffset, y + cDrawnLines * m_layoutInfo.nLineHeight, bt, clrBreakBg);
		}
	}

	// E]̕`
	if(nXOffset <= m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth))
		oDC.FillSolidRect(nXOffset, y,
			m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth) - nXOffset,
			m_layoutInfo.nLineHeight, (clrBackFixed == -1) ? GetTextFoundation(TT_NORMAL).bgColor : clrBackFixed);

	// ]̕`
	if(m_layoutInfo.nLeftMargin != 0)
		oDC.FillSolidRect(0, y,
			m_layoutInfo.nLeftMargin /*- 1*/, m_layoutInfo.nLineHeight * (cDrawnLines + 1),
			GetTextFoundation(TT_NORMAL).bgColor);

	return cDrawnLines + 1;
}

/**
 *	݂̑OiFgĉ`悷 (W͑Săr[WB]r[ɓ)
 *	@param x1	n_ x W
 *	@param x2	I_ x W
 *	@param y	̓ y W
 *	@param ult	̎
 *	@see		UnderlineType
 */
void CEditView::DrawUnderline(int x1, int x2, int y, UnderlineType ult) {
	if(ult == ULT_NONE)
		return;

	HPEN		hPen, hOldPen;
	LOGBRUSH	lb;
	CMinimalDC&	oDC = m_GDIObjects.oMemDC;
	
	// AjA_̏ꍇ
	if(ult <= ULT_DOTTED) {
		if(ult == ULT_SOLID)
			hPen = ::CreatePen(PS_SOLID, 1, oDC.GetTextColor());
		else if(ult == ULT_DASHED)
			hPen = ::CreatePen(PS_DOT, 1, oDC.GetTextColor());
		else {
			lb.lbColor = oDC.GetTextColor();
			lb.lbStyle = BS_SOLID;
			hPen = ::ExtCreatePen(PS_COSMETIC | PS_ALTERNATE, 1, &lb, 0, 0);
		}
		hOldPen = oDC.SelectObject(hPen);
		oDC.MoveTo(x1, y + m_layoutInfo.nCharHeight - 1);
		oDC.LineTo(x2, y + m_layoutInfo.nCharHeight - 1);
		oDC.SelectObject(hOldPen);
	} else if(ult == ULT_WAVED) {	// g
		hPen = ::CreatePen(PS_SOLID, 1, oDC.GetTextColor());
		hOldPen = oDC.SelectObject( hPen);
		for(int i = 0; x1 + i * 2 <= x2; ++i) {
			oDC.MoveTo(x1 + i * 2, y + m_layoutInfo.nCharHeight - ((i % 2 == 0) ? 1 : 2));
			oDC.LineTo(x1 + i * 2 + 2, y + m_layoutInfo.nCharHeight - ((i % 2 == 0) ? 1 : 2));
		}
		oDC.SelectObject(hOldPen);
	}
	::DeleteObject(hPen);
}

/// @see	IDropTarget::Drop
STDMETHODIMP CEditView::Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	if(m_ldmLeftDown == LDM_DRAGANDDROP) {	// vZX̃f[^
		char*		pszText = 0;
		wchar_t*	pwszText = 0;
		FORMATETC	fe = {CF_UNICODETEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
		STGMEDIUM	stm = {TYMED_HGLOBAL, 0};
		size_t		cch;
		POINT		ptCaret = {pt.x, pt.y};

		KillTimer(ID_TIMER_DRAGSCROLL);
		ScreenToClient(&ptCaret);
		CCharPos	pos = CharFromPos(ptCaret, !m_ModeState.bCaretMarkByMouse);
		SetSelWithoutSelection(pos);
		UINT		nBoxClipFormat = ::RegisterClipboardFormatW(L"MSDEVColumnSelect");

		if(pDataObj->QueryGetData(&fe) == S_OK) {	// CF_UNICODETEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				cch = ::GlobalSize(stm.hGlobal) / sizeof(wchar_t);
				pwszText = reinterpret_cast<wchar_t*>(::GlobalLock(stm.hGlobal));
//				*(pwszText + cch) = 0;
				GetDocument()->EndEditCollection();
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					GetDocument()->BeginEditCollection();
					m_pActivePoint->InsertBox(pwszText);
					GetDocument()->EndEditCollection();
					BeginBoxSelect();
				} else
					m_pActivePoint->Insert(pwszText);
				Unfreeze();
				OnMoveCaret();
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
					// ::GlobalFree(stm.hGlobal);
				*pdwEffect = DROPEFFECT_COPY;
			}
		} else if(fe.cfFormat = CF_TEXT, pDataObj->QueryGetData(&fe) == S_OK) {	// CF_TEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				cch = ::GlobalSize(stm.hGlobal) / sizeof(char);
				pszText = reinterpret_cast<char*>(::GlobalLock(stm.hGlobal));
//				*(pszText + cch) = 0;
				pwszText = new wchar_t[cch];
				::MultiByteToWideChar(CP_ACP, 0, pszText, -1, pwszText, cch);
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					GetDocument()->BeginEditCollection();
					m_pActivePoint->InsertBox(pwszText);
					GetDocument()->EndEditCollection();
					BeginBoxSelect();
				} else
					m_pActivePoint->Insert(pwszText);
				Unfreeze();
				OnMoveCaret();
				delete[] pwszText;
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
					// ::GlobalFree(stm.hGlobal);
				*pdwEffect = DROPEFFECT_COPY;
			}
		}
	} else if(m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// vZX̃f[^ (pDataObj gȂȒPȏ)
		CEditDoc*	pDoc = GetDocument();
		wstring		strText = GetSelection();
		POINT		ptCaret = {pt.x, pt.y};

		ScreenToClient(&ptCaret);
		CCharPos	pos = CharFromPos(ptCaret, !m_ModeState.bCaretMarkByMouse);

		// vZX̃f[^͑I͈͏Ƀhbvs
		if(IsOverSelection(ptCaret)) {
			*pdwEffect = DROPEFFECT_NONE;
			m_ldmLeftDown = LDM_NONE;
			SetSelWithoutSelection(pos);
			return S_OK;
		}

		pDoc->BeginEditCollection();
		Freeze();

		if(grfKeyState & MK_CONTROL) {	// 
			InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
			m_pAnchorPoint->MoveToPoint(pos);
			m_pActivePoint->MoveToPoint(pos);
			if(m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF)
				m_pActivePoint->InsertBox(strText);
			else
				m_pActivePoint->Insert(strText);
			*pdwEffect = DROPEFFECT_COPY;
		} else if(m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// `ړ̏ꍇ͈ʒu֌W͊֌WȂ
			CEditPoint*	pInsertPoint = CreateEditPoint();
			CCharPos	posInsert;

			pInsertPoint->SynchronizeWithOtherEdit(true);
			*pInsertPoint = posInsert = pos;
			pInsertPoint->InsertBox(strText);
			DeleteSel();
			m_pAnchorPoint->MoveToPoint(pos);
			m_pActivePoint->MoveToPoint(*pInsertPoint);
			m_pActivePoint->Insert(L"");	// _~[
			delete pInsertPoint;
			*pdwEffect = DROPEFFECT_MOVE;
		} else {
			CEditPoint*	pActivePointOrg = CreateEditPoint();
			CCharPos	posAnchorOrg = *m_pAnchorPoint;

			pActivePointOrg->SynchronizeWithOtherEdit(true);
			pActivePointOrg->m_iLine = m_pActivePoint->m_iLine;
			pActivePointOrg->m_iChar = m_pActivePoint->m_iChar;
			m_pAnchorPoint->MoveToPoint(pos);
			m_pActivePoint->MoveToPoint(pos);
			pActivePointOrg->Delete(posAnchorOrg);
			m_pActivePoint->Insert(strText);
			delete pActivePointOrg;
			*pdwEffect = DROPEFFECT_MOVE;
		}
		pDoc->EndEditCollection();
		Unfreeze();
		OnMoveCaret();
		m_eoLast.set(EOT_PASTE, *m_pActivePoint);
	}
	m_ldmLeftDown = LDM_NONE;
	return S_OK;
}

/**
 *	R}h̏
 *	@param cmd		sR}hʎq
 *	@param lParam	R}hˑ̃p[^
 */
void CEditView::ExecCommand(CommandIdentifier cmd, LPARAM lParam) {
	AssertValid();

	// L[}NɋL^
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING
			&& m_pKeyMacroPlayer->GetActiveView() == this) {
		TKeymacroCommand	kmc;
		kmc.cmd = cmd;
		kmc.lParam = lParam;
		m_pKeyMacroPlayer->AddCommand(kmc);
	}

	switch(cmd) {
		// ړ/I
	case CMDID_MOVE_BOOKMARKNEXT:		CmdMoveNextBookmark();							break;
	case CMDID_MOVE_BOOKMARKPREV:		CmdMovePrevBookmark();							break;
	case CMDID_MOVE_CANCELSELECTION:	CmdMoveCancelSelection();						break;
	case CMDID_MOVE_CHARNEXT:			CmdMoveCharNext(false, lParam);					break;
	case CMDID_MOVE_CHARNEXTEXTEND:		CmdMoveCharNext(true, lParam);					break;
	case CMDID_MOVE_CHARPREV:			CmdMoveCharPrev(false, lParam);					break;
	case CMDID_MOVE_CHARPREVEXTEND:		CmdMoveCharPrev(true, lParam);					break;
	case CMDID_MOVE_END:				CmdMoveEnd(false);								break;
	case CMDID_MOVE_ENDEXTEND:			CmdMoveEnd(true);								break;
	case CMDID_MOVE_HOME:				CmdMoveHome(false);								break;
	case CMDID_MOVE_HOMEEXTEND:			CmdMoveHome(true);								break;
	case CMDID_MOVE_LINEDOWN:			CmdMoveLineDown(false, lParam);					break;
	case CMDID_MOVE_LINEDOWNEXTEND:		CmdMoveLineDown(true, lParam);					break;
	case CMDID_MOVE_LINEEND:			CmdMoveLineEnd(false);							break;
	case CMDID_MOVE_LINEENDEXTEND:		CmdMoveLineEnd(true);							break;
	case CMDID_MOVE_LINEHOME:			CmdMoveLineHome(false);							break;
	case CMDID_MOVE_LINEHOMEEXTEND:		CmdMoveLineHome(true);							break;
	case CMDID_MOVE_LINEUP:				CmdMoveLineUp(false, lParam);					break;
	case CMDID_MOVE_LINEUPEXTEND:		CmdMoveLineUp(true, lParam);					break;
	case CMDID_MOVE_MATCHBRACKET:		CmdMoveMatchBracket(false);						break;
	case CMDID_MOVE_MATCHBRACKETEXTEND:	CmdMoveMatchBracket(true);						break;
	case CMDID_MOVE_PAGEDOWN:			CmdMovePageDown(false, lParam);					break;
	case CMDID_MOVE_PAGEDOWNEXTEND:		CmdMovePageDown(true, lParam);					break;
	case CMDID_MOVE_PAGEUP:				CmdMovePageUp(false, lParam);					break;
	case CMDID_MOVE_PAGEUPEXTEND:		CmdMovePageUp(true, lParam);					break;
	case CMDID_MOVE_SELECTALL:			CmdMoveSelectAll();								break;
	case CMDID_MOVE_SELECTCURRENTWORD:	CmdMoveSelectCurrentWord();						break;
	case CMDID_MOVE_WORDENDNEXT:		CmdMoveWordEndNext(false, lParam);				break;
	case CMDID_MOVE_WORDENDNEXTEXTEND:	CmdMoveWordEndNext(true, lParam);				break;
	case CMDID_MOVE_WORDENDPREV:		CmdMoveWordEndPrev(false, lParam);				break;
	case CMDID_MOVE_WORDENDPREVEXTEND:	CmdMoveWordEndPrev(true, lParam);				break;
	case CMDID_MOVE_WORDNEXT:			CmdMoveWordNext(false, lParam);					break;
	case CMDID_MOVE_WORDNEXTEXTEND:		CmdMoveWordNext(true, lParam);					break;
	case CMDID_MOVE_WORDPREV:			CmdMoveWordPrev(false, lParam);					break;
	case CMDID_MOVE_WORDPREVEXTEND:		CmdMoveWordPrev(true, lParam);					break;
		// ҏW
	case CMDID_EDIT_BACKSPACE:				CmdEditBackspace();							break;
	case CMDID_EDIT_BREAK:					CmdEditBreak();								break;
	case CMDID_EDIT_CHAR:					CmdEditChar(static_cast<unsigned long>(lParam));	break;
	case CMDID_EDIT_COPY:					CmdEditCopy();								break;
	case CMDID_EDIT_CUT:					CmdEditCut();								break;
	case CMDID_EDIT_DELETE:					CmdEditDelete();							break;
	case CMDID_EDIT_DELETELINE:				CmdEditDeleteLine();						break;
	case CMDID_EDIT_DELETETONEXTWORD:		CmdEditDeleteToNextWord();					break;
	case CMDID_EDIT_DELETETOPREVWORD:		CmdEditDeleteToPrevWord();					break;
	case CMDID_EDIT_INSERTPREVLINE:			CmdEditInsertPrevLine();					break;
	case CMDID_EDIT_MAKESELCAPITAL:			CmdEditConvertSel(SCT_CAPITALIZE);			break;
	case CMDID_EDIT_MAKESELLOWER:			CmdEditConvertSel(SCT_LOWERCASE);			break;
	case CMDID_EDIT_MAKESELUPPER:			CmdEditConvertSel(SCT_UPPERCASE);			break;
	case CMDID_EDIT_OPENCANDIDATEWINDOW:	CmdEditOpenCandidateWindow();				break;
	case CMDID_EDIT_PASTE:					CmdEditPaste();								break;
	case CMDID_EDIT_RECOMPOSESELECTION:		CmdEditRecomposeSelection();				break;
	case CMDID_EDIT_REDO:					CmdEditRedo();								break;
	case CMDID_EDIT_SETNEXTINPUTCONVERT:	CmdEditSetNextInputConvert(static_cast<NextCharConvert>(lParam));	break;
	case CMDID_EDIT_SPACEINDENT:			CmdEditSpaceIndent(false);					break;
	case CMDID_EDIT_SPACEUNINDENT:			CmdEditSpaceIndent(true);					break;
	case CMDID_EDIT_TABIFY:					CmdEditTabify(false);						break;
	case CMDID_EDIT_TABINDENT:				CmdEditTabIndent(false);					break;
	case CMDID_EDIT_TABUNINDENT:			CmdEditTabIndent(true);						break;
	case CMDID_EDIT_TEXT:					CmdEditText(reinterpret_cast<const wchar_t*>(lParam));	break;
	case CMDID_EDIT_TOGGLECHARCODEPOINT:	CmdEditToggleCharCodePoint();				break;
	case CMDID_EDIT_TOGGLEIMESTATUS:		CmdEditToggleIMEStatus();					break;
	case CMDID_EDIT_TOGGLEOVERTYPEMODE:		CmdEditToggleOvertypeMode();				break;
	case CMDID_EDIT_UNDO:					CmdEditUndo();								break;
	case CMDID_EDIT_UNTABIFY:				CmdEditTabify(true);						break;
		// XN[
	case CMDID_SCROLL_COLUMNNEXT:			CmdScrollColumnNext();			break;
	case CMDID_SCROLL_COLUMNPREV:			CmdScrollColumnPrev();			break;
	case CMDID_SCROLL_END:					CmdScrollEnd();					break;
	case CMDID_SCROLL_ENSURECARETCENTERED:	CmdScrollEnsureCaretCentered();	break;
	case CMDID_SCROLL_ENSURECARETVISIBLE:	CmdScrollEnsureCaretVisible();	break;
	case CMDID_SCROLL_HOME:					CmdScrollHome();				break;
	case CMDID_SCROLL_LINEDOWN:				CmdScrollLineDown();			break;
	case CMDID_SCROLL_LINEUP:				CmdScrollLineUp();				break;
	case CMDID_SCROLL_PAGEDOWN:				CmdScrollPageDown();			break;
	case CMDID_SCROLL_PAGEUP:				CmdScrollPageUp();				break;
	}
}

/**
 *	ΊʂTB<var>pos</var> ɊʂΏ false Ԃ
 *	@param pos				ʂ̈ʒu
 *	@param posFound			Ίʂ̈ʒu
 *	@return					Ƃ^
 */
bool CEditView::FindBracket(const CCharPos& pos, CCharPos& posFound) const {
	AssertValid();

	const wstring&	strCurrentLine = GetDocument()->GetLine(pos.m_iLine);
	unsigned long	cchLine = strCurrentLine.length();

	if(pos.m_iChar >= cchLine)
		return false;

	wchar_t	wchBrace = strCurrentLine.at(pos.m_iChar), wchMatch;	// ʂƑΊ
	bool	bBackward;												// ʂT

	switch(wchBrace) {	// Unicode 4.0 ̑SĂ̊ʂɑΉĂǂA͂3gł낤
	case L'(':	wchMatch = L')';	bBackward = false;	break;
	case L')':	wchMatch = L'(';	bBackward = true;	break;
	case L'{':	wchMatch = L'}';	bBackward = false;	break;
	case L'}':	wchMatch = L'{';	bBackward = true;	break;
	case L'[':	wchMatch = L']';	bBackward = false;	break;
	case L']':	wchMatch = L'[';	bBackward = true;	break;
	default:	return false;
	}

	/*
	 *	.:߂:.
	 *	Unicode ł́uΊʁv̒`ȂAʕނ Ps
	 *	(Punctuation Open)  Pe (Punctuation Close) ŃyÂY邾낤B
	 *	Unicode 4.0 ł̃vpeB͈̂ȉ̑gݍ킹:
	 *
	 *	(0028, 0029), (005B, 005D), (007B, 007D), (0F3A, 0F3B), (0F3C, 0F3D),
	 *	(169B, 169C), (2045, 2046), (207D, 207E), (208D, 208E), (2329, 232A),
	 *	(23B4, 23B5), (2768, 2769), (276A, 276B), (276C, 276D), (276E, 276F),
	 *	(2770, 2771), (2772, 2773), (2774, 2775), (27E6, 27E7), (27E8, 27E9),
	 *	(27EA, 27EB), (2983, 2984), (2985, 2986), (2987, 2988), (2989, 298A),
	 *	(298B, 298C), (298D, 298E), (298F, 2990), (2991, 2992), (2993, 2994),
	 *	(2995, 2996), (2997, 2998), (29D8, 29D9), (29DA, 29DB), (29FC, 29FD),
	 *	(3008, 3009), (300A, 300B), (300C, 300D), (300E, 300F), (3010, 3011),
	 *	(3014, 3015), (3016, 3017), (3018, 3019), (301A, 301B), (301D, 301F),
	 *	(FD3E, FD3F), (FE35, FE36), (FE37, FE38), (FE39, FE3A), (FE3B, FE3C),
	 *	(FE3D, FE3E), (FE3F, FE40), (FE41, FE42), (FE43, FE44), (FE45, FE46),
	 *	(FE47, FE48), (FE59, FE5A), (FE5B, FE5C), (FE5D, FE5E), (FF08, FF09),
	 *	(FF3B, FF3D), (FF5B, FF5D), (FF5F, FF60), (FF62, FF63)
	 *
	 *	yA̖J: 201A, 201E
	 *	yA̖: 301E
	 *
	 *	IvVł ASCII ȊO̊ʂ\ł悤ɂ邩Ȃ
	 */

	const CEditDoc*				pDocument = GetDocument();
	const wchar_t				wszBrackets[] = {wchBrace, wchMatch, 0};
	unsigned long				cLines = pDocument->GetLineCount();
	unsigned long				iLine = pos.m_iLine;
	unsigned long				iChar = !bBackward ? pos.m_iChar + 1 : pos.m_iChar - 1;
	const CLineLayoutInfo*		pLineInfo = 0;
	TokenList::const_iterator	itTokens;
	unsigned long				nNest = 1;			// qx
	unsigned long				cSearchedLines = 0;	// s

	while(true) {	// _s[v
		const wstring&	strLine = pDocument->GetLine(iLine);
		cchLine = pDocument->GetLineLength(iLine);

		if(cchLine != 0 && (!bBackward || cSearchedLines != 0 || pos.m_iChar != 0)) {
			pLineInfo = m_pLineLayoutManager->GetLine(iLine);
			if(cSearchedLines != 0)
				iChar = !bBackward ? 0 : cchLine - 1;

			if(!bBackward)
				itTokens = pLineInfo->GetTokenList().begin();
			else {
				itTokens = pLineInfo->GetTokenList().end();
				--itTokens;
			}

			while(true) {	// ʂT
				iChar = !bBackward ? strLine.find_first_of(wszBrackets, iChar) : strLine.find_last_of(wszBrackets, iChar);
				if(iChar == wstring::npos)
					break;
				while(!(iChar >= itTokens->GetIndex() && iChar < itTokens->GetIndex() + itTokens->GetStringLength()))
					!bBackward ? ++itTokens : --itTokens;
				if(itTokens->GetType() != TT_COMMENT
						&& itTokens->GetType() != TT_DOUBLEQUOTATION
						&& itTokens->GetType() != TT_SINGLEQUOTATION) {
					if(strLine[iChar] == wchBrace)
						++nNest;
					else if(strLine[iChar] == wchMatch && --nNest == 0) {
						posFound = CCharPos(iLine, iChar);
						return true;
					}
					if(bBackward && iChar == 0)
						break;
					iChar += !bBackward ? 1 : -1;
				} else	// XLbv
					iChar = !bBackward ? itTokens->GetIndex() + itTokens->GetStringLength() : itTokens->GetIndex();
				if((!bBackward && iChar == cchLine) || (bBackward && iChar == 0))
					break;
			}
		}

		if(++cSearchedLines >= m_ModeState.cFindLimit)
			return false;
		if((bBackward && iLine == 0) || (!bBackward && iLine == cLines - 1))
			return false;
		iLine += !bBackward ? 1 : -1;
	}

	return false;
}

/**
 *	݂̑I͈͏I_/n_當AIԂɂBȂΉȂ
 *	@param strText	镶Br null Ă͂Ȃ
 *	@param sfFlags	tO
 *	@return			 true
 */
bool CEditView::FindNext(const wstring& strText, SearchFlag sfFlags) {
	AssertValidAsWindow();
	CWaitCursor();

	const CEditDoc*	pDocument = GetDocument();
	CCharPos		posBegin = toBoolean(sfFlags & SF_BACKWARD) ?
						GetSelTopPoint() : GetSelBottomPoint();	// ŏ̍šJn_
	unsigned long	iEndLine = toBoolean(sfFlags & SF_BACKWARD) ?
						0 : pDocument->GetLineCount() - 1;	// Is
	size_t			iFound, cchFound;

	CEditView::m_oTextSearcher.SetFlag(sfFlags);
	CEditView::m_oTextSearcher.SetText(strText);
	for(unsigned long iLine = posBegin.m_iLine; ; iLine += (toBoolean(sfFlags & SF_BACKWARD) ? -1 : 1)) {
		CEditView::m_oTextSearcher.SetTargetText(pDocument->GetLine(iLine));
		if(iLine != posBegin.m_iLine)
			posBegin.m_iChar = toBoolean(sfFlags & SF_BACKWARD) ? -1 : 0;
		try {
			if(CEditView::m_oTextSearcher.Search(posBegin.m_iChar, iFound, cchFound)) {
				SetSel(CCharPos(iLine, iFound), CCharPos(iLine, iFound + cchFound));
				return true;
			}
		} catch(EFailedToLoadRegExpEngine& /* e */) {
			throw;
		} catch(ERegExpPatternIsInvalid& /* e */) {
			throw;
		}
		if(iLine == iEndLine)
			break;
		posBegin.m_iChar = toBoolean(sfFlags & SF_BACKWARD) ? pDocument->GetLineLength(iLine - 1) : 0;
	}

	return false;
}

///	`̃t[Y
void CEditView::Freeze() {
	AssertValidAsWindow();

	m_pOriginalView->m_bFreezed = true;
	for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
		(*it)->m_bFreezed = true;
}

///	ANeBu|CgԂ
CCharPos CEditView::GetActivePoint() const {
	AssertValid();
	return *m_pActivePoint;
}

/**
 *	Ss̃AvP[V`lXgɂĎ擾
 *	@param listLines	XgBl0̍s͊O
 */
void CEditView::GetAllLineParams(list<TAppDefinedLine>& listLines) const {
	AssertValid();

	unsigned long		cLines = GetDocument()->GetLineCount();
	TAppDefinedLine		line;

	listLines.clear();
	for(unsigned long iLine = 0; iLine < cLines; ++iLine) {
		DWORD	dwParam = m_pLineLayoutManager->GetLine(iLine)->GetUserDefinedValue();
		if(dwParam != 0) {
			line.iLine = iLine;
			line.dwParam = dwParam;
			listLines.push_back(line);
		}
	}
}

///	AJ[|CgԂ
CCharPos CEditView::GetAnchorPoint() const {
	AssertValid();
	return *m_pAnchorPoint;
}

/**
 *	ubN}[ÑXgԂ
 *	@param listLines	ubN}[NĂsԍ̃Xg
 */
void CEditView::GetBookmarkList(list<unsigned long>& listLines) const {
	AssertValid();

	unsigned long	cLines = GetDocument()->GetLineCount();

	listLines.clear();
	for(unsigned long iLine = 0; iLine < cLines; ++iLine) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked())
			listLines.push_back(iLine);
	}
}

///	\sԂ
unsigned long CEditView::GetDisplayLineCount() const {
	AssertValid();

//	if(m_ModeState.wpmWrapMode == WPM_NONE)
		return GetDocument()->GetLineCount();
/*
	unsigned long		cDisplayLines = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
	while(pInfo != 0) {
		cDisplayLines += pInfo->m_vecWrappedOffsets.size() + 1;
		pInfo = pInfo->m_pNext;
	}
	return cDisplayLines;*/
}

/**
 *	\s_ŝǂ̃ItZbgɑ邩Ԃ
 *	@param iDisplayLine	\s
 *	@param iLogicalLine	_s (iDisplayLine ȏꍇ-1)
 *	@param iOffset		_sŉԖڂ̕\s (iDisplayLine ȏꍇ-1)
 */
void CEditView::GetDisplayLineOffsetIndex(
		unsigned long iDisplayLine, unsigned long& iLogicalLine, unsigned long& iOffset) const {
	AssertValid();

//	if(m_ModeState.wpmWrapMode == WPM_NONE) {
		iLogicalLine = iDisplayLine;
		iOffset = 0;
/*		return;
	} else {
		CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
		unsigned long		iTotalDisplayLine = 0;

		iLogicalLine = 0;
		while(pInfo != 0) {
			if(iTotalDisplayLine + pInfo->m_vecWrappedOffsets.size() + 1 > iDisplayLine) {
				iOffset = iDisplayLine - iTotalDisplayLine;
				return;
			}
			iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
			pInfo = pInfo->m_pNext;
			++iLogicalLine;
		}
	}
	iLogicalLine = iOffset = -1;*/
}

/**
 *	hLgIuWFNg̎擾
 *	@return	hLgIuWFNg
 */
CEditDoc* CEditView::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CEditDoc*>(m_pDocument);
}

/**
 *	w肵s̃AvP[V`l擾
 *	@param iLine	_s
 *	@return			s̃AvP[V`l (擾Ɏsꍇ0Ԃ)
 */
DWORD CEditView::GetLineParam(unsigned long iLine) const {
	AssertValid();

	CLineLayoutInfo*	pLineInfo = m_pLineLayoutManager->GetLine(iLine);
	return (pLineInfo != 0) ? pLineInfo->GetUserDefinedValue() : 0;
}

/**
 *	Lbgt߂ɂPԂB
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	PꂪȂꍇAIꍇ͋󕶎Ԃ
 *	@see	GetNearestWordFromCursor, GetPrecedingWord
 */
wstring CEditView::GetNearestWordFromCaret() const {
	AssertValid();

	if(HasSelection())
		return L"";

	unsigned long	iStart, iEnd;
	const wstring&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
	const wchar_t*	pszLine = strLine.c_str();
	unsigned long	cchLine = strLine.length();
	unsigned long	nCodePoint;

	iStart = iEnd = m_pActivePoint->m_iChar;

	// Jnʒu𒲂ׂ
	while(iStart > 0) {
		if(IsUTF16LowSurrogate(pszLine[iStart - 1])
				&& iStart > 1
				&& IsUTF16HighSurrogate(pszLine[iStart - 2]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pszLine + iStart - 2, 2);
		else
			nCodePoint = pszLine[iStart - 1];
		if(binary_search(m_FoundationInfo.listCharsTreatedAsAlpha.begin(),
				m_FoundationInfo.listCharsTreatedAsAlpha.end(), nCodePoint)
				|| CEditView::IsIdentifierContinueChar(nCodePoint))
			iStart -= ((nCodePoint >= 0x010000) ? 2 : 1);
		else
			break;
	}

	// Iʒu𒲂ׂ
	while(true) {
		if(IsUTF16HighSurrogate(pszLine[iEnd])
				&& iEnd < cchLine - 1
				&& IsUTF16LowSurrogate(pszLine[iEnd + 1]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pszLine + iEnd, 2);
		else
			nCodePoint = pszLine[iEnd];
		if(binary_search(m_FoundationInfo.listCharsTreatedAsAlpha.begin(),
				m_FoundationInfo.listCharsTreatedAsAlpha.end(), nCodePoint)
				|| CEditView::IsIdentifierContinueChar(nCodePoint))
			iEnd += ((nCodePoint >= 0x010000) ? 2 : 1);
		else
			break;
	}

	return strLine.substr(iStart, iEnd - iStart);
}

/**
 *	J[\t߂ɂPԂB
 *	Ԃ镶ɂĂ CEditView::GetNearestWordFromCaret 
 *	@see	GetNearestWordFromCaret, GetPrecedingWord
 */
wstring CEditView::GetNearestWordFromCursor() const {
	AssertValidAsWindow();

	CCharPos	posAnchorOrg = *m_pAnchorPoint;
	CCharPos	posActiveOrg = *m_pActivePoint;
	CCharPos	posCursor;
	POINT		ptCursor;
	wstring		strWord;

	::GetCursorPos(&ptCursor);
	ScreenToClient(&ptCursor);
	posCursor = CharFromPos(ptCursor, false);
	const_cast<CEditView*>(this)->m_pAnchorPoint->MoveToPoint(posCursor);
	const_cast<CEditView*>(this)->m_pActivePoint->MoveToPoint(posCursor);
	strWord = GetNearestWordFromCaret();
	const_cast<CEditView*>(this)->m_pAnchorPoint->MoveToPoint(posAnchorOrg);
	const_cast<CEditView*>(this)->m_pActivePoint->MoveToPoint(posActiveOrg);

	return strWord;
}

/**
 *	Lbg̒OɂPԂB
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	PꂪȂꍇAIꍇA
 *	͒Pꂪw肵ō𒴂ꍇ͋󕶎Ԃ
 *	@see	GetNearestWordFromCaret, GetNearestWordFromCursor
 */
wstring CEditView::GetPrecedingWord(unsigned long cchLimit) const {
	AssertValid();

	if(HasSelection() || m_pActivePoint->m_iChar == 0)
		return L"";
	unsigned long	iChar = m_pActivePoint->m_iChar - 1;
	const wstring&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
	const wchar_t*	pszLine = strLine.c_str();
	unsigned long	nCodePoint;

	while(iChar != 0) {
		if(m_pActivePoint->m_iChar - iChar > cchLimit)
			return L"";
		if(IsUTF16LowSurrogate(pszLine[iChar])
				&& iChar > 0
				&& IsUTF16HighSurrogate(pszLine[iChar - 1]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pszLine + iChar - 1, 2);
		else
			nCodePoint = pszLine[iChar];
		if(CEditView::IsIdentifierContinueChar(nCodePoint))
			iChar -= ((nCodePoint >= 0x010000) ? 2 : 1);
		else {
			++iChar;
			break;
		}
	}
	return strLine.substr(iChar, m_pActivePoint->m_iChar - iChar);
}

/**
 *	I͈͂⌻݈ʒu̎擾
 *	@param posAnchor	IJnʒu
 *	@param posActive	IIʒu
 */
void CEditView::GetSel(CCharPos& posAnchor, CCharPos& posActive) const {
	AssertValid();
	posAnchor = *m_pAnchorPoint;
	posActive = *m_pActivePoint;
}

///	I͈̖͂Ԃ
const CVisibleEditPoint& CEditView::GetSelBottomPoint() const {
	AssertValid();
	return max(*m_pAnchorPoint, *m_pActivePoint);
}

///	I͈͂̐擪Ԃ
const CVisibleEditPoint& CEditView::GetSelTopPoint() const {
	AssertValid();
	return min(*m_pAnchorPoint, *m_pActivePoint);
}

/**
 *	I͈͂̎̕擾
 *	@return	I͈͂̕
 */
wstring CEditView::GetSelection() const {
	AssertValid();

	if(!HasSelection())
		return L"";

	wostringstream	ssSelection;
	CEditDoc*		pDoc = GetDocument();
	CCharPos		posTop = GetSelTopPoint();
	CCharPos		posBottom = GetSelBottomPoint();
	unsigned long	iLine = posTop.m_iLine;
	LineIterator	itLines;

	if(!m_ModeState.bBoxSelecting) {	// `IłȂꍇ
		if(posTop.m_iLine == posBottom.m_iLine)	// I1s̏ꍇ
			return pDoc->GetLine(posTop.m_iLine).substr(posTop.m_iChar, posBottom.m_iChar - posTop.m_iChar);
		else {								// I2sȏ̏ꍇ
			itLines = pDoc->GetLineIterator(iLine);
			while(true) {	// I𒆂̊es1̕ɂȂ
				if(iLine == posTop.m_iLine)		// IJns
					ssSelection << itLines->GetLine().substr(posTop.m_iChar);
				else if(iLine == posBottom.m_iLine) {	// IIs
					ssSelection << itLines->GetLine().substr(0, posBottom.m_iChar);
					break;
				} else
					ssSelection << pDoc->GetLine(iLine);
				ssSelection << CEditDoc::GetBreakString(itLines->GetBreakType());
				++iLine;
				++itLines;
			}
		}
	} else {	// `Ȉꍇ
		unsigned long	xLeft = min(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive);
		unsigned long	xRight = max(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive);
		unsigned long	iBegin;

		itLines = pDoc->GetLineIterator(iLine);
		while(true) {
			iBegin = CharFromPixel(iLine, xLeft, !m_ModeState.bCaretMarkByMouse);
			ssSelection << itLines->GetLine().substr(
				iBegin, CharFromPixel(iLine, xRight, !m_ModeState.bCaretMarkByMouse) - iBegin);
			ssSelection << CEditDoc::GetBreakString(itLines->GetBreakType());
			if(iLine == posBottom.m_iLine)
				break;
			++iLine;
			++itLines;
		}
	}

	return ssSelection.str();
}

///	@see	IDropSource::GiveFeedback
STDMETHODIMP CEditView::GiveFeedback(DWORD dwEffect) {
	AssertValid();
	return DRAGDROP_S_USEDEFAULTCURSORS;	// VXẽftHg̃J[\g 
}

/**
 *	w肵sɃubN}[Nݒ肳Ă邩ǂԂ
 *	@param iLine	ׂs
 */
bool CEditView::HasBookmarkAt(unsigned long iLine) const throw(out_of_range) {
	AssertValid();
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	return pInfo->IsBookmarked();
}

/**
 *	I͈͂邩ǂԂ
 *	@return	I͈͂Ȃ true
 */
bool CEditView::HasSelection() const {
	AssertValid();
	return *m_pAnchorPoint != *m_pActivePoint;
}

///	EBhȄ
void CEditView::InitializeWindow() {
	AssertValidAsWindow();

	// WReLXgj[̍쐬BAscension ł
	// GUI ŃeLXggȂB{ȊOɂΉĂ݂
	if(CEditView::m_oContextMenu.GetItemCount() == 0) {
		bool	bJapanese = ::GetUserDefaultLangID() == 0x0411;

		m_oContextMenu.AppendMenuItem(WM_UNDO, MFT_STRING | MFS_DISABLED, bJapanese ? L"ɖ߂(&U)" : L"&Undo");
		m_oContextMenu.AppendMenuItem(WM_REDO, MFT_STRING | MFS_DISABLED, bJapanese ? L"蒼(&R)" : L"&Redo");
		m_oContextMenu.AppendMenuItem(0, MFT_SEPARATOR, 0);
		m_oContextMenu.AppendMenuItem(WM_CUT, MFT_STRING, bJapanese ? L"؂(&T)" : L"Cu&t");
		m_oContextMenu.AppendMenuItem(WM_COPY, MFT_STRING, bJapanese ? L"Rs[(&C)" : L"&Copy");
		m_oContextMenu.AppendMenuItem(WM_PASTE, MFT_STRING, bJapanese ? L"\t(&P)" : L"&Paste");
		m_oContextMenu.AppendMenuItem(WM_CLEAR, MFT_STRING, bJapanese ? L"폜(&D)" : L"&Delete");
		m_oContextMenu.AppendMenuItem(0, MFT_SEPARATOR, 0);
		m_oContextMenu.AppendMenuItem(WM_SELECTALL, MFT_STRING, bJapanese ? L"ׂđI(&A)" : L"Select &All");
		m_oContextMenu.AppendMenuItem(0, MFT_SEPARATOR, 0);
		m_oContextMenu.AppendMenuItem(ID_SHOWRTL, MFT_STRING | MFS_GRAYED, bJapanese ? L"E獶ɓǂ(&R)" : L"&Read right to left");
		m_oContextMenu.AppendMenuItem(ID_SHOWUNICODECONTROLCHARS,
			MFT_STRING | MFS_GRAYED, bJapanese ? L"Unicode 䕶̕\(&S)" : L"&Show Unicode Controls");
		CPopupMenu* pMenu = m_oContextMenu.AppendMenuItem(12,
			MF_POPUP, bJapanese ? L"Unicode 䕶̑}(&I)" : L"&Insert Unicode Controls");
		pMenu->AppendMenuItem(ID_INSERT_LRM, MFT_STRING, L"LRM\tLeft-To-Right Mark");
		pMenu->AppendMenuItem(ID_INSERT_RLM, MFT_STRING, L"RLM\tRight-To-Left Mark");
		pMenu->AppendMenuItem(ID_INSERT_ZWJ, MFT_STRING, L"ZWJ\tZero Width Joiner");
		pMenu->AppendMenuItem(ID_INSERT_ZWNJ, MFT_STRING, L"ZWNJ\tZero Width Non-Joiner");
		pMenu->AppendMenuItem(ID_INSERT_LRE, MFT_STRING, L"LRE\tLeft-To-Right Embedding");
		pMenu->AppendMenuItem(ID_INSERT_RLE, MFT_STRING, L"RLE\tRight-To-Left Embedding");
		pMenu->AppendMenuItem(ID_INSERT_LRO, MFT_STRING, L"LRO\tLeft-To-Right Override");
		pMenu->AppendMenuItem(ID_INSERT_RLO, MFT_STRING, L"RLO\tRight-To-Left Override");
		pMenu->AppendMenuItem(ID_INSERT_PDF, MFT_STRING, L"PDF\tPop Directional Formatting");
		pMenu->AppendMenuItem(ID_INSERT_WJ, MFT_STRING, L"WJ\tWord Joiner");
		pMenu->AppendMenuItem(ID_INSERT_U2061, MFT_STRING, L"U+2061\tFunction Application");
		pMenu->AppendMenuItem(ID_INSERT_U2062, MFT_STRING, L"U+2062\tInvisible Times");
		pMenu->AppendMenuItem(ID_INSERT_U2063, MFT_STRING, L"U+2063\tInvisible Separator");
/*		pMenu->AppendMenuItem(ID_INSERT_NADS, MFT_STRING, L"NADS\tNational Digit Shapes");
		pMenu->AppendMenuItem(ID_INSERT_NODS, MFT_STRING, L"NODS\tNominal Digit Shapes");
		pMenu->AppendMenuItem(ID_INSERT_ASS, MFT_STRING, L"ASS\tActivate Symmetric Swapping");
		pMenu->AppendMenuItem(ID_INSERT_ISS, MFT_STRING, L"ISS\tInhibit Symmetric Swapping");
		pMenu->AppendMenuItem(ID_INSERT_AAFS, MFT_STRING, L"AAFS\tActivate Arabic Form Shaping");
		pMenu->AppendMenuItem(ID_INSERT_IAFS, MFT_STRING, L"IAFS\tInhibit Arabic Form Shaping");*/
		pMenu->AppendMenuItem(ID_INSERT_RS, MFT_STRING, L"RS\tRecord Separator");
		pMenu->AppendMenuItem(ID_INSERT_US, MFT_STRING, L"US\tUnit Separator");
		pMenu = m_oContextMenu.AppendMenuItem(13, MF_POPUP, bJapanese ? L"Unicode 󔒕̑}(&W)" : L"Insert Unicode &Whitespace");
		pMenu->AppendMenuItem(ID_INSERT_U0020, MFT_STRING, L"U+0020\tSpace");
		pMenu->AppendMenuItem(ID_INSERT_NBSP, MFT_STRING, L"NBSP\tNo-Break Space");
		pMenu->AppendMenuItem(ID_INSERT_MVS, MFT_STRING, L"MVS\tMongolian Vowel Separator");
		pMenu->AppendMenuItem(ID_INSERT_U1680, MFT_STRING, L"U+1680\tOgham Space Mark");
		pMenu->AppendMenuItem(ID_INSERT_U2000, MFT_STRING, L"U+2000\tEn Quad");
		pMenu->AppendMenuItem(ID_INSERT_U2001, MFT_STRING, L"U+2001\tEm Quad");
		pMenu->AppendMenuItem(ID_INSERT_U2002, MFT_STRING, L"U+2002\tEn Space");
		pMenu->AppendMenuItem(ID_INSERT_U2003, MFT_STRING, L"U+2003\tEm Space");
		pMenu->AppendMenuItem(ID_INSERT_U2004, MFT_STRING, L"U+2004\tThree-Per-Em Space");
		pMenu->AppendMenuItem(ID_INSERT_U2005, MFT_STRING, L"U+2005\tFour-Per-Em Space");
		pMenu->AppendMenuItem(ID_INSERT_U2006, MFT_STRING, L"U+2006\tSix-Per-Em Space");
		pMenu->AppendMenuItem(ID_INSERT_U2007, MFT_STRING, L"U+2007\tFigure Space");
		pMenu->AppendMenuItem(ID_INSERT_U2008, MFT_STRING, L"U+2008\tPunctuation Space");
		pMenu->AppendMenuItem(ID_INSERT_U2009, MFT_STRING, L"U+2009\tThin Space");
		pMenu->AppendMenuItem(ID_INSERT_U200A, MFT_STRING, L"U+200A\tHair Space");
		pMenu->AppendMenuItem(ID_INSERT_ZWSP, MFT_STRING, L"ZWSP\tZero Width Space");
		pMenu->AppendMenuItem(ID_INSERT_NNBSP, MFT_STRING, L"NNBSP\tNarrow No-Break Space");
		pMenu->AppendMenuItem(ID_INSERT_MMSP, MFT_STRING, L"MMSP\tMedium Mathematical Space");
		pMenu->AppendMenuItem(ID_INSERT_U3000, MFT_STRING, L"U+3000\tIdeographic Space");
		pMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
		pMenu->AppendMenuItem(ID_INSERT_NEL, MFT_STRING, L"NEL\tNext Line");
		pMenu->AppendMenuItem(ID_INSERT_LS, MFT_STRING, L"LS\tLine Separator");
		pMenu->AppendMenuItem(ID_INSERT_PS, MFT_STRING, L"PS\tParagraph Separator");
		if(toBoolean(::ImmIsIME(::GetKeyboardLayout(::GetCurrentThreadId())))) {
			m_oContextMenu.AppendMenuItem(0, MFT_SEPARATOR, 0);
			m_oContextMenu.AppendMenuItem(ID_TOGGLEIMESTATUS, MFT_STRING, bJapanese ? L"IME J(&O)" : L"&Open IME");
			m_oContextMenu.AppendMenuItem(ID_RECOMPOSITIONIME, MFT_STRING, bJapanese ? L"ĕϊ(&R)" : L"&Recompose");
		}
	}

	// ݊foCXReLXg/ GDI IuWFNg̍쐬
	HDC	hDC = GetDC();
	m_GDIObjects.oMemDC.CreateCompatibleDC(hDC);
	ReleaseDC(hDC);
	UpdateGDIObjects();

	// ͌EBhE̍쐬
	m_pwndAutoComplete->Create();
	
	// hbvΏۂɓo^
	RegisterDragDrop(this);

	// CAEg
	// hLg΍s𓯊
	LOGFONT	lf = {
		0, 0, 0, 0, FW_NORMAL, false, false, false,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		FIXED_PITCH | FF_DONTCARE, L"FixedSys"
	};
	if(m_pDocument != 0)
		m_pLineLayoutManager->ReconstructAll();
	ModifyFontInfo(lf, false);
}

/**
 *	݈ʒuɕ}BݑIĂu͍sȂ
 *	@param strText	}eLXg
 *	@see			DeleteSel, ReplaceSel, InsertBoxText
 */
void CEditView::InsertText(const wstring& strText) {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	m_ModeState.bBoxSelecting = false;
	GetDocument()->InsertText(this, *m_pActivePoint, strText);
	m_nccNextCharConvert = NCC_NONE;	// ɖ߂

	if(m_pEventListener != 0 && m_pKeyMacroPlayer->GetState() != KMS_PLAYING)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

/**
 *	wԍs`𖳌
 *	@param iLine	_s
 */
void CEditView::InvalidateLine(unsigned long iLine) {
	InvalidateLines(iLine, iLine);
}

/**
 *	ws`𖳌Bsw͂_sB<var>iStart</var>
 *	 <var>iEnd</var> ̑召֌Wɐ͖
 *	@param iStart	Jns
 *	@param iEnd		Is
 */
void CEditView::InvalidateLines(unsigned long iStart, unsigned long iEnd) {
	AssertValidAsWindow();

	if(iStart > iEnd)
		std::swap(iStart, iEnd);

	if(m_bFreezed) {	// 
		for(unsigned long i = iStart; i <= iEnd; ++i)
			m_setInvalidLines.insert(i);
		return;
	}

	RECT				rectInvalid;
	unsigned long		iDisplayStart, iDisplayEnd;
	unsigned int		cVisibleLines = GetVisibleLineCount();
	const unsigned long	cLines = GetDocument()->GetLineCount();

	// \sɕϊ
	if(iStart > iEnd)
		std::swap(iStart, iEnd);
	iDisplayStart = DisplayLineFromLogicalLine(min(iStart, cLines - 1));
	if(iStart >= cLines)
		iDisplayStart += iStart - cLines + 1;
	iDisplayEnd = DisplayLineFromLogicalLine(min(iEnd, cLines - 1));
	if(iEnd >= cLines)
		iDisplayEnd += iEnd - cLines + 1;
	GetClientRect(&rectInvalid);

	// [
	if(iDisplayStart > m_ptScroll.y + cVisibleLines)
		return;
	rectInvalid.top += m_layoutInfo.nTopMargin;
	if(static_cast<long>(iDisplayStart) > m_ptScroll.y)
		rectInvalid.top += (iDisplayStart - m_ptScroll.y) * m_layoutInfo.nLineHeight;

	// [
	rectInvalid.bottom = rectInvalid.top + (iDisplayEnd - iDisplayStart + 1) * m_layoutInfo.nLineHeight;

	InvalidateRect(&rectInvalid, false);
}

/**
 *	ʎq\𔻒肷B̃\bh
 *	Unicode  ID_Continue vpeB̃XgɊÂĂ
 *	@param nCodePoint	ׂR[h|Cg
 *	@return				ʎq\ǂ
 *	@see				CEditView::IsIdentifier, CEditView::IsIdentifierStartChar
 */
bool CEditView::IsIdentifierContinueChar(unsigned long nCodePoint) {
	// ʕނ Mn (Mark, Non-Spacing)AMc (Mark, Spacing Combining)A
	// Nd (Number, Decimal)APc (Punctuation, Connector) ̂ꂩłR[h|Cg
	// unicat.pl 莩 (Unicode 4.0)
	static const unsigned long	arrIDContinue[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\EditView_IdentifierContinue_4_0"
	};

	return CEditView::IsIdentifierStartChar(nCodePoint)
		|| std::binary_search(arrIDContinue,
		arrIDContinue + sizeof(arrIDContinue) / sizeof(unsigned long), nCodePoint);
}

/**
 *	ʎqJn𔻒肷B̃\bh
 *	Unicode  ID_Start vpeB̃XgɊÂĂ
 *	@param nCodePoint	ׂR[h|Cg
 *	@return				ʎqJnǂ
 *	@see				CEditView::IsIdentifier, CEditView::IsIdentifierContinueChar
 */
bool CEditView::IsIdentifierStartChar(unsigned long nCodePoint) {
	// DerivedCoreProperties.txt  ID_Start vpeBR[h|Cg
	// idstart.pl 莩 (Unicode 4.0)
	static const unsigned long	arrIDContinue[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\EditView_IdentifierStart_4_0"
	};

	return std::binary_search(arrIDContinue,
		arrIDContinue + sizeof(arrIDContinue) / sizeof(unsigned long), nCodePoint)
		|| (nCodePoint >= 0x1401 && nCodePoint <= 0x166C)	// Canadian Syllabics
		|| (nCodePoint >= 0x3400 && nCodePoint <= 0x4DB5)	// CJK Unified Ideograph
		|| (nCodePoint >= 0x4E00 && nCodePoint <= 0x9FA5)	// CJK Unified Ideograph
		|| (nCodePoint >= 0xA000 && nCodePoint <= 0xA48C)	// Yi Syllable
		|| (nCodePoint >= 0xAC00 && nCodePoint <= 0xD7A3)	// Hangul Syllable
		|| (nCodePoint >= 0x20000 && nCodePoint <= 0x2A6D6)	// CJK Unified Ideograph
		|| (nCodePoint >= 0x2F800 && nCodePoint <= 0x2FA1D);// CJK Compatibility Ideograph
}

/**
 *	wʒȗ݂I͈͂ƏdȂĂ邩ǂԂ
 *	@param pt	NCAgW
 *	@return		<var>pt</var> I͈͏ɂ true
 */
inline bool CEditView::IsOverSelection(const POINT& pt) const {
	AssertValidAsWindow();

	if(!HasSelection()
			|| pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin)
			|| pt.y < static_cast<long>(m_layoutInfo.nTopMargin))
		return false;

	RECT	rect;

	GetClientRect(&rect);
	if(pt.x > rect.right || pt.y > rect.bottom)
		return false;

	if(!m_ModeState.bBoxSelecting) {	// ʂ̑I
	//	bool		bTruncated;
		CCharPos	pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse/*, &bTruncated*/);
		return /*!bTruncated ||*/ (GetSelTopPoint() <= pos && GetSelBottomPoint() >= pos);
	} else {	// `Ȉꍇ
		unsigned long	xView = pt.x - m_layoutInfo.nLeftTabWidth +
			m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
		unsigned long	iDisplayLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio
			+ (pt.y - m_layoutInfo.nTopMargin) / m_layoutInfo.nLineHeight;
		return xView >= min(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive)
			&& xView <= max(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive)
			&& iDisplayLine >= min(m_layoutInfo.iBoxSelectionAnchorLine, m_layoutInfo.iBoxSelectionActiveLine)
			&& iDisplayLine <= max(m_layoutInfo.iBoxSelectionAnchorLine, m_layoutInfo.iBoxSelectionActiveLine);
	}
}

/**
 *	wʒu URI ƏdȂĂ邩ǂԂ
 *	@param pt		NCAgW
 *	@param strURI	<var>pt</var>  URI ɂ΂̕
 *	@return			<var>pt</var>  URI ɂ true
 */
inline bool CEditView::IsOverURIString(const POINT& pt, wstring& strURI) const {
	AssertValidAsWindow();
/*
	bool			bTruncated;
	CCharPos		pos = CharFromPos(pt, &bTruncated);

	if(bTruncated)
		return false;

	const wchar_t*	pwszLine = GetDocument()->GetLine(pos.iLine).c_str();
	size_t			cchLine = GetDocument()->GetLineLength(pos.iLine);
	unsigned long	cchURI;
	long			x = pt.x - m_layoutInfo.nLeftTabWidth
						+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
	long			xView = m_layoutInfo.nLeftMargin;
	bool			bSurrogate = false;

	for(unsigned long i = 0; i < cchLine; ++i) {
		if(pwszLine[i] == L'\t')
			xView = GetNextTabStop(xView, false);
		else if(cchURI = IsURIString(pwszLine + i, cchLine - i), cchURI > 0) {
			xView += m_layoutInfo.oTextWidthManager.GetTextWidth(pwszLine + i, cchURI);
			if(xView > x)
				return true;
		} else
			xView += m_layoutInfo.oTextWidthManager.GetCharWidth(pwszLine + i, (i < cchLine - 1) ? &bSurrogate : 0);

		if(xView > x)
			return false;

		if(bSurrogate) {
			++i;
			bSurrogate = false;
		}
	}
*/
	return false;
}

inline unsigned long CEditView::IsURIString(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	if(cch < 8)
		return 0;
	if(wcsncmp(psz, L"http://", 7) == 0) {
		for(unsigned long i = 7; i < cch; ++i) {
			if(wcschr(L" \"\'<>(){}", psz[i]) != 0)
				return i;
		}
		return cch;
	}

	return 0;
}

/**
 *	󔒗ޕ̒Ԃ
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		󔒗ޕAĂ钷BzCgXy[XłȂ0
 */
unsigned long CEditView::IsWhiteSpace(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	// ʕނ Zs (Separator, Space) łR[h|Cg
	// unicat.pl 莩 (Unicode 4.0)
	// NOTE: ListProp.txt ɂ WhiteSpace ƂvpeB邪
	// ̔z͂̏W (Ⴆΐ䕶Ȃǂ͊OĂ)
	static wchar_t	arrZs[] = {
		0x0009,	// ^u Zs ł͂ȂA󔒗ޕƂĈ
		0x0020, 0x00A0, 0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003,
		0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x200B,
		0x202F, 0x205F, 0x3000,
	};

	for(unsigned long i = 0; i < cch; ++i) {
		if(!std::binary_search(arrZs, arrZs + sizeof(arrZs) / sizeof(wchar_t), psz[i]))
			return i;
	}
	return cch;
}

///	s͂}B̃\bhĂяoƁA
///	̌̃L[[hRgJnݒ莞ɍs̍ĉ͂
///	sȂȂB̏Ԃ UnlockParsing Ăяo܂ő
void CEditView::LockParsing() {
	AssertValid();

	m_FoundationInfo.bLockedParsing = true;

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->LockParsing();
	}
}

/**
 *	\ʒu_ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posDisplay	ϊ\ʒu
 *	@return				ϊꂽ_ʒu (łȂo-1)
 */
CCharPos CEditView::LogicalCharFromDisplayChar(const CCharPos& posDisplay) const {
	AssertValid();

//	if(m_ModeState.wpmWrapMode == WPM_NONE)
		return posDisplay;
/*
	CCharPos			posLogical(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	// s̊m
	unsigned long	iTotalDisplayLine = 0;
	while(true) {
		iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
		if(iTotalDisplayLine > posDisplay.iLine)
			break;
		pInfo = pInfo->m_pNext;
		if(pInfo == 0)
			return CCharPos(-1, -1);
		++posLogical.iLine;
	}

	// ̊m
	vector<unsigned long>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();
	if(cOffsets == 0)	// ̍sł͐܂Ԃ͋NĂȂ
		return CCharPos(posLogical.iLine, posDisplay.iChar);
	for(vector<unsigned long>::size_type iOffset = 0; iOffset < cOffsets; ++iOffset) {
		if(posLogical.iChar + pInfo->m_vecWrappedOffsets[iOffset] >= posDisplay.iChar) {
			posLogical.iChar += posDisplay.iChar - posLogical.iChar;
			return posLogical;
		}
		posLogical.iChar += pInfo->m_vecWrappedOffsets[iOffset];
	}

	return CCharPos(posLogical.iLine, -1);*/
}

/**
 *	LbguȂꏊɂLbg𐳂ʒuɂ炷B
 *	UTF-16 TQ[g╡̉ɎgB
 *	@param pwsz			
 *	@param cch			
 *	@param nCaretPos	Lbgʒu
 *	@param bBackward	Lbgǂɓ
 *	@return				ړ (wchar_t P)B͌
 */
int CEditView::MakeCaretPosValid(const wchar_t* pwsz,
		unsigned long cch, unsigned long nCaretPos, bool bBackward) {
	assert(pwsz != 0);

	// P[X
	if(nCaretPos == 0 || nCaretPos >= cch)
		return 0;

	int				nOffset = 0;
	unsigned long	nCodePoint;
	while(true) {
		if(IsUTF16LowSurrogate(pwsz[nCaretPos + nOffset])
				&& nCaretPos + nOffset > 0
				&& IsUTF16HighSurrogate(pwsz[nCaretPos + nOffset - 1]))
			nOffset += bBackward ? -1 : 1;
		if(IsUTF16HighSurrogate(pwsz[nCaretPos + nOffset])
				&& IsUTF16LowSurrogate(pwsz[nCaretPos + nOffset + 1]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pwsz + nCaretPos + nOffset, 2);
		else
			nCodePoint = pwsz[nCaretPos + nOffset];
		if(CBoundarySearcher::IsFirstCharacterOfCluster(nCodePoint))
			break;
		// 炷
		nOffset += bBackward ? -1 : 1;
		if(nCaretPos + nOffset == 0 || nCaretPos + nOffset == cch)
			return nOffset;
	}
	return nOffset;
}

/**
 *	hLgƗ񃋁[ɎgtHg̐ݒB
 *	s̍XV
 *	@param lf		tHg (X^Co͖)
 *	@param bRedraw	ĕ`悷邩
 */
void CEditView::ModifyFontInfo(const LOGFONTW& lf, bool bRedraw /* = true */) {
	AssertValidAsWindow();
	HDC			hDC;
	HFONT		hOldFont = 0;
	LOGFONTW	lf_ = lf;
	TEXTMETRICW	tm;

	// ÕtHg폜
	if(m_GDIObjects.hNormalFont != 0) {
		::DeleteObject(m_GDIObjects.hNormalFont);
		::DeleteObject(m_GDIObjects.hBoldFont);
		::DeleteObject(m_GDIObjects.hItalicFont);
		::DeleteObject(m_GDIObjects.hBoldItalicFont);
	}

	lf_.lfItalic = false;
	lf_.lfStrikeOut = false;
	lf_.lfUnderline = false;

	lf_.lfWeight = FW_NORMAL;
	m_GDIObjects.hNormalFont = ::CreateFontIndirect(&lf_);

	lf_.lfWeight = FW_BOLD;
	m_GDIObjects.hBoldFont = ::CreateFontIndirect(&lf_);

	lf_.lfItalic = true;
	m_GDIObjects.hBoldItalicFont = ::CreateFontIndirect(&lf_);

	lf_.lfWeight = FW_NORMAL;
	m_GDIObjects.hItalicFont = ::CreateFontIndirect(&lf_);

	// tHg̕ۑ
	hDC = GetDC();
	::SelectObject(hDC, m_GDIObjects.hNormalFont);
	::GetTextMetrics(hDC, &tm);
	unsigned int	tmp = m_layoutInfo.nCharHeight;
	m_layoutInfo.nCharHeight = tm.tmHeight + 1;
	m_layoutInfo.nLineHeight += m_layoutInfo.nCharHeight - tmp;
	m_layoutInfo.nCharWidth = tm.tmAveCharWidth;
	ReleaseDC(hDC);

	RecalcLeftTabWidth();

	// CAEgXV
	m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s̍XV
	ModifyScrollInfo(true, true);
	m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;

	if(bRedraw) {
		HideCaret();
		RecreateCaret();
		InvalidateRect(0);
		ValidateCaretPos();
		ShowCaret();
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->ModifyFontInfo(lf, bRedraw);
	}
}

/**
 *	AXN[o[̏XV
 *	@param bHorizontal	XN[o[XVꍇ true
 *	@param bVertical	XN[o[XVꍇ true
 */
void CEditView::ModifyScrollInfo(bool bHorizontal, bool bVertical) {
	AssertValidAsWindow();
	const CEditDoc*	pDoc = GetDocument();
	SCROLLINFO		si = {
		sizeof(SCROLLINFO), SIF_DISABLENOSCROLL | SIF_PAGE | SIF_RANGE, 0, 0, 0, 0, 0
	};
	unsigned long	cLines = GetDisplayLineCount();

	// XN[o[
	if(bVertical) {
		m_layoutInfo.nVScrollRatio = cLines / std::numeric_limits<int>::max() + 1;
		si.nMax = cLines / m_layoutInfo.nVScrollRatio - 1;
		si.nPage = GetVisibleLineCount();
		if((si.nMax - si.nMin) * m_layoutInfo.nVScrollRatio <= si.nPage)	// XN[o[ȂOɏ[ɃXN[
			OnVScroll(SB_TOP, 0, 0);
		SetScrollInfo(SB_VERT, &si, true);
	}

	// XN[o[
	if(bHorizontal) {
		unsigned long	nMaxPixelLength = (m_ModeState.wpmWrapMode == WPM_NONE) ?
							m_pLineLayoutManager->GetMaxDisplayWidth() / GetAvgCharWidth() : 0;
		m_layoutInfo.nHScrollRatio = nMaxPixelLength / std::numeric_limits<int>::max() + 1;
		si.nMax = nMaxPixelLength / m_layoutInfo.nHScrollRatio;
		si.nPage = GetVisibleCharCount();
		if((si.nMax - si.nMin) * m_layoutInfo.nHScrollRatio <= si.nPage)	// XN[o[ȂOɍ[ɃXN[
			OnHScroll(SB_LEFT, 0, 0);
		SetScrollInfo(SB_HORZ, &si, true);
	}
}

/**
 *	wʒũNCAgW擾
 *	@param col	_ʒu
 *	@return		NCAgW
 */
POINT CEditView::PosFromChar(const CCharPos& col) const {
	AssertValidAsWindow();
	POINT				pt;	// ߂l
	unsigned long		iLine = std::min(col.m_iLine, GetDocument()->GetLineCount() - 1);
	CLineLayoutInfo*	pLineInfo = m_pLineLayoutManager->GetLine(iLine);
	unsigned long		iStart = 0;

	// ܂Ԃlꍇ
	if(m_ModeState.wpmWrapMode != WPM_NONE) {
		CCharPos		colDisplay = DisplayCharFromLogicalChar(col);
		unsigned int	cWraps = pLineInfo->GetWrappedPoints().size();

		// y W̊m
		pt.y = m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * (colDisplay.m_iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio);
		if(cWraps != 0) {
			unsigned int	i;
			for(i = 0; i < cWraps && col.m_iChar > pLineInfo->GetWrappedPoints()[i]; ++i)
				pt.y += m_layoutInfo.nLineHeight;
			if(i == cWraps)
				--i;
			iStart = (i != 0) ? pLineInfo->GetWrappedPoints()[i - 1] : 0;
		}
		// x W̊m

	} else {
		// y W̊m
		pt.y = m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio);

		// x W̊m
		pt.x = pLineInfo->GetCaretPositions()[std::min(col.m_iChar, GetDocument()->GetLineLength(iLine))];
	}

	pt.x -= m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
	pt.x += m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;

	return pt;
}

///	@see	IDropSource::QueryContinueDrag
STDMETHODIMP CEditView::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState) {
	AssertValid();

	if(fEscapePressed || toBoolean(grfKeyState & MK_RBUTTON))	// LZ
		return DRAGDROP_S_CANCEL;
	if(!toBoolean(grfKeyState & MK_LBUTTON))	// hbv
		return DRAGDROP_S_DROP;

	return S_OK;
}

/**
 *	т̕ČvZčXV
 *	ύX΃NCAg`XV̈ɒǉ
 *	@param cy	EBhȄcB-1łΌ݂̃EBhȄc
 */
void CEditView::RecalcLeftTabWidth(int cy /* = -1 */) {
	if(!IsWindow())
		return;

	int				nNewWidth = 0;	// V
	unsigned int	cMaxDigits;

	if(toBoolean(m_ModeState.lttTabType & LTT_LINENUMBER)) {
		HFONT	hOldFont = m_GDIObjects.oMemDC.SelectObject(m_GDIObjects.hNormalFont);
		m_GDIObjects.oMemDC.GetCharWidth(L'8', L'8', &nNewWidth);
		m_GDIObjects.oMemDC.SelectObject(hOldFont);
		cMaxDigits = GetLineNumberMaxDigit();
		nNewWidth *= (std::max<unsigned int>(cMaxDigits, 4) + 2);	// Œ4͊mۂ
	}
	if(toBoolean(m_ModeState.lttTabType & LTT_INDICATOR))
		nNewWidth += INDICATORMARGIN_WIDTH;
	if(cy != -1 || nNewWidth != m_layoutInfo.nLeftTabWidth) {
		RECT	rect;
		HDC		hDC = GetDC();

		GetClientRect(&rect);
		if(cy == -1)
			cy = rect.bottom - rect.top;
		if(cy == 0)
			return;	// ύXȂ
		m_layoutInfo.nLeftTabWidth = nNewWidth;
		::DeleteObject(m_GDIObjects.hMemLeftTabBMP);	// rbg}bṽTCYύX
		m_GDIObjects.hMemLeftTabBMP =
			::CreateCompatibleBitmap(hDC, m_layoutInfo.nLeftTabWidth, cy);
		ReleaseDC(hDC);
		InvalidateRect(0, false);
		ValidateCaretPos();
	}
}

/**
 *	r[̐ݒ񂩂Lbg쐬B
 *	Lbg͎Iɕ\<strong>Ȃ</strong>
 */
void CEditView::RecreateCaret() {
	AssertValidAsWindow();

	int	nCaretWidth;
	
	::DestroyCaret();
	if(!m_ModeState.bOvertype || HasSelection())
		nCaretWidth = 2;
	else {	// ㏑[ĥƂ̓Lbg̕Ɠɂ
		const wstring&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
		const wchar_t*	pwszLine = strLine.c_str();
		unsigned long	cchLine = strLine.length();

		if(m_pActivePoint->m_iChar == cchLine)
			nCaretWidth = GetAvgCharWidth();
		else if(pwszLine[m_pActivePoint->m_iChar] == L'\t') {
			POINT	pt = PosFromChar(*m_pActivePoint);

			pt.x += m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
			pt.x -= m_layoutInfo.nLeftMargin + m_layoutInfo.nLeftTabWidth;
			nCaretWidth = GetNextTabStop(pt.x, false/*m_ModeState.bRtlReading*/) - pt.x;
		} else {
			CMinimalDC&	oDC = m_GDIObjects.oMemDC;
			HFONT		hOldFont;
			CCharPos	pos = m_pBoundarySearcher->SearchFirstCharacterOfCluster(*m_pActivePoint, true);

			hOldFont = oDC.SelectObject(m_GDIObjects.hNormalFont);
			nCaretWidth = oDC.GetTextExtent(
				pwszLine + m_pActivePoint->m_iChar,
				pos.m_iChar - m_pActivePoint->m_iChar).cx;
			oDC.SelectObject(hOldFont);
		}
	}
	CreateSolidCaret(nCaretWidth, m_layoutInfo.nCharHeight);
}

/**
 *	Ascension EBhENXo^
 *	@return	
 */
bool CEditView::RegisterWindowClass() {
	// EBhENXo^ĂȂΓo^
	if(!CEditView::m_bRegistered) {
		WNDCLASSEXW	wc;

		wc.cbSize			= sizeof(WNDCLASSEX);
		wc.style			= CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW | CS_DBLCLKS;
		wc.lpfnWndProc		= reinterpret_cast<WNDPROC>(CEditView::WndProc);
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= sizeof(long);
		wc.hInstance		= ::GetModuleHandle(0);
		wc.hIcon			= 0;
		wc.hIconSm			= 0;
		wc.hCursor			= ::LoadCursor(0, IDC_IBEAM);
		wc.hbrBackground	= reinterpret_cast<HBRUSH>(::GetStockObject(WHITE_BRUSH));
		wc.lpszClassName	= WC_ASCENSIONVIEW;
		wc.lpszMenuName		= 0;

		if(!::RegisterClassExW(&wc))
			return false;
		CEditView::m_bRegistered = true;
	}
	return true;
}

/**
 *	w肵ҏW_ǗĂ郊XgOB̃\bh CEditPoint
 *	̃fXgN^ĂяoBNCAgĂяoKv͖
 *	@param pt	ҏW_
 */
void CEditView::ReleaseEditPoint(CEditPoint& pt) {
	AssertValid();

	set<CEditPoint*>::iterator	it = m_setEditPoints.find(&pt);
	if(it != m_setEditPoints.end())
		m_setEditPoints.erase(it);
}

/**
 *	SĒu
 *	@param strFindWhat		
 *	@param strReplaceWith	u
 *	@param sfFlags			tO (EVF_BACKWARD ͖)
 *	@return					ueLXg̐
 */
unsigned long CEditView::ReplaceAll(
		const wstring& strFindWhat, const wstring& strReplaceWith, SearchFlag sfFlags) {
	AssertValid();

	CEditDoc*		pDocument = GetDocument();
	CCharPos		posOrigin = *m_pActivePoint;
	unsigned long	cLines = pDocument->GetLineCount();
	unsigned long	cReplaced = 0;
	size_t			iBegin, iFound, cchFound;

	CEditView::m_oTextSearcher.SetFlag(sfFlags);
	CEditView::m_oTextSearcher.SetText(strFindWhat);
	pDocument->BeginEditCollection();

	try {
		for(unsigned long iLine = 0; iLine < cLines; ++iLine) {
			iBegin = 0;
			while(true) {
				CEditView::m_oTextSearcher.SetTargetText(pDocument->GetLine(iLine));
				if(!CEditView::m_oTextSearcher.Search(iBegin, iFound, cchFound))
					break;
				pDocument->DeleteText(this, CCharPos(iLine, iFound), CCharPos(iLine, iFound + cchFound));
				pDocument->InsertText(this, CCharPos(iLine, iFound), strReplaceWith);
				iBegin = iFound + strReplaceWith.length();
				++cReplaced;
			}
		}
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		throw;
	} catch(ERegExpPatternIsInvalid& /* e */) {
		throw;
	}

	pDocument->EndEditCollection();

	if(cReplaced != 0)
		SetSelWithoutSelection(posOrigin);

	return cReplaced;
}

/**
 *	I͈͂uāAɈv镶IB
 *	I͈͂̕ <var>strFindWhat</var>
 *	ɈvȂꍇIꍇ͒u͍sȂ
 *	@param strFindWhat		
 *	@param strReplaceWith	u
 *	@param sfFlags			tO
 *	@return					Ɉv镶񂪌 true
 */
bool CEditView::ReplaceAndFindNext(
		const wstring& strFindWhat, const wstring& strReplaceWith, SearchFlag sfFlags) {
	AssertValid();

	if(HasSelection() && !m_ModeState.bBoxSelecting) {
		wstring	strSelection = GetSelection();
		DWORD	dwFlags = 0;

		if(toBoolean(sfFlags & SF_IGNORE_CASE_SIMPLE))	dwFlags |= NORM_IGNORECASE;
		if(toBoolean(sfFlags & SF_IGNORE_KANATYPE))		dwFlags |= NORM_IGNOREKANATYPE;
		if(CSTR_EQUAL == ::CompareString(LOCALE_USER_DEFAULT, dwFlags,
				strSelection.c_str(), strSelection.length(), strFindWhat.c_str(), strFindWhat.length()))
			ReplaceSel(strReplaceWith);
	}

	return FindNext(strFindWhat, sfFlags);
}

/**
 *	I͈͂w蕶Œu
 *	@param strText		}eLXg
 *	@param bBoxPaste	`}̏ꍇ^
 *	@see				DeleteSel
 */
void CEditView::ReplaceSel(const wstring& strText, bool bBoxPaste /* = false */) {
	AssertValidAsWindow();

	if(HasSelection()) {
		GetDocument()->BeginEditCollection();
		DeleteSel();
		if(bBoxPaste)
			m_pActivePoint->InsertBox(strText);
		else
			InsertText(strText);
		GetDocument()->EndEditCollection();
	} else if(bBoxPaste)
		m_pActivePoint->InsertBox(strText);
	else
		InsertText(strText);
}

/**
 *	AvP[V`s̐ݒB̍s̓r[<strong>1</strong>݂Ȃ
 *	@param iLine	_sB-1w肷邩sԍȂΉ
 */
void CEditView::SetAppDefinedLine(unsigned long iLine) {
	AssertValid();
	CLineLayoutInfo*	pInfo = (iLine != -1) ? m_pLineLayoutManager->GetLine(iLine) : 0;

	m_layoutInfo.pAppDefinedSingleLine = pInfo;
	if(IsWindowVisible())
		InvalidateRect(0, false);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetAppDefinedLine(iLine);
	}
}

/**
 *	w肵sɃubN}[Nݒ/
 *	@param iLine		ݒ肷s
 *	@param bOn			ݒ莞 trueB false
 *	@throw out_of_range	<var>iLine</var> sԍƂĐȂꍇX[
 *	@see				CEditView::HasBookmarkAt, CEditView::ToggleBookmark
 */
void CEditView::SetBookmark(unsigned long iLine, bool bOn /* = true */) throw(out_of_range) {
	AssertValid();
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	pInfo->SetBookmark(bOn);

	if(IsWindowVisible())
		InvalidateLine(iLine);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetBookmark(iLine, bOn);
	}
}

/**
 *	͌PꃊXg̐ݒ
 *	@param listWords	ݒ肷镶̃Xg
 */
void CEditView::SetCandidateWords(const list<TCandidateWord>& listWords) {
	AssertValid();

	m_pwndAutoComplete->SetCandidateWords(listWords);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetCandidateWords(listWords);
	}
}

/**
 *	sԁAԊu̐ݒ
 *	@param nLineSpan	s̊Ԋu
 *	@param nCharSpan	̊Ԋu
 */
void CEditView::SetCharSpaces(unsigned int nLineSpan, unsigned int nCharSpan) {
	AssertValid();

	m_layoutInfo.nLineHeight = m_layoutInfo.nCharHeight + nLineSpan;
	m_layoutInfo.nCharSpan = nCharSpan;
	if(IsWindow()) {
		if(m_ModeState.wpmWrapMode != WPM_NONE)
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
		ModifyScrollInfo(true, true);
		InvalidateRect(0, true);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetCharSpaces(nLineSpan, nCharSpan);
	}
}

/**
 *	VCxgXi̓o^
 *	@param pEventListener	Vo^CxgXiBnull Ɠo^
 */
void CEditView::SetEventListener(IEditViewEventListener* pEventListener) {
	AssertValid();

	m_pEventListener = pEventListener;

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetEventListener(pEventListener);
	}
}

/**
 *	\L[[h̐ݒ
 *	@param listKeywords1, listKeywords2	ݒ肷镶̃Xg
 */
void CEditView::SetKeywordLists(const list<wstring>& listKeywords1, const list<wstring>& listKeywords2) {
	AssertValid();
	list<wstring>::const_iterator	it;

	m_FoundationInfo.pKeywords1->Clear();
	m_FoundationInfo.pKeywords2->Clear();

	for(it = listKeywords1.begin(); it != listKeywords1.end(); ++it)
		m_FoundationInfo.pKeywords1->Add(*it);
	for(it = listKeywords2.begin(); it != listKeywords2.end(); ++it)
		m_FoundationInfo.pKeywords2->Add(*it);

	if(!m_FoundationInfo.bLockedParsing) {
		m_pLineLayoutManager->NotifyAll(LPL_TOKEN);
		if(IsWindow())
			InvalidateRect(0, false);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetKeywordLists(listKeywords1, listKeywords2);
	}
}

/**
 *	т̎ނ̐ݒ
 *	@param ltt	т̎
 *	@see		LeftTabType
 */
void CEditView::SetLeftTabType(LeftTabType ltt) {
	AssertValid();

	m_ModeState.lttTabType = ltt;
	RecalcLeftTabWidth();

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetLeftTabType(ltt);
	}
}

/**
 *	AvP[V`l̐ݒ
 *	@param iLine	ݒs
 *	@param dwParam	AvP[V`l
 *	@param dwMask	}XNlB̃rbgɂe
 */
void CEditView::SetLineParam(unsigned long iLine, DWORD dwParam, DWORD dwMask /* = 0xFFFFFFFF */) {
	AssertValid();

	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(iLine);
	if(pInfo != 0) {
		DWORD	dwParam_ = pInfo->GetUserDefinedValue();
		dwParam_ &= ~dwMask;
		dwParam_ |= (dwParam & dwMask);
		pInfo->SetUserDefinedValue(dwParam_);
		if(IsWindowVisible())
			InvalidateLines(iLine, iLine);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetLineParam(iLine, dwParam, dwMask);
	}
}

/**
 *	A̗]̐ݒ
 *	@param nLeft	]
 *	@param nTop		]
 */
void CEditView::SetMargins(unsigned int nLeft, unsigned int nTop) {
	AssertValid();

	m_layoutInfo.nLeftMargin = nLeft;
	m_layoutInfo.nTopMargin = nTop;
	RecalcLeftTabWidth();

	if(IsWindow()) {
		if(m_ModeState.wpmWrapMode == WPM_WINDOW)
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
		ModifyScrollInfo(true, true);
		InvalidateRect(0, true);
		ValidateCaretPos();
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetMargins(nLeft, nTop);
	}
}

/**
 *	sRg1̊JnƏI̐ݒB
 *	Jn󕶎ɂƋ\͍sȂȂ
 *	@param strBegin1, strBegin2	Jn
 *	@param strEnd1, strEnd2		I
 */
void CEditView::SetMultilineCommentDelimiters(
		const wstring& strBegin1, const wstring& strEnd1,
		const wstring& strBegin2, const wstring& strEnd2) {
	AssertValid();
	if(strBegin1.empty()) {
		m_FoundationInfo.strCommentStart1.erase();
		m_FoundationInfo.strCommentEnd1.erase();
	} else {
		assert(!strEnd1.empty());
		m_FoundationInfo.strCommentStart1 = strBegin1;
		m_FoundationInfo.strCommentEnd1 = strEnd1;
	}
	if(strBegin2.empty()) {
		m_FoundationInfo.strCommentStart2.erase();
		m_FoundationInfo.strCommentEnd2.erase();
	} else {
		assert(!strEnd2.empty());
		m_FoundationInfo.strCommentStart2 = strBegin2;
		m_FoundationInfo.strCommentEnd2 = strEnd2;
	}

	if(!m_FoundationInfo.bLockedParsing) {
		m_pLineLayoutManager->NotifyAll(LPL_MULTILINECOMMENT);
		if(IsWindow())
			InvalidateRect(0, false);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetMultilineCommentDelimiters(strBegin1, strEnd1, strBegin2, strEnd2);
	}
}

/**
 *	Zq̐ݒ
 *	@param listOperators	ݒ肷鉉Zq̃Xg
 */
void CEditView::SetOperators(const list<wstring>& listOperators) {
	AssertValid();

	OperatorMap&					mapOperators = m_FoundationInfo.mapOperators;
	list<wstring>::const_iterator	itOps;
	OperatorMap::iterator			itInis;

	mapOperators.clear();
	for(itOps = listOperators.begin(); itOps != listOperators.end(); ++itOps) {
		if(itOps->empty())
			continue;
		mapOperators[itOps->at(0)].push_back(*itOps);
	}
	for(itInis = mapOperators.begin(); itInis != mapOperators.end(); ++itInis)
		itInis->second.sort(_CompareStringByLength);

	if(!m_FoundationInfo.bLockedParsing) {
		m_pLineLayoutManager->NotifyAll(LPL_TOKEN);
		if(IsWindow())
			InvalidateRect(0, false);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetOperators(listOperators);
	}
}

/**
 *	̑̐ݒ
 *	@param evo	ݒ
 */
void CEditView::SetOption(TEditViewOption& evo) {
	AssertValid();

	const EditViewOption&	misc = evo.evoMiscellaneous;

	m_ModeState.bResetDirByToken = toBoolean(misc & EVO_RESETDIRECTIONBYTOKEN);
	m_ModeState.bUseOLEDragDrop = toBoolean(misc & EVO_USE_OLEDRAGDROP);
	m_ModeState.aitAutoIndentType = evo.aitAutoIndentType;
	m_ModeState.cFindLimit = evo.cRecognizingLines;
	m_FoundationInfo.bDrawBreakArrow = toBoolean(misc & EVO_SHOW_BREAKARROWS);
	m_FoundationInfo.bDrawCurrentUnderline = toBoolean(misc & EVO_SHOW_CURRENTUNDERLINE);
	m_FoundationInfo.bDrawEOF = toBoolean(misc & EVO_SHOW_EOFMARK);
	m_FoundationInfo.bDrawSpaces = toBoolean(misc & EVO_SHOW_WHITESPACE);
	m_FoundationInfo.bIgnoreCaseOnHilite = toBoolean(misc & EVO_IGNORECASE);
	m_FoundationInfo.bPaintBreakContinuingSelection = toBoolean(misc & EVO_PAINTBREAKCONTINUINGSEL);
	m_FoundationInfo.bDrawBoldCharsClosely = toBoolean(misc & EVO_MAKECLOSEBOLDCHARS);
	m_FoundationInfo.chSpace = evo.chWhitespaceAlternative;
	m_FoundationInfo.chTab = evo.chTabAlternative;
	m_FoundationInfo.strEndOfFile = evo.strEndOfFile;

	// UTF-16 -> UTF-32 (xstring::find(ulong) Ōł悤ɂ)
	const wchar_t*		pwszChars = evo.strCharsTreatedAsAlpha.c_str();
	wstring::size_type	cchChars = evo.strCharsTreatedAsAlpha.length();
	unsigned long		nCodePoint;
	m_FoundationInfo.listCharsTreatedAsAlpha.clear();
	for(wstring::size_type i = 0; i < evo.strCharsTreatedAsAlpha.length(); ++i) {
		nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pwszChars + i, cchChars - i);
		m_FoundationInfo.listCharsTreatedAsAlpha.push_back(nCodePoint);
		i += (nCodePoint >= 0x010000) ? 1 : 0;
	}
	m_FoundationInfo.listCharsTreatedAsAlpha.sort();
	m_pLineLayoutManager->NotifyAll(LPL_TOKEN);	// [U`P\ύXꂽ̂
												// ̕тς\
	if(IsWindow())
		InvalidateRect(0, false);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetOption(evo);
	}
}

/**
 *	㏑[h̐ݒ
 *	@param bOvertype	true: ㏑Afalse: }
 */
void CEditView::SetOvertypeMode(bool bOvertype /* = true */) {
	AssertValid();

	m_ModeState.bOvertype = bOvertype;
	if(!m_ModeState.bOvertype) {
		RecreateCaret();
		if(::GetFocus() == m_hWnd)
			ShowCaret();
	}
	ValidateCaretPos();
	if(IsWindow())
		SetFocus();
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

/**
 *	݈ʒuAI͈͂̐ݒ
 *	@param posAnchor	IJnʒu
 *	@param posActive	IIʒu
 *	@param bScroll		VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint		ĕ`悷邩ǂBfalse ɂĂXV̈vZ邪Lbg͈ړȂ
 */
void CEditView::SetSel(const CCharPos& posAnchor,
		const CCharPos& posActive, bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValidAsWindow();

	if(*m_pAnchorPoint != posAnchor || *m_pActivePoint != posActive) {
		CEditDoc*		pDoc = GetDocument();
		unsigned long	cLines = pDoc->GetLineCount();
		unsigned long	cchLine;
		unsigned long	nOriginColumn[] = {m_pAnchorPoint->m_iChar, m_pActivePoint->m_iChar};	// ̗̈ʒu
		bool			bAnchorAndActiveIsSame = posAnchor == posActive;

		HideCaret();

		// ̈ʒuۑ
		CCharPos	posTopOrg = GetSelTopPoint();
		CCharPos	posBottomOrg = GetSelBottomPoint();

		// n_̍sƗ̒
		CCharPos	posAnchorOrg = *m_pAnchorPoint;
		m_pAnchorPoint->m_iLine = std::min(posAnchor.m_iLine, cLines - 1);
		cchLine = pDoc->GetLineLength(m_pAnchorPoint->m_iLine);
		m_pAnchorPoint->m_iChar = std::min(posAnchor.m_iChar, cchLine);
		if(!m_ModeState.bCaretMarkByMouse)
			m_pAnchorPoint->m_iChar += MakeCaretPosValid(
				pDoc->GetLine(m_pAnchorPoint->m_iLine).c_str(),
					cchLine, m_pAnchorPoint->m_iChar, posAnchor < posAnchorOrg);

		// I_̍sƗ̒
		if(bAnchorAndActiveIsSame)
			m_pActivePoint->MoveToPoint(*m_pAnchorPoint);
		else {
			CCharPos	posActiveOrg = *m_pActivePoint;
			m_pActivePoint->m_iLine = std::min(posActive.m_iLine, cLines - 1);
			cchLine = pDoc->GetLineLength(m_pActivePoint->m_iLine);
			m_pActivePoint->m_iChar = std::min(posActive.m_iChar, cchLine);
			if(!m_ModeState.bCaretMarkByMouse)
				m_pActivePoint->m_iChar += MakeCaretPosValid(
					pDoc->GetLine(m_pActivePoint->m_iLine).c_str(),
						cchLine, m_pActivePoint->m_iChar, posActive < posActiveOrg);
		}

		// Lbg/I͈͂̐ݒ
		if(bRepaint)
			ValidateCaretPos();
		ShowCaret();

		if(!m_ModeState.bBoxSelecting) {
			// XV
			if(posTopOrg == posBottomOrg) {	// XIꍇ
				if(HasSelection())	// I쐬
					InvalidateLines(
						min(GetSelTopPoint().m_iLine, posBottomOrg.m_iLine),
						max(GetSelBottomPoint().m_iLine, posBottomOrg.m_iLine));
				else {
					InvalidateLine(m_pActivePoint->m_iLine);
					UpdateWindow();
					InvalidateLine(posBottomOrg.m_iLine);
				}
			} else {	// XIꍇ
				if(!HasSelection())	// I
					InvalidateLines(
						(posTopOrg.m_iLine < m_pAnchorPoint->m_iLine) ? posTopOrg.m_iLine : m_pAnchorPoint->m_iLine,
						(posBottomOrg.m_iLine > m_pActivePoint->m_iLine) ? posBottomOrg.m_iLine : m_pActivePoint->m_iLine);
				else {	// I͈͂ύX
					const CCharPos&	posTop = GetSelTopPoint();
					const CCharPos&	posBottom = GetSelBottomPoint();
					if(posTop == posTopOrg)	// n_Œ
						InvalidateLines(posBottom.m_iLine, posBottomOrg.m_iLine);
					else if(posBottom == posBottomOrg)	// I_Œ
						InvalidateLines(posTop.m_iLine, posTopOrg.m_iLine);
					else	// ω
						InvalidateLines(min(posTop.m_iLine, posTopOrg.m_iLine), max(posBottom.m_iLine, posBottomOrg.m_iLine));
				}
			}
		} else {	// `I
			// XV
			const CCharPos&	posTop = GetSelTopPoint();
			const CCharPos&	posBottom = GetSelBottomPoint();

			m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
			m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x
				+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() - m_layoutInfo.nLeftTabWidth + 1;
			InvalidateLines(min(posTop, posTopOrg).m_iLine, max(posBottom, posBottomOrg).m_iLine);
		}

		if(bRepaint)
			UpdateWindow();
	}

	m_pAnchorPoint->MoveToPoint(*m_pAnchorPoint);
	m_pActivePoint->MoveToPoint(*m_pActivePoint);

	// Ίʂ̋\
	CheckMatchBrackets();

	// I͈͂LbgɂȂ悤ɃXN[
	if(bScroll)
		m_pActivePoint->EnsureVisible();

	// IME œ͒̏ꍇ͕ҏWEBhËʒuC
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();

	// CxgXiɒʒm (L[}NĐ͂ʒmȂ)
	if(m_pEventListener != 0 && bRepaint
			&& (m_pKeyMacroPlayer->GetState() != KMS_PLAYING || m_pKeyMacroPlayer->GetActiveView() != this))
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

/**
 *	Lbgʒu̐ݒ
 *	@param pos		ʒu
 *	@param bScroll	VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint	ĕ`悷邩ǂ
 */
void CEditView::SetSelWithoutSelection(const CCharPos& pos,
		bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValid();
	SetSel(pos, pos, bScroll, bRepaint);
}

/**
 *	Lbgʒu̐ݒ
 *	@param iLine, iChar	ʒu
 *	@param bScroll		VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint		ĕ`悷邩ǂ
 */
void CEditView::SetSelWithoutSelection(unsigned int iLine, unsigned int iChar,
		bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValid();
	SetSelWithoutSelection(CCharPos(iLine, iChar), bScroll, bRepaint);
}

/**
 *	sRg̊Jn̐ݒB
 *	󕶎w肷Ƌ\͍sȂȂ
 *	@param strHeader1, strHeader2	Jn
 */
void CEditView::SetSinglelineCommentHeaders(const wstring& strHeader1, const wstring& strHeader2) {
	AssertValid();

	m_FoundationInfo.strCommentLineHeader1 = strHeader1;
	m_FoundationInfo.strCommentLineHeader2 = strHeader2;

	if(!m_FoundationInfo.bLockedParsing) {
		m_pLineLayoutManager->NotifyAll(LPL_TOKEN);
		if(IsWindow())
			InvalidateRect(0, false);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetSinglelineCommentHeaders(strHeader1, strHeader2);
	}
}

///	^u̐ݒ
void CEditView::SetTabWidth(unsigned short nTabWidth) {
	AssertValid();

	if(nTabWidth != m_layoutInfo.nTabWidth) {
		m_layoutInfo.nTabWidth = nTabWidth;
		if(IsWindow()) {
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
			InvalidateRect(0);
		}
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetTabWidth(nTabWidth);
	}
}

/**
 *	eLXg̕ݒ肷
 *	@param bRtlReading	E獶ɓǂޏꍇ
 */
void CEditView::SetTextDirection(bool bRtlReading) {
	AssertValid();

	if(m_ModeState.bRtlReading != bRtlReading) {
		m_ModeState.bRtlReading = bRtlReading;
		if(IsWindow()) {
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
			InvalidateRect(0);
		}
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetTextDirection(bRtlReading);
	}
}

/**
 *	C̐ݒ
 *	@param type			C̎
 *	@param tf			CBOiFƔwiF-1w肷ƎIɌ肳Bʏ̃eLXgA
 *						Í͈AANeBuȑI͈͂̓VXe`FȂ͒ʏ̃eLXgƓɂȂ
 *	@throw out_of_range	<var>type</var> sȂƂX[
 *	@see				GetTextFoundation
 */
void CEditView::SetTextFoundation(TextType type, const TTextFoundation& tf) throw(out_of_range) {
	AssertValid();
	if(type < TT_NORMAL || type >= TEXTTYPE_NUMBER)
		throw out_of_range("Specified type is invalid.");

	m_layoutInfo.tfTextFoundation[type] = tf;
	UpdateGDIObjects();
	if(IsWindow())
		InvalidateRect(0, false);

	try {
		if(m_pOriginalView == this) {
			for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
				(*it)->SetTextFoundation(type, tf);
		}
	} catch(out_of_range& /* e */) {
		throw;
	}
}

///	܂Ԃ[h̐ݒ
void CEditView::SetWrapMode(WrapMode wpm) {
	AssertValidAsWindow();

	if(wpm == m_ModeState.wpmWrapMode)
		return;

	WrapMode	wpmOrg = m_ModeState.wpmWrapMode;	// ̒lۑ

	m_ModeState.wpmWrapMode = wpm;
	m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s𒲐
	if(wpmOrg == WPM_NONE)
		OnVScroll(SB_THUMBPOSITION,
			DisplayCharFromLogicalChar(CCharPos(m_ptScroll.y * m_layoutInfo.nVScrollRatio, 0)).m_iLine, 0);
	else
		OnVScroll(SB_THUMBPOSITION,
			LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y * m_layoutInfo.nVScrollRatio, 0)).m_iLine, 0);
	ModifyScrollInfo(true, true);
	InvalidateRect(0, false);
}

///	܂Ԃ̐ݒ
void CEditView::SetWrapWidth(unsigned long nWrapWidth) {
	AssertValid();

	m_ModeState.nWrapWidth = nWrapWidth;
	if(IsWindow() && m_ModeState.wpmWrapMode == WPM_SPECIFIED) {
		m_pLineLayoutManager->NotifyAll(LPL_FULL);
		ModifyScrollInfo(true, true);
		InvalidateRect(0, false);
	}
}

/**
 *	!gp֎~! ݖ
 *	݃LbĝsX}[gCfgB
 *	̃\bh <var>ch</var> ̑}s (ۂɃX}[gCfgƂ̂)A
 *	̂Ƃɂ͑Ŝ̑삪 OCF_PREVENTALL ƂȂ悤ɏB
 *	݂̃\bh͈ꕔ̌łӖB
 *	̌ǉɂ̓|V[NXKvB
 *	X}[gCfg̋ ߂.txt ɂ܂Ƃ߂Ă
 *	@param ch	X}[gCfgs͕ (s L'\n' g)
 *	@return		X}[gCfgsǂ
 */
bool CEditView::SmartIndent(wchar_t ch) {
/*	AssertValidAsWindow();

	unsigned long	nNest = 1;	// ʂ̃lXgx

	if(ch == L'{' || ch == L'}') {	// '{' T
		if(m_posActive.iLine == 0)
			return false;
		if(-1 == FindBrace(m_posActive.iLine, L'{', nNest, m_posActive.iChar - 1)) {	// ݍsT
			for(unsigned long iLine = m_posActive.iLine - 1;	// skĒT
					m_posActive.iLine - iLine < m_ModeState.cFindLimit; --iLine) {
				if(-1 != FindBrace(iLine, L'{', nNest))
					break;
				if(iLine == 0)
					break;
			}
			CEditDoc*		pDoc = GetDocument();
			const wstring&	strLine = pDoc->GetLine(iLine);
			unsigned long	cchIndent = IsWhiteSpace(strLine.c_str(), strLine.length());
			wstring			strIndent = strLine.substr(0, cchIndent);

			strLine = pDoc->GetLine(m_posActive.iLine);
			unsigned long	cchIndentOld = IsWhiteSpace(strLine.c_str(), strLine.length());
			if(ch == L'{') {
				strIndent.insert(0, L'\t');
				cchIndent += 1;
			}
			if(cchIndentOld != 0)
				pDoc->DeleteText(this,
					CCharPos(m_posActive.iLine, 0), CCharPos(m_posActive.iLine, cchIndentOld),
					static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			pDoc->InsertText(this, CCharPos(m_posActive.iLine, 0), strIndent,
				(cchIndentOld != 0) ? OCF_CONCATALL
				: static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, m_posActive.iChar + cchIndent - cchIndentOld);
			InsertText(wstring(&ch, 1),
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			return true;
		}
	} else if(ch == L'\n') {	// O̍s𒲂ׂ
		const wstring&	strPrevLine = GetDocument()->GetLine(m_posActive.iLine).substr(0, m_posActive.iChar);
		unsigned long	cchPrevLine = strPrevLine.length();
		const wchar_t*	pwszPrevLine = strPrevLine.c_str();
		unsigned long	iChar = 0;					// ݈ʒu
		MCommentType	mct = m_pLineLayoutManager->FindByLineNumber(m_posActive.iLine)->m_mctFromPrev;
		bool			bMCommentContinued = mct != MCT_NOTCOMMENT;
		unsigned long	nBraceLevel = 0;			// ʂ̓qx
		unsigned long	nParenLevel = 0;			// ۊʂ̓qx
		bool			bLastIsSemicolon = false;	// ŌɒׂZ~R
		unsigned long	cchToken;					// g[N̒
		
		// ʂĂ邩AŌ̕𒲂ׂ
		while(iChar < cchPrevLine) {
			if(iChar == 0 && mct == MCT_1) {
				cchToken = IsMComment1(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(iChar == 0 && mct == MCT_2) {
				cchToken = IsMComment2(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(0 != IsSComment1(pwszPrevLine + iChar) || 0 != IsSComment2(pwszPrevLine + iChar))
				break;
			else if(0 != (cchToken = IsMComment1(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))
					|| 0 != (cchToken = IsMComment2(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))) {
				if(bMCommentContinued)
					break;
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsSingleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))
					|| 0 != (cchToken = IsDoubleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))) {
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsWhiteSpace(pwszPrevLine + iChar, cchPrevLine - iChar)))
				iChar += cchToken;
			else {	// ̑̕
				wchar_t	wch = *(pwszPrevLine + iChar);
				if(wch == L';')
					bLastIsSemicolon = true;
				else {
					bLastIsSemicolon = false;
					if(wch == L'{')								++nBraceLevel;
					else if(wch == L'(')						++nParenLevel;
					else if(wch == L'}' && nBraceLevel != 0)	--nBraceLevel;
					else if(wch == L')' && nParenLevel != 0)	--nParenLevel;
				}
				++iChar;
			}
		}

		// X}[gCfg邩?
		unsigned long	cchIndentOld = IsWhiteSpace(strPrevLine.c_str(), cchPrevLine);
		if((nBraceLevel != 0 || nParenLevel != 0)
				|| (!bLastIsSemicolon && cchIndentOld != 0)) {
			ReplaceSel(CEditDoc::m_arrBreakStrings[GetDocument()->GetBreakType()],
				static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));

			unsigned long	iCharOrg = m_posActive.iChar;
			CEditDoc*		pDoc = GetDocument();
			const wstring&	strCurrentLine = pDoc->GetLine(m_posActive.iLine);
			unsigned long	cchIndent = IsWhiteSpace(strCurrentLine.c_str(), strCurrentLine.length());
			wstring			strIndent = L"\t" + strPrevLine.substr(0, cchIndentOld);

			pDoc->DeleteText(this, m_posActive, CCharPos(m_posActive.iLine, cchIndent), OCF_CONCATALL);
			InsertText(strIndent,
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, iCharOrg);
			return true;
		}
	}
*/
	return false;
}

/**
 *	w肵s̃ubN}[Nݒ/Bݒ肳ĂΉAĂΐݒ肷
 *	@param iLine		ݒ肷s
 *	@throw out_of_range	<var>iLine</var> sԍƂĐȂꍇX[
 *	@see				CEditView::SetBookmark
 */
void CEditView::ToggleBookmark(unsigned long iLine) throw(out_of_range) {
	AssertValid();
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	pInfo->SetBookmark(!pInfo->IsBookmarked());
	if(IsWindowVisible())
		InvalidateLine(iLine);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->ToggleBookmark(iLine);
	}
}

///	Unfreeze ̖{
void CEditView::_Unfreeze() {
	AssertValidAsWindow();

	unsigned long		iAnchor = -1;
	const unsigned long	cVisibleLines = GetVisibleLineCount();

	for(unsigned long i = m_ptScroll.y; i <= m_ptScroll.y + cVisibleLines; ++i) {
		set<unsigned long>::iterator	it = m_setInvalidLines.find(i);

		if(it != m_setInvalidLines.end()) {
			m_setInvalidLines.erase(it);
			if(iAnchor == -1)
				iAnchor = i;
		} else if(iAnchor != -1) {
			InvalidateLines(iAnchor, i - 1);
			iAnchor = -1;
		}
	}
	if(iAnchor != -1)
		InvalidateLines(iAnchor, m_ptScroll.y + cVisibleLines);

	m_setInvalidLines.clear();
}

///	`̃t[Y
void CEditView::Unfreeze() {
	AssertValidAsWindow();

	m_pOriginalView->m_bFreezed = false;
	m_pOriginalView->_Unfreeze();
	for(set<CEditView*>::iterator it =
			m_pOriginalView->m_setClones.begin();
			it != m_pOriginalView->m_setClones.end(); ++it) {
		(*it)->m_bFreezed = false;
		(*it)->_Unfreeze();
	}
}

///	s̗͂}B
///	̃\bhĂяoƃhLgŜ̉͂1xsB
void CEditView::UnlockParsing() {
	AssertValid();

	m_FoundationInfo.bLockedParsing = false;
	m_pLineLayoutManager->NotifyAll(LPL_MULTILINECOMMENT);
	if(IsWindowVisible())
		InvalidateRect(0, false);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->UnlockParsing();
	}
}

///	݂̐ݒg GDI IuWFNgXV
void CEditView::UpdateGDIObjects() {
//	LOGBRUSH	lb;

	::DeleteObject(m_GDIObjects.hUnderlinePen);
	::DeleteObject(m_GDIObjects.hIAUnderlinePen);
	::DeleteObject(m_GDIObjects.hLeftIndicatorPen);
	::DeleteObject(m_GDIObjects.hLineNumberPen);
	::DeleteObject(m_GDIObjects.hColumnPen);
	::DeleteObject(m_GDIObjects.hWhiteSpacePen);
	::DeleteObject(m_GDIObjects.hLineBreakPen);

	m_GDIObjects.hUnderlinePen = ::CreatePen(PS_SOLID, 1,
		(m_layoutInfo.clrUnderline != -1) ? m_layoutInfo.clrUnderline : ::GetSysColor(COLOR_HIGHLIGHT));
	m_GDIObjects.hIAUnderlinePen = ::CreatePen(PS_SOLID, 1,
		(m_layoutInfo.clrIAUnderline != -1) ? m_layoutInfo.clrIAUnderline : ::GetSysColor(COLOR_INACTIVECAPTION));
	m_GDIObjects.hLeftIndicatorPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_INDICATORMARGIN).fgColor);
	m_GDIObjects.hLineNumberPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_LINENUMBER).fgColor);
//	lb.lbColor = m_layoutInfo.tfTextFoundation[TT_LINENUMBER].fgColor;
//	lb.lbStyle = BS_SOLID;
//	m_GDIObjects.hLineNumberPen = ::ExtCreatePen(PS_COSMETIC | PS_ALTERNATE, 1, &lb, 0, 0);
	m_GDIObjects.hColumnPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_COLUMNNUMBER).fgColor);
	m_GDIObjects.hWhiteSpacePen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_SPACE).fgColor);
	m_GDIObjects.hLineBreakPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_BREAK).fgColor);
}

///	݈ʒuƃXN[󋵁AtHgȂǂLbgK؂ȈʒuɈړ
void CEditView::ValidateCaretPos() {
	if(m_hWnd != ::GetFocus())
		return;
	if(m_ModeState.bOvertype) {
		RecreateCaret();
		if(::GetFocus() == m_hWnd)
			ShowCaret();
	}

	POINT		pt = PosFromChar(*m_pActivePoint);

	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))	// LbguBv
		pt.x = -static_cast<long>(m_layoutInfo.nCharWidth);
	else if(pt.y < static_cast<long>(m_layoutInfo.nTopMargin))	// LbguBv
		pt.y = -static_cast<long>(m_layoutInfo.nLineHeight);
	if(!m_ModeState.bOvertype || HasSelection())
		--pt.x;
	SetCaretPos(pt);
}

///	IME tH[𐳂ʒuɈړ
void CEditView::ValidateIMEWindowPos() {
	AssertValidAsWindow();
	if(!m_bActiveIMEComposition)
		return;

	COMPOSITIONFORM	cf;
	HIMC			hIMC = ::ImmGetContext(m_hWnd);

	if(hIMC != 0) {
		cf.dwStyle = CFS_POINT;
		cf.ptCurrentPos = PosFromChar(*m_pActivePoint);
	//	cf.ptCurrentPos.x -= 1;
		cf.ptCurrentPos.y -= 1;
		::ImmSetCompositionWindow(hIMC, &cf);
		::ImmReleaseContext(m_hWnd, hIMC);
	}
}

/**
 *	̃EBhENX̃vZX
 *	@param hWnd				EBhEnh
 *	@param message			bZ[W
 *	@param wParam, lParam	bZ[Wˑ
 *	@return					bZ[Wˑ
 */
LRESULT CALLBACK CEditView::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	CEditView*	pView = 0;
	if(message == WM_CREATE) {
		pView = reinterpret_cast<CEditView*>(reinterpret_cast<CREATESTRUCTW*>(lParam)->lpCreateParams);
		pView->m_hWnd = hWnd;
		pView->SetWindowLong(
			GWL_USERDATA, reinterpret_cast<long>(reinterpret_cast<CREATESTRUCTW*>(lParam)->lpCreateParams));
		return pView->DispatchEvent(message, wParam, lParam);
	} else {
		pView = reinterpret_cast<CEditView*>(::GetWindowLong(hWnd, GWL_USERDATA));
		return (pView != 0 && pView->m_hWnd == hWnd) ?
			pView->DispatchEvent(message, wParam, lParam) : ::DefWindowProc(hWnd, message, wParam, lParam);
	}
}

/// @see	CWindow::OnChar
void CEditView::OnChar(UINT nChar, UINT nFlags) {
	ExecCommand(CMDID_EDIT_CHAR, nChar);
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
}

/// @see	CWindow::OnCommand
bool CEditView::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case WM_UNDO:	// [ɖ߂]
		ExecCommand(CMDID_EDIT_UNDO, 0L);
		break;
	case WM_REDO:	// [蒼]
		ExecCommand(CMDID_EDIT_REDO, 0L);
		break;
	case WM_CUT:	// [؂]
		ExecCommand(CMDID_EDIT_CUT, 0L);
		break;
	case WM_COPY:	// [Rs[]
		ExecCommand(CMDID_EDIT_COPY, 0L);
		break;
	case WM_PASTE:	// [\t]
		ExecCommand(CMDID_EDIT_PASTE, 0L);
		break;
	case WM_CLEAR:	// [폜]
		ExecCommand(CMDID_EDIT_DELETE, 0L);
		break;
	case WM_SELECTALL:	// [ׂđI]
		ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		break;
	case ID_SHOWUNICODECONTROLCHARS:	// [Unicode 䕶̕\]
		m_ModeState.bShowUnicodeCtrls = !m_ModeState.bShowUnicodeCtrls;
		InvalidateRect(0);
		break;
	case ID_INSERT_LRM:		ExecCommand(CMDID_EDIT_CHAR, 0x200E);	break;
	case ID_INSERT_RLM:		ExecCommand(CMDID_EDIT_CHAR, 0x200F);	break;
	case ID_INSERT_ZWJ:		ExecCommand(CMDID_EDIT_CHAR, 0x200D);	break;
	case ID_INSERT_ZWNJ:	ExecCommand(CMDID_EDIT_CHAR, 0x200C);	break;
	case ID_INSERT_LRE:		ExecCommand(CMDID_EDIT_CHAR, 0x202A);	break;
	case ID_INSERT_RLE:		ExecCommand(CMDID_EDIT_CHAR, 0x202B);	break;
	case ID_INSERT_LRO:		ExecCommand(CMDID_EDIT_CHAR, 0x202D);	break;
	case ID_INSERT_RLO:		ExecCommand(CMDID_EDIT_CHAR, 0x202E);	break;
	case ID_INSERT_PDF:		ExecCommand(CMDID_EDIT_CHAR, 0x202C);	break;
	case ID_INSERT_WJ:		ExecCommand(CMDID_EDIT_CHAR, 0x2060);	break;
	case ID_INSERT_U2061:	ExecCommand(CMDID_EDIT_CHAR, 0x2061);	break;
	case ID_INSERT_U2062:	ExecCommand(CMDID_EDIT_CHAR, 0x2062);	break;
	case ID_INSERT_U2063:	ExecCommand(CMDID_EDIT_CHAR, 0x2063);	break;
/*	case ID_INSERT_NADS:	ExecCommand(CMDID_EDIT_CHAR, 0x206E);	break;
	case ID_INSERT_NODS:	ExecCommand(CMDID_EDIT_CHAR, 0x206F);	break;
	case ID_INSERT_ASS:		ExecCommand(CMDID_EDIT_CHAR, 0x206B);	break;
	case ID_INSERT_ISS:		ExecCommand(CMDID_EDIT_CHAR, 0x206A);	break;
	case ID_INSERT_AAFS:	ExecCommand(CMDID_EDIT_CHAR, 0x206D);	break;
	case ID_INSERT_IAFS:	ExecCommand(CMDID_EDIT_CHAR, 0x206C);	break;*/
	case ID_INSERT_RS:		ExecCommand(CMDID_EDIT_CHAR, 0x001E);	break;
	case ID_INSERT_US:		ExecCommand(CMDID_EDIT_CHAR, 0x001F);	break;
	case ID_INSERT_U0020:	ExecCommand(CMDID_EDIT_CHAR, 0x0020);	break;
	case ID_INSERT_NBSP:	ExecCommand(CMDID_EDIT_CHAR, 0x00A0);	break;
	case ID_INSERT_U1680:	ExecCommand(CMDID_EDIT_CHAR, 0x1680);	break;
	case ID_INSERT_MVS:		ExecCommand(CMDID_EDIT_CHAR, 0x180E);	break;
	case ID_INSERT_U2000:	ExecCommand(CMDID_EDIT_CHAR, 0x2000);	break;
	case ID_INSERT_U2001:	ExecCommand(CMDID_EDIT_CHAR, 0x2001);	break;
	case ID_INSERT_U2002:	ExecCommand(CMDID_EDIT_CHAR, 0x2002);	break;
	case ID_INSERT_U2003:	ExecCommand(CMDID_EDIT_CHAR, 0x2003);	break;
	case ID_INSERT_U2004:	ExecCommand(CMDID_EDIT_CHAR, 0x2004);	break;
	case ID_INSERT_U2005:	ExecCommand(CMDID_EDIT_CHAR, 0x2005);	break;
	case ID_INSERT_U2006:	ExecCommand(CMDID_EDIT_CHAR, 0x2006);	break;
	case ID_INSERT_U2007:	ExecCommand(CMDID_EDIT_CHAR, 0x2007);	break;
	case ID_INSERT_U2008:	ExecCommand(CMDID_EDIT_CHAR, 0x2008);	break;
	case ID_INSERT_U2009:	ExecCommand(CMDID_EDIT_CHAR, 0x2009);	break;
	case ID_INSERT_U200A:	ExecCommand(CMDID_EDIT_CHAR, 0x200A);	break;
	case ID_INSERT_ZWSP:	ExecCommand(CMDID_EDIT_CHAR, 0x200B);	break;
	case ID_INSERT_NNBSP:	ExecCommand(CMDID_EDIT_CHAR, 0x202F);	break;
	case ID_INSERT_MMSP:	ExecCommand(CMDID_EDIT_CHAR, 0x205F);	break;
	case ID_INSERT_U3000:	ExecCommand(CMDID_EDIT_CHAR, 0x3000);	break;
	case ID_INSERT_NEL:		ExecCommand(CMDID_EDIT_CHAR, 0x0085);	break;
	case ID_INSERT_LS:		ExecCommand(CMDID_EDIT_CHAR, 0x2028);	break;
	case ID_INSERT_PS:		ExecCommand(CMDID_EDIT_CHAR, 0x2029);	break;
	case ID_TOGGLEIMESTATUS:	// [IME J] / [IME ]
		ExecCommand(CMDID_EDIT_TOGGLEIMESTATUS, 0L);
		break;
	case ID_RECOMPOSITIONIME:	// [ĕϊ]
		ExecCommand(CMDID_EDIT_RECOMPOSESELECTION, 0L);
		break;
	default:
		if(GetParent() != 0)
			GetParent()->SendMessage(WM_COMMAND,
				MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
	}

	return CView::OnCommand(wID, wNotifyCode, hwndCtrl);
}

/// @see	CWindow::OnContextMenu
bool CEditView::OnContextMenu(HWND hWnd, POINT pt) {
	RECT	rect;

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);

	// L[{[hɂꍇ
	if(pt.x == 65535 && pt.y == 65535) {
		pt.x = pt.y = 1;	// K...
		ClientToScreen(&pt);
	}

	// XN[o[łΏȂ
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if(!::PtInRect(&rect, pt))
		return false;

	CEditDoc*	pDoc = GetDocument();
	bool		bSelection = HasSelection();
	bool		bReadOnly = GetDocument()->IsReadOnly();

	// j[ڂ̏C
	m_oContextMenu.EnableMenuItem(WM_UNDO, !bReadOnly && pDoc->GetUndoHistoryLength() != 0);
	m_oContextMenu.EnableMenuItem(WM_REDO, !bReadOnly && pDoc->GetUndoHistoryLength(true) != 0);
	m_oContextMenu.EnableMenuItem(WM_CUT, !bReadOnly && bSelection);
	m_oContextMenu.EnableMenuItem(WM_COPY, bSelection);
	m_oContextMenu.EnableMenuItem(WM_PASTE, !bReadOnly && CanPaste());
	m_oContextMenu.EnableMenuItem(WM_CLEAR, !bReadOnly && bSelection);
	m_oContextMenu.CheckMenuItem(ID_SHOWUNICODECONTROLCHARS, m_ModeState.bShowUnicodeCtrls);
	if(toBoolean(::ImmIsIME(::GetKeyboardLayout(::GetCurrentThreadId())))) {
		HIMC	hImc = ::ImmGetContext(m_hWnd);
		m_oContextMenu.ModifyMenuItem(ID_TOGGLEIMESTATUS, MF_STRING,
			(::GetUserDefaultLangID() == 0x0411) ? (::ImmGetOpenStatus(hImc) ? L"IME (&L)" : L"IME J(&O)")
			: (::ImmGetOpenStatus(hImc) ? L"C&lose IME" : L"&Open IME"));
		m_oContextMenu.EnableMenuItem(ID_RECOMPOSITIONIME, !bReadOnly && bSelection);
		::ImmReleaseContext(m_hWnd, hImc);
	}

	m_oContextMenu.TrackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, m_hWnd);

	return true;
}

/// @see	CWindow::OnDestroy
void CEditView::OnDestroy() {
	// D&D 
	RevokeDragDrop();

	// ]EBhE폜
	m_pwndAutoComplete->DestroyWindow();

	CWindow::OnDestroy();
}

///	hLg[hɈxĂяo
///	@see	CView::OnDocumentSetup
void CEditView::OnDocumentSetup(LPARAM lHint /* = 0 */) {
	m_pAnchorPoint->MoveToPoint(CCharPos(0, 0));
	m_pActivePoint->MoveToPoint(CCharPos(0, 0));
	m_pLineLayoutManager->ReconstructAll();
	RecalcLeftTabWidth();
	ModifyScrollInfo(true, true);
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
	ValidateCaretPos();
}

/// @see	CWindow::OnHScroll
void CEditView::OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	int	nOrgPos = m_ptScroll.x;	// ̈ʒuۑ
	int	nMinPos, nMaxPos;		// őAŏʒu
	int	cVisibleChars = GetVisibleCharCount();

	GetScrollRange(SB_HORZ, &nMinPos, &nMaxPos);

//	if(m_pwndAutoComplete->IsWindowVisible())
//		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(cVisibleChars >= (nMaxPos - nMinPos) * static_cast<int>(m_layoutInfo.nHScrollRatio)) {
		m_ptScroll.x = 0;
		return;
	}

	switch(nSBCode) {
	case SB_LINELEFT:		// 1񕪍
		--m_ptScroll.x;	break;
	case SB_LINERIGHT:		// 1񕪉E
		++m_ptScroll.x;	break;
	case SB_PAGELEFT:		// 1y[W
		m_ptScroll.x -= GetVisibleCharCount();	break;
	case SB_PAGERIGHT:		// 1y[WE
		m_ptScroll.x += GetVisibleCharCount();	break;
	case SB_LEFT:			// [
		m_ptScroll.x = nMinPos;	break;
	case SB_RIGHT:			// E[
		m_ptScroll.x = nMaxPos;	break;
	case SB_THUMBTRACK:		// hbO or zC[
		m_ptScroll.x = GetScrollTrackPos(SB_HORZ);	break;	// 32rbglg
	case SB_THUMBPOSITION:	// ???
		m_ptScroll.x = nPos;
	}

	// 
	if(m_ptScroll.x < nMinPos)
		m_ptScroll.x = nMinPos;
	else if(m_ptScroll.x > static_cast<long>(nMaxPos - GetVisibleCharCount() + 1))
		m_ptScroll.x = nMaxPos - GetVisibleCharCount() + 1;
	if(m_ptScroll.x == nOrgPos)	// XN[Ȃ
		return;

	// ĕ`Ȃ
	if(dif<long>(m_ptScroll.x, nOrgPos) < cVisibleChars) {	// XN[ʂ1y[Wȉ
		RECT	rectScroll;				// XN[Ώ
		int		dx = (nOrgPos - m_ptScroll.x) * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
		RECT	rectUpdate;

		GetClientRect(&rectScroll);
		rectUpdate = rectScroll;
		rectScroll.left = m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;
		if(dx > 0) {
			rectScroll.left += dx;
			rectUpdate.left += m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;
			rectUpdate.right = rectUpdate.left + dx;
		} else {
			rectScroll.right += dx;
			rectUpdate.left = rectUpdate.right + dx;
		}
		ScrollWindowEx(dx, 0, &rectScroll, &rectScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rectUpdate, false);
	} else
		InvalidateRect(0, false);

	SetScrollPos(SB_HORZ, m_ptScroll.x);
	ValidateCaretPos();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
//	UpdateWindow();

	if(m_pwndAutoComplete->IsWindow())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/// @see	WM_IME_COMPOSITION
bool CEditView::OnImeComposition(WPARAM wParam, LPARAM lParam) {
	if(lParam == 0 || toBoolean(lParam & GCS_RESULTSTR)) {	// m
		wchar_t*	pszText = 0;
		HIMC		hIMC = ::ImmGetContext(m_hWnd);

		if(hIMC != 0) {
			size_t	cch = ::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, 0, 0);

			if(cch != 0) {	// LZȂꍇ
				pszText = new wchar_t[cch / sizeof(wchar_t) + 1];
				::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, pszText, cch);
				*(pszText + cch / sizeof(wchar_t)) = 0;
				ReplaceSel(pszText);

				// ExecCommand ʂȂ̂łŃL[}NɋL^
				// (ExecCommand(CMDID_EDIT_CHAR) ͒x)
				if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING
						&& m_pKeyMacroPlayer->GetActiveView() == this) {
					TKeymacroCommand	kmc;
					kmc.cmd = CMDID_EDIT_CHAR;
					for(size_t i = 0; i < cch / sizeof(wchar_t); ++i) {
						kmc.lParam = pszText[i];
						m_pKeyMacroPlayer->AddCommand(kmc);
					}
				}
				delete[] pszText;
			}

			ValidateIMEWindowPos();
			::ImmReleaseContext(m_hWnd, hIMC);
		}
		return true;
	}
	return false;
}

///	@see	WM_IME_ENDCOMPOSITION
void CEditView::OnImeEndComposition() {
	ShowCaret();
	m_bActiveIMEComposition = false;
}

/// @see	WM_IME_STARTCOMPOSITION
void CEditView::OnImeStartComposition() {
	HIMC		hIMC = ::ImmGetContext(m_hWnd);
	LOGFONTW	lf;

	if(hIMC != 0) {
		::GetObject(m_GDIObjects.hNormalFont, sizeof(LOGFONTW), &lf);
		::ImmSetCompositionFontW(hIMC, &lf);	// IME ̐ݒɂĂ͔f邾낤
		HideCaret();
		::ImmReleaseContext(m_hWnd, hIMC);
	}
	m_bActiveIMEComposition = true;
	ValidateIMEWindowPos();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

///	AvP[VōׂL[蓖Ăꍇ̓I[o[Ch
/// @see	WM_KEYDOWN
void CEditView::OnKeyDown(UINT nChar, UINT nFlags) {
	bool	bCtrl = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);
	bool	bShift = toBoolean(::GetKeyState(VK_SHIFT) & 0x8000);
	bool	bAlt = toBoolean(nFlags & (1 << 29));

	switch(nChar) {
	case VK_LEFT:	// []
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_WORDPREVEXTEND : CMDID_MOVE_WORDPREV, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_CHARPREVEXTEND : CMDID_MOVE_CHARPREV, 1);
		break;
	case VK_RIGHT:	// []
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_WORDNEXTEXTEND : CMDID_MOVE_WORDNEXT, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_CHARNEXTEXTEND : CMDID_MOVE_CHARNEXT, 1);
		break;
	case VK_UP:		// []
		if(bCtrl)	ExecCommand(CMDID_SCROLL_LINEUP, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEUPEXTEND : CMDID_MOVE_LINEUP, 1);
		break;
	case VK_DOWN:	// []
		if(bCtrl)	ExecCommand(CMDID_SCROLL_LINEDOWN, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEDOWNEXTEND : CMDID_MOVE_LINEDOWN, 1);
		break;
	case VK_HOME:	// [Home]
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_HOMEEXTEND : CMDID_MOVE_HOME);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEHOMEEXTEND : CMDID_MOVE_LINEHOME);
		break;
	case VK_END:	// [End]
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_ENDEXTEND : CMDID_MOVE_END);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEENDEXTEND : CMDID_MOVE_LINEEND);
		break;
	case VK_NEXT:	// [PageDown]
		if(bCtrl)	ExecCommand(CMDID_SCROLL_PAGEDOWN, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_PAGEDOWNEXTEND : CMDID_MOVE_PAGEDOWN, 1);
		break;
	case VK_PRIOR:	// [PageUp]
		if(bCtrl)	ExecCommand(CMDID_SCROLL_PAGEUP, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_PAGEUPEXTEND : CMDID_MOVE_PAGEUP, 1);
		break;
	case VK_RETURN:	// [Enter]
		ExecCommand(bCtrl ? CMDID_EDIT_INSERTPREVLINE : CMDID_EDIT_BREAK);
		break;
	case VK_DELETE:	// [Delete]
		if(bCtrl)	ExecCommand(CMDID_EDIT_DELETETONEXTWORD);
		else		ExecCommand(bShift ? CMDID_EDIT_DELETELINE : CMDID_EDIT_DELETE);
		break;
	case VK_BACK:	// [BackSpace]
		ExecCommand(bCtrl ? CMDID_EDIT_DELETETOPREVWORD: CMDID_EDIT_BACKSPACE);
		break;
	case VK_INSERT:	// [Insert]
		ExecCommand(CMDID_EDIT_TOGGLEOVERTYPEMODE);
		break;
	case VK_ESCAPE:	// [Esc]
		ExecCommand(CMDID_MOVE_CANCELSELECTION);
		break;
	}
}

///	@see	CWindow::OnKillFocus
void CEditView::OnKillFocus(HWND hwndNew) {
	if(m_pwndAutoComplete->IsWindowVisible()
			&& hwndNew != m_pwndAutoComplete->m_hWnd)
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(m_bActiveIMEComposition) {	// IME œ͒ł΂߂
		HIMC	hImc = ::ImmGetContext(m_hWnd);
		::ImmNotifyIME(hImc, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		::ImmReleaseContext(m_hWnd, hImc);
	}
	HideCaret();
	DestroyCaret();
	InvalidateRect(0);
}
	
///	@see	CWindow::OnLButtonBblClk
void CEditView::OnLButtonDblClk(UINT nFlags, POINT pt) {
	// L[}NL^͖
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING && m_pKeyMacroPlayer->GetActiveView() == this)
		return;
	ExecCommand(CMDID_MOVE_SELECTCURRENTWORD, 0L);
}

///	@see	CWindow::OnLButtonDown
void CEditView::OnLButtonDown(UINT nFlags, POINT pt) {
	// L[}NL^͖
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING && m_pKeyMacroPlayer->GetActiveView() == this) {
		::MessageBeep(MB_OK);
		return;
	}

	CCharPos	pos;
	bool		bBoxDragging = false;

	// ͕⊮EBhE
	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);

	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {	// 1sI
		if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	// SsI
			ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		else {
			pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
			m_ldmLeftDown = LDM_LINESELECTION;
			SetSel(CCharPos(pos.m_iLine, 0), CCharPos(pos.m_iLine, -1));
		}
		SetCapture();
		SetTimer(ID_TIMER_EXPANDLINESELECTION, 100, 0);
	} else if(m_ModeState.bUseOLEDragDrop
			&& m_ModeState.bBoxSelecting
			&& HasSelection()
			&& IsOverSelection(pt)) {	// OLE hbOJn (`)
		wstring			strSelection = GetSelection();
		set<CLIPFORMAT>	setClipFormats;

		bBoxDragging = true;
		setClipFormats.insert(CF_UNICODETEXT);
		setClipFormats.insert(::RegisterClipboardFormatW(L"MSDEVColumnSelect"));
		m_pDragging->SetAvailableFormatSet(setClipFormats);
		m_pDragging->SetTextData(strSelection.c_str());
		m_ldmLeftDown = LDM_DRAGANDDROPBOXSELF;
		SetTimer(ID_TIMER_DRAGSCROLL, 100, 0);
		m_pDragging->DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		KillTimer(ID_TIMER_DRAGSCROLL);
		m_ldmLeftDown = LDM_NONE;	// OnLButtonUp ͌Ă΂Ȃ
	} else if(m_ModeState.bUseOLEDragDrop
			&& HasSelection()
			&& IsOverSelection(pt)) {	// OLE hbOJn
		wstring	strSelection = GetSelection();

		m_pDragging->SetTextData(strSelection.c_str());
		m_ldmLeftDown = LDM_DRAGANDDROPSELF;
		SetTimer(ID_TIMER_DRAGSCROLL, 50, 0);
		m_pDragging->DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		KillTimer(ID_TIMER_DRAGSCROLL);
		m_ldmLeftDown = LDM_NONE;	// OnLButtonUp ͌Ă΂Ȃ
	} else if(toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// `IJn
		m_ldmLeftDown = LDM_BOXSELECTION;
		pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
		*m_pAnchorPoint = pos;
		*m_pActivePoint = pos;
		BeginBoxSelect();
		OnMoveCaret();
		SetCapture();
		SetTimer(ID_TIMER_EXPANDSELECTION, 50, 0);
	} else {	// ̑B`IJnALbgړ
		m_ldmLeftDown = LDM_SELECTION;
		pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
		SetSelWithoutSelection(pos);
		if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))
			ExecCommand(CMDID_MOVE_SELECTCURRENTWORD, 0L);
		SetCapture();
		SetTimer(ID_TIMER_EXPANDSELECTION, 50, 0);
	}

	if(!bBoxDragging && m_ldmLeftDown != LDM_BOXSELECTION) {
		m_ModeState.bBoxSelecting = false;
		InvalidateLine(m_pActivePoint->m_iLine);
	}
	SetFocus();
}

///	@see	CWindow::OnLButtonUp
void CEditView::OnLButtonUp(UINT nFlags, POINT pt) {
	if(m_ldmLeftDown == LDM_BOXSELECTION) {	// `II -> I͈͊m
	}
	m_ldmLeftDown = LDM_NONE;
	KillTimer(ID_TIMER_EXPANDSELECTION);
	KillTimer(ID_TIMER_EXPANDLINESELECTION);
	ReleaseCapture();
}

///	@see	CWindow::OnMouseMove
void CEditView::OnMouseMove(UINT nFlags, POINT pt) {
	CCharPos	pos;	// J[\ʒu狁܂sƗ

	if(pt.x & 0x8000)	pt.x = 0;
	if(pt.y & 0x8000)	pt.y = 0;

	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCursor(pt);

	if(m_ldmLeftDown != LDM_NONE) {	// XN[
		if(pt.y < static_cast<long>(m_layoutInfo.nTopMargin + m_layoutInfo.nLineHeight / 2))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y > static_cast<long>(m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * GetVisibleLineCount()))
			OnVScroll(SB_LINEDOWN, 0, 0);
		if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))
			OnHScroll(SB_THUMBPOSITION, m_ptScroll.x - m_layoutInfo.nTabWidth, 0);
//		else if(pt.x >)
	}
	if(m_ldmLeftDown == LDM_SELECTION) {	// I͈͂̊g/k
		pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
		SetSel(*m_pAnchorPoint, pos);
	} else if(m_ldmLeftDown == LDM_BOXSELECTION) {	// `I͈͂̊g/k
		pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
		SetSel(*m_pAnchorPoint, pos);
	} else if(m_ldmLeftDown == LDM_LINESELECTION ) {	// sI̊g/k
		pos = CharFromPos(pt, !m_ModeState.bCaretMarkByMouse);
		if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth))
			pos.m_iChar = -1;
		else {	// ʏ̑I[hɈڍs
			KillTimer(ID_TIMER_EXPANDLINESELECTION);
			SetTimer(ID_TIMER_EXPANDSELECTION, 50, 0);
			m_ldmLeftDown = LDM_SELECTION;
		}
		SetSel(*m_pAnchorPoint, pos);
	} else if(m_ldmLeftDown == LDM_DRAGANDDROP) {	// IehbO
	}
}

///	@see	CWindow::OnMouseWheel
bool CEditView::OnMouseWheel(UINT nFlags, short zDelta, POINT pt) {
	UINT	nScrollLines;	// XN[s

	// VXeŐݒ肳Ăʂg
	if(!::SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &nScrollLines, 0))
		nScrollLines = 3;
	zDelta *= nScrollLines;
	SetScrollPos(SB_VERT, m_ptScroll.y - zDelta / WHEEL_DELTA, false);	// ɐݒ肵Ă (OnVScroll Q)
	OnVScroll(SB_THUMBTRACK, m_ptScroll.y - zDelta / WHEEL_DELTA, 0);

	return true;
}

///	LbgړɌĂяo
void CEditView::OnMoveCaret() {
	AssertValidAsWindow();

	if(m_ModeState.bBoxSelecting) {
		m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
		m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x
			+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() - m_layoutInfo.nLeftTabWidth + 1;
		InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
	}
	ValidateCaretPos();
	CheckMatchBrackets();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
	if(m_pEventListener != 0)
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
}

///	@see	CWindow::OnPaint
void CEditView::OnPaint() {
	HDC			hDC;
	HBITMAP		hOldBMP;
	HPEN		hOldPen;
	PAINTSTRUCT	paint;
	RECT		rectLine, rectClient;
	CEditDoc*	pDoc = reinterpret_cast<CEditDoc*>(GetDocument());
	CMinimalDC&	oDC = m_GDIObjects.oMemDC;

//	CTimer	tm(L"OnPaint");

	unsigned long	cLines = pDoc->GetLineCount();				// _s
	unsigned long	cDisplayLines = GetDisplayLineCount();		// \s
	unsigned long	nVisibleLineCount = GetVisibleLineCount();	// s
	CCharPos		posTop = GetSelTopPoint();					// IJnʒu
	CCharPos		posBottom = GetSelBottomPoint();			// IIʒu

	// 
	GetClientRect(&rectClient);
	::SetRect(&rectLine, 0, 0, rectClient.right, m_layoutInfo.nLineHeight);
	hDC = BeginPaint(&paint);
	m_layoutInfo.rectUpdate = paint.rcPaint;

	// 1s`
	hOldBMP = oDC.SelectObject(m_GDIObjects.hMemLineBMP);
	oDC.SetBkMode(OPAQUE);

	// `Jnʒu
	int					y = m_layoutInfo.nTopMargin;
	unsigned long		iLine;			// _s
	unsigned long		iDisplayLine;	// `Jn\s
	unsigned long		iOffset;
	LineIterator		itLine;
	CLineLayoutInfo*	pInfo = 0;
	unsigned long		iCurrentDisplayLine;	// Lbg\s (Iꍇ̂)
	
	if(m_layoutInfo.rectUpdate.top >= static_cast<long>(m_layoutInfo.nTopMargin))
		iDisplayLine = (m_layoutInfo.rectUpdate.top - m_layoutInfo.nTopMargin)
					/ m_layoutInfo.nLineHeight + m_ptScroll.y * m_layoutInfo.nVScrollRatio;
	else
		iDisplayLine = m_layoutInfo.rectUpdate.top / m_layoutInfo.nLineHeight + m_ptScroll.y * m_layoutInfo.nVScrollRatio;
	iDisplayLine = min(iDisplayLine, cDisplayLines - 1);
	if(iDisplayLine < cDisplayLines) {
		GetDisplayLineOffsetIndex(iDisplayLine, iLine, iOffset);
		y += (iDisplayLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight;
		y -= iOffset * m_layoutInfo.nLineHeight;
	}
	if(!HasSelection())
		iCurrentDisplayLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);

	// `JnsŏIs܂͕܂
	if(iLine < cLines) {
		itLine = GetDocument()->GetLineIterator(iLine);//CTimer otm(L"> Inn");
		for(; y < static_cast<int>(m_layoutInfo.rectUpdate.bottom)
				&& iLine < cLines; ++iLine, ++itLine) {
			// _s1s`
			pInfo = m_pLineLayoutManager->GetLine(iLine);
			y += DrawLine(iLine, y,
					itLine->GetLine(), itLine->GetBreakType(), pInfo) * m_layoutInfo.nLineHeight;

			// ݍsɉ
			if(m_FoundationInfo.bDrawCurrentUnderline
					&& !HasSelection()
					&& iLine == iCurrentDisplayLine) {
				hOldPen = oDC.SelectObject((::GetFocus() == m_hWnd) ?
					m_GDIObjects.hUnderlinePen : m_GDIObjects.hIAUnderlinePen);
				oDC.MoveTo(m_layoutInfo.nLeftMargin, y - 1);
				oDC.LineTo(rectLine.right, y - 1);
				oDC.SelectObject(hOldPen);
			}
		}
	}

	// ȍ~
	if(m_layoutInfo.rectUpdate.bottom > y
			&& y > static_cast<int>(m_layoutInfo.nTopMargin + m_layoutInfo.nLineHeight - 1))
		oDC.FillSolidRect(0, y,
			rectClient.right, m_layoutInfo.rectUpdate.bottom - y, GetTextFoundation(TT_NORMAL).bgColor);

	// ]̕`
	oDC.FillSolidRect(0, 0,
		rectClient.right, m_layoutInfo.nTopMargin, GetTextFoundation(TT_NORMAL).bgColor);

	::BitBlt(hDC, m_layoutInfo.rectUpdate.left, m_layoutInfo.rectUpdate.top,
		m_layoutInfo.rectUpdate.right - m_layoutInfo.rectUpdate.left,
		m_layoutInfo.rectUpdate.bottom - m_layoutInfo.rectUpdate.top,
		oDC.GetSafeHdc(), m_layoutInfo.rectUpdate.left - m_layoutInfo.nLeftTabWidth,
		m_layoutInfo.rectUpdate.top, SRCCOPY);
	oDC.SelectObject(hOldBMP);

	// т̕`
	if(m_layoutInfo.rectUpdate.left < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
		hOldBMP = oDC.SelectObject(m_GDIObjects.hMemLeftTabBMP);
		DrawLeftTab(iDisplayLine, min(cLines - 1, iDisplayLine +
			(m_layoutInfo.rectUpdate.bottom - m_layoutInfo.rectUpdate.top) / m_layoutInfo.nLineHeight));
		::BitBlt(hDC, 0, 0, m_layoutInfo.nLeftTabWidth,
			rectClient.bottom - rectClient.top - 0, oDC.GetSafeHdc(), 0, 0, SRCCOPY);
		oDC.SelectObject(hOldBMP);
	}

	EndPaint(&paint);
}

///	@see	CWindow::OnSetCursor
bool CEditView::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;		// J[\ʒu

	::GetCursorPos(&pt);
	ScreenToClient(&pt);
	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {	// 
		::SetCursor(::LoadCursor(0, IDC_ARROW));
		return true;
	} else if(m_ModeState.bUseOLEDragDrop && HasSelection()) {	// I͈ (hbO\ǂ)
		if(IsOverSelection(pt)) {
			::SetCursor(::LoadCursor(0, IDC_ARROW));
			return true;
		}
	}
	
//	wstring	strURI;
//	if(IsOverURIString(pt, strURI)) {	// URI
//		::SetCursor(::LoadCursor(0, IDC_HAND));
//		return true;
//	}

	return false;
}

///	@see	CWindow::OnSetFocus
void CEditView::OnSetFocus(HWND hwndOld) {
	// XN[ʒuɖ߂
	SetScrollPos(SB_HORZ, m_ptScroll.x, false);
	SetScrollPos(SB_VERT, m_ptScroll.y, true);
	InvalidateRect(0, true);

	// Lbg𕜊
	RecreateCaret();
	ShowCaret();
	ValidateCaretPos();
}

///	@see	CWindow::OnSize
void CEditView::OnSize(UINT nType, int cx, int cy) {
	HDC	hDC = GetDC();

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);

	// TCY̕ύXɍ킹 m_hMemLineBMP ̍XV
	::DeleteObject(m_GDIObjects.hMemLineBMP);
	m_GDIObjects.hMemLineBMP						// т]̕ύXɖʓ|Ȃ̂ő傫߂̒lg
		= ::CreateCompatibleBitmap(hDC, cx, cy);	// ̑葼̕ύXɃrbg}bvKv͖
	ReleaseDC(hDC);
	if(cy != 0)	RecalcLeftTabWidth(cy);

	// ܂Ԃ̍XV
	if(m_ModeState.wpmWrapMode == WPM_WINDOW)
		m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s̍XV
	m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;
	OnVScroll(SB_THUMBTRACK, 0, 0);
	OnHScroll(SB_THUMBTRACK, 0, 0);

	ModifyScrollInfo(true, true);
}

///	@see	CWindow::OnSysColorChange
void CEditView::OnSysColorChange() {
	for(unsigned int i = 0; i < TEXTTYPE_NUMBER; ++i)
		SetTextFoundation(static_cast<TextType>(i), m_layoutInfo.tfTextFoundation[i]);
	UpdateGDIObjects();
}

///	@see	CWindow::OnTimer
void CEditView::OnTimer(UINT nIDEvent) {
	if(nIDEvent == ID_TIMER_EXPANDSELECTION || nIDEvent == ID_TIMER_EXPANDLINESELECTION) {	// I𒆂̎XN[
		POINT	pt;
		RECT	rect;
		bool	bProcessed = false;

		::GetCursorPos(&pt);
		ScreenToClient(&pt);
		GetClientRect(&rect);
		rect.top += static_cast<long>(m_layoutInfo.nTopMargin);
		rect.left += static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin);

		if(pt.y <= rect.top) {
			OnVScroll(SB_THUMBPOSITION, m_ptScroll.y - (rect.top - pt.y) / m_layoutInfo.nLineHeight - 1, 0);
			bProcessed = true;
		} else if(pt.y >= rect.bottom) {
			OnVScroll(SB_THUMBPOSITION, m_ptScroll.y + (pt.y - rect.bottom) / m_layoutInfo.nLineHeight + 1, 0);
			bProcessed = true;
		} else if(nIDEvent != ID_TIMER_EXPANDLINESELECTION && pt.x <= rect.left) {
			OnHScroll(SB_THUMBPOSITION, m_ptScroll.x - (rect.left - pt.x) / GetAvgCharWidth() - 1, 0);
			bProcessed = true;
		} else if(nIDEvent != ID_TIMER_EXPANDLINESELECTION && pt.x >= rect.right) {
			OnHScroll(SB_THUMBPOSITION, m_ptScroll.x + (pt.x - rect.right) / GetAvgCharWidth() + 1, 0);
			bProcessed = true;
		}
		if(bProcessed) {
			if(nIDEvent != ID_TIMER_EXPANDLINESELECTION)
				SetSel(*m_pAnchorPoint, CharFromPos(pt, !m_ModeState.bCaretMarkByMouse));
			else
				SetSel(*m_pAnchorPoint, CCharPos(CharFromPos(pt, !m_ModeState.bCaretMarkByMouse).m_iLine, -1));
		}
	} else if(nIDEvent == ID_TIMER_DRAGSCROLL) {	// hbO̎XN[
		POINT	pt;
		RECT	rect;

		::GetCursorPos(&pt);
		ScreenToClient(&pt);
		GetClientRect(&rect);

		if(pt.y >= rect.top && pt.y <= rect.top + static_cast<long>(m_layoutInfo.nTopMargin))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y >= rect.bottom - static_cast<long>(m_layoutInfo.nLineHeight) && pt.y <= rect.bottom)
			OnVScroll(SB_LINEDOWN, 0, 0);
		else if(pt.x >= rect.left && pt.x <= static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))
			OnHScroll(SB_THUMBPOSITION, m_ptScroll.x - 3, 0);
		else if(pt.x >= rect.right - static_cast<long>(GetAvgCharWidth()) && pt.y <= rect.right)
			OnHScroll(SB_THUMBPOSITION, m_ptScroll.x + 3, 0);
	} else if(nIDEvent == ID_TIMER_LINEPARSE) {	// ͂̍sǂ݂
		// ...
	}
}

/**
 *	@brief	hLgɑ΂ĕҏWsƌĂяo
 *
 *	̃\bh̑1͏GȃZ}eBNXB
 *	܂ MFC ̎dlƂ͈قȂ Manah::CDocument::UpdateAllViews
 *	͑𒼐ڍsr[ɑ΂Ă CView::OnUpdate ĂяoB
 *	1ڑsIuWFNg\̂ MFC ƓA
 *	̃IuWFNg̓r[łȂĂ悭Ar[̐݌v҂ <var>pSender</var>
 *	̈ӖRɌ߂悤ɂĂB
 *
 *	Ascension::CEditView ɂ <var>pSender</var> ƂȂ肤̂
 *	ȉ̂ꂩ̃NXhNX̃CX^Xł
 *	(<var>udi.usSummary</var>  US_OPERATION_DELETE AUS_OPERATION_INSERT
 *	̏ꍇ)B pSender ł邩ɂÃ\bh͊U镑ςB
 *	ȉ͂̏ڍׂł:
 *
 *	<dl>
 *		<dt>CEditPoint</dt>
 *		<dd>Ascension GfB^̑唼̑ (I͈͂폜ƂsƂ)
 *			͂̃IuWFNgʂčs (m_pActivePoint ĝŎۂ
 *			CVisibleEditPoint ̃CX^Xł)B<var>pSender</var> 
 *			CEditPoint ̏ꍇAIuWFNg m_pActivePoint
 *			ȊÕ[U쐬Cӂ̕ҏW_ł邩ɂ苓͍XɕωB
 *			ANeBu|Cg̏ꍇA<strong>ɃLbg͓K؂ȈʒuɈړĂƂ݂Ȃ</strong>A
 *			̑̕ҏW_̓AҏWɓĂ̂ɒʒms (CEditPoint::OnUpdateDocument)B
 *			<var>pSender</var> [U̕ҏW_łꍇ͏L̑ɉA
 *			m_pActivePoint  m_pAnchorPoint ɑ΂ĂʒmsB CEditPoint::EnsureVisible
 *			ĂяoɂLbg̉͍s<strong>Ȃ</strong>
 *		</dd>
 *		<dt>CEditDoc</dt>
 *		<dd>_ł̓AhD/hDsꍇ̂ <var>pSender</var> 
 *			CEditDoc CX^XɂȂB̏ꍇAe󂯂SĂ̕ҏW_ɒʒmsA
 *			tH[JXĂr[̃LbgK؂ȏꏊɈړ</dd>
 *		<dt>CEditView</dt>
 *		<dd><var>pSender</var>  CEditView ̃CX^XɂȂ̂
 *			CEditView ̃\bhɂҏWsꍇ݂̂łB
 *			̏ꍇ̋ CEditDoc Ɠł
 *		</dd>
 *	</dl>
 *
 *	݂̐݌vł <var>pSender</var> hLg̊O猈肳̂ CEditDoc::DeleteText A
 *	CEditDoc::InsertText \bhĂяoꍇłB̃\bhĂяoɎgꂽ1̂܂
 *	̃\bh̑1ƂȂBhLgύX鏈ꍇ͈ȏ̃Z}eBNXɓKĂȂ΂ȂȂB
 *	ȂȀꍇ̃\bh͍XV񂩂烌CAEgXVB
 *
 *	̃\bh CEditDoc Ăяo邱ƂOƂĂA3͏
 *	CEditDoc ւ̃|C^ɂȂB
 *
 *	@param pSender	𒼐ڍsIuWFNg
 *	@param lParam	gpȂ
 *	@param pHint	hLgւ̃|C^
 *	@see			CView::OnUpdate
 */
void CEditView::OnUpdate(CObject* pSender, LPARAM lParam, void* pHint) {
	HWND	hwndActive = ::GetFocus();	// tH[JXEBhE
										// ̑ŃLbg𓮂Ȃ΂ȂȂꍇA
										// Lbg𓮂̂͑sr[ł͂ȂA
										// ̎_ŃtH[JXr[ł

	// CEditDoc::InsertText  CEditDoc::DeleteText 
	// pHint ɃhLgւ̃|C^nĂ
	// pView ̓hLgXVr[ł邪ɎgpȂ
	// (MFC ̎dlƂ͈قȂ this == pSender ̏ꍇł\bh͌Ăяo; Manah)
	if(reinterpret_cast<CEditDoc*>(pHint) == GetDocument()) {
		TUpdateInfo		udi;
		unsigned long	cModifiedLines = 0;

		reinterpret_cast<CEditDoc*>(pHint)->GetModification(udi);

		if(udi.usSummary == US_OPERATION_INSERT) {	// } (udi.posBegin == udi.posEnd)
			if(udi.posEnd.m_iLine == udi.posResult.m_iLine) {	// s܂܂ĂȂ
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINECOMMENT)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				if(m_pEventListener != 0 && cModifiedLines != 0)
					m_pEventListener->OnChangeLines(udi.posEnd.m_iLine, cModifiedLines);
			} else {	// s
				m_pLineLayoutManager->InsertLines(udi.posEnd.m_iLine + 1, udi.posResult.m_iLine);
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINECOMMENT)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				if(m_pEventListener != 0) {
					if(cModifiedLines != 0)
						m_pEventListener->OnChangeLines(udi.posEnd.m_iLine, cModifiedLines);
					m_pEventListener->OnCreateLines(
						udi.posEnd.m_iLine + 1, udi.posResult.m_iLine - udi.posEnd.m_iLine);
				}
				if(m_bFreezed) {	// ̕`҂s炷
					set<unsigned long>::iterator	it;
					for(it = m_setInvalidLines.begin(); it != m_setInvalidLines.end(); ++it) {
						if(*it >= udi.posEnd.m_iLine)
							*it += udi.posResult.m_iLine - udi.posEnd.m_iLine;
					}
				}
				cModifiedLines = GetVisibleLineCount() - (udi.posBegin.m_iLine - m_ptScroll.y) + 1;
			}
		} else if(udi.usSummary == US_OPERATION_DELETE) {	// 폜
			if(udi.posBegin.m_iLine == udi.posEnd.m_iLine) {	// s܂܂ĂȂ
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINECOMMENT)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				if(m_pEventListener != 0 && cModifiedLines != 0)
					m_pEventListener->OnChangeLines(udi.posEnd.m_iLine, cModifiedLines);
			} else {	// s
				m_pLineLayoutManager->DeleteLines(udi.posBegin.m_iLine + 1, udi.posEnd.m_iLine);
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posBegin.m_iLine) >= LPL_MULTILINECOMMENT)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posBegin.m_iLine);
				if(m_pEventListener != 0) {
					if(cModifiedLines != 0)
						m_pEventListener->OnChangeLines(udi.posBegin.m_iLine, cModifiedLines);
					m_pEventListener->OnDeleteLines(
						udi.posBegin.m_iLine + 1, udi.posEnd.m_iLine - udi.posBegin.m_iLine);
				}
				if(m_bFreezed) {	// ̕`҂s炷
					set<unsigned long>::iterator	it = m_setInvalidLines.begin();
					while(it != m_setInvalidLines.end()) {
						if(*it > udi.posBegin.m_iLine && *it <= udi.posEnd.m_iLine)
							it = m_setInvalidLines.erase(it);
						else {
							if(*it >= udi.posEnd.m_iLine)
								*it -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
							++it;
						}
					}
				}
			/*	if(m_hWnd == hwndActive && !m_bFreezed) {
					m_pAnchorPoint->MoveToPoint(udi.posResult);
					m_pActivePoint->MoveToPoint(udi.posResult);
					OnMoveCaret();
				}*/
				cModifiedLines = GetVisibleLineCount() - (udi.posBegin.m_iLine - m_ptScroll.y) + 1;
			}
		} else if(udi.usSummary == US_SAVEDOCUMENT) {	// hLg̕ۑ
			InvalidateRect(0, false);
			return;
		} else if(udi.usSummary == US_BEGIN_UNDOGROUP) {
			Freeze();
			return;
		} else if(udi.usSummary == US_END_UNDOGROUP) {
			if(hwndActive == m_hWnd)
				SetSelWithoutSelection(udi.posResult, false, false);
			else {
				m_pAnchorPoint->MoveToPoint(udi.posResult);
				m_pActivePoint->MoveToPoint(udi.posResult);
			}
			ModifyScrollInfo(true, true);
			Unfreeze();
			OnMoveCaret();
			if(hwndActive == m_hWnd)
				m_pActivePoint->EnsureVisible();
			return;
		} else
			assert(false);

		// XN[ʒȕC
		if(!m_bFreezed)
			ModifyScrollInfo(true, true);
		if(udi.posBegin.m_iLine < m_iFirstVisibleLine)	// 擪s̍XV
			m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;

		// ҏW̉e󂯂ҏW_̏
		for(set<CEditPoint*>::iterator it = m_setEditPoints.begin(); it != m_setEditPoints.end(); ++it) {
			if((*it)->IsSynchronousWithOtherEdit())
				(*it)->OnUpdateDocument(udi);
		}
		if(pSender != m_pActivePoint) {
			m_pAnchorPoint->OnUpdateDocument(udi);
			m_pActivePoint->OnUpdateDocument(udi);
			if(hwndActive == m_hWnd
					&& !m_bFreezed
					&& (pSender == this
					|| pSender == m_pOriginalView
				/*	|| m_setClones.find(reinterpret_cast<CEditView*>(pSender)) != m_setClones.end()*/))
				SetSelWithoutSelection(udi.posResult, true, false);	// ̃\bḧvZ
		}
		RecalcLeftTabWidth();
		InvalidateLines(udi.posBegin.m_iLine, udi.posBegin.m_iLine + cModifiedLines - 1);
	} else {	// !ɗ邱Ƃ͖!
		assert(false);
		m_pLineLayoutManager->ReconstructAll();
//		if(m_pEventListener != 0)
//			m_pEventListener->OnChangeLines(...);	// Q
		RecalcLeftTabWidth();
		InvalidateRect(0, false);	// Ƃ肠S
		ModifyScrollInfo(true, true);
	}

	if(m_hWnd == hwndActive
			&& !m_bFreezed
			&& m_pEventListener != 0
			&& m_pKeyMacroPlayer->GetState() != KMS_PLAYING) {
		ValidateCaretPos();
		m_pEventListener->OnMoveCaret(*m_pActivePoint);
	}
}

///	@see	CWindow::OnVScroll
void CEditView::OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	int	nOrgPos = m_ptScroll.y;	// ̈ʒuۑ
	int	nMinPos, nMaxPos;		// őAŏʒu
	int	cVisibleLines = GetVisibleLineCount();
	
	GetScrollRange(SB_VERT, &nMinPos, &nMaxPos);

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(cVisibleLines >= (nMaxPos - nMinPos) * static_cast<int>(m_layoutInfo.nVScrollRatio)) {
		m_ptScroll.y = 0;
//		DrawLeftTab(0, GetVisibleLineCount());
		return;
	}

	switch(nSBCode) {
	case SB_LINEUP:			// 1s
		--m_ptScroll.y;	break;
	case SB_LINEDOWN:		// 1s
		++m_ptScroll.y;	break;
	case SB_PAGEUP:			// 1y[W
		m_ptScroll.y -= GetVisibleLineCount() - 1;	break;
	case SB_PAGEDOWN:		// 1y[W
		m_ptScroll.y += GetVisibleLineCount() - 1;	break;
	case SB_TOP:			// [
		m_ptScroll.y = nMinPos;	break;
	case SB_BOTTOM:			// [
		m_ptScroll.y = nMaxPos;	break;
	case SB_THUMBTRACK:		// hbO or zC[
		m_ptScroll.y = GetScrollTrackPos(SB_VERT);	break;
	case SB_THUMBPOSITION:	// ???
		m_ptScroll.y = nPos;
	}

	// 
	if(m_ptScroll.y < nMinPos)
		m_ptScroll.y = nMinPos;
	else if(m_ptScroll.y > static_cast<long>(nMaxPos - GetVisibleLineCount() + 1))
		m_ptScroll.y = nMaxPos - GetVisibleLineCount() + 1;
	if(m_ptScroll.y == nOrgPos)	// XN[Ȃ
		return;

	// 擪s̍XV
//	if(m_ptScroll.y - nOrgPos == 1)

	// ĕ`Ȃ
	if(dif<long>(m_ptScroll.y, nOrgPos) < cVisibleLines - 1) {	// XN[ʂ1y[Wȉ
		RECT	rectScroll;			// XN[Ώ
		int		dy = (nOrgPos - m_ptScroll.y) * m_layoutInfo.nVScrollRatio * m_layoutInfo.nLineHeight;
		RECT	rectUpdate;

		GetClientRect(&rectScroll);
		rectUpdate = rectScroll;
		rectScroll.top = m_layoutInfo.nTopMargin;
		if(dy > 0) {
			rectUpdate.top += m_layoutInfo.nTopMargin;
			rectUpdate.bottom = rectUpdate.top + dy;
		} else
			rectUpdate.top = rectUpdate.bottom + dy;
		ScrollWindowEx(0, dy, &rectScroll, &rectScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rectUpdate, false);
	} else
		InvalidateRect(0, false);

	SetScrollPos(SB_VERT, m_ptScroll.y);
	ValidateCaretPos();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
	UpdateWindow();

	if(m_pwndAutoComplete->IsWindow())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/* [EOF] */
