// EditPoint.h
// (c) 2003-2004 exeal

#ifndef _EDIT_POINT_H_
#define _EDIT_POINT_H_
#include "EditDoc.h"


#define VERIFY_VIEW()	\
	if(!IsAvailable())	\
		throw EViewIsAlreadyInavailable();


namespace Ascension {

class CCharPos;
class CEditDoc;
class CEditView;


///	͈͂̃eLXgϊ`
enum RangeConvertType {
	///	啶ɕϊ (P)
	RCT_UPPERCASE_SIMPLE,
	///	ɕϊ (P)
	RCT_LOWERCASE_SIMPLE,
	///	Ls^CY (P)
	RCT_CAPITALIZE_SIMPLE,
	///	啶ɕϊ (S)
	RCT_UPPERCASE_FULL,
	///	ɕϊ (S)
	RCT_LOWERCASE_FULL,
	///	Ls^CY (S)
	RCT_CAPITALIZE_FULL,
	///	ɕϊ
	RCT_HIRAGANA,
	///	Љɕϊ
	RCT_KATAKANA,
	///	ȑ̎ɕϊ
	RCT_SIMPLIFIED_CHINESE,
	///	ɑ̎ɕϊ
	RCT_TRADITIONAL_CHINESE,
	///	Spɕϊ
	RCT_FULLWIDTH,
	///	pɕϊ
	RCT_HALFWIDTH,
	///	󔒕^uɕϊ
	RCT_TABIFY,
	///	^u󔒕ɕϊ
	RCT_UNTABIFY,
	///	ArAɕϊ
	RCT_ARABICDIGIT,
	///	ꏊƂȂ폜
	RCT_REMOVE_NONSPACE,
	///	ArÃJV_폜
	RCT_REMOVE_ARABICKASHIDA,
	///	Ɍ
	RCT_COMPOSE,
	///	𕪉
	RCT_DECOMPOSE,
};


///	 CEditDoc ɖ CEditPoint IuWFNgLłȂƂ\O
class EViewIsAlreadyInavailable {
public:
	///	Ԃ
	std::wstring	GetDescription() const {
		return L"Target document is already inavailable. This object is no longer able to be used anyway.";
	}
};


/*
 *	.:߂:.
 *	CEditPoint NX CCharPos ɎĂ邪 CCharPos
 *	̔hNXɂȂƂɂB݈͌ʒu\ CCharPos
 *	2̃f[^oJĂ邩łB
 *	CCharPos ̃f[^oJɂĂ悢ACCharPos
 *	͌XPɈʒu\֐̗ǂf[^ɉ߂Ȃ̂ŁA
 *	CEditPoint Ƃ͈قȂZ}eBNXB
 *	ĉZqȂǂ͖ʓ|Vɒ`ȂB
 *	̃NX CCharPos ւ̈Öق̕ϊZqB
 */

/**
 *	@brief	GfB^ŕҏWAړ\ȁu_vB^Lbg
 *
 *	CEditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
 *	CEditView ̑Ǝ@ŕҏWs
 *
 *	̃IuWFNg̕\_͑̕ҏWŕύX悤ɂ邱ƂA
 *	ύXȂ悤ɂ邱ƂoB̏ꍇłʒu
 *	(ႦΑ݂Ȃ񂩂ŏIցA폜ꂽsŏIs) ւ̈ړ͋N
 *
 *	ҏW_ɂhLg̕ύXsƁAAҏW_͓K؂ȈʒuɈړB
 *	Ⴆ n ̕}ƌ݈ʒu n i߂
 *
 *	CEditPoint ɂhLg̃Z}eBNXɂĂ
 *	CEditView::OnUpdate ̉
 *
 *	CEditPoint RXgN^͔JłBCX^X̍쐬ɂ
 *	CEditView::CreateEditPoint \bhg
 *
 *	SẴ\bh̓hLg̃AhDO[v
 *	\bhĂяos<strong>Ȃ</strong>
 *
 *	̃NX̂قƂǂ̃\bh͑Ώۃr[ɑ݂Ȃꍇ
 *	EViewIsAlreadyInavailable X[
 *
 *	@see	CEditView, CEditDoc
 */
class CEditPoint : public Manah::CObject {
	friend class CEditView;
	friend bool operator ==(const CCharPos&, const CEditPoint&);
	friend bool operator !=(const CCharPos&, const CEditPoint&);
	friend bool operator <(const CCharPos&, const CEditPoint&);
	friend bool operator <=(const CCharPos&, const CEditPoint&);
	friend bool operator >(const CCharPos&, const CEditPoint&);
	friend bool operator >=(const CCharPos&, const CEditPoint&);

	// RXgN^
protected:
	CEditPoint(CEditView* pView);
private:
	CEditPoint(const CEditPoint& rhs);
public:
	virtual ~CEditPoint();

	// Zq
public:
	CEditPoint& operator =(const CCharPos& rhs);
				operator CCharPos() const;
	bool	operator ==(const CCharPos& rhs) const;
	bool	operator ==(const CEditPoint& rhs) const;
	bool	operator !=(const CCharPos& rhs) const;
	bool	operator !=(const CEditPoint& rhs) const;
	bool	operator <(const CCharPos& rhs) const;
	bool	operator <(const CEditPoint& rhs) const;
	bool	operator <=(const CCharPos& rhs) const;
	bool	operator <=(const CEditPoint& rhs) const;
	bool	operator >(const CCharPos& rhs) const;
	bool	operator >(const CEditPoint& rhs) const;
	bool	operator >=(const CCharPos& rhs) const;
	bool	operator >=(const CEditPoint& rhs) const;
private:
	operator =(const CEditPoint& rhs);

	// \bh
public:
	/*  */
	unsigned long	GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetCharNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetColumnNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineLength() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineNumber() const throw(EViewIsAlreadyInavailable);
	wstring			GetText(long nChars) const throw(EViewIsAlreadyInavailable);
	wstring			GetText(const CCharPos& pos) const throw(EViewIsAlreadyInavailable);
	CEditView*		GetView() const;
	bool			IsEndOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsEndOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsStartOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsStartOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsAvailable() const;
	bool			IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable);
	void			SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable);

	/*  */
	CEditPoint*	Clone() const throw(EViewIsAlreadyInavailable);

	/*  (ړ) */
	void		CharNext(unsigned long cch = 1) throw(EViewIsAlreadyInavailable);
	void		CharPrev(unsigned long cch = 1) throw(EViewIsAlreadyInavailable);
	void		EnsureCentered() throw(EViewIsAlreadyInavailable);
	void		EnsureVisible() throw(EViewIsAlreadyInavailable);
	void		LineDown(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		LineUp(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		MoveToAbsoluteCharOffset(unsigned long nOffset) throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfLine() throw(EViewIsAlreadyInavailable);
	void		MoveToNextBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		MoveToPrevBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfLine(bool bToFirstText) throw(EViewIsAlreadyInavailable);
	void		PageDown(unsigned long cPages = 1) throw(EViewIsAlreadyInavailable);
	void		PageUp(unsigned long cPages = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);

	/*  (ҏW) */
	void		Convert(long cChars, RangeConvertType rct) throw(EViewIsAlreadyInavailable);
	void		Convert(const CCharPos& pos, RangeConvertType rct) throw(EViewIsAlreadyInavailable);
	void		Copy(long cChars) throw(EViewIsAlreadyInavailable);
	void		Copy(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		Cut(long cChars) throw(EViewIsAlreadyInavailable);
	void		Cut(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		Delete(long cChars = 1) throw(EViewIsAlreadyInavailable);
	void		Delete(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		DestructiveInsert(const wstring& strText) throw(EViewIsAlreadyInavailable);
	void		Insert(const wstring& strText) throw(EViewIsAlreadyInavailable);
	void		InsertBox(const wstring& strText) throw(EViewIsAlreadyInavailable);
	void		NewLine() throw(EViewIsAlreadyInavailable);
	void		Paste(long cChars = 0) throw(EViewIsAlreadyInavailable);
	void		Paste(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	CCharPos	SpaceIndent(const CCharPos& pos, long nLevel = 1) throw(EViewIsAlreadyInavailable);
	CCharPos	TabIndent(const CCharPos& pos, long nLevel = 1) throw(EViewIsAlreadyInavailable);
protected:
	CCharPos	Indent(const CCharPos& pos, wchar_t chIndent, long nLevel) throw(EViewIsAlreadyInavailable);

protected:
	virtual void	OnUpdateDocument(const TUpdateInfo& udi);
	virtual void	OnViewDestroyed();

protected:
	void	Normalize() const;
	void	UpdateLastCx();

	// f[^o
protected:
	unsigned long	m_iLine;				// sԍ
	unsigned long	m_iChar;				// ԍ
	CEditView*		m_pView;				// r[
	bool			m_bSyncWithOtherEdit;	// ̕ҏWł̓_ړ邩
	bool			m_bOwnedByView;			// r[̊ǗXgɓ邩 (j󎞂 CEditView::ReleaseEditPoint ĂԂ)
	unsigned long	m_cxLast;				// r[̐Ό_̋ (x W)
											// LineDown ALineUp ňړƂɕێ
};


/**
 *	CEditView ̃AJ[|CgAANeBu|Cg\B
 *	CEditView ȊÕNCAg̓CX^X̍쐬͕s
 */
class CVisibleEditPoint : public CEditPoint {
	friend class CEditView;

	// RXgN^
private:
	CVisibleEditPoint(CEditView* pView);
	CVisibleEditPoint(const CVisibleEditPoint& rhs);
public:
	virtual ~CVisibleEditPoint();

	// Zq
public:
						operator CCharPos() const;
	CVisibleEditPoint&	operator =(const CCharPos& rhs);
private:
	operator =(const CVisibleEditPoint& rhs);

	// I[o[Ch\bh
protected:
	virtual void	OnUpdateDocument(const TUpdateInfo& udi);
private:
	CEditPoint*		Clone() const throw(EViewIsAlreadyInavailable);
};


// Global operators
/////////////////////////////////////////////////////////////////////////////

inline bool operator ==(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine == rhs.m_iLine && lhs.m_iChar == rhs.m_iChar;
}

inline bool operator !=(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine != rhs.m_iLine || lhs.m_iChar != rhs.m_iChar;
}

inline bool operator <(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine < rhs.m_iLine
		|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar < rhs.m_iChar);
}

inline bool operator <=(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine < rhs.m_iLine
		|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar <= rhs.m_iChar);
}

inline bool operator >(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine > rhs.m_iLine
		|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar > rhs.m_iChar);
}

inline bool operator >=(const CCharPos& lhs, const CEditPoint& rhs) {
	return lhs.m_iLine > rhs.m_iLine
		|| (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar >= rhs.m_iChar);
}


// CEditPoint class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	Zq
inline CEditPoint& CEditPoint::operator =(const CCharPos& rhs) {
	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	return *this;
}

///	CCharPos ւ̕ϊZq
inline CEditPoint::operator CCharPos() const {
	return CCharPos(m_iLine, m_iChar);
}

///	Zq
inline bool CEditPoint::operator ==(const CCharPos& rhs) const {
	return m_iLine == rhs.m_iLine && m_iChar == rhs.m_iChar;
}

///	Zq
inline bool CEditPoint::operator ==(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine == rhs.m_iLine && m_iChar == rhs.m_iChar;
}

///	񓙉Zq
inline bool CEditPoint::operator !=(const CCharPos& rhs) const {
	return m_iLine != rhs.m_iLine || m_iChar != rhs.m_iChar;
}

///	񓙉Zq
inline bool CEditPoint::operator !=(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine != rhs.m_iLine || m_iChar != rhs.m_iChar;
}

///	菬
inline bool CEditPoint::operator <(const CCharPos& rhs) const {
	return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar < rhs.m_iChar);
}

///	菬
inline bool CEditPoint::operator <(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar < rhs.m_iChar);
}

///	ȉ
inline bool CEditPoint::operator <=(const CCharPos& rhs) const {
	return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar <= rhs.m_iChar);
}

///	ȉ
inline bool CEditPoint::operator <=(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar <= rhs.m_iChar);
}

///	傫
inline bool CEditPoint::operator >(const CCharPos& rhs) const {
	return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar > rhs.m_iChar);
}

///	傫
inline bool CEditPoint::operator >(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar > rhs.m_iChar);
}

///	ȏ
inline bool CEditPoint::operator >=(const CCharPos& rhs) const {
	return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar >= rhs.m_iChar);
}

///	ȏ
inline bool CEditPoint::operator >=(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar >= rhs.m_iChar);
}

///	Ώۃr[Ԃ
inline CEditView* CEditPoint::GetView() const {
	AssertValid();
	return m_pView;
}

///	Ώۃr[Ă true Ԃ
inline bool CEditPoint::IsAvailable() const {
	AssertValid();
	return m_pView != 0;
}

///	̕ҏWł̓_ړ邩ǂԂ
inline bool CEditPoint::IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_bSyncWithOtherEdit;
}

///	r[j󂳂ꂽƂɌĂяo
inline void CEditPoint::OnViewDestroyed() {
	AssertValid();
	m_pView = 0;
}

/**
 *	̕ҏWɓ
 *	@param bSync	true: Bfalse: 񓯊
 */
inline void CEditPoint::SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	m_bSyncWithOtherEdit = bSync;
}


} /* namespace Ascension */

#endif /* _EDIT_POINT_H_ */

/* [EOF] */