// EditPoint.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditPoint.h"
#include "EditView.h"
#include "..\..\Manah\win_utils.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


// CEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pView	Ώۂ̃r[
 */
CEditPoint::CEditPoint(CEditView* pView)
		: m_iLine(0), m_iChar(0), m_pView(pView),
		m_bSyncWithOtherEdit(false), m_bOwnedByView(false), m_cxLast(0) {
	assert(m_pView != 0);
}

///	fXgN^
CEditPoint::~CEditPoint() {
	if(m_pView != 0 && m_bOwnedByView)
		m_pView->ReleaseEditPoint(*this);
}

/**
 *	̕Ɉړ
 *	@param nOffset	ړ邩
 */
void CEditPoint::CharNext(unsigned long nOffset /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();
	wstring			strLine = m_pView->GetDocument()->GetLine(m_iLine);
	const wchar_t*	pwszLine = strLine.c_str();

	Normalize();
	while(nOffset-- > 0) {
		if(m_iChar == strLine.length()) {	// sȂ̂Ŏ̍sɈړ
			if(m_iLine == cLines - 1)	// ŏIsłΈړȂ
				return;
			strLine = m_pView->GetDocument()->GetLine(++m_iLine);
			pwszLine = strLine.c_str();
			m_iChar = 0;
		} else
			// Lbg󂯎Ȃ΂
			m_iChar += CEditView::MakeCaretPosValid(pwszLine, strLine.length(), ++m_iChar, false);
	}
	UpdateLastCx();
}

/**
 *	O̕Ɉړ
 *	@param nOffset	ړ邩
 */
void CEditPoint::CharPrev(unsigned long nOffset /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	wstring			strLine = m_pView->GetDocument()->GetLine(m_iLine);
	const wchar_t*	pwszLine = strLine.c_str();

	Normalize();
	while(nOffset-- > 0) {
		if(m_iChar == 0) {	// sȂ̂őO̍sɈړ
			if(m_iLine == 0)	// 擪słΈړȂ
				return;
			strLine = m_pView->GetDocument()->GetLine(--m_iLine);
			pwszLine = strLine.c_str();
			m_iChar = strLine.length();
		} else
			// Lbg󂯎Ȃ΂
			m_iChar += CEditView::MakeCaretPosValid(pwszLine, strLine.length(), --m_iChar, true);
	}
	UpdateLastCx();
}

///	ʒu\IuWFNgԂB߂l͌Ăяoō폜
CEditPoint* CEditPoint::Clone() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditPoint*	pClone = new CEditPoint(m_pView);
	pClone->m_iLine = m_iLine;
	pClone->m_iChar = m_iChar;
	if(m_bOwnedByView)
		m_pView->m_setEditPoints.insert(pClone);
	return pClone;
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 *	@param rct		ϊ̎
 */
void CEditPoint::Convert(long cChars, RangeConvertType rct) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;

	CEditPoint	pt(m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cChars > 0)
		pt.CharNext(cChars);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cChars++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Convert(pt, rct);
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param pos	1̈ʒu
 *	@param rct	ϊ̎ށBw͕s
 */
void CEditPoint::Convert(const CCharPos& pos, RangeConvertType rct) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || *this == pos)
		return;

//	if(rct == RCT)
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param cChars	Rs[镶 (ł悢)
 */
void CEditPoint::Copy(long cChars) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(cChars).c_str());
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Copy(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(pos).c_str());
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param cChars	폜镶 (ł悢)
 */
void CEditPoint::Cut(long cChars) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(cChars).c_str());
	Delete(cChars);
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Cut(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(pos).c_str());
	Delete(pos);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Delete(long cChars /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || cChars == 0)
		return;

	CEditPoint	pt(m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cChars > 0)
		pt.CharNext(cChars);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cChars++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Delete(pt);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param pos	1̈ʒu
 */
void CEditPoint::Delete(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	if(pos == *this)
		return;
	*this = m_pView->GetDocument()->DeleteText(this, *this, pos);
	UpdateLastCx();
}

///	_̍sr[̒ɗ悤ɃXN[
void CEditPoint::EnsureCentered() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CCharPos		posDisplay = m_pView->DisplayCharFromLogicalChar(*this);
	const unsigned int	cVisibleLines = m_pView->GetVisibleLineCount();

	m_pView->OnHScroll(SB_THUMBPOSITION, 0, 0);
	m_pView->OnVScroll(SB_THUMBPOSITION, posDisplay.m_iLine - cVisibleLines / 2, 0);
}

///	_ɂȂ悤Ƀr[XN[
void CEditPoint::EnsureVisible() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CCharPos		posDisplay = m_pView->DisplayCharFromLogicalChar(*this);
	const unsigned int	cVisibleLines = m_pView->GetVisibleLineCount();
	const unsigned int	cVisibleChars = m_pView->GetVisibleCharCount();

	if(posDisplay.m_iLine <
			m_pView->m_ptScroll.y * m_pView->m_layoutInfo.nVScrollRatio)	// ʂ
		m_pView->OnVScroll(SB_THUMBPOSITION, posDisplay.m_iLine, 0);
	else if(posDisplay.m_iLine -
			m_pView->m_ptScroll.y *
			m_pView->m_layoutInfo.nVScrollRatio > cVisibleLines - 1)	// ʂ艺
		m_pView->OnVScroll(SB_THUMBPOSITION, posDisplay.m_iLine - cVisibleLines + 1, 0);
	if(m_pView->m_ModeState.wpmWrapMode == WPM_NONE) {
		const unsigned long	nScrollOffset =
			m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth();
		const unsigned long	cx =
			m_pView->PosFromChar(*this).x + nScrollOffset - m_pView->m_layoutInfo.nLeftTabWidth + 1;
		if(cx <= nScrollOffset)	// ʂ荶
			m_pView->OnHScroll(SB_THUMBPOSITION,
				cx / m_pView->GetAvgCharWidth() - cVisibleChars / 4, 0);
		else if(cx > (m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio
				+ cVisibleChars) * m_pView->GetAvgCharWidth())	// ʂE
			m_pView->OnHScroll(SB_THUMBPOSITION,
				cx / m_pView->GetAvgCharWidth() - cVisibleChars * 3 / 4, 0);
	} else {
		// ...
	}
}

///	hLg̐擪̕Ԃ
unsigned long CEditPoint::GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	nOffset = 0;
	LineIterator	itLines = m_pView->GetDocument()->GetLineIterator(0);

	Normalize();
	for(unsigned long iLine = 0; ; ++iLine, ++itLines) {
		if(iLine == m_iLine) {
			nOffset += m_iChar;
			break;
		} else
			nOffset += itLines->GetLine().length() + 1;	// +1 ͉s
	}
	return nOffset;
}

///	ԍԂ
unsigned long CEditPoint::GetCharNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_iChar;
}

///	\̗ԍԂ
unsigned long CEditPoint::GetColumnNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_pView->ColumnFromChar(*this);
}

///	_s̒Ԃ
unsigned long CEditPoint::GetLineLength() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine);
}

///	sԍԂ
unsigned long CEditPoint::GetLineNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine;
}

/**
 *	͈͓̃eLXgԂ
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
wstring CEditPoint::GetText(long cChars) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	if(cChars == 0)
		return L"";

	const CEditDoc*	pDoc = m_pView->GetDocument();
	wostringstream	ssText;

	while(true) {
	}
}

/**
 *	͈͓̃eLXgԂ
 *	@param pos	1̈ʒu
 */
wstring CEditPoint::GetText(const CCharPos& pos) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	if(*this == pos)
		return L"";

	const CEditDoc*	pDoc = m_pView->GetDocument();
	const CCharPos&	posStart = std::min<CCharPos>(*this, pos);
	const CCharPos&	posEnd = std::max<CCharPos>(*this, pos);

	if(posStart.m_iLine == posEnd.m_iLine)	// 1s̏ꍇ
		return pDoc->GetLine(posEnd.m_iLine).substr(
			posStart.m_iChar, posEnd.m_iChar - posStart.m_iChar);
	else {	// s̏ꍇ
		wostringstream	ssText;
		unsigned long	iLine = posStart.m_iLine;
		LineIterator	itLines = pDoc->GetLineIterator(iLine);

		while(true) {
			if(iLine == posStart.m_iLine)	// 擪s
				ssText << itLines->GetLine().substr(posStart.m_iChar);
			else if(iLine == posEnd.m_iLine)	// ŏIs
				ssText << itLines->GetLine().substr(0, posEnd.m_iChar);
			else
				ssText << itLines->GetLine() << CEditDoc::GetBreakString(itLines->GetBreakType());
			++iLine;
			++itLines;
		}
		return ssText.str();
	}
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 *	@param ocf		쌋tO
 */
void CEditPoint::DestructiveInsert(const wstring& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();

	if(pDoc->IsReadOnly())
		return;

	CEditPoint	pos(m_pView);

	pos.m_iLine = m_iLine;
	pos.m_iChar = m_iChar;
	pos.CharNext();
	pDoc->EndEditCollection();
	pDoc->BeginEditCollection();
	pDoc->DeleteText(this, *this, pos);
	*this = pDoc->InsertText(this, *this, strText);
	pDoc->EndEditCollection();
	UpdateLastCx();
}

/**
 *	͈͓̃eLXgCfg
 *	@param pos		1̈ʒu
 *	@param chIndent	CfgɎg
 *	@param nLevel	Cfgx
 */
CCharPos CEditPoint::Indent(const CCharPos& pos, wchar_t chIndent, long nLevel) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return pos;

	CEditDoc*		pDocument = m_pView->GetDocument();
	const wstring	strIndent = wstring(abs(nLevel), chIndent);
	const CCharPos	posTop = m_pView->GetSelTopPoint();
	const CCharPos	posBottom = m_pView->GetSelBottomPoint();
	CCharPos		posOtherRes = pos;
	unsigned long	iLine = posTop.m_iLine;
	unsigned long	cchIndent;	// s̋󔒕

	if(iLine < posBottom.m_iLine && nLevel != 0) {
		if(nLevel > 0) {
			pDocument->InsertText(this, CCharPos(iLine, 0), strIndent);
			if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
				posOtherRes.m_iChar += nLevel;
			else if(iLine == m_iLine && m_iChar != 0)
				m_iChar += nLevel;
		} else {
			cchIndent = CEditView::IsWhiteSpace(
							pDocument->GetLine(iLine).c_str(),
							pDocument->GetLineLength(iLine));
			if(cchIndent > 0) {
				unsigned long	cchDelete = min<unsigned long>(-nLevel, cchIndent);
				pDocument->DeleteText(this, CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar -= cchDelete;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar -= cchDelete;
			}
		}
	} else {	// I1sȓ -> Pȕ}
		if(nLevel > 0)
			m_pView->ReplaceSel(strIndent);
		return *this;
	}

	// ÎSĂ̍s (t) Cfg
	if(nLevel > 0) {
		for(++iLine; iLine <= posBottom.m_iLine; ++iLine) {
			if(pDocument->GetLineLength(iLine) != 0 && (iLine != posBottom.m_iLine || posBottom.m_iChar > 0)) {
				pDocument->InsertText(this, CCharPos(iLine, 0), strIndent);
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar += nLevel;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar += nLevel;
			}
		}
	} else {
		for(++iLine; iLine <= posBottom.m_iLine; ++iLine) {
			cchIndent = CEditView::IsWhiteSpace(
							pDocument->GetLine(iLine).c_str(),
							pDocument->GetLineLength(iLine));
			if(cchIndent > 0) {
				unsigned long	cchDelete = min<unsigned long>(-nLevel, cchIndent);
				pDocument->DeleteText(this, CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar -= cchDelete;
				else if(iLine == m_iLine && m_iChar != 0)
					m_iChar -= cchDelete;
			}
		}
	}
	return posOtherRes;
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 */
void CEditPoint::Insert(const wstring& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	*this = m_pView->GetDocument()->InsertText(this, *this, strText);
	UpdateLastCx();
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 */
void CEditPoint::InsertBox(const wstring& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || strText.empty())
		return;

	CEditDoc*			pDocument = m_pView->GetDocument();
	const unsigned long	cLines = pDocument->GetLineCount();
	const wstring		pwszBreaks = CEditDoc::GetBreakString(pDocument->GetBreakType());
	list<size_t>		listLines;

	// sʒũXg
	size_t	iChar = 0, iLast = 0;
	while(true) {
		iChar = strText.find_first_of(CEditDoc::m_wszBreakChars, iLast);
		if(iChar == wstring::npos)
			break;
		iLast = iChar + ((iChar < strText.length() - 1
			&& strText[iChar] == L'\r' && strText[iChar == L'\n']) ? 2 : 1);
		listLines.push_back(iLast);
	}

	if(*listLines.begin() != 0)
		listLines.push_front(0);

	unsigned long	iLine = m_iLine;	// }s
	wstring			strLine;			// }sƂȂ镔
	unsigned long	xFirstLineInsert;	// }擪s̑}ʒu (r[ x W)
	for(list<size_t>::const_iterator it = listLines.begin(); it != listLines.end(); ++it) {
		if(it == listLines.begin())	// ŏ̍s
			xFirstLineInsert = m_pView->PosFromChar(*this).x - m_pView->m_layoutInfo.nLeftTabWidth;
		if(++it == listLines.end())	// ŏIs
			strLine = strText.substr(*(--it), wstring::npos);
		else {
			size_t	cchLine = *it - ((strText[*it - 1] == L'\n' && strText[*it - 2] == L'\r') ? 2 : 1);
			cchLine -= *(--it);
			strLine = strText.substr(*it, cchLine);
		}
		++it;
		if(iLine >= cLines - 1 && it != listLines.end())	// }ʒuɍs݂Ȃꍇ͍쐬
			strLine += pwszBreaks;
		--it;

		if(strLine.length() != 0) {
			strLine = m_pView->CalculateSpacesReachingVirtualPoint(iLine, xFirstLineInsert) + strLine;	// }ʒu̒
			*this = pDocument->InsertText(this, CCharPos(iLine,
				m_pView->CharFromPixel(iLine, xFirstLineInsert,
					!m_pView->m_ModeState.bCaretMarkByMouse)), strLine);
		}
		++iLine;
	}
}

///	݈ʒuhLg̏I[ł邩ǂԂ
bool CEditPoint::IsEndOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();

	Normalize();
	if(pDoc->GetLineCount() - 1 != m_iLine)
		return false;
	return pDoc->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsEndOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒuhLg̐擪ł邩ǂԂ
bool CEditPoint::IsStartOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine == 0 && m_iChar == 0;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsStartOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iChar == 0;
}

/**
 *	̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineDown(unsigned long cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = min(m_iLine + cLines, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	O̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineUp(unsigned long cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = (m_iLine > cLines) ? m_iLine - cLines : 0;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	hLg擪̕Ŏw肵ʒuɈړ
 *	@param nOffset	hLg擪̕
 */
void CEditPoint::MoveToAbsoluteCharOffset(unsigned long nOffset) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	unsigned long	cRead = 0;
	LineIterator	itLines = pDoc->GetLineIterator(0);
	unsigned long	cLines = pDoc->GetLineCount();

	for(unsigned long iLine = 0; iLine < cLines; ++iLine, ++itLines) {
		unsigned long	cchLine = itLines->GetLine().length() + 1;
		if(cRead + cchLine >= nOffset) {
			m_iLine = iLine;
			m_iChar = cRead + cchLine - nOffset;
			return;
		}
		cRead += cchLine;
	}
	m_iLine = cLines - 1;
	m_iChar = itLines->GetLine().length();
	UpdateLastCx();
}

///	hLg̏I[Ɉړ
void CEditPoint::MoveToEndOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	m_iLine = pDoc->GetLineCount() - 1;
	m_iChar = pDoc->GetLineLength(pDoc->GetLineCount() - 1);
	UpdateLastCx();
}

///	sɈړ
void CEditPoint::MoveToEndOfLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = m_pView->GetDocument()->GetLineLength(m_iLine);
	UpdateLastCx();
}

///	̃ubN}[Ns̍sɈړ
void CEditPoint::MoveToNextBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	iLine;
	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();

	// T
	for(iLine = m_iLine + 1; iLine < cLines; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = 0; iLine < m_iLine; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}
}

/**
 *	wʒuɈړ
 *	@param pos	ړ
 */
void CEditPoint::MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = pos.m_iLine;
	m_iChar = pos.m_iChar;
	Normalize();
	UpdateLastCx();
}

///	ÕubN}[Ns̍sɈړ
void CEditPoint::MoveToPrevBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	iLine = m_iLine - 1;

	// T
	while(true) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
			UpdateLastCx();
		}
		if(--iLine == 0)
			break;
	}

	// Ȃΐ܂Ԃ
	CEditDoc*	pDoc = m_pView->GetDocument();
	for(iLine = pDoc->GetLineCount() - 1; iLine > m_iLine; --iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			UpdateLastCx();
			return;
		}
	}
}

///	hLg̐擪Ɉړ
void CEditPoint::MoveToStartOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = m_iChar = 0;
	UpdateLastCx();
}

/**
 *	sɈړ
 *	@param bToFirstText	true: 󔒕łȂŏ̕ɈړAfalse: 0ڂɈړB
 *			݈ʒu󔒂Ŗŏ̕ł΁A0ڂɈړ
 */
void CEditPoint::MoveToStartOfLine(bool bToFirstText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDocument = m_pView->GetDocument();

	m_iLine = std::min(m_iLine, pDocument->GetLineCount() - 1);
	if(!bToFirstText)
		m_iChar = 0;
	else {
		const wstring&	strLine = pDocument->GetLine(m_iLine);
		unsigned long	iFirstText = CEditView::IsWhiteSpace(strLine.c_str(), strLine.length());
		m_iChar = (m_iChar != iFirstText) ? iFirstText : 0;
	}
	UpdateLastCx();
}

///	sBݒɂăX}[gCfgAubNCfgs
void CEditPoint::NewLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();
	wstring		strBreak = CEditDoc::GetBreakString(pDoc->GetBreakType());
	bool		bDoneSmartIndent = false;	// X}[gCfg

	if(pDoc->IsReadOnly())
		return;
//	if(m_ModeState.aitAutoIndentType == AIT_SMART)
//		bDoneSmartIndent = SmartIndent(L'\n');
	if(!bDoneSmartIndent
			&& m_pView->m_ModeState.aitAutoIndentType == AIT_BLOCK) {	// I[gCfg
		const wstring&	strCurrentLine = pDoc->GetLine(m_iLine);
		unsigned long	cch = CEditView::IsWhiteSpace(strCurrentLine.c_str(), strCurrentLine.length());
		strBreak += strCurrentLine.substr(0, cch);
	}
	if(!bDoneSmartIndent)
		Insert(strBreak);
}

///	ʒuɈړ (const \bh悭Ăяô const ɂĂ)
void CEditPoint::Normalize() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const_cast<CEditPoint*>(this)->m_iLine =
		std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	const_cast<CEditPoint*>(this)->m_iChar =
		std::min(m_iChar, m_pView->GetDocument()->GetLineLength(m_iLine));
}

/**
 *	hLgύXꂽƂɌĂяo
 *	@param udi	XV̓e
 */
void CEditPoint::OnUpdateDocument(const TUpdateInfo& udi) {
	AssertValid();
	if(m_pView == 0)
		return;

//	Normalize();

	// hLg̕ύXɍ킹Ĉʒu𒲐
	if(udi.usSummary == US_OPERATION_INSERT) {	// }̏ꍇ
		if(*this < udi.posBegin)	// ݈ʒu
			return;
		else if(this->m_iLine > udi.posBegin.m_iLine)	// ݍsO
			m_iLine += udi.posResult.m_iLine - udi.posBegin.m_iLine;
		else {	// ݍsƓs
			m_iLine += udi.posResult.m_iLine - udi.posBegin.m_iLine;
			m_iChar += udi.posResult.m_iChar - udi.posBegin.m_iChar;
		}
	} else if(udi.usSummary == US_OPERATION_DELETE) {	// 폜̏ꍇ
		if(*this < udi.posEnd)	// ݈ʒu
			return;
		else if(this->m_iLine > udi.posEnd.m_iLine)	// ݍsO
			m_iLine -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
		else if(*this >= udi.posBegin && *this <= udi.posEnd) {	// ͈͓
			m_iLine = udi.posBegin.m_iLine;
			m_iChar = udi.posBegin.m_iChar;
		} else {	// I_ݍsƓs
			if(this->m_iLine == udi.posBegin.m_iLine)	// ͈͂1s
				m_iChar -= udi.posEnd.m_iChar - udi.posBegin.m_iChar;
			else {	// ͈͂s
				m_iLine -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
				m_iChar -= udi.posEnd.m_iChar - udi.posBegin.m_iChar;
			}
		}
	} else
		return;
	UpdateLastCx();
}

/**
 *	̃y[WɈړ
 *	@param cPages	ړy[W
 */
void CEditPoint::PageDown(unsigned long cPages /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = min(m_pView->GetDocument()->GetLineCount() - 1,
				m_iLine + (m_pView->GetVisibleLineCount() - 1) * cPages);
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	Õy[WɈړ
 *	@param cPages	ړy[W
 */
void CEditPoint::PageUp(unsigned long cPages /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = (m_iLine > (m_pView->GetVisibleLineCount() - 1) * cPages) ?
		m_iLine - (m_pView->GetVisibleLineCount() - 1) * cPages : 0;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Paste(long cChars /* = 0 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || cChars == 0) {
		Paste(*this);
		return;
	}

	CEditPoint	pt(m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cChars > 0)
		pt.CharNext(cChars);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cChars++ != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Paste(pt);
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param pos	1̈ʒu
 */
void CEditPoint::Paste(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;

	size_t		cch;
	wchar_t*	pwszText = 0;
	const UINT	nAvailableClipFormat = m_pView->CanPaste();

	if(nAvailableClipFormat == 0)
		return;
	if(pos != *this)
		Delete(pos);
	cch = (CClipboard::GetClipboardTextSize(m_pView->m_hWnd) - 1);
	pwszText = new wchar_t[cch + 1];
	CClipboard::ReadClipboardText(m_pView->m_hWnd, pwszText, cch + 1);

	if(nAvailableClipFormat == ::RegisterClipboardFormatW(L"MSDEVColumnSelect"))
		InsertBox(pwszText);
	else
		Insert(pwszText);

	delete[] pwszText;
}

/**
 *	͈͓̃eLXgXy[XCfg
 *	@param pos		1̈ʒu
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CEditPoint::SpaceIndent(const CCharPos& pos, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return Indent(pos, L' ', nLevel);
}

/**
 *	͈͓̃eLXg^uCfg
 *	@param pos		1̈ʒu
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CEditPoint::TabIndent(const CCharPos& pos, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return Indent(pos, L'\t', nLevel);
}

///	m_cxLast ݈ʒuɍXV
void CEditPoint::UpdateLastCx() {
	AssertValid();
	m_cxLast = m_pView->PosFromChar(*this).x
				+ m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth()
				- m_pView->m_layoutInfo.nLeftTabWidth + 1;
}

/**
 *	̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndNext(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, true, true);
	UpdateLastCx();
}

/**
 *	O̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndPrev(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, false, true);
	UpdateLastCx();
}

/**
 *	̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordNext(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, true, false);
	UpdateLastCx();
}

/**
 *	O̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordPrev(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	*this = m_pView->m_pBoundarySearcher->SearchWordBoundary(*this, false, false);
	UpdateLastCx();
}


// CVisibleEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pView	Ώۂ̃r[
 */
CVisibleEditPoint::CVisibleEditPoint(CEditView* pView) : CEditPoint(pView) {
}

/**
 *	Rs[RXgN^
 *	@param rhs	E
 */
CVisibleEditPoint::CVisibleEditPoint(
		const CVisibleEditPoint& rhs) : CEditPoint(rhs.m_pView) {
	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	m_bSyncWithOtherEdit = rhs.m_bSyncWithOtherEdit;
	m_cxLast = rhs.m_cxLast;
}

///	fXgN^
CVisibleEditPoint::~CVisibleEditPoint() {
}

///	CCharPos ւ̌^ϊZq
CVisibleEditPoint::operator CCharPos() const {
	AssertValid();
	return CCharPos(m_iLine, m_iChar);
}

///	Zq
CVisibleEditPoint& CVisibleEditPoint::operator =(const CCharPos& rhs) {
	AssertValid();

	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	return *this;
}

///	@see	CEditPoint::OnUpdateDocument
void CVisibleEditPoint::OnUpdateDocument(const TUpdateInfo& udi) {
	AssertValid();

	CEditPoint::OnUpdateDocument(udi);
}


// CEditRange class implementation
/////////////////////////////////////////////////////////////////////////////
#if 0

///	͈͓eLXgLs^CY
void CEditRange::MakeCapitalized() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;

	wstring		str = GetText();
	size_t		cch = str.length();
	wchar_t*	pwsz = new wchar_t[str.length()];

	for(size_t i = 0; i < cch; ) {
		size_t	cchWord = m_pView->IsWord(pwsz + i, cch - i);
		if(cchWord > 0) {
			size_t	cchHead = ((i < cch - 1)
						&& CTextConverter::IsUTF16HighSurrogate(pwsz[i])
						&& CTextConverter::IsUTF16LowSurrogate(pwsz[i + 1])) ? 2 : 1;
			::CharUpperBuffW(pwsz + i, cchHead);
			::CharLowerBuffW(pwsz + i + cchHead, cch - i - cchHead);
			i += cchHead;
		} else
			++i;
	}

	str.assign(pwsz, str.length());
	Replace(str);
	delete[] pwsz;
}
#endif

/* [EOF] */