// EditDoc.h
// (c) 2003-2004 exeal

#ifndef _EDIT_DOC_H_
#define _EDIT_DOC_H_

#include <stack>
#include <map>
#include "AscensionCommon.h"
#include "..\..\Manah\DocumentView.h"
#include "..\..\Manah\File.h"


namespace Ascension {

class CEditDoc;
class CEditController;


// COperation interface definition
/////////////////////////////////////////////////////////////////////////////

class COperationUnit;

/**
 *	炩̕ҏW
 *	@see	CDeleteOperation, CInsertOperation
 */
interface IOperation {
	///	fXgN^
	virtual ~IOperation() {}
	///  <var>pOperationUnit</var> Ɍ
	virtual void	Concat(COperationUnit* pOperationUnit) = 0;
	/// s
	virtual void	Execute(CEditDoc* pDoc) = 0;
};


// CInsertOperation class definition
/////////////////////////////////////////////////////////////////////////////

class CDeleteOperation;
class COperationUnit;

///	1̑}
class CInsertOperation : public IOperation {

	friend class CDeleteOperation;
	friend class COperationUnit;
	// f[^o
private:
	bool			m_bType;	// ̎ (true: }Afalse: 폜)
	CCharPos		m_pos;		// }ʒu
	std::wstring	m_strText;	// }

	// RXgN^
public:
	CInsertOperation(const CCharPos& pos, const std::wstring& strText);

	// \bh
public:
	virtual void	Concat(COperationUnit* pOperationUnit);
	virtual void	Execute(CEditDoc* pDoc);
};


// CInsertOperation class definition
/////////////////////////////////////////////////////////////////////////////

///	1̍폜
class CDeleteOperation : public IOperation {

	friend class CInsertOperation;
	friend class COperationUnit;

	// f[^o
private:
	bool		m_bType;	// ̎ (true: }Afalse: 폜)
	CCharPos	m_posBegin;	// 폜Jn_
	CCharPos	m_posEnd;	// 폜I_

	// RXgN^
public:
	CDeleteOperation(const CCharPos& posBegin, const CCharPos& posEnd);

	// \bh
public:
	virtual void	Concat(COperationUnit* pOperationUnit);
	virtual void	Execute(CEditDoc* pDoc);
};


// COpearionUnit class definition
/////////////////////////////////////////////////////////////////////////////

///	܂Ƃ߂ăAhD/hD\ȈȂ
class COperationUnit {
	// RXgN^
public:
	virtual ~COperationUnit();

	// \bh
public:
	void		Execute(CEditDoc* pDoc);
	IOperation*	Pop();
	void		Push(IOperation* pOperation);
	IOperation*	Top() const;

	// f[^o
private:
	std::stack<IOperation*>	m_stkOpes;	// ̒PʂɊ܂܂Ȃ
};


// CEditDoc class definition
/////////////////////////////////////////////////////////////////////////////

// R[hy[WXgɌȂR[h
/// ʁA݂̕R[h
const UINT	EXTCP_AUTO		= 65500;
/// UTF-5
const UINT	EXTCP_UTF5		= 65506;

// 
/// UTF-16 gGfBA
const UINT	EXTCP_UTF16LE	= 1200;
/// UTF-16 rbOGfBA
const UINT	EXTCP_UTF16BE	= 1201;
/// UTF-32 gGfBA
const UINT	EXTCP_UTF32LE	= 12000;
/// UTF-32 rbOGfBA
const UINT	EXTCP_UTF32BE	= 12001;
/// EUC-JP
const UINT	EXTCP_EUCJP		= 51932;

/// sR[h
enum BreakType {
	/// ϊAw薳Ȃ
	BT_AUTO,
	/// sBUnix W (Lf, U+000A)
	BT_LF,
	/// BMacintosh W (Cr, U+000D)
	BT_CR,
	/// +sBWindows W (CrLf, U+000D U+000A)
	BT_CRLF,
	///	Vs (U+0085)
	BT_NEL,
	/// s؂ (U+2028)
	BT_LS,
	/// i؂ (U+2029)
	BT_PS
};

///	t@C̃I[v[h
enum FileOpenMode {
	///	bNȂ
	FOM_DENYNONE,
	///	̏ݖړĨt@CI[v
	FOM_DENYWRITE,
	///	̓ǂݍݖړĨt@CI[v
	FOM_DENYREAD,
	///	ǂݎpƂĊJ (bN͖)
	FOM_ASREADONLY
};

/// LoadDocument ASaveDocument ŕԂl
enum StreamStatus {
	/// t@C͐Ƀ[h/Z[uꂽ
	SS_OK						= 0x00,
	/// t@C̓ǂݎ/݂ۂꂽ
	SS_ACCESSDENIED				= 0x01,
	/// t@C̃bNۂꂽ
	SS_LOCKDENIED				= 0x02,
	/// w肳ꂽR[hy[WȂ
	SS_ILLEGALCODEPAGE			= 0x03,
	///	s̃G[
	SS_UNKNOWNERROR				= 0x04,	
	/// t@Cւ̃ANZXĂ߂ɁAǂݎp[hŊJ
	SS_READ_READONLY			= 0x11,
	/// t@C̕R[h𔻕ʂłȂ
	SS_READ_UNKNOWNCHARCODE		= 0x12,
	/// t@Cɕsȕ܂܂ĂߊSɓǂݍ߂Ȃ
	SS_READ_ILLEGALCHAR			= 0x13,
	/// ǂݍރt@C傫
	SS_READ_HUGEFILE			= 0x14,
	/// w肳ꂽt@C݂Ȃ
	SS_READ_NOEXISTS			= 0x15,
	///	NłȂ
	SS_READ_CANNOTRESOLVELINK	= 0x16,
	/// L}̂ɏނ߂̗̈悪
	SS_WRITE_FULLDISK			= 0x21,
	/// ǂݎp[hA܂͓ǂݎp̃t@CɏƂ
	SS_WRITE_READONLY			= 0x22,
	///	ϊR[hy[WɑΉ镶
	SS_WRITE_CONTAININVALIDCHAR	= 0x23,
};

/// CopyCurrentFile ADeleteCurrentFile AMoveCurrentFile ŕԂl
enum OperationStatus {
	/// t@C͐ɏI
	OPS_OK,
	/// [U𒆒f (ݔֈړ ̂ݗL)
	OPS_ABORTED,
	/// ǂݎp[hŊJĂ̂ŏłȂ
	OPS_MODEISREADONLY,
	/// Rs[Aړɓ̃t@C݂,
	OPS_ALREADYEXISTS,
	/// t@CJƂɓǂݎpŊJ
	OPS_OPENEDASREADONLY,
	/// t@CĴɎs
	OPS_CANNOTOPEN,
	/// \bhsɃt@CJĂȂ
	OPS_HASNOINSTANCE,
	/// m̃G[ (G[bZ[W GetLastError 擾\)
	OPS_UNKNOWNERROR,
};

///	CEditView::OnUpdate ̍XV̎
enum UpdateSummary {
	///	}
	US_OPERATION_INSERT,
	///	폜
	US_OPERATION_DELETE,
	///	AhD/hD̊Jn
	US_BEGIN_UNDOGROUP,
	///	AhD/hD̏I
	US_END_UNDOGROUP,
	///	hLgۑ
	US_SAVEDOCUMENT,
};

///	CEditDoc::GetModification œXV
struct TUpdateInfo {
	///	UpdateSummary Q
	UpdateSummary	usSummary;
	///	ΏۊJnʒu
	CCharPos		posBegin;
	///	ΏۏIʒu (posBegin &lt;= posEnd)
	CCharPos		posEnd;
	///	I̐Lbgʒu
	CCharPos		posResult;
};

///	hLgǂݎp̂ƂҏW悤ƂƃX[
class EDocumentIsReadOnly {
public:
	wstring	GetDescription() const {
		return L"Document is readonly. Any edit process is denied.";
	}
};

///	s̓e
class CEditDocLine {
	friend class CEditDoc;

	// f[^o
private:
	std::wstring	m_strLine;				// s
	BreakType		m_breakType;			// s̎
	unsigned long	m_cOperationHistory;	// AhDJE^ (0ŕύX̏)

	// RXgN^
public:
	explicit CEditDocLine(std::wstring& strLine = wstring(L""), BreakType breakType = BT_AUTO, bool bModified = false)
		: m_strLine(strLine), m_breakType(breakType), m_cOperationHistory(bModified ? 1 : 0) {
	}

	// \bh
public:
	const std::wstring&	GetLine() const {
		return m_strLine;
	}
	BreakType	GetBreakType() const {
		return m_breakType;
	}
	bool	IsModified() const {
		return m_cOperationHistory != 0;
	}
};

///	hLg̒ʒm󂯎Cxgnh
interface IEditDocEventListener {
	///	fXgN^
	virtual ~IEditDocEventListener() {
	}
	///	hLgύXꂽ
	virtual void	OnDocumentModified() = 0;
	/**
	 *	t@COvZXŕύXꂽ
	 *	@param pDocument	hLg
	 */
	virtual void	OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument) = 0;
};

typedef std::list<CEditDocLine>				CEditDocLineList;
typedef CEditDocLineList::const_iterator	LineIterator;

typedef unsigned short	SaveDocumentOption;
const SaveDocumentOption	SDO_WRITE_BOM			= 0x0001;	///	BOM 
const SaveDocumentOption	SDO_IGNORE_NOFITCHARS	= 0x0002;	///	ΉȂɑ΂Ċ̕ւ

/**
 *	@brief	Ascension eLXgGfB^̃hLg
 *
 *	SĂ̍s̓eA엚AR[hy[WAsR[hȂǂB
 *	t@Cs
 *
 *	<h3>AhDO[v̊TO</h3>
 *
 *	Ascension GfB^ɂ́Ȃ܂Ƃ߂ăAhD/hDł悤
 *	AhDO[vƂTOB^CsOɂA͂̈ꊇ
 *	쑤̎dłBCEditView ACEditPoint ͂Ƃɂ̑Ă邽߁A
 *	̃NXgăhLgҏWꍇA[U̓^CsOɂꊇ
 *	̂߂̃R[hKv͖
 *
 *	̑AhDO[vƂɂ͈Ȃ̑O
 *	CEditDoc::BeginEditCollection 1xĂяoBđ삪I
 *	CEditDoc::EndEditCollection Ăяo
 *
 *	@see	CEditView, CEditController, CEditPoint
 */
class CEditDoc : public Manah::Windows::CDocument {

	// CUndoManager class definition
	/////////////////////////////////////////////////////////////////////////

	///	AhDAhDǗ
	class CUndoManager /*: public Manah::CObject*/ {
		// f[^o
	private:
		CEditDoc*					m_pDoc;			// ΏۃhLg
		std::stack<COperationUnit*>	m_stkUndo;		// AhDX^bN
		std::stack<COperationUnit*>	m_stkRedo;		// hDX^bN
		bool						m_bVirtual;		// ẑƂ^
		COperationUnit*				m_pVirtualUnit;	// zǉ鑀P
		COperationUnit*				m_pLastUnit;	// ŌɒǉꂽP

		// RXgN^
	public:
		CUndoManager(CEditDoc* pDoc);
		virtual ~CUndoManager();

		// \bh
	public:
		void	Clear();						// obt@ɂ
		size_t	GetRedoBufferLength() const;	// hD\ȉ񐔂Ԃ
		size_t	GetUndoBufferLength() const;	// AhD\ȉ񐔂Ԃ
		void	PushUndoBuffer(					// AhDobt@ɑǉ
					IOperation* pOperation, bool bConcatPrev);
		void	Redo();							// hLgɃhDs
		void	Undo();							// hLgɃAhDs
	};

	///	AhDO[v̏
	enum UndoGroupingState {
		UGS_NONE,				///	O[sO͍sĂȂ
		UGS_WAITFORFIRSTEDIT,	///	O[sOJnҏW1xsĂȂ
		UGS_WAITFORCONTINUEEDIT	///	O[sOJn1xȏҏWsꂽ
	};

	// f[^o
public:
	static const wchar_t	m_wszBreakChars[6];		// s̏W
private:
	bool						m_bIgnoreViews;	// OnUpdate ĂяoKvƂ true (t@CǂݍݓrȂ)
	bool						m_bReadOnly;	// ǂݎp[h (ǂݍݎɐݒ肳s)
	FileOpenMode				m_fomMode;		// t@C̋L[h (FOM_ASREADONLY ͖Ӗ)
	UINT						m_nCodePage;	// R[hy[W
	BreakType					m_breakType;	// sR[h (L[{[h͂ɂsɎgp)
	CEditDocLineList			m_listLines;	// s
	Manah::Windows::IO::CFile	m_oFile;		// ݊JĂt@C
	CUndoManager*				m_pUndoManager;	// AhD/hD̊Ǘ
	TUpdateInfo					m_oUpdateInfo;	// Ō̍XV
	UndoGroupingState			m_ugsGroupingState;			// AhDO[v̎W
	bool						m_bOnceUndoBufferCleared;	// 1xȏAhDobt@NA

	bool						m_bVirtualOperating;	// AhD/hDɂ DeleteText AInsertText
														// \bhĂяôƂ true B
														// true ̊Ԃ͗\bhŃhDX^bNNAȂ

	IEditDocEventListener*		m_pEventListener;	// CxgXi
	FILETIME					m_lastWriteTime;	// t@C̍ŏIXV
	UINT						m_nTimerId;			// ^C} ID
	static std::map<UINT, CEditDoc*>	m_mapDocuments;	// ^C} ID -> hLg̃}bv

	mutable unsigned long						m_iLineCache_;	// GetInternalLineIterator LbVpf[^
	mutable CEditDocLineList::iterator			m_itCache_;
	mutable unsigned long						m_iLineCache;	// GetLineIterator LbVpf[^
	mutable CEditDocLineList::const_iterator	m_itCache;

	// RXgN^
public:
	CEditDoc(CEditController* pController = 0);
	virtual ~CEditDoc();

	// \bh
public:
	// hLgANZX
	void				ClearUndoBuffer();												// AhD/hDX^bÑNA
	void				GetAllLines(std::wstring& strText) const;						// Ss擾
	CEditController*	GetController() const;											// Rg[Ԃ
	unsigned long		GetDocumentLength() const;										// hLg̒Ԃ
	const std::wstring&	GetLine(unsigned long iLine) const throw(out_of_range);			// 1s擾
	unsigned long		GetLineCount() const;											// s擾
	unsigned long		GetLineIndex(unsigned long iLine,								// s̃ItZbg擾
							bool bIncludeBreak) const throw(out_of_range);
	const CEditDocLine*	GetLineInfo(unsigned long iLine) const throw(out_of_range);		// s擾
	LineIterator		GetLineIterator(unsigned long iLine) const throw(out_of_range);	// sCe[^̎擾
	unsigned long		GetLineLength(unsigned long iLine) const throw(out_of_range);	// s̒擾
	void				GetModification(TUpdateInfo& oUpdateInfo) const;				// XVe̎擾
	FileOpenMode		GetShareMode() const;											// r[h̎擾
	unsigned long		GetUndoHistoryLength(bool bRedo = false) const;					// AhD/hD\ȉ񐔂Ԃ
	void				InitiateDocument();												// 
	bool				IsReadOnly() const;												// ǂݎp[h̎擾
	void				SetReadOnly(bool bReadOnly = true);								// ǂݎp[h̐ݒ

	// ҏW
	void		BeginEditCollection();
	CCharPos	DeleteText(Manah::CObject* pSender,							// w͈͂폜
					const CCharPos& posBegin,
					const CCharPos& posEnd) throw(EDocumentIsReadOnly);
	void		EndEditCollection();
	CCharPos	InsertText(Manah::CObject* pSender,							// wʒuɕ}
					const CCharPos& pos,
					const std::wstring& strText) throw(EDocumentIsReadOnly);
	void		Redo() throw(EDocumentIsReadOnly);							// hD̎s
	void		SetEventListener(IEditDocEventListener* pEventListener);	// CxgXi̐ݒ
	void		Undo() throw(EDocumentIsReadOnly);							// AhD̎s

	// R[h
	static wstring	GetBreakString(BreakType bt);
	BreakType		GetBreakType() const;									// ݂̉sR[hԂ
	UINT			GetCodePage() const;									// ݂̃R[hy[WԂ
	static bool		IsAvailableCodePage(UINT nCodePage);					// ̃NXŗp\ȃR[hy[Wǂ
	bool			IsCharCodeUnicode() const;								// gp̕R[h Unicode 
	void			SetBreakType(BreakType bt) throw(invalid_argument);		// sR[h̐ݒ
	void			SetCodePage(UINT nCodePage) throw(invalid_argument);	// R[hy[W̐ݒ

	// t@C <-> hLg
	// 3̃\bh͉炩̗RŎsꍇ́AG[̓e\_CAO\A
	// false ܂ StreamStatus ԂB͂̃\bhŐZ
	bool			CloseDocument();										// t@C
	StreamStatus	LoadDocument(const std::wstring& strPathName,			// t@C̓ǂݍ
						FileOpenMode fom, UINT nCodePage = EXTCP_AUTO);
	StreamStatus	SaveDocument(const std::wstring& strPathName,			// t@C̕ۑ
						SaveDocumentOption sdo,
						BreakType bt, UINT nCodePage = EXTCP_AUTO);

	// ɊJĂt@Cɑ΂鏈
	OperationStatus	CopyCurrentFile(const wchar_t* pwszDestination);				// Rs[
	OperationStatus	DeleteCurrentFile() throw(EDocumentIsReadOnly);					// ݔֈړ
	bool			LockCurrentFile(FileOpenMode fom);								// bN
	OperationStatus	MoveCurrentFile(const wchar_t* pwszDestination);				// ړ
	bool			SendCurrentFile(bool bAsAttachment, bool bShowDialog = true);	// [֑M

protected:
	CEditDocLineList::iterator
		GetInternalLineIterator(unsigned long iLine) const throw(out_of_range);	// const łȂsCe[^̎擾
	void	CheckFileLastWriteTime();
private:
	static void CALLBACK	TimerProc(HWND hWnd, UINT nMsg, UINT_PTR idEvent, DWORD dwTime);

public:
	virtual bool	OnNewDocument();									// VhLg쐬ƂɌĂяo
	virtual bool	OnOpenDocument(const std::wstring& strPathName);	// t@CJƂɌĂяo
	virtual bool	OnSaveDocument(const std::wstring& strPathName);	// t@CۑƂɌĂяo
};


// CEditDoc class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	sR[h̉sԂ
inline wstring CEditDoc::GetBreakString(BreakType bt) {
	switch(bt) {
	case BT_AUTO:	return L"";
	case BT_LF:		return L"\n";
	case BT_CR:		return L"\r";
	case BT_CRLF:	return L"\r\n";
	case BT_NEL:	return wstring(1, 0x0085);	// VC6
	case BT_LS:		return L"\x2028";
	case BT_PS:		return L"\x2029";
	default:		assert(false);
	}
	return L"";	// ɂ͗Ȃ
}

///	ݎgpĂsR[h擾
inline BreakType CEditDoc::GetBreakType() const {
	AssertValid();
	return m_breakType;
}

///	ݎgpĂR[hy[W擾
inline UINT CEditDoc::GetCodePage() const {
	AssertValid();
	return m_nCodePage;
}

///	Rg[擾
inline CEditController* CEditDoc::GetController() const {
	AssertValid();
	return reinterpret_cast<CEditController*>(m_pController);
}

///	s擾
inline unsigned long CEditDoc::GetLineCount() const {
	AssertValid();
	return m_listLines.size();
}

///	Ō̍XV擾
inline void CEditDoc::GetModification(TUpdateInfo& oUpdateInfo) const {
	AssertValid();
	oUpdateInfo = m_oUpdateInfo;
}

///	t@C̔r[h擾
inline FileOpenMode CEditDoc::GetShareMode() const {
	AssertValid();
	return m_fomMode;
}

///	AhDAhD\ȉ񐔂擾
inline unsigned long CEditDoc::GetUndoHistoryLength(bool bRedo /* = false */) const {
	AssertValid();
	return bRedo ? m_pUndoManager->GetRedoBufferLength() : m_pUndoManager->GetUndoBufferLength();
}

///	̃NXŗp\ȃR[hy[WǂԂ (EXTCP_AUTO ɂ false Ԃ)
inline bool CEditDoc::IsAvailableCodePage(UINT nCodePage) {
	return nCodePage == CP_UTF8
		|| nCodePage == EXTCP_EUCJP
		|| nCodePage == EXTCP_UTF16LE
		|| nCodePage == EXTCP_UTF16BE
		|| nCodePage == EXTCP_UTF32LE
		|| nCodePage == EXTCP_UTF32BE
		|| nCodePage == EXTCP_UTF5
		|| ::IsValidCodePage(nCodePage);
}

///	ݎgpĂR[hy[W Unicode Ԃ
inline bool CEditDoc::IsCharCodeUnicode() const {
	AssertValid();
	return m_nCodePage == EXTCP_UTF5
		|| m_nCodePage == CP_UTF7
		|| m_nCodePage == CP_UTF8
		|| m_nCodePage == EXTCP_UTF16LE
		|| m_nCodePage == EXTCP_UTF16BE
		|| m_nCodePage == EXTCP_UTF16LE
		|| m_nCodePage == EXTCP_UTF32BE;
}

///	ǂݎp[hǂԂ
inline bool CEditDoc::IsReadOnly() const {
	AssertValid();
	return m_bReadOnly;
}

} // namespace Ascension


#endif /* _EDIT_DOC_H_ */

/* [EOF] */