// EditDoc.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditDoc.h"
#include <MAPI.h>	// MAPISendMail
#include "..\..\Manah\Text.h"
#include "..\..\Manah\WaitCursor.h"
#include "..\..\Armaiti\ComGeneric.h"

using namespace Ascension;
using Ascension::CEditDoc::CUndoManager;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Text;
using namespace Armaiti;
using namespace std;


// CInsertOperation class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CInsertOperation::CInsertOperation(const CCharPos& pos,
		const wstring& strText) : m_bType(true), m_pos(pos), m_strText(strText) {
}

///	폜͏ɌłȂ
void CInsertOperation::Concat(COperationUnit* pOperationUnit) {
	assert(pOperationUnit != 0);
	pOperationUnit->Push(this);
}

///	}̍Đ
void CInsertOperation::Execute(CEditDoc* pDoc) {
	VIEW_POSITION	pos = pDoc->GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = pDoc->GetNextView(pos))) {
		if(::GetFocus() == pView->m_hWnd)
			break;
	}
	pDoc->InsertText(pView, m_pos, m_strText);
}


// CDeleteOperation class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDeleteOperation::CDeleteOperation(const CCharPos& posBegin,
		const CCharPos& posEnd) : m_bType(false), m_posBegin(posBegin), m_posEnd(posEnd) {
}

///	̑w肳ꂽPʂɌ
void CDeleteOperation::Concat(COperationUnit* pOperationUnit) {
	assert(pOperationUnit != 0);
	IOperation*	pLastOpe = pOperationUnit->Top();

	if(!static_cast<CDeleteOperation*>(pLastOpe)->m_bType) {	// O͑}
		CDeleteOperation*	pPrevOperation = static_cast<CDeleteOperation*>(pLastOpe);
		if(m_posBegin.m_iLine != pPrevOperation->m_posEnd.m_iLine
				|| m_posBegin.m_iChar != pPrevOperation->m_posEnd.m_iChar)
			pOperationUnit->Push(this);
		else
			pPrevOperation->m_posEnd = m_posEnd;	// Ō̑Pʂ̍Ō̑Ɍ (폜͈͂g)
	} else	// O͍폜
		pOperationUnit->Push(this);	// Ō̑Pʂɒǉ
}

///	폜̍Đ
void CDeleteOperation::Execute(CEditDoc* pDoc) {
	VIEW_POSITION	pos = pDoc->GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = pDoc->GetNextView(pos))) {
		if(::GetFocus() == pView->m_hWnd)
			break;
	}
	pDoc->DeleteText(pView, m_posBegin, m_posEnd);
}


// COperationUnit class implementation
/////////////////////////////////////////////////////////////////////////////

/// fXgN^
COperationUnit::~COperationUnit() {
	while(!m_stkOpes.empty()) {
		delete m_stkOpes.top();
		m_stkOpes.pop();
	}
}

/**
 *	Pʂ̎sB\bhďoケ̃IuWFNg͖ɂȂ
 *	@param pDoc	ΏۃhLg
 */
void COperationUnit::Execute(CEditDoc* pDoc) {
	while(!m_stkOpes.empty()) {	// SĂ̑s
		m_stkOpes.top()->Execute(pDoc);
		delete m_stkOpes.top();
		m_stkOpes.pop();
	}
}

///	1̑|bv
IOperation* COperationUnit::Pop() {
	IOperation*	p = m_stkOpes.top();
	m_stkOpes.pop();
	return p;
}

///	1̑vbV
void COperationUnit::Push(IOperation* pOperation) {
	if(m_stkOpes.size() != 0
			&& !static_cast<CDeleteOperation*>(pOperation)->m_bType
			&& !static_cast<CDeleteOperation*>(m_stkOpes.top())->m_bType) {
		CDeleteOperation*	pNewOp = static_cast<CDeleteOperation*>(pOperation);
		CDeleteOperation*	pLastOp = static_cast<CDeleteOperation*>(m_stkOpes.top());
		if(pNewOp->m_posBegin.m_iLine == pLastOp->m_posEnd.m_iLine
				&& pNewOp->m_posBegin.m_iChar == pLastOp->m_posEnd.m_iChar) {
			pLastOp->m_posEnd = pNewOp->m_posEnd;
			delete pNewOp;
			return;
		}
	}
	m_stkOpes.push(pOperation);
}

///	擪̑擾
IOperation* COperationUnit::Top() const {
	return m_stkOpes.top();
}


// CUndoManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CUndoManager::CUndoManager(CEditDoc* pDoc)
	: m_pDoc(pDoc), m_bVirtual(false), m_pVirtualUnit(0), m_pLastUnit(0) {
}

///	fXgN^
CUndoManager::~CUndoManager() {
	Clear();
}

///	AhD/hDX^bNɂ
void CUndoManager::Clear() {
	m_pLastUnit = 0;
	while(!m_stkUndo.empty()) {
		delete m_stkUndo.top();
		m_stkUndo.pop();
	}
	while(!m_stkRedo.empty()) {
		delete m_stkRedo.top();
		m_stkRedo.pop();
	}
}

///	hD\ȉ񐔂Ԃ
size_t CUndoManager::GetRedoBufferLength() const {
	return m_stkRedo.size();
}

///	AhD\ȉ񐔂Ԃ
size_t CUndoManager::GetUndoBufferLength() const {
	return m_stkUndo.size();
}

/**
 *	1̑AhDX^bNɒǉ
 *	@param pOperation	ǉ鑀
 *	@param bConcatPrev	Ȏƌ邩ǂ
 */
void CUndoManager::PushUndoBuffer(IOperation* pOperation, bool bConcatPrev) {
	// hDX^bNɂ
	if(!m_bVirtual) {
		while(!m_stkRedo.empty()) {
			delete m_stkRedo.top();
			m_stkRedo.pop();
		}
	}

	if(m_bVirtual) {	// z쎞̓X^bNւ̒ǉx
		if(m_pVirtualUnit == 0)	// 
			m_pVirtualUnit = new COperationUnit();
		m_pVirtualUnit->Push(pOperation);
	} else if(bConcatPrev && m_pLastUnit) {	// Ō̑PʂɌ
		assert(m_pLastUnit != 0);
		m_pLastUnit->Push(pOperation);
	} else {
		COperationUnit*	pUnit = new COperationUnit();
		pUnit->Push(pOperation);
		m_stkUndo.push(pUnit);
		m_pLastUnit = pUnit;
	}
}

///	hD1s
void CUndoManager::Redo() {
	if(m_stkRedo.empty())
		return;

	COperationUnit*	pUnit = m_stkRedo.top();
	m_stkRedo.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_pDoc);
	m_stkUndo.push(m_pVirtualUnit);	// zPʂAhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}

///	AhD1s
void CUndoManager::Undo() {
	if(m_stkUndo.empty())
		return;

	COperationUnit*	pUnit = m_stkUndo.top();
	m_stkUndo.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_pDoc);
	m_stkRedo.push(m_pVirtualUnit);	// zPʂhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}


// CEditDoc class implementation
/////////////////////////////////////////////////////////////////////////////

const wchar_t CEditDoc::m_wszBreakChars[6] = {		// U+0085 Ƀeg VC6 ŃG[ɂȂ
	0x000A, 0x000D, 0x0085, 0x2028, 0x2029, 0x0000	// (C99 ł 0x00A0 ȉ̕ \uxxxx `Ŏw肷邱Ƃ
};													// oȂ炵 C++ Ƃ̊֘A͕s)

map<UINT, CEditDoc*> CEditDoc::m_mapDocuments;

///	RXgN^
CEditDoc::CEditDoc(Ascension::CEditController* pController /* = 0 */) :
		Manah::Windows::CDocument((CController*)pController), m_bIgnoreViews(false), m_bReadOnly(false),
		m_fomMode(FOM_DENYNONE), m_breakType(BT_CRLF), m_ugsGroupingState(UGS_NONE),
		m_bOnceUndoBufferCleared(false), m_bVirtualOperating(false), m_pEventListener(0),
		m_itCache_(m_listLines.end()), m_itCache(m_listLines.end()) {
	CEditDocLine	oLine;
	m_nCodePage = ::GetACP();
	m_listLines.push_back(oLine);
	m_pUndoManager = new CUndoManager(this);
	m_nTimerId = ::SetTimer(0, 0, 1000, CEditDoc::TimerProc);
	CEditDoc::m_mapDocuments[m_nTimerId] = this;
}

///	fXgN^
CEditDoc::~CEditDoc() {
	CloseDocument();
	delete m_pUndoManager;
	::KillTimer(0, m_nTimerId);
	map<UINT, CEditDoc*>::iterator	it = CEditDoc::m_mapDocuments.find(m_nTimerId);
	if(it != CEditDoc::m_mapDocuments.end())
		CEditDoc::m_mapDocuments.erase(it);
}

///	AhDO[v̎WJnB
///	ݎWł΁AxIAVWJn
void CEditDoc::BeginEditCollection() {
	AssertValid();

	if(m_ugsGroupingState != UGS_NONE)
		EndEditCollection();
	m_ugsGroupingState = UGS_WAITFORFIRSTEDIT;
}

///	t@C̍ŏIXV`FbN
void CEditDoc::CheckFileLastWriteTime() {
	AssertValid();

	if(m_strPathName.empty())
		return;

	HANDLE				hFind;
	WIN32_FIND_DATAW	wfd;

	hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind == INVALID_HANDLE_VALUE)
		return;
	if(::CompareFileTime(&m_lastWriteTime, &wfd.ftLastWriteTime) == -1
			&& m_pEventListener != 0) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		m_pEventListener->OnDocumentOverwrittenByOtherProcess(this);
	}
	::FindClose(hFind);
}

///	AhD/hDX^bNɂė
void CEditDoc::ClearUndoBuffer() {
	AssertValid();
	m_pUndoManager->Clear();
	m_bOnceUndoBufferCleared = true;
}

///	hLg OnCloseDocument Ă
bool CEditDoc::CloseDocument() {
	AssertValid();

	m_oFile.Close();
	InitiateDocument();

	OnCloseDocument();
	return true;
}

/**
 *	݊JĂt@CRs[
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::CopyCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	OperationStatus	ops = OPS_OK;
	UINT			nShareMode;

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(::PathFileExistsW(pwszDestination))
		return OPS_ALREADYEXISTS;

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:	nShareMode = CFile::shareDenyWrite;	break;
		case FOM_DENYREAD:	nShareMode = CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:nShareMode = CFile::shareDenyNone;	break;
	}

	m_oFile.Close();
	if(!::CopyFileW(m_strPathName.c_str(), pwszDestination, true))
		ops = OPS_UNKNOWNERROR;

	// t@CJ
	if(m_bReadOnly) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false))
			m_fomMode = FOM_ASREADONLY;
		else
			return OPS_CANNOTOPEN;
	} else if(!m_oFile.Open(m_strPathName, nShareMode | CFile::modeReadWrite | CFile::modeNoTruncate, false)) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fomMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	݊JĂt@CݔɈړB
 *	̃\bhsƃt@C͕
 *	@return	
 */
OperationStatus CEditDoc::DeleteCurrentFile() {
	AssertValid();

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	OperationStatus	ops = OPS_OK;
	unsigned int	nShareMode = 0;
	wchar_t			wszPath[MAX_PATH];
	SHFILEOPSTRUCTW	shfos = {::GetDesktopWindow(), FO_DELETE, wszPath, 0, FOF_ALLOWUNDO, 0, 0, 0};

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:	nShareMode = CFile::shareDenyWrite;	break;
		case FOM_DENYREAD:	nShareMode = CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:nShareMode = CFile::shareDenyNone;	break;
	}

	wcscpy(wszPath, m_strPathName.c_str());
	*(wszPath + wcslen(wszPath) + 1) = 0;

	m_oFile.Close();
	::SHFileOperationW(&shfos);
	if(::PathFileExistsW(wszPath)) {	// s (SHFileExistsW ̖߂l͂ǂMpł)
		if(shfos.fAnyOperationsAborted)
			ops = OPS_ABORTED;

		// t@CJ
		if(!m_oFile.Open(m_strPathName, nShareMode | CFile::modeReadWrite | CFile::modeNoTruncate, false)) {
			if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
				m_fomMode = FOM_ASREADONLY;
				if(!m_bReadOnly) {
					ops = OPS_OPENEDASREADONLY;
					m_bReadOnly = true;
				}
			} else
				ops = OPS_CANNOTOPEN;
		}
	}

	return ops;
}

/**
 *	hLgeLXg̎w͈͂폜B
 *	̃\bh posBegin  posEnd ̓Lbguׂ
 *	UpdateAllViews Ăяȏ3ɁAłȂ2ɓnB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	hLgɏvr[
 *	@param posBegin	폜Jn_
 *	@param posEnd	폜I_
 *	@return			IɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::DeleteText(CObject* pSender,
		const CCharPos& posBegin, const CCharPos& posEnd) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	const CCharPos&	posABegin = min(posBegin, posEnd);	// n_
	const CCharPos&	posAEnd = max(posBegin, posEnd);	// I_
	wstring			strDeleted;							// 폜 (sɂȂƂ݂͌̉s})

	if(posBegin.m_iLine == posEnd.m_iLine) {	// Ώۂ1sȓ
		const CEditDocLine*	pLine = GetLineInfo(posEnd.m_iLine);
		wstring&			strLine = const_cast<wstring&>(GetLine(posEnd.m_iLine));

		++const_cast<CEditDocLine*>(pLine)->m_cOperationHistory;
		strDeleted = strLine.substr(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
	} else {							// Ώۂs
		wstring&	strLine = const_cast<wstring&>(GetLine(posABegin.m_iLine));
		wstring	strTail;
		strDeleted = strLine.substr(posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar);

		// 폜镔ۑ폜
		CEditDocLineList::iterator	it = GetInternalLineIterator(posABegin.m_iLine), itNext;
		CEditDocLineList::iterator	itFirstLine = it;
		BreakType					btLastLine;
		strDeleted += CEditDoc::GetBreakString(it->m_breakType);
		itNext = ++it;
		for(unsigned long iLine = posABegin.m_iLine + 1; iLine < posAEnd.m_iLine + 1; ++iLine) {
			strDeleted +=
				((iLine != posAEnd.m_iLine) ? it->m_strLine : it->m_strLine.substr(0, posAEnd.m_iChar));
			if(iLine != posAEnd.m_iLine)
				strDeleted += GetBreakString(it->m_breakType);
			++itNext;
			assert(itNext != 0);
			if(iLine == posAEnd.m_iLine) {	// 폜Is
				strTail = it->m_strLine.substr(posAEnd.m_iChar);
				btLastLine = it->m_breakType;
			}
			m_listLines.erase(it);
			it = itNext;
		}

		// 폜̑Oq
		itFirstLine->m_breakType = btLastLine;
		++itFirstLine->m_cOperationHistory;
		if(!strTail.empty())
			strLine += strTail;
	}

	m_itCache_ = m_listLines.end();	// ŃLbV𖳌ɂĂ
	m_itCache = m_listLines.end();

	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(new CInsertOperation(
		posABegin, strDeleted), m_ugsGroupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_ugsGroupingState == UGS_WAITFORFIRSTEDIT)
		m_ugsGroupingState = UGS_WAITFORCONTINUEEDIT;

	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_oUpdateInfo.usSummary = US_OPERATION_DELETE;
		m_oUpdateInfo.posBegin = posABegin;
		m_oUpdateInfo.posEnd = posAEnd;
		m_oUpdateInfo.posResult = posABegin;
		UpdateAllViews(pSender, 0, this);
	}
	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();

	return posABegin;
}

///	AhDO[v̎WI
void CEditDoc::EndEditCollection() {
	AssertValid();
	m_ugsGroupingState = UGS_NONE;
}

/**
 *	Ss (hLgS) 擾
 *	@param strText	i[
 */
void CEditDoc::GetAllLines(wstring& strText) const {
	AssertValid();
	LineIterator	it;
	unsigned long	cchAllLines = 0;

	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		cchAllLines += it->m_strLine.length() + CEditDoc::GetBreakString(it->m_breakType).length();
	strText.reserve(cchAllLines);
	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		strText += it->m_strLine + CEditDoc::GetBreakString(it->m_breakType);
}

///	hLg̕ҏW̕ԂBsɂ݂͌̉sR[hgp
unsigned long CEditDoc::GetDocumentLength() const {
	AssertValid();

	unsigned long	len = 0;
	LineIterator	it;
	int				cchBreak = (m_breakType == BT_CRLF) ? 2 : 1;

	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		len += it->m_strLine.length() + cchBreak;
	len -= cchBreak;

	return len;
}

///	ҏW\ȓpsCe[^̎擾
CEditDocLineList::iterator CEditDoc::GetInternalLineIterator(unsigned long iLine) const throw(out_of_range) {
	AssertValid();

	CEditDocLineList&			refList = const_cast<CEditDoc*>(this)->m_listLines;
	CEditDocLineList::size_type	i, len = m_listLines.size();
	CEditDocLineList::iterator	it;

	if(iLine >= len)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache_ == refList.end()) {	// LbVgȂꍇ
		if(iLine <= len / 2)
			for(i = 0, it = refList.begin(); i < iLine; ++i, ++it);
		else
			for(i = len, it = refList.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache_, iLine))
			for(i = 0, it = refList.begin(); i < iLine; ++i, ++it);
		else if(len - iLine < dif(m_iLineCache_, iLine))
			for(i = len, it = refList.end(); i > iLine; --i, --it);
		else if(m_iLineCache_ < iLine)
			for(i = m_iLineCache_, it = m_itCache_; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache_, it = m_itCache_; i > iLine; --i, --it);
	}

	m_iLineCache_ = iLine;
	m_itCache_ = it;
	return it;
}

/**
 *	w肵s̃eLXg擾B
 *	s݂Ȃ <code>out_of_range</code> 𓊂
 */
const wstring& CEditDoc::GetLine(unsigned long iLine) const throw(out_of_range) {
	AssertValid();

	try {
		return GetLineInfo(iLine)->m_strLine;
	} catch(out_of_range& e) {
		throw e;
	}
}

/**
 *	ws牽ڂԂ
 *	@param iLine			ׂs
 *	@param bIncludeBreak	s𕶎ƂĐ邩ǂ
 *	@throw out_of_range		<var>iLine</var> ȂꍇX[
 */
unsigned long CEditDoc::GetLineIndex(unsigned long iLine, bool bIncludeBreak) const throw(out_of_range) {
	AssertValid();

	if(iLine >= m_listLines.size())
		throw out_of_range("Specified line not found.");

	unsigned long						iOffset = 0;
	list<CEditDocLine>::const_iterator	it = m_listLines.begin();
	for(unsigned long i = 0; i < iLine; ++it, ++i) {
		iOffset += it->m_strLine.length();
		iOffset += bIncludeBreak ? CEditDoc::GetBreakString(it->m_breakType).length() : 0;
	}

	return iOffset;
}

///	sꊇĎ擾
const CEditDocLine* CEditDoc::GetLineInfo(unsigned long iLine) const throw(out_of_range) {
	AssertValid();

	try {
		return &(*GetLineIterator(iLine));
	} catch(out_of_range& e) {
		throw e;
	}
}

///	sCe[^̎擾
LineIterator CEditDoc::GetLineIterator(unsigned long iLine) const throw(out_of_range) {
	AssertValid();

	CEditDocLineList::size_type	i, len = m_listLines.size();
	LineIterator				it;

	if(iLine >= len)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache == m_listLines.end()) {	// LbVgȂꍇ
		if(iLine <= len / 2)
			for(i = 0, it = m_listLines.begin(); i < iLine; ++i, ++it);
		else
			for(i = len, it = m_listLines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache, iLine))
			for(i = 0, it = m_listLines.begin(); i < iLine; ++i, ++it);
		else if(len - iLine < dif(m_iLineCache, iLine))
			for(i = len, it = m_listLines.end(); i > iLine; --i, --it);
		else if(m_iLineCache < iLine)
			for(i = m_iLineCache, it = m_itCache; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache, it = m_itCache; i > iLine; --i, --it);
	}

	m_iLineCache = iLine;
	m_itCache = it;
	return it;
}

/**
 *	w肵s̒擾B
 *	s݂Ȃ <code>out_of_range</code> 𓊂
 */
unsigned long CEditDoc::GetLineLength(unsigned long iLine) const throw(out_of_range) {
	AssertValid();
	try {
		return GetLine(iLine).length();
	} catch(out_of_range& e) {
		throw e;
	}
}

///	hLg
void CEditDoc::InitiateDocument() {
	AssertValid();

	m_listLines.clear();
	m_listLines.push_back(CEditDocLine());
	m_itCache_ = m_listLines.end();
	m_itCache = m_listLines.end();
	m_bModified = false;
	ClearUndoBuffer();
	m_ugsGroupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;

	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();
}

/**
 *	wʒuɃeLXg}B
 *	̃\bh͑}eLXg̏I[ʒuԂB
 *	܂AI[ʒu͂̃\bh UpdateAllViews \bhĂяȏ2A3ɂgpB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	̏vr[
 *	@param pos		}ʒu
 *	@param strText	}镶
 *	@return			ɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::InsertText(CObject* pSender,
		const CCharPos& pos, const wstring& strText) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	wstring::size_type	iLast = strText.find_first_of(CEditDoc::m_wszBreakChars);
	wstring::size_type	iNext;
	CCharPos			posResult;
	const CEditDocLine*	pLastLine = GetLineInfo(pos.m_iLine);
	wstring&			strLine = const_cast<wstring&>(pLastLine->m_strLine);

	if(iLast == wstring::npos) {	// ͂ɉsꍇ
		strLine.insert(pos.m_iChar, strText);
		++const_cast<CEditDocLine*>(pLastLine)->m_cOperationHistory;
		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = pos.m_iChar + strText.length();
	} else {	// ͂ɉsꍇ
		unsigned long	iLine = pos.m_iLine;
		CEditDocLineList::iterator	it = GetInternalLineIterator(pos.m_iLine);
		wstring			strInsert = strText + it->m_strLine.substr(pos.m_iChar);
		BreakType		bt;
		BreakType		btFirstLine = it->m_breakType;	// 擪s̉s (}Ԍɕt)

		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = strText.length() - strText.find_last_of(CEditDoc::m_wszBreakChars) - 1;

		// 擪s̒u
		strLine.replace(pos.m_iChar, strLine.length() - pos.m_iChar, strInsert.substr(0, iLast));
		if(strInsert[iLast] == L'\r' && iLast + 1 != strInsert.length() && strInsert[iLast + 1] == L'\n') {
			iLast += 2;
			it->m_breakType = BT_CRLF;
		} else {
			switch(strInsert[iLast]) {
			case L'\n':		it->m_breakType = BT_LF;	break;
			case L'\r':		it->m_breakType = BT_CR;	break;
			case 0x0085:	it->m_breakType = BT_NEL;	break;
			case L'\x2028':	it->m_breakType = BT_LS;	break;
			case L'\x2029':	it->m_breakType = BT_PS;	break;
			}
			++iLast;
		}
		++it->m_cOperationHistory;
		++iLine;
		++it;
		++posResult.m_iLine;

		while(true) {	// sƂɍs؂
			iNext = strInsert.find_first_of(CEditDoc::m_wszBreakChars, iLast);
			if(iNext != wstring::npos) {
				if(strInsert[iNext] == L'\r' && iNext + 1 != strInsert.length() && strInsert[iNext + 1] == L'\n') {
					iNext += 2;
					bt = BT_CRLF;
				} else {
					switch(strInsert[iNext]) {
					case L'\n':		bt = BT_LF;	break;
					case L'\r':		bt = BT_CR;	break;
					case 0x0085:	bt = BT_NEL;break;
					case L'\x2028':	bt = BT_LS;	break;
					case L'\x2029':	bt = BT_PS;	break;
					}
					++iNext;
				}
				// s쐬A}
				it = m_listLines.insert(it,
					CEditDocLine(strInsert.substr(iLast, iNext - iLast - ((bt == BT_CRLF) ? 2 : 1)), bt, true));
				++it;
				++iLine;
				++posResult.m_iLine;
				iLast = iNext;
			} else {	// ̍sōŌ
				m_listLines.insert(it,
					CEditDocLine(strInsert.substr(iLast), btFirstLine, true));
				break;
			}
		}

		m_itCache_ = m_listLines.end();	// ŃLbV𖳌ɂĂ
		m_itCache = m_listLines.end();
	}

	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(new CDeleteOperation(
		pos, posResult), m_ugsGroupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_ugsGroupingState == UGS_WAITFORFIRSTEDIT)
		m_ugsGroupingState = UGS_WAITFORCONTINUEEDIT;

	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();
	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_oUpdateInfo.usSummary = US_OPERATION_INSERT;
		m_oUpdateInfo.posBegin = pos;
		m_oUpdateInfo.posEnd = pos;
		m_oUpdateInfo.posResult = posResult;
		UpdateAllViews(pSender, 0, this);
	}

	return posResult;
}

/**
 *	hLgǂݍ
 *	@param strPathName	t@CpX
 *	@param fom			r[hȂ
 *	@param nCodePage	R[hy[W (ȗƎ)
 *	@return				
 */
StreamStatus CEditDoc::LoadDocument(const wstring& strPathName,
		FileOpenMode fom, UINT nCodePage /* = EXTXP_AUTO */) {
//	CTimer tm(L"LoadDocument");	// 2.86s / 1MB
	AssertValid();

	if(nCodePage != EXTCP_AUTO && !IsAvailableCodePage(nCodePage))
		return SS_ILLEGALCODEPAGE;

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;
	wchar_t			wszPathName[MAX_PATH];
	HGLOBAL			hGlobal = 0, hGlobal2 = 0;
	unsigned char*	pszBuffer = 0;		// obt@
	wchar_t*		pwszBuffer = 0;
	wchar_t*		pwszFirstBreak = 0;	// ŏɌꂽs
	DWORD			dwFileSize;			// t@CTCY
	DWORD			dwRead;				// ۂɓǂݎf[^
	CCharPos		posLast(0, 0);		// ɕǉʒu

	// V[gJbg̉
	const wchar_t*	pwszExtension = ::PathFindExtensionW(strPathName.c_str());
	if(pwszExtension != 0 && (
			(::StrCmpIW(pwszExtension + 1, L"lnk") == 0)
			/*|| (::StrCmpIW(pwszExtension + 1, L"url") == 0)*/)) {
		CComPtr<IShellLink>		pShellLink;
		CComPtr<IPersistFile>	pFile;

		if(FAILED(pShellLink.CreateInstance(CLSID_ShellLink)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->QueryInterface(IID_IPersistFile, reinterpret_cast<void**>(&pFile))))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pFile->Load(strPathName.c_str(), STGM_READ)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->Resolve(0, SLR_ANY_MATCH | SLR_NO_UI)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->GetPath(wszPathName, MAX_PATH, 0, 0)))
			return SS_READ_CANNOTRESOLVELINK;
	} else
		wcscpy(wszPathName, strPathName.c_str());

	try {
		m_oFile.Close();
		m_bReadOnly = false;
		m_fomMode = fom;
		if(fom == FOM_ASREADONLY) {
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		} else if(!m_oFile.Open(wszPathName, CFile::modeReadWrite | CFile::shareDenyNone, false)) {
			ss = SS_READ_READONLY;
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		}
		m_oFile.GetFileTime(0, 0, &m_lastWriteTime);
		dwFileSize = m_oFile.GetFileSize(0);	// 4GB ̃XNvgȂ񂩖낤
		hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
		pszBuffer = static_cast<unsigned char*>(::GlobalLock(hGlobal));

		if(dwFileSize != 0)
			dwRead = m_oFile.Read(pszBuffer, dwFileSize);
	} catch(CFileException& e) {
		if(pszBuffer != 0)
			::GlobalUnlock(hGlobal);
		if(hGlobal != 0)
			::GlobalFree(hGlobal);
		return SS_READ_NOEXISTS;
	}

	m_oFile.Close();

	// R[hϊ
	CharCode	cc;
	if(dwFileSize != 0) {
		hGlobal2 = ::GlobalAlloc(GMEM_MOVEABLE, sizeof(wchar_t) * dwRead * 3);	// ȃTCY...
		pwszBuffer = static_cast<wchar_t*>(::GlobalLock(hGlobal2));
		switch(nCodePage) {
		case EXTCP_AUTO:
			cc = CC_AUTO;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			switch(cc) {
			case CC_UTF16LE:	nCodePage = EXTCP_UTF16LE;	break;
			case CC_UTF16BE:	nCodePage = EXTCP_UTF16BE;	break;
			case CC_UTF32LE:	nCodePage = EXTCP_UTF32LE;	break;
			case CC_UTF32BE:	nCodePage = EXTCP_UTF32BE;	break;
			case CC_UTF8:		nCodePage = CP_UTF8;		break;
			case CC_UTF7:		nCodePage = EXTCP_UTF5;		break;
			case CC_SHIFTJIS:	nCodePage = 932;			break;
			case CC_JIS:		nCodePage = 50221;			break;
			case CC_EUCJP:		nCodePage = EXTCP_EUCJP;	break;
			}
			break;
		case EXTCP_UTF16LE:
			cc = CC_UTF16LE;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case EXTCP_UTF16BE:
			cc = CC_UTF16BE;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case EXTCP_UTF32LE:
			cc = CC_UTF32LE;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case EXTCP_UTF32BE:
			cc = CC_UTF32BE;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case CP_UTF8:
			cc = CC_UTF8;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case EXTCP_UTF5:
			cc = CC_UTF5;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case 932:	// Shift-JIS
			cc = CC_SHIFTJIS;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case 50221:	// JIS
			cc = CC_JIS;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		case EXTCP_EUCJP:
			cc = CC_EUCJP;
			dwRead = ConvertToUnicode(cc, pwszBuffer, pszBuffer, dwRead);
			break;
		default:
			dwRead = ::MultiByteToWideChar(nCodePage, 0,
				reinterpret_cast<const char*>(pszBuffer), dwRead, pwszBuffer, dwRead * 2);
			break;
		}
		*(pwszBuffer + dwRead) = 0;

		// sƂɋ؂AXgɒǉĂ
		unsigned long	iNext, iLast = 0;
		wchar_t*		pwszBreak;
		BreakType		bt;
		m_listLines.clear();
		while(true) {
			pwszBreak = wcspbrk(pwszBuffer + iLast, CEditDoc::m_wszBreakChars);
			if(pwszBreak != 0) {
				iNext = pwszBreak - pwszBuffer;
				// s̔
				switch(*pwszBreak) {
				case L'\n':	bt = BT_LF;	break;
				case L'\r':
					bt = (iNext + 1 < dwRead && *(pwszBreak + 1) == L'\n') ? BT_CRLF : BT_CR;
					break;
				case 0x0085:	bt = BT_NEL;break;
				case L'\x2028':	bt = BT_LS;	break;
				case L'\x2029':	bt = BT_PS;	break;
				}
				m_listLines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, iNext - iLast), bt));
				iLast = iNext + ((bt != BT_CRLF) ? 1 : 2);
			} else {	// ŏIs
				m_listLines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, dwRead - iLast)));
				break;
			}
		}
	} else {	// ̃t@C
		nCodePage = ::GetACP();
		m_listLines.clear();
		m_listLines.push_back(CEditDocLine());
		InsertText(0, CCharPos(0, 0), L"");
		m_listLines.begin()->m_cOperationHistory = 0;
	}

	m_itCache_ = m_listLines.end();
	m_itCache = m_listLines.end();

	// sR[h̔ (_ł͍ŏɌꂽ̂g)
	if(dwFileSize != 0) {
		pwszFirstBreak = wcspbrk(pwszBuffer, CEditDoc::m_wszBreakChars);
		if(pwszFirstBreak == 0)
			m_breakType = BT_CRLF;
		else if(*pwszFirstBreak == L'\n')
			m_breakType = BT_LF;
		else if(*pwszFirstBreak == L'\r')
			m_breakType = (*(pwszFirstBreak + 1) == L'\n') ? BT_CRLF : BT_CR;
		else if(*pwszFirstBreak == 0x0085)
			m_breakType = BT_NEL;
		else if(*pwszFirstBreak == L'\x2028')
			m_breakType = BT_LS;
		else if(*pwszFirstBreak == L'\x2029')
			m_breakType = BT_PS;
	} else
		m_breakType = BT_CRLF;

	::GlobalUnlock(hGlobal2);
	::GlobalFree(hGlobal2);
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	// t@C̃bN
	try {
		if(fom == FOM_DENYNONE || fom == FOM_ASREADONLY)
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
		else if(fom == FOM_DENYWRITE)
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyWrite);
		else	/* fom == FOM_DENYWRITE */
			m_oFile.Open(wszPathName,
				CFile::modeRead | CFile::modeWrite | CFile::shareDenyRead | CFile::shareDenyWrite);
	} catch(CFileException& e) {
		ss = SS_LOCKDENIED;
	}

	m_nCodePage = nCodePage;
	ClearUndoBuffer();
	m_bModified = false;
	m_ugsGroupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;
	m_strPathName = wszPathName;
	m_strTitle = ::PathFindFileNameW(wszPathName);

	SetupAllViews();	// r[ɒʒm

	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();

	return ss;
}

/**
 *	݂̊JĂt@Cw肵@ŃbNBǂݎp͖
 *	@param fom	r[hBFOM_DENYWRITE AFOM_DENYREAD ̂ݗL
 *	@return		bNɐ true
 *	@see		CEditDoc::UnlockCurrentFile
 */
bool CEditDoc::LockCurrentFile(FileOpenMode fom) {
	AssertValid();

	if(fom != FOM_DENYWRITE && fom != FOM_DENYREAD)
		return false;
	if(m_strPathName.empty() || m_bReadOnly)
		return false;

	m_oFile.Close();
	if(m_oFile.Open(m_strPathName, CFile::modeReadWrite | ((fom == FOM_DENYWRITE) ?
			CFile::shareDenyWrite : CFile::shareDenyRead), false)) {
		m_fomMode = fom;
		return true;
	} else
		return false;
}

/**
 *	݊JĂt@Cړ
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::MoveCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	OperationStatus	ops = OPS_OK;
	UINT			nShareMode = 0;

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(::PathFileExistsW(pwszDestination))
		return OPS_ALREADYEXISTS;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:	nShareMode = CFile::shareDenyWrite;	break;
		case FOM_DENYREAD:	nShareMode = CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:nShareMode = CFile::shareDenyNone;	break;
	}

	m_oFile.Close();
	if(!::MoveFileW(m_strPathName.c_str(), pwszDestination))
		ops = OPS_UNKNOWNERROR;
	else {
		m_strPathName = pwszDestination;
		m_strTitle = ::PathFindFileNameW(pwszDestination);
	}
	if(!m_oFile.Open(m_strPathName, nShareMode | CFile::modeReadWrite | CFile::modeNoTruncate, false)) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fomMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	hD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Redo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetRedoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_oUpdateInfo.usSummary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Redo();
	EndEditCollection();
	m_oUpdateInfo.usSummary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);
}

/**
 *	hLg̕ۑ
 *	@param strPathName		t@C̃pX
 *	@param sdo				IvV
 *	@param bt				ꂷsR[h
 *	@param nCodePage		R[hy[WBȗƌ݂̃R[hy[Wgp
 *	@return					݌ʁB SS_OK
 */
StreamStatus CEditDoc::SaveDocument(const wstring& strPathName,
		SaveDocumentOption sdo, BreakType bt, UINT nCodePage /* = EXTCP_AUTO */) {
	AssertValid();

	// R[hy[WCXg[Ă邩
	if(nCodePage != EXTCP_AUTO && !IsAvailableCodePage(nCodePage))
		return SS_ILLEGALCODEPAGE;
	if(nCodePage == EXTCP_AUTO)	// ݂̃R[hy[Wg
		nCodePage = m_nCodePage;

	// ϊR[hy[Wŕ\łȂ邩
	if(!toBoolean(sdo & SDO_IGNORE_NOFITCHARS)
			&& nCodePage != EXTCP_UTF16LE
			&& nCodePage != EXTCP_UTF16BE
			&& nCodePage != EXTCP_UTF32LE
			&& nCodePage != EXTCP_UTF32BE
			&& nCodePage != EXTCP_UTF5
			&& nCodePage != 50221) {
		BOOL	bUsedDefaultChar = FALSE;
		wstring	strText;
		GetAllLines(strText);
		::WideCharToMultiByte(nCodePage, 0, strText.c_str(), strText.length(), 0, 0, 0, &bUsedDefaultChar);
		if(toBoolean(bUsedDefaultChar))
			return SS_WRITE_CONTAININVALIDCHAR;
	}

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;
	HGLOBAL			hGlobal = 0;
	char*			pszBuffer = 0;

	// fobO͏ɃobNAbv (㏑̏ꍇ̂)
#ifdef _DEBUG
	if(::PathFileExistsW(strPathName.c_str())) {
		wchar_t	wszBackupPath[MAX_PATH + 1];
		SHFILEOPSTRUCTW	shfos = {
			0, FO_DELETE, wszBackupPath, 0, FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT, false, 0
		};
		wcscpy(wszBackupPath, strPathName.c_str());
		wcscat(wszBackupPath, L".bak");
		*(wszBackupPath + wcslen(wszBackupPath) + 1) = 0;
		::CopyFileW(strPathName.c_str(), wszBackupPath, false);
		::SHFileOperationW(&shfos);	// ݔɎĂ
	}
#endif

	// Vt@CJ
	try {
		if(m_oFile.IsOpened())
			m_oFile.Close();
		m_oFile.Open(strPathName, CFile::modeReadWrite | CFile::shareDenyWrite | CFile::modeCreate);
	} catch(CFileException& e) {	// ߂Ȃꍇ͈ȑÕt@CJȂ
		m_oFile.Open(m_strPathName, (m_bReadOnly ? CFile::modeRead : CFile::modeReadWrite)
			| CFile::shareDenyWrite | CFile::modeCreate | CFile::modeNoTruncate);
		return SS_UNKNOWNERROR;
	}

	// BOM
	if(toBoolean(sdo & SDO_WRITE_BOM)) {
		if(nCodePage == EXTCP_UTF16LE) {
			unsigned char	pszBOM[] = {0xFF, 0xFE};
			m_oFile.Write(pszBOM, 2);
		} else if(nCodePage == EXTCP_UTF16BE) {
			unsigned char	pszBOM[] = {0xFE, 0xFF};
			m_oFile.Write(pszBOM, 2);
		} else if(nCodePage == CP_UTF8) {
			unsigned char	pszBOM[] = {0xEF, 0xBB, 0xBF};
			m_oFile.Write(pszBOM, 3);
		} else if(nCodePage == EXTCP_UTF32LE) {
			unsigned char	pszBOM[] = {0xFF, 0xFE, 0x00, 0x00};
			m_oFile.Write(pszBOM, 4);
		} else if(nCodePage == EXTCP_UTF32BE) {
			unsigned char	pszBOM[] = {0x00, 0x00, 0xFE, 0xFF};
			m_oFile.Write(pszBOM, 4);
		} else if(nCodePage == 50225) {	// ISO-2022-KR
			unsigned char	pszBOM[] = {0x1B, 0x24, 0x29, 0x43};
			m_oFile.Write(pszBOM, 4);
		} else if(nCodePage == 50227 || nCodePage == 50229) {	// ISO-2022-CN
			unsigned char	pszBOM[] = {0x1B, 0x24, 0x29, 0x41};
			m_oFile.Write(pszBOM, 4);
		}
	}

	// sR[ȟ
	if(bt != BT_AUTO)
		m_breakType = bt;

	// 1sϊĂ珑
	CEditDocLineList::iterator	it = m_listLines.begin();
	unsigned long				cLine = GetLineCount();	// s
	unsigned long				cchLine;				// R[hϊO̒
	unsigned long				len;					// R[hϊ̒
	wstring						strLine;				// 1s
	CharCode					cc;

	for(unsigned long iLine = 0; iLine < cLine; ++iLine, ++it) {
		it->m_cOperationHistory = 0;	// 엚
		if(bt != BT_AUTO)
			it->m_breakType = bt;		// sR[h㏑
		strLine = it->m_strLine;
		if(iLine != cLine - 1)
			strLine += GetBreakString(it->m_breakType);

		// R[h̕ϊ
		cchLine = GetLineLength(iLine);
		if(iLine == cLine - 1) {	// ŏIs
			if(cchLine == 0)
				break;
		} else
			cchLine += (((bt == BT_AUTO) ? it->m_breakType : m_breakType) == BT_CRLF) ? 2 : 1;
		switch(nCodePage) {
		case EXTCP_UTF16LE:
			cc = CC_UTF16LE;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 2);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case EXTCP_UTF16BE:
			cc = CC_UTF16BE;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 2);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case CP_UTF8:
			cc = CC_UTF8;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 3);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case EXTCP_UTF32LE:
			cc = CC_UTF32LE;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 2);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case EXTCP_UTF32BE:
			cc = CC_UTF32BE;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 2);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case EXTCP_UTF5:
			cc = CC_UTF5;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 4);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case 932:	// Shift-JIS
			cc = CC_SHIFTJIS;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 3);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case EXTCP_EUCJP:
			cc = CC_EUCJP;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 2);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		case 50221:	// JIS
			cc = CC_JIS;
			hGlobal = ::GlobalAlloc(GHND, cchLine * sizeof(wchar_t) * 3);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ConvertUnicodeTo(cc, pszBuffer, strLine.c_str(), 0, cchLine);
			break;
		default:
			len = ::WideCharToMultiByte(nCodePage, 0,
					strLine.c_str(), cchLine, 0, 0, 0, 0);
			hGlobal = ::GlobalAlloc(GHND, len);
			pszBuffer = reinterpret_cast<char*>(::GlobalLock(hGlobal));
			len = ::WideCharToMultiByte(nCodePage, 0,
					strLine.c_str(), cchLine, pszBuffer, len, 0, 0);
			break;
		}
		m_oFile.Write(pszBuffer, len);
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
	}

	m_oFile.Close();

	// t@C̃bN
	try {
		if(m_fomMode == FOM_DENYWRITE || m_fomMode == FOM_DENYREAD) {
			if(!LockCurrentFile(m_fomMode))
				ss = SS_LOCKDENIED;
		}
	} catch(CFileException& e) {
		ss = SS_LOCKDENIED;
	}

	m_bModified = false;
	m_bReadOnly = false;
	m_breakType = (bt != BT_AUTO) ? bt : m_breakType;
	m_nCodePage = nCodePage;
	m_strPathName = strPathName;
	m_strTitle = m_strPathName.substr(m_strPathName.rfind(L'\\') + 1);

	// ŏIXV̍XV
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind != INVALID_HANDLE_VALUE) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		::FindClose(hFind);
	}

	// r[ɒʒm
	m_oUpdateInfo.usSummary = US_SAVEDOCUMENT;
	UpdateAllViews(this, 0, this);

	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();
	return ss;
}

/**
 *	݂̃t@C[֑M
 *	@param bAsAttachment	Ytt@CƂđM邩ǂBYtt@Cɂꍇ
 *							݂̕ύX͔fȂB{ƂđMꍇ݂͌̃hLggp
 *	@param bShowDialog		[UI_CAO\邩ǂ
 *	@return					
 */
bool CEditDoc::SendCurrentFile(bool bAsAttachment, bool bShowDialog /* = true */) {
	AssertValid();

	if(bAsAttachment && m_strPathName.empty())
		return false;

	HINSTANCE		hInstance;
	MAPISENDMAIL*	lpfnMAPISendMail;
	MapiMessage		msg;
	MapiFileDesc	fileDesc;
	char			szFilePath[MAX_PATH];
	char*			pszContent = 0;
	wchar_t*		pwszContent = 0;
	unsigned long	cchDocument;
	unsigned long	nErr;
	CWaitCursor		wc;
	
	hInstance = ::LoadLibraryA("MAPI32.DLL");
	if(hInstance == 0)
		return false;
	reinterpret_cast<FARPROC&>(lpfnMAPISendMail) = ::GetProcAddress(hInstance, "MAPISendMail");
	if(lpfnMAPISendMail == 0) {
		::FreeLibrary(hInstance);
		return false;
	}


	ZeroMemory(&msg, sizeof(MapiMessage));
	msg.flFlags = MAPI_RECEIPT_REQUESTED;

	if(bAsAttachment) {	// Ytt@CɂƂ
		setlocale(LC_CTYPE, "");
		int	cConverted = wcstombs(szFilePath, m_strPathName.c_str(), MAX_PATH);
		assert(cConverted != -1);
		*(szFilePath + cConverted) = 0;
		msg.nFileCount = 1;
		msg.lpFiles = &fileDesc;

		ZeroMemory(&fileDesc, sizeof(MapiFileDesc));
		fileDesc.lpszPathName = szFilePath;
		fileDesc.nPosition = static_cast<unsigned long>(-1);
	} else {	// {ƂđMƂ
		unsigned long	i = 0;
		unsigned long	iLine = 0;
		LineIterator	it;
		CEditDocLine	oLine;

		cchDocument = GetDocumentLength();
		pwszContent = new wchar_t[cchDocument + 1];

		for(it = m_listLines.begin(); ; ++it, ++iLine) {
			oLine = *it;
			wcsncpy(pwszContent + i, oLine.m_strLine.c_str(), oLine.m_strLine.length());
			i += oLine.m_strLine.length();
			if(iLine != m_listLines.size() - 1) {
				wcscpy(pwszContent + i, GetBreakString(oLine.m_breakType).c_str());
				i += GetBreakString(oLine.m_breakType).length();
			} else
				break;
		}
		*(pwszContent + cchDocument) = 0;

		// }`oCgɕϊ
		setlocale(LC_CTYPE, "");
		size_t	cchContent = wcstombs(0, pwszContent, 0);
		pszContent = new char[cchContent + 1];
		wcstombs(pszContent, pwszContent, cchContent);
		*(pszContent + cchContent) = 0;
		msg.lpszNoteText = pszContent;
		delete[] pwszContent;
		pwszContent = 0;
	}

	nErr = lpfnMAPISendMail(0, 0, &msg, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
	if(pszContent != 0) {
		delete[] pszContent;
		pszContent = 0;
	}
	::FreeLibrary(hInstance);

	if(nErr != SUCCESS_SUCCESS
			&& nErr != MAPI_USER_ABORT
			&& nErr != MAPI_E_LOGIN_FAILURE)
		return false;
	return true;
}

/**
 *	sR[h̐ݒ
 *	@param breakType		Vݒ肷sR[h
 *	@throw invalid_argument	sR[hȂƂX[
 */
void CEditDoc::SetBreakType(BreakType breakType) {
	AssertValid();
	switch(breakType) {
	case BT_LF:
	case BT_CR:
	case BT_CRLF:
	case BT_NEL:
	case BT_LS:
	case BT_PS:
		m_breakType = breakType;
		break;
	default:
		throw invalid_argument("Specified break type is invalid.");
	}
}

/**
 *	R[hy[W̐ݒ
 *	@param nCodePage		Vݒ肷R[hy[Wԍ
 *	@throw invalid_argument	R[hy[WpłȂƂX[
 */
void CEditDoc::SetCodePage(UINT nCodePage) throw(invalid_argument) {
	AssertValid();
	if(!IsAvailableCodePage(nCodePage))
		throw invalid_argument("Specified code page is not available.");
	m_nCodePage = nCodePage;
}

/**
 *	CxgXi̐ݒ
 *	@param pEventListener	VCxgXi (null ł悢)
 */
void CEditDoc::SetEventListener(IEditDocEventListener* pEventListener) {
	AssertValid();
	m_pEventListener = pEventListener;
}

///	ǂݎp[h̐ݒ
void CEditDoc::SetReadOnly(bool bReadOnly /* = true */) {
	AssertValid();
	m_bReadOnly = bReadOnly;
	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();
}

///	::SetTimer ̃R[obN֐B1000~bƂɌĂяoA
///	t@CvZXŕύXĂȂĎ
void CALLBACK CEditDoc::TimerProc(HWND hWnd, UINT nMsg, UINT_PTR idEvent, DWORD dwTime) {
	map<UINT, CEditDoc*>::iterator	it = CEditDoc::m_mapDocuments.find(idEvent);

	if(it != CEditDoc::m_mapDocuments.end())
		it->second->CheckFileLastWriteTime();
}

/**
 *	AhD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Undo() {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetUndoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_oUpdateInfo.usSummary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Undo();
	EndEditCollection();
	m_oUpdateInfo.usSummary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);

	if(!m_bOnceUndoBufferCleared && m_pUndoManager->GetUndoBufferLength() == 0) {
		m_bModified = false;
	if(m_pEventListener != 0)
		m_pEventListener->OnDocumentModified();
	}
}

///	hLgV쐬ƂɌĂяo
bool CEditDoc::OnNewDocument() {
	return true;
}

///	hLgǂݍ݂̂߂Ƀt@CJƂɌĂяo
bool CEditDoc::OnOpenDocument(const wstring& strPathName) {
	return true;
}

///	hLgۑƂɌĂяo
bool CEditDoc::OnSaveDocument(const wstring& strPathName) {
	return true;
}

/* [EOF] */