// AlphaView.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AlphaView.h"
#include "Ambient.h"
using Alpha::CAlphaView;


// CAlphaView class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaView::CAlphaView() : m_pAutomationProcessor(0), m_pAutomationSelection(0) {
}

///	Rs[RXgN^
CAlphaView::CAlphaView(const CAlphaView& rhs)
		: CEditView(rhs), m_pAutomationProcessor(0), m_pAutomationSelection(0) {
}

///	fXgN^
CAlphaView::~CAlphaView() {
	if(m_pAutomationProcessor != 0)
		m_pAutomationProcessor->Release();
	if(m_pAutomationSelection != 0)
		m_pAutomationSelection->Release();
}

/**
 *	r[̌JI[g[VIuWFNgԂ
 *	@param riid			IuWFNg IIDBIID_ITextProcessor AIID_ITextSelection ̂
 *	@param pApp			AvP[VIuWFNg
 *	@param ppAutomation	[out] ߂l
 */
void CAlphaView::GetAutomation(REFIID riid, Alpha::CAlphaApp* pApp, IDispatch** ppAutomation) {
	AssertValid();
	assert(ppAutomation != 0);

	if(riid == IID_ITextProcessor) {
		if(m_pAutomationProcessor == 0) {
			m_pAutomationProcessor = new Alpha::Ambient::CTextProcessor(pApp, this);
			m_pAutomationProcessor->AddRef();
		}
		*ppAutomation = m_pAutomationProcessor;
	} else if(riid == IID_ITextSelection) {
		if(m_pAutomationSelection == 0) {
			m_pAutomationSelection = new Alpha::Ambient::CTextSelection(pApp, this);
			m_pAutomationSelection->AddRef();
		}
		*ppAutomation = m_pAutomationSelection;
	} else
		assert(false);
	(*ppAutomation)->AddRef();
}

///	݈ʒu\Ԃ
const wchar_t* CAlphaView::GetCurrentPositionString() const {
	AssertValid();

	static wchar_t	wsz[40];
	CCharPos		posBegin, posEnd;

	GetSel(posBegin, posEnd);
	swprintf(wsz, L"%lu s A %lu  A %lu ",
		posEnd.m_iLine + 1, ColumnFromChar(posEnd) + 1, posEnd.m_iChar + 1);
	return wsz;
}

/* [EOF] */