// AlphaTabCtrl.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AlphaTabCtrl.h"
#include "resource.h"
using Alpha::CAlphaTabCtrl;


// CAlphaTabCtrl class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	^uEBhE쐬
 *	@param hwndParent	eEBhE
 *	@param rect			Rg[̋`
 *	@param nID			Rg[ ID
 *	@return				
 */
bool CAlphaTabCtrl::Create(HWND hwndParent, const RECT& rect, UINT nID) {
	AssertValid();

	if(!CTabCtrl::Create(true,
			WS_CHILD | WS_CLIPSIBLINGS | TCS_HOTTRACK | TCS_FOCUSNEVER | TCS_TOOLTIPS,
			&rect, hwndParent, nID))
		return false;

	SIZE	sizePad = {3, 3};
	SetExtendedStyle(TCS_EX_REGISTERDROP);
	SetPadding(sizePad);
	ShowWindow(SW_SHOW);

	return true;
}

///	@see	CTabCtrl::DispatchEvent
LRESULT CAlphaTabCtrl::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_CONTEXTMENU:
		m_oContextMenu.TrackPopupMenu(
			TPM_LEFTALIGN, LOWORD(lParam), HIWORD(lParam), GetParent()->m_hWnd);
		return 0L;
	case WM_RBUTTONDOWN:	// ANeBuȃyCς
		SendMessage(WM_LBUTTONDOWN, wParam, lParam);
		break;
	}

	return CTabCtrl::DispatchEvent(message, wParam, lParam);
}

///	@see	IDropTarget::DragEnter
STDMETHODIMP CAlphaTabCtrl::DragEnter(
		IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
/*	IEnumFORMATETC*	pEnum = 0;
	if(S_OK == pDataObj->EnumFormatEtc(DATADIR_GET, &pEnum)) {
		FORMATETC	fe;
		while(S_OK == pEnum->Next(1, &fe, 0)) {
			fe;
		}
		pEnum->Release();
	}*/
	return E_NOTIMPL;
}

///	@see	IDropTarget::DragLeave
STDMETHODIMP CAlphaTabCtrl::DragLeave() {
	return E_NOTIMPL;
}

///	@see	IDropTarget::DragOver
STDMETHODIMP CAlphaTabCtrl::DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	return E_NOTIMPL;
}

///	@see	IDropTarget::Drop
STDMETHODIMP CAlphaTabCtrl::Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	return E_NOTIMPL;
}

///	@see	IDropSource::GiveFeedback
STDMETHODIMP CAlphaTabCtrl::GiveFeedback(DWORD dwEffect) {
	return E_NOTIMPL;
}

///	@see	IDropSource::QueryContinueDrag
STDMETHODIMP CAlphaTabCtrl::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState) {
	return E_NOTIMPL;
}

///	@see	CWindow::OnLButtonDblClk
void CAlphaTabCtrl::OnLButtonDblClk(UINT nFlags, POINT pt) {
	::SendMessage(::GetParent(m_hWnd), WM_COMMAND, IDCM_FILE_CLOSE, reinterpret_cast<LPARAM>(m_hWnd));
}

/* [EOF] */