// AlphaScriptHost.h
// (c) 2003 exeal

#ifndef _ALPHA_SCRIPT_HOST_H_
#define _ALPHA_SCRIPT_HOST_H_

#include <activscp.h>				// IActiveScriptSite, IActiveScriptSiteWindow
#include <activdbg.h>				// IActiveScriptSiteDebug
#include "AmbientIdl.h"				// generated from AlphaApp.idl
#include "..\Armaiti\UnknownImpl.h"
#include <map>
using namespace Armaiti;

namespace Alpha {

namespace Ambient {
class CScriptHost;
}
typedef map<wstring, IDispatch*>	MemberTable;

///	XNvgzXg
class CAlphaScriptHost :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IActiveScriptSite,
		public IActiveScriptSiteWindow,
		public IActiveScriptSiteDebug {
	// RXgN^
public:
	CAlphaScriptHost(HWND hWnd,
		IActiveScript* pScriptEngine, IDebugApplication* pDebugApplication = 0);
	virtual ~CAlphaScriptHost();

	// \bh
public:
	void	AddTopLevelObject(LPCOLESTR lpstrObjectName, IDispatch* pObject);
	void	AllowErrorReport(bool bAllow);
	void	GetAutomationHostObject(IScriptHost** ppScriptHost) const;
	bool	IsErrorReportedAtLastParse() const;
	void	RunEventSinks(IDispatch* pScriptObject);
	void	SetScriptPath(const wchar_t* pwszScriptPath);

	// IUnknown \bh
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IActiveScriptSite)
		IMPLEMENTS_INTERFACE(IActiveScriptSiteWindow)
		IMPLEMENTS_INTERFACE(IActiveScriptSiteDebug)
	END_INTERFACE_TABLE()

	// IActiveScriptSite \bh
	STDMETHODIMP	GetLCID(LCID* plcid);
	STDMETHODIMP	GetItemInfo(LPCOLESTR pstrName,
						DWORD dwReturnMask, IUnknown** ppiunkItem, ITypeInfo** ppti);
	STDMETHODIMP	GetDocVersionString(BSTR* pbstrVersion);
	STDMETHODIMP	OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo);
	STDMETHODIMP	OnStateChange(SCRIPTSTATE ssScriptState);
	STDMETHODIMP	OnScriptError(IActiveScriptError* pscripterror);
	STDMETHODIMP	OnEnterScript();
	STDMETHODIMP	OnLeaveScript();

	// IActiveScriptSiteWindow \bh
	STDMETHODIMP	GetWindow(HWND* phwnd);
	STDMETHODIMP	EnableModeless(BOOL fEnable);

	// IActiveScriptSiteDebug \bh
	STDMETHODIMP	GetDocumentContextFromPosition(DWORD dwSourceContext,
						ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc);
	STDMETHODIMP	GetApplication(IDebugApplication** ppda);
	STDMETHODIMP	GetRootApplicationNode(IDebugApplicationNode** ppdanRoot);
	STDMETHODIMP	OnScriptErrorDebug(IActiveScriptErrorDebug* pErrorDebug,
						BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing);

	// f[^o
private:
	Ambient::CScriptHost*	m_pAutomation;				// XNvgɌJzXg
	HWND					m_hOwnerWindow;				// zXgEBhE
	MemberTable				m_mapTopLevelObjects;		// gbvxIuWFNg
	IActiveScript*			m_pScriptEngine;
	IDebugApplication*		m_pDebugApplication;
	mutable bool			m_bIsErrorReported;			// IsErrorReportedAtLastParse Q
	bool					m_bAllowedErrorReport;		// AllowErrorReport Q
};

}

#endif /* _ALPHA_SCRIPT_HOST_ */

/* [EOF] */