// AlphaApplicationObject.h
// (c) 2003 exeal

#ifndef _ALPHA_APPLICATION_OBJECT_H_
#define _ALPHA_APPLICATION_OBJECT_H_

#include "AlphaApp.h"	// generated from AlphaApp.idl
#include "AdhocEventSink.h"
#include "Alpha.h"
#include "..\Armaiti\ArmaitiImplementation.h"
using namespace Armaiti;
using namespace Armaiti::OLE;

#define	ASH_HOSTNAME		OLESTR("Alpha Script Host")
#define ASH_VERSION			OLESTR("0.5")
#define ASH_BUILDVERSION	0


namespace Alpha {

class CAlphaApp;
class CAlphaDoc;
class CAlphaView;


namespace Ambient {

// CAlphaTypeLibPath class definition and implementation
/////////////////////////////////////////////////////////////////////////////

///	^CvCũpXێ
class CAlphaTypeLibPath {
public:
	static const OLECHAR*	GetPath() {
		return OLESTR("AlphaApp.tlb");
	}
};


// CApplication class definition
/////////////////////////////////////////////////////////////////////////////

///	IApplication ̎
class CApplication :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<
			IApplication, CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IApplication>
		>,
		public ISupportErrorInfoImpl<&IID_IApplication>//,
/*		public IProvideClassInfo2Impl<&CLSID_Application, &IID_IApplication, &LIBID_Alpha>*/ {
	friend class CAlphaDoc;
	friend class CAlphaView;
	friend class CAlphaApp;

	// RXgN^
public:
	CApplication(CAlphaApp* pApp, const vector<wstring>* pvecArguments = 0);
	~CApplication();

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IApplication)
//		IMPLEMENTS_INTERFACE(IDispatchEx)
		IMPLEMENTS_INTERFACE(IDispatch)
		IMPLEMENTS_INTERFACE(ISupportErrorInfo)
//		IMPLEMENTS_INTERFACE(IProvideClassInfo2)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// IApplication C^[tFCX
    STDMETHODIMP	get_Active(VARIANT_BOOL* pbActive);
    STDMETHODIMP	put_Active(VARIANT_BOOL bActive);
    STDMETHODIMP	get_ActiveDocument(IDocument** ppActiveDocument);
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_CurrentDirectory(BSTR* pbstrDirectory);
    STDMETHODIMP	put_CurrentDirectory(BSTR bstrDirectory);
	STDMETHODIMP	get_Debugger(IDebugger** ppDebugger);
    STDMETHODIMP	get_Documents(IDocuments** ppDocuments);
	STDMETHODIMP	get_FullName(BSTR* pbstrFullName);
    STDMETHODIMP	get_Height(long* pnHeight);
    STDMETHODIMP	put_Height(long nHeight);
    STDMETHODIMP	get_Left(long* pnLeft);
    STDMETHODIMP	put_Left(long nLeft);
	STDMETHODIMP	get_Name(BSTR* pbstrName);
    STDMETHODIMP	get_Top(long* pnTop);
    STDMETHODIMP	put_Top(long nTop);
	STDMETHODIMP	get_Version(BSTR* pbstrVersion);
    STDMETHODIMP	get_Visible(VARIANT_BOOL* pbVisible);
    STDMETHODIMP	put_Visible(VARIANT_BOOL bVisible);
    STDMETHODIMP	get_Width(long* pnWidth);
    STDMETHODIMP	put_Width(long nWidth);
    STDMETHODIMP	get_WindowState(AlphaWindowState* palphaWindowState);
    STDMETHODIMP	put_WindowState(AlphaWindowState alphaWindowState);
	STDMETHODIMP	ClearOutput();
	STDMETHODIMP	Quit(short nErrorCode = 0);
	STDMETHODIMP	WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate);
	STDMETHODIMP	WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate);

	// f[^o
private:
	CAlphaApp*	m_pApp;
};


// CDocuments class definition
/////////////////////////////////////////////////////////////////////////

///	IDocuments ̎
class CDocuments : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IDocuments,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IDocuments>
		> {
	// RXgN^
public:
	CDocuments(CAlphaApp* pApp);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDocuments)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// IDocuments C^[tFCX
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_Count(long* pnCount);
    STDMETHODIMP	AddNew();
    STDMETHODIMP	CloseAll();
    STDMETHODIMP	Item(long iDocument, IDocument** ppDocument);
    STDMETHODIMP	Open(BSTR bstrPathName, AlphaFileShareMode nShareMode, long nCodePage = 0);
    STDMETHODIMP	SaveAll();

	// f[^o
private:
	CAlphaApp*	m_pApp;
};


// CTextDocument class definition
////////////////////////////////////////////////////////////////////////////

///	ITextDocument ̎
class CTextDocument :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<ITextDocument,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_ITextDocument>
		> {
	// RXgN^
public:
	CTextDocument(CAlphaApp* pApp, CAlphaDoc* pDocument);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(ITextDocument)
		IMPLEMENTS_INTERFACE(IDocument)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// IDocument C^[tFCX
    STDMETHODIMP	get_Active(VARIANT_BOOL* pbActive);
    STDMETHODIMP	put_Active(VARIANT_BOOL bActive);
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_BreakType(AlphaBreakType* pBreakType);
    STDMETHODIMP	put_BreakType(AlphaBreakType breakType);
    STDMETHODIMP	get_CodePage(long* pnCodePage);
    STDMETHODIMP	put_CodePage(long nCodePage);
    STDMETHODIMP	get_FileName(BSTR* pbstrFileName);
    STDMETHODIMP	get_FilePath(BSTR* pbstrFilePath);
    STDMETHODIMP	get_Modified(VARIANT_BOOL* pbModified);
    STDMETHODIMP	put_Modified(VARIANT_BOOL bModified);
    STDMETHODIMP	get_ReadOnly(VARIANT_BOOL* pbReadOnly);
    STDMETHODIMP	put_ReadOnly(VARIANT_BOOL bReadOnly);
    STDMETHODIMP	ClearUndoBuffer();
    STDMETHODIMP	Close(VARIANT_BOOL bConfirm = VARIANT_TRUE);
    STDMETHODIMP	Redo();
    STDMETHODIMP	Save(BSTR bstrFileName, AlphaBreakType breakType = ABT_AUTO, long nCodePage = 0);
    STDMETHODIMP	Undo();

	// ITextDocument C^[tFCX
	STDMETHODIMP	get_EndPoint(ITextPoint** ppEndPoint);
	STDMETHODIMP	get_StartPoint(ITextPoint** ppStartPoint);
	STDMETHODIMP	get_TextProcessor(ITextProcessor** ppTextProcessor);

protected:
	unsigned int	FindDocument() const;

	// f[^o
private:
	CAlphaApp*	m_pApp;
	CAlphaDoc*	m_pDocument;
};


// CTextProcessor class definition
/////////////////////////////////////////////////////////////////////////

///	ITextProcessor ̎
class CTextProcessor : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<ITextProcessor,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_ITextProcessor>
		> {
	// RXgN^
public:
	CTextProcessor(CAlphaApp* pApp, CAlphaView* pView);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(ITextProcessor)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// ITextProcessor C^[tFCX
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_OvertypeMode(VARIANT_BOOL* pbOvertypeMode);
    STDMETHODIMP	put_OvertypeMode(VARIANT_BOOL bOvertypeMode);
    STDMETHODIMP	get_Selection(ITextSelection** ppSelection);
    STDMETHODIMP	get_TabWidth(short* pnTabWidth);
    STDMETHODIMP	put_TabWidth(short nTabWidth);
    STDMETHODIMP	BackSpace();
	STDMETHODIMP	CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint);
    STDMETHODIMP	Delete();
    STDMETHODIMP	FindText(BSTR bstrFindWhat, AlphaFindTextFlags ftf,VARIANT_BOOL* pbFound);
    STDMETHODIMP	Indent();
    STDMETHODIMP	NewLine();
    STDMETHODIMP	Paste();
    STDMETHODIMP	Unindent();

	// f[^o
private:
	CAlphaApp*	m_pApp;
	CAlphaView*	m_pView;
};


// CTextSelection class definition
/////////////////////////////////////////////////////////////////////////

///	ITextSelection ̎
class CTextSelection : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<ITextSelection,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_ITextSelection>
		> {
	// RXgN^
public:
	CTextSelection(CAlphaApp* pApp, CAlphaView* pView);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(ITextSelection)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// ITextSelection C^[tFCX
	STDMETHODIMP	get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater);
	STDMETHODIMP	get_ActivePoint(ITextPoint** ppActivePoint);
	STDMETHODIMP	get_AnchorPoint(ITextPoint** ppAnchorPoint);
    STDMETHODIMP	get_Application(IApplication** ppApplication);
	STDMETHODIMP	get_BottomPoint(ITextPoint** ppBottomPoint);
	STDMETHODIMP	get_Empty(VARIANT_BOOL* pbEmpty);
	STDMETHODIMP	get_Text(BSTR* pbstrText);
	STDMETHODIMP	get_TextRanges(ITextRanges** ppTextRanges);
	STDMETHODIMP	get_TopPoint(ITextPoint** ppTopPoint);
    STDMETHODIMP	Cancel();
    STDMETHODIMP	CharNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long nOffset = 1);
    STDMETHODIMP	CharPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long nOffset = 1);
    STDMETHODIMP	Copy();
    STDMETHODIMP	Cut();
    STDMETHODIMP	GoToEndOfDocument(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	GoToEndOfLine(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	GoToNextBookmark(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	GoToPreviousBookmark(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	GoToStartOfDocument(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	GoToStartOfLine(VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	LineDown(VARIANT_BOOL bExtend = VARIANT_FALSE, long cLines = 1);
    STDMETHODIMP	LineUp(VARIANT_BOOL bExtend = VARIANT_FALSE, long cLines = 1);
	STDMETHODIMP	MakeCapital();
	STDMETHODIMP	MakeLower();
	STDMETHODIMP	MakeUpper();
    STDMETHODIMP	MoveTo(long iLine, long iChar, VARIANT_BOOL bExtend = VARIANT_FALSE);
    STDMETHODIMP	PageDown(VARIANT_BOOL bExtend = VARIANT_FALSE, long cPages = 1);
    STDMETHODIMP	PageUp(VARIANT_BOOL bExtend = VARIANT_FALSE, long cPages = 1);
	STDMETHODIMP	Paste();
    STDMETHODIMP	Replace(BSTR bstrText, AlphaOperationConcatenationFlag nFlags = AOCF_PREVENTALL);
    STDMETHODIMP	SelectAll();
    STDMETHODIMP	SelectLine(long iLine);
	STDMETHODIMP	SwapAnchor();
	STDMETHODIMP	Tabify();
	STDMETHODIMP	Untabify();
    STDMETHODIMP	WordEndNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
    STDMETHODIMP	WordEndPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
    STDMETHODIMP	WordNext(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);
    STDMETHODIMP	WordPrev(VARIANT_BOOL bExtend = VARIANT_FALSE, long cWords = 1);

	// f[^o
private:
	CAlphaApp*	m_pApp;
	CAlphaView*	m_pView;
};


// CTextPoint class definition
/////////////////////////////////////////////////////////////////////////

///	ITextPoint ̎
class CTextPoint :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<ITextPoint,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_ITextPoint>
		> {
	// RXgN^
public:
	CTextPoint(CAlphaApp* pApp, CEditPoint* pos);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(ITextPoint)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// ITextPoint C^[tFCX
	STDMETHODIMP	get_AbsoluteCharOffset(long* pnAbsoluteCharOffset);
	STDMETHODIMP	get_Application(IApplication** ppApplication);
	STDMETHODIMP	get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument);
	STDMETHODIMP	get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine);
	STDMETHODIMP	get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument);
	STDMETHODIMP	get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine);
	STDMETHODIMP	get_Char(long* pnChar);
	STDMETHODIMP	get_Column(long* pnColumn);
	STDMETHODIMP	get_Line(long* pnLine);
	STDMETHODIMP	get_LineLength(long* pnLineLength);
	STDMETHODIMP	CharNext(long nOffset = 1);
	STDMETHODIMP	CharPrev(long nOffset = 1);
	STDMETHODIMP	CreateEditPoint(IEditPoint** ppEditPoint);
	STDMETHODIMP	EnsureVisible();
	STDMETHODIMP	EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual);
	STDMETHODIMP	GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater);
	STDMETHODIMP	LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess);
	STDMETHODIMP	LineDown(long nLines = 1);
	STDMETHODIMP	LineUp(long nLines = 1);
	STDMETHODIMP	MoveTo(long iLine, long iChar);
	STDMETHODIMP	MoveToAbsoluteOffset(long nOffset);
	STDMETHODIMP	MoveToEndOfDocument();
	STDMETHODIMP	MoveToEndOfLine();
	STDMETHODIMP	MoveToNextBookmark();
	STDMETHODIMP	MoveToPreviousBookmark();
	STDMETHODIMP	MoveToStartOfDocument();
	STDMETHODIMP	MoveToStartOfLine();
	STDMETHODIMP	WordEndNext(long cWords = 1);
	STDMETHODIMP	WordEndPrev(long cWords = 1);
	STDMETHODIMP	WordNext(long cWords = 1);
	STDMETHODIMP	WordPrev(long cWords = 1);

	// f[^o
private:
	CAlphaApp*	m_pApp;
	CEditPoint*	m_pos;
};


// CTextRange class definition
/////////////////////////////////////////////////////////////////////////

///	ITextRange ̎
class CTextRange :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<ITextRange,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_ITextRange>
		> {
	// RXgN^
public:
	CTextRange(CAlphaApp* pApp, CEditPoint* p1, CEditPoint* p2);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(ITextRange)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// ITextRange C^[tFCX
	STDMETHODIMP	get_Application(IApplication** ppApplication);
	STDMETHODIMP	get_EndPoint(ITextPoint** ppEndPoint);
	STDMETHODIMP	get_StartPoint(ITextPoint **ppStartPoint);

	// f[^o
private:
	CAlphaApp*	m_pApp;
	CEditPoint*	m_pPoint1;
	CEditPoint*	m_pPoint2;
};


// CDebugger class definition
/////////////////////////////////////////////////////////////////////////

///	IDebugger ̎
class CDebugger :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IDebugger,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IDebugger>
		> {
	STDMETHODIMP	get_Application(IApplication** ppApplication);
	STDMETHODIMP	get_BreakPoints(IBreakPoints** ppBreakPoints);
	STDMETHODIMP	get_CurrentProcess(IProcess** ppCurrentProcess);
	STDMETHODIMP	get_CurrentStackFrame(IStackFrame** ppCurrentStackFrame);
	STDMETHODIMP	get_CurrentThread(IThread** ppCurrentThread);
	STDMETHODIMP	get_DebuggedProcesses(IProcesses** ppDebuggedProcesses);
	STDMETHODIMP	get_HexDisplayMode(VARIANT_BOOL* pbHexDisplayMode);
	STDMETHODIMP	put_HexDisplayMode(VARIANT_BOOL bHexDisplayMode);
	STDMETHODIMP	get_HexInputMode(VARIANT_BOOL* pbHexInputMode);
	STDMETHODIMP	put_HexInputMode(VARIANT_BOOL bHexInputMode);
	STDMETHODIMP	get_Languages(ILanguages** ppLanguages);
	STDMETHODIMP	get_LastBreakReason(AlphaBreakReason* pBreakReason);
	STDMETHODIMP	get_State(AlphaDebuggingState* pDebuggingState);
	STDMETHODIMP	Break();
	STDMETHODIMP	Evaluate(BSTR bstrExpression, VARIANT_BOOL bNoSideEffects, BSTR* pbstrResult);
	STDMETHODIMP	Go();
	STDMETHODIMP	RunToCursor();
	STDMETHODIMP	StepInto();
	STDMETHODIMP	StepOut();
	STDMETHODIMP	StepOver();
	STDMETHODIMP	Stop();
};


// CBreakPoints class definition
/////////////////////////////////////////////////////////////////////////

///	IBreakPoints ̎
class CBreakPoints : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IBreakPoints,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IBreakPoints>
		> {
public:
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_Count(long* pnCount);
    STDMETHODIMP	AddBreakPointAtLine(long iLine = -1);
    STDMETHODIMP	Item(long iBreakPoint, IBreakPoint** ppBreakPoint);
    STDMETHODIMP	RemoveAllBreakPoints(long iLine);
    STDMETHODIMP	RemoveBreakPointAtLine(long iLine = -1);
};


// CBreakPoint class definition
/////////////////////////////////////////////////////////////////////////

///	IBreakPoint ̎
class CBreakPoint : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IBreakPoint,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IBreakPoint>
		> {
public:
    STDMETHODIMP	get_Application(IApplication** ppApplication);
    STDMETHODIMP	get_Enabled(VARIANT_BOOL* pbEnabled);
    STDMETHODIMP	put_Enabled(VARIANT_BOOL bEnabled);
    STDMETHODIMP	get_FileName(BSTR* pbstrFileName);
    STDMETHODIMP	get_LineNumber(long* piLine);
    STDMETHODIMP	Remove();
};


// CAutomationScriptHost class definition
/////////////////////////////////////////////////////////////////////////////

///	IScriptHost ̎
class CAutomationScriptHost :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IScriptHost,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IScriptHost>
		>,
		public ISupportErrorInfoImpl<&IID_IScriptHost> {
	// RXgN^
public:
	CAutomationScriptHost(HWND hwndOwner);
	virtual ~CAutomationScriptHost();

	// \bh
public:
	void	RunEventSinks(IDispatch* pScriptObject);
	void	SetScriptPath(const wchar_t* pwszScriptPath);

	// IUnknown \bh
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IScriptHost)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch \bh
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// IScriptHost \bh
	STDMETHODIMP	ConnectObject(IDispatch* pObject, BSTR bstrPrefix);
	STDMETHODIMP	CreateObject(BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject);
	STDMETHODIMP	DisconnectObject(IDispatch* pObject);
	STDMETHODIMP	Echo(SAFEARRAY* parr);
	STDMETHODIMP	get_Arguments(IArguments** ppArguments);
	STDMETHODIMP	get_BuildVersion(short* pnBuildVersion);
	STDMETHODIMP	get_FullName(BSTR* pbstrFullName);
	STDMETHODIMP	get_Interactive(VARIANT_BOOL* pbInteractive);
	STDMETHODIMP	get_Name(BSTR* pbstrName);
	STDMETHODIMP	get_Path(BSTR* pbstrPath);
	STDMETHODIMP	get_ScriptFullName(BSTR* pbstrScriptFullName);
	STDMETHODIMP	get_ScriptName(BSTR* pbstrScriptName);
	STDMETHODIMP	get_StdErr(IDispatch** ppStdErr);
	STDMETHODIMP	get_StdIn(IDispatch** ppStdIn);
	STDMETHODIMP	get_StdOut(IDispatch** ppStdOut);
	STDMETHODIMP	get_Timeout(long* pnTimeout);
	STDMETHODIMP	get_Version(BSTR* pbstrVersion);
	STDMETHODIMP	GetObject(BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject);
	STDMETHODIMP	put_Interactive(VARIANT_BOOL bInteractive);
	STDMETHODIMP	put_Timeout(long nTimeout);
	STDMETHODIMP	Sleep(long nMilliseconds);
	STDMETHODIMP	Quit(short nExitCode = 0);

	// f[^o
private:
	map<IDispatch*, CAdhocEventSink*>	m_mapEventSinks;
	wchar_t								m_wszScriptPath[MAX_PATH];
	HWND								m_hwndOwner;
	bool								m_bInteractive;
	long								m_nTimeout;
};


// CArguments class definition
/////////////////////////////////////////////////////////////////////////

///	IArguments ̎
class CArguments : 
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IArguments,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IArguments>
		> {
	// RXgN^
public:
	CArguments(const vector<wstring>& vecArgs);

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IArguments)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// IArguments C^[tFCX
	STDMETHODIMP	get_Item(long nIndex, BSTR* pbstrArg);
	STDMETHODIMP	get_Length(long* pcArgs);
	STDMETHODIMP	get_Named(IDispatch** ppNamed);
	STDMETHODIMP	get_Unnamed(IDispatch** ppUnnamed);
	STDMETHODIMP	Count(long* pcArgs);
	STDMETHODIMP	_NewEnum(IUnknown** ppOut);
	STDMETHODIMP	ShowUsage();

	// f[^o
private:
	vector<wstring>	m_vecArgs;
};


// CNamedArguments class definition
/////////////////////////////////////////////////////////////////////////////

///	INamedArguments ̎
class CNamedArguments :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<INamedArguments,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_INamedArguments>
		> {
	// RXgN^
public:
	CNamedArguments(const map<wstring, wstring>& mapNamedArguments);

public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(INamedArguments)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// INamedArguments C^[tFCX
	STDMETHODIMP	get_Item(BSTR bstrName, BSTR *pbstrArgument);
	STDMETHODIMP	get_Length(long *pnLength);
	STDMETHODIMP	Count(long *pnCount);
	STDMETHODIMP	Exists(BSTR bstrName, VARIANT_BOOL* pbExists);
	STDMETHODIMP	_NewEnum(IUnknown** ppOut);

	// f[^o
private:
	map<wstring, wstring>	m_mapNamedArguments;
};


// CUnnamedArguments class definition
/////////////////////////////////////////////////////////////////////////////

///	IUnnamedArguments ̎
class CUnnamedArguments :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IDispatchImpl<IUnnamedArguments,
			CPathTypeLibTypeInfoHolder<CAlphaTypeLibPath, &IID_IUnnamedArguments>
		> {
	// RXgN^
public:
	CUnnamedArguments(const vector<wstring>& vecUnnamedArguments);

public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IUnnamedArguments)
		IMPLEMENTS_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
						WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
						EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

	// INamedArguments C^[tFCX
	STDMETHODIMP	get_Item(long iArgument, BSTR *pbstrArgument);
	STDMETHODIMP	get_Length(long *pnLength);
	STDMETHODIMP	Count(long *pnCount);
	STDMETHODIMP	_NewEnum(IUnknown** ppOut);

	// f[^o
private:
	vector<wstring>	m_vecUnnamedArguments;
};

} /* namespace Ambient */

} /* namespace Alpha */

#endif /* _ALPHA_APPLICATION_OBJECT_H_ */

/* [EOF] */