// AlphaApplicationDebugger.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AlphaApplicationDebugger.h"
#include "AlphaScriptHost.h"
#include "DebugExpressionCallBack.h"
using Alpha::CAlphaApplicationDebugger;
using Alpha::CAlphaScriptHost;
using Alpha::BreakPointList;
using Alpha::IAlphaApplicationDebuggerEventListener;
using Alpha::CAlphaDoc;


// CAlphaApplicationDebugger class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaApplicationDebugger::CAlphaApplicationDebugger(HWND hwndMain, const BreakPointList& listBreakPoints)
		: m_pRemoteAppThread(0), m_pActiveEngine(0), m_pEventListener(0),
		m_hwndMain(hwndMain), m_bDebugging(false), m_bFirstHalt(false), m_listBreakPoints(listBreakPoints) {
	assert(::IsWindow(m_hwndMain));
}

///	u[N|Cgݒ肷BonHandleBreakPoint 1xĂяo
void CAlphaApplicationDebugger::_SetBreakPoints() {
	if(m_bFirstHalt)
		return;
	m_bFirstHalt = true;

	HRESULT							hr;
	CComPtr<IEnumDebugStackFrames>	pStackFrameEnumerator;
	DebugStackFrameDescriptor		dsfd;
	CComPtr<IDebugCodeContext>		pCodeContext, pBreakContext;
	CComPtr<IDebugDocumentContext>	pDocContext, pBreakDocContext;
	CComPtr<IDebugDocument>			pDocument;
	CComPtr<IDebugDocumentText>		pDocText;
	CComPtr<IEnumDebugCodeContexts>	pCodeContextEnumerator;
	unsigned long					cFetched;
	unsigned long					nPosition;

	hr = m_pRemoteAppThread->EnumStackFrames(&pStackFrameEnumerator);
	pStackFrameEnumerator->Reset();
	if(SUCCEEDED(hr) && S_OK == pStackFrameEnumerator->Next(1, &dsfd, &cFetched)) {	// O[oł
		dsfd.pdsf->GetCodeContext(&pCodeContext);
		pCodeContext->GetDocumentContext(&pDocContext);
		pDocContext->GetDocument(&pDocument);
		pDocument->QueryInterface(IID_IDebugDocumentText, reinterpret_cast<void**>(&pDocText));

		for(BreakPointList::const_iterator it = m_listBreakPoints.begin();
				it != m_listBreakPoints.end(); ++it) {
			pDocText->GetPositionOfLine(it->iLine, &nPosition);
			pDocText->GetContextOfPosition(nPosition, m_pDocument->GetLineLength(it->iLine), &pBreakDocContext);
			pBreakDocContext->EnumCodeContexts(&pCodeContextEnumerator);
			pCodeContextEnumerator->Reset();
			pCodeContextEnumerator->Next(1, &pBreakContext, &cFetched);
			pBreakContext->SetBreakPoint(it->bEnabled ? BREAKPOINT_ENABLED : BREAKPOINT_DISABLED);

			pCodeContextEnumerator = 0;
			pBreakContext = 0;
			pBreakDocContext = 0;
		}
		dsfd.pdsf->Release();
	}
	Continue();
}

/**
 *	fobO̊JnBStartDebugging Ăяo
 *	@param pParam	CAlphaApplicationDebugger CX^Xւ̃|C^
 */
unsigned int CAlphaApplicationDebugger::_StartDebugging(void* pParam) {
	CAlphaApplicationDebugger*		pInstance = reinterpret_cast<CAlphaApplicationDebugger*>(pParam);
	CComPtr<IProcessDebugManager>	pProcessManager;		// PDM
	CComPtr<IDebugApplication>		pDebugApplication;		// fobOAvP[V
	CComPtr<IActiveScript>			pScriptEngine;			// XNvgGW
	CComPtr<IActiveScriptDebug>		pScriptDebugger;		// XNvgfobK
	CComPtr<IActiveScriptParse>		pScriptParser;			// XNvgp[T
	OLECHAR							wszApplicationName[50];	// fobK
	CLSID							clsidLanguage;			// GW CLSID
	wstring							strSourceText;			// s\[X
	HRESULT							hr;

	// IAlphaApplicationDebuggerEventListener::OnDebugIllegalStatus(ds) ĂяoďI}N
#define FIRE_ILLEGAL_STATUS_AND_RETURN(ds)						\
do {															\
	if(pInstance->m_pEventListener != 0) {						\
		pInstance->m_pEventListener->OnDebugIllegalStatus(ds);	\
		pInstance->m_pEventListener->OnDebugEnd();				\
	}															\
	return 0;													\
} while(false)

	// fobOJn
	pInstance->m_bDebugging = true;
	::CoInitialize(0);
	if(pInstance->m_pEventListener != 0)
		pInstance->m_pEventListener->OnDebugStart();

	// PDM fobOAvP[V擾
	if(FAILED(pProcessManager.CreateInstance(
			CLSID_ProcessDebugManager, 0, CLSCTX_ALL, IID_IProcessDebugManager)))
		FIRE_ILLEGAL_STATUS_AND_RETURN(DS_FAILEDTOGETPDM);
	if(FAILED(pProcessManager->GetDefaultApplication(&pDebugApplication)))
		FIRE_ILLEGAL_STATUS_AND_RETURN(DS_FAILEDTOGETPDM);
	swprintf(wszApplicationName, L"Alpha Script Debugger <0x%08lX>", ::GetCurrentProcessId());
	hr = pDebugApplication->SetName(wszApplicationName);

	// fobOZbV̊Jn
	//  IRemoteDebugApplication::ConnectDebugger ĂԂƂɂȂ
	// IDebugApplication::StartDebugSession Ăł͂Ȃ!
	hr = pInstance->StartDebugSession(pDebugApplication);

	// XNvgGW[h
	if(FAILED(::CLSIDFromProgID(pInstance->m_strLanguageName.c_str(), &clsidLanguage)))
		FIRE_ILLEGAL_STATUS_AND_RETURN(DS_UNKNOWNSCRIPTLANGUAGE);
	if(FAILED(pScriptEngine.CreateInstance(clsidLanguage, 0, CLSCTX_ALL, IID_IActiveScript)))
		FIRE_ILLEGAL_STATUS_AND_RETURN(DS_UNKNOWNSCRIPTLANGUAGE);

	// XNvgzXg̏
	pInstance->m_pScriptHost = new CAlphaScriptHost(pInstance->m_hwndMain,
								pInstance->m_pActiveEngine, pDebugApplication);
	pInstance->m_pScriptHost->AddRef();
	pInstance->m_pScriptHost->SetScriptPath(pInstance->m_pDocument->GetPathName().c_str());
//	pInstance->m_pScriptHost->SetTopLevelObject();

	// p[Tp
	if(FAILED(pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pScriptParser)))) {
		pScriptEngine->Close();
		FIRE_ILLEGAL_STATUS_AND_RETURN(DS_ENGINENOTSUPPORTPARSER);
	}
	hr = pScriptEngine->SetScriptSite(pInstance->m_pScriptHost);
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = pScriptParser->InitNew();
	hr = pScriptEngine->AddNamedItem(OLESTR("Ambient"), SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	hr = pScriptEngine->AddNamedItem(OLESTR("Alpha"), SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	hr = pScriptEngine->AddNamedItem(OLESTR("WScript"), SCRIPTITEM_ISVISIBLE);

	// fobK擾悤Ƃ
	if(FAILED(pScriptEngine->QueryInterface(
			IID_IActiveScriptDebug, reinterpret_cast<void**>(&pScriptDebugger)))) {
		if(pInstance->m_pEventListener != 0)
			pInstance->m_pEventListener->OnDebugIllegalStatus(DS_ENGINENOTSUPPORTDEBUGGING);
	}

	// ꎟ
	VARIANT			vtResult;
	EXCEPINFO		excepinfo;
	pInstance->m_pActiveEngine = pScriptEngine;
	pInstance->m_pActiveEngine->AddRef();
	pInstance->m_pDocument->GetAllLines(strSourceText);
	hr = pScriptParser->ParseScriptText(strSourceText.c_str(),				// u[N|Cg
			0, 0, 0, 0, 0, SCRIPTTEXT_ISVISIBLE, &vtResult, &excepinfo);	// d|q}...
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_STARTED);
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);

	// CxgVN () L
//	CComPtr<IDispatch>	pScriptObject;
//	pScriptEngine->GetScriptDispatch(0, &pScriptObject);
//	pInstance->m_pScriptHost->RunEventSinks(pScriptObject);

	// fobOI -> n
	pInstance->m_pScriptHost->Release();
	pInstance->m_pScriptHost = 0;
	pDebugApplication->DisconnectDebugger();
	pInstance->m_pActiveEngine->Release();
	pInstance->m_pActiveEngine = 0;
	pScriptEngine->Close();
	if(pInstance->m_pRemoteAppThread != 0)
		pInstance->m_pRemoteAppThread->Release();

	::CoUninitialize();
	pInstance->m_bDebugging = false;
	if(pInstance->m_pEventListener != 0)
		pInstance->m_pEventListener->OnDebugEnd();

	return 0;

#undef FIRE_ILLEGAL_STATUS_AND_RETURN
}

///	~
void CAlphaApplicationDebugger::Abort() {
	assert(m_pRemoteAppThread != 0);

	IRemoteDebugApplication*	pApp = 0;
	m_pRemoteAppThread->GetApplication(&pApp);
	if(m_pScriptHost != 0)
		m_pScriptHost->AllowErrorReport(false);
    pApp->ResumeFromBreakPoint(m_pRemoteAppThread,
		BREAKRESUMEACTION_ABORT, ERRORRESUMEACTION_SkipErrorStatement);
	pApp->Release();
}

///	s
void CAlphaApplicationDebugger::Continue() {
	assert(m_pRemoteAppThread != 0);

	IRemoteDebugApplication*	pApp = 0;
	m_pRemoteAppThread->GetApplication(&pApp);
    pApp->ResumeFromBreakPoint(m_pRemoteAppThread,
		BREAKRESUMEACTION_CONTINUE, ERRORRESUMEACTION_SkipErrorStatement);
	pApp->Release();
}


///	@see	IApplicationDebugger::CreateInstanceAtDebugger
STDMETHODIMP CAlphaApplicationDebugger::CreateInstanceAtDebugger(REFCLSID rclsid,
		IUnknown* pUnkOuter, DWORD dwClsContext, REFIID riid, IUnknown** ppvObject) {
	return ::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, reinterpret_cast<void**>(ppvObject));
}

/**
 *	݂̃ReLXgŎ]AʂԂB]ɔp͖
 *	@param strExpression	]镶
 *	@param nRadix			ʂ̊
 *	@param bNoSideEffects	p}~Ƃ^
 *	@param pdpiResult		ʁB}XN (m_dwValidFields) ͌ĂяoŐݒ肷
 *	@return					
 */
HRESULT CAlphaApplicationDebugger::EvaluateExpression(const wstring& strExpression,
		unsigned int nRadix, bool bNoSideEffects, DebugPropertyInfo* pdpiResult) {
	if(m_pRemoteAppThread == 0)
		return E_UNEXPECTED;
	VERIFY_POINTER(pdpiResult);

	CComPtr<IEnumDebugStackFrames>		pStackFrameEnumerator;
	DebugStackFrameDescriptor			dsfd;
	CComPtr<IDebugExpression>			pExpression;
	CComPtr<IDebugExpressionContext>	pExpressionContext;
	CComPtr<CDebugExpressionCallBack>	pExpressionCallBack;
	CComPtr<IDebugProperty>				pDebugProperty;
	unsigned long						cFetched;
	DWORD								dwEvalFlags = DEBUG_TEXT_ISEXPRESSION | DEBUG_TEXT_RETURNVALUE;
	HRESULT								hr, hr2;

	hr = m_pRemoteAppThread->EnumStackFrames(&pStackFrameEnumerator);
	if(FAILED(hr))
		return hr;

	pStackFrameEnumerator->Reset();
	hr = pStackFrameEnumerator->Next(1, &dsfd, &cFetched);
	if(FAILED(hr))
		return hr;

	pExpressionCallBack = new Alpha::CDebugExpressionCallBack;
	dsfd.pdsf->QueryInterface(IID_IDebugExpressionContext, reinterpret_cast<void**>(&pExpressionContext));
	m_pScriptHost->AllowErrorReport(false);

	// ̐ -> ]
	if(bNoSideEffects)
		dwEvalFlags |= DEBUG_TEXT_NOSIDEEFFECTS;
	pExpressionContext->ParseLanguageText(strExpression.c_str(), 10, 0, dwEvalFlags, &pExpression);
	hr = pExpression->Start(pExpressionCallBack);
	if(!pExpressionCallBack->WaitForCompletion(2000)) {
		pExpression->Abort();
		dsfd.pdsf->Release();
		m_pScriptHost->AllowErrorReport(true);
		return E_ABORT;
	}

	// ʂ̎擾
	hr = pExpression->GetResultAsDebugProperty(&hr2, &pDebugProperty);
	if(SUCCEEDED(hr) && SUCCEEDED(hr2)) {	// sɉeƂ hr2 G[ɂȂ邱Ƃ
		hr = pDebugProperty->GetPropertyInfo(pdpiResult->m_dwValidFields, nRadix, pdpiResult);
		if(wcslen(pdpiResult->m_bstrValue) == 0) {	// ^ "Object" ̂ƂlɂȂ
			::SysFreeString(pdpiResult->m_bstrValue);
			pdpiResult->m_bstrValue = ::SysAllocString(OLESTR("{...}"));	// [
//			pExpression->GetResultAsString(&hr2, &pdpiResult->m_bstrValue);
		}
	}

	dsfd.pdsf->Release();
	m_pScriptHost->AllowErrorReport(true);

	return FAILED(hr2) ? hr2 : hr;
}

///	fobÕAvP[VԂ
void CAlphaApplicationDebugger::GetDebuggingApplication(IRemoteDebugApplication** ppApplication) {
	assert(ppApplication != 0);

	if(m_pRemoteAppThread == 0)
		*ppApplication = 0;
	else
		m_pRemoteAppThread->GetApplication(ppApplication);
}

///	fobÕAvP[VXbhԂ
void CAlphaApplicationDebugger::GetDebuggingApplicationThread(IRemoteDebugApplicationThread** ppAppThread) {
	assert(ppAppThread != 0);
	*ppAppThread = m_pRemoteAppThread;
	if(m_pRemoteAppThread != 0)
		(*ppAppThread)->AddRef();
}

///	fobÕhLgԂ (fobOłȂ null)
const CAlphaDoc* CAlphaApplicationDebugger::GetDebuggingDocument() const {
	return m_bDebugging ? m_pDocument : 0;
}

///	fobOɎgpĂXNvgzXgԂ
void CAlphaApplicationDebugger::GetScriptHost(IActiveScriptSiteDebug** ppScriptSite) {
	assert(m_pScriptHost != 0);
	*ppScriptSite = m_pScriptHost;
	(*ppScriptSite)->AddRef();
}

///	fobOǂԂ
bool CAlphaApplicationDebugger::IsDebugging() const {
	return m_bDebugging;
}

///	@see	IApplicationDebugger::onClose
STDMETHODIMP CAlphaApplicationDebugger::onClose() {
	return S_OK;
}

///	@see	IApplicationDebugger::onDebuggerEvent
STDMETHODIMP CAlphaApplicationDebugger::onDebuggerEvent(REFIID riid, IUnknown* punk) {
	return E_NOTIMPL;
}

///	@see	IApplicationDebugger::onDebugOutput
STDMETHODIMP CAlphaApplicationDebugger::onDebugOutput(LPCOLESTR pstr) {
	return S_OK;
}

///	@see	IApplicationDebugger::onHandleBreakPoint
STDMETHODIMP CAlphaApplicationDebugger::onHandleBreakPoint(
		IRemoteDebugApplicationThread* prpt, BREAKREASON br, IActiveScriptErrorDebug* pError) {
	// fobOAvP[VXbh|C^ŐV̂̂ɍXV
	if(m_pRemoteAppThread != 0)
		m_pRemoteAppThread->Release();
	m_pRemoteAppThread = prpt;
	m_pRemoteAppThread->AddRef();

	if(br == BREAKREASON_DEBUGGER_HALT && !m_bFirstHalt)
		_SetBreakPoints();
	if(m_pEventListener == 0)
		return S_OK;

	// AvP[VɃu[NŒ~Ƃʒm
	if(br == BREAKREASON_STEP || br == BREAKREASON_BREAKPOINT || br == BREAKREASON_ERROR) {
		HRESULT						hr;
        unsigned long				cFetched;
		unsigned long				nPosition;			// ~ʒu
		unsigned long				cch;
		unsigned long				iLine, iChar;		// ~ʒu̍sA
		DebugStackFrameDescriptor	dsfd;
		CComPtr<IEnumDebugStackFrames>	pStackFrameEnumerator;
		CComPtr<IDebugCodeContext>		pCodeContext;	// u[N|Cg̃R[hReLXg
		CComPtr<IDebugDocumentContext>	pDocContext;	// u[N|CgʒũhLgReLXg
		CComPtr<IDebugDocument>			pDoc;			// u[N|CgʒũhLg
		CComPtr<IDebugDocumentText>		pDocText;		// u[N|CgʒũhLgeLXg

		hr = m_pRemoteAppThread->EnumStackFrames(&pStackFrameEnumerator);
		hr = pStackFrameEnumerator->Next(1, &dsfd, &cFetched);
		hr = dsfd.pdsf->GetCodeContext(&pCodeContext);
		hr = pCodeContext->GetDocumentContext(&pDocContext);
		hr = pDocContext->GetDocument(&pDoc);
		hr = pDoc->QueryInterface(IID_IDebugDocumentText, reinterpret_cast<void**>(&pDocText));
		hr = pDocText->GetPositionOfContext(pDocContext, &nPosition, &cch);
		hr = pDocText->GetLineOfPosition(nPosition, &iLine, &iChar);
		if(br == BREAKREASON_STEP)
			m_pEventListener->OnDebugStepTo(iLine);
		else if(br == BREAKREASON_BREAKPOINT)
			m_pEventListener->OnDebugStopAtBreakPoint(iLine);
		else if(br == BREAKREASON_ERROR) {	// b
			m_pScriptHost->OnScriptError/*Debug*/(pError);
			m_pEventListener->OnDebugStopByError(iLine);
		}
		dsfd.pdsf->Release();
	}

	return S_OK;
}

///	@see	IApplicationDebugger::QueryAlive
STDMETHODIMP CAlphaApplicationDebugger::QueryAlive() {
	return S_OK;
}

/**
 *	CxgXi̐ݒ
 *	@param pEventListener	VCxgXi (null ł)
 */
void CAlphaApplicationDebugger::SetEventListener(IAlphaApplicationDebuggerEventListener* pEventListener) {
	m_pEventListener = pEventListener;
}

/**
 *	fobO̊Jn
 *	@param pDocument		shLg
 *	@param strLanguageName	gp錾ꖼ
 */
void CAlphaApplicationDebugger::StartDebugging(const CAlphaDoc* pDocument, const wstring& strLanguageName) {
	assert(pDocument != 0);

	unsigned int	dwThraedId;

	m_strLanguageName = strLanguageName;
	m_pDocument = pDocument;
	::_beginthreadex(0, 0, CAlphaApplicationDebugger::_StartDebugging, this, 0, &dwThraedId);
}

///	@see	IDebugSessionProvider::StartDebugSession
STDMETHODIMP CAlphaApplicationDebugger::StartDebugSession(IRemoteDebugApplication* pda) {
	return SUCCEEDED(pda->ConnectDebugger(this)) ? S_OK : E_FAIL;
}

/**
 *	XebvC
 */
void CAlphaApplicationDebugger::StepInto() {
	assert(m_pRemoteAppThread != 0);

	IRemoteDebugApplication*	pApp = 0;
	m_pRemoteAppThread->GetApplication(&pApp);
    pApp->ResumeFromBreakPoint(m_pRemoteAppThread,
		BREAKRESUMEACTION_STEP_INTO, ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller);
	pApp->Release();
}

/**
 *	XebvI[o[
 */
void CAlphaApplicationDebugger::StepOver() {
	assert(m_pRemoteAppThread != 0);

	IRemoteDebugApplication*	pApp = 0;
	m_pRemoteAppThread->GetApplication(&pApp);
    pApp->ResumeFromBreakPoint(m_pRemoteAppThread,
		BREAKRESUMEACTION_STEP_OVER, ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller);
	pApp->Release();
}

/**
 *	XebvAEg
 */
void CAlphaApplicationDebugger::StepOut() {
	assert(m_pRemoteAppThread != 0);

	IRemoteDebugApplication*	pApp = 0;
	m_pRemoteAppThread->GetApplication(&pApp);
    pApp->ResumeFromBreakPoint(m_pRemoteAppThread,
		BREAKRESUMEACTION_STEP_OUT, ERRORRESUMEACTION_AbortCallAndReturnErrorToCaller);
	pApp->Release();
}


/* [EOF] */