// Alpha.h
// (c) 2003 exeal

#ifndef _ALPHA_H_
#define _ALPHA_H_
#include "..\Manah\WinApp.h"
#include "..\Manah\MenuOperator.h"
#include "AlphaTabCtrl.h"
#include "AlphaEditController.h"
#include "AlphaView.h"
#include "Ambient.h"
#include "OutputWnd.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"
#include "BookmarkDlg.h"
#include "OutlineParserDlg.h"
#include "KeyboardMap.h"
#include "MRUManager.h"
#include "PluginManager.h"
#include "ScriptLanguageManager.h"
#include "AlphaApplicationDebugger.h"
#include <map>
#include <sstream>


// Literals
/////////////////////////////////////////////////////////////////////////////

#define IDN_TOOLIMAGECOUNT	(32 * 7)

#define IDS_UNTITLED			L"Untitled"
#define IDS_FILEFILTERW			L"ׂẴt@C\0*.*\0\0"
#define IDS_KEYMACROFILENAME	L"keymacro"


// Timer ID
#define ID_TIMER_QUERYCOMMAND	1	// c[o[ACe̗L
#define ID_TIMER_MOUSEMOVE		2	// J[\~1bɔ (qg\ȂǂɎgp)


namespace Alpha {

static bool	arrAvailableIcon[32 * 7] = {	// ACRpӂĂ ID ɑ΂Đ^lz
	true,	true,	false,	false,	true,	true,	true,	false,	// t@C
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	true,	true,	true,	true,	true,	true,	false,	false,	// ҏW
	false,	false,	true,	true,	true,	true,	true,	true,
	true,	true,	true,	true,	true,	true,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	true,	true,	true,	false,	false,	false,	false,	true,	// 
	false,	true,	true,	true,	false,	true,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	true,	true,	true,	false,	true,	true,	// \
	true,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	true,	false,	true,	true,	true,	true,	true,	true,	// fobO
	true,	true,	true,	true,	true,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	true,	true,	true,	true,	false,	// c[
	true,	true,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,	// wv
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
	false,	false,	false,	false,	false,	false,	false,	false,
};


// O錾
class CGotoLineDlg;
class CBookmarkDlg;
class CDebugBreakPointsDlg;
class CDebugCallStackDlg;
class CDebugImmediateDlg;
class CDebugRunningDocumentsDlg;
class CDebugThreadsDlg;
class CDebugVariablesDlg;


// 
/////////////////////////////////////////////////////////////////////////////

///	s̑BCEditView::SetLineParam Ŏg
enum LineAttribute {
	///	ɂȂ
	LA_NONE					= 0x00,
	/// Lȃu[N|Cg
	LA_BREAKPOINT_ENABLED	= 0x01,
	///	ȃu[N|Cg
	LA_BREAKPOINT_DISABLED	= 0x02,
	///	SetLineParam p}XN
	LA_BREAKPOINT_MASK		= 0x03,
};


// CAlphaApp class definition
/////////////////////////////////////////////////////////////////////////////

struct TDocumentType;

/// Alpha ̃AvP[VNX
class CAlphaApp :
		public CWinApp,
		public IEditViewEventListener,
		public IEditDocEventListener,
		public IClipboardRingEventListener,
		public IAlphaApplicationDebuggerEventListener {
	friend class CAlphaApplication;

	// f[^o
protected:
	/* CX^X */
	static CAlphaApp*	m_pInstance;	// 1̃CX^X

private:
	/* EBhE */
	CMenuOperator*		m_pMenu;			// Cj[
	CPopupMenu*			m_pFileOpeMenu;		// [t@C] |bvAbvj[
	CPopupMenu*			m_pNewDocTypeMenu;	// VKhLg^Cv|bvAbvj[
	CPopupMenu*			m_pAppDocTypeMenu;	// KphLg^Cv|bvAbvj[
	HWND				m_hRebar;			// o[
	HWND				m_hToolbar;			// c[o[
	HWND				m_hDebugBar;		// fobOo[
	HWND				m_hStatusBar;		// Xe[^Xo[
	CAlphaTabCtrl		m_wndTab;			// ^u
	unsigned int		m_iActiveTab;		// ANeBuȃ^u
	unsigned int		m_iLastActiveTab;	// OANeBu^u
	COutputWnd			m_wndOutput;		// [o] EBhE
	vector<IAlphaTab*>	m_vecDocuments;		// e^u
	CFindDlg			m_dlgFind;			// []/[u]_CAO
	CGotoLineDlg*		m_pdlgGotoLine;		// [wsֈړ]_CAO
	CBookmarkDlg*		m_pdlgBookmark;		// [ubN}[N]_CAO
	COutlineParserDlg	m_dlgOutline;		// [AEgC]_CAO
	CToolTipCtrl		m_oToolTip;			// fobÕc[qg
	WNDPROC				m_wndprocTab;		// ^ǔ̃EBhEvVW
	int					m_nOutputWndHeight;	// o̓EBhE̍
	bool				m_bSizingOutputWnd;	// o̓EBhE̍ύX

	/* GDI IuWFNg */
	HFONT		m_hTabFont;						// ^uɎgptHg
	CImageList	m_oTabIconsImageList;			// ^uɎgpC[WXg
	HIMAGELIST	m_hCommandImageList;			// SR}h̃ACRi[C[WXg
	HIMAGELIST	m_hDisabledCommandImageList;	// m_hCommandImageList ̃mNo[W

	/* @\ƃR}h */
	CAlphaApplicationDebugger*	m_pActiveDebugger;		// ANeBuȃfobK
	CAlphaEditController*		m_pDebuggingEditor;		// fobÕGfB^
	CKeyboardMap				m_oKeyboardMap;			// gp̃L[{[h}bv
	CMRUManager*				m_pMRUManager;			// MRU Xg̊Ǘ
	CScriptLanguageManager		m_oScriptLanguages;		// XNvg̊Ǘ
	CPluginManager				m_oPluginManager;		// vOC̊Ǘ
	bool						m_bCancelSelAfterCopy;	// Rs[sɑI邩

	/* fobO_CAO */
	CDebugBreakPointsDlg*		m_pdlgDebugBreakPoints;			// [u[N|Cg] _CAO
	CDebugCallStackDlg*			m_pdlgDebugCallStack;			// [Ăяo] _CAO
	CDebugImmediateDlg*			m_pdlgDebugImmediate;			// [C~fBGCg] _CAO
	CDebugRunningDocumentsDlg*	m_pdlgDebugRunningDocuments;	// [s̃hLg] _CAO
	CDebugThreadsDlg*			m_pdlgDebugThreads;				// [Xbh] _CAO
	CDebugVariablesDlg*			m_pdlgDebugVariables;			// [ϐ] _CAO

	/* \Ȃ */
	vector<TDocumentType>		m_vecDocumentTypes;	// ݓo^ĂhLg^Cv
	vector<TDocumentStyleType>	m_vecDocStyleTypes;	// ݓo^ĂhLgX^C
	LOGFONTW					m_lfCommonFont;		// r[ɎgptHg
	unsigned int				m_nLeftMargin;		// r[Ɏgp鍶]
	unsigned int				m_nTopMargin;		// r[Ɏgp]
	MSXML2::IXMLDOMDocument*	m_pXMLDoc;			// PꃊXgp XML

	/* I[g[VpC^[tFCX */
	IApplication*	m_pApplication;
	IDocuments*		m_pDocuments;

	/* IvV */
	bool	m_bShowMessageBoxOnFind;			// ŃbZ[W{bNX\
	bool	m_bInitializeFindTextFromEditor;	// []/[u] _CAOJƂ
												// eLXgGfB^珉

protected:
	/* EBhEvVW */
	static LRESULT CALLBACK AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// RXgN^
public:
	CAlphaApp();
	virtual ~CAlphaApp();

	// \bh
public:
	void					ApplyDocumentType(unsigned int iTab, unsigned int iDocType = -1) throw(out_of_range);
	int						ErrorMessageBox(unsigned int nErrorId, unsigned int nType);
	CAlphaDoc*				GetActiveDocument() const;
	IAlphaTab*				GetActiveTab() const;
	unsigned int			GetActiveTabIndex() const;
	CAlphaEditController*	GetActiveTextEditor() const;
	void					GetAutomation(IApplication** ppApplication);
	void					GetAutomationDocuments(IDocuments** ppDocuments);
	CAlphaEditController*	GetTextEditor(unsigned int iTab) const throw(out_of_range);
	unsigned int			GetDocumentTypeFromFileName(const wstring& strFileName) const;
	static CAlphaApp*		GetInstance();
	IAlphaTab*				GetTab(unsigned int iTab) const throw(out_of_range);
	unsigned int			GetTabCount() const;
	virtual bool			InitApplication(HINSTANCE hInstance);
	virtual bool			InitInstance();
	wstring					LoadErrorString(unsigned int nErrorId) const;
	int						MessageBox(DWORD wID, UINT nType);
	int						MessageBox(DWORD wID, UINT nType, const CMessageArguments& args);
	bool					OpenFile(const wstring& strPathName,
								UINT nCodePage = EXTCP_AUTO, unsigned int DocType = -1);
	void					ParseCommandLine(const vector<wstring>& vecArgs);
	void					SetActiveTab(unsigned int iTab) throw(out_of_range);

	// ZbgAbv (INI t@CȂǂݒǂݍ)
	void	LoadINISettings();
	void	SetupKeyBinds(const wstring& strSchemeName);
	void	SetupMenus();
	void	SetupTextFoundations();
	void	SetupToolbar();

	// IEditViewEventListener C^[tFCX
	void	OnChangeLines(unsigned long iLine, unsigned long cLines);
	void	OnCreateLines(unsigned long iLine, unsigned long cLines);
	void	OnDeleteLines(unsigned long iLine, unsigned long cLines);
	void	OnDrawIndicatorMargin(unsigned long iLine, CMinimalDC& oDC,
				const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis);
	void	OnMoveCaret(const CCharPos& pos);
	void	OnMoveCursor(const POINT& pt);
	void	OnQueryLineColor(unsigned long iLine, bool bBookmarked, DWORD dwParam,
				bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack);

	// IEditDocEventListener C^[tFCX
	void	OnDocumentModified();
	void	OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument);

	// IClipboardRingEventListener C^[tFCX
	void	OnClipboardRingChanged();
	void	OnClipboardRingDeniedAdding();

	// IAlphaApplicationDebuggerEventListener C^[tFCX
	void	OnDebugStart();
	void	OnDebugEnd();
	void	OnDebugStopAtBreakPoint(unsigned long iLine);
	void	OnDebugStopByError(unsigned long iLine);
	void	OnDebugStepTo(unsigned long iLine);
	void	OnDebugIllegalStatus(DebugStatus ds);

protected:
	void			BindOneKey(short sVKey, KeyModifier km, int nCommandID);
	virtual LRESULT	DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	void			GetModelessDialogList(list<HWND>& listDlgs) const;
	bool			HandleFileOpenError(Ascension::StreamStatus ss);
	void			ModifyTabIcons();
	void			UpdateStatusBar();
	void			UpdateTitleBar();

	// bZ[Wnh
protected:
	virtual bool	OnFileClose(bool bConfirm = true);
	virtual bool	OnFileCloseAll();
	virtual void	OnFileNew(UINT nCodePage);
	virtual void	OnFileNewWithFormat();
	virtual bool	OnFileOpen();
	virtual void	OnFileReopen();
	virtual void	OnFileReopenWithCodepage();
	virtual bool	OnFileSave(unsigned int iTab = -1) throw(out_of_range);
	virtual bool	OnFileSaveAs(unsigned int iTab = -1) throw(out_of_range);
	virtual bool	OnFileSaveAll();
	virtual void	OnFileProperty();
	virtual void	OnFileOperation(UINT id);
	virtual void	OnEditReloadPlugin();
	virtual void	OnFindFind();
	virtual void	OnFindFindNext(bool bPrevious = false, bool bNotice = true);
	virtual void	OnFindBookmarkAll();
	virtual void	OnFindToggleBookmark();
	virtual void	OnFindReplace();
	virtual void	OnFindReplaceAll();
	virtual void	OnFindReplaceAndNext();
	virtual void	OnFindParseOutline();
	virtual void	OnToolCommonOption();
	virtual void	OnToolDocTypeOption();
	virtual void	OnToolFont();
	virtual void	OnToolExecute();
	virtual void	OnToolExecuteCommand();
	virtual void	OnToolDebugStart();
	virtual void	OnToolDebugInsertBreakPoint();
	virtual void	OnToolDebugBreakPoints();
	virtual void	OnToolDebugCallStack();
	virtual void	OnToolDebugImmediate();
	virtual void	OnToolDebugVariables();
	virtual void	OnToolDebugThreads();
	virtual void	OnHelpAbout();

protected:
	virtual bool	OnClose();													// WM_CLOSE
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);		// WM_COMMAND
	virtual void	OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds);				// WM_COPYDATA
	virtual void	OnDestroy();												// WM_DESTROY
	virtual void	OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem);		// WM_DRAWITEM
	virtual void	OnDropFiles(HDROP hDrop);									// WM_DROPFILES
	virtual void	OnEnterMenuLoop(bool bIsTrackPopup);						// WM_ENTERMENULOOP
	virtual void	OnExitMenuLoop(bool bIsTrackPopup);							// WM_EXITMENULOOP
	virtual void	OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI);		// WM_MEASUREITEM
	virtual void	OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);	// WM_MENUSELECT
	virtual void	OnMouseMove(UINT nFlags, POINT pt);							// WM_MOUSEMOVE
	virtual bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);						// WM_NOTIFY
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);		// WM_SETCURSOR
	virtual void	OnSize(UINT nType, int cx, int cy);							// WM_SIZE
	virtual void	OnTimer(UINT nIDTimer);										// WM_TIMER

	// hLgAr[̕ύXĎ
protected:
	static void OnUpdateDocument();

	// [t@CJ] _CAOtbNvVW
protected:
	static UINT CALLBACK	OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// J[eBeB
protected:
	wchar_t*	GetMenuLabel(int nCommand) const;
	void		GetProfileList(const wchar_t* pwszSectionName,
					const wchar_t* pwszKeyName, list<wstring>& listItems, const wchar_t* pwszDefault = 0);
	void		GetProfileSet(const wchar_t* pwszSectionName,
					const wchar_t* pwszKeyName, set<wstring>& setItems, const wchar_t* pwszDefault = 0);
};

///	B̃AvP[VIuWFNgԂ
inline CAlphaApp* CAlphaApp::GetInstance() {
	return CAlphaApp::m_pInstance;
}

/**
 *	R}h̃j[LvVԂ
 *	@param nCommand	R}h ID
 */
inline wchar_t*	CAlphaApp::GetMenuLabel(int nCommand) const {
	static wchar_t	wsz[100];
	wchar_t*		psz = 0;

	LoadString(nCommand, wsz, 100);
	psz = wcschr(wsz, L'\n');
	if(psz != 0)
		*psz = 0;
	wcscat(wsz, L"\t");
	wcscat(wsz, m_oKeyboardMap.GetKeyString(nCommand).c_str());
	return wsz;
}

/**
 *	INI 當񃊃Xgǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param listItems		[out] Xg
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void CAlphaApp::GetProfileList(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, list<wstring>& listItems, const wchar_t* pwszDefault /* = 0 */) {
	wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	wstring	strItem;

	listItems.clear();
	if(strList.empty())
		return;
	wistringstream	wis(strList);
	while(wis >> strItem)
		listItems.push_back(strItem);
}


/**
 *	INI 當̏Wǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param setItems			[out] W
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void	CAlphaApp::GetProfileSet(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, set<wstring>& setItems, const wchar_t* pwszDefault /* = 0 */) {
	wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	wstring	strItem;

	setItems.clear();
	if(strList.empty())
		return;
	wistringstream	wis(strList);
	while(wis >> strItem)
		setItems.insert(strItem);
}

} /* namespace Alpha */

#endif /* _ALPHA_H_ */

/* [EOF] */