// Exception.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_

#include "ManahObject.h"
#include <process.h>
#include <tchar.h>


// CException class definition
/////////////////////////////////////////////////////////////////////////////

namespace _Manah
{

class CException : public CManahObject
{
	//property
protected:
	TCHAR	m_szThrownMethod[128];	// complete name of the method thrown this exception
	TCHAR	m_szDescription[256];	// description for the exception

	// constructor
protected:
	CException()	{/* empty */}
public:
	CException(const TCHAR* lpszMethodName, const TCHAR* lpszDescription)
	{
		_tcscpy(m_szThrownMethod, lpszMethodName);
		_tcscpy(m_szDescription, lpszDescription);
	}

	// method
public:
	const TCHAR* GetThrownMethodName() const{return m_szThrownMethod;}
	const TCHAR* GetDescription() const{return m_szDescription;}
	virtual void ReportError(BOOL bAbort = FALSE) const	// show description on dialog
	{
#ifdef _DEBUG
		TCHAR szReport[384];

		_tcscpy(szReport, _T("The exception thrown by _Manah::"));
		_tcscat(szReport, m_szThrownMethod);
		_tcscat(szReport, _T("!\n\n"));
		_tcscat(szReport, m_szDescription);
		::MessageBox(NULL, szReport, _T("_Manah::CException assertion"), MB_ICONHAND);
		if(bAbort)
			abort();
#endif
	}

#ifdef _DEBUG
protected:
	virtual void	AssertValid() const
	{CManahObject::AssertValid();}
public:
	virtual void	Dump(CDumpContext& dc) const
	{
		dc << _T("m_szThrownMethod=\t") << m_szThrownMethod
			<< _T("m_szDescription=\t") << m_szDescription;
	}
#else
protected:	inline void	AssertValid() const	{}
public:		inline void	Dump(CDumpContext& dc) const {}
#endif
};

};

#endif /* _EXCEPTION_H_ */

/* [EOF] */