// OutlineParserDlg.h
// (c) 2003 exeal

#ifndef _OUTLINE_PARSER_DLG_H_
#define _OUTLINE_PARSER_DLG_H_

#include "..\Manah\Dialog.h"
#include "AlphaDoc.h"


namespace Alpha {

/// ͂Ɏgp錾
enum OutlineParserLanguage {
	OPL_NONE,		// l
	OPL_JSCRIPT,	// Microsoft JScript 5.6
	OPL_VBSCRIPT,	// Microsoft Visual Basic Script Edition 5.6
};

///	[AEgC] _CAO
class COutlineParserDlg : public CDialog {
	struct TOutlineElement {	// AEgCP
		wstring					title;		// ֐Ȃ
		unsigned long			line;		// sԍ (0-)
		list<TOutlineElement*>	children;	// qvf (NXɑ΂ă\bh Ȃ)
	};

	// f[^o
private:
	TOutlineElement			m_oelmRoot;		// [gvf
public:
	bool					m_bAutoClose;	// Iɕ邩ǂ
	OutlineParserLanguage	m_oplLanguage;	// 

	// RXgN^
public:
	COutlineParserDlg() : m_bAutoClose(false), m_oplLanguage(OPL_NONE) {
	}

	// \bh
public:
	void	Parse(const Ascension::CEditDoc* pEditDoc);
protected:
	void	CopyAsXML();
	void	ParseAsJScript(const Ascension::CEditDoc* pEditDoc);
	void	ParseAsVBScript(const Ascension::CEditDoc* pEditDoc);
	void	SetTree();

	// ̓wp
protected:
	// VBScript ʎq/̒Ԃ
	inline static size_t	GetIdentifierAsVBScript(const wchar_t* pszText, size_t cchText) {
		if(cchText == 0 || !iswalpha(*pszText))
			return 0;
		size_t	i = 1;
		while(i < cchText && iswalnum(*(pszText + i)))
			++i;
		return i;
	}
	// VBScript ̎̎ʎq܂ i CNgA̎ʎq̒Ԃ
	inline static size_t	GetNextIdentifierAsVBScript(const wchar_t* pszText, size_t cchText, size_t& i) {
		size_t	iChar = 0;
		while(iChar < cchText && !iswalpha(*(pszText + iChar))) {
			++iChar;
			++i;
		}
		return GetIdentifierAsVBScript(pszText + iChar, cchText - iChar);
	}

	// bZ[Wnh
protected:
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND

};

} /* namespace Alpha */

#endif /* _OUTLINE_PARSER_DLG_H_ */

/* [EOF] */