// ConfirmUnsavedDocumentDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "ConfirmUnsavedDocumentDlg.h"
using Alpha::CConfirmUnsavedDocumentDlg;


// CConfirmUnsavedDocumentDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CConfirmUnsavedDocumentDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LINK_SELECTALL)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, 0, m_vecFiles.size() - 1);
	else if(wID == IDC_LINK_CLEARALL)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, m_vecFiles.size() - 1, 0);

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CConfirmUnsavedDocumentDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	m_oSelectAllLinkLabel.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_SELECTALL);
	m_oSelectAllLinkLabel.SetWindowText(L"ׂđI(&A)");
	m_oSelectAllLinkLabel.MoveWindow(150, 160, 70, 14);
	m_oClearAllLinkLabel.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_CLEARALL);
	m_oClearAllLinkLabel.SetWindowText(L"Iׂĉ(&C)");
	m_oClearAllLinkLabel.MoveWindow(230, 160, 104, 14);

	for(vector<TDirtyFile>::const_iterator it = m_vecFiles.begin(); it != m_vecFiles.end(); ++it)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->strFileName.c_str()));
	SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, 0, m_vecFiles.size() - 1);

	return true;
}

///	@see	CDialog::OnOK
void CConfirmUnsavedDocumentDlg::OnOK() {
	int		cSels = SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_GETSELCOUNT, 0, 0L);
	int*	pSels = new int[cSels];

	SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_GETSELITEMS, cSels, reinterpret_cast<LPARAM>(pSels));
	for(vector<TDirtyFile>::iterator it = m_vecFiles.begin(); it != m_vecFiles.end(); ++it)
		it->bSave = false;
	for(int iSel = 0; iSel < cSels; ++iSel)
		m_vecFiles[iSel].bSave = true;
	delete[] pSels;

	CDialog::OnOK();
}

/* [EOF] */