// (c) 2003 exeal
// EditPoint.cpp

#include "StdAfx.h"
#include "EditPoint.h"
#include "EditView.h"
#include "..\..\Manah\win_utils.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


// CEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pView	Ώۂ̃r[
 */
CEditPoint::CEditPoint(CEditView* pView) : m_pView(pView) {
}

///	fXgN^
CEditPoint::~CEditPoint() {
	if(m_pView != 0)
		m_pView->ReleaseEditPoint(*this);
}

/**
 *	̕Ɉړ
 *	@param nOffset	ړ邩
 */
void CEditPoint::CharNext(unsigned long nOffset /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();
	wstring			strLine = m_pView->GetDocument()->GetLine(m_iLine);
	const wchar_t*	pwszLine = strLine.c_str();

	Normalize();
	while(nOffset-- > 0) {
		if(m_iChar == strLine.length()) {	// sȂ̂Ŏ̍sɈړ
			if(m_iLine == cLines - 1)	// ŏIsłΈړȂ
				return;
			strLine = m_pView->GetDocument()->GetLine(++m_iLine);
			pwszLine = strLine.c_str();
			m_iChar = 0;
		} else
			// Lbg󂯎Ȃ΂
			m_iChar += CEditView::MakeCaretPosValid(pwszLine, strLine.length(), ++m_iChar, false);
	}
	m_cxLast = m_pView->PosFromChar(*this).x
				+ m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth()
				- m_pView->m_layoutInfo.nLeftTabWidth + 1;
}

/**
 *	O̕Ɉړ
 *	@param nOffset	ړ邩
 */
void CEditPoint::CharPrev(unsigned long nOffset /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	wstring			strLine = m_pView->GetDocument()->GetLine(m_iLine);
	const wchar_t*	pwszLine = strLine.c_str();

	Normalize();
	while(nOffset-- > 0) {
		if(m_iChar == 0) {	// sȂ̂őO̍sɈړ
			if(m_iLine == 0)	// 擪słΈړȂ
				return;
			strLine = m_pView->GetDocument()->GetLine(--m_iLine);
			pwszLine = strLine.c_str();
			m_iChar = strLine.length();
		} else
			// Lbg󂯎Ȃ΂
			m_iChar += CEditView::MakeCaretPosValid(pwszLine, strLine.length(), --m_iChar, true);
	}
	m_cxLast = m_pView->PosFromChar(*this).x
				+ m_pView->m_ptScroll.x * m_pView->m_layoutInfo.nHScrollRatio * m_pView->GetAvgCharWidth()
				- m_pView->m_layoutInfo.nLeftTabWidth + 1;
}

///	ʒu\IuWFNgԂB߂l͌Ăяoō폜
CEditPoint* CEditPoint::Clone() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditPoint*	pClone = new CEditPoint(m_pView);
	pClone->m_iLine = m_iLine;
	pClone->m_iChar = m_iChar;
	m_pView->m_setEditPoints.insert(pClone);
	return pClone;
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 *	@param rct		ϊ̎
 */
void CEditPoint::Convert(long cChars, RangeConvertType rct) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Convert()
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param pt	1̈ʒu
 *	@param rct	ϊ̎
 */
void CEditPoint::Convert(const CEditPoint& pt, RangeConvertType rct) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Convert()
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param cChars	Rs[镶 (ł悢)
 */
void CEditPoint::Copy(long cChars) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(cChars).c_str());
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param cChars	1̈ʒu܂ł̕
 */
void CEditPoint::Copy(const CEditPoint& pt) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(pt).c_str());
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param cChars	Rs[镶 (ł悢)
 */
void CEditPoint::Cut(long cChars) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(cChars).c_str());
	Delete(cChars);
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Cut(const CEditPoint& pt) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	CClipboard::SetClipboardText(m_pView->m_hWnd, GetText(pt).c_str());
	Delete(pt);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Delete(long cChars /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly() || cChars == 0)
		return;

	CEditPoint	pt(m_pView);

	pt.m_iLine = m_iLine;
	pt.m_iChar = m_iChar;

	if(cChars > 0)
		pt.CharNext(cChars);
	else {
		while(cChars != 0) {
			if(pt.m_iChar == 0) {
				if(pt.m_iLine == 0)
					break;
				--pt.m_iLine;
				pt.m_iChar = m_pView->GetDocument()->GetLineLength(pt.m_iLine);
			} else
				--pt.m_iChar;
		}
	}
	Delete(pt);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param pt	1̈ʒu
 */
void CEditPoint::Delete(const CEditPoint& pt) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	*this = m_pView->GetDocument()->DeleteText(m_pView, *this, pt, OCF_PREVENTALL);
}

///	_r[̒ɗ悤ɃXN[
void CEditPoint::EnsureCentered() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::EnsureCentered()
}

///	_ɂȂ悤Ƀr[XN[
void CEditPoint::EnsureVisible() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::EnsureVisible()
}

///	hLg̐擪̕Ԃ
unsigned long CEditPoint::GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	nOffset = 0;
	LineIterator	itLines = m_pView->GetDocument()->GetLineIterator(0);

	Normalize();
	for(unsigned long iLine = 0; ; ++iLine, ++itLines) {
		if(iLine == m_iLine) {
			nOffset += m_iChar;
			break;
		} else
			nOffset += itLines->GetLine().length() + 1;	// +1 ͉s
	}
	return nOffset;
}

///	ԍԂ
unsigned long CEditPoint::GetCharNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_iChar;
}

///	\̗ԍԂ
unsigned long CEditPoint::GetColumnNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_pView->ColumnFromChar(*this);
}

///	_s̒Ԃ
unsigned long CEditPoint::GetLineLength() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine);
}

///	sԍԂ
unsigned long CEditPoint::GetLineNumber() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine;
}

/**
 *	͈͓̃eLXgԂ
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
wstring CEditPoint::GetText(long cChars) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	if(cChars == 0)
		return L"";

	const CEditDoc*	pDoc = m_pView->GetDocument();
	wostringstream	ssText;

	while(true) {
	}
}

/**
 *	͈͓̃eLXgԂ
 *	@param pt	1̈ʒu
 */
wstring CEditPoint::GetText(const CEditPoint& pt) const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	if(*this == pt)
		return L"";

	const CEditDoc*		pDoc = m_pView->GetDocument();
	const CEditPoint&	posStart = std::min(*this, pt);
	const CEditPoint&	posEnd = std::max(*this, pt);

	if(posStart.m_iLine == posEnd.m_iLine)	// 1s̏ꍇ
		return pDoc->GetLine(posEnd.m_iLine).substr(
			posStart.m_iChar, posEnd.m_iChar - posStart.m_iChar);
	else {	// s̏ꍇ
		wostringstream	ssText;
		unsigned long	iLine = posStart.m_iLine;
		LineIterator	itLines = pDoc->GetLineIterator(iLine);

		while(true) {
			if(iLine == posStart.m_iLine)	// 擪s
				ssText << itLines->GetLine().substr(posStart.m_iChar);
			else if(iLine == posEnd.m_iLine)	// ŏIs
				ssText << itLines->GetLine().substr(0, posEnd.m_iChar);
			else
				ssText << itLines->GetLine() << CEditDoc::GetBreakString(itLines->GetBreakType());
			++iLine;
			++itLines;
		}
		return ssText.str();
	}
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param strText	}eLXg
 *	@param ocf		쌋tO
 */
void CEditPoint::Insert(const wstring& strText,
		Ascension::OperationConcatenationFlag ocf) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pView->GetDocument()->IsReadOnly())
		return;
	*this = m_pView->GetDocument()->InsertText(m_pView, *this, strText, ocf);
}

///	݈ʒuhLg̏I[ł邩ǂԂ
bool CEditPoint::IsAtEndOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	CEditDoc*	pDoc = m_pView->GetDocument();

	Normalize();
	if(pDoc->GetLineCount() - 1 != m_iLine)
		return false;
	return pDoc->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsAtEndOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_pView->GetDocument()->GetLineLength(m_iLine) == m_iChar;
}

///	݈ʒuhLg̐擪ł邩ǂԂ
bool CEditPoint::IsAtStartOfDocument() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iLine == 0 && m_iChar == 0;
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsAtStartOfLine() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	return m_iChar == 0;
}

/**
 *	̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineDown(unsigned long cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	cLines_ = m_pView->GetDocument()->GetLineCount();

	Normalize();
	m_iLine = (m_iLine + cLines < cLines_) ? m_iLine + cLines_ : cLines - 1;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	O̍sɈړ
 *	@param cLines	ړs
 */
void CEditPoint::LineUp(unsigned long cLines /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	m_iLine = (m_iLine < cLines) ? 0 : m_iLine - cLines;
	m_iChar = m_pView->CharFromPixel(m_iLine, m_cxLast, true);
}

/**
 *	hLg擪̕Ŏw肵ʒuɈړ
 *	@param nOffset	hLg擪̕
 */
void CEditPoint::MoveToAbsoluteCharOffset(unsigned long nOffset) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	unsigned long	cRead = 0;
	LineIterator	itLines = pDoc->GetLineIterator(0);
	unsigned long	cLines = pDoc->GetLineCount();

	for(unsigned long iLine = 0; iLine < cLines; ++iLine, ++itLines) {
		unsigned long	cchLine = itLines->GetLine().length() + 1;
		if(cRead + cchLine >= nOffset) {
			m_iLine = iLine;
			m_iChar = cRead + cchLine - nOffset;
			return;
		}
		cRead += cchLine;
	}
	m_iLine = cLines - 1;
	m_iChar = itLines->GetLine().length();
}

///	hLg̏I[Ɉړ
void CEditPoint::MoveToEndOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const CEditDoc*	pDoc = m_pView->GetDocument();
	m_iLine = pDoc->GetLineCount() - 1;
	m_iChar = pDoc->GetLineLength(pDoc->GetLineCount() - 1);
}

///	sɈړ
void CEditPoint::MoveToEndOfLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = m_pView->GetDocument()->GetLineLength(m_iLine);
}

///	̃ubN}[Ns̍sɈړ
void CEditPoint::MoveToNextBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	iLine;
	unsigned long	cLines = m_pView->GetDocument()->GetLineCount();

	// T
	for(iLine = m_iLine + 1; iLine < cLines; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = 0; iLine < m_iLine; ++iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
		}
	}
}

/**
 *	wʒuɈړ
 *	@param pos	ړ
 */
void CEditPoint::MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = pos.m_iLine;
	m_iChar = pos.m_iChar;
	Normalize();
}

///	ÕubN}[Ns̍sɈړ
void CEditPoint::MoveToPrevBookmark() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	unsigned long	iLine = m_iLine - 1;

	// T
	while(true) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
		}
		if(--iLine == 0)
			break;
	}

	// Ȃΐ܂Ԃ
	CEditDoc*	pDoc = m_pView->GetDocument();
	for(iLine = pDoc->GetLineCount() - 1; iLine > m_iLine; --iLine) {
		if(m_pView->m_pLineLayoutManager->GetLine(iLine)->IsBookmarked()) {
			m_iLine = iLine;
			m_iChar = 0;
			return;
		}
	}
}

///	hLg̐擪Ɉړ
void CEditPoint::MoveToStartOfDocument() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = m_iChar = 0;
}

///	sɈړ
void CEditPoint::MoveToStartOfLine() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	m_iLine = std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	m_iChar = 0;
}

///	ʒuɈړ (const \bh悭Ăяô const ɂĂ)
void CEditPoint::Normalize() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	const_cast<CEditPoint*>(this)->m_iLine =
		std::min(m_iLine, m_pView->GetDocument()->GetLineCount() - 1);
	const_cast<CEditPoint*>(this)->m_iChar =
		std::min(m_iChar, m_pView->GetDocument()->GetLineLength(m_iLine));
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param cChars	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Paste(long cChars /* = 0 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Paste()
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param pt	1̈ʒu
 */
void CEditPoint::Paste(const CEditPoint& pt) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Paste()
}

/**
 *	͈͓̃eLXgXy[XCfg
 *	@param pt		1̈ʒu
 *	@param nLevel	Cfgx
 */
void CEditPoint::SpaceIndent(const CEditPoint& pt, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::SpaceIndent()
}

/**
 *	͈͓̃eLXg̃Xy[X^uɕϊ
 *	@param cChars		1̈ʒu܂ł̕ (ł悢)
 *	@param bUntabify	^uXy[Xɕϊꍇ true
 */
void CEditPoint::Tabify(long cChars, bool bUntabify /* = false */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Tabify()
}

/**
 *	͈͓̃eLXg̃Xy[X^uɕϊ
 *	@param pt	1̈ʒu
 *	@param bUntabify	^uXy[Xɕϊꍇ true
 */
void CEditPoint::Tabify(const CEditPoint& pt, bool bUntabify /* = false */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::Tabify()
}

/**
 *	͈͓̃eLXg^uCfg
 *	@param pt		1̈ʒu
 *	@param nLevel	Cfgx
 */
void CEditPoint::TabIndent(const CEditPoint& pt, long nLevel /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	// TODO: CEditPoint::TabIndent()
}

/**
 *	̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndNext(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	// TODO: CEditPoint::WordEndNext()
}

/**
 *	O̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordEndPrev(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	// TODO: CEditPoint::WordEndPrev()
}

/**
 *	̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordNext(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	// TODO: CEditPoint::WordNext()
}

/**
 *	O̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CEditPoint::WordPrev(unsigned long cWords /* = 1 */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();

	Normalize();
	// TODO: CEditPoint::WordPrev()
}


// CEditRange class implementation
/////////////////////////////////////////////////////////////////////////////
#if 0
///	RXgN^
CEditRange::CEditRange(CEditView* pView, const CCharPos& posStart, const CCharPos& posEnd)
		: m_pView(pView), m_pAnchorPoint(new CEditPoint(pView, posStart)), m_pActivePoint(new CEditPoint(pView, posEnd)) {
}

///	͈͓̃eLXg폜B̃\bh͏I_n_̈ʒuɈړ
void CEditRange::Delete() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;

	Normalize();
	m_pView->GetDocument()->DeleteText(m_pView, *m_pAnchorPoint, *m_pActivePoint, OCF_PREVENTALL);
}

///	͈͓eLXgLs^CY
void CEditRange::MakeCapitalized() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;

	wstring		str = GetText();
	size_t		cch = str.length();
	wchar_t*	pwsz = new wchar_t[str.length()];

	for(size_t i = 0; i < cch; ) {
		size_t	cchWord = m_pView->IsWord(pwsz + i, cch - i);
		if(cchWord > 0) {
			size_t	cchHead = ((i < cch - 1)
						&& CTextConverter::IsUTF16HighSurrogate(pwsz[i])
						&& CTextConverter::IsUTF16LowSurrogate(pwsz[i + 1])) ? 2 : 1;
			::CharUpperBuffW(pwsz + i, cchHead);
			::CharLowerBuffW(pwsz + i + cchHead, cch - i - cchHead);
			i += cchHead;
		} else
			++i;
	}

	str.assign(pwsz, str.length());
	Replace(str);
	delete[] pwsz;
}

///	͈͓eLXg
void CEditRange::MakeLower() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;

	wstring		str = GetText();
	wchar_t*	pwsz = new wchar_t[str.length()];

	::CharLowerBuffW(pwsz, str.length());
	str.assign(pwsz, str.length());
	Replace(str);
	delete[] pwsz;
}

///	͈͓eLXg啶
void CEditRange::MakeUpper() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;

	wstring		str = GetText();
	wchar_t*	pwsz = new wchar_t[str.length()];

	::CharUpperBuffW(pwsz, str.length());
	str.assign(pwsz, str.length());
	Replace(str);
	delete[] pwsz;
}

/**
 *	Xy[XCfg
 *	@param bReverse	tCfg̏ꍇ true
 */
void CEditRange::SpaceIndent(bool bReverse /* = false */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;
}

/**
 *	󔒁A^u̕ϊ
 *	@param bRevoke	^u󔒂ɕϊƂ true
 */
void CEditRange::Tabify(bool bRevoke /* = false */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;
}

/**
 *	^uCfg
 *	@param bReverse	tCfg̏ꍇ true
 */
void CEditRange::TabIndent(bool bReverse /* = false */) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;
}

///	͈͓eLXgNbv{[h̓eŒuB`\t͕s
///	( CF_UNICODETEXT g)B̃\bh͏I_ũeLXg̖Ɉړ
void CEditRange::Paste() throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();
	if(m_pView->GetDocument()->IsReadOnly())
		return;
	if(!toBoolean(::IsClipboardFormatAvailable(CF_UNICODETEXT)))
		return;

	size_t		cch = CClipboard::GetClipboardTextSize(m_pView->m_hWnd);
	wchar_t*	pwszText = new wchar_t[cch];

	CClipboard::ReadClipboardText(m_pView->m_hWnd, pwszText, cch);
	Replace(pwszText);
	delete[] pwszText;
}

/**
 *	͈͓eLXguB̃\bh͏I_ũeLXg̖Ɉړ
 *	@param strText	ueLXg
 */
void CEditRange::Replace(const wstring& strText) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	if(!IsAvailable())
		throw EViewIsAlreadyInavailable();

	CEditDoc*	pDoc = m_pView->GetDocument();
	CCharPos	posResult;

	if(pDoc->IsReadOnly())
		return;
	if(IsEmpty())
		posResult = pDoc->InsertText(m_pView, *m_pActivePoint, strText, OCF_PREVENTALL);
	else {
		pDoc->DeleteText(m_pView, *m_pAnchorPoint, *m_pActivePoint, OCF_PREVENTCONCATFORWARD);
		posResult = pDoc->InsertText(m_pView, *m_pActivePoint, strText, OCF_PREVENTCONCATBACKWARD);
	}
	m_pActivePoint->m_iLine = posResult.m_iLine;
	m_pActivePoint->m_iChar = posResult.m_iChar;
}
#endif

/* [EOF] */