// AutoCompleteWnd.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AutoCompleteWnd.h"
#include "EditView.h"	// CEditView

using namespace Ascension;
using namespace std;


// CAutoCompleteWnd class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutoCompleteWnd::CAutoCompleteWnd(CEditView* pView) : m_pView(pView) {
	assert(m_pView != 0);
}

///	⊮
void CAutoCompleteWnd::Complete() {
	AssertValid();

	int	iSel = GetSelectionMark();

	if(iSel != -1 && GetItemState(iSel, LVIS_SELECTED) == LVIS_SELECTED) {
		wchar_t	wszItem[300];
		wstring	strLeftWord = m_pView->GetPrecedingWord(250);

		GetItemText(iSel, 0, wszItem, 300);
		if(m_pView->m_posAnchor < m_pView->m_posActive)
			m_pView->m_posAnchor.m_iChar -= strLeftWord.length();
		else
			m_pView->m_posActive.m_iChar -= strLeftWord.length();
		m_pView->GetDocument()->DeleteText(m_pView, m_pView->m_posAnchor, m_pView->m_posActive, OCF_PREVENTCONCATFORWARD);
		m_pView->GetDocument()->InsertText(m_pView, m_pView->m_posActive, wszItem, OCF_PREVENTCONCATBACKWARD);
	}
	ShowWindow(SW_HIDE);
}

/**
 *	EBhE쐬
 *	@return	
 */
bool CAutoCompleteWnd::Create() {
	AssertValid();

	RECT	rect = {0, 0, 0, 0};
	if(Manah::Windows::Controls::CListCtrl::CreateEx(true,
			WS_EX_CLIENTEDGE | WS_EX_LAYERED | WS_EX_NOPARENTNOTIFY,
			WS_CHILD | WS_POPUP | WS_TABSTOP | LVS_REPORT | LVS_SHOWSELALWAYS | LVS_SINGLESEL | LVS_NOCOLUMNHEADER,
			&rect, m_pView->m_hWnd, 0)) {
		LVCOLUMN	col = {LVCF_WIDTH, 0, 144, 0, 0, 0, 0, 0};

		InsertColumn(0, &col);
		SetExtendedStyle(LVS_EX_FULLROWSELECT);
		SetLayeredWindowAttributes(0, 220, LWA_ALPHA);
		return true;
	}
	return false;
}

///	@see	CListCtrl:DispatchEvent
LRESULT CAutoCompleteWnd::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	int	iSel;

	switch(message) {
	case WM_CHAR:
		m_pView->ExecCommand(CMDID_EDIT_CHAR, wParam);
		return true;
	case WM_KEYDOWN:
		switch(wParam) {
		case VK_UP:	// Xgr[̊̑
		case VK_DOWN:
		case VK_NEXT:
		case VK_PRIOR:
			break;
		case VK_ESCAPE:	// ͌EBhE
			ShowWindow(SW_HIDE);
			return true;
		case VK_RETURN:	// I΂̃eLXg}ĕBI΃r[ɑ
			iSel = GetSelectionMark();
			if(iSel == -1 || GetItemState(iSel, LVIS_SELECTED) != LVIS_SELECTED) {
				m_pView->SendMessage(WM_KEYDOWN, VK_RETURN, lParam);
				ShowWindow(SW_HIDE);
			} else
				Complete();
			return true;
		case VK_TAB:
		case VK_SPACE:
			Complete();
			m_pView->SendMessage(WM_KEYDOWN, wParam, lParam);
			return true;
		default:	// c̃L[͂͑Săr[ɑ
			m_pView->SendMessage(WM_KEYDOWN, wParam, lParam);
			return true;
		}
		break;
	case WM_KILLFOCUS:
		ShowWindow(SW_HIDE);
		break;
	case WM_LBUTTONDBLCLK:	// _uNbNł⊮
		Complete();
		break;
	}

	return CListCtrl::DispatchEvent(message, wParam, lParam);
}

///	XgԂ
unsigned long CAutoCompleteWnd::GetWordCount() const {
	AssertValid();
	return m_listWords.size();
}

///	͌⃊Xg̃Zbg
void CAutoCompleteWnd::SetCandidateWords(const CandidateWordList& listWords) {
	AssertValid();

	CandidateWordList::const_iterator	it = listWords.begin();
	LVITEMW								item;

	item.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_TEXT;
	item.iItem = item.iSubItem = 0;

	m_listWords.clear();
	DeleteAllItems();
	while(it != listWords.end()) {
		m_listWords.push_back(*it);
		item.pszText = const_cast<wchar_t*>(it->strName.c_str());
		item.iImage = it->wordProperty;
		item.lParam = reinterpret_cast<LPARAM>(&(*it));
		InsertItem(&item);
		++it;
		++item.iItem;
	}
}

///	r[̏󋵂ɍ킹ăXg̑IXV
void CAutoCompleteWnd::UpdateListCursel() {
	AssertValidAsWindow();

	wstring		strLeftWord = m_pView->GetPrecedingWord(250);
	LVFINDINFOW	findinfo;
	int			iFound;

	if(!strLeftWord.empty()) {
		findinfo.flags = LVFI_PARTIAL | LVFI_STRING;
		findinfo.psz = strLeftWord.c_str();
		iFound = FindItem(&findinfo, -1);
		if(iFound != -1) {
			// ۂɕIɈvĂ邩ǂ𒲂ׂ (Ȃ͂ł)
			wchar_t	wszItem[300];
			GetItemText(iFound, 0, wszItem, 300);
			if(wcsncmp(wszItem, findinfo.psz, strLeftWord.length()) == 0) {
				SetItemState(iFound,
					LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
				SetSelectionMark(iFound);
				EnsureVisible(iFound, false);
				return;
			}
		}
	}

	// v̂ꍇ
	iFound = GetSelectionMark();
	if(iFound == -1)
		iFound = 0;
	SetItemState(iFound, LVIS_FOCUSED, LVIS_FOCUSED | LVIS_SELECTED);
	EnsureVisible(iFound, false);
}

/* [EOF] */