// DocTypeOptionDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "DocTypeOptionDlg.h"
#include "..\Manah\DC.h"
using Alpha::CDocTypeOptionDlg;


// CDocTypeBasicOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	[^Cv] ύXꂽ
 *	@param iCursel	I
 */
void CDocTypeOptionDlg::OnDocTypeComboboxChange(int iCursel) {
	TDocumentType&	info = m_vecDocTypes[iCursel];

	// [t@C̊gq]
	if(iCursel == 0) {
		SetDlgItemText(IDC_EDIT_DOCTYPEEXTENSIONS, L"(̃^CvŎw肳ȂSĂ̊gq)");
		::EnableWindow(GetDlgItem(IDC_EDIT_DOCTYPEEXTENSIONS), false);
	} else {
		wostringstream	ssExtensions;
		for(list<wstring>::const_iterator it = info.listExtensions.begin();
				it != info.listExtensions.end(); ++it)
			ssExtensions << *it << L" ";
		SetDlgItemText(IDC_EDIT_DOCTYPEEXTENSIONS, ssExtensions.str().c_str());
		::EnableWindow(GetDlgItem(IDC_EDIT_DOCTYPEEXTENSIONS), true);
	}

	// [GfB^ CAEg]
	SendDlgItemMessage(IDC_SPIN_LINESPACE, UDM_SETPOS, 0, info.nLineSpan);
	SendDlgItemMessage(IDC_SPIN_CHARSPACE, UDM_SETPOS, 0, info.nCharSpan);
	switch(info.nTabWidth) {
	case 2:		SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 0, 0L);	break;
	case 4:		SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 1, 0L);	break;
	case 6:		SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 2, 0L);	break;
	case 8:		SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 3, 0L);	break;
	case 10:	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 4, 0L);	break;
	case 16:	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_SETCURSEL, 5, 0L);	break;
	}
	SendDlgItemMessage(IDC_COMBO_LEFTTABTYPE, CB_SETCURSEL, info.ltt, 0L);

	// [Rg]
	SetDlgItemText(IDC_EDIT_MCOMMENTBEGIN1, info.strMCommentBegin1.c_str());
	SetDlgItemText(IDC_EDIT_MCOMMENTEND1, info.strMCommentEnd1.c_str());
	SetDlgItemText(IDC_EDIT_MCOMMENTBEGIN2, info.strMCommentBegin2.c_str());
	SetDlgItemText(IDC_EDIT_MCOMMENTEND2, info.strMCommentEnd2.c_str());
	SetDlgItemText(IDC_EDIT_SCOMMENT1, info.strSCommentHeader1.c_str());
	SetDlgItemText(IDC_EDIT_SCOMMENT2, info.strSCommentHeader2.c_str());

	// [\L[[h]
	CheckDlg2StateButton(IDC_CHK_IGNORECASE, info.bIgnoreCase);
	SetDlgItemText(IDC_EDIT_CHARSTREATEDASALPHA, info.strSpecialKeywordChars.c_str());
	LVITEMW	item;
	HWND	hwndKeywords1ListView = GetDlgItem(IDC_LIST_KEYWORDS1);
	HWND	hwndKeywords2ListView = GetDlgItem(IDC_LIST_KEYWORDS2);
	item.mask = LVIF_TEXT;
	item.iItem = 0;
	item.iSubItem = 0;
	ListView_DeleteAllItems(hwndKeywords1ListView);
	for(list<wstring>::const_iterator it = info.listKeywords1.begin();
			it != info.listKeywords1.end(); ++it, ++item.iItem) {
		item.pszText = const_cast<wchar_t*>(it->c_str());
		ListView_InsertItem(hwndKeywords1ListView, &item);
	}
	item.iItem = 0;
	ListView_DeleteAllItems(hwndKeywords2ListView);
	for(list<wstring>::const_iterator it = info.listKeywords2.begin();
			it != info.listKeywords2.end(); ++it, ++item.iItem) {
		item.pszText = const_cast<wchar_t*>(it->c_str());
		ListView_InsertItem(hwndKeywords2ListView, &item);
	}
	NMHDR	nmhdr = {GetDlgItem(IDC_TAB_KEYWORD), IDC_TAB_KEYWORD, TCN_SELCHANGE};
	SendDlgItemMessage(IDC_TAB_KEYWORD, TCM_SETCURSEL, 0, 0L);
	OnNotify(IDC_TAB_KEYWORD, &nmhdr);

	// [Cfg]
	CheckRadioButton(IDC_RADIO_NOAUTOINDENT, IDC_RADIO_SMARTINDENT, IDC_RADIO_NOAUTOINDENT + info.ait);
	SendDlgItemMessage(IDC_COMBO_SMARTINDENT, CB_SETCURSEL, info.nSmartIndentRule, 0L);

	// [͕⊮]
	SetDlgItemText(IDC_EDIT_FILENAME, info.strCandidateWordsFile.c_str());
}

///	@see	CDialog::OnCommand
bool CDocTypeOptionDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_COMBO_DOCTYPENAMES && wNotifyCode == CBN_SELCHANGE) {
		int	iSel = SendDlgItemMessage(wID, CB_GETCURSEL, 0, 0L);
		if(iSel != CB_ERR)
			OnDocTypeComboboxChange(iSel);
		return true;
	}
	return CPropertyPage::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CDocTypeOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CPropertyPage::OnInitDialog(hwndFocus, lInitParam);

	// [^Cv]
	for(int i = 0; i < static_cast<int>(m_vecDocTypes.size()); ++i)
		SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES,
			CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(m_vecDocTypes[i].strName.c_str()));

	// [GfB^ CAEg]
	SendDlgItemMessage(IDC_SPIN_LINESPACE, UDM_SETRANGE32, 0, 100);
	SendDlgItemMessage(IDC_SPIN_CHARSPACE, UDM_SETRANGE32, 0, 100);
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"2"));
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"4"));
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"6"));
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"8"));
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"10"));
	SendDlgItemMessage(IDC_COMBO_TABWIDTH, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"16"));
	SendDlgItemMessage(IDC_COMBO_LEFTTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"\"));
	SendDlgItemMessage(IDC_COMBO_LEFTTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"sԍ"));
	SendDlgItemMessage(IDC_COMBO_LEFTTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CWP[^"));
	SendDlgItemMessage(IDC_COMBO_LEFTTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"sԍƃCWP[^"));
	SendDlgItemMessage(IDC_COMBO_TOPTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"\"));
	SendDlgItemMessage(IDC_COMBO_TOPTABTYPE, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ԍ"));

	// [\L[[h]
	TCITEMW	tab;
	tab.mask = TCIF_TEXT;
	tab.pszText = L"L[[h1";
	SendDlgItemMessage(IDC_TAB_KEYWORD, TCM_INSERTITEMW, 0, reinterpret_cast<LPARAM>(&tab));
	tab.pszText = L"L[[h2";
	SendDlgItemMessage(IDC_TAB_KEYWORD, TCM_INSERTITEMW, 1, reinterpret_cast<LPARAM>(&tab));

	// [Cfg]
	SendDlgItemMessage(IDC_COMBO_SMARTINDENT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"Ȃ"));
	SendDlgItemMessage(IDC_COMBO_SMARTINDENT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"JavaScript"));
	SendDlgItemMessage(IDC_COMBO_SMARTINDENT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"VBScript"));
	SendDlgItemMessage(IDC_COMBO_SMARTINDENT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"Ruby"));

	SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES, CB_SETCURSEL, m_iActiveType, 0L);
	OnCommand(IDC_COMBO_DOCTYPENAMES, CBN_SELCHANGE, GetDlgItem(IDC_COMBO_DOCTYPENAMES));

	SetWindowPos(0, 0, 0, 300, 300, SWP_NOMOVE | SWP_NOZORDER);

	return true;
}

///	@see	CDialog::OnNotify
bool CDocTypeOptionDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_TAB_KEYWORD && lpNMHDR->code == TCN_SELCHANGE) {
		int	iActiveTab = SendDlgItemMessage(IDC_TAB_KEYWORD, TCM_GETCURSEL, 0, 0L);
		::ShowWindow(GetDlgItem(IDC_LIST_KEYWORDS1), (iActiveTab == 0) ? SW_SHOW : SW_HIDE);
		::ShowWindow(GetDlgItem(IDC_LIST_KEYWORDS2), (iActiveTab == 1) ? SW_SHOW : SW_HIDE);
		return true;
	}
	return CPropertyPage::OnNotify(idCtrl, lpNMHDR);
}

/* [EOF] */