// DebugDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "DebugDlg.h"
#include "DebugExpressionCallBack.h"
#include "AlphaEditController.h"
#include "AlphaView.h"
#include "..\Manah\TreeCtrl.h"
#include <dbgprop_legacy.h>
using Alpha::CDebugBreakPointsDlg;
using Alpha::CDebugCallStackDlg;
using Alpha::CDebugImmediateDlg;
using Alpha::CDebugRunningDocumentsDlg;
using Alpha::CDebugThreadsDlg;
using Alpha::CDebugVariablesDlg;
using Alpha::BreakPointList;


// CDebugBreakPointsDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	Xgr[̍XV
void CDebugBreakPointsDlg::UpdateList() {
	AssertValidAsWindow();

	HWND	hwndBreakPointsListView = GetDlgItem(IDC_LIST_BREAKPOINTS);
	LVITEMW	item;
	wchar_t	wszItem[MAX_PATH];

	item.mask = LVIF_TEXT;
	item.iItem = 0;
	item.pszText = wszItem;
	for(BreakPointList::const_iterator it = m_listBreakPoints.begin(); it != m_listBreakPoints.end(); ++it) {
		item.iSubItem = 0;
		wcscpy(wszItem, L"(ANeBuȃt@C)");
		ListView_InsertItem(hwndBreakPointsListView, &item);
		item.iSubItem = 1;
		swprintf(wszItem, L"%lu", it->iLine + 1);
		ListView_SetItem(hwndBreakPointsListView, &item);
		ListView_SetCheckState(hwndBreakPointsListView, item.iItem, it->bEnabled);
		++item.iItem;
	}
}

///	@see	CDialog::OnClose
void CDebugBreakPointsDlg::OnDestroy() {
	HWND		hwndBreakPointsListView = GetDlgItem(IDC_LIST_BREAKPOINTS);
	int			cItems = ListView_GetItemCount(hwndBreakPointsListView);
	wchar_t		wszLine[10];
	wchar_t*	pwszDel = 0;

	// XgXV
	m_listBreakPoints.clear();
	for(int iItem = 0; iItem < cItems; ++iItem) {
		TBreakPointInfo	bpi;
		bpi.bEnabled = toBoolean(ListView_GetCheckState(hwndBreakPointsListView, iItem));
		ListView_GetItemText(hwndBreakPointsListView, iItem, 1, wszLine, 10);
		bpi.iLine = wcstoul(wszLine, &pwszDel, 10) - 1;
		m_listBreakPoints.push_back(bpi);
	}

	CDialog::OnDestroy();
}

///	@see	CDialog::OnCommand
bool CDebugBreakPointsDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_BTN_JUMP) {	// [ړ]
	} else if(wID == IDC_BTN_DELETE) {	// [폜]
		HWND		hwndBreakPointsListView = GetDlgItem(IDC_LIST_BREAKPOINTS);
		list<int>	listSelected;
		int			iLast = -1;

		while(true) {
			iLast = ListView_GetNextItem(hwndBreakPointsListView, iLast, LVNI_SELECTED);
			if(iLast == -1)
				break;
			listSelected.push_back(iLast);
		}
		for(list<int>::reverse_iterator it = listSelected.rbegin();
				it != listSelected.rend(); ++it)
			ListView_DeleteItem(hwndBreakPointsListView, *it);
	} else if(wID == IDC_BTN_CLEAR)	// [ׂč폜]
		SendDlgItemMessage(IDC_LIST_BREAKPOINTS, LVM_DELETEALLITEMS, 0, 0L);
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CDebugBreakPointsDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND		hwndBreakPointsListView = GetDlgItem(IDC_LIST_BREAKPOINTS);
	LVCOLUMNW	column;

	column.mask = LVCF_TEXT | LVCF_WIDTH;
	column.cx = 200;
	column.pszText = L"t@C";
	ListView_InsertColumn(hwndBreakPointsListView, 0, &column);
	column.cx = 50;
	column.pszText = L"s";
	ListView_InsertColumn(hwndBreakPointsListView, 1, &column);

	// SsIA_uNbNA`FbN{bNXLɂ
	long	nStyle = ::GetWindowLong(hwndBreakPointsListView, GWL_EXSTYLE);
	::SetWindowLong(hwndBreakPointsListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	ListView_SetExtendedListViewStyle(hwndBreakPointsListView, LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);

	UpdateList();

	return true;
}

bool CDebugBreakPointsDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_BREAKPOINTS && lpNMHDR->code == LVN_ITEMCHANGED) {
		int	cSelected = ListView_GetSelectedCount(lpNMHDR->hwndFrom);

		::EnableWindow(GetDlgItem(IDC_BTN_JUMP), cSelected == 1);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), cSelected > 0);
		::EnableWindow(GetDlgItem(IDC_BTN_CLEAR), ListView_GetItemCount(lpNMHDR->hwndFrom));
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}


// CDebugCallStackDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDebugCallStackDlg::CDebugCallStackDlg() : m_pDebugger(0) {
}

///	fXgN^
CDebugCallStackDlg::~CDebugCallStackDlg() {
	if(m_pDebugger != 0)
		m_pDebugger->Release();
}

///	_CAO̍XV
void CDebugCallStackDlg::Update(Alpha::CAlphaApplicationDebugger* pDebugger) {
	AssertValidAsWindow();
	assert(pDebugger != 0);

	CComPtr<IRemoteDebugApplicationThread>	pThread;
	CComPtr<IEnumDebugStackFrames>			pStackFrameEnumerator;
	DebugStackFrameDescriptor				dsfd;
	HWND			hwndStackFramesListView = GetDlgItem(IDC_LIST_DEBUGSTACKFRAMES);
	LVITEMW			item;
	unsigned long	cFetched;
	wchar_t			wszProcAddress[11];	// [AhX]
	BSTR			bstrItem;

	// VXbh̐ݒ
	if(m_pDebugger != 0)
		m_pDebugger->Release();
	m_pDebugger = pDebugger;
	m_pDebugger->AddRef();

	item.iItem = 0;
	ListView_DeleteAllItems(hwndStackFramesListView);

	m_pDebugger->GetDebuggingApplicationThread(&pThread);
	pThread->EnumStackFrames(&pStackFrameEnumerator);
	pStackFrameEnumerator->Reset();
	while(S_OK == pStackFrameEnumerator->Next(1, &dsfd, &cFetched)) {
		item.mask = LVIF_TEXT | LVIF_PARAM;
		item.iSubItem = 0;
		swprintf(wszProcAddress, L"0x%lx", dsfd.dwMin);
		item.pszText = wszProcAddress;
		item.lParam = reinterpret_cast<LPARAM>(dsfd.pdsf);
		ListView_InsertItem(hwndStackFramesListView, &item);

		dsfd.pdsf->GetDescriptionString(true, &bstrItem);
		item.mask = LVIF_TEXT;
		item.iSubItem = 1;
		item.pszText = bstrItem;
		ListView_SetItem(hwndStackFramesListView, &item);
		::SysFreeString(bstrItem);

		dsfd.pdsf->GetLanguageString(false, &bstrItem);
		item.iSubItem = 2;
		item.pszText = bstrItem;
		ListView_SetItem(hwndStackFramesListView, &item);
		::SysFreeString(bstrItem);

		++item.iItem;
	}
}

///	@see	CDialog::OnCommand
bool CDebugCallStackDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CDebugCallStackDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND		hwndStackFramesListView = GetDlgItem(IDC_LIST_DEBUGSTACKFRAMES);
	LVCOLUMNW	column;

	column.mask = LVCF_TEXT | LVCF_WIDTH;
	column.pszText = L"AhX";
	column.cx = 60;
	ListView_InsertColumn(hwndStackFramesListView, 0, &column);
	column.pszText = L"֐";
	column.cx = 180;
	ListView_InsertColumn(hwndStackFramesListView, 1, &column);
	column.pszText = L"";
	column.cx = 70;
	ListView_InsertColumn(hwndStackFramesListView, 2, &column);

	long	nStyle = ::GetWindowLong(hwndStackFramesListView, GWL_EXSTYLE);
	::SetWindowLong(hwndStackFramesListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	ListView_SetExtendedListViewStyle(hwndStackFramesListView, LVS_EX_FULLROWSELECT);

	return true;
}

///	@see	CDialog::OnNotify
bool CDebugCallStackDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_DEBUGSTACKFRAMES) {
		LVITEMW	item;
		if(lpNMHDR->code == LVN_DELETEITEM) {
			item.mask = LVIF_PARAM;
			item.iItem = item.iSubItem = reinterpret_cast<LPNMLISTVIEW>(lpNMHDR)->iItem;
			ListView_GetItem(lpNMHDR->hwndFrom, &item);
			if(item.lParam != 0)
				reinterpret_cast<IDebugStackFrame*>(item.lParam)->Release();
			return true;
		} else if(lpNMHDR->code == NM_DBLCLK) {	// _uNbN -> X^bNt[ɑΉvVWɈړ
			item.mask = LVIF_PARAM;
			item.iItem = reinterpret_cast<LPNMLISTVIEW>(lpNMHDR)->iItem;
			item.iSubItem = 0;
			ListView_GetItem(lpNMHDR->hwndFrom, &item);
			if(item.lParam != 0) {
				CComPtr<IDebugCodeContext>		pCodeContext;
				CComPtr<IDebugDocumentContext>	pDocContext;
				CComPtr<IDebugDocument>			pDocument;
				CComPtr<IDebugDocumentText>		pDocText;
				unsigned long					nPosition, iLine, iChar, cch;

				// sԍ擾
				reinterpret_cast<IDebugStackFrame*>(item.lParam)->GetCodeContext(&pCodeContext);
				pCodeContext->GetDocumentContext(&pDocContext);
				pDocContext->GetDocument(&pDocument);
				pDocument->QueryInterface(IID_IDebugDocument, reinterpret_cast<void**>(&pDocText));
				pDocText->GetPositionOfContext(pDocContext, &nPosition, &cch);
				pDocText->GetLineOfPosition(nPosition, &iLine, &iChar);

				// Lbgړ
				const CAlphaDoc*	pDoc = m_pDebugger->GetDebuggingDocument();
				CAlphaView*			pView = pDoc->GetController()->GetActiveView();
				pView->SetSelWithoutSelection(iLine, 0);
				pView->SetFocus();
			}
			return true;
		}
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CDialog::OnSize
void CDebugCallStackDlg::OnSize(UINT nType, int cx, int cy) {
	::MoveWindow(GetDlgItem(IDC_LIST_DEBUGSTACKFRAMES), 0, 0, cx, cy, true);
}


// CDebugImmediateDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDebugImmediateDlg::CDebugImmediateDlg() : m_pDebugger(0) {
}

///	fXgN^
CDebugImmediateDlg::~CDebugImmediateDlg() {
}

///	]Čʂ\
void CDebugImmediateDlg::OnEvaluateExpression() {
	AssertValidAsWindow();
	assert(m_pDebugger != 0);

	HRESULT				hr;
	DebugPropertyInfo	dpi;
	wchar_t*			pwszInput = 0;
	size_t				cchInput;
	unsigned int		nOutputRadix;
	bool				bNoSideEffects;

	// ͂ƃIvV̎擾
	cchInput = ::GetWindowTextLength(GetDlgItem(IDC_EDIT_INPUT));
	pwszInput = new wchar_t[cchInput + 1];
	GetDlgItemText(IDC_EDIT_INPUT, pwszInput, cchInput + 1);
	nOutputRadix = (IsDlgButtonChecked(IDC_CHK_USEHEXADECIMAL) == BST_CHECKED) ? 16 : 10;
	bNoSideEffects = IsDlgButtonChecked(IDC_CHK_EVALWITHNOSIDEEFFECTS) == BST_CHECKED;

	// fobK猋ʂ擾
	dpi.m_dwValidFields = DBGPROP_INFO_ALL;
	dpi.m_dwValidFields &= ~DBGPROP_INFO_DEBUGPROP;
	hr = m_pDebugger->EvaluateExpression(pwszInput, nOutputRadix, bNoSideEffects, &dpi);
	if(hr == E_ABORT)
		SetDlgItemText(IDC_EDIT_OUTPUT, L"(^CAEg܂)");
	else if(FAILED(hr))
		SetDlgItemText(IDC_EDIT_OUTPUT, L"(]Ɏs܂)");
	else {
		wstring	strOutput = L"O:\t";	// []
		if(toBoolean(dpi.m_dwValidFields & DBGPROP_INFO_NAME))
			(strOutput += dpi.m_bstrName), ::SysFreeString(dpi.m_bstrName);
		else
			strOutput += L"(擾ł܂ł)";
		strOutput += L"\r\nS:\t";
		if(toBoolean(dpi.m_dwValidFields & DBGPROP_INFO_FULLNAME))
			(strOutput += dpi.m_bstrFullName), ::SysFreeString(dpi.m_bstrFullName);
		else
			strOutput += L"(擾ł܂ł)";
		strOutput += L"\r\n^:\t";
		if(toBoolean(dpi.m_dwValidFields & DBGPROP_INFO_TYPE))
			(strOutput += dpi.m_bstrType), ::SysFreeString(dpi.m_bstrType);
		else
			strOutput += L"(擾ł܂ł)";
		strOutput += L"\r\nl:\t";
		if(toBoolean(dpi.m_dwValidFields & DBGPROP_INFO_VALUE))
			(strOutput += dpi.m_bstrValue), ::SysFreeString(dpi.m_bstrValue);
		else
			strOutput += L"(擾ł܂ł)";
/*		if(toBoolean(dpi.m_dwValidFields & DBGPROP_INFO_ATTRIBUTES)) {
			strOutput += L"\r\n:\tȉ̑ݒ肳Ă܂";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_VALUE_IS_INVALID)		strOutput += L"\r\n  +is_invalid";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_VALUE_IS_EXPANDABLE)		strOutput += L"\r\n  +is_expandable";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_VALUE_READONLY)			strOutput += L"\r\n  +readonly";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_ACCESS_PUBLIC)			strOutput += L"\r\n  +public";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_ACCESS_PRIVATE)			strOutput += L"\r\n  +private";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_ACCESS_PROTECTED)		strOutput += L"\r\n  +protected";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_ACCESS_FINAL)			strOutput += L"\r\n  +final";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_STORAGE_GLOBAL)			strOutput += L"\r\n  +global";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_STORAGE_STATIC)			strOutput += L"\r\n  +static";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_STORAGE_FIELD)			strOutput += L"\r\n  +field";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_STORAGE_VIRTUAL)			strOutput += L"\r\n  +virtual";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_TYPE_IS_CONSTANT)		strOutput += L"\r\n  +constant";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_TYPE_IS_SYNCHRONIZED)	strOutput += L"\r\n  +synchronized";
			if(dpi.m_dwAttrib & DBGPROP_ATTRIB_TYPE_IS_VOLATILE)		strOutput += L"\r\n  +volatile";
		} else
			strOutput += L"\n:\t(擾ł܂ł)";
*/
		SetDlgItemText(IDC_EDIT_OUTPUT, strOutput.c_str());
	}

	delete pwszInput;
	::SetFocus(GetDlgItem(IDC_EDIT_INPUT));
	SendDlgItemMessage(IDC_EDIT_INPUT, EM_SETSEL, 0, -1);
}

///	VfobOAvP[VXbh̐ݒ
void CDebugImmediateDlg::Update(Alpha::CAlphaApplicationDebugger* pDebugger) {
	AssertValidAsWindow();
	m_pDebugger = pDebugger;
}

///	@see	CDialog::Command
bool CDebugImmediateDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_BTN_UPDATE)
		OnEvaluateExpression();
	else if(wID == IDC_EDIT_INPUT && wNotifyCode == EN_CHANGE)
		::EnableWindow(GetDlgItem(IDC_BTN_UPDATE), ::GetWindowTextLength(GetDlgItem(IDC_EDIT_INPUT)) != 0);

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CDebugImmediateDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CheckDlg2StateButton(IDC_CHK_EVALWITHNOSIDEEFFECTS);

	return true;
}


// CDebugRunningDocumentsDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	ċAIɃAvP[Vm[hc[r[ɍ\z
 *	@param pParentNode	em[h
 *	@param hParent		eACe
 */
void CDebugRunningDocumentsDlg::_MakeNodeTree(IDebugApplicationNode* pParentNode, HTREEITEM hParent) {
	assert(pParentNode != 0);

	CComPtr<IEnumDebugApplicationNodes>	pAppNodeEnumerator;
	IDebugApplicationNode*				pAppNode = 0;
	BSTR								bstrDocumentName;
	TDocumentNode*						pDocumentNode = 0;
	unsigned long						cFetched;

	HWND			hwndRunningDocumentsTreeView = GetDlgItem(IDC_TREE_ACTIVEDOCUMENTS);
	TVINSERTSTRUCT	tvis;
	HTREEITEM		hItem;

	if(FAILED(pParentNode->EnumChildren(&pAppNodeEnumerator)))
		return;

	pAppNodeEnumerator->Reset();
	tvis.item.mask = TVIF_TEXT | TVIF_PARAM;

	while(S_OK == pAppNodeEnumerator->Next(1, &pAppNode, &cFetched)) {
		pAppNode->GetName(DOCUMENTNAMETYPE_APPNODE, &bstrDocumentName);
		pDocumentNode = new TDocumentNode;
		pDocumentNode->bNodeIsApplication = false;
		pDocumentNode->oNodeObject.pAppNode = pAppNode;

		tvis.hParent = hParent;
		tvis.hInsertAfter = TVI_LAST;
		tvis.item.pszText = bstrDocumentName;
		tvis.item.lParam = reinterpret_cast<LPARAM>(pDocumentNode);
		hItem = TreeView_InsertItem(hwndRunningDocumentsTreeView, &tvis);

		::SysFreeString(bstrDocumentName);

		_MakeNodeTree(pAppNode, hItem);
	}
}

///	hLgXgŐV̂̂ɂ
void CDebugRunningDocumentsDlg::Update() {
	AssertValidAsWindow();

	CComPtr<IMachineDebugManager>			pMachineDebugManager;
	CComPtr<IEnumRemoteDebugApplications>	pApplicationEnumerator;
	IRemoteDebugApplication*				pApplication = 0;
	IDebugApplicationNode*					pApplicationNode = 0;
	unsigned long							cFetched;
	BSTR									bstrName;
	TDocumentNode*							pDocumentNode = 0;

	HWND			hwndRunningDocumentsTreeView = GetDlgItem(IDC_TREE_ACTIVEDOCUMENTS);
	HTREEITEM		hItem;
	TVINSERTSTRUCT	tvis;

	// Zbg
	TreeView_DeleteAllItems(hwndRunningDocumentsTreeView);

	// MDM shLg擾
	if(FAILED(pMachineDebugManager.CreateInstance(CLSID_MachineDebugManager)))
		return;
	if(FAILED(pMachineDebugManager->EnumApplications(&pApplicationEnumerator)))
		return;
	if(pApplicationEnumerator == 0)
		return;

	// c[ɒǉĂ
	tvis.item.mask = TVIF_TEXT | TVIF_PARAM;
	pApplicationEnumerator->Reset();
	while(S_OK == pApplicationEnumerator->Next(1, &pApplication, &cFetched)) {
		pDocumentNode = new TDocumentNode;
		pDocumentNode->bNodeIsApplication = true;
		pDocumentNode->oNodeObject.pApplication = pApplication;
		pApplication->GetName(&bstrName);
		tvis.hParent = TVI_ROOT;
		tvis.hInsertAfter = TVI_LAST;
		tvis.item.pszText = bstrName;
		tvis.item.lParam = reinterpret_cast<LPARAM>(pDocumentNode);
		hItem = TreeView_InsertItem(hwndRunningDocumentsTreeView, &tvis);
		::SysFreeString(bstrName);

		pApplication->GetRootNode(&pApplicationNode);
		_MakeNodeTree(pApplicationNode, hItem);
	}
}

///	@see	CDialog::OnInitDialog
bool CDebugRunningDocumentsDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	Update();
	return true;
}

///	@see	CDialog::OnNotify
bool CDebugRunningDocumentsDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_TREE_ACTIVEDOCUMENTS && lpNMHDR->code == TVN_DELETEITEM) {
		delete reinterpret_cast<TDocumentNode*>(reinterpret_cast<LPNMTREEVIEWW>(lpNMHDR)->itemOld.lParam);
		return true;
	}

	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CDialog::OnSize
void CDebugRunningDocumentsDlg::OnSize(UINT nType, int cx, int cy) {
	::MoveWindow(GetDlgItem(IDC_TREE_ACTIVEDOCUMENTS), 0, 0, cx, cy, true);
}


// CDebugThreadsDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	XbhXgr[XV
void CDebugThreadsDlg::Update(IRemoteDebugApplication* pApplication) {
	AssertValidAsWindow();
	assert(pApplication != 0);

	CComPtr<IEnumRemoteDebugApplicationThreads>	pThreadEnumerator;
	IRemoteDebugApplicationThread*				pThread = 0;
	CComPtr<IEnumDebugStackFrames>				pStackFrameEnumerator;
	DebugStackFrameDescriptor					dsfd;
	HRESULT			hr;
	unsigned long	cFetched;
	HWND			hwndThreadListView = GetDlgItem(IDC_LIST_DEBUGTHREADS);
	LVITEMW			item;

	// Xg̃NA
	item.mask = LVIF_PARAM;
	item.iItem = item.iSubItem = 0;
	while(ListView_GetItemCount(hwndThreadListView) != 0) {
		ListView_GetItem(hwndThreadListView, &item);
		reinterpret_cast<IRemoteDebugApplicationThread*>(item.lParam)->Release();
		item.lParam = 0L;								// 폜 OnNotify Ăяô
		ListView_SetItem(hwndThreadListView, &item);	// item.lParam 𖳌ɂ
		ListView_DeleteItem(hwndThreadListView, 0);
	}

	if(FAILED(pApplication->EnumThreads(&pThreadEnumerator)))
		return;

	unsigned long	nData;
	wchar_t			wszData[100];
	BSTR			bstrLocation;
	while(pThreadEnumerator->Next(1, &pThread, &cFetched) == S_OK) {
		// [ID]
		pThread->GetSystemThreadId(&nData);
		swprintf(wszData, L"0x%08lX", nData);
		item.mask = LVIF_TEXT | LVIF_PARAM;
		item.iSubItem = 0;
		item.pszText = wszData;
		item.lParam = reinterpret_cast<LPARAM>(pThread);
		ListView_InsertItem(hwndThreadListView, &item);
		
		// [ꏊ]
		item.mask = LVIF_TEXT;
		hr = pThread->EnumStackFrames(&pStackFrameEnumerator);
		if(SUCCEEDED(hr)) {
			pStackFrameEnumerator->Reset();
			hr = pStackFrameEnumerator->Next(1, &dsfd, &cFetched);
			if(SUCCEEDED(hr)) {
				dsfd.pdsf->GetDescriptionString(true, &bstrLocation);
				item.iSubItem = 1;
				item.pszText = bstrLocation;
				ListView_SetItem(hwndThreadListView, &item);
				::SysFreeString(bstrLocation);
				dsfd.pdsf->Release();
			}
		}
		if(FAILED(hr)) {
			item.iSubItem = 1;
			item.pszText = L"s";
			ListView_SetItem(hwndThreadListView, &item);
		}

		// [D揇]
		hr = pThread->GetState(&nData);
		swprintf(wszData, SUCCEEDED(hr) ? L"%lu" : L"s", nData);
		item.iSubItem = 2;
		item.pszText = wszData;
		ListView_SetItem(hwndThreadListView, &item);

		// [f]
		hr = pThread->GetSuspendCount(&nData);
		swprintf(wszData, SUCCEEDED(hr) ? L"%lu" : L"s", nData);
		item.iSubItem = 3;
		item.pszText = wszData;
		ListView_SetItem(hwndThreadListView, &item);

		++item.iItem;
	}

	ListView_SetItemState(hwndThreadListView, 0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	::SetFocus(hwndThreadListView);
}

///	@see	CDialog::OnCommand
bool CDebugThreadsDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_BTN_SUSPEND || wID == IDC_BTN_RESUME) {	// [~]A[ĊJ]
		CComPtr<IRemoteDebugApplicationThread>	pThread;
		LVITEMW									item;
		HWND									hwndThreadsListView = GetDlgItem(IDC_LIST_DEBUGTHREADS);
		DWORD									cSuspend;
		wchar_t									wszSuspendCount[10];
		HRESULT									hr;

		item.mask = LVIF_PARAM;
		item.iItem = ListView_GetSelectionMark(hwndThreadsListView);
		if(item.iItem == -1)
			return true;
		ListView_GetItem(hwndThreadsListView, &item);
		pThread = reinterpret_cast<IRemoteDebugApplicationThread*>(item.lParam);
		if(wID == IDC_BTN_SUSPEND)
			hr = pThread->Suspend(&cSuspend);
		else
			hr = pThread->Resume(&cSuspend);
		pThread->GetSuspendCount(&cSuspend);
		::EnableWindow(GetDlgItem(IDC_BTN_RESUME), cSuspend > 0);

		if(hr == E_NOTIMPL) {
			MessageBox(L"XNvgGW͂̑T|[gĂ܂B",
				IDS_APPNAME, MB_ICONINFORMATION);
			return true;
		}

		// XV
		item.mask = LVIF_TEXT;
		item.iSubItem = 3;
		pThread->GetSuspendCount(&cSuspend);
		swprintf(wszSuspendCount, L"%lu", cSuspend);
		item.pszText = wszSuspendCount;
		ListView_SetItem(hwndThreadsListView, &item);
		ListView_SetSelectionMark(hwndThreadsListView, item.iItem);

		return true;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

bool CDebugThreadsDlg::OnContextMenu(HWND hWnd, POINT pt) {
	HWND			hwndThreadsListView = GetDlgItem(IDC_LIST_DEBUGTHREADS);
	LVHITTESTINFO	lvhi;

	lvhi.pt = pt;
	::ScreenToClient(hwndThreadsListView, &lvhi.pt);
	if(-1 == ListView_HitTest(hwndThreadsListView, &lvhi) || !toBoolean(lvhi.flags & LVHT_ONITEM))
		return true;

	LVITEMW									item;
	CComPtr<IRemoteDebugApplicationThread>	pThread;
	DWORD									cSuspend;

	item.mask = LVIF_PARAM;
	item.iItem = ListView_GetSelectionMark(hwndThreadsListView);
	if(item.iItem != -1) {
		ListView_GetItem(hwndThreadsListView, &item);
		pThread = reinterpret_cast<IRemoteDebugApplicationThread*>(item.lParam);
		if(pThread != 0) {
			pThread->GetSuspendCount(&cSuspend);
			::EnableMenuItem(m_hContextMenu,
				IDC_BTN_RESUME, MF_BYCOMMAND | ((cSuspend > 0) ? MF_ENABLED : MF_GRAYED));
		}
	} else {	// I
		::EnableMenuItem(m_hContextMenu, IDC_BTN_SUSPEND, MF_BYCOMMAND | MF_GRAYED);
		::EnableMenuItem(m_hContextMenu, IDC_BTN_RESUME, MF_BYCOMMAND | MF_GRAYED);
	}
	::TrackPopupMenu(m_hContextMenu, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, m_hWnd, 0);
	return true;
}

///	@see	CDialog::OnDestory
void CDebugThreadsDlg::OnDestroy() {
	HWND	hwndAppListBox = GetDlgItem(IDC_LIST_DEBUGAPPLICATIONS);
	HWND	hwndThreadListView = GetDlgItem(IDC_LIST_DEBUGTHREADS);
	LVITEMW	item;

	// Xg̃NA
	while(::SendMessage(hwndAppListBox, LB_GETCOUNT, 0, 0L) != 0) {
		reinterpret_cast<IRemoteDebugApplication*>(
			::SendMessage(hwndAppListBox, LB_GETITEMDATA, 0, 0L))->Release();
		::SendMessage(hwndAppListBox, LB_DELETESTRING, 0, 0L);
	}
	item.mask = LVIF_PARAM;
	item.iItem = item.iSubItem = 0;
	while(ListView_GetItemCount(hwndThreadListView) != 0) {
		ListView_GetItem(hwndThreadListView, &item);
		reinterpret_cast<IRemoteDebugApplicationThread*>(item.lParam)->Release();
		item.lParam = 0L;
		ListView_SetItem(hwndThreadListView, &item);
		ListView_DeleteItem(hwndThreadListView, 0);
	}

	::DestroyMenu(m_hContextMenu);

	CDialog::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CDebugThreadsDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	LVCOLUMNW	column;
	HWND		hwndThreadListView = GetDlgItem(IDC_LIST_DEBUGTHREADS);
	long		nStyle;

	nStyle = ::GetWindowLong(hwndThreadListView, GWL_EXSTYLE);
	::SetWindowLong(hwndThreadListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	ListView_SetExtendedListViewStyle(hwndThreadListView, LVS_EX_FULLROWSELECT);
	column.mask = LVCF_TEXT | LVCF_WIDTH;
	column.pszText = L"ID";
	column.cx = 74;
	ListView_InsertColumn(hwndThreadListView, 0, &column);
	column.pszText = L"ꏊ";
	column.cx = 180;
	ListView_InsertColumn(hwndThreadListView, 1, &column);
	column.pszText = L"D揇";
	column.cx = 68;
	ListView_InsertColumn(hwndThreadListView, 2, &column);
	column.pszText = L"f";
	column.cx = 64;
	ListView_InsertColumn(hwndThreadListView, 3, &column);

	m_hContextMenu = ::CreatePopupMenu();
	::AppendMenu(m_hContextMenu, MF_STRING, IDC_BTN_SUSPEND, L"~(&S)");
	::AppendMenu(m_hContextMenu, MF_STRING, IDC_BTN_RESUME, L"ĊJ(&R)");

	return true;
}

///	@see	CDialog::OnSize
void CDebugThreadsDlg::OnSize(UINT nType, int cx, int cy) {
	::MoveWindow(GetDlgItem(IDC_LIST_DEBUGTHREADS), 0, 0, cx, cy, true);
}


// CDebugVariablesDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDebugVariablesDlg::CDebugVariablesDlg() : m_pDebugger(0), m_pGlobalFrame(0), m_nRadix(10) {
}

///	fXgN^
CDebugVariablesDlg::~CDebugVariablesDlg() {
	if(m_pDebugger != 0)
		m_pDebugger->Release();
}

///	[ReLXg] R{{bNXɂ
void CDebugVariablesDlg::_CleanupCallStacks() {
	HWND	hwndContextCombobox = GetDlgItem(IDC_COMBO_CALLSTACKS);

	if(m_pGlobalFrame != 0) {
		m_pGlobalFrame->Release();
		m_pGlobalFrame = 0;
	}
	while(::SendMessage(hwndContextCombobox, CB_GETCOUNT, 0, 0L) != 0) {
		reinterpret_cast<IDebugStackFrame*>(
			::SendMessage(hwndContextCombobox, CB_GETITEMDATA, 0, 0L))->Release();
		::SendMessage(hwndContextCombobox, CB_DELETESTRING, 0, 0L);
	}
}

/// vpeBWJ/k
void CDebugVariablesDlg::_ExpandProperty(HWND hwndListView) {
	LVITEMW	item;

	item.iItem = ListView_GetSelectionMark(hwndListView);
	if(item.iItem == -1)
		return;

	item.mask = LVIF_PARAM;
	item.iSubItem = 0;
	ListView_GetItem(hwndListView, &item);

	assert(item.lParam != 0);

	TPropertyItem*	pItem = reinterpret_cast<TPropertyItem*>(item.lParam);
	unsigned int	nTargetIndent = pItem->nIndent + 2;	// ǉ/폜ACẽCfg

	if(pItem->bExpanded) {	// WJĂȂ

		pItem->bExpanded = false;
		++item.iItem;
		while(toBoolean(ListView_GetItem(hwndListView, &item))) {
			pItem = reinterpret_cast<TPropertyItem*>(item.lParam);
			if(pItem->nIndent == nTargetIndent)
				ListView_DeleteItem(hwndListView, item.iItem);
			else
				break;
		}
	} else {	// WJ
		CComPtr<IEnumDebugPropertyInfo>	pMemberEnumerator;
		unsigned long					cMembers;
		DebugPropertyInfo*				pPropertyInfos = 0;

		pItem->bExpanded = true;

		// o̗
		if(S_OK == pItem->pProperty->EnumMembers(
				DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE | DBGPROP_INFO_DEBUGPROP,
				m_nRadix, IID_IEnumDebugPropertyInfo, &pMemberEnumerator)) {
			wstring	strText;
			if(pMemberEnumerator == 0)
				return;
			pMemberEnumerator->Reset();
			pMemberEnumerator->GetCount(&cMembers);
			if(cMembers == 0) {	// o
				pItem = new TPropertyItem;
				strText.assign(pItem->nIndent + 2, L' ');
				strText += L"(vpeB͂܂)";
				item.mask = LVIF_TEXT | LVIF_PARAM;
				++item.iItem;
				item.iSubItem = 0;
				item.pszText = const_cast<wchar_t*>(strText.c_str());
				item.lParam = reinterpret_cast<LPARAM>(pItem);
				pItem->nIndent = pItem->nIndent + 2;
				ListView_InsertItem(hwndListView, &item);
			} else {
				pPropertyInfos = new DebugPropertyInfo[cMembers];
				if(S_OK == pMemberEnumerator->Next(cMembers, pPropertyInfos, &cMembers)) {
					for(unsigned long iMember = 0; iMember < cMembers; ++iMember) {
						TPropertyItem*	pItem = new TPropertyItem;

						strText.assign(nTargetIndent, L' ');
						strText += pPropertyInfos[iMember].m_bstrName;
						item.mask = LVIF_TEXT | LVIF_PARAM;
						++item.iItem;
						item.iSubItem = 0;
						item.pszText = const_cast<wchar_t*>(strText.c_str());
						item.lParam = reinterpret_cast<LPARAM>(pItem);
						pItem->pProperty = pPropertyInfos[iMember].m_pDebugProp;
						pItem->nIndent = nTargetIndent;
						ListView_InsertItem(hwndListView, &item);

						item.mask = LVIF_TEXT;
						++item.iSubItem;
						item.pszText = pPropertyInfos[iMember].m_bstrValue;
						ListView_SetItem(hwndListView, &item);

						++item.iSubItem;
						item.pszText = pPropertyInfos[iMember].m_bstrType;
						ListView_SetItem(hwndListView, &item);

						::SysFreeString(pPropertyInfos[iMember].m_bstrName);
						::SysFreeString(pPropertyInfos[iMember].m_bstrType);
						::SysFreeString(pPropertyInfos[iMember].m_bstrValue);
					}
				}
				delete[] pPropertyInfos;
			}
		}
	}

}

///	ϐXgXV
void CDebugVariablesDlg::_ShowMembers() {
	CComPtr<IDebugStackFrame>		pStackFrame;
	CComPtr<IDebugProperty>			pProperty;
	CComPtr<IEnumDebugPropertyInfo>	pMemberEnumerator;
	DebugPropertyInfo*				pPropertyInfos = 0;

	HWND			hwndContextCombobox = GetDlgItem(IDC_COMBO_CALLSTACKS);
	HWND			hwndGlobalListView = GetDlgItem(IDC_LIST_GLOBALVARIABLES);
	HWND			hwndLocalListView = GetDlgItem(IDC_LIST_LOCALVARIABLES);
	HWND			hwndWatchListView = GetDlgItem(IDC_LIST_WATCH);
	int				iCursel = ::SendMessage(hwndContextCombobox, CB_GETCURSEL, 0, 0L);
	unsigned long	cMembers;
	LVITEMW			item;

	// [O[o]
	ListView_DeleteAllItems(hwndGlobalListView);
	m_pGlobalFrame->GetDebugProperty(&pProperty);
	pProperty->EnumMembers(
		DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE | DBGPROP_INFO_DEBUGPROP, m_nRadix,
		IID_IEnumDebugPropertyInfo, &pMemberEnumerator);
	pMemberEnumerator->Reset();
	pMemberEnumerator->GetCount(&cMembers);
	if(cMembers != 0) {
		pPropertyInfos = new DebugPropertyInfo[cMembers];
		if(S_OK == pMemberEnumerator->Next(cMembers, pPropertyInfos, &cMembers)) {
			for(item.iItem = 0; item.iItem < static_cast<long>(cMembers); ++item.iItem) {
				TPropertyItem*	pItem = new TPropertyItem;

				item.mask = LVIF_TEXT | LVIF_PARAM;
				item.iSubItem = 0;
				item.pszText = pPropertyInfos[item.iItem].m_bstrName;
				item.lParam = reinterpret_cast<LPARAM>(pItem);
				pItem->pProperty = pPropertyInfos[item.iItem].m_pDebugProp;
				ListView_InsertItem(hwndGlobalListView, &item);

				item.mask = LVIF_TEXT;
				++item.iSubItem;
				item.pszText = pPropertyInfos[item.iItem].m_bstrValue;
				ListView_SetItem(hwndGlobalListView, &item);

				++item.iSubItem;
				item.pszText = pPropertyInfos[item.iItem].m_bstrType;
				ListView_SetItem(hwndGlobalListView, &item);

				::SysFreeString(pPropertyInfos[item.iItem].m_bstrName);
				::SysFreeString(pPropertyInfos[item.iItem].m_bstrType);
				::SysFreeString(pPropertyInfos[item.iItem].m_bstrValue);
			}
		}
		delete[] pPropertyInfos;
	}

	pProperty = 0;
	pMemberEnumerator = 0;

	// [[J]
	ListView_DeleteAllItems(hwndLocalListView);
	pStackFrame = reinterpret_cast<IDebugStackFrame*>(
		::SendMessage(hwndContextCombobox, CB_GETITEMDATA, iCursel, 0L));
	pStackFrame->GetDebugProperty(&pProperty);
	pProperty->EnumMembers(
		DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE | DBGPROP_INFO_DEBUGPROP, m_nRadix,
		IID_IEnumDebugPropertyInfo, &pMemberEnumerator);
	pMemberEnumerator->Reset();
	pMemberEnumerator->GetCount(&cMembers);
	if(cMembers != 0) {
		pPropertyInfos = new DebugPropertyInfo[cMembers];
		if(S_OK == pMemberEnumerator->Next(cMembers, pPropertyInfos, &cMembers)) {
			for(item.iItem = 0; item.iItem < static_cast<long>(cMembers); ++item.iItem) {
				TPropertyItem*	pItem = new TPropertyItem;

				item.mask = LVIF_TEXT | LVIF_PARAM;
				item.iSubItem = 0;
				item.pszText = pPropertyInfos[item.iItem].m_bstrName;
				item.lParam = reinterpret_cast<LPARAM>(pItem);
				pItem->pProperty = pPropertyInfos[item.iItem].m_pDebugProp;
				ListView_InsertItem(hwndLocalListView, &item);

				item.mask = LVIF_TEXT;
				++item.iSubItem;
				item.pszText = pPropertyInfos[item.iItem].m_bstrValue;
				ListView_SetItem(hwndLocalListView, &item);

				++item.iSubItem;
				item.pszText = pPropertyInfos[item.iItem].m_bstrType;
				ListView_SetItem(hwndLocalListView, &item);

				::SysFreeString(pPropertyInfos[item.iItem].m_bstrName);
				::SysFreeString(pPropertyInfos[item.iItem].m_bstrType);
				::SysFreeString(pPropertyInfos[item.iItem].m_bstrValue);
			}
		}
		delete[] pPropertyInfos;
	}

	// [EHb`]
	pPropertyInfos = new DebugPropertyInfo;
	pPropertyInfos->m_dwValidFields = DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
	ListView_DeleteAllItems(hwndWatchListView);
	item.iItem = 0;
	for(list<wstring>::const_iterator it = m_listWatchingExpressions.begin();
			it != m_listWatchingExpressions.end(); ++item.iItem, ++it) {
		m_pDebugger->EvaluateExpression(*it, m_nRadix, true, pPropertyInfos);
		item.iSubItem = 0;
		item.pszText = const_cast<wchar_t*>(it->c_str());
		ListView_InsertItem(hwndWatchListView, &item);
		++item.iSubItem;
		item.pszText = pPropertyInfos->m_bstrValue;
		ListView_SetItem(hwndWatchListView, &item);
		++item.iSubItem;
		item.pszText = pPropertyInfos->m_bstrType;
		ListView_SetItem(hwndWatchListView, &item);
		::SysFreeString(pPropertyInfos->m_bstrType);
		::SysFreeString(pPropertyInfos->m_bstrValue);
	}
	delete pPropertyInfos;
	item.iSubItem = 0;
	item.pszText = L"";
	ListView_InsertItem(hwndWatchListView, &item);
}

///	@see	CDialog::OnCommand
bool CDebugVariablesDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_COMBO_CALLSTACKS && wNotifyCode == CBN_SELCHANGE)
		_ShowMembers();
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnDestroy
void CDebugVariablesDlg::OnDestroy() {
	_CleanupCallStacks();
	CDialog::OnDestroy();
}

///	@see	CDialog::OnInitDialog
bool CDebugVariablesDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

//	ModifyStyleEx(0, WS_EX_LAYERED);
//	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	HWND		hwndTab = GetDlgItem(IDC_TAB_VARIABLES);
	HWND		hwndGlobalListView = GetDlgItem(IDC_LIST_GLOBALVARIABLES);
	HWND		hwndLocalListView = GetDlgItem(IDC_LIST_LOCALVARIABLES);
	HWND		hwndWatchListView = GetDlgItem(IDC_LIST_WATCH);
	TCITEMW		item;
	LVCOLUMNW	column;
	long		nStyle;

	// ^u̐ݒ
	item.mask = TCIF_TEXT;
	item.pszText = L"O[o";
	TabCtrl_InsertItem(hwndTab, 0, &item);
	item.pszText = L"[J";
	TabCtrl_InsertItem(hwndTab, 1, &item);
	item.pszText = L"EHb`";
	TabCtrl_InsertItem(hwndTab, 2, &item);

	// Xgr[̐ݒ
	column.mask = LVCF_TEXT | LVCF_WIDTH;
	column.cx = 100;
	column.pszText = L"V{";
	ListView_InsertColumn(hwndGlobalListView, 0, &column);
	ListView_InsertColumn(hwndLocalListView, 0, &column);
	ListView_InsertColumn(hwndWatchListView, 0, &column);
	column.cx = 240;
	column.pszText = L"l";
	ListView_InsertColumn(hwndGlobalListView, 1, &column);
	ListView_InsertColumn(hwndLocalListView, 1, &column);
	ListView_InsertColumn(hwndWatchListView, 1, &column);
	column.cx = 70;
	column.pszText = L"^";
	ListView_InsertColumn(hwndGlobalListView, 2, &column);
	ListView_InsertColumn(hwndLocalListView, 2, &column);
	ListView_InsertColumn(hwndWatchListView, 2, &column);
	nStyle = ::GetWindowLong(hwndGlobalListView, GWL_EXSTYLE);
	::SetWindowLong(hwndGlobalListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	nStyle = ::GetWindowLong(hwndLocalListView, GWL_EXSTYLE);
	::SetWindowLong(hwndLocalListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	nStyle = ::GetWindowLong(hwndWatchListView, GWL_EXSTYLE);
	::SetWindowLong(hwndWatchListView, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	ListView_SetExtendedListViewStyle(hwndGlobalListView, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
	ListView_SetExtendedListViewStyle(hwndLocalListView, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
	ListView_SetExtendedListViewStyle(hwndWatchListView, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);

	NMHDR	hdr = {hwndTab, IDC_TAB_VARIABLES, TCN_SELCHANGE};
	OnNotify(IDC_TAB_VARIABLES, &hdr);

	return true;
}

///	@see	CDialog::OnNotify
bool CDebugVariablesDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(lpNMHDR->code == LVN_ENDLABELEDIT) {
		wchar_t	wszOrigin[1024];

		ListView_GetItemText(lpNMHDR->hwndFrom,
			reinterpret_cast<LPNMLVDISPINFOW>(lpNMHDR)->item.iItem, 0, wszOrigin, 1024);
		return true;
	} else if(lpNMHDR->code == LVN_DELETEITEM) {
		LVITEMW			item;

		item.mask = LVIF_PARAM;
		item.iItem = item.iSubItem = reinterpret_cast<LPNMLISTVIEW>(lpNMHDR)->iItem;
		ListView_GetItem(lpNMHDR->hwndFrom, &item);
		if(item.lParam != 0)
			delete reinterpret_cast<TPropertyItem*>(item.lParam);
		return true;
	} else if(lpNMHDR->code == TCN_SELCHANGE) {
		int	iCursel = TabCtrl_GetCurSel(lpNMHDR->hwndFrom);
		::ShowWindow(GetDlgItem(IDC_LIST_GLOBALVARIABLES), (iCursel == 0) ? SW_SHOW : SW_HIDE);
		::ShowWindow(GetDlgItem(IDC_LIST_LOCALVARIABLES), (iCursel == 1) ? SW_SHOW : SW_HIDE);
		::ShowWindow(GetDlgItem(IDC_LIST_WATCH), (iCursel == 2) ? SW_SHOW : SW_HIDE);
		return true;
	} else if(lpNMHDR->code == NM_DBLCLK &&
			(idCtrl == IDC_LIST_GLOBALVARIABLES || idCtrl == IDC_LIST_LOCALVARIABLES || idCtrl == IDC_LIST_WATCH)) {
		_ExpandProperty(lpNMHDR->hwndFrom);
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CDialog::OnSize
void CDebugVariablesDlg::OnSize(UINT nType, int cx, int cy) {
	::MoveWindow(GetDlgItem(IDC_COMBO_CALLSTACKS), 80, 5, cx - 84, 14, true);
	::MoveWindow(GetDlgItem(IDC_TAB_VARIABLES), 0, 28, cx, cy - 28, true);
	::MoveWindow(GetDlgItem(IDC_LIST_GLOBALVARIABLES), 4, 50, cx - 8, cy - 54, true);
	::MoveWindow(GetDlgItem(IDC_LIST_LOCALVARIABLES), 4, 50, cx - 8, cy - 54, true);
	::MoveWindow(GetDlgItem(IDC_LIST_WATCH), 4, 50, cx - 8, cy - 54, true);
}

///	VfobOAvP[VXbh̐ݒ
void CDebugVariablesDlg::Update(Alpha::CAlphaApplicationDebugger* pDebugger) {
	AssertValid();
	assert(pDebugger != 0);

	HRESULT									hr;
	CComPtr<IRemoteDebugApplicationThread>	pThread;
	CComPtr<IEnumDebugStackFrames>			pStackFrameEnumerator;
	DebugStackFrameDescriptor				dsfd;

	HWND			hwndContextCombobox = GetDlgItem(IDC_COMBO_CALLSTACKS);
	int				iInserted;
	unsigned long	cFetched;
	wchar_t*		pwszFrameName = 0;

	if(m_pDebugger != 0)
		m_pDebugger->Release();
	m_pDebugger = pDebugger;
	m_pDebugger->AddRef();

	// [ReLXg]
	_CleanupCallStacks();
	m_pDebugger->GetDebuggingApplicationThread(&pThread);
	hr = pThread->EnumStackFrames(&pStackFrameEnumerator);
	if(SUCCEEDED(hr)) {
		BSTR	bstrName;
		pStackFrameEnumerator->Reset();
		while(S_OK == pStackFrameEnumerator->Next(1, &dsfd, &cFetched)) {
			m_pGlobalFrame = dsfd.pdsf;
			dsfd.pdsf->GetDescriptionString(false, &bstrName);
			pwszFrameName = new wchar_t[wcslen(bstrName) + 12];
			swprintf(pwszFrameName, L"0x%08lx %s", dsfd.dwMin, bstrName);
			::SysFreeString(bstrName);
			iInserted = ::SendMessage(hwndContextCombobox,
				CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszFrameName));
			::SendMessage(hwndContextCombobox,
				CB_SETITEMDATA, iInserted, reinterpret_cast<LPARAM>(dsfd.pdsf));
		}
		m_pGlobalFrame->AddRef();	// ŌɈ̂t[
	}
	::SendMessage(hwndContextCombobox, CB_SETCURSEL, 0, 0L);
	_ShowMembers();
}

/* [EOF] */