// LineLayout.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "LineLayout.h"
#include "EditView.h"
#include "KeywordManager.h"

using namespace Ascension;
using namespace Manah;
using namespace std;


// CLineLayoutManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CLineLayoutManager::CLineLayoutManager(CEditView* pView)
		: m_pView(pView), m_pHead(0), m_pxMax(0), m_pMaxDisplayWidthLine(0), m_pInfoCache(0) {
}

///	fXgN^
CLineLayoutManager::~CLineLayoutManager() {
	DeleteAllLines();
}

///	CAEgׂĔj
void CLineLayoutManager::DeleteAllLines() {
	CLineLayoutInfo*	pCurrent = m_pHead;
	CLineLayoutInfo*	pNext;

	while(pCurrent != 0) {
		pNext = pCurrent->m_pNext;
		delete pCurrent;
		pCurrent = pNext;
	}
	m_pHead = 0;
	m_pxMax = 0;
	m_pMaxDisplayWidthLine = 0;
	m_pInfoCache = 0;
}

/**
 *	w肵s̃CAEg폜
 *	@param iLine	폜sԍ
 *	@exception		iLine ݂Ȃsł <code>out_of_range</code>
 */
void CLineLayoutManager::DeleteLine(unsigned long iLine) throw(out_of_range) {
	CLineLayoutInfo*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	m_pInfoCache = 0;

	if(pInfo->m_pNext == 0) {
		if(pInfo->m_pPrev == 0)
			m_pHead = 0;
		else
			pInfo->m_pPrev->m_pNext = 0;
		if(m_pView->m_ModeState.wpmWrapMode == WPM_NONE && pInfo == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
	} else {
		CLineLayoutInfo*	pTemp = pInfo->m_pNext;
		if(pInfo->m_pPrev == 0) {
			pInfo->m_pNext->m_pPrev = 0;
			m_pHead = pInfo->m_pNext;
		} else {
			pInfo->m_pPrev->m_pNext = pInfo->m_pNext;
			pInfo->m_pNext->m_pPrev = pInfo->m_pPrev;
		}
		if(m_pView->m_ModeState.wpmWrapMode == WPM_NONE && pInfo == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
		pInfo = pTemp;
	}

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pInfo->m_pPrev == 0 && pInfo->m_mctFromPrev == MCT_NOTCOMMENT)
		return;
	if(pInfo->m_pPrev != 0 && pInfo->m_pPrev->m_mctToNext == pInfo->m_mctFromPrev)
		return;
	while(true) {
		ParseLineEdgeComments(iLine, pInfo);
		pInfo->m_bReady = false;
		if(pInfo->m_pNext == 0
				|| !pInfo->m_pNext->m_bEdgeMCommentsCompleted
				|| pInfo->m_mctToNext == pInfo->m_pNext->m_mctFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		++iLine;
	}
}

/**
 *	̍s̃CAEg폜
 *	@param iStart	폜Jns
 *	@param iEnd		폜Is (̍s폜)
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::DeleteLines(unsigned long iStart, unsigned long iEnd) throw(out_of_range) {
	assert(iStart <= iEnd);

	CLineLayoutInfo*	pInfo = GetLineInternal(iStart);
	CLineLayoutInfo*	pLast = GetLineInternal(iEnd);

	if(pInfo == 0 || pLast == 0)
		throw out_of_range("Specified lines are not found.");
	m_pInfoCache = 0;

	CLineLayoutInfo*	pNext = 0;
	CLineLayoutInfo*	pBeginPrev = pInfo->m_pPrev;
	CLineLayoutInfo*	pEndNext = pLast->m_pNext;
	bool				bMaxIsDeleted = false;

	if(pInfo == m_pHead)
		m_pHead = pLast->m_pNext;

	while(true) {	// 폜
		pNext = pInfo->m_pNext;
		if(pInfo == m_pMaxDisplayWidthLine)
			bMaxIsDeleted = true;
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
		if(pNext == pEndNext)
			break;
		pInfo = pNext;
	}

	if(pBeginPrev != 0)
		pBeginPrev->m_pNext = pEndNext;
	if(pEndNext != 0)
		pEndNext->m_pPrev = pBeginPrev;

	if(m_pView->m_ModeState.wpmWrapMode == WPM_NONE && bMaxIsDeleted)
		ModifyMaxDisplayWidth();

	if(pEndNext == 0)
		return;
	pInfo = pEndNext;

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pInfo->m_pPrev == 0 && pInfo->m_mctFromPrev == MCT_NOTCOMMENT)
		return;
	if(pInfo->m_pPrev != 0 && pInfo->m_pPrev->m_mctToNext == pInfo->m_mctFromPrev)
		return;
	unsigned long	iLine = iStart;
	while(true) {
		ParseLineEdgeComments(iLine, pInfo);
		pInfo->m_bReady = false;
		if(pInfo->m_pNext == 0
				|| !pInfo->m_pNext->m_bEdgeMCommentsCompleted
				|| pInfo->m_mctToNext == pInfo->m_pNext->m_mctFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		++iLine;
	}
}

/**
 *	w肵s̃CAEgԂ
 *	@param iLine	s
 *	@return			CAEgB<var>iLine</var> Ȃ null
 */
CLineLayoutInfo* CLineLayoutManager::GetLine(unsigned long iLine) const {
	CLineLayoutInfo*	pInfo = GetLineInternal(iLine);
	if(pInfo != 0 && !pInfo->m_bReady)	// łĂȂ
		const_cast<CLineLayoutManager*>(this)->ParseLineTokens(iLine, pInfo);
	return pInfo;
}

///	GetLine ̓ (Ԃs͖͂̏ꍇ)
CLineLayoutInfo* CLineLayoutManager::GetLineInternal(unsigned long iLine) const {
	CLineLayoutInfo*	pInfo;
	unsigned long		iRest;
	bool				bForward;	// m_pNext ŌƂ^

	if(m_pInfoCache == 0 || iLine <= dif(iLine, m_iLineCache)) {	// LbVgȂ or n_̕߂
		pInfo = m_pHead;
		iRest = iLine;
		bForward = true;
	} else {	// LbV_̕߂Ƃ
		pInfo = m_pInfoCache;
		iRest = dif(m_iLineCache, iLine);
		bForward = m_iLineCache < iLine;
	}

	if(bForward) {
		while(pInfo != 0) {
			if(iRest == 0)
				return pInfo;
			pInfo = pInfo->m_pNext;
			--iRest;
		}
	} else {
		while(pInfo != 0) {
			if(iRest == 0)
				return pInfo;
			pInfo = pInfo->m_pPrev;
			--iRest;
		}
	}
	return 0;
}

///	ő\s̕\Ԃ
unsigned long CLineLayoutManager::GetMaxDisplayWidth() const {
	return m_pxMax;
}

/**
 *	w肵s̃CAEg쐬AXgɒǉ
 *	@param iLine	sԍ
 *	@exception		iLine }s\ȍsԍł <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLine(unsigned long iLine) throw(out_of_range) {
	if(iLine > m_pView->GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayoutInfo*	pInfo = 0;
	CLineLayoutInfo*	pPrev = 0;

	m_pInfoCache = 0;

	// s̑}
	if(iLine == 0) {
		pInfo = new CLineLayoutInfo();
		pInfo->m_pNext = m_pHead;
		m_pHead->m_pPrev = pInfo;
		m_pHead = pInfo;
	} else {
		pPrev = GetLineInternal(iLine - 1);
		assert(pPrev != 0);
		pInfo = new CLineLayoutInfo();
		pInfo->m_pPrev = pPrev;
		pInfo->m_pNext = pPrev->m_pNext;
		if(pPrev->m_pNext != 0)
			pPrev->m_pNext->m_pPrev = pInfo;
		pPrev->m_pNext = pInfo;
		pInfo->m_mctFromPrev = pInfo->m_pPrev->m_mctToNext;
	}
	ParseLineEdgeComments(iLine, pInfo);

	if(pInfo->m_pNext == 0)
		return;
	pInfo = pInfo->m_pNext;
	++iLine;

	// 㑱̉e󂯂s`FbN
	while(true) {
		if(pInfo->m_pNext == 0
				|| !pInfo->m_pNext->m_bEdgeMCommentsCompleted
				|| pInfo->m_mctToNext == pInfo->m_pNext->m_mctFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineEdgeComments(++iLine, pInfo);
		pInfo->m_bReady = false;
	}
}

/**
 *	̍sCAEg쐬AXgɒǉ
 *	@param iStart	}Jns
 *	@param iEnd		}Is
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLines(unsigned long iStart, unsigned long iEnd) throw(out_of_range) {
	assert(iStart <= iEnd);
//	CTimer tm(L"InsertLines");
	if(iStart > m_pView->GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");
	m_pInfoCache = 0;

	CLineLayoutInfo*	pBeginPrev = (iStart != 0) ? GetLineInternal(iStart - 1) : 0;
	CLineLayoutInfo*	pEndNext = GetLineInternal(iStart);
	CLineLayoutInfo*	pNewInfo = 0;
	CLineLayoutInfo*	pNewPrevInfo = 0;

	// s̑}
	for(unsigned long iLine = iStart; /* iLine <= iEnd */; ++iLine) {
		pNewInfo = new CLineLayoutInfo();
		if(iLine == iStart) {
			pNewInfo->m_pPrev = pBeginPrev;
			if(pBeginPrev == 0)
				m_pHead = pNewInfo;
			else
				pBeginPrev->m_pNext = pNewInfo;
		} else {
			pNewInfo->m_pPrev = pNewPrevInfo;
			pNewPrevInfo->m_pNext = pNewInfo;
		}
		if(iLine == iEnd) {
			pNewInfo->m_pNext = pEndNext;
			if(pEndNext != 0)
				pEndNext->m_pPrev = pNewInfo;
			break;
		}
		pNewPrevInfo = pNewInfo;
	}

	// }s̏XV
	CLineLayoutInfo*	pInfo = GetLineInternal(iStart);
	for(unsigned long iLine = iStart; iLine <= iEnd; ++iLine, pInfo = pInfo->m_pNext)
		ParseLineEdgeComments(iLine, pInfo);

	// 㑱̉e󂯂s`FbN
	unsigned long	iLine_ = iEnd;
	pInfo = pEndNext;
	if(pInfo == 0)
		return;
	while(true) {
		if(pInfo->m_pNext == 0
				|| !pInfo->m_pNext->m_bEdgeMCommentsCompleted
				|| pInfo->m_mctToNext == pInfo->m_pNext->m_mctFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineEdgeComments(++iLine_, pInfo);
		pInfo->m_bReady = false;
	}
}

/**
 *	ws̉͂IĂ邩Ԃ
 *	@param iLine	_s
 */
bool CLineLayoutManager::IsLineParseComplete(unsigned long iLine) throw(out_of_range) {
	CLineLayoutInfo*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	return pInfo->m_bReady;
}

/**
 *	SĂ̍s̃CAEgXV
 *	@param bReconstruct	xCAEgSč폜č\ǂ
 */
void CLineLayoutManager::ModifyAllLines(bool bReconstruct) {
	unsigned long cLines = m_pView->GetDocument()->GetLineCount();
	if(bReconstruct) {
		DeleteAllLines();
		InsertLines(0, cLines - 1);
	} else {
		for(unsigned long iLine = 0; iLine < cLines; ++iLine)
			ModifyLine(iLine);
	}
}

/**
 *	w肵s̃CAEgXV
 *	@param iLine	(_) sԍ
 *	@return			es
 *	@exception		iLine ݂Ȃsł <code>out_of_range</code>
 */
inline unsigned long CLineLayoutManager::ModifyLine(unsigned long iLine) throw(out_of_range) {
	CLineLayoutInfo*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");

	m_iLineCache = iLine;
	m_pInfoCache = pInfo;

	// ܂Ԃƍs̕\ɂ
	LineIterator		it = m_pView->GetDocument()->GetLineIterator(iLine);
	const CEditDocLine*	pLineInfo = &(*it);
	const wchar_t*		pszLine = pLineInfo->GetLine().c_str();
	unsigned long		cchLine = pLineInfo->GetLine().length();
	unsigned long		cxLine = 0;

	pInfo->m_vecWrappedOffsets.clear();
	pInfo->m_bReady = false;

//	hOldFont = m_pView->m_GDIObjects.oMemDC.SelectObject(m_pView->m_GDIObjects.hNormalFont);

//	if(m_pView->m_ModeState.wpmWrapMode == WPM_NONE)
		ParseLineTokens(iLine, pInfo);
/*	else {	// ܂Ԃ̌vZ
		unsigned long	cxWrap;
		unsigned int	cxChar;

		if(m_pView->m_ModeState.wpmWrapMode == WPM_SPECIFIED)
			cxWrap = m_pView->m_ModeState.nWrapWidth;
		else if(m_pView->m_ModeState.wpmWrapMode == WPM_WINDOW) {
			RECT	rect;
			m_pView->GetClientRect(&rect);
			cxWrap = rect.right - rect.left
						- m_pView->m_layoutInfo.nLeftTabWidth - m_pView->m_layoutInfo.nLeftMargin;
		}
		for(unsigned long i = 0; i < cchLine; ++i) {
			if(*(pszLine + i) == L'\t')
				cxChar = m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth()
							- cxLine % (m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth());
			else
				cxChar = m_pView->m_GDIObjects.oMemDC.GetTextExtent(pszLine + i, 1).cx;
			if(cxLine + cxChar > cxWrap) {	// ܂Ԃ
				pInfo->m_vecWrappedOffsets.push_back(i);
				cxLine = 0;
			}
			cxLine += cxChar;
		}
	}

	m_pView->m_GDIObjects.oMemDC.SelectObject(hOldFont);*/

	// 㑱s̕sRgɂ
	unsigned long	cModifiedLines = 1;
	while(true) {
		if(pInfo->m_pNext == 0
				|| !pInfo->m_pNext->m_bEdgeMCommentsCompleted
				|| pInfo->m_mctToNext == pInfo->m_pNext->m_mctFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineEdgeComments(iLine + cModifiedLines, pInfo);
		pInfo->m_bReady = false;
		++cModifiedLines;
	}
	return cModifiedLines;
}

///	ő\sT
void CLineLayoutManager::ModifyMaxDisplayWidth() {
	m_pxMax = 0;
	for(CLineLayoutInfo* pInfo = m_pHead; pInfo != 0; pInfo = pInfo->m_pNext) {
		if(pInfo->m_cxPixel > m_pxMax) {
			m_pxMax = pInfo->m_cxPixel;
			m_pMaxDisplayWidthLine = pInfo;
		}
	}
}

/**
 *	s̐擪A̕sRg
 *	@param iLine	_sԍ
 *	@param pInfo	s (ȗƍsԍ擾)
 *	@see			ParseLineTokens
 */
void CLineLayoutManager::ParseLineEdgeComments(unsigned long iLine, CLineLayoutInfo* pInfo /* = 0 */) {
	if(m_pView->m_FoundationInfo.strCommentStart1.empty() && m_pView->m_FoundationInfo.strCommentStart2.empty())
		return;

	if(pInfo == 0)
		pInfo = GetLineInternal(iLine);

	// O̍s̕sRgI󋵂g
	if(pInfo->m_pPrev == 0)
		pInfo->m_mctFromPrev = MCT_NOTCOMMENT;
	else {
		if(!pInfo->m_pPrev->m_bEdgeMCommentsCompleted)	// O̍s͂Ȃ΍ċAIɉ͂
			ParseLineEdgeComments(iLine - 1, pInfo->m_pPrev);
		pInfo->m_mctFromPrev = pInfo->m_pPrev->m_mctToNext;
	}
	pInfo->m_bEdgeMCommentsCompleted = true;

	const wchar_t*	pwszLine = m_pView->GetDocument()->GetLine(iLine).c_str();
	unsigned long	iChar = 0;
	unsigned long	cchLine = m_pView->GetDocument()->GetLineLength(iLine);

	if(cchLine == 0) {
		pInfo->m_mctToNext = pInfo->m_mctFromPrev;
		return;
	}

	bool			bInComment = pInfo->m_mctFromPrev != MCT_NOTCOMMENT;
	unsigned long	cchToken;

	while(iChar < cchLine) {
		if(iChar == 0 && bInComment) {	// sRgO̍s瑱Ăꍇ
			bInComment = true;
			if(pInfo->m_mctFromPrev == MCT_1)
				iChar += m_pView->IsMComment1(pwszLine + iChar, cchLine - iChar, bInComment);
			else if(pInfo->m_mctFromPrev == MCT_2)
				iChar += m_pView->IsMComment2(pwszLine + iChar, cchLine - iChar, bInComment);
			else
				assert(false);	// ...͕sRg3ȍ~͖
			if(bInComment) {
				pInfo->m_mctToNext = pInfo->m_mctFromPrev;
				return;
			}
			bInComment = false;
		} else {
			if(0 != (cchToken = m_pView->IsSComment1(pwszLine + iChar, cchLine - iChar))) {
				pInfo->m_mctToNext = MCT_NOTCOMMENT;
				return;
			} else if(0 != (cchToken = m_pView->IsSComment2(pwszLine + iChar, cchLine - iChar))) {
				pInfo->m_mctToNext = MCT_NOTCOMMENT;
				return;
			} else if(0 != (cchToken = m_pView->IsMComment1(pwszLine + iChar, cchLine - iChar, bInComment))) {
				if(bInComment) {
					pInfo->m_mctToNext = MCT_1;
					return;
				}
				iChar += cchToken;
			} else if(0 != (cchToken = m_pView->IsMComment2(pwszLine + iChar, cchLine - iChar, bInComment))) {
				if(bInComment) {
					pInfo->m_mctToNext = MCT_2;
					return;
				}
				iChar += cchToken;
			} else if((0 != (cchToken = m_pView->IsDoubleQuotation(pwszLine + iChar, cchLine - iChar)))
					|| (0 != (cchToken = m_pView->IsSingleQuotation(pwszLine + iChar, cchLine - iChar))))
				iChar += cchToken;
			else
				++iChar;
		}
	}
	pInfo->m_mctToNext = MCT_NOTCOMMENT;
}

/**
 *	ws̉͂sB͍ς݂łΉȂB
 *	CLineLayoutManager ̃NCAg GetLine
 *	gƂŉ͍ς݂̍s擾ł邪AGetLine
 *	ȊÕ\bh͍s͂sȂ̂ŁA
 *	̃\bhŗ\߉͂sƂŃI[owbhɘa邱Ƃł
 */
void CLineLayoutManager::ParseLine(unsigned long iLine) throw(out_of_range) {
	CLineLayoutInfo*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");

	if(!pInfo->m_bReady)
		ParseLineTokens(iLine, pInfo);
}

/**
 *	g[N؂oƕʒǔvZs (ParseLineEdgeComments ̓˂)
 *	@param iLine	_sԍ
 *	@param pInfo	s (ȗƍsԍ擾)
 *	@see			ParseLineEdgeComments
 */
void CLineLayoutManager::ParseLineTokens(unsigned long iLine, CLineLayoutInfo* pInfo /* = 0 */) {
	const wchar_t*	pwszLine = m_pView->GetDocument()->GetLine(iLine).c_str();
	unsigned long	cchLine = m_pView->GetDocument()->GetLineLength(iLine);

	if(pInfo == 0)
		pInfo = GetLineInternal(iLine);

	// O̍s畡sRgĂ邩ǂĂȂ΂Ȃ
	if(pInfo->m_pPrev != 0 && !pInfo->m_pPrev->m_bEdgeMCommentsCompleted)
		ParseLineEdgeComments(iLine, pInfo->m_pPrev);
	pInfo->m_mctFromPrev = (pInfo->m_pPrev != 0) ? pInfo->m_pPrev->m_mctToNext : MCT_NOTCOMMENT;
	pInfo->m_mctToNext = MCT_NOTCOMMENT;

	pInfo->m_listTokens.clear();
	if(cchLine == 0) {
		pInfo->m_mctToNext = pInfo->m_mctFromPrev;
		pInfo->m_cxPixel = 0;
		pInfo->m_vecCaretPos.clear();
		pInfo->m_vecCaretPos.push_back(0);
		pInfo->m_bEdgeMCommentsCompleted = pInfo->m_bReady = true;
		return;
	}

	CMinimalDC&		oDC = m_pView->m_GDIObjects.oMemDC;
	HFONT			hOldFont = oDC.SelectObject(m_pView->m_GDIObjects.hNormalFont);
	GCP_RESULTSW	gcpr;
	int*			arrCaretPos = new int[cchLine + 1];
	unsigned int*	arrOrder = new unsigned int[cchLine + 1];
	unsigned long	nOffset = 0;	// s̈ʒu

	arrCaretPos[0] = 0;
	oDC.SetTextCharacterExtra(m_pView->m_layoutInfo.nCharSpan);
	ZeroMemory(&gcpr, sizeof(GCP_RESULTSW));
	gcpr.lStructSize = sizeof(GCP_RESULTSW);

	// ͂ƕʒu
	bool	bInComment = pInfo->m_mctFromPrev != MCT_NOTCOMMENT;
	for(unsigned long iChar = 0; iChar < cchLine; ) {
		CTokenInfo	oToken;

		// g[N؂o
		oToken.m_iChar = iChar;
		if(m_pView->m_layoutInfo.tfTextFoundation[TT_COMMENT].enabled
				&& iChar == 0 && pInfo->m_mctFromPrev == MCT_1) {
			oToken.m_cchToken = m_pView->IsMComment1(pwszLine + iChar, cchLine - iChar, bInComment);
			oToken.m_ttType = TT_COMMENT;
			if(bInComment)
				pInfo->m_mctToNext = MCT_1;
		} else if(m_pView->m_layoutInfo.tfTextFoundation[TT_COMMENT].enabled
				&& iChar == 0 && pInfo->m_mctFromPrev == MCT_2) {
			oToken.m_cchToken = m_pView->IsMComment2(pwszLine + iChar, cchLine - iChar, bInComment);
			oToken.m_ttType = TT_COMMENT;
			if(bInComment)
				pInfo->m_mctToNext = MCT_2;
		} else if(m_pView->m_layoutInfo.tfTextFoundation[TT_COMMENT].enabled
				&& (m_pView->IsSComment1(pwszLine + iChar, cchLine - iChar)
				|| m_pView->IsSComment2(pwszLine + iChar, cchLine - iChar))) {	// 1sRg -> s܂
			oToken.m_cchToken = cchLine - iChar;
			oToken.m_ttType = TT_COMMENT;
		} else if(m_pView->m_layoutInfo.tfTextFoundation[TT_COMMENT].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsMComment1(pwszLine + iChar, cchLine - iChar, bInComment))) {
			oToken.m_ttType = TT_COMMENT;
			if(bInComment)
				pInfo->m_mctToNext = MCT_1;
		} else if(m_pView->m_layoutInfo.tfTextFoundation[TT_COMMENT].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsMComment2(pwszLine + iChar, cchLine - iChar, bInComment))) {
			oToken.m_ttType = TT_COMMENT;
			if(bInComment)
				pInfo->m_mctToNext = MCT_2;
		} else if(m_pView->m_layoutInfo.tfTextFoundation[TT_OPERATOR].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsOperator(pwszLine + iChar, cchLine - iChar)))	// Zq
			oToken.m_ttType = TT_OPERATOR;
		else if(m_pView->m_layoutInfo.tfTextFoundation[TT_SPACE].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsWhiteSpace(pwszLine + iChar, cchLine - iChar)))	// 󔒗ނ
			oToken.m_ttType = TT_SPACE;
		else if(m_pView->m_layoutInfo.tfTextFoundation[TT_NUMERIC].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsNumeric(pwszLine + iChar, cchLine - iChar)))	// l\
			oToken.m_ttType = TT_NUMERIC;
		else if(m_pView->m_layoutInfo.tfTextFoundation[TT_DOUBLEQUOTATION].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsDoubleQuotation(pwszLine + iChar, cchLine - iChar)))	// dp
			oToken.m_ttType = TT_DOUBLEQUOTATION;
		else if(m_pView->m_layoutInfo.tfTextFoundation[TT_SINGLEQUOTATION].enabled
				&& 0 != (oToken.m_cchToken = m_pView->IsSingleQuotation(pwszLine + iChar, cchLine - iChar)))	// dp
			oToken.m_ttType = TT_SINGLEQUOTATION;
		else if(0 != (oToken.m_cchToken = m_pView->IsWord(pwszLine + iChar, cchLine - iChar))) {	// Pꂩ
			if(m_pView->m_layoutInfo.tfTextFoundation[TT_KEYWORD1].enabled
					&& m_pView->m_FoundationInfo.pKeywords1->Find(pwszLine + iChar,
					oToken.m_cchToken, m_pView->m_FoundationInfo.bIgnoreCaseOnHilite))	// \L[[h1
				oToken.m_ttType = TT_KEYWORD1;
			else if(m_pView->m_layoutInfo.tfTextFoundation[TT_KEYWORD2].enabled
					&& m_pView->m_FoundationInfo.pKeywords2->Find(pwszLine + iChar,
					oToken.m_cchToken, m_pView->m_FoundationInfo.bIgnoreCaseOnHilite))	// \L[[h2
				oToken.m_ttType = TT_KEYWORD2;
			else	// ʂ̃eLXg -> ʎq
				oToken.m_ttType = TT_IDENTIFIER;
		} else {
			// TQ[gyÃ`FbN
			if(CTextConverter::IsUTF16HighSurrogate(pwszLine[iChar])
					&& iChar < cchLine - 1
					&& CTextConverter::IsUTF16LowSurrogate(pwszLine[iChar + 1]))
				oToken.m_cchToken = 2;
			else
				oToken.m_cchToken = 1;
			oToken.m_ttType = TT_NORMAL;
		}

		// ʒuƕ (ȍ~̌vZ͎bIȂ̂ŁA̗]n͏\ɂ)
		unsigned long					iLastTab = iChar;
		CTokenInfo::TSubstringDirection	oDirection = {0, false};
		SIZE							size;

		oDC.SelectObject(m_pView->GetFontForRenderingToken(oToken.m_ttType));
		oToken.m_nLeftEdge = nOffset;
		oToken.m_listDirections.push_back(oDirection);
		while(true) {	// g[Ñ^u͕ʈ
			const wchar_t*	pwszTab = wcschr(pwszLine + iLastTab, L'\t');
			unsigned long	cchSubstring;
			long			cxSubstring;

			if(static_cast<unsigned long>(pwszTab - pwszLine) >= iChar + oToken.m_cchToken)	// ȂƂɂ
				pwszTab = 0;

			// ^u܂
			if(pwszTab == 0 || pwszTab - pwszLine != iLastTab) {
				cchSubstring = (pwszTab != 0) ? pwszTab - pwszLine - iLastTab : iChar - iLastTab + oToken.m_cchToken;
				cchSubstring = std::min(oToken.m_cchToken - iLastTab + iChar, cchSubstring);
				gcpr.nGlyphs = cchSubstring;
				gcpr.lpOrder = arrOrder + iLastTab;
				oDC.GetCharacterPlacement(pwszLine + iLastTab,
					cchSubstring, 0, &gcpr, GCP_DIACRITIC | GCP_DISPLAYZWG | GCP_GLYPHSHAPE | GCP_REORDER);
				oDC.GetTextExtentExPoint(pwszLine + iLastTab,
					cchSubstring, 0, 0, arrCaretPos + iLastTab + 1, &size);
				cxSubstring = size.cx;
				for(unsigned long i = iLastTab; i < iLastTab + cchSubstring; ++i) {
					arrOrder[i] += iLastTab;
					arrCaretPos[i + 1] += nOffset;
				}
				nOffset += cxSubstring;
				if(pwszTab == 0)	// g[NI
					break;
			}

			// ^u
			nOffset = m_pView->GetNextTabStop(nOffset, false);
			iLastTab = pwszTab - pwszLine;
			arrOrder[iLastTab] = iLastTab;
			arrCaretPos[iLastTab + 1] = nOffset;
			++iLastTab;
		}

		// ̏畔eLXg߂ ([Alef][Bet][Gimel]012 -> [Gimel][Bet][Alef]012)
		unsigned int	iDesired = iChar;	// ݂̕Ŋ҂鎟̏
		unsigned long	iRtlStart = 0;		// ŌɉE獶ɂȂʒu
		for(unsigned long i = iChar; i < iChar + oToken.m_cchToken; ++i) {
			if(i > 0 && arrOrder[i] == arrOrder[i - 1])	// TQ[gyA
				continue;
			else if(arrOrder[i] == iDesired)	// z肳ꂽ
				iDesired += oDirection.bRightToLeft ? -1 : 1;
			else {	// ȊO -> ω
				oDirection.iStartChar = i - iChar;
				oDirection.bRightToLeft = !oDirection.bRightToLeft;
				oToken.m_listDirections.push_back(oDirection);
				iDesired = arrOrder[i] + (oDirection.bRightToLeft ? -1 : 1);

				if(oDirection.bRightToLeft)
					iRtlStart = i;
				else {
					// eLXg̕E獶̃̕Lbgʒu
					// t] (アƒԕ𓯈ꎋ邪...)
					int	nSubstringLeft = arrCaretPos[iRtlStart];
					for(unsigned long j = iRtlStart; j < i; ++j)
						arrCaretPos[j] = arrCaretPos[i] - arrCaretPos[j] + nSubstringLeft;

					// RTL  LTR  (ア) Oɏo ([Gimel][Bet][Alef]012 -> 012[Gimel][Bet][Alef])
					unsigned long	cWeakChars = 0;
					while(i > iChar
							&& i + cWeakChars < iChar + oToken.m_cchToken
							&& arrOrder[i + cWeakChars] < arrOrder[i - 1])
						++cWeakChars;
					if(cWeakChars != 0) {
						int	cxRtr = oDC.GetTextExtent(pwszLine + iRtlStart, i - iRtlStart).cx;
						int	cxLtr = oDC.GetTextExtent(pwszLine + i, cWeakChars).cx;
						if(i + cWeakChars == cchLine)	// I[܂߂
							++cWeakChars;
						for(unsigned long j = iRtlStart; j < i + cWeakChars; ++j)
							arrCaretPos[j] += (j < i) ? cxLtr : -cxRtr;
					}
				}
			}
		}
		if(oDirection.bRightToLeft) {	// E獶̏ꍇ͂ŏ
			int				nSubstringLeft = arrCaretPos[iRtlStart];
			unsigned long	iEnd = (iChar + oToken.m_cchToken != cchLine) ?
								iChar + oToken.m_cchToken : iChar + oToken.m_cchToken + 1;

			for(unsigned long j = iRtlStart; j < iEnd; ++j)
				arrCaretPos[j] = arrCaretPos[iChar + oToken.m_cchToken] - arrCaretPos[j] + nSubstringLeft;
		}

		oToken.m_nTextWidth = nOffset - oToken.m_nLeftEdge;
		iChar += oToken.m_cchToken;
		pInfo->m_listTokens.push_back(oToken);
	}

	pInfo->m_cxPixel = nOffset;
	pInfo->m_vecCaretPos.assign(arrCaretPos, arrCaretPos + cchLine + 1);
	delete[] arrCaretPos;
	delete[] arrOrder;
	oDC.SelectObject(hOldFont);

	// ő\̌vZ
	if(pInfo == m_pMaxDisplayWidthLine) {
		ModifyMaxDisplayWidth();
		m_pView->ModifyScrollInfo(true, false);
	} else if(pInfo->m_cxPixel > m_pxMax) {
		m_pxMax = pInfo->m_cxPixel;
		m_pMaxDisplayWidthLine = pInfo;
		m_pView->ModifyScrollInfo(true, false);
	}

	pInfo->m_bEdgeMCommentsCompleted = pInfo->m_bReady = true;
}

/* [EOF] */