// (c) 2003 exeal
// EditPoint.h

#ifndef _EDIT_POINT_H_
#define _EDIT_POINT_H_
#include "EditDoc.h"


namespace Ascension {

class CCharPos;
class CEditDoc;
class CEditView;


///	 CEditView ɖ CEditPoint ACEditRange IuWFNgLłȂƂ\O
class EViewIsAlreadyInavailable {
public:
	std::wstring	GetDescription() const {
		return L"Target view is already inavailable. This object is no longer able to be used anyway.";
	}
};


///	r[疳ʒm\ȃIuWFNg
interface IDisablableByView {
	///	fXgN^
	virtual ~IDisablableByView() {}
	///	r[j󂳂ꂽ
	virtual void	OnViewDeleted() = 0;
};


/**
 *	@brief	GfB^ŕҏWAړ\ȁu_v
 *
 *	CEditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
 *	CEditView ̑Ǝ@ŕҏWsB
 *	̃IuWFNg̕\_͑̕ҏWŕύX邱Ƃ͖Aʒu
 *	(ႦΑ݂Ȃ񂩂ŏIցA폜ꂽsŏIs) ւ̈ړ͋N
 */
class CEditPoint :
		public Manah::CObject,
		public CCharPos,
		public IDisablableByView {
	friend class CEditView;
	friend class CEditRange;

	// RXgN^
private:
	CEditPoint(CEditView* pView, const CCharPos& pos);
	CEditPoint(const CEditPoint& rhs);
	operator =(const CEditPoint& rhs);

	// \bh
public:
	/*  */
	unsigned long	GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetCharNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetColumnNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineLength() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineNumber() const throw(EViewIsAlreadyInavailable);
	bool			IsAtEndOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsAtEndOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsAtStartOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsAtStartOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsAvailable() const;

	/*  */
	void		CharNext(unsigned long nOffset = 1) throw(EViewIsAlreadyInavailable);
	void		CharPrev(unsigned long nOffset = 1) throw(EViewIsAlreadyInavailable);
	CEditPoint*	Clone() const throw(EViewIsAlreadyInavailable);
	void		EnsureCentered() throw(EViewIsAlreadyInavailable);
	void		EnsureVisible() throw(EViewIsAlreadyInavailable);
	void		MoveToAbsoluteCharOffset(unsigned long nOffset) throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfLine() throw(EViewIsAlreadyInavailable);
	void		MoveToNextBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		MoveToPrevBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfLine() throw(EViewIsAlreadyInavailable);
	void		Insert(const wstring& strText, OperationConcatenationFlag ocf) throw(EViewIsAlreadyInavailable);
	void		LineDown(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		LineUp(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);

	/* IDisablableByView C^[tFCX */
	void	OnViewDeleted();

private:
	void	Normalize() const;

	// f[^o
private:
	CEditView*		m_pView;	// r[
	unsigned long	m_cxLast;	// r[̐Ό_̋ (x W)
								// LineDown ALineUp ňړƂɕێ
};


/**
 *	@brief	GfB^͈̓̔
 *
 *	2 CEditPoint Ȃ͈̔ (`\邱Ƃ)B
 *	̃NX CEditView ̑I͈͂\邽߂Ɏgp邪A
 *	NCAg͂̃IuWFNgɂĔCӂ͈̔͂쐬邱ƂoB
 *	쐬ꂽ͈͂̑ CEditView ̑I͈͂ƂقړŁA
 *	̃IuWFNg\͈͂ɑ΂ĕҏWsƔ͈͂ύXꂽA
 *	r[ɑ΂čĕ`ʒmsꂽ肷B
 *	Ԃł͂̃IuWFNg͐`͈͂\
 */
class CEditRange :
		public Manah::CObject,
		public IDisablableByView {
	friend class CEditView;

	// RXgN^
private:
	CEditRange(CEditView* pView, const CCharPos& posStart, const CCharPos& posEnd);

	// \bh
public:
	/*  */
	const CEditPoint*	GetActivePoint() const;
	const CEditPoint*	GetAnchorPoint() const;
	const CEditPoint*	GetEndPoint() const;
	const CEditPoint*	GetStartPoint() const;
	std::wstring		GetText() const throw(EViewIsAlreadyInavailable);
	bool				IsAvailable() const;
	bool				IsBoxRange() const;
	bool				IsEmpty() const;

	/*  */
	void	Copy() const throw(EViewIsAlreadyInavailable);
	void	Delete() throw(EViewIsAlreadyInavailable);
	void	MakeCapitalized();
	void	MakeLower();
	void	MakeUpper();
	void	Paste() throw(EViewIsAlreadyInavailable);
	void	Replace(const std::wstring& strText) throw(EViewIsAlreadyInavailable);
	void	SetBoxRange(bool bBox = true);
	void	SpaceIndent(bool bReverse = false);
	void	Tabify(bool bRevoke = false);
	void	TabIndent(bool bReverse = false);

	/* IDisablableByView C^[tFCX */
	void	OnViewDeleted();

private:
	void	Normalize();

	// f[^o
private:
	CEditView*	m_pView;		// r[
	CEditPoint*	m_pAnchorPoint;	// AJ[|Cg
	CEditPoint*	m_pActivePoint;	// ANeBu|Cg
	bool		m_bBoxRange;	// ͈͂`
};


// CEditPoint class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	Ώۃr[Ă true Ԃ
inline bool CEditPoint::IsAvailable() const {
	AssertValid();
	return m_pView != 0;
}

///	@see	IDisablableByView
inline void CEditPoint::OnViewDeleted() {
	AssertValid();
	m_pView = 0;
}


// CEditRange class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	ANeBu|CgԂ
inline const CEditPoint* CEditRange::GetActivePoint() const {
	AssertValid();
	return m_pActivePoint;
}

///	AJ[|CgԂ
inline const CEditPoint* CEditRange::GetAnchorPoint() const {
	AssertValid();
	return m_pAnchorPoint;
}

///	I_Ԃ
inline const CEditPoint* CEditRange::GetEndPoint() const {
	AssertValid();
	return &std::max(*m_pAnchorPoint, *m_pActivePoint);
}

///	n_Ԃ
inline const CEditPoint* CEditRange::GetStartPoint() const {
	AssertValid();
	return &std::min(*m_pAnchorPoint, *m_pActivePoint);
}

///	Ώۃr[Ă true Ԃ
inline bool CEditRange::IsAvailable() const {
	AssertValid();
	return m_pView != 0;
}

///	͈͂󂩂ǂԂ
inline bool CEditRange::IsEmpty() const {
	AssertValid();

	const_cast<CEditRange*>(this)->Normalize();
	return *m_pAnchorPoint == *m_pActivePoint;
}

///	n_AI_𐳂ʒuɈړ
inline void CEditRange::Normalize() {
	AssertValid();

	m_pAnchorPoint->Normalize();
	m_pActivePoint->Normalize();
}

///	@see	IDisablableByView
inline void CEditRange::OnViewDeleted() {
	AssertValid();
	m_pView = 0;
}

} /* namespace Ascension */

#endif /* _EDIT_POINT_H_ */

/* [EOF] */