// TreeCtrl.h
///////////////////////////////////////////////////////////

#ifndef _TREE_CTRL_H_
#define _TREE_CTRL_H_

#include "Window.h"


namespace Manah {
namespace Windows {
namespace Controls {

class CTreeCtrl : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool		Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	bool		CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);

	/*  */
	COLORREF	GetBkColor() const;
	bool		GetCheck(HTREEITEM hItem) const;
	HTREEITEM	GetChildItem(HTREEITEM hItem) const;
	UINT		GetCount() const;
	HTREEITEM	GetDropHilightItem() const;
	HWND		GetEditControl() const;
	HTREEITEM	GetFirstVisibleItem() const;
	HIMAGELIST	GetImageList(UINT iImage) const;
	UINT		GetIndent() const;
	COLORREF	GetInsertMarkColor() const;
	UINT		GetISearchString(TCHAR* lpszText);
	bool		GetItem(TVITEM& item) const;
	bool		GetItem(TVITEMEX& item) const;
	DWORD		GetItemData(HTREEITEM hItem) const;
	SHORT		GetItemHeight() const;
	bool		GetItemImage(HTREEITEM hItem, int& nImage, int& nSelectedImage) const;
	bool		GetItemRect(HTREEITEM hItem, RECT& rect, bool nTextOnly);
	UINT		GetItemState(HTREEITEM hItem, UINT nStateMask) const;
	bool		GetItemText(HTREEITEM hItem, TCHAR* lpszText) const;
	HTREEITEM	GetLastVisibleItem() const;
	COLORREF	GetLineColor() const;
	HTREEITEM	GetNextItem(HTREEITEM hItem, UINT nCode) const;
	HTREEITEM	GetNextSiblingItem(HTREEITEM hItem) const;
	HTREEITEM	GetNextVisibleItem(HTREEITEM hItem) const;
	HTREEITEM	GetParentItem(HTREEITEM hItem) const;
	HTREEITEM	GetPrevSiblingItem(HTREEITEM hItem) const;
	HTREEITEM	GetPrevVisibleItem(HTREEITEM hItem) const;
	HTREEITEM	GetRootItem() const;
	UINT		GetScrollTime() const;
	HTREEITEM	GetSelectedItem() const;
	COLORREF	GetTextColor() const;
	HWND		GetToolTips() const;
	bool		GetUnicodeFormat() const;
	UINT		GetVisibleCount() const;
	bool		ItemHasChildren(HTREEITEM hItem) const;
	COLORREF	SetBkColor(COLORREF clr);
	bool		SetCheck(HTREEITEM hItem, bool bCheck = true);
	HIMAGELIST	SetImageList(HIMAGELIST hImageList, UINT iImage);
	void		SetIndent(UINT nIndent);
	bool		SetInsertMark(HTREEITEM hItem, bool bAfter = true);
	COLORREF	SetInsertMarkColor(COLORREF clrNew);
	bool		SetItem(const TVITEM& item);
	bool		SetItem(const TVITEMEX& item);
	bool		SetItem(HTREEITEM hItem, UINT nMask, const TCHAR* lpszItem,
					int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam);
	bool		SetItemData(HTREEITEM hItem, DWORD dwData);
	SHORT		SetItemHeight(SHORT cyHeight);
	bool		SetItemState(HTREEITEM hItem, UINT nState, UINT nStateMask);
	bool		SetItemImage(HTREEITEM hItem, int nImage, int nSelectedImage);
	bool		SetItemText(HTREEITEM hItem, const TCHAR* lpszItem);
	COLORREF	SetLineColor(COLORREF clrNew = CLR_DEFAULT);
	UINT		SetScrollTime(UINT nScrollTime);
	COLORREF	SetTextColor(COLORREF clr);
	HWND		SetToolTips(HWND hwndToolTips);
	bool		SetUnicodeFormat(bool bUnicode = true);

	/*  */
	HIMAGELIST	CreateDragImage(HTREEITEM hItem);	// returned pointer is permanent
	bool		DeleteAllItems();
	bool		DeleteItem(HTREEITEM hItem);
	HWND		EditLabel(HTREEITEM hItem);
	bool		EndEditLabelNow();
	bool		EnsureVisible(HTREEITEM hItem);
	bool		ExpandItem(HTREEITEM hItem, UINT nCode);
	HTREEITEM	HitTest(TVHITTESTINFO& tvhi);
	HTREEITEM	HitTest(const POINT& pt, UINT nFlags);
	HTREEITEM	InsertItem(const TVINSERTSTRUCT& insertStruct);
	HTREEITEM	InsertItem(UINT nMask, const TCHAR* lpszItem,
					int iImage, int iSelectedImage, UINT nState, UINT nStateMask,
					LPARAM lParam, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM	InsertItem(const TCHAR* lpszItem,
					HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM	InsertItem(const TCHAR* lpszItem, int iImage, int iSelectedImage,
					HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM	MapAccIdToHTREEITEM(UINT id) const;
	UINT		MapHTREEITEMToAccId(HTREEITEM hItem) const;
	bool		SelectDropTarget(HTREEITEM hItem);
	bool		SelectItem(HTREEITEM hItem, UINT nCode = TVGN_CARET);
	bool		SelectSetFirstVisible(HTREEITEM hItem);
	bool		SortChildren(HTREEITEM hItem, bool bRecurse = false);
	bool		SortChildrenCB(const TVSORTCB& sort, bool bRecurse = false);
};


#define UNCONST_THIS	const_cast<CTreeCtrl*>(this)

inline bool CTreeCtrl::Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::Create(false, WC_TREEVIEW, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline bool CTreeCtrl::CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::CreateEx(false, dwExStyle, WC_TREEVIEW, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline UINT CTreeCtrl::GetCount() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TVM_GETCOUNT));
}

inline UINT CTreeCtrl::GetIndent() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TVM_GETINDENT));
}

inline void CTreeCtrl::SetIndent(UINT nIndent) {
	SendMessage(TVM_SETINDENT, nIndent);
}

inline HIMAGELIST CTreeCtrl::GetImageList(UINT iImage) const {
	return reinterpret_cast<HIMAGELIST>(UNCONST_THIS->SendMessage(TVM_GETIMAGELIST, iImage));
}

inline HIMAGELIST CTreeCtrl::SetImageList(HIMAGELIST hImageList, UINT iImage) {
	return reinterpret_cast<HIMAGELIST>(
		SendMessage(TVM_SETIMAGELIST, iImage, reinterpret_cast<LPARAM>(hImageList)));
}

inline HTREEITEM CTreeCtrl::GetNextItem(HTREEITEM hItem, UINT nCode) const {
	return reinterpret_cast<HTREEITEM>(
		UNCONST_THIS->SendMessage(TVM_GETNEXTITEM, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::ItemHasChildren(HTREEITEM hItem) const {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_CHILDREN;
	UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));
	return item.cChildren != 0;
}

inline HTREEITEM CTreeCtrl::GetChildItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_CHILD);
}

inline HTREEITEM CTreeCtrl::GetNextSiblingItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_NEXT);
}

inline HTREEITEM CTreeCtrl::GetPrevSiblingItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PREVIOUS);
}

inline HTREEITEM CTreeCtrl::GetParentItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PARENT);
}

inline HTREEITEM CTreeCtrl::GetFirstVisibleItem() const {
	return GetNextItem(0, TVGN_FIRSTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetLastVisibleItem() const {
	return GetNextItem(0, TVGN_LASTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetNextVisibleItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_NEXTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetPrevVisibleItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PREVIOUSVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetSelectedItem() const {
	return GetNextItem(0, TVGN_CARET);
}

inline HTREEITEM CTreeCtrl::GetDropHilightItem() const {
	return GetNextItem(0, TVGN_DROPHILITE);
}

inline HTREEITEM CTreeCtrl::GetRootItem() const {
	return GetNextItem(0, TVGN_ROOT);
}

inline bool CTreeCtrl::GetItem(TVITEM& item) const {
	return toBoolean(UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItem(TVITEMEX& item) const {
	return toBoolean(UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::SetItem(const TVITEM& item) {
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::SetItem(const TVITEMEX& item) {
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::SetItem(HTREEITEM hItem, UINT nMask, LPCTSTR lpszItem,
		int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = nMask;
	item.pszText = const_cast<LPTSTR>(lpszItem);
	item.iImage = nImage;
	item.iSelectedImage = nSelectedImage;
	item.state = nState;
	item.stateMask = nStateMask;
	item.lParam = lParam;
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline UINT CTreeCtrl::GetItemState(HTREEITEM hItem, UINT nStateMask) const {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_STATE;
	item.stateMask = nStateMask;
	item.state = 0;
	UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));
	return item.state;
}

inline bool CTreeCtrl::SetItemState(HTREEITEM hItem, UINT nState, UINT nStateMask) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_STATE;
	item.stateMask = nStateMask;
	item.state = nState;
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemImage(HTREEITEM hItem, int& nImage, int& nSelectedImage) const {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	if(UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item))) {
		nImage = item.iImage;
		nSelectedImage = item.iSelectedImage;
		return true;
	} else
		return false;
}

inline bool CTreeCtrl::SetItemImage(HTREEITEM hItem, int nImage, int nSelectedImage) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	item.iImage = nImage;
	item.iSelectedImage = nSelectedImage;
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemText(HTREEITEM hItem, TCHAR* lpszText) const {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_TEXT;
	item.pszText = lpszText;
	item.cchTextMax = _tcslen(lpszText) + 1;
	if(UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item))) {
		lpszText = item.pszText;
		return true;
	} else
		return false;
}

inline bool CTreeCtrl::SetItemText(HTREEITEM hItem, LPCTSTR lpszItem) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_TEXT;
	item.pszText = const_cast<LPTSTR>(lpszItem);
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline DWORD CTreeCtrl::GetItemData(HTREEITEM hItem) const {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_PARAM;
	UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));
	return item.lParam;
}

inline bool CTreeCtrl::SetItemData(HTREEITEM hItem, DWORD dwData) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_PARAM;
	item.lParam = dwData;
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemRect(HTREEITEM hItem, RECT& rect, bool bTextOnly) {
	rect = *reinterpret_cast<RECT*>(hItem);
	return toBoolean(SendMessage(TVM_GETITEMRECT, bTextOnly, reinterpret_cast<LPARAM>(&rect)));
}

inline HWND CTreeCtrl::GetEditControl() const {
	return reinterpret_cast<HWND>(UNCONST_THIS->SendMessage(TVM_GETEDITCONTROL));
}

inline UINT CTreeCtrl::GetVisibleCount() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TVM_GETVISIBLECOUNT));
}

inline HWND CTreeCtrl::GetToolTips() const {
	return reinterpret_cast<HWND>(UNCONST_THIS->SendMessage(TVM_GETTOOLTIPS));
}

inline HWND CTreeCtrl::SetToolTips(HWND hwndTooltip) {
	return reinterpret_cast<HWND>(SendMessage(TVM_SETTOOLTIPS, 0, reinterpret_cast<LPARAM>(hwndTooltip)));
}

inline COLORREF CTreeCtrl::GetBkColor() const {
	return static_cast<COLORREF>(UNCONST_THIS->SendMessage(TVM_GETBKCOLOR));
}

inline COLORREF CTreeCtrl::SetBkColor(COLORREF clr) {
	return static_cast<COLORREF>(SendMessage(TVM_SETBKCOLOR, 0, static_cast<LPARAM>(clr)));
}

inline SHORT CTreeCtrl::GetItemHeight() const {
	return static_cast<short>(UNCONST_THIS->SendMessage(TVM_GETITEMHEIGHT));
}

inline SHORT CTreeCtrl::SetItemHeight(SHORT cyHeight) {
	return static_cast<short>(SendMessage(TVM_SETITEMHEIGHT, cyHeight));
}

inline COLORREF CTreeCtrl::GetTextColor() const {
	return static_cast<COLORREF>(UNCONST_THIS->SendMessage(TVM_GETTEXTCOLOR));
}

inline COLORREF CTreeCtrl::SetTextColor(COLORREF clr) {
	return static_cast<COLORREF>(SendMessage(TVM_SETTEXTCOLOR, clr));
}

inline bool CTreeCtrl::SetInsertMark(HTREEITEM hItem, bool fAfter /* = true */) {
	return toBoolean(SendMessage(TVM_SETINSERTMARK, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::GetCheck(HTREEITEM hItem) const {
	TVITEM item;

	item.mask = TVIF_HANDLE | TVIF_STATE;
	item.hItem = hItem;
	item.stateMask = TVIS_STATEIMAGEMASK;
	UNCONST_THIS->SendMessage(TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));
	return toBoolean(static_cast<UINT>(item.state >> 12) -1);
}

inline bool CTreeCtrl::SetCheck(HTREEITEM hItem, bool bCheck /* = true */) {
	TVITEM item;

	item.mask = TVIF_HANDLE | TVIF_STATE;
	item.hItem = hItem;
	item.stateMask = TVIS_STATEIMAGEMASK;
	item.state = INDEXTOSTATEIMAGEMASK((bCheck ? 2 : 1));
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline COLORREF CTreeCtrl::GetInsertMarkColor() const {
	return static_cast<COLORREF>(UNCONST_THIS->SendMessage(TVM_GETINSERTMARKCOLOR));
}

inline COLORREF CTreeCtrl::SetInsertMarkColor(COLORREF clrNew) {
	return static_cast<COLORREF>(SendMessage(TVM_SETINSERTMARKCOLOR, clrNew));
}

inline HTREEITEM CTreeCtrl::InsertItem(const TVINSERTSTRUCT& insertStruct) {
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&insertStruct)));
}

inline HTREEITEM CTreeCtrl::InsertItem(UINT nMask, LPCTSTR lpszItem, int nImage, int nSelectedImage,
	UINT nState, UINT nStateMask, LPARAM lParam, HTREEITEM hParent, HTREEITEM hInsertAfter) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = nMask;
	tvis.item.pszText = const_cast<TCHAR*>(lpszItem);
	tvis.item.iImage = nImage;
	tvis.item.iSelectedImage = nSelectedImage;
	tvis.item.state = nState;
	tvis.item.stateMask = nStateMask;
	tvis.item.lParam = lParam;
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline HTREEITEM CTreeCtrl::InsertItem(const TCHAR* lpszItem,
		HTREEITEM hParent /* = TVI_ROOT */, HTREEITEM hInsertAfter /* = TVI_LAST */) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = TVIF_TEXT;
	tvis.item.pszText = const_cast<TCHAR*>(lpszItem);
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline HTREEITEM CTreeCtrl::InsertItem(
		const TCHAR* lpszItem, int nImage, int nSelectedImage,
		HTREEITEM hParent /* = TVI_ROOT */, HTREEITEM hInsertAfter /* = TVI_LAST */) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvis.item.pszText = const_cast<TCHAR*>(lpszItem);
	tvis.item.iImage = nImage;
	tvis.item.iSelectedImage = nSelectedImage;
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline bool CTreeCtrl::DeleteItem(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_DELETEITEM, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::DeleteAllItems() {
	return toBoolean(SendMessage(TVM_DELETEITEM, 0, reinterpret_cast<LPARAM>(TVI_ROOT)));
}

inline bool CTreeCtrl::ExpandItem(HTREEITEM hItem, UINT nCode) {
	return toBoolean(SendMessage(TVM_EXPAND, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectItem(HTREEITEM hItem, UINT nCode /* = TVGN_CARET */) {
	return toBoolean(SendMessage(TVM_SELECTITEM, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectDropTarget(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_SELECTITEM, TVGN_DROPHILITE, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectSetFirstVisible(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_SELECTITEM, TVGN_FIRSTVISIBLE, reinterpret_cast<LPARAM>(hItem)));
}

inline HWND CTreeCtrl::EditLabel(HTREEITEM hItem) {
	return reinterpret_cast<HWND>(SendMessage(TVM_EDITLABEL, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline HTREEITEM CTreeCtrl::HitTest(TVHITTESTINFO& tvhi) {
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_HITTEST, 0, reinterpret_cast<LPARAM>(&tvhi)));
}

inline HTREEITEM CTreeCtrl::HitTest(const POINT& pt, UINT nFlags) {
	TVHITTESTINFO tvhti;

	tvhti.flags = nFlags;
	tvhti.pt = pt;
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_HITTEST, 0, reinterpret_cast<LPARAM>(&tvhti)));
}

inline HIMAGELIST CTreeCtrl::CreateDragImage(HTREEITEM hItem) {
	return reinterpret_cast<HIMAGELIST>(
		SendMessage(TVM_CREATEDRAGIMAGE, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SortChildren(HTREEITEM hItem, bool bRecurse /* = false */) {
	return toBoolean(SendMessage(TVM_SORTCHILDREN, bRecurse, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::EnsureVisible(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_ENSUREVISIBLE, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SortChildrenCB(const TVSORTCB& sort, bool bRecurse /* = false */) {
	return toBoolean(SendMessage(TVM_SORTCHILDRENCB, bRecurse, reinterpret_cast<LPARAM>(&sort)));
}

inline bool CTreeCtrl::EndEditLabelNow() {
	return toBoolean(SendMessage(TVM_ENDEDITLABELNOW));
}

inline UINT CTreeCtrl::GetISearchString(LPSTR lpszText) {
	return static_cast<UINT>(SendMessage(TVM_GETISEARCHSTRING, 0, reinterpret_cast<LPARAM>(lpszText)));
}

inline UINT CTreeCtrl::GetScrollTime() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TVM_GETSCROLLTIME));
}

inline UINT CTreeCtrl::SetScrollTime(UINT nScrollTime) {
	return static_cast<UINT>(SendMessage(TVM_SETSCROLLTIME, nScrollTime));
}

inline bool CTreeCtrl::GetUnicodeFormat() const {
	return toBoolean(UNCONST_THIS->SendMessage(TVM_GETUNICODEFORMAT));
}

inline bool CTreeCtrl::SetUnicodeFormat(bool bUnicode /* = true */) {
	return toBoolean(SendMessage(TVM_SETUNICODEFORMAT, bUnicode));
}

inline COLORREF CTreeCtrl::GetLineColor() const {
#ifndef TVM_GETLINECOLOR
	const UINT	TVM_GETLINECOLOR = TV_FIRST + 41;
#endif /* !TVM_GETLINECOLOR */
	return UNCONST_THIS->SendMessage(TVM_GETLINECOLOR);
}

inline COLORREF CTreeCtrl::SetLineColor(COLORREF clrNew /* = CLR_DEFAULT */) {
#ifndef TVM_GETLINECOLOR
	const UINT	TVM_SETLINECOLOR = TV_FIRST + 40;
#endif /* !TVM_GETLINECOLOR */
	return SendMessage(TVM_SETLINECOLOR, 0, clrNew);
}

inline HTREEITEM CTreeCtrl::MapAccIdToHTREEITEM(UINT id) const {
#ifndef TVM_MAPACCIDTOHTREEITEM
	const UINT	TVM_MAPACCIDTOHTREEITEM = TV_FIRST + 42;
#endif /* !TVM_MAPACCIDTOHTREEITEM */
	return reinterpret_cast<HTREEITEM>(UNCONST_THIS->SendMessage(TVM_MAPACCIDTOHTREEITEM, id));
}

inline UINT CTreeCtrl::MapHTREEITEMToAccId(HTREEITEM hItem) const {
#ifndef TVM_MAPHTREEITEMTOACCID
	const UINT	TVM_MAPHTREEITEMTOACCID = TV_FIRST + 43;
#endif /* !TVM_MAPHTREEITEMTOACCID */
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TVM_MAPHTREEITEMTOACCID, reinterpret_cast<WPARAM>(hItem)));
}

#undef UNCONST_THIS

} // namespace Controls
} // namespace Windows
} // namespace Manah

#endif /* _TREE_CTRL_H_ */

/* [EOF] */