// Toolbar.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _TOOLBAR_H_
#define _TOOLBAR_H_

#include "Window.h"


namespace Manah {
namespace Windows {
namespace Controls {

class CToolbar : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool	Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	bool	CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);

	/*  */
	bool		GetAnchorHighlight() const;
	int			GetBitmap(int id) const;
	DWORD		GetBitmapFlags() const;
	bool		GetButton(int index, TBBUTTON& button) const;
	int			GetButtonCount() const;
	SIZE		GetButtonSize() const;
	int			GetButtonText(int id, TCHAR* lpszText) const;
	int			GetButtonTextLength(int id) const;
	bool		GetColorScheme(COLORSCHEME& scheme) const;
	HIMAGELIST	GetDisabledImageList() const;
	HRESULT		GetDropTarget(IDropTarget*& pDropTarget) const;
	DWORD		GetExtendedStyle() const;
	HIMAGELIST	GetHotImageList() const;
	int			GetHotItem() const;
	HIMAGELIST	GetImageList() const;
	void		GetInsertMark(TBINSERTMARK& mark) const;
	COLORREF	GetInsertMarkColor() const;
	bool		GetItemRect(int index, RECT& rect) const;
	bool		GetMaxSize(SIZE& size) const;
	int			GetMaxTextRows() const;
	void		GetPadding(SIZE& padding) const;
	bool		GetRect(int id, RECT& rect) const;
	int			GetRows() const;
	int			GetState(int id) const;
	DWORD		GetStyle() const;
	HWND		GetToolTips() const;
	bool		GetUnicodeFormat() const;
	int			HitTest(const POINT& pt) const;
	bool		InsertMarkHitTest(const POINT& pt, const TBINSERTMARK& mark) const;
	bool		IsButtonChecked(int id) const;
	bool		IsButtonEnabled(int id) const;
	bool		IsButtonHidden(int id) const;
	bool		IsButtonHighlighted(int id) const;
	bool		IsButtonIndeterminate(int id) const;
	bool		IsButtonPressed(int id) const;
	bool		MapAccelerator(TCHAR ch, UINT& id);
	bool		MoveButton(int iOld, int iNew);
	bool		SetAnchorHighlight(bool bEnable = true);
	bool		SetBitmapSize(const SIZE& size);
	bool		SetBitmapSize(int cx, int cy);
	bool		SetButtonSize(const SIZE& size);
	bool		SetButtonSize(int cx, int cy);
	void		SetButtonStructSize(std::size_t nSize = sizeof(TBBUTTON));
	void		SetColorScheme(const COLORSCHEME& scheme);
	bool		SetButtonWidth(int cxMin, int cxMax);
	bool		SetCommandId(int index, UINT id);
	HIMAGELIST	SetDisabledImageList(HIMAGELIST hImageList);
	DWORD		SetExtendedStyle(DWORD dwExStyle);
	HIMAGELIST	SetHotImageList(HIMAGELIST hImageList);
	int			SetHotItem(int index);
	HIMAGELIST	SetImageList(HIMAGELIST hImageList);
	bool		SetIndent(int nIndent);
	void		SetInsertMark(const TBINSERTMARK& mark);
	COLORREF	SetInsertMarkColor(COLORREF clr);
	bool		SetMaxTextRows(int nRows);
	void		SetOwner(HWND hwndOwner);
	void		SetPadding(int cx, int cy, SIZE* pPadding = 0);
	void		SetRow(int nRows, bool bLarger, const RECT& rect);
	bool		SetState(int id, UINT nState);
	void		SetStyle(DWORD dwStyle);
	void		SetToolTips(HWND hwndToolTips);
	bool		SetUnicodeFormat(bool bUnicode = true);

	/*  */
	int		AddBitmap(int cButtons, UINT nBitmapId);
	int		AddBitmap(int cButtons, HBITMAP hBitmap);
	bool	AddButtons(int cButtons, TBBUTTON* lpButtons);
	int		AddString(UINT nStringId);
	int		AddStrings(const TCHAR* lpStrings);
	void	AutoSize();
	bool	ChangeBitmap(int id, int iBitmap);
	bool	CheckButton(int id, bool bCheck = true);
	UINT	CommandToIndex(int id) const;
	void	Customize();
	bool	DeleteButton(int index);
	bool	EnableButton(int id, bool bEnable = true);
	bool	GetButtonInfo(int id, TBBUTTONINFO& bi) const;
	int		GetString(int index, TCHAR* lpszText, int cchMax) const;
	bool	HideButton(int id, bool bHide = true);
	bool	Indeterminate(int id, bool bIndeterminate = true);
	bool	InsertButton(int index, const TBBUTTON& button);
	void	LoadImages(int nImageId);
	void	LoadStdImages(int nImageId);
	bool	MarkButton(int id, bool bHighlight = true);
	bool	PressButton(int id, bool bPress = true);
	bool	ReplaceBitmap(const TBREPLACEBITMAP& tbrb);
	void	RestoreState(HKEY hKeyRoot, const TCHAR* lpszSubKey, const TCHAR* lpszValueName);
	void	SaveState(HKEY hKeyRoot, const TCHAR* lpszSubKey, const TCHAR* lpszValueName);
	bool	SetButtonInfo(int id, const TBBUTTONINFO& bi);
	DWORD	SetDrawTextFlags(DWORD dwMask, DWORD dwFlags);

	// WinXP only
#ifdef TB_GETMETRICS
	void	GetMetrics(TBMETRICS& metrics) const;
	void	SetMetrics(const TBMETRICS& metrics);
	void	SetWindowTheme(const wchar_t* pwszStyleName);
#endif /* TB_GETMETRICS */
};


#define UNCONST_THIS	const_cast<CToolbar*>(this)

inline int CToolbar::AddBitmap(int cButtons, UINT nBitmapId) {
	TBADDBITMAP	tbab;
	tbab.hInst = ::GetModuleHandle(0);
	tbab.nID = nBitmapId;
	return static_cast<int>(SendMessage(TB_ADDBITMAP, cButtons, reinterpret_cast<LPARAM>(&tbab)));
}

inline int CToolbar::AddBitmap(int cButtons, HBITMAP hBitmap) {
	TBADDBITMAP	tbab;
	tbab.hInst = 0;
	tbab.nID = reinterpret_cast<UINT>(hBitmap);
	return static_cast<int>(SendMessage(TB_ADDBITMAP, cButtons, reinterpret_cast<LPARAM>(&tbab)));
}

inline bool CToolbar::AddButtons(int cButtons, TBBUTTON* lpButtons) {
	return toBoolean(SendMessage(TB_ADDBUTTONS, cButtons, reinterpret_cast<LPARAM>(lpButtons)));
}

inline int CToolbar::AddString(UINT nStringId) {
	return static_cast<int>(SendMessage(TB_ADDSTRING, reinterpret_cast<WPARAM>(::GetModuleHandle(0)), nStringId));
}

inline int CToolbar::AddStrings(const TCHAR* lpStrings) {
	return static_cast<int>(SendMessage(TB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpStrings)));
}

inline void CToolbar::AutoSize() {
	SendMessage(TB_AUTOSIZE);
}

inline bool CToolbar::ChangeBitmap(int id, int iBitmap) {
	return toBoolean(SendMessage(TB_CHANGEBITMAP, id, iBitmap));
}

inline bool CToolbar::CheckButton(int id, bool bCheck /* = true */) {
	return toBoolean(SendMessage(TB_CHECKBUTTON, id, bCheck));
}

inline UINT CToolbar::CommandToIndex(int id) const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(TB_COMMANDTOINDEX, id));
}

inline bool CToolbar::Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::Create(false, TOOLBARCLASSNAME, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline bool CToolbar::CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::CreateEx(false, dwExStyle, TOOLBARCLASSNAME, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline void CToolbar::Customize() {
	SendMessage(TB_CUSTOMIZE);
}

inline bool CToolbar::DeleteButton(int index) {
	return toBoolean(SendMessage(TB_DELETEBUTTON, index));
}

inline bool CToolbar::EnableButton(int id, bool bEnable /* = true */) {
	return toBoolean(SendMessage(TB_ENABLEBUTTON, id, bEnable));
}

inline bool CToolbar::GetAnchorHighlight() const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETANCHORHIGHLIGHT));
}

inline int CToolbar::GetBitmap(int id) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETBITMAP, id));
}

inline DWORD CToolbar::GetBitmapFlags() const {
	return UNCONST_THIS->SendMessage(TB_GETBITMAPFLAGS);
}

inline bool CToolbar::GetButton(int index, TBBUTTON& button) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETBUTTON, index, reinterpret_cast<LPARAM>(&button)));
}

inline int CToolbar::GetButtonCount() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_BUTTONCOUNT));
}

inline bool CToolbar::GetButtonInfo(int id, TBBUTTONINFO& bi) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETBUTTONINFO, id, reinterpret_cast<LPARAM>(&bi)));
}

inline SIZE CToolbar::GetButtonSize() const {
	const DWORD	dw = UNCONST_THIS->SendMessage(TB_GETBUTTONSIZE);
	const SIZE	size = {LOWORD(dw), HIWORD(dw)};
	return size;
}

inline int CToolbar::GetButtonText(int id, TCHAR* lpszText) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETBUTTONTEXT, id, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CToolbar::GetButtonTextLength(int id) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETBUTTONTEXT, id));
}

inline bool CToolbar::GetColorScheme(COLORSCHEME& scheme) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETCOLORSCHEME, 0, reinterpret_cast<LPARAM>(&scheme)));
}

inline HIMAGELIST CToolbar::GetDisabledImageList() const {
	return reinterpret_cast<HIMAGELIST>(UNCONST_THIS->SendMessage(TB_GETDISABLEDIMAGELIST));
}

inline HRESULT CToolbar::GetDropTarget(IDropTarget*& pDropTarget) const {
	return UNCONST_THIS->SendMessage(TB_GETOBJECT,
		reinterpret_cast<WPARAM>(&IID_IDropTarget), reinterpret_cast<LPARAM>(&pDropTarget));
}

inline DWORD CToolbar::GetExtendedStyle() const {
	return UNCONST_THIS->SendMessage(TB_GETEXTENDEDSTYLE);
}

inline HIMAGELIST CToolbar::GetHotImageList() const {
	return reinterpret_cast<HIMAGELIST>(UNCONST_THIS->SendMessage(TB_GETHOTIMAGELIST));
}

inline int CToolbar::GetHotItem() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETHOTITEM));
}

inline HIMAGELIST CToolbar::GetImageList() const {
	return reinterpret_cast<HIMAGELIST>(UNCONST_THIS->SendMessage(TB_GETIMAGELIST));
}

inline void CToolbar::GetInsertMark(TBINSERTMARK& mark) const {
	UNCONST_THIS->SendMessage(TB_GETINSERTMARK, 0, reinterpret_cast<LPARAM>(&mark));
}

inline COLORREF CToolbar::GetInsertMarkColor() const {
	return UNCONST_THIS->SendMessage(TB_GETINSERTMARKCOLOR);
}

inline bool CToolbar::GetItemRect(int index, RECT& rect) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETITEMRECT, index, reinterpret_cast<LPARAM>(&rect)));
}

inline bool CToolbar::GetMaxSize(SIZE& size) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETMAXSIZE, 0, reinterpret_cast<LPARAM>(&size)));
}

inline int CToolbar::GetMaxTextRows() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETTEXTROWS));
}

inline void CToolbar::GetPadding(SIZE& padding) const {
	const DWORD	dwPadding = UNCONST_THIS->SendMessage(TB_GETPADDING);
	padding.cx = LOWORD(dwPadding);
	padding.cy = HIWORD(dwPadding);
}

inline bool CToolbar::GetRect(int id, RECT& rect) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETRECT, id, reinterpret_cast<LPARAM>(&rect)));
}

inline int CToolbar::GetRows() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETROWS));
}

inline int CToolbar::GetState(int id) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_GETSTATE, id));
}

#ifdef TB_GETSTRING
inline int CToolbar::GetString(int index, TCHAR* lpszText, int cchMax) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(
		TB_GETSTRING, MAKEWPARAM(cchMax, index), reinterpret_cast<LPARAM>(lpszText)));
}
#endif

inline DWORD CToolbar::GetStyle() const {
	return UNCONST_THIS->SendMessage(TB_GETSTYLE);
}

inline HWND CToolbar::GetToolTips() const {
	return reinterpret_cast<HWND>(UNCONST_THIS->SendMessage(TB_GETTOOLTIPS));
}

inline bool CToolbar::GetUnicodeFormat() const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_GETUNICODEFORMAT));
}

inline bool CToolbar::HideButton(int id, bool bHide /* = true */) {
	return toBoolean(SendMessage(TB_HIDEBUTTON, id, bHide));
}

inline int CToolbar::HitTest(const POINT& pt) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(TB_HITTEST, 0, reinterpret_cast<LPARAM>(&pt)));
}

inline bool CToolbar::Indeterminate(int id, bool bIndeterminate /* = true */) {
	return toBoolean(SendMessage(TB_INDETERMINATE, id, bIndeterminate));
}

inline bool CToolbar::InsertButton(int index, const TBBUTTON& button) {
	return toBoolean(SendMessage(TB_INSERTBUTTON, index, reinterpret_cast<LPARAM>(&button)));
}

inline bool CToolbar::InsertMarkHitTest(const POINT& pt, const TBINSERTMARK& mark) const {
	return toBoolean(UNCONST_THIS->SendMessage(
		TB_INSERTMARKHITTEST, reinterpret_cast<WPARAM>(&pt), reinterpret_cast<LPARAM>(&mark)));
}

inline bool CToolbar::IsButtonChecked(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONCHECKED, id));
}

inline bool CToolbar::IsButtonEnabled(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONENABLED, id));
}

inline bool CToolbar::IsButtonHidden(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONHIDDEN, id));
}

inline bool CToolbar::IsButtonHighlighted(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONHIGHLIGHTED, id));
}

inline bool CToolbar::IsButtonIndeterminate(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONINDETERMINATE, id));
}

inline bool CToolbar::IsButtonPressed(int id) const {
	return toBoolean(UNCONST_THIS->SendMessage(TB_ISBUTTONPRESSED, id));
}

inline void CToolbar::LoadImages(int nImageId) {
	SendMessage(TB_LOADIMAGES, nImageId, reinterpret_cast<LPARAM>(::GetModuleHandle(0)));
}

inline void CToolbar::LoadStdImages(int nImageId) {
	SendMessage(TB_LOADIMAGES, nImageId, reinterpret_cast<LPARAM>(HINST_COMMCTRL));
}

inline bool CToolbar::MapAccelerator(TCHAR ch, UINT& id) {
	return toBoolean(SendMessage(TB_MAPACCELERATOR, ch, reinterpret_cast<LPARAM>(&id)));
}

inline bool CToolbar::MarkButton(int id, bool bHighlight /* = true */) {
	return toBoolean(SendMessage(TB_MARKBUTTON, id, bHighlight));
}

inline bool CToolbar::MoveButton(int iOld, int iNew) {
	return toBoolean(SendMessage(TB_MOVEBUTTON, iOld, iNew));
}

inline bool CToolbar::PressButton(int id, bool bPress /* = true */) {
	return toBoolean(SendMessage(TB_PRESSBUTTON, id, bPress));
}

inline bool CToolbar::ReplaceBitmap(const TBREPLACEBITMAP& tbrb) {
	return toBoolean(SendMessage(TB_REPLACEBITMAP, 0, reinterpret_cast<LPARAM>(&tbrb)));
}

inline void CToolbar::RestoreState(HKEY hKeyRoot, const TCHAR* lpszSubKey, const TCHAR* lpszValueName) {
	TBSAVEPARAMS	tbsp = {hKeyRoot, lpszSubKey, lpszValueName};
	SendMessage(TB_SAVERESTORE, false, reinterpret_cast<LPARAM>(&tbsp));
}

inline void CToolbar::SaveState(HKEY hKeyRoot, const TCHAR* lpszSubKey, const TCHAR* lpszValueName) {
	TBSAVEPARAMS	tbsp = {hKeyRoot, lpszSubKey, lpszValueName};
	SendMessage(TB_SAVERESTORE, true, reinterpret_cast<LPARAM>(&tbsp));
}

inline bool CToolbar::SetAnchorHighlight(bool bEnable /* = true */) {
	return toBoolean(SendMessage(TB_SETANCHORHIGHLIGHT, bEnable));
}

inline bool CToolbar::SetBitmapSize(const SIZE& size) {
	return toBoolean(SendMessage(TB_SETBITMAPSIZE, 0, MAKELPARAM(size.cx, size.cy)));
}

inline bool CToolbar::SetBitmapSize(int cx, int cy) {
	return toBoolean(SendMessage(TB_SETBITMAPSIZE, 0, MAKELPARAM(cx, cy)));
}

inline bool CToolbar::SetButtonInfo(int id, const TBBUTTONINFO& bi) {
	return toBoolean(SendMessage(TB_SETBUTTONINFO, id, reinterpret_cast<LPARAM>(&bi)));
}

inline bool CToolbar::SetButtonSize(const SIZE& size) {
	return toBoolean(SendMessage(TB_SETBUTTONSIZE, 0, MAKELPARAM(size.cx, size.cy)));
}

inline bool CToolbar::SetButtonSize(int cx, int cy) {
	return toBoolean(SendMessage(TB_SETBUTTONSIZE, 0, MAKELPARAM(cx, cy)));
}

inline void CToolbar::SetButtonStructSize(std::size_t nSize /* = sizeof(TBBUTTON) */) {
	SendMessage(TB_BUTTONSTRUCTSIZE, nSize);
}

inline bool CToolbar::SetButtonWidth(int cxMin, int cxMax) {
	return toBoolean(SendMessage(TB_SETBUTTONWIDTH, 0, MAKELPARAM(cxMin, cxMax)));
}

inline void CToolbar::SetColorScheme(const COLORSCHEME& scheme) {
	SendMessage(TB_SETCOLORSCHEME, 0, reinterpret_cast<LPARAM>(&scheme));
}

inline bool CToolbar::SetCommandId(int index, UINT id) {
	return toBoolean(SendMessage(TB_SETCMDID, index, id));
}

inline HIMAGELIST CToolbar::SetDisabledImageList(HIMAGELIST hImageList) {
	return reinterpret_cast<HIMAGELIST>(SendMessage(TB_SETDISABLEDIMAGELIST, 0, reinterpret_cast<LPARAM>(hImageList)));
}

inline DWORD CToolbar::SetDrawTextFlags(DWORD dwMask, DWORD dwFlags) {
	return SendMessage(TB_SETDRAWTEXTFLAGS, dwMask, dwFlags);
}

inline DWORD CToolbar::SetExtendedStyle(DWORD dwExStyle) {
	return SendMessage(TB_SETEXTENDEDSTYLE, 0, dwExStyle);
}

inline HIMAGELIST CToolbar::SetHotImageList(HIMAGELIST hImageList) {
	return reinterpret_cast<HIMAGELIST>(SendMessage(TB_SETHOTIMAGELIST, 0, reinterpret_cast<LPARAM>(hImageList)));
}

inline int CToolbar::SetHotItem(int index) {
	return static_cast<int>(SendMessage(TB_SETHOTITEM, index));
}

inline HIMAGELIST CToolbar::SetImageList(HIMAGELIST hImageList) {
	return reinterpret_cast<HIMAGELIST>(SendMessage(TB_SETIMAGELIST, 0, reinterpret_cast<LPARAM>(hImageList)));
}

inline bool CToolbar::SetIndent(int nIndent) {
	return toBoolean(SendMessage(TB_SETINDENT, nIndent));
}

inline void CToolbar::SetInsertMark(const TBINSERTMARK& mark) {
	SendMessage(TB_SETINSERTMARK, 0, reinterpret_cast<LPARAM>(&mark));
}

inline COLORREF CToolbar::SetInsertMarkColor(COLORREF clr) {
	return SendMessage(TB_SETINSERTMARKCOLOR, 0, clr);
}

inline bool CToolbar::SetMaxTextRows(int nRows) {
	return toBoolean(SendMessage(TB_SETMAXTEXTROWS, nRows));
}

inline void CToolbar::SetOwner(HWND hwndOwner) {
	SendMessage(TB_SETPARENT, reinterpret_cast<WPARAM>(hwndOwner));
}

inline void CToolbar::SetPadding(int cx, int cy, SIZE* pPadding /* = 0 */) {
	const DWORD	dwPadding = SendMessage(TB_SETPADDING, 0, MAKELPARAM(cx, cy));
	if(pPadding != 0) {
		pPadding->cx = LOWORD(dwPadding);
		pPadding->cy = HIWORD(dwPadding);
	}
}

inline void CToolbar::SetRow(int nRows, bool bLarger, const RECT& rect) {
	SendMessage(TB_SETROWS, MAKELPARAM(nRows, bLarger), reinterpret_cast<LPARAM>(&rect));
}

inline bool CToolbar::SetState(int id, UINT nState) {
	return toBoolean(SendMessage(TB_SETSTATE, id, nState));
}

inline void CToolbar::SetStyle(DWORD dwStyle) {
	SendMessage(TB_SETSTYLE, 0, dwStyle);
}

inline void CToolbar::SetToolTips(HWND hwndToolTips) {
	SendMessage(TB_SETTOOLTIPS, reinterpret_cast<WPARAM>(hwndToolTips));
}

inline bool CToolbar::SetUnicodeFormat(bool bUnicode /* = true */) {
	return toBoolean(SendMessage(TB_SETUNICODEFORMAT, bUnicode));
}

#ifdef TB_GETMETRICS
inline void CToolbar::GetMetrics(TBMETRICS& metrics) const {
	UNCONST_THIS->SendMessage(TB_GETMETRICS, 0, reinterpret_cast<LPARAM>(&metrics));
}

inline void CToolbar::SetMetrics(const TBMETRICS& metrics) {
	SendMessage(TB_SETMETRICS, 0, reinterpret_cast<LPARAM>(&metrics));
}

inline void CToolbar::SetWindowTheme(const wchar_t* pwszStyleName) {
	SendMessage(TB_SETWINDOWTHEME, 0, reinterpret_cast<LPARAM>(pwszStyleName));
}
#endif /* TB_GETMETRICS */

#undef UNCONST_THIS

} // namespace Controls
} // namespace Windows
} // namespace Controls

#endif /* _TOOLBAR_H_ */

/* [EOF] */