// Rebar.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _REBAR_H_
#define _REBAR_H_

#include "Window.h"


namespace Manah {
namespace Windows {
namespace Controls {

class CRebar : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool	Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	bool	CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);

	/*  */
	void		GetBandBorders(int iBand, RECT& rect) const;
	UINT		GetBandCount() const;
	bool		GetBandInfo(int iBand, REBARBANDINFO& rbbi) const;
	UINT		GetBarHeight() const;
	bool		GetBarInfo(REBARINFO& rbi) const;
	COLORREF	GetBkColor() const;
	bool		GetColorScheme(COLORSCHEME& scheme) const;
	void		GetDropTarget(IDropTarget*& pDropTarget) const;
	HIMAGELIST	GetImageList() const;
	HPALETTE	GetPalette() const;
	bool		GetRect(int iBand, RECT& rect) const;
	UINT		GetRowCount() const;
	UINT		GetRowHeight(int iBand) const;
	COLORREF	GetTextColor() const;
	HWND		GetToolTips() const;
	bool		GetUnicodeFormat() const;
	int			IdToIndex(UINT id) const;
	bool		SetBandInfo(UINT iBand, const REBARBANDINFO& rbbi);
	bool		SetBarInfo(const REBARINFO& rbi);
	COLORREF	SetBkColor(COLORREF clr);
	bool		SetImageList(HIMAGELIST hImageList);
	HWND		SetOwner(HWND hwndOwner);
	HPALETTE	SetPalette(HPALETTE hPalette);
	void		SetColorScheme(const COLORSCHEME& scheme);
	COLORREF	SetTextColor(COLORREF clr);
	void		SetToolTips(HWND hwndToolTips);
	bool		SetUnicodeFormat(bool bUnicode = true);

	/*  */
	void	BeginDrag(UINT iBand, DWORD dwPos = static_cast<DWORD>(-1));
	void	BeginDrag(UINT iBand, int x, int y);
	bool	DeleteBand(UINT iBand);
	void	DragMove(DWORD dwPos = static_cast<DWORD>(-1));
	void	DragMove(int x, int y);
	void	EndDrag();
	int		HitTest(RBHITTESTINFO& rbhi);
	bool	InsertBand(UINT iBand, const REBARBANDINFO& rbbi);
	void	LockBands(bool bLock);	// from WTL
	void	MaximizeBand(UINT iBand);
	void	MinimizeBand(UINT iBand);
	bool	MoveBand(UINT iFrom, UINT iTo);
	void	PushChevron(UINT iBand, LPARAM lParam);
	void	RestoreBand(UINT iBand);
	bool	ShowBand(UINT iBand, bool bShow);
	bool	SizeToRect(const RECT& rect);

#ifdef RB_GETMARGINS
	void	GetBandMargins(MARGINS& margins) const;
	void	SetWindowTheme(const WCHAR* lpszStyleName);
#endif /* RB_GETMARGINS */
};


#define UNCONST_THIS	const_cast<CRebar*>(this)

inline void CRebar::BeginDrag(UINT iBand, DWORD dwPos /* = -1 */) {
	SendMessage(RB_BEGINDRAG, iBand, dwPos);
}

inline void CRebar::BeginDrag(UINT iBand, int x, int y) {
	BeginDrag(iBand, MAKELPARAM(x, y));
}

inline bool CRebar::Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::Create(false, REBARCLASSNAME, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline bool CRebar::CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	return CWindow::CreateEx(false, dwExStyle, REBARCLASSNAME, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id));
}

inline bool CRebar::DeleteBand(UINT iBand) {
	return toBoolean(SendMessage(RB_DELETEBAND, iBand));
}

inline void CRebar::DragMove(DWORD dwPos /* = -1 */) {
	SendMessage(RB_DRAGMOVE, 0, dwPos);
}

inline void CRebar::DragMove(int x, int y) {
	DragMove(MAKELPARAM(x, y));
}

inline void CRebar::EndDrag() {
	SendMessage(RB_ENDDRAG);
}

inline void CRebar::GetBandBorders(int iBand, RECT& rect) const {
	UNCONST_THIS->SendMessage(RB_GETBANDBORDERS, iBand, reinterpret_cast<LPARAM>(&rect));
}

inline UINT CRebar::GetBandCount() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(RB_GETBANDCOUNT));
}

inline bool CRebar::GetBandInfo(int iBand, REBARBANDINFO& rbbi) const {
	return toBoolean(UNCONST_THIS->SendMessage(RB_GETBANDINFO, iBand, reinterpret_cast<LPARAM>(&rbbi)));
}

inline UINT CRebar::GetBarHeight() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(RB_GETBARHEIGHT));
}

inline bool CRebar::GetBarInfo(REBARINFO& rbi) const {
	return toBoolean(UNCONST_THIS->SendMessage(RB_GETBARINFO, 0, reinterpret_cast<LPARAM>(&rbi)));
}

inline COLORREF CRebar::GetBkColor() const {
	return UNCONST_THIS->SendMessage(RB_GETBKCOLOR);
}

inline bool CRebar::GetColorScheme(COLORSCHEME& scheme) const {
	return toBoolean(UNCONST_THIS->SendMessage(RB_GETCOLORSCHEME, 0, reinterpret_cast<LPARAM>(&scheme)));
}

inline void CRebar::GetDropTarget(IDropTarget*& pDropTarget) const {
	UNCONST_THIS->SendMessage(RB_GETDROPTARGET, 0, reinterpret_cast<LPARAM>(&pDropTarget));
}

inline HIMAGELIST CRebar::GetImageList() const {
	REBARINFO	rbi;
	rbi.cbSize = sizeof(REBARINFO);
	rbi.fMask = RBIM_IMAGELIST;
	if(GetBarInfo(rbi))
		return rbi.himl;
	return 0;
}

inline HPALETTE CRebar::GetPalette() const {
	return reinterpret_cast<HPALETTE>(UNCONST_THIS->SendMessage(RB_GETPALETTE));
}

inline bool CRebar::GetRect(int iBand, RECT& rect) const {
	return toBoolean(UNCONST_THIS->SendMessage(RB_GETRECT, iBand, reinterpret_cast<LPARAM>(&rect)));
}

inline UINT CRebar::GetRowCount() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(RB_GETROWCOUNT));
}

inline UINT CRebar::GetRowHeight(int iBand) const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(RB_GETROWHEIGHT, iBand));
}

inline COLORREF CRebar::GetTextColor() const {
	return UNCONST_THIS->SendMessage(RB_GETTEXTCOLOR);
}

inline HWND CRebar::GetToolTips() const {
	return reinterpret_cast<HWND>(UNCONST_THIS->SendMessage(RB_GETTOOLTIPS));
}

inline bool CRebar::GetUnicodeFormat() const {
	return toBoolean(UNCONST_THIS->SendMessage(RB_GETUNICODEFORMAT));
}

inline int CRebar::HitTest(RBHITTESTINFO& rbhi) {
	return static_cast<int>(SendMessage(RB_HITTEST, 0, reinterpret_cast<LPARAM>(&rbhi)));
}

inline int CRebar::IdToIndex(UINT id) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(RB_IDTOINDEX, id));
}

inline bool CRebar::InsertBand(UINT iBand, const REBARBANDINFO& rbbi) {
	return toBoolean(SendMessage(RB_INSERTBAND, iBand, reinterpret_cast<LPARAM>(&rbbi)));
}

inline void CRebar::LockBands(bool bLock) {
	const UINT		cBands = GetBandCount();
	REBARBANDINFO	rbbi;


	ZeroMemory(&rbbi, sizeof(REBARBANDINFO));
	rbbi.cbSize = sizeof(REBARBANDINFO);
	rbbi.fMask = RBBIM_STYLE;
	for(UINT iBand = 0; iBand < cBands; ++iBand) {
		GetBandInfo(iBand, rbbi);
		if(!toBoolean(rbbi.fStyle & RBBS_GRIPPERALWAYS)) {
			rbbi.fStyle |= RBBS_GRIPPERALWAYS;
			SetBandInfo(iBand, rbbi);
			rbbi.fStyle &= ~RBBS_GRIPPERALWAYS;
			SetBandInfo(iBand, rbbi);
		}
		if(bLock)
			rbbi.fStyle |= RBBS_NOGRIPPER;
		else
			rbbi.fStyle &= ~RBBS_NOGRIPPER;
		SetBandInfo(iBand, rbbi);
	}
}

inline void CRebar::MaximizeBand(UINT iBand) {
	SendMessage(RB_MAXIMIZEBAND, iBand, false);
}

inline void CRebar::MinimizeBand(UINT iBand) {
	SendMessage(RB_MINIMIZEBAND, iBand);
}

inline bool CRebar::MoveBand(UINT iFrom, UINT iTo) {
	assert(iTo >= 0 && iTo < GetBandCount());
	return toBoolean(SendMessage(RB_MOVEBAND, iFrom, iTo));
}

inline void CRebar::PushChevron(UINT iBand, LPARAM lParam) {
#ifndef RB_PUSHCHEVRON
	const UINT	RB_PUSHCHEVRON = WM_USER + 43;
#endif /* !RB_PUSHCHEVRON */
	SendMessage(RB_PUSHCHEVRON, iBand, lParam);
}

inline void CRebar::RestoreBand(UINT iBand) {
	SendMessage(RB_MAXIMIZEBAND, iBand, true);
}

inline bool CRebar::SetBandInfo(UINT iBand, const REBARBANDINFO& rbbi) {
	return toBoolean(SendMessage(RB_SETBANDINFO, iBand, reinterpret_cast<LPARAM>(&rbbi)));
}

inline bool CRebar::SetBarInfo(const REBARINFO& rbi) {
	return toBoolean(SendMessage(RB_SETBARINFO, 0, reinterpret_cast<LPARAM>(&rbi)));
}

inline COLORREF CRebar::SetBkColor(COLORREF clr) {
	return SendMessage(RB_SETBKCOLOR, 0, clr);
}

inline bool CRebar::SetImageList(HIMAGELIST hImageList) {
	REBARINFO	rbi;
	rbi.cbSize = sizeof(REBARINFO);
	rbi.fMask = RBIM_IMAGELIST;
	rbi.himl = hImageList;
	return SetBarInfo(rbi);
}

inline HWND CRebar::SetOwner(HWND hwndOwner) {
	return reinterpret_cast<HWND>(SendMessage(RB_SETPARENT, reinterpret_cast<WPARAM>(hwndOwner)));
}

inline HPALETTE CRebar::SetPalette(HPALETTE hPalette) {
	return reinterpret_cast<HPALETTE>(SendMessage(RB_SETPALETTE, 0, reinterpret_cast<LPARAM>(hPalette)));
}

inline void CRebar::SetColorScheme(const COLORSCHEME& scheme) {
	SendMessage(RB_SETCOLORSCHEME, 0, reinterpret_cast<LPARAM>(&scheme));
}

inline COLORREF CRebar::SetTextColor(COLORREF clr) {
	return SendMessage(RB_SETTEXTCOLOR, 0, clr);
}

inline void CRebar::SetToolTips(HWND hwndToolTips) {
	SendMessage(RB_SETTOOLTIPS, reinterpret_cast<WPARAM>(hwndToolTips));
}

inline bool CRebar::SetUnicodeFormat(bool bUnicode /* = true */) {
	return toBoolean(SendMessage(RB_SETUNICODEFORMAT, bUnicode));
}

inline bool CRebar::ShowBand(UINT iBand, bool bShow) {
	return toBoolean(SendMessage(RB_SHOWBAND, iBand, bShow));
}

inline bool CRebar::SizeToRect(const RECT& rect) {
	return toBoolean(SendMessage(RB_SIZETORECT, 0, reinterpret_cast<LPARAM>(&rect)));
}

#ifdef RB_GETMARGINS
inline void CRebar::GetBandMargins(MARGINS& margins) const {
	SendMessage(RB_GETBANDMARGINS, 0, reinterpret_cast<LPARAM>(&margins));
}

inline void CRebar::SetWindowTheme(const WCHAR* lpszStyleName) {
	SendMessage(RB_SETWINDOWTHEME, 0, reinterpret_cast<LPARAM>(lpszStyleName));
}
#endif /* RB_GETMARGINS */

#undef UNCONST_THIS

} // namespace Controls
} // namespace Windows
} // namespace Controls

#endif /* _REBAR_H_ */

/* [EOF] */