// ListBox.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _LISTBOX_H_
#define _LISTBOX_H_

#include "Window.h"


// CListBox class definition
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {
namespace Controls {

class CListBox : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool	Attach(HWND hWnd, bool bSubClass = false);
	bool	Create(bool bSubClass, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	bool	CreateEx(bool bSubClass, DWORD dwExStyle,
				DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id);
	int		InitStorage(int nItems, UINT nBytes);

	/*  */
	int		GetCount() const;
	int		GetHorizontalExtent() const;
	DWORD	GetItemData(int nIndex) const;
	void*	GetItemDataPtr(int nIndex) const;
	int		GetItemRect(int nIndex, RECT* lpRect) const;
	int		GetItemHeight(int nIndex) const;
	LCID	GetLocale() const;
	int		GetSel(int nIndex) const;
	int		GetText(int nIndex, TCHAR* lpszBuffer) const;
	int		GetTextLen(int nIndex) const;
	int		GetTopIndex() const;
	UINT	ItemFromPoint(const POINT& pt, bool& bOutSide) const;
	void	SetColumnWidth(int cxWidth);
	void	SetHorizontalExtent(int cxExtent);
	int		SetItemData(int nIndex, DWORD dwItemData);
	int		SetItemDataPtr(int nIndex, void* pData);
	int		SetItemHeight(int nIndex, UINT cyItemHeight);
	LCID	SetLocale(LCID nNewLocale);
	void	SetTabStops();
	bool	SetTabStops(const int& cxEachStop);
	bool	SetTabStops(int nTabStops, INT* rgTabStops);
	int		SetTopIndex(int nIndex);

	int		GetCurSel() const;
	int		SetCurSel(int nSelect);

	int		GetAnchorIndex() const;
	int		GetCaretIndex() const;
	int		GetSelCount() const;
	int		GetSelItems(int nMaxItems, INT* rgIndex) const;
	void	SetAnchorIndex(int nIndex);
	int		SetCaretIndex(int nIndex, bool bScroll = true);
	int		SelItemRange(int nFirstItem, int nLastItem, bool bSelect = true);
	int		SetSel(int nIndex, bool bSelect = true);

	/*  */
	int		AddString(const TCHAR* lpszItem);
	int		DeleteString(UINT nIndex);
	int		Dir(UINT attr, const TCHAR* lpszWildCard);
	int		FindString(int nStartAfter, const TCHAR* lpszItem) const;
	int		FindStringExact(int nStartAfter, const TCHAR* lpszItem) const;
	int		InsertString(int nIndex, const TCHAR* lpszItem);
	void	ResetContent();
	int		SelectString(int nStartAfter, const TCHAR* lpszItem);
protected:
	friend class WndProcProvider<CListBox, true>;
};


// CListBox class implementation
/////////////////////////////////////////////////////////////////////////////

#define UNCONST_THIS	const_cast<CListBox*>(this)

inline bool CListBox::Attach(HWND hWnd, bool bSubClass /* = false */) {
	AssertValid();

	if(IsWindow() || !::IsWindow(hWnd) || m_OldProc != 0)
		return false;
	m_hWnd = hWnd;

	if(bSubClass){
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(
			GWL_WNDPROC, reinterpret_cast<LPARAM>(STANDARD_WINDOW_CLASS_WNDPROC(CListBox))));
		assert(m_OldProc != STANDARD_WINDOW_CLASS_WNDPROC(CListBox));
		m_lOldUserData = GetWindowLong(GWL_USERDATA);
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}
	return true;
}

inline bool CListBox::Create(bool bSubClass, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindow(
		_T("LISTBOX"), _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id),
		reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC,
			reinterpret_cast<LPARAM>(STANDARD_WINDOW_CLASS_WNDPROC(CListBox))));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}
	return true;
}

inline bool CListBox::CreateEx(bool bSubClass, DWORD dwExStyle,
		DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindowEx(
		dwExStyle, _T("LISTBOX"), _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		hwndParent, reinterpret_cast<HMENU>(id),
		reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC,
				reinterpret_cast<LPARAM>(STANDARD_WINDOW_CLASS_WNDPROC(CListBox))));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}
	return true;
}

inline int CListBox::InitStorage(int nItems, UINT nBytes) {
	return static_cast<int>(SendMessage(LB_INITSTORAGE, nItems, static_cast<LPARAM>(nBytes)));
}

inline int CListBox::GetCount() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETCOUNT));
}

inline int CListBox::GetHorizontalExtent() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETHORIZONTALEXTENT));
}

inline void CListBox::SetHorizontalExtent(int cxExtent) {
	SendMessage(LB_SETHORIZONTALEXTENT, cxExtent);
}

inline int CListBox::GetTopIndex() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETTOPINDEX));
}

inline int CListBox::SetTopIndex(int nIndex) {
	return static_cast<int>(SendMessage(LB_SETTOPINDEX, nIndex));
}

inline DWORD CListBox::GetItemData(int nIndex) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETITEMDATA, nIndex));
}

inline void* CListBox::GetItemDataPtr(int nIndex) const {
	return reinterpret_cast<void*>(UNCONST_THIS->SendMessage(LB_GETITEMDATA, nIndex));
}

inline int CListBox::SetItemData(int nIndex, DWORD dwItemData) {
	return static_cast<int>(SendMessage(LB_SETITEMDATA, nIndex, static_cast<LPARAM>(dwItemData)));
}

inline int CListBox::SetItemDataPtr(int nIndex, void* pData) {
	return static_cast<int>(SendMessage(LB_SETITEMDATA, nIndex, reinterpret_cast<LPARAM>(pData)));
}

inline int CListBox::GetItemRect(int nIndex, RECT* lpRect) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETITEMRECT, nIndex, reinterpret_cast<LPARAM>(lpRect)));
}

inline UINT CListBox::ItemFromPoint(const POINT& pt, bool& bOutSide) const {
	UINT nReturn;

	nReturn = static_cast<UINT>(UNCONST_THIS->SendMessage(LB_ITEMFROMPOINT, 0, MAKELPARAM(pt.x, pt.y)));
	bOutSide = toBoolean(HIWORD(nReturn));

	return nReturn;
}

inline int CListBox::SetItemHeight(int nIndex, UINT cyItemHeight) {
	return static_cast<int>(SendMessage(LB_SETITEMHEIGHT, nIndex, static_cast<LPARAM>(cyItemHeight)));
}

inline int CListBox::GetItemHeight(int nIndex) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETITEMHEIGHT, nIndex));
}

inline int CListBox::GetSel(int nIndex) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETSEL, nIndex));
}

inline int CListBox::GetText(int nIndex, TCHAR* lpszBuffer) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETTEXT, nIndex, reinterpret_cast<LPARAM>(lpszBuffer)));
}

inline int CListBox::GetTextLen(int nIndex) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETTEXTLEN, nIndex));
}

inline void CListBox::SetColumnWidth(int cxWidth) {
	SendMessage(LB_SETCOLUMNWIDTH, cxWidth);
}

inline void CListBox::SetTabStops() {
	SendMessage(LB_GETSEL);
}

inline bool CListBox::SetTabStops(const int& cxEachTabStop) {
	int rgTabStops[1] = {cxEachTabStop};
	return toBoolean(SendMessage(LB_GETSEL, 1, reinterpret_cast<LPARAM>(rgTabStops)));
}

inline bool CListBox::SetTabStops(int nTabStops, INT* rgTabStops) {
	return toBoolean(SendMessage(LB_GETSEL, nTabStops, reinterpret_cast<LPARAM>(rgTabStops)));
}

inline LCID CListBox::GetLocale() const {
	return static_cast<LCID>(UNCONST_THIS->SendMessage(LB_GETLOCALE));
}

inline LCID CListBox::SetLocale(LCID nNewLocale) {
	return static_cast<LCID>(SendMessage(LB_SETLOCALE, nNewLocale));
}

inline int CListBox::GetCurSel() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETCURSEL));
}

inline int CListBox::SetCurSel(int nSelect) {
	return static_cast<int>(SendMessage(LB_SETCURSEL, nSelect));
}

inline int CListBox::SetSel(int nIndex, bool bSelect /* = true */) {
	return static_cast<int>(SendMessage(LB_SETSEL, bSelect, nIndex));
}

inline int CListBox::GetCaretIndex() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETCARETINDEX));
}

inline int CListBox::SetCaretIndex(int nIndex, bool bScroll /* = true */) {
	return static_cast<int>(SendMessage(LB_SETCARETINDEX, nIndex, bScroll));
}

inline int CListBox::GetSelCount() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETSELCOUNT));
}

inline int CListBox::GetSelItems(int nMaxItems, INT* rgIndex) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETCURSEL, nMaxItems, reinterpret_cast<LPARAM>(rgIndex)));
}

inline int CListBox::SelItemRange(int nFirstItem, int nLastItem, bool bSelect /* = true */) {
	return static_cast<int>(SendMessage(LB_GETCURSEL, bSelect, MAKELPARAM(nFirstItem, nLastItem)));
}

inline void CListBox::SetAnchorIndex(int nIndex) {
	SendMessage(LB_SETANCHORINDEX, nIndex);
}

inline int CListBox::GetAnchorIndex() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(LB_GETANCHORINDEX));
}

inline int CListBox::AddString(const TCHAR* lpszItem) {
	return static_cast<int>(SendMessage(LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpszItem)));
}

inline int CListBox::DeleteString(UINT nIndex) {
	return static_cast<int>(SendMessage(LB_DELETESTRING, nIndex));
}

inline int CListBox::InsertString(int nIndex, const TCHAR* lpszItem) {
	return static_cast<int>(SendMessage(LB_INSERTSTRING, nIndex, reinterpret_cast<LPARAM>(lpszItem)));
}

inline void CListBox::ResetContent() {
	SendMessage(LB_RESETCONTENT);
}

inline int CListBox::Dir(UINT attr, const TCHAR* lpszWildCard) {
	return static_cast<int>(SendMessage(LB_DIR, attr, reinterpret_cast<LPARAM>(lpszWildCard)));
}

inline int CListBox::FindString(int nStartAfter, const TCHAR* lpszItem) const {
	return static_cast<int>
		(UNCONST_THIS->SendMessage(LB_FINDSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszItem)));
}

inline int CListBox::FindStringExact(int nStartAfter, const TCHAR* lpszItem) const {
	return static_cast<int>
		(UNCONST_THIS->SendMessage(LB_FINDSTRINGEXACT, nStartAfter, reinterpret_cast<LPARAM>(lpszItem)));
}

inline int CListBox::SelectString(int nStartAfter, const TCHAR* lpszItem) {
	return static_cast<int>(SendMessage(LB_SELECTSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszItem)));
}

#undef UNCONST_THIS

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _LIST_BOX_H_ */

/* [EOF] */