// OleTypeWrapper.h
// (c) 2002-2004 exeal

#ifndef _OLE_TYPE_WRAPPER_H_
#define _OLE_TYPE_WRAPPER_H_

#include "ComBasic.h"


namespace Armaiti {
namespace OLE {

// CComBSTR class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// BSTR ̃bp
/// @see	comutil.h  _bstr_t NX
class CComBSTR {
	// RXgN^
public:
	///	RXgN^
	/// OLE 񂩂珉B
	explicit CComBSTR(const OLECHAR* psz = 0) : m_bstr(::SysAllocString(psz)) {
	}
	///	RXgN^B
	///	ANSI 񂩂珉
	explicit CComBSTR(const char* psz) {
		if(psz != 0) {
			int			cch = ::MultiByteToWideChar(CP_ACP, 0, psz, -1, 0, 0);
			wchar_t*	pwsz = new wchar_t[cch + 1];
			::MultiByteToWideChar(CP_ACP, 0, psz, -1, pwsz, cch);
			m_bstr = ::SysAllocString(pwsz);
			delete[] pwsz;
		} else
			m_bstr = 0;
	}
	///	RXgN^B
	///	ɕϊ\ VARIANT 珉
	explicit CComBSTR(const VARIANT& var) {
		if(var.vt == VT_BSTR)
			m_bstr = ::SysAllocString(var.bstrVal);
		else {
			VARIANT	var_;
			::VariantChangeType(&var_, const_cast<VARIANT*>(&var), 0, VT_BSTR);
			m_bstr = ::SysAllocString(var_.bstrVal);
			::SysFreeString(var_.bstrVal);
		}
	}
	/// Rs[RXgN^
	explicit CComBSTR(const CComBSTR& rhs) {
		m_bstr = ::SysAllocString(rhs.m_bstr);
	}
	/// fXgN^
	~CComBSTR() {
		if(m_bstr != 0)
			::SysFreeString(m_bstr);
	}

	// Zq
public:
	/// Zq
	bool	operator	==(const CComBSTR& rhs) const {
		return wcscmp(_SafeString(m_bstr), _SafeString(rhs.m_bstr)) == 0;
	}
	///	񓙉Zq
	bool	operator	!=(const CComBSTR& rhs) const {
		return !operator ==(rhs);
	}
	/// QƉZq
	BSTR*	operator	&() {
		if(m_bstr != 0)
			::SysFreeString(m_bstr);
		return &m_bstr;
	}
	friend bool	operator ==(const CComBSTR& lhs, const OLECHAR* rhs);
	friend bool	operator !=(const CComBSTR& lhs, const OLECHAR* rhs);

	// \bh
public:
	/// BSTR Ԃ
	const BSTR	GetBSTR() const {
		return m_bstr;
	}
	/// 󕶎񂩂ǂԂ
	bool IsEmpty() const {
		return m_bstr == 0 || wcslen(m_bstr) == 0;
	}
	/// ̒Ԃ
	size_t	Length() const {
		return (m_bstr != 0) ? wcslen(m_bstr) : 0;
	}
protected:
	static OLECHAR*	_SafeString(BSTR bstr) {
		return (bstr != 0) ? bstr : OLESTR("");
	}

	// f[^o
private:
	BSTR	m_bstr;
};

/// CComBSTR ̓Zq
inline bool operator ==(const CComBSTR& lhs, const OLECHAR* rhs) {
	assert(rhs != 0);
	return wcscmp(CComBSTR::_SafeString(lhs.m_bstr), rhs) == 0;
}

/// CComBSTR ̔񓙉Zq
inline bool operator !=(const CComBSTR& lhs, const OLECHAR* rhs) {
	return !operator ==(lhs, rhs);
}


// CComVariant class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// VARIANT AVARIANTARG ̃bp
/// @see	comutil.h  _variant_t NX
class CComVariant : public tagVARIANT {
	// RXgN^
public:
	CComVariant() {
		vt = VT_EMPTY;
	}
	CComVariant(const CComVariant& var) {
		vt = VT_EMPTY;
		Copy(&var);
	}
	CComVariant(const tagVARIANT& var) {
		vt = VT_EMPTY;
		Copy(&var);
	}
	CComVariant(const OLECHAR* psz) {
		vt = VT_EMPTY;
		*this = psz;
	}
	CComVariant(const BSTR bstr) {
		vt = VT_EMPTY;
		*this = bstr;
	}
	CComVariant(bool b) {
		vt = VT_BOOL;
		boolVal = b ? VARIANT_TRUE : VARIANT_FALSE;
	}
	CComVariant(int n) {
		vt = VT_I4;
		lVal = n;
	}
	CComVariant(unsigned int n) {
		vt = VT_UI4;
		ulVal = n;
	}
	CComVariant(BYTE bt) {
		vt = VT_UI1;
		bVal = bt;
	}
	CComVariant(short n) {
		vt = VT_I2;
		iVal = n;
	}
	CComVariant(unsigned short n) {
		vt = VT_UI2;
		uiVal = n;
	}
	CComVariant(long n, VARTYPE vtSrc = VT_I4) {
		assert(vtSrc == VT_I4 || vtSrc == VT_EMPTY);
		vt = vtSrc;
		lVal = n;
	}
	CComVariant(unsigned long n) {
		vt = VT_UI4;
		ulVal = n;
	}
	CComVariant(float n) {
		vt = VT_R4;
		fltVal = n;
	}
	CComVariant(double n) {
		vt = VT_R8;
		dblVal = n;
	}
	CComVariant(CY cy) {
		vt = VT_CY;
		cyVal.Hi = cy.Hi;
		cyVal.Lo = cy.Lo;
	}
	CComVariant(const IDispatch* pDisp) {
		vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(pDisp);
		if(pdispVal != 0)
			pdispVal->AddRef();
	}
	CComVariant(const IUnknown* pUnk) {
		vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(pUnk);
		if(punkVal != 0)
			punkVal->AddRef();
	}
	virtual ~CComVariant() {
		Clear();
	}

	// \bh
public:
	///	A^b`
	HRESULT Attach(const VARIANT* pVar) {
		HRESULT hr = Clear();
		if(SUCCEEDED(hr)) {
			memcpy(this, pVar, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}

	///	^ύX
	HRESULT ChangeType(VARTYPE vt, const VARIANT* pSrc = 0) {
		return ::VariantChangeType(this, (pSrc == 0) ? this : const_cast<VARIANT*>(pSrc), 0, vt);
	}

	///	
	HRESULT Clear() {
		return ::VariantClear(this);
	}

	///	Rs[
	HRESULT Copy(const VARIANT* pSrc) {
		HRESULT hr = ::VariantCopy(this, const_cast<VARIANT*>(pSrc));
		if(FAILED(hr))
			vt = VT_ERROR, scode = hr;
		return hr;
	}

	///	f^b`
	HRESULT Detach(VARIANT* pVar) {
		HRESULT hr = ::VariantClear(pVar);
		if(SUCCEEDED(hr)) {
			memcpy(pVar, this, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}

/*	HRESULT ReadFromStream(IStream* pStream) {
		return E_NOTIMPL;
	}

	HRESULT WriteToStream(IStream* pStream) {
		return E_NOTIMPL;
	}
*/
	// Zq
public:
	CComVariant& operator =(const CComVariant& var) {
		Copy(&var);
		return *this;
	}
	CComVariant& operator =(const tagVARIANT& var) {
		Copy(&var);
		return *this;
	}
	CComVariant& operator =(const OLECHAR* psz) {
		Clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(psz);
		if(bstrVal == 0 && psz != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	CComVariant& operator =(const BSTR bstr) {
		Clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(bstr);
		if(bstrVal == 0 && bstr != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	CComVariant& operator =(bool b) {
		if(vt != VT_BOOL)
			Clear(), vt = VT_BOOL;
		boolVal = b ? VARIANT_TRUE : VARIANT_FALSE;
		return *this;
	}
	CComVariant& operator =(int n) {
		if(vt != VT_I4)
			Clear(), vt = VT_I4;
		lVal = n;
		return *this;
	}
	CComVariant& operator =(BYTE bt) {
		if(vt != VT_UI1)
			Clear(), vt = VT_UI1;
		bVal = bt;
		return *this;
	}
	CComVariant& operator =(short n) {
		if(vt != VT_I2)
			Clear(), vt = VT_I2;
		iVal = n;
		return *this;
	}
	CComVariant& operator =(long n) {
		if(vt != VT_I4)
			Clear(), vt = VT_I4;
		lVal = n;
		return *this;
	}
	CComVariant& operator =(float n) {
		if(vt != VT_R4)
			Clear(), vt = VT_R4;
		fltVal = n;
		return *this;
	}
	CComVariant& operator =(double n) {
		if(vt != VT_R8)
			Clear(), vt = VT_R8;
		dblVal = n;
		return *this;
	}
	CComVariant& operator =(CY cy) {
		if(vt != VT_CY)
			Clear(), vt = VT_CY;
		cyVal.Hi = cy.Hi;
		cyVal.Lo = cy.Lo;
		return *this;
	}
	CComVariant& operator =(const IDispatch* pDisp) {
		Clear(), vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(pDisp);
		if(pdispVal != 0)
			pdispVal->AddRef();
		return *this;
	}
	CComVariant& operator =(const IUnknown* pUnk) {
		Clear(), vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(pUnk);
		if(punkVal != 0)
			punkVal->AddRef();
		return *this;
	}
	bool operator ==(const VARIANT& var) const {
		if(this == &var)
			return true;
		if(vt != var.vt)
			return false;
		switch(vt) {
		case VT_EMPTY:		return true;
		case VT_NULL:		return true;
		case VT_I2:			return iVal == var.iVal;
		case VT_I4:			return lVal == var.lVal;
		case VT_R4:			return fltVal == var.fltVal;
		case VT_R8:			return dblVal == var.dblVal;
		case VT_CY:			return memcmp(&cyVal, &var.cyVal, sizeof(CY)) == 0;
		case VT_DATE:		return date == var.date;
		case VT_BSTR:		return (::SysStringByteLen(bstrVal) == ::SysStringByteLen(var.bstrVal))
									&& (memcmp(bstrVal, var.bstrVal, ::SysStringByteLen(bstrVal)) == 0);
		case VT_DISPATCH:	return pdispVal == var.pdispVal;
		case VT_ERROR:		return scode == var.scode;
		case VT_BOOL:		return boolVal == var.boolVal;
		case VT_VARIANT:	return pvarVal == var.pvarVal;
		case VT_UNKNOWN:	return punkVal == var.punkVal;
		case VT_DECIMAL:	return memcmp(&decVal, &var.decVal, sizeof(DECIMAL)) == 0;
//		case VT_I1:			return cVal == var.cVal;
//		case VT_UI1:		return ;
		case VT_UI2:		return uiVal == var.uiVal;
		case VT_UI4:		return ulVal == var.ulVal;
//		case VT_I8:			return ;
//		case VT_UI8:		return ;
		case VT_INT:		return intVal == var.intVal;
		case VT_UINT:		return uintVal == var.uintVal;
		case VT_VOID:		return true;
		}
		return false;
	}
	bool operator !=(const VARIANT& var) const {
		return operator==(var);
	}
//	bool operator <(const VARIANT& var) {	// ??? comparison of VARIANT is not available now.
//		return (::VarCmp(this, const_cast<VARIANT*>(&var), LOCALE_USER_DEFAULT) == VARCMP_LT);
//	}
//	bool operator >(const VARIANT& var) {
//		return (::VarCmp(this, const_cast<VARIANT*>(&var), LOCALE_USER_DEFAULT) == VARCMP_GT);
//	}
	operator bool() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_BOOL);
		return (varDest.boolVal != 0);
	}
	operator BYTE() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_UI1);
		return varDest.bVal;
	}
	operator short() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I2);
		return varDest.iVal;
	}
	operator int() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I4);
		return varDest.lVal;
	}
	operator long() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I4);
		return varDest.lVal;
	}
	operator float() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_R4);
		return varDest.fltVal;
	}
	operator double() const {	// DATE
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_R8);
		return varDest.dblVal;
	}
	operator CY() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_CY);
		return varDest.cyVal;
	}
/*	operator CComBSTR() const {	// BSTR
		CComBSTR	str;
		VARIANT		varDest;
		wchar_t		wszDump[22];

		varDest.vt = VT_BSTR;
		if(vt == VT_BSTR)
			str = bstrVal;
		else if(vt == VT_UNKNOWN) {
			swprintf(wszDump, L"[IUnknown*]$0x%08lX", reinterpret_cast<long>(punkVal));
			str = wszDump;
		} else if(vt == VT_DISPATCH) {
			swprintf(wszDump, L"[IDispatch*]$0x%08lX", reinterpret_cast<long>(pdispVal));
			str = wszDump;
		} else {	// numeric compatible
			varDest.bstrVal = ::SysAllocStringLen(0, 100);
			::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_BSTR);
			str = varDest.bstrVal;
			::SysFreeString(varDest.bstrVal);
		}

		return str;
	}
*/	operator IDispatch*() const {
		return (vt == VT_DISPATCH) ? pdispVal : 0;
	}
	operator IUnknown*() const {
		if(vt == VT_UNKNOWN)
			return punkVal;
		else if(vt == VT_DISPATCH)
			return static_cast<IUnknown*>(pdispVal);
		else
			return 0;
	}
};

} // namespace OLE
} // namespace Armaiti

#endif /* _OLE_TYPE_WRAPPER_H_ */

/* [EOF] */