// ScriptMacroManager.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "ScriptMacroManager.h"
#include "Alpha.h"				// CAlphaApp
#include "AlphaScriptHost.h"	// CAlphaScriptHost
#include "Ambient.h"			// CApplication
#include "SelectLanguageDlg.h"
#include "Ascension/Encodings/Encoder.h"
//#include <winable.h>	// BlockInput
using namespace Alpha;
using namespace Manah;
using namespace Manah::Text;
using namespace Armaiti;
using namespace Ascension::Encodings;
using namespace std;
using namespace MSXML2;


namespace {
	struct TScriptStartupInfo {
		CScriptMacroManager*	pThis;
		wchar_t*				pwszSource;
		vector<wstring>			arguments;
		CAlphaApp*				pApplication;
		wstring					strLanguageName;
		wstring					strScriptPath;
		bool					bFailedToLoadEngine;
		HANDLE					hInitializeEvent;
		CSelectLanguageDlg		selectLanguageDialog;
	};
}


// Alpha ł wchar_t gݍ݌^ƂĎgĂ邪AƂ
// MSXML SAX C^[tFCX͕|C^Ƃ unsigned short* gB
// ̂߃LXgKvɂȂ
#define WC2US(__pwsz)	reinterpret_cast<unsigned short*>(__pwsz)
#define US2WC(__pus)	reinterpret_cast<wchar_t*>(__pus)


// CScriptMacroManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CScriptMacroManager::CScriptMacroManager(CAlphaApp& app)
		: m_app(app), m_bExecuting(false), m_ppMacros(0), m_cMacros(0) {
	m_saxHandler.m_pThis = this;
}

///	fXgN^
CScriptMacroManager::~CScriptMacroManager() {
	if(m_ppMacros != 0) {
		for(size_t i = 0; i < m_cMacros; ++i)
			delete m_ppMacros[i];
		delete[] m_ppMacros;
	}
}

/**
 *	vOCs
 *	@param i					vOC̔ԍ
 *	@param args					XNvgɓn
 *	@throw std::out_of_range	<var>i</var> ȂƂX[
 *	@throw EFailedToOpenScript	XNvgt@CJȂꍇX[
 *	@throw EInvalidLanguage		ꖼȂꍇX[
 */
void CScriptMacroManager::Execute(size_t i, const vector<wstring>& args)
		throw(out_of_range, EFailedToOpenScript, EInvalidLanguage) {
	using namespace Manah::Windows::IO;

	if(i >= m_cMacros)
		throw out_of_range("Invalid index.");

	const TMacroInfo*	pInfo = m_ppMacros[i];
	wchar_t*			pwszSource = 0;
	wchar_t				wszFilePath[MAX_PATH];
	CFile				scriptFile;
	DWORD				dwFileSize;
	wchar_t*			pwszTitle;
	CEncoder*			pEncoder;
	char*				pszSource;

	wcscpy(wszFilePath, m_strFilePath.c_str());
	pwszTitle = wcsrchr(wszFilePath, L'\\');
	wcscpy(pwszTitle + 1, pInfo->strScriptPath.c_str());
	if(!toBoolean(::PathFileExistsW(wszFilePath)))
		throw EFailedToOpenScript(wszFilePath);
	try {
		scriptFile.Open(wszFilePath, CFile::modeRead | CFile::shareDenyNone);
	} catch(CFileException& /* e */) {
		throw EFailedToOpenScript(wszFilePath);
	}
	pEncoder = CEncoderFactory::GetInstance().CreateEncoder(CP_UTF8);	// XNvg UTF-8
	dwFileSize = scriptFile.GetFileSize(0);
	pszSource = new char[dwFileSize];
	dwFileSize = scriptFile.Read(pszSource, dwFileSize);
	scriptFile.Close();
	pwszSource = new wchar_t[dwFileSize + 1];
	dwFileSize = pEncoder->ConvertToUnicode(pwszSource, dwFileSize, pszSource, dwFileSize);
	delete pEncoder;
	*(pwszSource + dwFileSize) = 0;
	delete[] pszSource;

	TScriptStartupInfo*	pStartupInfo = new TScriptStartupInfo;
	pStartupInfo->pThis = this;
	pStartupInfo->pwszSource = pwszSource;
	pStartupInfo->arguments = args;
	pStartupInfo->pApplication = &m_app;
	pStartupInfo->bFailedToLoadEngine = false;
	pStartupInfo->strLanguageName = pInfo->strLanguage;
	pStartupInfo->strScriptPath = wszFilePath;
	pStartupInfo->hInitializeEvent = ::CreateEventW(0, false, false, 0);
	pStartupInfo->selectLanguageDialog.Create(::GetModuleHandle(0),
		IDD_DLG_SELECTLANGUAGE, m_app.GetMainWindow()->GetSafeHwnd());
	m_bExecuting = true;
	if(-1L == ::_beginthread(CScriptMacroManager::ScriptThreadProc, 0, pStartupInfo)) {
		delete pStartupInfo;
		delete[] pwszSource;
		return;
	}
	::WaitForSingleObject(pStartupInfo->hInitializeEvent, INFINITE);
	if(pStartupInfo->bFailedToLoadEngine)	// XNvgGW[hłȂ
		throw EInvalidLanguage(pInfo->strLanguage);
}

///	vOČԂ
size_t CScriptMacroManager::GetCount() const {
	return m_cMacros;
}

/**
 *	vOC̐Ԃ
 *	@param i			vOC̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
wstring CScriptMacroManager::GetDescription(size_t i) const throw(out_of_range) {
	if(i >= m_cMacros)
		throw out_of_range("Specified plugin not found.");
	return m_ppMacros[i]->strDescription;
}

/**
 *	vOC̖OԂ
 *	@param i			vOC̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
wstring CScriptMacroManager::GetName(size_t i) const throw(out_of_range) {
	if(i >= m_cMacros)
		throw out_of_range("Specified plugin not found.");
	return m_ppMacros[i]->strName;
}

/**
 *	t@C}N[h
 *	@param pwszFilePath	XNvgt@C
 *	@return				
 */
bool CScriptMacroManager::Load(const wchar_t* pwszFilePath) throw(EFailedToParseXml) {
	assert(pwszFilePath != 0);

	CComPtr<ISAXXMLReader>	pXMLReader;
	HRESULT					hr;

	if(m_ppMacros != 0) {
		for(size_t i = 0; i < m_cMacros; ++i)
			delete m_ppMacros;
		delete[] m_ppMacros;
		m_ppMacros = 0;
	}

	m_strFilePath = pwszFilePath;
	hr = ::CoCreateInstance(__uuidof(SAXXMLReader), 0,
		CLSCTX_ALL, __uuidof(ISAXXMLReader), reinterpret_cast<void**>(&pXMLReader));
	if(SUCCEEDED(hr)) {
		pXMLReader->putContentHandler(&m_saxHandler);
		pXMLReader->putErrorHandler(&m_saxHandler);
		hr = pXMLReader->parseURL(WC2US(const_cast<wchar_t*>(pwszFilePath)));
		if(FAILED(hr))
			return false;
	} else
		throw EFailedToParseXml();

	return true;
}

namespace {
//	struct _InputBlocker {
//		_InputBlocker() {::BlockInput(true);}
//		~_InputBlocker() {::BlockInput(false);}
//	};
	struct _InputBlocker {
		_InputBlocker(CAlphaApp& app) : m_app(app) {
			CDocumentManager&	documents = m_app.GetDocumentManager();
			for(size_t i = 0; i < documents.GetCount(); ++i)
				::EnableWindow(documents.GetDocument(i)->GetWindow(), false);
		}
		~_InputBlocker() {
			CDocumentManager&	documents = m_app.GetDocumentManager();
			for(size_t i = 0; i < documents.GetCount(); ++i)
				::EnableWindow(documents.GetDocument(i)->GetWindow(), true);
		}
		CAlphaApp&	m_app;
	};
}

void __cdecl CScriptMacroManager::ScriptThreadProc(void* p) {
	TScriptStartupInfo* const		pInfo = static_cast<TScriptStartupInfo*>(p);
	CLSID							clsidLanguageEngine;
	CComPtr<IActiveScript>			pScriptEngine;			// XNvgGW
	CComPtr<IActiveScriptParse>		pScriptParser;			// p[T
	CComPtr<CAlphaScriptHost>		pScriptHost;			// XNvgzXg
	CComPtr<Ambient::CScriptHost>	pAutomationScriptHost;	// ActiveX 
	CComPtr<Ambient::CApplication>	pApplication;			// ŏʃIuWFNg
	long							nResult = 0;
	HRESULT							hr;

	::CoInitializeEx(0, COINIT_APARTMENTTHREADED);	// STA ɓ
	pInfo->pApplication->GetAutomation(&pApplication, 0);

	auto_ptr<_InputBlocker>	inputBlocker;

	// ꖼXNvgGW[h
	wstring	strLanguage = pInfo->strLanguageName;
	if(strLanguage.empty()) {
		pInfo->pApplication->GetScriptLanguageByFileName(pInfo->strScriptPath.c_str(), clsidLanguageEngine);
		if(clsidLanguageEngine == IID_NULL)
			CAlphaScriptHost::FindScriptEngine(pInfo->strScriptPath.c_str(), clsidLanguageEngine);
		if(clsidLanguageEngine == IID_NULL) {
			if(pInfo->selectLanguageDialog.DoModal() != IDOK)
				goto EndThread;
			strLanguage = pInfo->selectLanguageDialog.GetSelectedLanguage();
			if(FAILED(::CLSIDFromProgID(strLanguage.c_str(), &clsidLanguageEngine))) {
				pInfo->bFailedToLoadEngine = true;
				::SetEvent(pInfo->hInitializeEvent);
				goto EndThread;
			}
		}
	} else if(FAILED(::CLSIDFromProgID(strLanguage.c_str(), &clsidLanguageEngine))) {
		pInfo->bFailedToLoadEngine = true;
		::SetEvent(pInfo->hInitializeEvent);
		goto EndThread;
	}
	if(FAILED(pScriptEngine.CreateInstance(clsidLanguageEngine, 0, CLSCTX_INPROC))) {
		pInfo->bFailedToLoadEngine = true;
		::SetEvent(pInfo->hInitializeEvent);
		goto EndThread;
	}

	::SetEvent(pInfo->hInitializeEvent);
	inputBlocker.reset(new _InputBlocker(*pInfo->pApplication));

	// XNvgs̏
	pScriptHost = new CAlphaScriptHost(pInfo->pThis->m_app.GetMainWindow()->GetSafeHwnd(), pScriptEngine, true);
	pAutomationScriptHost = new Ambient::CScriptHost(pScriptHost);
	pScriptHost->SetScriptPath(pInfo->strScriptPath.c_str());
	pScriptHost->SetSecurityLevel(true,
		static_cast<ScriptSiteSecurityLevel>(
		pInfo->pThis->m_app.GetProfileInt(L"Script", L"securityLevelForSafeObject", 0)));
	pScriptHost->SetSecurityLevel(false,
		static_cast<ScriptSiteSecurityLevel>(
		pInfo->pThis->m_app.GetProfileInt(L"Script", L"securityLevelForUnsafeObject", 1)));
	hr = pScriptEngine->SetScriptSite(pScriptHost);

	pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pScriptParser));
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = pScriptParser->InitNew();

	const DWORD	dwItemTraits = SCRIPTITEM_ISPERSISTENT | SCRIPTITEM_ISVISIBLE;
	pScriptHost->AddTopLevelObject(OLESTR("Ambient"), pApplication, dwItemTraits | SCRIPTITEM_GLOBALMEMBERS);
	pScriptHost->AddTopLevelObject(OLESTR("WScript"), pAutomationScriptHost, dwItemTraits);
	pScriptHost->AddTopLevelObject(OLESTR("WSH"), pAutomationScriptHost, dwItemTraits);

	// ̃x瓦邽߂̃ubN
	{
		set<pair<wstring, CEnumImpl*> >	enums;
		pApplication->GetEnumerations(enums);
		for(set<pair<wstring, CEnumImpl*> >::iterator it = enums.begin(); it != enums.end(); ++it) {
			pScriptHost->AddTopLevelObject(it->first.c_str(), it->second, dwItemTraits);
			it->second->Release();
		}
	}

	// s
	EXCEPINFO	exception;
	ZeroMemory(&exception, sizeof(EXCEPINFO));
	hr = pScriptParser->ParseScriptText(pInfo->pwszSource,
		0, 0, 0, 0UL, 0UL, SCRIPTTEXT_ISPERSISTENT | SCRIPTTEXT_ISVISIBLE, 0, &exception);
	if(SUCCEEDED(hr)) {
		CComPtr<IDispatch>	pTopLevel;
		hr = pScriptEngine->SetScriptState(SCRIPTSTATE_STARTED);
		hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);
		if(SUCCEEDED(pScriptEngine->GetScriptDispatch(0, &pTopLevel))) {
			DISPID		dispid;
			OLECHAR*	pwszRoutineName = OLESTR("main");

			hr = pTopLevel->GetIDsOfNames(IID_NULL, &pwszRoutineName, 1, LOCALE_USER_DEFAULT, &dispid);
			if(SUCCEEDED(hr)) {
				DISPPARAMS	params;
				VARIANT		result;
				VARIANTARG	arguments;
				UINT		iArgErr;

				::VariantInit(&result);
				::VariantInit(&arguments);
				arguments.vt = VT_DISPATCH;
				arguments.pdispVal = new Ambient::CArguments(pInfo->arguments);
				arguments.pdispVal->AddRef();
				params.cArgs = 1;
				params.cNamedArgs = 0;
				params.rgdispidNamedArgs = 0;
				params.rgvarg = &arguments;
				hr = pTopLevel->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT,
					DISPATCH_METHOD, &params, &result, &exception, &iArgErr);
				arguments.pdispVal->Release();

				::VariantChangeType(&result, &result, 0, VT_I4);
				nResult = result.lVal;
				::VariantClear(&result);
			}
		}
	}

	// n
EndThread:
	// HaskellScript ̏ꍇAp[goĂGW (ƃp[T)  Release Ɣ
	pScriptParser = 0;
	if(pScriptEngine != 0) {
		pScriptEngine->Close();
		pScriptEngine = 0;
	}

	pInfo->pThis->m_bExecuting = false;
	pInfo->pApplication->GetMainWindow()->SendMessage(WM_ENDSCRIPTMACRO);
	delete[] pInfo->pwszSource;
	delete pInfo;
	::CoUninitialize();
}


// CSAXReadHandler class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	ISAXContentHandler::characters
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::characters(unsigned short* pwchChars, int cchChars) {
	if(m_nReadingPhase == 1)	// <description>
		m_works.begin()->strDescription.append(US2WC(pwchChars), cchChars);
	return S_OK;
}

///	@see	ISAXContentHandler::endDocument
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endDocument() {
	assert(m_pThis->m_ppMacros == 0);
	m_pThis->m_cMacros = m_works.size();
	if(m_works.empty())
		return S_OK;

	m_pThis->m_ppMacros = new TMacroInfo*[m_pThis->m_cMacros];

	TMacroInfo**	pp = m_pThis->m_ppMacros;
	for(list<TMacroInfo>::reverse_iterator it = m_works.rbegin(); it != m_works.rend(); ++it, ++pp)
		*pp = new TMacroInfo(*it);
	m_works.clear();
	return S_OK;
}

///	@see	ISAXContentHandler::endElement
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endElement(unsigned short* pwchNamespaceUri,
		int cchNamespaceUri, unsigned short* pwchLocalName, int cchLocalName, unsigned short* pwchQName, int cchQName) {
	if(wcsncmp(US2WC(pwchLocalName), L"description", cchLocalName) == 0
			|| wcsncmp(US2WC(pwchLocalName), L"script", cchLocalName) == 0)
		m_nReadingPhase = 0;
	return S_OK;
}

///	@see	ISAXContentHandler::endPrefixMapping
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endPrefixMapping(unsigned short* pwchPrefix, int cchPrefix) {
	return S_OK;
}

///	@see	ISAXErrorHandler::error
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::error(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	ss;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	ss << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pThis->m_app.GetMainWindow()->MessageBox(L"Alpha", ss.str().c_str(), MB_ICONEXCLAMATION);
	return S_OK;
}

///	@see	ISAXErrorHandler::fatalError
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::fatalError(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	ss;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	ss << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pThis->m_app.GetMainWindow()->MessageBox(L"Alpha", ss.str().c_str(), MB_ICONEXCLAMATION);
	return S_OK;
}

///	@see	ISAXErrorHandler::ignorableWarning
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::ignorableWarning(
		ISAXLocator* pLocator, unsigned short* pwchErrorMessage, HRESULT hrErrorCode) {
	return S_OK;
}

///	@see	ISAXContentHandler::ignorableWhitespace
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::ignorableWhitespace(unsigned short* pwchChars, int cchChars) {
	return S_OK;
}

///	@see	ISAXContentHandler::processingInstruction
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::processingInstruction(
		unsigned short* pwchTarget, int cchTarget, unsigned short* pwchData, int cchData) {
	return S_OK;
}

///	@see	ISAXContentHandler::putDocumentLocator
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::putDocumentLocator(ISAXLocator* pLocator) {
	return S_OK;
}

///	@see	ISAXContentHandler::skippedEntity
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::skippedEntity(unsigned short* pwchName, int cchName) {
	return S_OK;
}

///	@see	ISAXContentHandler::startDocument
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startDocument() {
	return S_OK;
}

///	@see	ISAXContentHandler::startElement
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startElement(
		unsigned short* pwchNamespaceUri, int cchNamespaceUri,
		unsigned short* pwchLocalName, int cchLocalName,
		unsigned short* pwchQName, int cchQName, ISAXAttributes* pAttributes) {
	wchar_t*	pwszValue = 0;
	int			cchValue;
		
	if(wcsncmp(US2WC(pwchLocalName), L"macro", cchLocalName) == 0) {	// macro vf name 擾
		m_nReadingPhase = 0;
		TMacroInfo	pi;
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"name"), 4, reinterpret_cast<unsigned short**>(&pwszValue), &cchValue)))
			pi.strName.assign(pwszValue, cchValue);
		m_works.push_front(pi);
	} else if(wcsncmp(US2WC(pwchLocalName), L"script", cchLocalName) == 0) {	// script vf language Asrc 擾
		m_nReadingPhase = 2;
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"language"), 8, reinterpret_cast<unsigned short**>(&pwszValue), &cchValue)))
			m_works.begin()->strLanguage.assign(pwszValue, cchValue);
		if(SUCCEEDED(pAttributes->getValueFromName(WC2US(L""), 0,
				WC2US(L"src"), 3, reinterpret_cast<unsigned short**>(&pwszValue), &cchValue))) {
			wstring&	str = m_works.begin()->strScriptPath;
			str.assign(pwszValue, cchValue);
			// XbVobNXbVɕύXĂ
			for(int i = 0; i < cchValue; ++i) {
				if(str[i] == L'/')
					str[i] = L'\\';
			}
		}
	} else if(wcsncmp(US2WC(pwchLocalName), L"description", cchLocalName) == 0)
		m_nReadingPhase = 1;
	return S_OK;
}

///	@see	ISAXContentHandler::startPrefixMapping
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startPrefixMapping(
		unsigned short* pwchPrefix, int cchPrefix, unsigned short* pwchUri, int cchUri) {
	return S_OK;
}

#undef WC2US
#undef US2WC

/* [EOF] */