// OutputWnd.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "OutputWnd.h"
using Alpha::COutputWnd;
using Alpha::OutputTabType;
using namespace std;


// COutputWnd class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	^u̕
 *	@param tabType		^u
 *	@param bActivate	^uANeBuɂ邩
 */
void COutputWnd::Clear(OutputTabType tabType, bool bActivate /* = true */) {
	AssertValidAsWindow();

	switch(tabType) {
	case OTT_GENERAL:
		::SendMessage(m_hwndGeneralEdit, EM_SETSEL, 0, -1);
		::SendMessage(m_hwndGeneralEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(L""));
		if(bActivate)
			m_wndTab.SetCurSel(0);
		break;
	case OTT_FINDRESULT:
		::SendMessage(m_hwndFindResultListBox, LB_RESETCONTENT, 0, 0L);
		if(bActivate)
			m_wndTab.SetCurSel(1);
		break;
	case OTT_DEBUG:
		::SendMessage(m_hwndDebugEdit, EM_SETSEL, 0, -1);
		::SendMessage(m_hwndDebugEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(L""));
		if(bActivate)
			m_wndTab.SetCurSel(2);
		break;
	}
}

/**
 *	EBhE쐬
 *	@param pParentWindow	eEBhE
 *	@return					
 */
bool COutputWnd::Create(const CWindow* pParentWindow) {
	AssertValid();

	RECT	rect;

	if(!CWindow::CreateEx(true, WS_EX_STATICEDGE,
			L"Static", L"", WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE, 0, 0, 0, 0, pParentWindow->GetSafeHwnd()))
		return false;

	m_hFont = ::CreateFontW(12, 0, 0, 0, FW_NORMAL, false, false, false,
		SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		VARIABLE_PITCH | (FF_SWISS << 4), L"MS UI Gothic");
	::SetRect(&rect, 0, 0, 0, 0);
	m_wndTab.Create(false, WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE
		| TCS_BOTTOM | TCS_BUTTONS | TCS_FLATBUTTONS, rect, m_hWnd, 1);
	m_wndTab.ModifyStyleEx(TCS_EX_FLATSEPARATORS, 0);
	m_wndTab.SetFont(m_hFont);
	m_wndTab.InsertItem(0, L"");
	m_wndTab.InsertItem(1, L"");
	m_wndTab.InsertItem(2, L"fobO");

	m_hwndGeneralEdit = ::CreateWindowExW(WS_EX_CLIENTEDGE, L"Edit", L"",
							WS_CHILD | WS_VISIBLE | WS_VSCROLL | ES_MULTILINE | ES_READONLY,
							0, 0, 0, 0, m_wndTab.GetSafeHwnd(), 0,
							reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE)), 0L);
	::SendMessage(m_hwndGeneralEdit, WM_SETFONT, reinterpret_cast<WPARAM>(m_hFont), 0L);
	m_hwndFindResultListBox = ::CreateWindowExW(WS_EX_CLIENTEDGE, L"ListBox", L"",
							WS_CHILD, 0, 0, 0, 0, m_wndTab.GetSafeHwnd(), 0,
							reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE)), 0L);
	::SendMessage(m_hwndFindResultListBox, WM_SETFONT, reinterpret_cast<WPARAM>(m_hFont), 0L);
	m_hwndDebugEdit = ::CreateWindowExW(WS_EX_CLIENTEDGE, L"Edit", L"",
							WS_CHILD | WS_VSCROLL | ES_MULTILINE | ES_READONLY,
							0, 0, 0, 0, m_wndTab.GetSafeHwnd(), 0,
							reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE)), 0L);
	::SendMessage(m_hwndDebugEdit, WM_SETFONT, reinterpret_cast<WPARAM>(m_hFont), 0L);

	return true;
}

/**
 *	^uɕ
 *	@param tabType		^u
 *	@param strLine		
 *	@param bActivate	^uANeBuɂ邩
 */
void COutputWnd::Write(OutputTabType tabType, const wstring& strLine, bool bActivate /* = true */) {
	AssertValid();

	switch(tabType) {
	case OTT_GENERAL:
		::SendMessage(m_hwndGeneralEdit, EM_SETSEL, -1, -1);
		::SendMessage(m_hwndGeneralEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(strLine.c_str()));
		if(bActivate)
			m_wndTab.SetCurSel(0);
		break;
	case OTT_FINDRESULT:
		::SendMessage(m_hwndFindResultListBox, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(strLine.c_str()));
		if(bActivate)
			m_wndTab.SetCurSel(1);
		break;
	case OTT_DEBUG:
		::SendMessage(m_hwndDebugEdit, EM_SETSEL, -1, -1);
		::SendMessage(m_hwndDebugEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(strLine.c_str()));
		if(bActivate)
			m_wndTab.SetCurSel(2);
		break;
	}
	if(bActivate) {
		NMHDR	hdr = {m_wndTab.GetSafeHwnd(), 0, TCN_SELCHANGE};
		OnNotify(0, &hdr);
	}
}

/**
 *	^uɕ݉s
 *	@param tabType		^u
 *	@param strLine		
 *	@param bActivate	^uANeBuɂ邩
 */
void COutputWnd::WriteLine(OutputTabType tabType, const wstring& strLine, bool bActivate /* = true */) {
	AssertValid();

	Write(tabType, strLine, bActivate);
	switch(tabType) {
	case OTT_GENERAL:
		::SendMessage(m_hwndGeneralEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(L"\r\n"));
		break;
	case OTT_DEBUG:
		::SendMessage(m_hwndDebugEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(L"\r\n"));
		break;
	}
}

///	@see	CWindow::OnDestroy
void COutputWnd::OnDestroy() {
	m_wndTab.DestroyWindow();
	::DeleteObject(m_hFont);
	::DestroyWindow(m_hwndGeneralEdit);
	::DestroyWindow(m_hwndFindResultListBox);
	::DestroyWindow(m_hwndDebugEdit);

	CWindow::OnDestroy();
}

///	@see	CWindow::OnNotify
bool COutputWnd::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(lpNMHDR->code == TCN_SELCHANGE) {	// ^u؂ւ
		int	iActiveTab = m_wndTab.GetCurSel();
		::ShowWindow(m_hwndGeneralEdit, (iActiveTab == 0) ? SW_SHOW : SW_HIDE);
		::ShowWindow(m_hwndFindResultListBox, (iActiveTab == 1) ? SW_SHOW : SW_HIDE);
		::ShowWindow(m_hwndDebugEdit, (iActiveTab == 2) ? SW_SHOW : SW_HIDE);
		return true;
	}
	return CWindow::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CWindow::OnSize
void COutputWnd::OnSize(UINT nType, int cx, int cy) {
	RECT	rectTab;

	m_wndTab.MoveWindow(0, 1, cx + 2, cy - 1);
	m_wndTab.GetItemRect(0, &rectTab);
	cy -= rectTab.bottom - rectTab.top;

	::MoveWindow(m_hwndGeneralEdit, 0, 0, cx, cy - 3, true);
	::MoveWindow(m_hwndFindResultListBox, 0, 0, cx, cy - 3, true);
	::MoveWindow(m_hwndDebugEdit, 0, 0, cx, cy - 3, true);
}


/* [EOF] */