// NewFileFormatDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "NewFileFormatDlg.h"
#include "Alpha.h"
#include "..\Manah\ComboBox.h"
using Alpha::CNewFileFormatDlg;
using Manah::Windows::Controls::CComboBox;
using namespace Ascension::Encodings;


// CNewFileFormatDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnInitDialog
bool CNewFileFormatDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CComboBox		comboBox;
	set<CodePage>	codePages;
	int				iItem;

	// [R[hy[W]
	comboBox.Attach(GetDlgItem(IDC_COMBO_CHARCODE));
	CEncoderFactory::GetInstance().EnumCodePages(codePages);
	for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
		if(CEncoderFactory::GetInstance().IsCodePageForAutoDetection(*it))
			continue;
		if(const wchar_t* pwszCPName = CAlphaApp::GetCodePageName(*it)) {
			iItem = comboBox.AddString((*it == m_nCodePage) ?
				(pwszCPName + wstring(L" *")).c_str() : pwszCPName);
			comboBox.SetItemData(iItem, *it);
			if(*it == m_nCodePage)
				comboBox.SetCurSel(iItem);
		}
	}
	comboBox.Detach();

	// [sR[h]
	comboBox.Attach(GetDlgItem(IDC_COMBO_BREAKCODE));
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_CRLF) ? L"CR+LF (Windows) *" : L"CR+LF (Windows)"), Ascension::BT_CRLF);
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_LF) ? L"LF (Unix) *" : L"LF (Unix)"), Ascension::BT_LF);
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_CR) ? L"CR (Macintosh) *" : L"CR (Macintosh)"), Ascension::BT_CR);
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_NEL) ? L"NEL (U+0085) *" : L"NEL (U+0085)"), Ascension::BT_NEL);
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_LS) ? L"LS (U+2028) *" : L"LS (U+2028)"), Ascension::BT_LS);
	comboBox.SetItemData(comboBox.AddString(
		(m_breakType == Ascension::BT_PS) ? L"PS (U+2029) *" : L"PS (U+2029)"), Ascension::BT_PS);
	for(unsigned short i = 0; i < 6; ++i) {
		if(m_breakType == static_cast<Ascension::BreakType>(comboBox.GetItemData(i))) {
			comboBox.SetCurSel(i);
			break;
		}
	}
	comboBox.Detach();

	// [^Cv]
	comboBox.Attach(GetDlgItem(IDC_COMBO_DOCTYPENAMES));
	for(list<wstring>::const_iterator it =
			m_documentTypes.begin(); it != m_documentTypes.end(); ++it) {
		SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES,
			CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	}
	comboBox.SetCurSel(m_iDocumentType);
	comboBox.Detach();

	return true;
}

///	@see	CDialog::OnOK
void CNewFileFormatDlg::OnOK() {
	m_nCodePage = SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETCURSEL, 0, 0L), 0L);
	m_breakType = static_cast<Ascension::BreakType>(SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETCURSEL, 0, 0L), 0L));
	m_iDocumentType = SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES, CB_GETCURSEL, 0, 0L);

	CDialog::OnOK();
}

/* [EOF] */