// MRUManager.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "MRUManager.h"
#include "Alpha.h"
using Alpha::CMRUManager;
using Alpha::TMRU;
using namespace std;
using Manah::Windows::Controls::CMenu;
using Ascension::Encodings::CodePage;


// CMRUManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CMRUManager::CMRUManager(unsigned short cLimit, int nStartID, bool bOwnerDrawMenu /* = false */)
		: m_pPopupMenu(new CMenu), m_cLimit(cLimit), m_nStartID(nStartID), m_bOwnerDraw(bOwnerDrawMenu) {
	_ReconstructMenu();
}

///	fXgN^
CMRUManager::~CMRUManager() {
	delete m_pPopupMenu;
}

///	<code>m_fileNames</code> 烁j[č\
void CMRUManager::_ReconstructMenu() {
	unsigned short				iItem = 0;
	list<TMRU>::const_iterator	it = m_fileNames.begin();
	wchar_t						szItem[MAX_PATH + 100];

	delete m_pPopupMenu;
	m_pPopupMenu = new CMenu();
	if(m_fileNames.empty()) {	// ̏ꍇ
		m_pPopupMenu->AppendMenuItem(0, MFT_STRING, MFS_GRAYED, L"(Ȃ)");
		return;
	}
	while(it != m_fileNames.end()) {
		swprintf(szItem, L"&%x  %s [%s]", iItem,
			it->strFileName.c_str(), CAlphaApp::GetCodePageName(it->nCodePage));
		m_pPopupMenu->AppendMenuItem(m_nStartID + iItem,
			m_bOwnerDraw ? MFT_OWNERDRAW : MFT_STRING,
			m_bOwnerDraw ? 0 : szItem);
		++it;
		++iItem;
	}
}

/**
 *	ڂǉBɓ̂΂擪ɏo
 *	@param strFilePath	Vǉt@CpX
 *	@param nCodePage	R[hy[W
 */
void CMRUManager::Add(const wstring& strFilePath, CodePage nCodePage) {
	list<TMRU>::iterator	it = m_fileNames.begin();
	wchar_t*				pwsz = new wchar_t[strFilePath.length() + 1];
	wchar_t					wszItem[MAX_PATH];

	// ̂邩T (啶ʂȂBۂ͂ŏ\ł͂Ȃ)
	wcscpy(pwsz, strFilePath.c_str());
	::CharLowerW(pwsz);
	while(it != m_fileNames.end()) {
		wcscpy(wszItem, it->strFileName.c_str());
		::CharLowerW(wszItem);
		if(wcscmp(wszItem, pwsz) == 0) {	//  -> 擪ɏo
			TMRU	item = *it;
			item.nCodePage = nCodePage;
			m_fileNames.erase(it);
			m_fileNames.push_front(item);
			delete[] pwsz;
			_ReconstructMenu();
			return;
		}
		++it;
	}
	delete[] pwsz;

	// 擪ɒǉBl𒴂ꍇ͈ԌÂ̂폜
	TMRU	item = {strFilePath, nCodePage};
	m_fileNames.push_front(item);
	if(m_fileNames.size() > m_cLimit)
		m_fileNames.resize(m_cLimit);
	_ReconstructMenu();
}

///	ڂSč폜
void CMRUManager::Clear() {
	m_fileNames.clear();
	delete m_pPopupMenu;
	m_pPopupMenu = new CMenu();
	_ReconstructMenu();
}

///	Xg̍ڐԂ
unsigned short CMRUManager::GetCount() const {
	return m_fileNames.size();
}

///	w肵ʒũt@CpXԂ
const TMRU& CMRUManager::GetFileInfoAt(unsigned short i) const throw(out_of_range) {
	if(i >= m_fileNames.size())
		throw out_of_range("First argument is out of range!");
	list<TMRU>::const_iterator	it = m_fileNames.begin();
	for(unsigned short j = 0; j < i; ++j)
		++it;
	return *it;
}

///	|bvAbvj[Ԃ
CMenu* CMRUManager::GetPopupMenu() const {
	return m_pPopupMenu;
}

/**
 *	ڂ̍폜
 *	@param i			ڂ̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
void CMRUManager::Remove(unsigned short i) throw(out_of_range) {
	if(i >= m_fileNames.size())
		throw out_of_range("First argument is out of range!");
	list<TMRU>::iterator	it = m_fileNames.begin();
	for(unsigned short j = 0; j < i; ++j)
		++it;
	m_fileNames.erase(it);
	_ReconstructMenu();
}

///	ڐ̏l̐ݒ
void CMRUManager::SetLimit(unsigned short cLimit) {
	CMenu*	pItem = 0;

	if(cLimit < 4)
		cLimit = 4;
	else if(cLimit > 16)
		cLimit = 16;

	// ӂꂽ폜
	if(m_fileNames.size() > cLimit) {
		m_fileNames.resize(cLimit);
		for(unsigned short i = m_fileNames.size() - 1; i > cLimit; --i)
			m_pPopupMenu->RemoveMenuItem(i, false);
	}
}

/* [EOF] */