// KeyboardMap.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "KeyboardMap.h"
#include "../Manah/File.h"
using namespace Alpha;
using namespace std;


///	RXgN^
CKeyboardMap::CKeyboardMap() {
	for(KeyModifier modifiers = 0; modifiers < 8; ++modifiers) {
		for(VirtualKey key = 0; key < 0x0100; ++key) {
			m_firstKeyMaps[modifiers][key].id = 0;
			m_firstKeyMaps[modifiers][key].pp2ndKeyMap = 0;
		}
	}
	Clear();
	m_bDirty = false;
}

///	fXgN^
CKeyboardMap::~CKeyboardMap() {
	Clear();
}

/**
 *	1̃R}ho^
 *	@param id			R}h ID
 *	@param key			zL[
 *	@param modifiers	CL[
 *	@throw out_of_range	<var>key</var> 256ȏ̂ƂX[
 */
void CKeyboardMap::Assign(CommandId id, VirtualKey key, KeyModifier modifiers) throw(out_of_range) {
	if(key >= 0x0100)
		throw out_of_range("The second argument is invalid as virutal key code.");

	T1stKeyMap&	firstKeyMap = m_firstKeyMaps[modifiers][key];
	if(firstKeyMap.pp2ndKeyMap != 0) {
		for(size_t i = 0; i < 8; ++i)
			delete[] firstKeyMap.pp2ndKeyMap[i];
		delete[] firstKeyMap.pp2ndKeyMap;
		firstKeyMap.pp2ndKeyMap = 0;
	}
	firstKeyMap.id = id;
	m_bDirty = true;
}

/**
 *	1̃R}ho^
 *	@param id				R}h ID
 *	@param firstKey			1̉zL[
 *	@param firstModifiers	1̏CL[
 *	@param secondKey		2̉zL[
 *	@param secondModifiers	2̏CL[
 *	@throw out_of_range		<var>firstKey</var> A<var>secondKey</var> ̂ꂩ256ȏ̂ƂX[
 *	@throw runtime_error	1Xg[N͊ƂX[
 */
void CKeyboardMap::Assign(CommandId id, VirtualKey firstKey,
		KeyModifier firstModifiers, VirtualKey secondKey, KeyModifier secondModifiers) throw(out_of_range) {
	if(firstKey >= 0x0100 || secondKey >= 0x0100)
		throw out_of_range("The second or forth argument is invalid as virutal key code.");

	T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstModifiers][firstKey];

	firstKeyMap.id = CMD_SPECIAL_WAITFOR2NDKEYS;
	if(firstKeyMap.pp2ndKeyMap == 0) {
		firstKeyMap.pp2ndKeyMap = new CommandId*[8];
		memset(firstKeyMap.pp2ndKeyMap, 0, sizeof(CommandId*) * 8);
	}
	if(firstKeyMap.pp2ndKeyMap[secondModifiers] == 0) {
		firstKeyMap.pp2ndKeyMap[secondModifiers] = new CommandId[0x0100];
		memset(firstKeyMap.pp2ndKeyMap[secondModifiers], 0, sizeof(CommandId) * 0x0100);
	}
	firstKeyMap.pp2ndKeyMap[secondModifiers][secondKey] = id;
	m_bDirty = true;
}

///	o^Sĉ
void CKeyboardMap::Clear() {
	m_bDirty = true;
	for(KeyModifier modifiers = 0; modifiers < 8; ++modifiers) {
		for(VirtualKey key = 0; key < 0x0100; ++key) {
			T1stKeyMap&	firstKeyMap = m_firstKeyMaps[modifiers][key];
			firstKeyMap.id = 0;
			if(firstKeyMap.pp2ndKeyMap != 0) {
				for(size_t i = 0; i < 8; ++i)
					delete[] firstKeyMap.pp2ndKeyMap[i];
				delete[] firstKeyMap.pp2ndKeyMap;
				firstKeyMap.pp2ndKeyMap = 0;
			}
		}
	}
}

/**
 *	R}hɊ蓖ĂĂL[̕\擾
 *	@param id			R}h ID
 *	@param bShortName	Z𓾂ꍇ true
 *	@return				"Ctrl+N" Ȃǂ̕\Bo^ĂȂ΋󕶎
 */
wstring CKeyboardMap::GetKeyString(CommandId id, bool bShortName) const {
	wstring	str;

	for(KeyModifier firstModifiers = 0; firstModifiers < 8; ++firstModifiers) {
		for(VirtualKey firstKey = 0; firstKey < 0x0100; ++firstKey) {
			const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstModifiers][firstKey];
			if(firstKeyMap.id == id) {	// 1Xg[N
				const wstring	str_ = GetStrokeString(firstKey, firstModifiers, bShortName);
				if(str.empty() || str_.length() < str.length())
					str = str_;
			}
			else if(firstKeyMap.pp2ndKeyMap != 0) {
				for(KeyModifier secondModifiers = 0; secondModifiers < 8; ++secondModifiers) {
					if(firstKeyMap.pp2ndKeyMap[secondModifiers] == 0)
						continue;
					for(VirtualKey secondKey = 0; secondKey < 0x0100; ++secondKey) {
						if(firstKeyMap.pp2ndKeyMap[secondModifiers][secondKey] == id) {	// 2Xg[N
							const wstring	str_ = GetStrokeString(
								firstKey, firstModifiers, secondKey, secondModifiers, bShortName);
							if(str.empty() || str_.length() < str.length())
								str = str_;
						}
					}
				}
			}
		}
	}
	return str;
}

///	@see	ISerializable::Load
bool CKeyboardMap::Load(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	Clear();

	try {
		CFile		file(pwszPathName, CFile::modeRead);
		CommandId	id;
		VirtualKey	firstKey, secondKey;
		KeyModifier	firstModifiers, secondModifiers;

		while(true) {
			if(sizeof(CommandId) != file.Read(&id, sizeof(CommandId)))
				break;
			if(sizeof(VirtualKey) != file.Read(&firstKey, sizeof(VirtualKey)))
				break;
			if(sizeof(KeyModifier) != file.Read(&firstModifiers, sizeof(KeyModifier)))
				break;
			if(id != CMD_SPECIAL_WAITFOR2NDKEYS)
				Assign(id, firstKey, firstModifiers);
			else {
				if(sizeof(CommandId) != file.Read(&id, sizeof(CommandId)))
					break;
				if(sizeof(VirtualKey) != file.Read(&secondKey, sizeof(VirtualKey)))
					break;
				if(sizeof(KeyModifier) != file.Read(&secondModifiers, sizeof(KeyModifier)))
					break;
				Assign(id, firstKey, firstModifiers, secondKey, secondModifiers);
			}
		}
		file.Close();
	} catch(CFileException& /*e*/) {
		return false;
	} catch(out_of_range&) {
		return false;
	}

	m_bDirty = false;
	return true;
}

///	@see	ISerializable::Save
bool CKeyboardMap::Save(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	try {
		CFile	file(pwszPathName, CFile::modeWrite | CFile::modeCreate | CFile::shareExclusive);

		for(KeyModifier firstModifiers = 0; firstModifiers < 8; ++firstModifiers) {
			for(VirtualKey firstKey = 0; firstKey < 0x0100; ++firstKey) {
				const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstModifiers][firstKey];
				if(firstKeyMap.id == 0)	// 蓖ĂĂȂ
					continue;
				else if(firstKeyMap.id != CMD_SPECIAL_WAITFOR2NDKEYS) {	// 1Xg[N
					file.Write(&firstKeyMap.id, sizeof(CommandId));
					file.Write(&firstKey, sizeof(VirtualKey));
					file.Write(&firstModifiers, sizeof(KeyModifier));
				} else {	// 2Xg[N
					assert(firstKeyMap.pp2ndKeyMap != 0);
					for(KeyModifier secondModifiers = 0; secondModifiers < 8; ++secondModifiers) {
						for(VirtualKey secondKey = 0; secondKey < 0x0100; ++secondKey) {
							if(firstKeyMap.pp2ndKeyMap[secondModifiers] == 0
									|| firstKeyMap.pp2ndKeyMap[secondModifiers][secondKey] == 0)
								continue;
							file.Write(&firstKeyMap.id, sizeof(CommandId));
							file.Write(&firstKey, sizeof(VirtualKey));
							file.Write(&firstModifiers, sizeof(KeyModifier));
							file.Write(&firstKeyMap.pp2ndKeyMap[secondModifiers][secondKey], sizeof(CommandId));
							file.Write(&secondKey, sizeof(VirtualKey));
							file.Write(&secondModifiers, sizeof(KeyModifier));
						}
					}
				}
			}
		}
		file.Close();
	} catch(CFileException& /*e*/) {
		return false;
	}

	m_bDirty = false;
	return true;
}

/* [EOF] */