// FindDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "FindDlg.h"
#include "Alpha.h"
#include <algorithm>	// std::find
using Alpha::CAlphaApp;
using Alpha::CFindDlg;
using Alpha::CSearchOptionDlg;
using namespace Ascension;


// CFindDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[V
 */
CFindDlg::CFindDlg(const CAlphaApp& app) : m_app(app) {
}

/**
 *	ɕǉ
 *	@param strText		ǉ镶
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::AddToHistory(const string_t& strText, bool bIsReplace) {
	AssertValid();

	list<string_t>&				target = bIsReplace ? m_replaceWiths : m_findWhats;
	list<string_t>::iterator	it;

	it = find(target.begin(), target.end(), strText);
	if(it != target.end())
		target.erase(it);
	target.push_front(strText);

	if(IsWindow()) {
		UpdateHistory(bIsReplace);
		SendDlgItemMessage(bIsReplace ? IDC_COMBO_REPLACEWITH : IDC_COMBO_FINDWHAT, CB_SETCURSEL, 0, 0L);
	}
}

/**
 *	폜
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::ClearHistory(bool bIsReplace) {
	AssertValid();
	(bIsReplace ? m_replaceWiths : m_findWhats).clear();
	if(IsWindow())
		UpdateHistory(bIsReplace);
}

///	擾
void CFindDlg::GetHistory(list<string_t>& findWhats, list<string_t>& replaceWiths) const {
	AssertValid();
	findWhats = m_findWhats;
	replaceWiths = m_replaceWiths;
}

///	ݒ
void CFindDlg::SetHistory(const list<string_t>& findWhats, const list<string_t>& replaceWiths) {
	AssertValid();

	// d`FbNȂRs[ (sort -> unique_copy ł)
	m_findWhats.clear();
	for(list<string_t>::const_iterator it = findWhats.begin(); it != findWhats.end(); ++it) {
		if(m_findWhats.end() == find(m_findWhats.begin(), m_findWhats.end(), *it))
			m_findWhats.push_back(*it);
	}
	m_replaceWiths.clear();
	for(list<string_t>::const_iterator it = replaceWiths.begin(); it != replaceWiths.end(); ++it) {
		if(m_replaceWiths.end() == find(m_replaceWiths.begin(), m_replaceWiths.end(), *it))
			m_replaceWiths.push_back(*it);
	}

	if(IsWindow()) {
		UpdateHistory(false);
		UpdateHistory(true);
	}
}

/**	
 *	XgR{{bNXɔf
 *	@param	bIsReplace	ûƂ^
 */
void CFindDlg::UpdateHistory(bool bIsReplace) {
	AssertValidAsWindow();

	list<string_t>::const_iterator	it;
	HWND							hwndReplaceWithCombobox = GetDlgItem(IDC_COMBO_REPLACEWITH);

	if(!bIsReplace) {	// []
		SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_RESETCONTENT, 0, 0L);
		for(it = m_findWhats.begin(); it != m_findWhats.end(); ++it)
			SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	} else{	// [u]
		if(::IsWindow(hwndReplaceWithCombobox)) {
			::SendMessage(hwndReplaceWithCombobox, CB_RESETCONTENT, 0, 0L);
			for(it = m_replaceWiths.begin(); it != m_replaceWiths.end(); ++it)
				::SendMessageW(hwndReplaceWithCombobox, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
		}
	}
}

///	̍XV
void CFindDlg::UpdateOptions() {
	AssertValidAsWindow();

	IDocumentContainer*			pActiveContainer = m_app.GetDocumentManager().GetActiveDocument();
	CAlphaEditController*		pActiveEditor;
	CAlphaView*					pActiveView;
	Ascension::TSearchOption	options;

	if(pActiveContainer == 0
			|| 0 == (pActiveEditor = pActiveContainer->GetTextEditor())
			|| 0 == (pActiveView = pActiveEditor->GetActiveView()))
		return;

	options = pActiveView->GetSearchOptions();
//	if(IsDlgButtonChecked(IDC_CHK_ONLYIDENTIFIERS) == BST_CHECKED)
//		options.generalOptions |= SO_ONLY_IDENTIFIERS;
	options.bWholeWord = IsDlgButtonChecked(IDC_CHK_WHOLEWORD) == BST_CHECKED;
	switch(SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_GETCURSEL, 0, 0L)) {
	case 0:	options.type = ST_LITERAL;	break;
	case 1:	options.type= ST_REGEXP;	break;
	case 2:	options.type= ST_MIGEMO;	break;
	}
	switch(SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_GETCURSEL, 0, 0L)) {
	case 0:	options.caseSensitivity = CS_NONE;		break;
	case 1:	options.caseSensitivity = CS_ASCII;		break;
	case 2:	options.caseSensitivity = CS_SIMPLE;	break;
	case 3:	options.caseSensitivity = CS_FULL;		break;
	}
	pActiveView->SetSearchOptions(options);
}

///	@see	CDialog::OnActivate
void CFindDlg::OnActivate(UINT nState, HWND hwndPrevious, bool bMinimize) {
	if(nState == WA_INACTIVE)
		UpdateOptions();
	else if(IDocumentContainer* pContainer = m_app.GetDocumentManager().GetActiveDocument()) {
		if(CAlphaEditController* pEditor = pContainer->GetTextEditor()) {
			CAlphaView*				pView = pEditor->GetActiveView();
			const bool				bHasFindText = ::GetWindowTextLengthW(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0;
			const TSearchOption&	options = pView->GetSearchOptions();

			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bHasFindText);
			::EnableWindow(GetDlgItem(IDC_RADIO_SELECTION), false/*pView->HasSelection()*/);

			CheckDlg2StateButton(IDC_CHK_WHOLEWORD, options.bWholeWord);

			if(options.type == ST_LITERAL)
				SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 0, 0L);
			else if(options.type == ST_REGEXP)
				SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 1, 0L);
			else if(options.type == ST_MIGEMO)
				SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 2, 0L);

			if(options.caseSensitivity == CS_ASCII)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 1, 0L);
			else if(options.caseSensitivity == CS_SIMPLE)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 2, 0L);
			else if(options.caseSensitivity == CS_FULL)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 3, 0L);
			else
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 0, 0L);
			CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);
		}
	}
}

///	@see	CDialog::OnCancel
void CFindDlg::OnCancel() {
	OnClose();
}

///	@see	CDialog::OnClose
void CFindDlg::OnClose() {
	::SendMessageW(GetParent(), WM_COMMAND, CMD_SEARCH_FIND, reinterpret_cast<LPARAM>(this));
//	CDialog::OnClose();
}

///	@see	CDialog::OnCommand
bool CFindDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case CMD_SEARCH_FINDNEXT:		// []
	case CMD_SEARCH_FINDPREV:		// [O]
	case CMD_SEARCH_BOOKMARKALL:	// [ׂă}[N]
	case CMD_SEARCH_REPLACEALL:		// [ׂĒu]
	case CMD_SEARCH_REPLACEANDNEXT:	// [u]
		::SendMessageW(GetParent(), WM_COMMAND,
			MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
		return true;
	case IDC_COMBO_FINDWHAT:
		if(wNotifyCode == CBN_EDITCHANGE || wNotifyCode == CBN_SELCHANGE) {
			const bool	bEnable = (wNotifyCode == CBN_EDITCHANGE) ?
				::GetWindowTextLength(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0 : true;
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bEnable);
		}
		break;
	case IDC_BTN_BROWSE: {	// [gIvV...] {^
		if(CAlphaEditController* pEditor = m_app.GetDocumentManager().GetActiveDocument()->GetTextEditor()) {
			CSearchOptionDlg	dlg(*pEditor->GetActiveView());
			dlg.Create(::GetModuleHandle(0), IDD_DLG_SEARCHOPTIONS, m_hWnd);
			dlg.DoModal();
		}
		}
		break;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFindDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_LIMITTEXT, 255, 0L);
	SendDlgItemMessage(IDC_COMBO_REPLACEWITH, CB_LIMITTEXT, 255, 0L);

	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_LITERALSEARCH).c_str()));
	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_REGEXPSEARCH).c_str()));
	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_MIGEMOSEARCH).c_str()));

	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_MATCHCASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_IGNOREASCIICASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDINGSIMPLE).c_str()));
//	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
//		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDINGFULL).c_str()));

	UpdateHistory(false);
	UpdateHistory(true);
	OnCommand(IDC_COMBO_FINDWHAT, CBN_EDITCHANGE, GetDlgItem(IDC_COMBO_FINDWHAT));

	return true;
}


// CSearchOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param view	ݒr[
 */
CSearchOptionDlg::CSearchOptionDlg(Alpha::CAlphaView& view) : m_view(view) {
}

///	@see	CDialog::OnInitDialog
bool CSearchOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	const TSearchOption&	options = m_view.GetSearchOptions();

#define CHECK_OPTION(id, b)	\
	CheckDlgButton(id, toBoolean(b) ? BST_CHECKED : BST_UNCHECKED)

	CHECK_OPTION(IDC_CHK_IGNORE_SYMBOLS, options.characterSkipOptions & CSO_SYMBOLS);
	CHECK_OPTION(IDC_CHK_IGNORE_CONTROLS, options.characterSkipOptions & CSO_CONTROLS);
	CHECK_OPTION(IDC_CHK_IGNORE_PUNCTUATIONS, options.characterSkipOptions & CSO_PUNCTUATIONS);
	CHECK_OPTION(IDC_CHK_IGNORE_DIACRITICS, options.characterSkipOptions & CSO_DIACRITICS);
	CHECK_OPTION(IDC_CHK_IGNORE_VOWELS, options.characterSkipOptions & CSO_VOWELS);
	CHECK_OPTION(IDC_CHK_IGNORE_KASHIDA, options.characterSkipOptions & CSO_KASHIDA);
	CHECK_OPTION(IDC_CHK_IGNORE_WHITESPACES, options.characterSkipOptions & CSO_WHITESPACES);
	
	CHECK_OPTION(IDC_CHK_IGNORE_WIDTH, options.provisionalFoldingOptions & PFO_WIDTH);
	CHECK_OPTION(IDC_CHK_IGNORE_DIGITTYPE, options.foldingOptions & FO_NATIVE_DIGIT);
//	CHECK_OPTION(IDC_CHK_IGNORE_ALEFHAMZA, SF_IGNORE_ALEFHAMZA);
/*
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_KANATYPE, JFSF_KANATYPE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_YOUONSOKUON, JFSF_YOUON_SOKUON);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDS, JFSF_MINUS_PROLONGEDMARK_DASH);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_REPITATIONS, JFSF_ITERATIONMARK);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_UNSTABLEKANJIS, JFSF_UNUNIFIEDKANJI);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_LEGACYKANAGLYPHS, JFSF_LEGACY_MODERN_KANAFIGURE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDVOWELS, JFSF_PROLONGEDMARK_VOWEL);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_ZIZU, JFSF_DI_JI_DU_ZU);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_BAHA, JFSF_BA_VA_HA_FA);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_TIDI, JFSF_TSI_THI_TI_DHI_JI);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_HYUBYU, JFSF_HYU_FYU_BYU_VYU);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_SEZE, JFSF_SE_SYE_ZE_JE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_AYAFOLLOWINGIE, JFSF_A_YA_FOLLOWING_I_E);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_KIKUFOLLOWEDBYS, JFSF_KI_KU_FOLLOWEDBY_S);
*/
	return true;

#undef CHECK_OPTION
}

///	@see	CDialog::OnOK
void CSearchOptionDlg::OnOK() {
	TSearchOption	options = m_view.GetSearchOptions();

#define GET_OPTION(id, exp)	\
	if(IsDlgButtonChecked(id) == BST_CHECKED)	exp;

	GET_OPTION(IDC_CHK_IGNORE_SYMBOLS, options.characterSkipOptions |= CSO_SYMBOLS);
	GET_OPTION(IDC_CHK_IGNORE_CONTROLS, options.characterSkipOptions |= CSO_CONTROLS);
	GET_OPTION(IDC_CHK_IGNORE_PUNCTUATIONS, options.characterSkipOptions |= CSO_PUNCTUATIONS);
	GET_OPTION(IDC_CHK_IGNORE_DIACRITICS, options.characterSkipOptions |= CSO_DIACRITICS);
	GET_OPTION(IDC_CHK_IGNORE_VOWELS, options.characterSkipOptions |= CSO_VOWELS);
	GET_OPTION(IDC_CHK_IGNORE_KASHIDA, options.characterSkipOptions |= CSO_KASHIDA);
	GET_OPTION(IDC_CHK_IGNORE_WHITESPACES, options.characterSkipOptions |= CSO_WHITESPACES);

	GET_OPTION(IDC_CHK_IGNORE_WIDTH, options.provisionalFoldingOptions |= PFO_WIDTH);
	GET_OPTION(IDC_CHK_IGNORE_DIGITTYPE, options.foldingOptions |= FO_NATIVE_DIGIT);
//	GET_OPTION(IDC_CHK_IGNORE_ALEFHAMZA, SF_IGNORE_ALEFHAMZA);

	m_view.SetSearchOptions(options);
/*
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_KANATYPE, JFSF_KANATYPE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_YOUONSOKUON, JFSF_YOUON_SOKUON);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDS, JFSF_MINUS_PROLONGEDMARK_DASH);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_REPITATIONS, JFSF_ITERATIONMARK);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_UNSTABLEKANJIS, JFSF_UNUNIFIEDKANJI);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_LEGACYKANAGLYPHS, JFSF_LEGACY_MODERN_KANAFIGURE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDVOWELS, JFSF_PROLONGEDMARK_VOWEL);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_ZIZU, JFSF_DI_JI_DU_ZU);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_BAHA, JFSF_BA_VA_HA_FA);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_TIDI, JFSF_TSI_THI_TI_DHI_JI);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_HYUBYU, JFSF_HYU_FYU_BYU_VYU);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_SEZE, JFSF_SE_SYE_ZE_JE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_AYAFOLLOWINGIE, JFSF_A_YA_FOLLOWING_I_E);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_KIKUFOLLOWEDBYS, JFSF_KI_KU_FOLLOWEDBY_S);

	m_view.SetJapaneseFuzzySearchFlags(jpnFuzzySearchFlags);
*/
	CDialog::OnOK();

#undef GET_OPTION
}


/* [EOF] */