// FileOperationDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "FileOperationDlg.h"
using Alpha::CFileOperationDlg;
using namespace std;


// CFileOperationDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CFileOperationDlg::CFileOperationDlg(UINT nCommandID,
		const wstring& strFilePath) : m_nCommandID(nCommandID), m_strFilePath(strFilePath) {
}

///	@see	CDialog::OnCommand
bool CFileOperationDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wNotifyCode == EN_CHANGE) {
		::EnableWindow(GetDlgItem(IDOK),
			::GetWindowTextLength(GetDlgItem(IDC_EDIT_FILENAME)) != 0 && ::GetWindowTextLength(GetDlgItem(IDC_EDIT_DESTPATH)) != 0);
		return true;
	} else if(wID == IDC_BTN_BROWSE) {
		wchar_t		wszPath[MAX_PATH];
		LPITEMIDLIST	lpidl = 0;
		BROWSEINFOW		bi = {
			m_hWnd, 0, wszPath, L"fBNgIĂB", BIF_RETURNONLYFSDIRS, 0, 0L, 0
		};
		lpidl = ::SHBrowseForFolderW(&bi);
		if(lpidl != 0) {
			::SHGetPathFromIDList(lpidl, wszPath);
			::SetWindowText(GetDlgItem(IDC_EDIT_DESTPATH), wszPath);
		}
		return true;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFileOperationDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND	hwndFileNameEdit = GetDlgItem(IDC_EDIT_FILENAME);
	HWND	hwndDestPathEdit = GetDlgItem(IDC_EDIT_DESTPATH);
	HWND	hwndBrowseButton = GetDlgItem(IDC_BTN_BROWSE);
	wstring::size_type	i = m_strFilePath.rfind(L'\\');

	::SetWindowText(hwndFileNameEdit, m_strFilePath.substr(i + 1).c_str());
	::SetWindowText(hwndDestPathEdit, m_strFilePath.substr(0, i).c_str());

	switch(m_nCommandID) {
	case CMD_FILE_RENAME:
		::EnableWindow(hwndBrowseButton, false);
		SetWindowText(L"O̕ύX - t@C");
		break;
	case CMD_FILE_COPY:
		SetWindowText(L"Rs[ - t@C");
		break;
	case CMD_FILE_MOVE:
		SetWindowText(L"ړ - t@C");
		break;
	}

	return true;
}

///	@see	CDialog::OnOK
void CFileOperationDlg::OnOK() {
	wchar_t	wszNewName[MAX_PATH];
	wchar_t	wszToPath[MAX_PATH + 1];

	GetDlgItemText(IDC_EDIT_FILENAME, wszNewName, MAX_PATH);
	GetDlgItemText(IDC_EDIT_DESTPATH, wszToPath, MAX_PATH);
	::PathAppend(wszToPath, wszNewName);
	m_strFilePath = wszToPath;

	CDialog::OnOK();
}

/* [EOF] */