// DocumentManager.h
// (c) 2004 exeal

#ifndef _DOCUMENT_MANAGER_H_
#define _DOCUMENT_MANAGER_H_

#include <string>
#include <vector>
#include <stdexcept>
#include "..\Manah\Menu.h"


namespace Alpha {
	class CAlphaEditController;

	///	1ׂ̕C^[tFCX
	interface IDocumentContainer {
		///	fXgN^
		virtual ~IDocumentContainer() {}
		/// IuWFNg̔j
		virtual void DeleteInstance() = 0;
		///	hLgZԂ
		virtual std::wstring GetDescription() const = 0;
		///	hLgt@C̃pXԂBhLgt@CłȂꍇ͋󕶎
		virtual std::wstring GetFilePath() const = 0;
		///	eLXgGfB^IuWFNgԂBeLXgGfB^łȂ0
		virtual CAlphaEditController* GetTextEditor() = 0;
		/// LvV^Cgo[ɕ\ZԂ
		virtual std::wstring GetTitle() const = 0;
		/// hLg̃gbvxEBhẼnhԂ
		virtual HWND GetWindow() const = 0;
		/// EBhEXV
		virtual void RefreshWindow() = 0;
		///	hLgANeBuɂȂƂɌĂяo
		virtual void OnActivate(bool bActive) = 0;
	};

	///	^Cvƃt@C̑Ή
	struct TDocumentType {
		std::wstring	strName;				///< ^Cv
		wchar_t			wszFileSpec[MAX_PATH];	///< ChJ[hB MAX_PATH ȉłȂ΂ȂȂ
		std::wstring	strCommand;				///< [s] ŎsR}hB"$F" ݂̃t@C\
		bool			bPrivate;				///< Kp\XgB
	};
	typedef std::vector<TDocumentType>	DocTypeList;

	/**
	 *	@brief	^Cv̊Ǘ
	 *
 	 *	ɊǗ镶^CvXgɂ̓CfbNXŃANZXB
	 *	0Ԗڂ̕^Cv͍ŏo^Ă镶^CvŁA
	 *	O͋󕶎Agq̃ftHg^CvłB
	 *	̕^Cv RemoveAll gĂ폜Ȃ
	 */
	class CDocumentTypeManager {
		// RXgN^
	public:
		CDocumentTypeManager();

		// \bh
	public:
		void					Add(const TDocumentType& type) throw(std::invalid_argument);
		std::size_t				Find(const std::wstring& strName) const;
		const TDocumentType&	GetAt(std::size_t iType) const throw(std::out_of_range);
		const TDocumentType&	GetByFileName(const std::wstring& strFileName) const;
		std::size_t				GetCount() const;
		void					RemoveAll();

		// f[^o
	private:
		std::vector<TDocumentType>	m_documentTypes;
	};

	///	CDocumentManager ̃CxgXi
	interface IDocumentManagerEventListener {
		virtual ~IDocumentManagerEventListener() {}
		virtual void	OnActivatDocumentChanged() = 0;
	};

	/**
	 *	@brief	Xg̊ǗBobt@o[ɎgACR񋟂
	 *
	 *	<h3>To implementor:</h3>
	 *	uANeBuȕṽZ}eBNX͈ȉ̂悤ɒ߂
	 *	<ul>
	 *		<li>ANeBuȕ̓CfNXŎQƂ</li>
	 *		<li>XĝƂAANeBuȕ͖BΉCfNX-1</li>
	 *		<li>XgłȂƂAANeBuȕK݂</li>
	 *		<li>ANeBuȕXg폜ꂽƂAIɕʂ̕ANeBuɂȂBɂȂꍇ-1</li>
	 *	</ul>
	 */
	class CDocumentManager {
		// RXgN^
	public:
		CDocumentManager();
		~CDocumentManager();

		// \bh
	public:
		void									AddDocument(IDocumentContainer& document);
		IDocumentContainer*						GetActiveDocument() const;
		std::size_t								GetActiveDocumentIndex() const;
		std::size_t								GetCount() const;
		IDocumentContainer*						GetDocument(std::size_t iDocument) const throw(std::out_of_range);
		HIMAGELIST								GetImageList() const;
		const Manah::Windows::Controls::CMenu&	GetBufferListMenu() const;
		void									MoveDocument(std::size_t iDocument, std::size_t iInsertion) throw(std::out_of_range);
		void									RemoveDocument(std::size_t iDocument) throw(std::out_of_range);
		void									SetActiveDocument(std::size_t iDocument) throw(std::out_of_range);
		void									SetEventListener(IDocumentManagerEventListener* pEventListener);
		void									UpdateList();
	private:
		void	_AssertValid() const;
		void	_ResetResources();

		// f[^o
	private:
		std::vector<IDocumentContainer*>	m_documents;
		std::size_t							m_iActiveDocument;
		std::size_t							m_iLastActiveDocument;
		IDocumentManagerEventListener*		m_pEventListener;
		HIMAGELIST							m_hImageList;
		Manah::Windows::Controls::CMenu		m_bufferListMenu;
	};

	inline void CDocumentManager::_AssertValid() const {
#ifndef NDEBUG
		assert(this != 0);
		assert((m_documents.empty() && m_iActiveDocument == -1)
			|| (!m_documents.empty() && m_iActiveDocument != -1));
#endif /* !NDEBUG */
	}

	///	ANeBuȃhLgԂ (hLg1ꍇ null)
	inline IDocumentContainer* CDocumentManager::GetActiveDocument() const {
		_AssertValid();
		return (m_iActiveDocument != -1) ? m_documents[m_iActiveDocument] : 0;
	}

	///	ANeBuȃhLg̔ԍԂ (hLg1ꍇ -1)
	inline size_t CDocumentManager::GetActiveDocumentIndex() const {
		_AssertValid();
		return m_iActiveDocument;
	}

	///	obt@Xg̃j[Ԃ
	inline const Manah::Windows::Controls::CMenu& CDocumentManager::GetBufferListMenu() const {
		_AssertValid();
		return m_bufferListMenu;
	}

	///	hLg̐Ԃ
	inline std::size_t CDocumentManager::GetCount() const {
		_AssertValid();
		return m_documents.size();
	}

	///	wʒũhLgԂ (hLg1ꍇ null)
	inline IDocumentContainer* CDocumentManager::GetDocument(std::size_t iDocument) const throw(std::out_of_range) {
		_AssertValid();
		if(iDocument >= m_documents.size())
			throw std::out_of_range("Specified index is out of range.");
		return m_documents[iDocument];
	}

	///	C[WXgԂBԂꂽC[WXgjҏWĂ͂ȂȂ
	inline HIMAGELIST CDocumentManager::GetImageList() const {
		_AssertValid();
		return m_hImageList;
	}

	///	CxgXi̐ݒ
	inline void CDocumentManager::SetEventListener(IDocumentManagerEventListener* pEventListener) {
		_AssertValid();
		m_pEventListener = pEventListener;
	}

	///	Xg̓eωƂ𕶏}l[Wɒʒm
	inline void CDocumentManager::UpdateList() {
		_AssertValid();
		_ResetResources();
	}

} // namespace Alpha

#endif /* _DOCUMENT_MANAGER_H_ */

/* [EOF] */